/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.FKOnUniqueKeyColumnsTest;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class FKOnUniqKeyDUnit
extends DistributedSQLTestBase {
    public FKOnUniqKeyDUnit(String name) {
        super(name);
    }

    public void testFKOnUniqueColumnsWhichIsInGlobalIndex() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        for (int i = 0; i < 4; ++i) {
            block3: {
                System.out.println("testFKOnUniqueColumnsWhichIsInGlobalIndex " + i);
                String baseTableType = FKOnUniqueKeyColumnsTest.getBaseType(i);
                String referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c2 int not null unique) " + baseTableType);
                s.execute("insert into base values(1, 2), (12, 11), (22, 21), (31, 32)");
                s.execute("create table referbase(rc1 int not null, rc2 int not null,foreign key (rc2) references base(c2))" + referbaseTableType);
                s.execute("insert into referbase values (1, 11), (2, 21)");
                try {
                    s.execute("insert into referbase values (1, 8)");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block3;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
    }

    public void testFKOnUniqueColumnsWhichIsInLocalIndex() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        for (int i = 0; i < 2; ++i) {
            block3: {
                System.out.println("testFKOnUniqueColumnsWhichIsInLocalIndex " + i);
                String referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c2 int not null unique) partition by column(c2)");
                s.execute("insert into base values(1, 2), (12, 11), (22, 21), (31, 32)");
                s.execute("create table referbase(rc1 int not null, rc2 int not null,foreign key (rc2) references base(c2))" + referbaseTableType);
                s.execute("insert into referbase values (1, 11), (2, 21)");
                try {
                    s.execute("insert into referbase values (1, 8)");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block3;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
    }

    public void testFKOnUniqueColumnsWhichIsInGlobalIndex_compositeKey() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        for (int i = 0; i < 4; ++i) {
            block3: {
                System.out.println("testFKOnUniqueColumnsWhichIsInGlobalIndex_compositeKey " + i);
                String baseTableType = FKOnUniqueKeyColumnsTest.getBaseType(i);
                String referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c2 int not null, c3 int not null,  unique(c2, c3)) " + baseTableType);
                s.execute("insert into base values(1, 2, 2), (11, 12, 12), (21, 22, 22), (31, 32, 32)");
                s.execute("create table referbase(rc1 int not null, rc2 int not null,rc3 int not null, foreign key (rc2, rc3) references base(c2, c3)) " + referbaseTableType);
                s.execute("insert into referbase values (1, 2, 2), (2, 22, 22)");
                try {
                    s.execute("insert into referbase values (1, 8, 4)");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block3;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
    }

    public void testFKOnUniqueColumnsWhichIsInLocalIndex_compositeKey() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        for (int i = 0; i < 2; ++i) {
            block3: {
                System.out.println("testFKOnUniqueColumnsWhichIsInLocalIndex_compositeKey " + i);
                String referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c2 int not null, c3 int not null, unique(c2, c3)) partition by column(c2, c3)");
                s.execute("insert into base values(1, 2, 3), (11, 12, 13), (21, 22, 23), (31, 32, 33)");
                s.execute("create table referbase(rc1 int not null, rc2 int not null, rc3 int not null, foreign key (rc2, rc3) references base(c2, c3))" + referbaseTableType);
                s.execute("insert into referbase values (1, 12, 13), (2, 22, 23)");
                try {
                    s.execute("insert into referbase values (1, 8, 10)");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block3;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
    }

    public void testFKOnUniqueColumnsWhichIsInGlobalIndex_compositeKey_MixType() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        for (int i = 0; i < 4; ++i) {
            block3: {
                System.out.println("testFKOnUniqueColumnsWhichIsInGlobalIndex_compositeKey_MixType " + i);
                String baseTableType = FKOnUniqueKeyColumnsTest.getBaseType(i);
                String referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c2 int not null, c3 varchar(20) not null,  unique(c2, c3)) " + baseTableType);
                s.execute("insert into base values(1, 2, 'name1'), (11, 12, 'name2'), (21, 22, 'name3'), (31, 32, 'name4')");
                s.execute("create table referbase(rc1 int not null, rc2 int not null,rc3 varchar(20) not null, foreign key (rc2, rc3) references base(c2, c3))" + referbaseTableType);
                s.execute("insert into referbase values (1, 2, 'name1'), (2, 22, 'name3')");
                try {
                    s.execute("insert into referbase values (1, 2, 'myname')");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block3;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
    }

    public void testFKOnUniqueColumnsWhichIsInLocalIndex_compositeKey_MixType() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        for (int i = 0; i < 2; ++i) {
            block3: {
                System.out.println("testFKOnUniqueColumnsWhichIsInLocalIndex_compositeKey_MixType " + i);
                String referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c2 int not null, c3 varchar(20) not null,  unique(c2, c3)) partition by column(c2, c3)");
                s.execute("insert into base values(1, 2, 'name1'), (11, 12, 'name2'), (21, 22, 'name3'), (31, 32, 'name4')");
                s.execute("create table referbase(rc1 int not null, rc2 int not null, rc3 varchar(20) not null, foreign key (rc2, rc3) references base(c2, c3))" + referbaseTableType);
                s.execute("insert into referbase values (1, 2, 'name1'), (4, 22, 'name3')");
                try {
                    s.execute("insert into referbase values (1, 2, 'myname')");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block3;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
    }

    public void testFKOnUniqueColumnsForSupersetPartitioning() throws Exception {
        String referbaseTableType;
        int i;
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        for (i = 0; i < 2; ++i) {
            block6: {
                System.out.println("testFKOnUniqueColumnsForSupersetPartitioning " + i);
                referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c11 varchar(10), c12 int, c2 int not null, c3 varchar(20) not null, unique (c3, c2)) partition by column(c3)");
                s.execute("insert into base values(1, '1', 1, 2, 'name1'), (11, '11', 1, 12, 'name2'), (21, '21', 21, 22, 'name3'), (31, '31', 31, 32, 'name4')");
                s.execute("create table referbase(rc1 int not null, rc2 varchar(20) not null, rc3 int not null, foreign key (rc2, rc3) references base(c3, c2))" + referbaseTableType);
                s.execute("insert into referbase (rc1, rc2, rc3) values (1, 'name1', 2), (4, 'name3', 22)");
                try {
                    s.execute("insert into referbase (rc1, rc2, rc3) values (1, 'myname', 2)");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block6;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
        for (i = 0; i < 2; ++i) {
            block7: {
                System.out.println("testFKOnUniqueColumnsForSupersetPartitioning " + i);
                referbaseTableType = FKOnUniqueKeyColumnsTest.getReferBaseType(i);
                s.execute("create table base(c1 int not null primary key, c11 varchar(10), c12 int, c2 int not null, c3 varchar(20) not null, unique (c2, c3)) partition by column(c3)");
                s.execute("insert into base values(1, '1', 1, 2, 'name1'), (11, '11', 1, 12, 'name2'), (21, '21', 21, 22, 'name3'), (31, '31', 31, 32, 'name4')");
                s.execute("create table referbase(rc1 int not null, rc3 int not null, rc2 varchar(20) not null, foreign key (rc3, rc2) references base(c2, c3))" + referbaseTableType);
                s.execute("insert into referbase (rc1, rc2, rc3) values (1, 'name1', 2), (4, 'name3', 22)");
                try {
                    s.execute("insert into referbase (rc1, rc2, rc3) values (1, 'myname', 2)");
                    FKOnUniqKeyDUnit.fail((String)"above insert violating fk so should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block7;
                    throw ex;
                }
            }
            s.execute("drop table referbase");
            s.execute("drop table base");
        }
    }

    public void testDeleteWhenFKOnUniqueColumns() throws Exception {
        block5: {
            Statement s;
            block4: {
                this.startVMs(1, 3);
                Connection conn = TestUtil.getConnection();
                s = conn.createStatement();
                s.execute("create table base(c1 int not null primary key, c2 int not null, c3 varchar(20) not null,  unique(c2, c3)) partition by column(c2, c3)");
                s.execute("insert into base values(1, 2, 'name1'), (11, 12, 'name2'), (21, 22, 'name3'), (31, 32, 'name4')");
                s.execute("create table referbase_replicate(rc1 int not null, rc2 int not null, rc3 varchar(20) not null, foreign key (rc2, rc3) references base(c2, c3)) replicate");
                s.execute("insert into referbase_replicate values (1, 2, 'name1'), (4, 22, 'name3')");
                try {
                    s.execute("delete from base where c2 = 2");
                    FKOnUniqKeyDUnit.fail((String)"above delete should fail");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block4;
                    throw ex;
                }
            }
            s.execute("create table referbase_partitioned(rc1 int not null, rc2 int not null, rc3 varchar(20) not null, foreign key (rc2, rc3) references base(c2, c3)) partition by column(rc1)");
            s.execute("insert into referbase_partitioned values (1, 2, 'name1'), (4, 22, 'name3')");
            try {
                s.execute("delete from base where c2 = 2");
                FKOnUniqKeyDUnit.fail((String)"above delete should fail");
            }
            catch (SQLException ex) {
                if ("23503".equals(ex.getSQLState())) break block5;
                throw ex;
            }
        }
    }
}

