/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class ExportImportTestDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 1L;
    SerializableRunnable importLockTableObserverSet = new SerializableRunnable("Set importLockTableObserver"){

        public void run() throws CacheException {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ExportImportTestDUnit.this.importLockTableObserver);
        }
    };
    final GemFireXDQueryObserver importLockTableObserver = new GemFireXDQueryObserverAdapter(){

        public void afterLockingTableDuringImport() {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public ExportImportTestDUnit(String name) {
        super(name);
    }

    public void testSimpleExport_PR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 'kingfisher'), (1, 2, 'jet'), (2, 1, 'ai'), (3, 1, 'ial')");
        this.clientSQLExecute(1, "CALL SYSCS_UTIL.EXPORT_TABLE(null, 't1', 'export_PR.flt', null, null, null)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleImport_PR() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,11,Airbus");
            p.println("7363,12,Boeing");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_DATA('APP', 'T1', null, null, 'import_test_data.txt', null, null, null, 1)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table should be 2", (int)2, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiThreadedImportTable_PR() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_table_ex.txt"));
            p.println("1354,11,Airbus");
            p.println("7363,12,Boeing");
            p.println("2562,13,Airbus");
            p.println("6355,14,Boeing");
            p.println("8376,15,Airbus");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_table_ex.txt', null, null, null, 0, 0, 6, 0, null, null)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table should be 5", (int)5, (int)rs.getInt(1));
        }
        finally {
            new File("import_table_ex.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleImportWithImproperDataFile_PR() throws Exception {
        boolean exceptionOccurredDuringImport = false;
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,11");
            p.println("7363,12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_DATA('APP', 'T1', null, null, 'import_test_data.txt', null, null, null, 1)");
        }
        catch (SQLException e) {
            exceptionOccurredDuringImport = true;
        }
        finally {
            new File("import_test_data.txt").delete();
        }
        ExportImportTestDUnit.assertTrue((String)"exception should occur during import", (boolean)exceptionOccurredDuringImport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithSelectiveColumnNamesAsParameters_PR() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,11");
            p.println("7363,12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_DATA('APP', 'T1', 'FLIGHT_ID,SEGMENT_NUMBER', null, 'import_test_data.txt', null, null, null, 1)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table should be 2", (int)2, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithAllColumnNamesAsParameters_PR() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,11,Airbus");
            p.println("7363,12,Boeing");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_DATA('APP', 'T1', 'FLIGHT_ID,SEGMENT_NUMBER,AIRCRAFT', null, 'import_test_data.txt', null, null, null, 1)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table should be 2", (int)2, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithSelectiveColumnNamesInDataFile_PR() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("FLIGHT_ID,SEGMENT_NUMBER");
            p.println("1354,11");
            p.println("7363,12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_DATA('APP', 'T1', null, null, 'import_test_data.txt', null, null, null, 1)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table should be 2", (int)2, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithSelectiveColumnNamesAsParamsAndInDataFile_PR() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("FLIGHT_ID,SEGMENT_NUMBER");
            p.println("1354,11");
            p.println("7363,12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_DATA('APP', 'T1', 'FLIGHT_ID,SEGMENT_NUMBER', null, 'import_test_data.txt', null, null, null, 1)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table should be 2", (int)2, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithNoColumnNamesSpecified_PR() throws Exception {
        boolean exceptionOccurredDuringImport = false;
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null, segment_number int not null, aircraft varchar(20), CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,11");
            p.println("7363,12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_DATA('APP', 'T1', null, null, 'import_test_data.txt', null, null, null, 1)");
        }
        catch (SQLException e) {
            exceptionOccurredDuringImport = true;
        }
        finally {
            new File("import_test_data.txt").delete();
        }
        ExportImportTestDUnit.assertTrue((String)"exception should occur during import", (boolean)exceptionOccurredDuringImport);
    }

    public void testSimpleExport_REPLICATE() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER)) replicate");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 'kingfisher'), (1, 2, 'jet'), (2, 1, 'ai'), (3, 1, 'ial')");
        this.clientSQLExecute(1, "CALL SYSCS_UTIL.EXPORT_TABLE(null, 't1', 'export_REPLICATE.flt', null, null, null)");
    }

    public void testSimpleExport_joinQuery_PR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID))");
        this.clientSQLExecute(1, "create table t2(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_FK foreign KEY (FLIGHT_ID) references t1(flight_id))");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 'kingfisher'), (2, 2, 'jet'), (3, 1, 'ai'), (4, 1, 'ial')");
        this.clientSQLExecute(1, "insert into t2 values (1, 1, 'kingfisher_dep'), (2, 2, 'jet_dep'), (3, 1, 'ai_dep'), (4, 1, 'ial_dep')");
        this.clientSQLExecute(1, "CALL SYSCS_UTIL.EXPORT_QUERY('select * from t1, t2 where t1.flight_id = t2.flight_id', 'export_joinQuery_pr.flt', null, null, null)");
    }

    public void testSimpleExport_joinQuery_REPLICATE() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID)) replicate");
        this.clientSQLExecute(1, "create table t2(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_FK foreign KEY (FLIGHT_ID) references t1(flight_id)) replicate");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 'kingfisher'), (2, 2, 'jet'), (3, 1, 'ai'), (4, 1, 'ial')");
        this.clientSQLExecute(1, "insert into t2 values (1, 1, 'kingfisher_dep'), (2, 2, 'jet_dep'), (3, 1, 'ai_dep'), (4, 1, 'ial_dep')");
        this.clientSQLExecute(1, "CALL SYSCS_UTIL.EXPORT_QUERY('select * from t1, t2 where t1.flight_id = t2.flight_id', 'export_joinQuery_replicate.flt', null, null, null)");
    }

    public void testSimpleExport_non_colocatedjoinQuery_PR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID))");
        this.clientSQLExecute(1, "create table t2(flight_id int not null, segment_number int not null, aircraft varchar(20) not null)");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 'kingfisher'), (2, 2, 'jet'), (3, 1, 'ai'), (4, 1, 'ial')");
        this.clientSQLExecute(1, "insert into t2 values (1, 1, 'kingfisher_dep'), (2, 2, 'jet_dep'), (3, 1, 'ai_dep'), (4, 1, 'ial_dep')");
        try {
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.EXPORT_QUERY('select * from t1, t2 where t1.flight_id = t2.flight_id', 'export_noncolojoinQuery_pr.flt', null, null, null)");
            ExportImportTestDUnit.fail((String)"should have  thrown exception");
        }
        catch (SQLException sqle) {
            return;
        }
        ExportImportTestDUnit.fail((String)"should have got the exception");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportTable_PR_bug51375() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,\" \"\"Airbus\"\"\", 11");
            p.println("1355,\"\"\"Boeing\"\"\", 12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 0, 1, 0, null, null)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("select aircraft, flight_id from app.t1");
            ResultSet rs = st.getResultSet();
            int count = 0;
            while (rs.next()) {
                ++count;
                int flight_id = rs.getInt(2);
                if (flight_id == 1354) {
                    ExportImportTestDUnit.assertEquals((String)"value of column aircraft is incorrect: ", (String)" \"Airbus\"", (String)rs.getString(1));
                    continue;
                }
                if (flight_id != 1355) continue;
                ExportImportTestDUnit.assertEquals((String)"value of column aircraft is incorrect: ", (String)"\"Boeing\"", (String)rs.getString(1));
            }
            ExportImportTestDUnit.assertTrue((String)"Number of rows in table is incorrect: ", (count == 2 ? 1 : 0) != 0);
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportTable_PR_bug51274() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,Airbus, 11");
            p.println("1355,Boeing, 12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 1, 1, 0, null, null)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("insert into APP.T1 values (1356, 'Airbus', 13)");
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table is incorrect", (int)3, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportTableWithLockObserver_PR_bug51274() throws Exception {
        try {
            Properties props = new Properties();
            props.setProperty(GfxdConstants.MAX_LOCKWAIT, "10000");
            this.startVMs(1, 3, 0, null, props);
            this.serverExecute(1, (Runnable)this.importLockTableObserverSet);
            this.serverExecute(2, (Runnable)this.importLockTableObserverSet);
            this.serverExecute(3, (Runnable)this.importLockTableObserverSet);
            this.clientExecute(1, (Runnable)this.importLockTableObserverSet);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,Airbus, 11");
            p.println("1355,Boeing, 12");
            p.close();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExportImportTestDUnit.this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 1, 1, 0, null, null)");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            Thread.sleep(5000L);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            boolean lockTimeoutExceptionOccurred = false;
            try {
                st.execute("insert into APP.T1 values (1356, 'Airbus', 13)");
            }
            catch (SQLException e) {
                if (!"40XL1".equals(e.getSQLState())) {
                    throw e;
                }
                lockTimeoutExceptionOccurred = true;
            }
            ExportImportTestDUnit.assertTrue((boolean)lockTimeoutExceptionOccurred);
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportTableInvalidDataInFile_PR_bug51274() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,abababababababababAirbus,11");
            p.println("1355,Boeing,12");
            p.close();
            boolean exceptionOccurredDuringImport = false;
            try {
                this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 1, 1, 0, null, null)");
            }
            catch (Exception e) {
                exceptionOccurredDuringImport = true;
            }
            ExportImportTestDUnit.assertTrue((String)"Exception should have occurred during import table", (boolean)exceptionOccurredDuringImport);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("insert into APP.T1 values (1356, 'Airbus', 13)");
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table is incorrect", (int)1, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportTableWithTwoThreads_PR_bug51274() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,Airbus, 11");
            p.println("1355,Boeing, 12");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 1, 2, 0, null, null)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("insert into APP.T1 values (1356, 'Airbus', 13)");
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table is incorrect", (int)3, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiThreadedImportTableInvalidDataInFile_PR_bug51274() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,Airbus, 11");
            p.println("1355,Boeingdjffhsfhhababababab, 12");
            p.close();
            boolean exceptionOccurredDuringImport = false;
            try {
                this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 1, 3, 0, null, null)");
            }
            catch (Exception e) {
                exceptionOccurredDuringImport = true;
            }
            ExportImportTestDUnit.assertTrue((String)"Exception should have occurred during import table", (boolean)exceptionOccurredDuringImport);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("insert into APP.T1 values (1356, 'Airbus', 13)");
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table is incorrect", (int)2, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportTableWithMoreThanTwoThreads_PR_bug51274() throws Exception {
        try {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,Airbus, 11");
            p.println("1355,Boeing, 12");
            p.println("1356,Airbus, 13");
            p.println("1357,Airbus, 14");
            p.println("1358,Boeing, 15");
            p.println("1359,Boeing, 16");
            p.println("1360,Airbus, 17");
            p.println("1361,Boeing, 18");
            p.println("1362,Airbus, 19");
            p.println("1363,Boeing, 20");
            p.close();
            this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 1, 6, 0, null, null)");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("insert into APP.T1 values (1364, 'Airbus', 21)");
            st.execute("select count(*) from app.t1");
            ResultSet rs = st.getResultSet();
            ExportImportTestDUnit.assertTrue((boolean)rs.next());
            ExportImportTestDUnit.assertEquals((String)"Number of rows in table is incorrect", (int)11, (int)rs.getInt(1));
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultithreadedImportTableWithLockObserver_PR_bug51274() throws Exception {
        try {
            Properties props = new Properties();
            props.setProperty(GfxdConstants.MAX_LOCKWAIT, "10000");
            this.startVMs(1, 3, 0, null, props);
            this.serverExecute(1, (Runnable)this.importLockTableObserverSet);
            this.serverExecute(2, (Runnable)this.importLockTableObserverSet);
            this.serverExecute(3, (Runnable)this.importLockTableObserverSet);
            this.clientExecute(1, (Runnable)this.importLockTableObserverSet);
            this.clientSQLExecute(1, "create table app.t1(flight_id int not null primary key, aircraft varchar(20),segment_number int not null ) ");
            PrintWriter p = new PrintWriter(new File("import_test_data.txt"));
            p.println("1354,Airbus, 11");
            p.println("1355,Boeing, 12");
            p.println("1356,Airbus, 13");
            p.println("1357,Airbus, 14");
            p.println("1358,Boeing, 15");
            p.println("1359,Boeing, 16");
            p.println("1360,Airbus, 17");
            p.println("1361,Boeing, 18");
            p.close();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExportImportTestDUnit.this.clientSQLExecute(1, "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T1', 'import_test_data.txt', null, null, null, 1, 1, 6, 0, null, null)");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            Thread.sleep(5000L);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            boolean lockTimeoutExceptionOccurred = false;
            try {
                st.execute("insert into APP.T1 values (1356, 'Airbus', 13)");
            }
            catch (SQLException e) {
                if (!"40XL1".equals(e.getSQLState())) {
                    throw e;
                }
                lockTimeoutExceptionOccurred = true;
            }
            ExportImportTestDUnit.assertTrue((boolean)lockTimeoutExceptionOccurred);
        }
        finally {
            new File("import_test_data.txt").delete();
        }
    }
}

