/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gnu.trove.TIntHashSet;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ExpirationDUnit
extends DistributedSQLTestBase {
    public ExpirationDUnit(String name) {
        super(name);
    }

    private void checkExpiration(Statement st1) throws Exception {
        st1.execute("truncate table t1");
        st1.execute("insert into t1 values (1, 1, 1)");
        Thread.sleep(14000L);
        st1.execute("select col1 from t1");
        ResultSet rs1 = st1.getResultSet();
        ExpirationDUnit.assertFalse((boolean)rs1.next());
        rs1.close();
    }

    private void checkNonPKBasedSelect(Statement st1) throws Exception {
        st1.execute("truncate table t1");
        st1.execute("insert into t1 values (1, 1, 1)");
        Thread.sleep(6000L);
        st1.execute("select col1 from t1");
        ResultSet rs1 = st1.getResultSet();
        ExpirationDUnit.assertTrue((boolean)rs1.next());
        Thread.sleep(6000L);
        st1.execute("select col1 from t1");
        rs1 = st1.getResultSet();
        ExpirationDUnit.assertFalse((boolean)rs1.next());
    }

    private void checkPKBasedSelect(Statement st1) throws Exception {
        st1.execute("truncate table t1");
        st1.execute("insert into t1 values (1, 1, 1)");
        Thread.sleep(5000L);
        st1.execute("select col1 from t1 where col1 = 1");
        ResultSet rs1 = st1.getResultSet();
        ExpirationDUnit.assertTrue((boolean)rs1.next());
        ExpirationDUnit.assertEquals((int)1, (int)rs1.getInt(1));
        Thread.sleep(6000L);
        st1.execute("select col1 from t1 where col1 = 1");
        rs1 = st1.getResultSet();
        ExpirationDUnit.assertTrue((boolean)rs1.next());
        ExpirationDUnit.assertEquals((int)1, (int)rs1.getInt(1));
        ExpirationDUnit.assertFalse((boolean)rs1.next());
    }

    private void checkNonPKBasedUpdate(Statement st1) throws Exception {
        st1.execute("truncate table t1");
        st1.execute("insert into t1 values (1, 1, 1)");
        Thread.sleep(5000L);
        st1.execute("update t1 set col2 = 2");
        Thread.sleep(7000L);
        st1.execute("select col1 from t1");
        ResultSet rs1 = st1.getResultSet();
        ExpirationDUnit.assertTrue((boolean)rs1.next());
    }

    private void checkPKBasedUpdate(Statement st1) throws Exception {
        st1.execute("truncate table t1");
        st1.execute("insert into t1 values (1, 1, 1)");
        Thread.sleep(5000L);
        st1.execute("update t1 set col2 = 2 where col1 = 1");
        Thread.sleep(7000L);
        st1.execute("select col1 from t1 where col1 = 1");
        ResultSet rs1 = st1.getResultSet();
        ExpirationDUnit.assertTrue((boolean)rs1.next());
        ExpirationDUnit.assertEquals((int)1, (int)rs1.getInt(1));
        ExpirationDUnit.assertFalse((boolean)rs1.next());
    }

    private void basicEntryExpirationTest(Connection conn, boolean idletime, boolean replicate, boolean persistent, boolean synchronous) throws Exception {
        Statement st1 = conn.createStatement();
        String distributionPolicy = replicate ? "replicate " : "partition by (col1) ";
        String expiryPolicy = idletime ? "idletime " : "timetolive ";
        String createTableStr = "create table t1 (col1 int constraint pk1 primary key, col2 int, col3 int) " + distributionPolicy + "expire entry with " + expiryPolicy + "10 action destroy";
        if (persistent) {
            createTableStr = createTableStr + " persistent";
            createTableStr = synchronous ? createTableStr + " synchronous" : createTableStr + " asynchronous";
        }
        st1.execute(createTableStr);
        this.checkExpiration(st1);
        this.checkNonPKBasedSelect(st1);
        if (!replicate && idletime) {
            this.checkPKBasedSelect(st1);
        }
        this.checkNonPKBasedUpdate(st1);
        this.checkPKBasedUpdate(st1);
        st1.execute("drop table t1");
        st1.close();
    }

    public void testBasicEntryExpiration() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        this.getLogWriter().info((Object)"testing for replicated table idletime policy");
        this.basicEntryExpirationTest(conn, true, true, false, false);
        this.basicEntryExpirationTest(conn, true, true, true, false);
        this.basicEntryExpirationTest(conn, true, true, true, true);
        this.getLogWriter().info((Object)"testing for partitioned table idletime policy");
        this.basicEntryExpirationTest(conn, true, false, false, false);
        this.basicEntryExpirationTest(conn, true, false, true, false);
        this.basicEntryExpirationTest(conn, true, false, true, true);
        this.getLogWriter().info((Object)"testing for replicated table time-to-live policy");
        this.basicEntryExpirationTest(conn, false, true, false, false);
        this.basicEntryExpirationTest(conn, false, true, true, false);
        this.basicEntryExpirationTest(conn, false, true, true, true);
        this.getLogWriter().info((Object)"testing for partitioned table time-to-live policy");
        this.basicEntryExpirationTest(conn, false, false, false, false);
        this.basicEntryExpirationTest(conn, false, false, true, false);
        this.basicEntryExpirationTest(conn, false, false, true, true);
    }

    public void testTimeToLive() throws Exception {
        this.startServerVMs(1, 0, null);
        this.startClientVMs(1, 0, null);
        try {
            this.serverSQLExecute(1, "drop diskstore teststore");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSQLExecute(1, "create diskstore teststore");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))REPLICATE PERSISTENT 'teststore' EXPIRE ENTRY WITH TIMETOLIVE 10 ACTION DESTROY ");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_TWO (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY COLUMN (ID) PERSISTENT 'teststore' EXPIRE ENTRY WITH TIMETOLIVE 10 ACTION DESTROY ");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_ONE values (1, 'hello')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_TWO values (1, 'hello')");
        Thread.sleep(5000L);
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_ONE values (2, 'goodbye')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_TWO values (2, 'goodbye')");
        long start = System.currentTimeMillis();
        this.stopVMNum(-1);
        this.restartVMNums(-1);
        TIntHashSet expected = new TIntHashSet();
        expected.add(2);
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed < 6000L) {
            Thread.sleep(6000L - elapsed);
        } else if (elapsed > 10000L) {
            expected = null;
        }
        this.validateResults("EMP.TESTTABLE_ONE", expected);
        this.validateResults("EMP.TESTTABLE_TWO", expected);
        Thread.sleep(5000L);
        this.validateResults("EMP.TESTTABLE_ONE", null);
        this.validateResults("EMP.TESTTABLE_TWO", null);
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE_TWO");
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE_ONE");
        this.serverSQLExecute(1, "drop diskstore teststore");
    }

    public void testAlterCommandTimeToLive() throws Exception {
        this.startServerVMs(1, 0, null);
        this.startClientVMs(1, 0, null);
        try {
            this.serverSQLExecute(1, "drop diskstore teststore");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSQLExecute(1, "create diskstore teststore");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))REPLICATE PERSISTENT 'teststore' EXPIRE ENTRY WITH TIMETOLIVE 10 ACTION DESTROY ");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'hello')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'goodbye')");
        this.clientSQLExecute(1, "ALTER TABLE EMP.TESTTABLE set EXPIRE ENTRY WITH TIMETOLIVE 20 ACTION DESTROY");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'hello1')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (4, 'goodbye1')");
        TIntHashSet expected = new TIntHashSet();
        expected.add(1);
        expected.add(2);
        expected.add(3);
        expected.add(4);
        Thread.sleep(11000L);
        this.validateResults("EMP.TESTTABLE", expected);
        Thread.sleep(10000L);
        this.validateResults("EMP.TESTTABLE", null);
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
        this.serverSQLExecute(1, "drop diskstore teststore");
    }

    public void testIdleTime() throws Exception {
        this.startServerVMs(1, 0, null);
        this.startClientVMs(1, 0, null);
        try {
            this.serverSQLExecute(1, "drop diskstore teststore");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSQLExecute(1, "create diskstore teststore");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))REPLICATE PERSISTENT 'teststore' EXPIRE ENTRY WITH IDLETIME 10 ACTION DESTROY ");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_TWO (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY COLUMN (ID) PERSISTENT 'teststore' EXPIRE ENTRY WITH IDLETIME 10 ACTION DESTROY ");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_ONE values (1, 'hello')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_TWO values (1, 'hello')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_TWO values (3, 'hello')");
        Thread.sleep(5000L);
        long start = System.currentTimeMillis();
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_ONE values (2, 'goodbye')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE_TWO values (2, 'goodbye')");
        this.clientSQLExecute(1, "update EMP.TESTTABLE_TWO set DESCRIPTION = 'hi' where ID = 3");
        this.clientSQLExecute(1, "select * from EMP.TESTTABLE_TWO where ID = 1 ");
        this.stopVMNum(-1);
        this.restartVMNums(-1);
        TIntHashSet expected = new TIntHashSet();
        expected.add(2);
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed < 6000L) {
            Thread.sleep(6000L - elapsed);
        } else if (elapsed > 10000L) {
            expected = null;
        }
        this.validateResults("EMP.TESTTABLE_ONE", expected);
        if (expected != null) {
            expected.add(3);
        }
        this.validateResults("EMP.TESTTABLE_TWO", expected);
        Thread.sleep(5000L);
        this.validateResults("EMP.TESTTABLE_ONE", null);
        this.validateResults("EMP.TESTTABLE_TWO", null);
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE_TWO");
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE_ONE");
        this.serverSQLExecute(1, "drop diskstore teststore");
    }

    protected void validateResults(String tablename, TIntHashSet expected) throws SQLException {
        PreparedStatement pstmt = TestUtil.getPreparedStatement("select * from " + tablename);
        ResultSet rs = pstmt.executeQuery();
        if (expected == null) {
            ExpirationDUnit.assertFalse((boolean)rs.next());
        } else {
            TIntHashSet ids = new TIntHashSet();
            while (rs.next()) {
                ids.add(rs.getInt("ID"));
            }
            ExpirationDUnit.assertEquals((Object)expected, (Object)ids);
        }
    }
}

