/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheFactory;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.EventCallback;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EventCallbackWriter
implements EventCallback {
    private static final int VENDOR_CODE_ARCHIVE_ERROR = 0;
    private static final int VENDOR_CODE_TIMEOUT = 1;
    protected Properties props = new Properties();
    protected String url = "";
    protected String primaryKeys = "";
    protected int minConnections;
    protected int maxConnections;
    protected long connectionTimeout;
    private Integer connectionCount = 0;
    private final LogWriter log = CacheFactory.getAnyInstance().getLogger();
    private final ExecutorService backgroundExecutor = Executors.newCachedThreadPool();
    private final Queue<Connection[]> waitingConnections = new LinkedList<Connection[]>();
    private final Queue<Connection> availableConnections = new LinkedList<Connection>();

    public void close() throws SQLException {
    }

    public void init(String initStr) throws SQLException {
        this.log.entering("EventCallbackWriter", "init()");
        this.loadParametersFromInitString(initStr);
    }

    public void onEvent(Event event) throws SQLException {
        if (event.getType() == Event.Type.BEFORE_UPDATE) {
            if (this.connectionCount < this.minConnections) {
                this.initConnection();
            }
            String query = this.buildUpdateQuery(event);
            PreparedStatement pstmt = this.getPreparedStatement(query);
            this.executePreparedStatement(pstmt);
            this.log.info("Complete updating a row in the backend database.");
        } else if (event.getType() == Event.Type.BEFORE_INSERT) {
            if (this.connectionCount < this.minConnections) {
                this.initConnection();
            }
            String query = this.buildInsertQuery(event);
            PreparedStatement pstmt = this.getPreparedStatement(query);
            this.executePreparedStatement(pstmt);
            this.log.info("Complete inserting a row in the backend database.");
        } else if (event.getType() == Event.Type.BEFORE_DELETE) {
            if (this.connectionCount < this.minConnections) {
                this.initConnection();
            }
            String query = this.buildDeleteQuery(event);
            PreparedStatement pstmt = this.getPreparedStatement(query);
            this.executePreparedStatement(pstmt);
            this.log.info("Complete deleting a row in the backend database.");
        }
    }

    private String maskString(String str) {
        if (str != null) {
            char[] masked = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                masked[i] = 120;
            }
            return String.copyValueOf(masked);
        }
        return "";
    }

    private void logInitParameters() {
        if (this.log.infoEnabled()) {
            this.log.info("EventCallbackWriter initialized.");
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                if ("password".equals(entry.getKey())) {
                    this.log.info("   " + entry.getKey() + ": " + this.maskString((String)entry.getValue()));
                    continue;
                }
                this.log.info("   " + entry.getKey() + ": " + entry.getValue());
            }
        }
    }

    private void parsePropertiesFromString(String initStr) {
        if (initStr.length() > 1) {
            String[] params;
            String delimiter = initStr.substring(0, 1);
            for (String parameter : params = initStr.substring(1).split("\\" + delimiter)) {
                int equalsIndex = parameter.indexOf(61);
                if (!(equalsIndex > 0 & parameter.length() > equalsIndex + 1)) continue;
                String key = parameter.substring(0, equalsIndex).trim();
                String value = parameter.substring(equalsIndex + 1).trim();
                this.props.put(key, value);
            }
        }
    }

    private String getProperty(String key, String defaultValue) {
        Object value = this.props.remove(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    private void loadParametersFromInitString(String initStr) {
        this.parsePropertiesFromString(initStr);
        this.logInitParameters();
        this.url = this.getProperty("url", "");
        this.primaryKeys = this.getProperty("primary-keys", "");
        this.minConnections = Integer.parseInt(this.getProperty("min-connections", "1"));
        this.maxConnections = Integer.parseInt(this.getProperty("max-connections", "1"));
        this.connectionTimeout = Long.parseLong(this.getProperty("connection-timeout", "3000"));
    }

    private Connection getDatabaseConnection() throws SQLException {
        return TestUtil.getConnection();
    }

    private String buildUpdateQuery(Event event) throws SQLException {
        TableMetaData meta = event.getResultSetMetaData();
        int[] modifiedCols = event.getModifiedColumns();
        List newRow = event.getNewRow();
        StringBuilder query = new StringBuilder();
        if (event.getModifiedColumns() == null) {
            throw new SQLException("Nothing is updated.");
        }
        query.append("UPDATE " + meta.getSchemaName(1) + "." + meta.getTableName(1) + "_ONE");
        query.append(" SET ");
        block3: for (int i = 0; i < modifiedCols.length; ++i) {
            query.append(meta.getColumnName(modifiedCols[i]) + "=");
            int type = meta.getColumnType(modifiedCols[i]);
            Object value = newRow.get(modifiedCols[i] - 1);
            switch (type) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 93: {
                    query.append(value + ",");
                    continue block3;
                }
                default: {
                    query.append("'" + value + "',");
                }
            }
        }
        query.delete(query.length() - 1, query.length());
        Object[] pkValue = event.getPrimaryKey();
        String[] keys = this.primaryKeys.split(",");
        if (keys.length > 0) {
            query.append(" WHERE ");
            for (int i = 0; i < keys.length; ++i) {
                String keyName = keys[i];
                query.append(keyName).append("=");
                if (pkValue[i] instanceof String) {
                    query.append("'" + pkValue[i] + "'");
                } else {
                    query.append(pkValue[i]);
                }
                if (i >= keys.length - 1) continue;
                query.append(" AND ");
            }
        }
        return query.toString();
    }

    private String buildInsertQuery(Event event) throws SQLException {
        TableMetaData meta = event.getResultSetMetaData();
        List newRow = event.getNewRow();
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO " + meta.getSchemaName(1) + "." + meta.getTableName(1) + "_ONE VALUES (");
        block3: for (int i = 1; i <= meta.getColumnCount(); ++i) {
            int type = meta.getColumnType(i);
            Object value = newRow.get(i - 1);
            switch (type) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 93: {
                    query.append(value + ",");
                    continue block3;
                }
                default: {
                    query.append("'" + value + "',");
                }
            }
        }
        query.delete(query.length() - 1, query.length());
        query.append(");");
        return query.toString();
    }

    private String buildDeleteQuery(Event event) throws SQLException {
        TableMetaData meta = event.getResultSetMetaData();
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM " + meta.getSchemaName(1) + "." + meta.getTableName(1) + "_ONE");
        Object[] pkValue = event.getPrimaryKey();
        String[] keys = this.primaryKeys.split(",");
        if (keys.length > 0) {
            query.append(" WHERE ");
            for (int i = 0; i < keys.length; ++i) {
                String keyName = keys[i];
                query.append(keyName).append("=");
                if (pkValue[i] instanceof String) {
                    query.append("'" + pkValue[i] + "'");
                } else {
                    query.append(pkValue[i]);
                }
                if (i >= keys.length - 1) continue;
                query.append(" AND ");
            }
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection() {
        for (int i = 0; i < this.minConnections; ++i) {
            Integer n = this.connectionCount;
            synchronized (n) {
                this.connectionCount = this.connectionCount + 1;
            }
            ConnectionCreator creator = new ConnectionCreator();
            this.backgroundExecutor.execute(creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedStatement(String query) throws SQLException {
        Connection[] holder;
        Connection[] connectionArray = holder = new Connection[1];
        synchronized (holder) {
            this.getPooledConnection(holder);
            if (holder[0] == null) {
                try {
                    holder.wait(this.connectionTimeout);
                }
                catch (InterruptedException e) {
                    this.log.warning("JDBCRowLoader interrupted while waiting for an available pooled statement.");
                    this.log.warning((Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (holder[0] == null) {
                throw new SQLException("Timeout waiting for pooled connection to archive database", "08001", 1);
            }
            PreparedStatement pstmt = holder[0].prepareStatement(query);
            return pstmt;
        }
    }

    private void executePreparedStatement(PreparedStatement pstmt) throws SQLException {
        try {
            this.log.info("Executing query " + pstmt.toString());
            pstmt.executeUpdate();
            this.log.info("Query succeeded");
            Connection con = pstmt.getConnection();
            this.recyclePooledConnection(con);
        }
        catch (SQLException e) {
            Connection con = pstmt.getConnection();
            this.releasePooledConnection(con);
            this.logGetRowError(e);
            throw new SQLException("Error executing query from archive database", e.getSQLState(), 0, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getPooledConnection(Connection[] holder) {
        holder[0] = this.availableConnections.poll();
        if (holder[0] == null) {
            this.waitingConnections.add(holder);
            Integer n = this.connectionCount;
            synchronized (n) {
                if (this.connectionCount < this.maxConnections) {
                    this.connectionCount = this.connectionCount + 1;
                    ConnectionCreator creator = new ConnectionCreator();
                    this.backgroundExecutor.execute(creator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void returnPooledConnection(Connection con) {
        Connection[] holder = this.waitingConnections.poll();
        if (holder == null) {
            this.availableConnections.offer(con);
            return;
        }
        Connection[] connectionArray = holder;
        synchronized (holder) {
            holder[0] = con;
            holder.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void recyclePooledConnection(Connection con) {
        ConnectionRecycler recycler = new ConnectionRecycler(con);
        this.backgroundExecutor.execute(recycler);
    }

    private void releasePooledConnection(Connection con) {
        ConnectionReleaser releaser = new ConnectionReleaser(con);
        this.backgroundExecutor.execute(releaser);
    }

    private void logGetRowError(SQLException e) {
        this.log.error("Error executing prepared statement in JDBCRowLoader");
        this.log.error((Throwable)e);
    }

    private class ConnectionReleaser
    implements Runnable {
        private Connection con;

        public ConnectionReleaser(Connection con) {
            this.con = con;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Integer n = EventCallbackWriter.this.connectionCount;
                synchronized (n) {
                    EventCallbackWriter.this.connectionCount = EventCallbackWriter.this.connectionCount - 1;
                }
                this.con.close();
            }
            catch (SQLException e) {
                EventCallbackWriter.this.log.warning((Throwable)e);
            }
        }
    }

    private class ConnectionRecycler
    implements Runnable {
        private Connection con;

        public ConnectionRecycler(Connection con) {
            this.con = con;
        }

        @Override
        public void run() {
            try {
                EventCallbackWriter.this.returnPooledConnection(this.con);
            }
            catch (Exception e) {
                EventCallbackWriter.this.releasePooledConnection(this.con);
                EventCallbackWriter.this.log.warning((Throwable)e);
            }
        }
    }

    private class ConnectionCreator
    implements Runnable {
        private ConnectionCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (EventCallbackWriter.this.url.isEmpty()) {
                EventCallbackWriter.this.log.error("Connection url not provided for JDBCRowLoader");
                return;
            }
            try {
                Connection con = EventCallbackWriter.this.getDatabaseConnection();
                EventCallbackWriter.this.log.info(" Successful connection to target database: " + EventCallbackWriter.this.url);
                EventCallbackWriter.this.recyclePooledConnection(con);
            }
            catch (SQLException e) {
                Integer n = EventCallbackWriter.this.connectionCount;
                synchronized (n) {
                    EventCallbackWriter.this.connectionCount = EventCallbackWriter.this.connectionCount - 1;
                }
                EventCallbackWriter.this.log.error("Error connecting to target database");
                EventCallbackWriter.this.log.error((Throwable)e);
            }
        }
    }
}

