/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.ddl.ConcurrencyChecksDUnit;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class DDLAndRestartIssuesDUnit
extends DistributedSQLTestBase {
    public DDLAndRestartIssuesDUnit(String name) {
        super(name);
    }

    public void testNoNewDDLCreationWhenMemberStarting() throws Exception {
        this.getLogWriter().info((Object)"Starting one client and two servers");
        Properties extraProps = new Properties();
        extraProps.setProperty(GfxdConstants.MAX_LOCKWAIT, "60000");
        this.startVMs(1, 2, 0, null, extraProps);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.getLogWriter().info((Object)"Inserting data");
        st.execute("create table APP.T1(id int primary key, name varchar(20), address varchar(50)) persistent replicate");
        st.execute("insert into APP.T1 values(1, 'name1', 'addr1')");
        st.execute("insert into APP.T1 values(2, 'name2', 'addr2')");
        st.execute("insert into APP.T1 values(3, 'name3', 'addr3')");
        st.execute("insert into APP.T1 values(4, 'name4', 'addr4')");
        st.execute("create index APP.IDX1 on APP.T1(name)");
        this.getLogWriter().info((Object)"Stopping second server");
        VM vm = this.getServerVM(2);
        this.stopVMNums(-2);
        st.execute("insert into APP.T1 values(9, 'name9', 'addr9')");
        st.execute("insert into APP.T1 values(10, 'name10', 'addr10')");
        st.execute("create index APP.IDX2 on APP.T1(id)");
        this.getLogWriter().info((Object)"Installing latch on second server");
        vm.invoke((Runnable)new SerializableRunnable(""){

            public void run() throws CacheException {
                DDLAndRestartIssuesDUnit.this.getLogWriter().info((Object)"KN: setting the test latches");
                DistributedRegion.testLatch = new CountDownLatch(1);
                DistributedRegion.testRegionName = "T1";
            }
        });
        this.getLogWriter().info((Object)"Restarting second server async");
        DistributedSQLTestBase.AsyncVM asyncVM = this.restartServerVMAsync(2, 0, null, extraProps);
        this.getLogWriter().info((Object)"Waiting until the test latch point arrives");
        DDLAndRestartIssuesDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                VM serverVM = DDLAndRestartIssuesDUnit.this.getServerVM(2);
                return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaitingGIIComplete"));
            }

            public String description() {
                return "waiting for applyAllSuspects to finish";
            }
        }, (long)180000L, (long)500L, (boolean)true);
        this.getLogWriter().info((Object)"Doing in-flight inserts");
        st.execute("insert into APP.T1 values(5, 'name5', 'addr5')");
        st.execute("insert into APP.T1 values(6, 'name6', 'addr6')");
        st.execute("insert into APP.T1 values(7, 'name7', 'addr7')");
        st.execute("insert into APP.T1 values(8, 'name8', 'addr8')");
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        try {
            st.execute("drop index APP.IDX1");
            DDLAndRestartIssuesDUnit.assertFalse((String)"The ddl should have timed out", (boolean)true);
        }
        catch (SQLException sqle) {
            DDLAndRestartIssuesDUnit.assertTrue((boolean)"40XL1".equalsIgnoreCase(sqle.getSQLState()));
            this.getLogWriter().info((Object)("Got exception: " + sqle.getSQLState()), (Throwable)sqle);
        }
        this.getLogWriter().info((Object)"Releasing the test latch");
        this.getServerVM(2).invoke((Runnable)new SerializableRunnable(""){

            public void run() throws CacheException {
                DistributedRegion.testLatch.countDown();
                DistributedRegion.testLatch = null;
                DistributedRegion.testLatchWaiting = false;
                DistributedRegion.testRegionName = null;
            }
        });
        this.getLogWriter().info((Object)"Waiting for the second server to restart completely");
        this.joinVM(true, asyncVM);
        st.execute("drop index APP.IDX1");
    }
}

