/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CustomEvictionDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 1L;

    public CustomEvictionDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHDFSEviction() throws Exception {
        this.startVMs(1, 3);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        boolean success = false;
        try {
            this.checkDirExistence(homeDir);
            st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "'");
            st.execute("create table app.m1 (col1 int primary key , col2 int, col3 int, constraint uq unique (col2, col3)) REDUNDANCY 1 hdfsstore (myhdfs) eviction by criteria (col2 > 5) EVICT INCOMING");
            st.execute("insert into app.m1 values (1, 2, 3)");
            st.execute("insert into app.m1 values (11, 22, 33)");
            st.execute("update app.m1 set col2=33 where col1=11");
            st.execute("insert into app.m1 values (66, 77, 88)");
            st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col2 = 22 ");
            ResultSet rs = st.getResultSet();
            CustomEvictionDUnit.assertFalse((boolean)rs.next());
            st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col2 = 33 ");
            rs = st.getResultSet();
            CustomEvictionDUnit.assertTrue((boolean)rs.next());
            CustomEvictionDUnit.assertEquals((int)33, (int)rs.getInt(2));
            CustomEvictionDUnit.assertEquals((int)33, (int)rs.getInt(3));
            CustomEvictionDUnit.assertFalse((boolean)rs.next());
            st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col2 = 77 ");
            rs = st.getResultSet();
            CustomEvictionDUnit.assertTrue((boolean)rs.next());
            CustomEvictionDUnit.assertEquals((int)77, (int)rs.getInt(2));
            CustomEvictionDUnit.assertEquals((int)88, (int)rs.getInt(3));
            CustomEvictionDUnit.assertFalse((boolean)rs.next());
            st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
            rs = st.getResultSet();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            CustomEvictionDUnit.assertEquals((int)3, (int)count);
            String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/M1");
            st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
            this.stopAllVMs();
            this.restartVMNums(-1, -2);
            this.restartVMNums(1);
            conn = TestUtil.getConnection();
            st = conn.createStatement();
            st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 11");
            rs = st.getResultSet();
            CustomEvictionDUnit.assertTrue((boolean)rs.next());
            CustomEvictionDUnit.assertEquals((int)33, (int)rs.getInt(2));
            CustomEvictionDUnit.assertEquals((int)33, (int)rs.getInt(3));
            CustomEvictionDUnit.assertFalse((boolean)rs.next());
            st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 66");
            rs = st.getResultSet();
            CustomEvictionDUnit.assertTrue((boolean)rs.next());
            CustomEvictionDUnit.assertEquals((int)77, (int)rs.getInt(2));
            CustomEvictionDUnit.assertEquals((int)88, (int)rs.getInt(3));
            CustomEvictionDUnit.assertFalse((boolean)rs.next());
            st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
            rs = st.getResultSet();
            count = 0;
            while (rs.next()) {
                ++count;
            }
            CustomEvictionDUnit.assertEquals((int)3, (int)count);
            success = true;
        }
        finally {
            if (!success) {
                conn = TestUtil.getConnection();
                st = conn.createStatement();
            }
            st.execute("drop table if exists app.m1");
            st.execute("drop hdfsstore if exists myhdfs");
            CustomEvictionDUnit.delete(homeDirFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHDFSEvictionGlobalIndex() throws Exception {
        this.startVMs(1, 3);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        boolean success = false;
        try {
            this.checkDirExistence(homeDir);
            stmt.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "'");
            stmt.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) persistent hdfsstore (myhdfs) EVICTION BY CRITERIA (qty > 500) EVICT INCOMING");
            stmt.executeUpdate("insert into trade.portfolio values(3, 120, 1592, 1592, 14264.32000000000000000000 ,18)");
            try {
                stmt.executeUpdate("insert into trade.portfolio  values(3, 120, 1374, 1374, 12311.04000000000000000000, 18)");
                CustomEvictionDUnit.fail((String)"failed");
            }
            catch (Exception c) {
                c.printStackTrace();
            }
            stmt.execute("delete from trade.portfolio where cid = 3 and sid = 120 and tid = 18");
            ResultSet rs = stmt.executeQuery("select * from trade.portfolio -- GEMFIREXD-PROPERTIES queryHDFS=true ");
            CustomEvictionDUnit.assertFalse((boolean)rs.next());
            stmt.executeUpdate("insert into trade.portfolio values(3, 120, 1374, 1374, 12311.04000000000000000000, 8)");
            success = true;
        }
        finally {
            if (!success) {
                conn = TestUtil.getConnection();
                stmt = conn.createStatement();
            }
            stmt.execute("drop table if exists trade.portfolio");
            stmt.execute("drop hdfsstore if exists myhdfs");
            CustomEvictionDUnit.delete(homeDirFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHDFSEvictionHA() throws Exception {
        this.startVMs(1, 3);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        boolean success = false;
        try {
            this.checkDirExistence(homeDir);
            stmt.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "'");
            stmt.execute("create table trade.portfolio (cid int primary key, sid int not null) BUCKETS 1 redundancy 2 persistent hdfsstore (myhdfs) EVICTION BY CRITERIA (sid > 500) EVICT INCOMING");
            stmt.executeUpdate("insert into trade.portfolio  values(1, 600)");
            stmt.executeUpdate("update trade.portfolio  set sid=100 where cid=1");
            success = true;
        }
        finally {
            if (!success) {
                conn = TestUtil.getConnection();
                stmt = conn.createStatement();
            }
            stmt.execute("drop table if exists trade.portfolio");
            stmt.execute("drop hdfsstore if exists myhdfs");
            CustomEvictionDUnit.delete(homeDirFile);
        }
    }

    public void testHDFSEvictionHAGlobalIndex() {
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    private void checkDirExistence(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            CustomEvictionDUnit.delete(dir);
        }
    }
}

