/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.ToursDBUtil;
import com.pivotal.gemfirexd.ddl.CreateTableDUnit;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinDiskLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinDiskLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedLocalRowLocationThinDiskLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedLocalRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedLocalRowLocationThinLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedLocalRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.io.File;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class CreateTablePart2DUnit
extends DistributedSQLTestBase {
    private static boolean signalThread = false;

    public CreateTablePart2DUnit(String name) {
        super(name);
    }

    public void testInsertBySelects() throws Exception {
        this.basicInsertBySelects(false);
    }

    public void testInsertBySelectsOffheap() throws Exception {
        this.basicInsertBySelects(true);
    }

    private String getConditionalOffheapSuffix(boolean enableOffheapForTable) {
        if (enableOffheapForTable) {
            return " offheap ";
        }
        return " ";
    }

    private void basicInsertBySelects(boolean enableOffheapForTable) throws Exception {
        Properties extra = null;
        if (enableOffheapForTable) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startClientVMs(2, 0, null, extra);
        this.startServerVMs(3, 0, "SG1", extra);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 )" + this.getConditionalOffheapSuffix(enableOffheapForTable));
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (20, 'Second')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (30, 'Third')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (40, 'Fourth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (60, 'Sixth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (70, 'Seventh')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (75, 'Eighth')");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_TWO (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 )" + this.getConditionalOffheapSuffix(enableOffheapForTable));
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_TWO (select * from EMP.PARTITIONTESTTABLE_ONE)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select * from EMP.PARTITIONTESTTABLE_TWO", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select ID, DESCRIPTION from EMP.PARTITIONTESTTABLE_TWO", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_THREE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 )" + this.getConditionalOffheapSuffix(enableOffheapForTable));
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_THREE (select ID, DESCRIPTION from EMP.PARTITIONTESTTABLE_ONE)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select * from EMP.PARTITIONTESTTABLE_THREE", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select ID, DESCRIPTION from EMP.PARTITIONTESTTABLE_THREE", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
        this.clientSQLExecute(1, "create table EMP.REPLICATETESTTABLE_ONE (ID int not null, DESCRIPTION varchar(1024) not null, primary key (ID)) REPLICATE" + this.getConditionalOffheapSuffix(enableOffheapForTable));
        this.clientSQLExecute(1, "insert into EMP.REPLICATETESTTABLE_ONE (select * from EMP.PARTITIONTESTTABLE_ONE)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select * from EMP.REPLICATETESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select ID, DESCRIPTION from EMP.REPLICATETESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
        this.clientSQLExecute(1, "create table EMP.REPLICATETESTTABLE_TWO (ID int not null, DESCRIPTION varchar(1024) not null, primary key (ID)) REPLICATE" + this.getConditionalOffheapSuffix(enableOffheapForTable));
        this.clientSQLExecute(1, "insert into EMP.REPLICATETESTTABLE_TWO (select ID, DESCRIPTION from EMP.PARTITIONTESTTABLE_ONE)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select * from EMP.REPLICATETESTTABLE_TWO", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select ID, DESCRIPTION from EMP.REPLICATETESTTABLE_TWO", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "insert_as_select", false, false);
    }

    public void testBug42820_ReplicateNPEWhenPopulateThruLoader() throws Exception {
        this.basicBug42820_ReplicateNPEWhenPopulateThruLoader(false);
    }

    public void testBug42820_ReplicateNPEWhenPopulateThruLoaderOffHeap() throws Exception {
        this.basicBug42820_ReplicateNPEWhenPopulateThruLoader(true);
    }

    private void basicBug42820_ReplicateNPEWhenPopulateThruLoader(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        String createTableDDL = "create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  replicate" + this.getConditionalOffheapSuffix(enableOffHeap);
        this.startClientVMs(2, 0, null, extra);
        this.startServerVMs(2, 0, "SG1", extra);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute(createTableDDL);
        GfxdCallbacksTest.addLoader("trade", "buyorders", "com.pivotal.gemfirexd.ddl.TestBuyOrdersLoader", "");
        stmt.execute("select * from trade.buyorders where oid = 1");
        ResultSet rs = stmt.getResultSet();
        CreateTablePart2DUnit.assertFalse((boolean)rs.next());
    }

    public void testBug48284() throws Exception {
        this.reduceLogLevelForTest("config");
        this.testVersionedRegionEntries();
        this.tearDown();
        for (int i = 0; i < 5; ++i) {
            this.setUp();
            this.testVersionedRegionEntries();
            this.tearDown();
        }
    }

    public void testVersionedRegionEntries() throws Exception {
        this.startVMs(1, 4);
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        Statement s = conn.createStatement();
        s.execute("create table APP.T1(id int primary key, name varchar(20)) partition by primary key redundancy 1 ");
        s.execute("insert into APP.T1 values(1, 'name1')");
        s.execute("insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMBucketRowLocationThinRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(id int primary key, name varchar(20)) partition by primary key redundancy 1 persistent synchronous ");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinDiskRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) partition by primary key redundancy 1 eviction by lrucount 1 evictaction overflow ");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMBucketRowLocationThinLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) partition by primary key redundancy 1 eviction by lrucount 1 evictaction overflow persistent synchronous ");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinDiskLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) replicate");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) replicate persistent");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinDiskRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20))  replicate eviction by lrucount 1 evictaction overflow");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20))  replicate eviction by lrucount 1 evictaction overflow  persistent synchronous ");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinDiskLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(id int primary key, name varchar(20)) partition by primary key redundancy 1 enable concurrency checks");
        s.execute("insert into APP.T1 values(1, 'name1')");
        s.execute("insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(id int primary key, name varchar(20)) partition by primary key redundancy 1 persistent synchronous enable concurrency checks");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinDiskRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) partition by primary key redundancy 1 eviction by lrucount 1 evictaction overflow enable concurrency checks");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) partition by primary key redundancy 1 eviction by lrucount 1 evictaction overflow persistent synchronous enable concurrency checks");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinDiskLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) replicate enable concurrency checks");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedLocalRowLocationThinRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20)) replicate persistent enable concurrency checks");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedLocalRowLocationThinDiskRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20))  replicate eviction by lrucount 1 evictaction overflow enable concurrency checks");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedLocalRowLocationThinLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(ID INT PRIMARY KEY, NAME VARCHAR(20))  replicate eviction by lrucount 1 evictaction overflow  persistent synchronous enable concurrency checks");
        this.getServerVM(1).invoke(CreateTableDUnit.class, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedLocalRowLocationThinDiskLRURegionEntryHeap.class});
        s.execute("drop table APP.T1");
    }

    public void testBug45372() throws Exception {
        this.basicBug45372(false);
    }

    public void testBug45372_OffHeap() throws Exception {
        this.basicBug45372(true);
    }

    private void basicBug45372(boolean enableOffHeap) throws Exception {
        Statement stmt;
        block3: {
            Properties extra = null;
            if (enableOffHeap) {
                extra = new Properties();
                extra.put("gemfire.off-heap-memory-size", "500m");
            }
            this.startVMs(1, 3, -1, null, extra);
            Connection conn = TestUtil.jdbcConn;
            stmt = conn.createStatement();
            stmt.execute("create table trade.customers  (cid int not null GENERATED BY DEFAULT AS IDENTITY,tid int not null, primary key (cid))" + this.getConditionalOffheapSuffix(enableOffHeap));
            stmt.execute("alter table trade.customers ALTER cid RESTART WITH 1");
            stmt.execute("insert into trade.customers (tid) values (1)");
            this.stopVMNum(-1);
            this.startVMs(0, 1, -1, null, extra);
            try {
                stmt.execute("insert into trade.customers (tid) values (2)");
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (!(e.getCause() instanceof EntryExistsException)) break block3;
                e.getCause().printStackTrace();
                CreateTablePart2DUnit.fail((String)("Test failed with " + e.getMessage()));
            }
        }
        stmt.execute("drop table trade.customers");
    }

    public void testBug49357() throws Exception {
        Properties props = new Properties();
        props.put("gemfire.off-heap-memory-size", "500m");
        this.startServerVMs(1, 0, null, props);
        this.serverSQLExecute(1, "CREATE TABLE usertable (YCSB_KEY VARCHAR(100) PRIMARY KEY) partition by (YCSB_KEY) redundancy 1 offheap PERSISTENT");
        this.startClientVMs(1, 0, null, null);
    }

    public void test40100() throws Exception {
        this.basic40100(false);
    }

    public void test40100_OffHeap() throws Exception {
        this.basic40100(true);
    }

    private void basic40100(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(1, 1, -1, null, extra);
        this.startServerVMs(1, 0, "SG1", extra);
        Connection conn = TestUtil.jdbcConn;
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid)) replicate" + this.getConditionalOffheapSuffix(enableOffHeap));
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs.setDataPolicy(DataPolicy.REPLICATE);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        expectedAttrs.setEnableOffHeapMemory(enableOffHeap);
        this.serverVerifyRegionProperties(1, "TRADE", "CUSTOMERS", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "TRADE", "CUSTOMERS", (RegionAttributes<?, ?>)expectedAttrs);
        s.execute("insert into trade.customers values (1, 'XXXX1', 1, 'BEAV1', 1)");
        s.close();
        s = conn.createStatement();
        ResultSet rs = s.executeQuery("select * from trade.customers where since=1");
        while (rs.next()) {
            CreateTablePart2DUnit.assertEquals((int)1, (int)rs.getInt(1));
            CreateTablePart2DUnit.assertEquals((String)"XXXX1", (String)rs.getString(2).trim());
            CreateTablePart2DUnit.assertEquals((int)1, (int)rs.getInt(3));
            CreateTablePart2DUnit.assertEquals((String)"BEAV1", (String)rs.getString(4));
            s.close();
            s = conn.createStatement();
            int numUpdate = s.executeUpdate("update trade.customers set since=2 where cid=1");
            CreateTablePart2DUnit.assertEquals((String)"Should update one row", (int)1, (int)numUpdate);
            s.close();
            s = conn.createStatement();
            rs = s.executeQuery("select * from trade.customers where since=1");
            if (!rs.next()) continue;
            this.getLogWriter().info((Object)("XXXX col1 : " + rs.getInt(1) + " #2 : " + rs.getString(2).trim() + " #3 : " + rs.getInt(3) + " #4 " + rs.getString(4) + " #5 : " + rs.getInt(5)));
            throw new AssertionFailedError("Should not return any rows");
        }
    }

    public void test39937() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(1, 0, "SG1");
        this.startServerVMs(2, 0, "SG2");
        this.serverSQLExecute(1, "create diskstore teststore compactionthreshold 100  TimeInterval 20 MaxLogSize 1048576 WriteBufferSize 1024 autocompact true queuesize  1024 ");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))REPLICATE SERVER GROUPS (sg1, sg2) INITSIZE 100 EXPIRE TABLE WITH TIMETOLIVE 100 ACTION DESTROY EXPIRE ENTRY WITH IDLETIME 10 ACTION DESTROY");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_TWO (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))REPLICATE SERVER GROUPS (sg1) EVICTION BY LRUMEMSIZE 1000 EVICTACTION OVERFLOW  ASYNCHRONOUS 'teststore'");
    }

    public void test40494() throws Exception {
        this.basic40494(false);
    }

    public void test40494_OffHeap() throws Exception {
        this.basic40494(true);
    }

    private void basic40494(boolean enableOffHeap) throws Exception {
        block6: {
            block5: {
                Properties extra = null;
                if (enableOffHeap) {
                    extra = new Properties();
                    extra.put("gemfire.off-heap-memory-size", "500m");
                }
                this.startVMs(1, 1, -1, null, extra);
                this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate" + this.getConditionalOffheapSuffix(enableOffHeap));
                this.clientSQLExecute(1, "create index index_sym on trade.securities(symbol)");
                this.clientSQLExecute(1, "drop table trade.securities");
                this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))" + this.getConditionalOffheapSuffix(enableOffHeap));
                this.startVMs(0, 1, -1, null, extra);
                this.stopVMNums(-1);
                this.clientSQLExecute(1, "insert into trade.securities values (1, 'A', 10.0, 'nye', 1)");
                try {
                    this.clientSQLExecute(1, "insert into trade.securities values (2, 'B', 20.0, 'TSE', 2)");
                    CreateTablePart2DUnit.fail((String)"expected a check constraint violation");
                }
                catch (SQLException ex) {
                    if ("23513".equals(ex.getSQLState())) break block5;
                    throw ex;
                }
            }
            try {
                this.clientSQLExecute(1, "insert into trade.securities values (2, 'B', 20.0, 'tse', 2), (3, 'C', 30.0, 'tsee', 3)");
                CreateTablePart2DUnit.fail((String)"expected a check constraint violation");
            }
            catch (SQLException ex) {
                if ("23513".equals(ex.getSQLState())) break block6;
                throw ex;
            }
        }
        this.clientSQLExecute(1, "insert into trade.securities values (3, 'C', 30.0, 'fse', 3), (4, 'D', 25.0, 'lse', 4)");
        this.clientSQLExecute(1, "select * from trade.securities");
    }

    public void test40494_WithOutSchema() throws Exception {
        this.basic40494_WithOutSchema(false);
    }

    public void test40494_WithOutSchema_OffHeap() throws Exception {
        this.basic40494_WithOutSchema(true);
    }

    private void basic40494_WithOutSchema(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(1, 1, -1, null, extra);
        this.clientSQLExecute(1, "create table securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.clientSQLExecute(1, "create index index_sym on securities(symbol)");
        this.clientSQLExecute(1, "drop table securities");
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.startVMs(0, 1, -1, null, extra);
        this.stopVMNums(-1);
        this.clientSQLExecute(1, "insert into trade.securities values (1, 'A', 10.0, 'nye', 1)");
        this.clientSQLExecute(1, "insert into trade.securities values (2, 'B', 20.0, 'tse', 2)");
        this.clientSQLExecute(1, "select * from trade.securities");
    }

    public void test40494_WithCreateSchema() throws Exception {
        this.basic40494_WithCreateSchema(false);
    }

    public void test40494_WithCreateSchema_OffHeap() throws Exception {
        this.basic40494_WithCreateSchema(true);
    }

    private void basic40494_WithCreateSchema(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(1, 1, -1, null, extra);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.clientSQLExecute(1, "create index index_sym on trade.securities(symbol)");
        this.clientSQLExecute(1, "drop table trade.securities");
        this.clientSQLExecute(1, "drop schema trade RESTRICT");
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.startVMs(0, 1, -1, null, extra);
        this.stopVMNums(-1);
        this.clientSQLExecute(1, "insert into trade.securities values (1, 'A', 10.0, 'nye', 1)");
        this.clientSQLExecute(1, "insert into trade.securities values (2, 'B', 20.0, 'tse', 2)");
        this.clientSQLExecute(1, "select * from trade.securities");
    }

    public void test41524() throws Exception {
        this.startVMs(0, 3);
        int netPort = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        this.startNetworkServer(3, null, null);
        String createTablesScripts = TestUtil.getResourcesDir() + "/lib/useCase8/create_colocated_schema.sql";
        String[] loadDataScriptNames = new String[]{"loadCOUNTRIES.sql", "loadCITIES.sql", "loadAIRLINES.sql", "loadFLIGHTS1.sql", "loadFLIGHTS2.sql", "loadFLIGHTAVAILABILITY1.sql", "loadFLIGHTAVAILABILITY2.sql"};
        File qsDir = ToursDBUtil.getQuickstartDir();
        String[] loadDataScripts = new String[loadDataScriptNames.length];
        for (int index = 0; index < loadDataScriptNames.length; ++index) {
            loadDataScripts[index] = new File(qsDir, loadDataScriptNames[index]).toString();
        }
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=q;password=q", null);
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{createTablesScripts}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)false);
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])loadDataScripts, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)false);
        Statement stmt = conn.createStatement();
        HashSet<String> servers = new HashSet<String>();
        ResultSet rs = stmt.executeQuery("select ID from sys.members where hostdata=1");
        while (rs.next()) {
            servers.add(rs.getString("ID"));
        }
        this.checkServers(servers, 3);
        int totalRows = 542;
        for (String server : servers) {
            int numRows = 0;
            rs = stmt.executeQuery("select * from flights where DSID() = '" + server + "'");
            while (rs.next()) {
                ++numRows;
            }
            CreateTablePart2DUnit.assertTrue((String)("expected at least 100 rows on each server but found " + numRows + " on " + server), (numRows > 100 ? 1 : 0) != 0);
            totalRows -= numRows;
        }
        CreateTablePart2DUnit.assertEquals((int)0, (int)totalRows);
    }

    private void checkServers(Set<String> servers, int expectedNumServers) {
        CreateTablePart2DUnit.assertEquals((String)("expected exactly " + expectedNumServers + " servers but got: " + servers), (int)expectedNumServers, (int)servers.size());
        block0: for (int vmNum = 0; vmNum < expectedNumServers; ++vmNum) {
            VM vm = (VM)this.serverVMs.get(vmNum);
            for (Map.Entry memberEntry : this.members.entrySet()) {
                if (vm != memberEntry.getValue()) continue;
                CreateTablePart2DUnit.assertTrue((boolean)servers.contains(((DistributedMember)memberEntry.getKey()).toString()));
                continue block0;
            }
        }
    }

    public void testUseCase8HangStandaloneServer_5965() throws Exception {
        this.reduceLogLevelForTest("config");
        Properties props = new Properties();
        String ksDir = TestUtil.getResourcesDir() + "/lib/useCase8";
        String createTablesScripts = ksDir + "/create_colocated_schema.sql";
        props.setProperty("init-scripts", createTablesScripts);
        props.setProperty("default-recovery-delay", "-1");
        props.setProperty(GfxdConstants.MAX_LOCKWAIT, "120000");
        this.startServerVMs(1, 0, null, props);
        VM firstVM = (VM)this.serverVMs.get(0);
        String[] loadDataScriptNames = new String[]{"loadCOUNTRIES.sql", "loadCITIES.sql", "loadAIRLINES.sql", "loadFLIGHTS1.sql", "loadFLIGHTS2.sql", "loadFLIGHTAVAILABILITY1.sql", "loadFLIGHTAVAILABILITY2.sql"};
        File qsDir = ToursDBUtil.getQuickstartDir();
        final String[] loadDataScripts = new String[loadDataScriptNames.length];
        for (int index = 0; index < loadDataScriptNames.length; ++index) {
            String loadScriptName = loadDataScriptNames[index];
            loadDataScripts[index] = loadScriptName.startsWith("loadFLIGHTS") ? new File(ksDir, loadScriptName).toString() : new File(qsDir, loadScriptName).toString();
        }
        final SerializableRunnable fireQuery = new SerializableRunnable("fire query to check proper data in region"){

            public void run() throws CacheException {
                Connection conn = TestUtil.jdbcConn;
                try {
                    ResultSet rs = conn.createStatement().executeQuery("select * from flights");
                    int numResults = 0;
                    while (rs.next()) {
                        ++numResults;
                    }
                    TestCase.assertEquals((int)542, (int)numResults);
                }
                catch (Throwable t) {
                    throw new CacheException(t){};
                }
            }
        };
        SerializableRunnable loadData = new SerializableRunnable("load initial data using scripts"){

            public void run() throws CacheException {
                Connection conn = TestUtil.jdbcConn;
                try {
                    GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])loadDataScripts, (boolean)false, (LogWriter)Misc.getCacheLogWriter(), null, null, (boolean)false);
                    fireQuery.run();
                }
                catch (Throwable t) {
                    throw new CacheException(t){};
                }
            }
        };
        props.remove("init-scripts");
        props.setProperty("host-data", "true");
        AsyncInvocation loadDataAsync = firstVM.invokeAsync((Runnable)loadData);
        this.startClientVMs(1, 0, null, props);
        this.startServerVMs(3, 0, null, props);
        this.joinAsyncInvocation(loadDataAsync, firstVM);
        this.addExpectedException((int[])null, new int[]{3, 4}, new Object[]{CacheClosedException.class, DistributedSystemDisconnectedException.class, ForceReattemptException.class});
        this.stopVMNums(-3, -4);
        this.restartServerVMNums(new int[]{3, 4}, 0, null, props);
        this.removeExpectedException((int[])null, new int[]{3, 4}, new Object[]{CacheClosedException.class, DistributedSystemDisconnectedException.class, ForceReattemptException.class});
        firstVM.invoke((Runnable)fireQuery);
    }

    public void testUseCase8HangStandaloneServer_5965_2() throws Exception {
        int numResults;
        this.reduceLogLevelForTest("config");
        Properties props = new Properties();
        String ksDir = TestUtil.getResourcesDir() + "/lib/useCase8";
        String createTablesScripts = ksDir + "/create_colocated_schema2.sql";
        props.setProperty("init-scripts", createTablesScripts);
        props.setProperty("default-recovery-delay", "-1");
        this.startServerVMs(1, 0, null, props);
        VM firstVM = (VM)this.serverVMs.get(0);
        String[] loadDataScriptNames = new String[]{"loadCOUNTRIES.sql", "loadCITIES.sql", "loadAIRLINES.sql", "loadFLIGHTS1.sql", "loadFLIGHTS2.sql", "loadFLIGHTAVAILABILITY1.sql", "loadFLIGHTAVAILABILITY2.sql"};
        File qsDir = ToursDBUtil.getQuickstartDir();
        final String[] loadDataScripts = new String[loadDataScriptNames.length];
        for (int index = 0; index < loadDataScriptNames.length; ++index) {
            String loadScriptName = loadDataScriptNames[index];
            loadDataScripts[index] = loadScriptName.startsWith("loadFLIGHTS") ? new File(ksDir, loadScriptName).toString() : new File(qsDir, loadScriptName).toString();
        }
        final SerializableCallable fireQuery = new SerializableCallable("fire query to check proper data in region"){

            public Object call() {
                ResultSet rs;
                Connection conn = TestUtil.jdbcConn;
                try {
                    rs = conn.createStatement().executeQuery("select * from flights");
                    int numResults = 0;
                    while (rs.next()) {
                        int bbLen;
                        CreateTablePart2DUnit.this.getLogWriter().info((Object)String.format("Columns: FLIGHT_ID=%s, SEGMENT_NUMBER=%s, ORIG_AIRPORT=%s, DEPART_TIME=%s, DEST_AIRPORT=%s, ARRIVE_TIME=%s, MEAL=%s, FLYING_TIME=%s, MILES=%s, AIRCRAFT=%s", rs.getString("FLIGHT_ID"), rs.getInt(2), rs.getString(3), rs.getTime("DEPART_TIME"), rs.getString(5), rs.getTimestamp(6), rs.getString("MEAL"), rs.getDouble(8), rs.getString(9), rs.getString("AIRCRAFT")));
                        TestCase.assertEquals((String)("unexpected value: " + rs.getString(1)), (int)6, (int)rs.getString(1).length());
                        TestCase.assertTrue((String)("unexpected value " + rs.getInt("SEGMENT_NUMBER")), (rs.getInt(2) == 1 || rs.getInt(2) == 2 ? 1 : 0) != 0);
                        TestCase.assertEquals((int)3, (int)rs.getString("ORIG_AIRPORT").length());
                        TestCase.assertEquals((int)3, (int)rs.getString("DEST_AIRPORT").length());
                        TestCase.assertEquals((String)("unexpected value " + rs.getString("MEAL")), (int)1, (int)rs.getString(7).length());
                        TestCase.assertTrue((String)("unexpected value: " + rs.getString("AIRCRAFT")), (rs.getString(10).length() <= 6 ? 1 : 0) != 0);
                        Blob bb = rs.getBlob("PATH_MAP");
                        if (bb != null && (bbLen = (int)bb.length()) > 0) {
                            TestCase.assertEquals((String)"0031", (String)StringUtil.toHexString((byte[])bb.getBytes(1L, bbLen), (int)0, (int)bbLen));
                        }
                        ++numResults;
                    }
                    TestCase.assertEquals((int)542, (int)numResults);
                }
                catch (Throwable t) {
                    throw new CacheException(t){};
                }
                try {
                    rs = conn.createStatement().executeQuery("select flight_id, path_map, aircraft, miles from flights");
                    int numNonNullBlobs = 0;
                    int numResults = 0;
                    while (rs.next()) {
                        CreateTablePart2DUnit.this.getLogWriter().info((Object)String.format("Columns: FLIGHT_ID=%s, MILES=%s, AIRCRAFT=%s", rs.getString("FLIGHT_ID"), rs.getInt("MILES"), rs.getString(3)));
                        TestCase.assertEquals((String)("unexpected value: " + rs.getString("FLIGHT_ID")), (int)6, (int)rs.getString(1).length());
                        TestCase.assertTrue((String)("unexpected value " + rs.getString("AIRCRAFT")), (rs.getString(3).length() <= 6 ? 1 : 0) != 0);
                        Blob bb = rs.getBlob(2);
                        if (bb != null && bb.length() > 0L) {
                            TestCase.assertEquals((String)"0031", (String)rs.getString(2));
                            ++numNonNullBlobs;
                        }
                        ++numResults;
                    }
                    TestCase.assertEquals((int)542, (int)numResults);
                    return numNonNullBlobs;
                }
                catch (Throwable t) {
                    throw new CacheException(t){};
                }
            }
        };
        SerializableRunnable loadData = new SerializableRunnable("load initial data using scripts"){

            public void run() throws CacheException {
                Connection conn = TestUtil.jdbcConn;
                try {
                    GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])loadDataScripts, (boolean)false, (LogWriter)Misc.getCacheLogWriter(), null, null, (boolean)false);
                    fireQuery.call();
                }
                catch (Throwable t) {
                    throw new CacheException(t){};
                }
            }
        };
        props.remove("init-scripts");
        props.setProperty("host-data", "true");
        AsyncInvocation loadDataAsync = firstVM.invokeAsync((Runnable)loadData);
        this.startClientVMs(1, 0, null, props);
        this.startServerVMs(3, 0, null, props);
        Connection conn = TestUtil.jdbcConn;
        long start = System.currentTimeMillis();
        while ((numResults = conn.createStatement().executeUpdate("update flights set miles = miles + 500 where miles <= 1000")) == 0) {
            this.getLogWriter().info((Object)("missed updating " + numResults + " rows"));
            if (System.currentTimeMillis() - start <= 120000L) continue;
            CreateTablePart2DUnit.fail((String)"Did not detect successful update for 120 secs");
        }
        this.getLogWriter().info((Object)("updated " + numResults + " rows"));
        numResults = conn.createStatement().executeUpdate("update flights set path_map = cast(X'0031' as blob(102400)) where miles <= 1500");
        this.getLogWriter().info((Object)("updated " + numResults + " blobs"));
        this.joinAsyncInvocation(loadDataAsync, firstVM);
        this.addExpectedException((int[])null, new int[]{3, 4}, new Object[]{CacheClosedException.class, DistributedSystemDisconnectedException.class, ForceReattemptException.class});
        this.stopVMNums(-3, -4);
        this.restartServerVMNums(new int[]{3, 4}, 0, null, props);
        this.removeExpectedException((int[])null, new int[]{3, 4}, new Object[]{CacheClosedException.class, DistributedSystemDisconnectedException.class, ForceReattemptException.class});
        Integer numNonNullBlobs = (Integer)firstVM.invoke((Callable)fireQuery);
        this.getLogWriter().info((Object)("Number of blobs updated: " + numNonNullBlobs));
        CreateTablePart2DUnit.assertTrue((numNonNullBlobs > 0 ? 1 : 0) != 0);
    }

    public void testUseCase8_6131() throws Exception {
        this.basicUseCase8_6131(false);
    }

    public void testUseCase8_6131_OffHeap() throws Exception {
        this.basicUseCase8_6131(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicUseCase8_6131(boolean enableOffHeap) throws Exception {
        int index;
        this.reduceLogLevelForTest("config");
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(1, 2, -1, null, extra);
        int startIndex = 1000;
        int totalInserts = 20000;
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))" + this.getConditionalOffheapSuffix(enableOffHeap));
        for (int index2 = 1; index2 <= 1000; ++index2) {
            this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE values (" + index2 + ", " + index2 + ", " + index2 + ')');
        }
        final AtomicInteger threadId = new AtomicInteger(1);
        int numThreads = 20;
        final Object waitForInserts = new Object();
        Runnable doInsert = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int myId = threadId.getAndIncrement();
                    CreateTablePart2DUnit.this.getLogWriter().info((Object)("My thread ID is: " + myId));
                    PreparedStatement pstmt = TestUtil.getConnection().prepareStatement("insert into EMP.PARTITIONTESTTABLE values (?, ?, ?)");
                    Object object = waitForInserts;
                    synchronized (object) {
                        while (!signalThread) {
                            waitForInserts.wait();
                        }
                    }
                    for (int index = 1000 + myId; index <= 20000; index += 20) {
                        pstmt.setInt(1, index);
                        pstmt.setInt(2, index);
                        pstmt.setInt(3, index);
                        pstmt.execute();
                        CreateTablePart2DUnit.this.getLogWriter().info((Object)("Executed for index: " + index));
                    }
                }
                catch (Throwable t) {
                    CreateTablePart2DUnit.this.getLogWriter().error((Object)"Unexpected exception", t);
                    throw new TestException("failed in execution", t);
                }
            }
        };
        signalThread = false;
        Thread[] threads = new Thread[20];
        for (index = 0; index < 20; ++index) {
            threads[index] = new Thread(doInsert, "testThread-" + index);
        }
        for (index = 0; index < 20; ++index) {
            threads[index].start();
        }
        Thread.sleep(3000L);
        Object index3 = waitForInserts;
        synchronized (index3) {
            waitForInserts.notifyAll();
            signalThread = true;
        }
        for (int index4 = 0; index4 < 20; ++index4) {
            threads[index4].join();
        }
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, "select count(*) from EMP.PARTITIONTESTTABLE", null, String.valueOf(20000));
    }
}

