/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.RowLoader;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdListPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GfxdObjectSizer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedLocalRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedLocalRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.jdbc.CreateTableTest;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;

public class CreateTableDUnit
extends DistributedSQLTestBase {
    private volatile Throwable threadEx;
    private static Random random = new Random(System.currentTimeMillis());
    private static int derbyServerPort;

    public CreateTableDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testFabricServiceAPI() throws Throwable {
        Host host = Host.getHost((int)0);
        VM loc = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        final int locPort = AvailablePort.getRandomAvailablePort((int)0);
        final int netPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int netPort2 = AvailablePort.getRandomAvailablePort((int)0);
        int netPort3 = AvailablePort.getRandomAvailablePort((int)0);
        SerializableRunnable startLoc = new SerializableRunnable("start locator"){

            public void run() {
                Properties props = new Properties();
                CreateTableDUnit.this.setCommonProperties(props, 0, null, null);
                props.remove("locators");
                props.remove("start-locator");
                FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
                try {
                    locator.start("localhost", locPort, props);
                    locator.startNetworkServer("localhost", netPort1, null);
                }
                catch (SQLException sqle) {
                    throw new TestException("failed to start locator", (Throwable)sqle);
                }
            }
        };
        loc.invoke((Runnable)startLoc);
        Properties serverProps = new Properties();
        serverProps.setProperty("host-data", "true");
        serverProps.setProperty("locators", "localhost[" + locPort + ']');
        AsyncInvocation async1 = server1.invokeAsync((Runnable)((Object)new ServerStart(netPort2, serverProps)));
        AsyncInvocation async2 = server2.invokeAsync((Runnable)((Object)new ServerStart(netPort3, serverProps)));
        async1.getResult();
        async2.getResult();
        Connection conn = TestUtil.getNetConnection("localhost", netPort1, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1 (id int, name varchar(100)) persistent");
        stmt.execute("insert into t1 values (1, 'one'), (2, 'two'), (3, 'three'), (4, 'four')");
        ResultSet rs = stmt.executeQuery("select sum(id) from t1");
        CreateTableDUnit.assertTrue((boolean)rs.next());
        CreateTableDUnit.assertEquals((int)10, (int)rs.getInt(1));
        CreateTableDUnit.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
        conn.close();
        SerializableRunnable stopVM = new SerializableRunnable("stop VM"){

            public void run() {
                try {
                    FabricServiceManager.currentFabricServiceInstance().stop(null);
                }
                catch (SQLException sqle) {
                    throw new TestException("failed to stop VM", (Throwable)sqle);
                }
            }
        };
        server2.invoke((Runnable)stopVM);
        server1.invoke((Runnable)stopVM);
        loc.invoke((Runnable)stopVM);
        loc.invoke((Runnable)startLoc);
        async1 = server1.invokeAsync((Runnable)((Object)new ServerStart(netPort2, serverProps)));
        async2 = server2.invokeAsync((Runnable)((Object)new ServerStart(netPort3, serverProps)));
        async1.getResult();
        async2.getResult();
        this.addExpectedException(null, new Object[]{"com.pivotal.gemfirexd.internal.client.am.DisconnectException", "java.sql.SQLNonTransientConnectionException"});
        conn = TestUtil.getNetConnection("localhost", netPort1, null, null);
        stmt = conn.createStatement();
        rs = stmt.executeQuery("select sum(id) from t1");
        CreateTableDUnit.assertTrue((boolean)rs.next());
        CreateTableDUnit.assertEquals((int)10, (int)rs.getInt(1));
        CreateTableDUnit.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
        conn.close();
        this.removeExpectedException(null, new Object[]{"com.pivotal.gemfirexd.internal.client.am.DisconnectException", "java.sql.SQLNonTransientConnectionException"});
        server2.invoke((Runnable)stopVM);
        server1.invoke((Runnable)stopVM);
        loc.invoke((Runnable)stopVM);
    }

    public void testDifferentDDLForTableCreate() throws Exception {
        this.basicDifferentDDLForTableCreate(false);
    }

    public void testDifferentDDLForTableCreateOffheap() throws Exception {
        this.basicDifferentDDLForTableCreate(true);
    }

    private void basicDifferentDDLForTableCreate(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "sg1", extra);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "Sg1 ", extra);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG2", extra);
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, null, extra);
        this.startClientVMs(1, 0, null, extra);
        this.joinVMs(true, async1, async2, async3, async4);
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 )" + this.getConditionalOffheapSuffix(enableOffHeap));
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        ArrayList<ResolverUtils.GfxdRange> ranges = new ArrayList<ResolverUtils.GfxdRange>();
        ranges.add(new ResolverUtils.GfxdRange(null, (Object)new Integer(20), (Object)new Integer(40)));
        ranges.add(new ResolverUtils.GfxdRange(null, (Object)new Integer(40), (Object)new Integer(59)));
        ranges.add(new ResolverUtils.GfxdRange(null, (Object)new Integer(60), (Object)new Integer(80)));
        GfxdRangePartitionResolver resolver = new GfxdRangePartitionResolver("ID", ranges);
        PartitionAttributesFactory paf = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver);
        if (enableOffHeap) {
            paf.setLocalMaxMemory(500);
        }
        PartitionAttributes pa = paf.create();
        expectedAttrs.setPartitionAttributes(pa);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        expectedAttrs.setEnableOffHeapMemory(enableOffHeap);
        this.serverVerifyRegionProperties(1, "EMP", "PARTITIONTESTTABLE_ONE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "EMP", "PARTITIONTESTTABLE_ONE", (RegionAttributes<?, ?>)expectedAttrs);
        pa = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pa);
        expectedAttrs.setEnableOffHeapMemory(false);
        this.clientVerifyRegionProperties(1, "EMP", "PARTITIONTESTTABLE_ONE", (RegionAttributes<?, ?>)expectedAttrs);
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (20, 'Second')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (30, 'Third')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (40, 'Fourth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (60, 'Sixth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (70, 'Seventh')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (75, 'Eighth')");
        for (int index = 0; index < 2; ++index) {
            ((VM)this.serverVMs.get(index)).invoke(CreateTableDUnit.class, "checkBucketValuesInList", new Object[]{"EMP", "PARTITIONTESTTABLE_ONE", ranges, Boolean.TRUE});
        }
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (10, 'First')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ONE values (50, 'Fifth')");
        this.sqlExecuteVerify(new int[]{1}, null, "select ID, DESCRIPTION from EMP.PARTITIONTESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_partitionby_sel", false, false);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_ZERO (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY LIST ( ID ) ( VALUES (10, 20 ), VALUES (50, 60), VALUES (12, 34, 45))" + this.getConditionalOffheapSuffix(enableOffHeap));
        RegionAttributesCreation expectedAttrsLst = new RegionAttributesCreation();
        expectedAttrsLst.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrsLst.setConcurrencyChecksEnabled(false);
        ArrayList listofLists = new ArrayList();
        ArrayList<Integer> list_1 = new ArrayList<Integer>();
        list_1.add(new Integer(10));
        list_1.add(new Integer(20));
        listofLists.add(list_1);
        ArrayList<Integer> list_2 = new ArrayList<Integer>();
        list_2.add(new Integer(50));
        list_2.add(new Integer(60));
        listofLists.add(list_2);
        ArrayList<Integer> list_3 = new ArrayList<Integer>();
        list_3.add(new Integer(12));
        list_3.add(new Integer(34));
        list_3.add(new Integer(45));
        listofLists.add(list_3);
        GfxdListPartitionResolver resolver_list = new GfxdListPartitionResolver(listofLists);
        paf = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver_list);
        if (enableOffHeap) {
            paf.setLocalMaxMemory(500);
        }
        PartitionAttributes pa_list = paf.create();
        expectedAttrsLst.setPartitionAttributes(pa_list);
        expectedAttrsLst.setInitialCapacity(5);
        expectedAttrsLst.setConcurrencyChecksEnabled(false);
        expectedAttrsLst.setAllHasFields(true);
        expectedAttrsLst.setHasScope(false);
        expectedAttrsLst.setHasDiskDirs(false);
        expectedAttrsLst.setHasDiskWriteAttributes(false);
        expectedAttrsLst.setEnableOffHeapMemory(enableOffHeap);
        this.serverVerifyRegionProperties(1, "EMP", "PARTITIONTESTTABLE_ZERO", (RegionAttributes<?, ?>)expectedAttrsLst);
        this.serverVerifyRegionProperties(2, "EMP", "PARTITIONTESTTABLE_ZERO", (RegionAttributes<?, ?>)expectedAttrsLst);
        pa_list = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver_list).setLocalMaxMemory(0).create();
        expectedAttrsLst.setPartitionAttributes(pa_list);
        expectedAttrsLst.setEnableOffHeapMemory(false);
        this.clientVerifyRegionProperties(1, "EMP", "PARTITIONTESTTABLE_ZERO", (RegionAttributes<?, ?>)expectedAttrsLst);
        this.serverVerifyRegionProperties(3, "EMP", "PARTITIONTESTTABLE_ZERO", (RegionAttributes<?, ?>)expectedAttrsLst);
        this.serverVerifyRegionProperties(4, "EMP", "PARTITIONTESTTABLE_ZERO", (RegionAttributes<?, ?>)expectedAttrsLst);
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (10, 'First')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (20, 'Second')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (50, 'Third')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (60, 'Fourth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (12, 'Fifth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (34, 'Sixth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (45, 'Seventh')");
        for (int index = 0; index < 2; ++index) {
            ((VM)this.serverVMs.get(index)).invoke(CreateTableDUnit.class, "checkBucketValuesInList", new Object[]{"EMP", "PARTITIONTESTTABLE_ZERO", listofLists, Boolean.FALSE});
        }
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (11, 'Eighth')");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_ZERO values (13, 'Ninth')");
        this.sqlExecuteVerify(new int[]{1}, null, "select ID, DESCRIPTION from EMP.PARTITIONTESTTABLE_ZERO", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_partitionby_list", false, false);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_TWO (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY PRIMARY KEY BUCKETS 73 RECOVERYDELAY 100" + this.getConditionalOffheapSuffix(enableOffHeap));
        RegionAttributesCreation partAttrs = new RegionAttributesCreation();
        partAttrs.setDataPolicy(DataPolicy.PARTITION);
        PartitionAttributesFactory pafact = new PartitionAttributesFactory();
        pafact.setTotalNumBuckets(73).setRecoveryDelay(100L).setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver());
        if (enableOffHeap) {
            pafact.setLocalMaxMemory(500);
        }
        partAttrs.setPartitionAttributes(pafact.create());
        partAttrs.setInitialCapacity(5);
        partAttrs.setConcurrencyChecksEnabled(false);
        partAttrs.setAllHasFields(true);
        partAttrs.setHasScope(false);
        partAttrs.setHasDiskDirs(false);
        partAttrs.setHasDiskWriteAttributes(false);
        partAttrs.setEnableOffHeapMemory(enableOffHeap);
        this.serverVerifyRegionProperties(1, "EMP", "PARTITIONTESTTABLE_TWO", (RegionAttributes<?, ?>)partAttrs);
        this.serverVerifyRegionProperties(2, "EMP", "PARTITIONTESTTABLE_TWO", (RegionAttributes<?, ?>)partAttrs);
        RegionAttributesCreation emptyAttrs = new RegionAttributesCreation();
        emptyAttrs.setDataPolicy(DataPolicy.PARTITION);
        emptyAttrs.setPartitionAttributes(pafact.setLocalMaxMemory(0).create());
        emptyAttrs.setInitialCapacity(5);
        emptyAttrs.setConcurrencyChecksEnabled(false);
        emptyAttrs.setAllHasFields(true);
        emptyAttrs.setHasScope(false);
        emptyAttrs.setHasDiskDirs(false);
        emptyAttrs.setHasDiskWriteAttributes(false);
        emptyAttrs.setEnableOffHeapMemory(false);
        this.clientVerifyRegionProperties(1, "EMP", "PARTITIONTESTTABLE_TWO", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(3, "EMP", "PARTITIONTESTTABLE_TWO", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(4, "EMP", "PARTITIONTESTTABLE_TWO", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverSQLExecute(3, "create table EMP.TESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))REPLICATE SERVER GROUPS (SG1, SG2) INITSIZE 100 EXPIRE TABLE WITH TIMETOLIVE 100 ACTION DESTROY EXPIRE ENTRY WITH IDLETIME 10 ACTION DESTROY");
        RegionAttributesCreation replAttrs = new RegionAttributesCreation();
        replAttrs.setDataPolicy(DataPolicy.REPLICATE);
        replAttrs.setScope(Scope.DISTRIBUTED_ACK);
        replAttrs.setConcurrencyChecksEnabled(false);
        ExpirationAttributes expAttrs = new ExpirationAttributes(10, ExpirationAction.DESTROY);
        replAttrs.setEntryIdleTimeout(expAttrs);
        expAttrs = new ExpirationAttributes(100, ExpirationAction.DESTROY);
        replAttrs.setRegionTimeToLive(expAttrs);
        replAttrs.setStatisticsEnabled(true);
        replAttrs.setInitialCapacity(5);
        replAttrs.setConcurrencyChecksEnabled(false);
        replAttrs.setAllHasFields(true);
        replAttrs.setHasDiskDirs(false);
        replAttrs.setHasDiskWriteAttributes(false);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE_ONE", (RegionAttributes<?, ?>)replAttrs);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE_ONE", (RegionAttributes<?, ?>)replAttrs);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE_ONE", (RegionAttributes<?, ?>)replAttrs);
        emptyAttrs = new RegionAttributesCreation();
        emptyAttrs.setDataPolicy(DataPolicy.EMPTY);
        emptyAttrs.setScope(Scope.DISTRIBUTED_ACK);
        emptyAttrs.setConcurrencyChecksEnabled(false);
        emptyAttrs.setRegionTimeToLive(expAttrs);
        emptyAttrs.setStatisticsEnabled(true);
        emptyAttrs.setInitialCapacity(5);
        emptyAttrs.setConcurrencyChecksEnabled(false);
        emptyAttrs.setAllHasFields(true);
        emptyAttrs.setHasDiskDirs(false);
        emptyAttrs.setHasDiskWriteAttributes(false);
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE_ONE", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE_ONE", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverSQLExecute(4, "create diskstore teststore compactionthreshold 100  TimeInterval 20 MaxLogSize 1048576 WriteBufferSize 1024 autocompact true queuesize  1024 ");
        this.serverSQLExecute(4, "create table EMP.TESTTABLE_TWO (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))REPLICATE SERVER GROUPS (sg1, sg2) EVICTION BY LRUMEMSIZE 1000 EVICTACTION OVERFLOW  ASYNCHRONOUS  'teststore' ");
        replAttrs = new RegionAttributesCreation();
        replAttrs.setDataPolicy(DataPolicy.REPLICATE);
        replAttrs.setScope(Scope.DISTRIBUTED_ACK);
        replAttrs.setConcurrencyChecksEnabled(false);
        replAttrs.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)1000, (ObjectSizer)new GfxdObjectSizer(), (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        replAttrs.setInitialCapacity(5);
        replAttrs.setConcurrencyChecksEnabled(false);
        replAttrs.setAllHasFields(true);
        replAttrs.setHasDiskDirs(false);
        replAttrs.setHasDiskWriteAttributes(false);
        replAttrs.setDiskSynchronous(false);
        replAttrs.setDiskStoreName("TESTSTORE");
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE_TWO", (RegionAttributes<?, ?>)replAttrs);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE_TWO", (RegionAttributes<?, ?>)replAttrs);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE_TWO", (RegionAttributes<?, ?>)replAttrs);
        emptyAttrs = new RegionAttributesCreation();
        emptyAttrs.setScope(Scope.DISTRIBUTED_ACK);
        emptyAttrs.setInitialCapacity(5);
        emptyAttrs.setConcurrencyChecksEnabled(false);
        emptyAttrs.setAllHasFields(true);
        emptyAttrs.setDiskSynchronous(true);
        emptyAttrs.setDataPolicy(DataPolicy.EMPTY);
        emptyAttrs.setHasDiskWriteAttributes(false);
        emptyAttrs.setHasDiskDirs(false);
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE_TWO", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE_TWO", (RegionAttributes<?, ?>)emptyAttrs);
    }

    public void testGfxdRowLoaderNullsALso() throws Exception {
        this.basicGfxdRowLoaderNullsALso(false);
    }

    public void testGfxdRowLoaderNullsALso_Offheap() throws Exception {
        this.basicGfxdRowLoaderNullsALso(false);
    }

    private void basicGfxdRowLoaderNullsALso(boolean enableOffHeap) throws Exception {
        block4: {
            Properties extra = null;
            if (enableOffHeap) {
                extra = new Properties();
                extra.put("gemfire.off-heap-memory-size", "500m");
            }
            this.startClientVMs(2, 0, null, extra);
            this.startServerVMs(1, 0, "SG1", extra);
            this.startServerVMs(1, 0, "SG2", extra);
            this.clientSQLExecute(1, "create schema EMP");
            this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID CHAR(2), THIRDID varchar(100), primary key (ID)) SERVER GROUPS (sg1)" + this.getConditionalOffheapSuffix(enableOffHeap));
            GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdTestRowLoaderNullAndDifferentReturns", null);
            this.sqlExecuteVerify(new int[]{2}, null, "select ID from EMP.PARTITIONTESTTABLE where ID = 1", null, null);
            this.addExpectedException(new int[]{1}, new int[]{1}, "from loader as primary key");
            try {
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from EMP.PARTITIONTESTTABLE where ID = 11", null, null);
                CreateTableDUnit.fail((String)"expected an exception from loader");
            }
            catch (SQLException ex) {
                if (ex.getMessage().contains("from loader as primary key")) break block4;
                throw ex;
            }
        }
        this.removeExpectedException(new int[]{1}, new int[]{1}, "from loader as primary key");
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("select * from EMP.PARTITIONTESTTABLE");
        ResultSet rs = st.getResultSet();
        boolean gotResult = false;
        while (rs.next()) {
            gotResult = true;
            CreateTableDUnit.assertEquals((String)"33", (String)rs.getString(2));
        }
        CreateTableDUnit.assertTrue((boolean)gotResult);
    }

    public void testDDLForTableCreateLoader() throws Exception {
        this.basicDDLForTableCreateLoader(false);
    }

    public void testDDLForTableCreateLoader_Offheap() throws Exception {
        this.basicDDLForTableCreateLoader(true);
    }

    private void basicDDLForTableCreateLoader(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(1, 1, -1, null, extra);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))" + this.getConditionalOffheapSuffix(enableOffHeap));
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdTestRowLoader", null);
        this.sqlExecuteVerify(new int[]{1}, null, "select ID from EMP.PARTITIONTESTTABLE where ID = 1", null, null);
        this.sqlExecuteVerify(new int[]{1}, null, "select ID from EMP.PARTITIONTESTTABLE where ID = 2", null, null);
        this.sqlExecuteVerify(new int[]{1}, null, "select ID from EMP.PARTITIONTESTTABLE where ID = 3", null, null);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        CacheLoader ldr = rattr.getCacheLoader();
        GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
        CreateTableDUnit.assertNull((Object)gfxdldr);
        CreateTableDUnit.assertEquals((String)"Number of entries expected to be 3", (int)regtwo.size(), (int)3);
        for (Object keyObj : regtwo.keySet()) {
            RegionKey key = (RegionKey)keyObj;
            CreateTableDUnit.assertNotNull((Object)key);
            Object val = regtwo.get((Object)key);
            CreateTableDUnit.assertNotNull((Object)val);
            GemFireContainer gfContainer = (GemFireContainer)regtwo.getUserAttribute();
            if (gfContainer.isByteArrayStore()) {
                CreateTableDUnit.assertTrue((boolean)(val instanceof byte[]));
            } else {
                CreateTableDUnit.assertTrue((boolean)(val instanceof DataValueDescriptor[]));
            }
            CreateTableDUnit.assertNotNull((Object)val);
        }
    }

    public void testDistributedInsert() throws Exception {
        this.basicDistributedInsert(false);
    }

    public void testDistributedInsert_OffHeap() throws Exception {
        this.basicDistributedInsert(true);
    }

    private void basicDistributedInsert(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startServerVMs(1, 0, "sg1", extra);
        this.startClientVMs(1, 0, null, extra);
        this.clientSQLExecute(1, "create schema trade default server groups (SG1)");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid))" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.clientSQLExecute(1, "insert into trade.customers values (1,'XXXX1',1,'BEAV1',1)");
    }

    public void testUpdateColumn() throws Exception {
        this.basicUpdateColumn(false);
    }

    public void testUpdateColumn_OffHeap() throws Exception {
        this.basicUpdateColumn(true);
    }

    private void basicUpdateColumn(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startServerVMs(2, 0, "SG1", extra);
        this.startClientVMs(1, 0, null, extra);
        this.clientSQLExecute(1, "create schema trade default server groups (SG1)");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        expectedAttrs.setDataPolicy(DataPolicy.EMPTY);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.clientVerifyRegionProperties(1, "TRADE", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "TRADE", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "TRADE", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid))" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.clientSQLExecute(1, "insert into trade.customers values (1, 'XXXX1', 1, 'BEAV1', 1)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers where cid=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers where since=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_insert");
        this.clientSQLExecute(1, "update trade.customers set since=2 where cid=1");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cust_name,cid,since,addr,tid from trade.customers where cid=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers where since=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers where since=2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update");
        this.clientSQLExecute(1, "update trade.customers set since=3, cust_name='XXXX3' where tid=1");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cust_name,cid,since,addr,tid from trade.customers where cid=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers where since=2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers where since=3", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update2");
    }

    public void testReplicatedTable() throws Exception {
        this.basicReplicatedTable(false);
    }

    public void testReplicatedTable_OffHeap() throws Exception {
        this.basicReplicatedTable(true);
    }

    private void basicReplicatedTable(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startServerVMs(2, 0, "SG1", extra);
        this.startVMs(1, 1, -1, null, extra);
        this.clientSQLExecute(1, "create schema trade default server groups (SG1)");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        expectedAttrs.setDataPolicy(DataPolicy.EMPTY);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.clientVerifyRegionProperties(1, "TRADE", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "TRADE", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "TRADE", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid)) replicate" + this.getConditionalOffheapSuffix(enableOffHeap));
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.REPLICATE);
        expectedAttrs.setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        expectedAttrs.setEnableOffHeapMemory(enableOffHeap);
        this.serverVerifyRegionProperties(1, "TRADE", "CUSTOMERS", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "TRADE", "CUSTOMERS", (RegionAttributes<?, ?>)expectedAttrs);
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.EMPTY);
        expectedAttrs.setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        expectedAttrs.setEnableOffHeapMemory(false);
        this.clientVerifyRegionProperties(1, "TRADE", "CUSTOMERS", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(3, "TRADE", "CUSTOMERS", (RegionAttributes<?, ?>)expectedAttrs);
        this.clientSQLExecute(1, "insert into trade.customers values (1, 'XXXX1', 1, 'BEAV1', 1)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers where cid=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers where since=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_insert");
        this.clientSQLExecute(1, "update trade.customers set since=2 where cid=1");
        this.sqlExecuteVerify(new int[]{1}, null, "select cust_name, cid, since, addr, tid from trade.customers where cid=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers where since=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers where since=2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update");
        this.clientSQLExecute(1, "update trade.customers set since=3, cust_name='XXXX3' where tid=1");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select cust_name,cid,since,addr,tid from trade.customers where cid=1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers where since=2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers where since=3", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "trade_update2");
    }

    private void checkSYSTABLES(int vmNum, String schema, String table, final String xmlElement) throws CacheException {
        final String schemaName = schema.toUpperCase(Locale.ENGLISH);
        final String tableName = table.toUpperCase(Locale.ENGLISH);
        final String resourceDir = TestUtil.getResourcesDir();
        SerializableRunnable checkSYS = new SerializableRunnable("Clear cache and check tables"){

            public void run() throws CacheException {
                try {
                    TestUtil.sqlExecuteVerifyText("SELECT sc.SCHEMANAME, tab.TABLENAME, tab.SERVERGROUPS FROM SYS.SYSSCHEMAS sc, SYS.SYSTABLES tab WHERE sc.SCHEMANAME='" + schemaName + "' AND tab.TABLENAME='" + tableName + "' AND sc.SCHEMAID = tab.SCHEMAID", resourceDir + "/lib/checkCreateTable.xml", xmlElement, true, false);
                    TestUtil.sqlExecuteVerifyText("SELECT sc.SCHEMANAME, tab.TABLENAME, tab.SERVERGROUPS FROM SYS.SYSSCHEMAS sc, SYS.SYSTABLES tab WHERE sc.SCHEMANAME LIKE '" + schemaName + "%' AND tab.TABLENAME LIKE '" + tableName + "%' AND sc.SCHEMAID = tab.SCHEMAID", resourceDir + "/lib/checkCreateTable.xml", xmlElement, true, false);
                }
                catch (Exception ex) {
                    throw new CacheException(ex){};
                }
            }
        };
        VM vm = vmNum < 0 ? (VM)this.serverVMs.get(-vmNum - 1) : (VM)this.clientVMs.get(vmNum - 1);
        if (vm != null) {
            vm.invoke((Runnable)checkSYS);
        } else {
            checkSYS.run();
        }
    }

    public void testServerGroupsNoVMs() throws Exception {
        this.basicServerGroupsNoVMs(false);
    }

    public void testServerGroupsNoVMs_OffHeap() throws Exception {
        this.basicServerGroupsNoVMs(true);
    }

    private void basicServerGroupsNoVMs(boolean enableOffHeap) throws Exception {
        block3: {
            Properties extra = null;
            if (enableOffHeap) {
                extra = new Properties();
                extra.put("gemfire.off-heap-memory-size", "500m");
            }
            this.startServerVMs(2, 0, "SG1", extra);
            this.startVMs(1, 1, -1, null, extra);
            this.clientSQLExecute(1, "create schema trade default server groups (SG1)");
            this.serverSQLExecute(1, "create table trade.customers (cid int not null, primary key (cid)) server groups (sg1, SG2)" + this.getConditionalOffheapSuffix(enableOffHeap));
            TestUtil.checkServerGroups("trade.customers", "sg1", "sg2");
            this.checkSYSTABLES(1, "trade", "customers", "cust_sg");
            this.checkSYSTABLES(-1, "trade", "customers", "cust_sg");
            this.checkSYSTABLES(-2, "trade", "customers", "cust_sg");
            this.checkSYSTABLES(-3, "trade", "customers", "cust_sg");
            this.serverSQLExecute(2, "create table trade.securities (sec_id int not null, primary key (sec_id)) server groups (sg2, sg1)" + this.getConditionalOffheapSuffix(enableOffHeap));
            TestUtil.checkServerGroups("trade.securities", "sg1", "sg2");
            this.checkSYSTABLES(1, "trade", "securities", "sec_sg");
            this.checkSYSTABLES(-1, "trade", "securities", "sec_sg");
            this.checkSYSTABLES(-2, "trade", "securities", "sec_sg");
            this.checkSYSTABLES(-3, "trade", "securities", "sec_sg");
            this.clientSQLExecute(1, "insert into trade.customers values (1), (2)");
            this.serverSQLExecute(2, "insert into trade.securities values (4), (5)");
            try {
                this.serverSQLExecute(3, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, foreign key (sid) references trade.securities(sec_id)) server groups (Sg2)" + this.getConditionalOffheapSuffix(enableOffHeap));
                CreateTableDUnit.fail((String)"Expected an exception while creating a replicated table with no datastore");
            }
            catch (RMIException ex) {
                CreateTableDUnit.assertTrue((String)"Expected an SQLException", (boolean)(ex.getCause() instanceof SQLException));
                SQLException sqlEx = (SQLException)ex.getCause();
                if ("X0Z08".equals(sqlEx.getSQLState())) break block3;
                throw sqlEx;
            }
        }
    }

    public void testReplicatedServerGroupsNoVMs_bug40106() throws Exception {
        this.basicReplicatedServerGroupsNoVMs_bug40106(false);
    }

    public void testReplicatedServerGroupsNoVMs_bug40106_OffHeap() throws Exception {
        this.basicReplicatedServerGroupsNoVMs_bug40106(true);
    }

    private void basicReplicatedServerGroupsNoVMs_bug40106(boolean enableOffHeap) throws Exception {
        block3: {
            Properties extra = null;
            if (enableOffHeap) {
                extra = new Properties();
                extra.put("gemfire.off-heap-memory-size", "500m");
            }
            this.startServerVMs(2, 0, "SG1", extra);
            this.startVMs(1, 1, -1, null, extra);
            this.clientSQLExecute(1, "create schema trade default server groups (SG1)");
            this.serverSQLExecute(1, "create table trade.customers (cid int not null, primary key (cid)) replicate server groups (sg1, SG2)" + this.getConditionalOffheapSuffix(enableOffHeap));
            this.checkSYSTABLES(1, "trade", "customers", "cust_sg");
            this.checkSYSTABLES(-1, "trade", "customers", "cust_sg");
            this.checkSYSTABLES(-2, "trade", "customers", "cust_sg");
            this.checkSYSTABLES(-3, "trade", "customers", "cust_sg");
            this.serverSQLExecute(2, "create table trade.securities (sec_id int not null, primary key (sec_id)) replicate server groups (sg2, sg1)" + this.getConditionalOffheapSuffix(enableOffHeap));
            this.checkSYSTABLES(1, "trade", "securities", "sec_sg");
            this.checkSYSTABLES(-1, "trade", "securities", "sec_sg");
            this.checkSYSTABLES(-2, "trade", "securities", "sec_sg");
            this.checkSYSTABLES(-3, "trade", "securities", "sec_sg");
            this.clientSQLExecute(1, "insert into trade.customers values (1), (2)");
            this.serverSQLExecute(2, "insert into trade.securities values (4), (5)");
            try {
                this.serverSQLExecute(3, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, foreign key (sid) references trade.securities(sec_id)) replicate server groups (Sg2)" + this.getConditionalOffheapSuffix(enableOffHeap));
                CreateTableDUnit.fail((String)"Expected an exception while creating a replicated table with no datastore");
            }
            catch (RMIException ex) {
                CreateTableDUnit.assertTrue((String)"Expected an SQLException", (boolean)(ex.getCause() instanceof SQLException));
                SQLException sqlEx = (SQLException)ex.getCause();
                if ("X0Z08".equals(sqlEx.getSQLState())) break block3;
                throw sqlEx;
            }
        }
    }

    public void testRedundantCopies_bug40141() throws Exception {
        this.basicRedundantCopies_bug40141(false);
    }

    public void testRedundantCopies_bug40141_OffHeap() throws Exception {
        this.basicRedundantCopies_bug40141(true);
    }

    private void basicRedundantCopies_bug40141(boolean enableOffHeap) throws Exception {
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(1, 4, -1, null, extra);
        this.serverSQLExecute(1, "create table trade.customers (cid int not null, primary key (cid))" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.serverSQLExecute(2, "create table trade.securities (sec_id int not null, sec_name varchar(20), primary key (sec_id)) redundancy 2" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.clientSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, foreign key (sid) references trade.securities(sec_id)) redundancy 2" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.clientSQLExecute(1, "create table trade.portfolio2 (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, foreign key (sid) references trade.securities(sec_id)) redundancy 3" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.clientSQLExecute(1, "insert into trade.customers values (1), (2)");
        this.serverSQLExecute(3, "insert into trade.securities values (4, 'SEC1'), (5, 'SEC2')");
        this.checkFKViolation(1, "insert into trade.portfolio values (1, 3, 10, 20, 100.0, 5), (2, 2, 20, 25, 200.0, 6)");
        this.serverSQLExecute(1, "insert into trade.portfolio values (1, 4, 10, 20, 100.0, 5), (2, 5, 20, 25, 200.0, 6)");
        this.checkFKViolation(-3, "insert into trade.portfolio2 values (1, 3, 10, 20, 100.0, 5), (2, 2, 20, 25, 200.0, 6)");
        this.serverSQLExecute(1, "insert into trade.portfolio2 values (1, 4, 10, 20, 100.0, 5), (2, 5, 20, 25, 200.0, 6)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.securities", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "sec_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.portfolio", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.portfolio2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.customers where cid < 10", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.securities where sec_id > 1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "sec_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.portfolio where sid > 1 and qty > 5", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.portfolio2 where sid > 1 and qty > 5", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_insert");
        this.clientSQLExecute(1, "update trade.securities set sec_name='SEC4' where sec_id=4");
        this.serverSQLExecute(2, "update trade.securities set sec_name='SEC5' where sec_id=5");
        this.serverSQLExecute(3, "update trade.portfolio set tid=sid");
        this.serverSQLExecute(2, "update trade.portfolio2 set tid=sid");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.securities", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "sec_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.portfolio", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.portfolio2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.customers where cid < 10", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.securities where sec_id > 1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "sec_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.portfolio where sid > 1 and qty > 5", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_update");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct * from trade.portfolio2 where sid > 1 and qty > 5", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "port_update");
    }

    public void testQuickStart() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "CREATE TABLE AIRLINES(AIRLINE CHAR(2) NOT NULL CONSTRAINT AIRLINES_PK PRIMARY KEY, AIRLINE_FULL VARCHAR(24), BASIC_RATE DOUBLE PRECISION,DISTANCE_DISCOUNT DOUBLE PRECISION, BUSINESS_LEVEL_FACTOR DOUBLE PRECISION,FIRSTCLASS_LEVEL_FACTOR DOUBLE PRECISION, ECONOMY_SEATS INTEGER,BUSINESS_SEATS INTEGER, FIRSTCLASS_SEATS INTEGER )");
        this.clientSQLExecute(1, "CREATE TABLE COUNTRIES ( COUNTRY VARCHAR(26) NOT NULL CONSTRAINT COUNTRIES_UNQ_NM Unique, COUNTRY_ISO_CODE CHAR(2) NOT NULL CONSTRAINT COUNTRIES_PK PRIMARY KEY, REGION VARCHAR(26), CONSTRAINT COUNTRIES_UC CHECK (country_ISO_code = upper(country_ISO_code) ) )");
        this.clientSQLExecute(1, "CREATE TABLE CITIES ( CITY_ID INTEGER NOT NULL CONSTRAINT CITIES_PK Primary Key , CITY_NAME VARCHAR(24) NOT NULL,COUNTRY VARCHAR(26) NOT NULL, AIRPORT VARCHAR(3), LANGUAGE  VARCHAR(16), COUNTRY_ISO_CODE CHAR(2) CONSTRAINT COUNTRIES_FK REFERENCES COUNTRIES (COUNTRY_ISO_CODE) )");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTS ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), CONSTRAINT FLIGHTS_PK Primary Key ( FLIGHT_ID, SEGMENT_NUMBER), CONSTRAINT MEAL_CONSTRAINT CHECK (meal IN ('B', 'L', 'D', 'S')) )");
        this.clientSQLExecute(1, "CREATE INDEX DESTINDEX ON FLIGHTS ( DEST_AIRPORT)");
        this.clientSQLExecute(1, "CREATE INDEX ORIGINDEX ON FLIGHTS ( ORIG_AIRPORT)");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTAVAILABILITY ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , FLIGHT_DATE DATE NOT NULL , ECONOMY_SEATS_TAKEN INTEGER DEFAULT 0, BUSINESS_SEATS_TAKEN INTEGER DEFAULT 0, FIRSTCLASS_SEATS_TAKEN INTEGER DEFAULT 0, CONSTRAINT FLIGHTAVAIL_PK Primary Key ( FLIGHT_ID, SEGMENT_NUMBER, FLIGHT_DATE), CONSTRAINT FLIGHTS_FK2 Foreign Key ( FLIGHT_ID, SEGMENT_NUMBER) REFERENCES FLIGHTS ( FLIGHT_ID, SEGMENT_NUMBER) )");
        this.clientSQLExecute(1, "CREATE TABLE MAPS ( MAP_ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY, MAP_NAME VARCHAR(24) NOT NULL, REGION VARCHAR(26), AREA DECIMAL(8,4) NOT NULL, PHOTO_FORMAT VARCHAR(26) NOT NULL, PICTURE BLOB(102400), UNIQUE (MAP_ID, MAP_NAME) )");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTS_HISTORY ( FLIGHT_ID CHAR(6), SEGMENT_NUMBER INTEGER, ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), STATUS VARCHAR (20))");
        this.clientSQLExecute(1, "DROP TABLE AIRLINES");
        this.clientSQLExecute(1, "DROP TABLE CITIES");
        this.clientSQLExecute(1, "DROP TABLE COUNTRIES");
        this.clientSQLExecute(1, "DROP TABLE FLIGHTAVAILABILITY");
        this.clientSQLExecute(1, "DROP TABLE FLIGHTS");
        this.clientSQLExecute(1, "DROP TABLE MAPS");
        this.clientSQLExecute(1, "DROP TABLE FLIGHTS_HISTORY");
        this.clientSQLExecute(1, "CREATE TABLE AIRLINES ( AIRLINE CHAR(2) NOT NULL CONSTRAINT AIRLINES_PK PRIMARY KEY, AIRLINE_FULL VARCHAR(24), BASIC_RATE DOUBLE PRECISION, DISTANCE_DISCOUNT DOUBLE PRECISION, BUSINESS_LEVEL_FACTOR DOUBLE PRECISION, FIRSTCLASS_LEVEL_FACTOR DOUBLE PRECISION, ECONOMY_SEATS INTEGER, BUSINESS_SEATS INTEGER, FIRSTCLASS_SEATS INTEGER ) REPLICATE");
        this.clientSQLExecute(1, "CREATE TABLE COUNTRIES( COUNTRY VARCHAR(26) NOT NULL CONSTRAINT COUNTRIES_UNQ_NM Unique, COUNTRY_ISO_CODE CHAR(2) NOT NULL CONSTRAINT COUNTRIES_PK PRIMARY KEY, REGION VARCHAR(26), CONSTRAINT COUNTRIES_UC CHECK (country_ISO_code = upper(country_ISO_code) ) ) REPLICATE");
        this.clientSQLExecute(1, "CREATE TABLE CITIES ( CITY_ID INTEGER NOT NULL CONSTRAINT CITIES_PK Primary Key , CITY_NAME VARCHAR(24) NOT NULL, COUNTRY VARCHAR(26) NOT NULL, AIRPORT VARCHAR(3), LANGUAGE  VARCHAR(16), COUNTRY_ISO_CODE CHAR(2) CONSTRAINT COUNTRIES_FK REFERENCES COUNTRIES (COUNTRY_ISO_CODE) ) REPLICATE");
        this.clientSQLExecute(1, "CREATE TABLE MAPS ( MAP_ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY, MAP_NAME VARCHAR(24) NOT NULL, REGION VARCHAR(26), AREA DECIMAL(8,4) NOT NULL, PHOTO_FORMAT VARCHAR(26) NOT NULL, PICTURE BLOB(102400), UNIQUE (MAP_ID, MAP_NAME) ) REPLICATE");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTS ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), CONSTRAINT FLIGHTS_PK Primary Key ( FLIGHT_ID, SEGMENT_NUMBER), CONSTRAINT MEAL_CONSTRAINT CHECK (meal IN ('B', 'L', 'D', 'S')) ) PARTITION BY COLUMN (FLIGHT_ID)");
        this.clientSQLExecute(1, "CREATE INDEX DESTINDEX ON FLIGHTS (DEST_AIRPORT)");
        this.clientSQLExecute(1, "CREATE INDEX ORIGINDEX ON FLIGHTS (ORIG_AIRPORT)");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTAVAILABILITY ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , FLIGHT_DATE DATE NOT NULL , ECONOMY_SEATS_TAKEN INTEGER DEFAULT 0, BUSINESS_SEATS_TAKEN INTEGER DEFAULT 0, FIRSTCLASS_SEATS_TAKEN INTEGER DEFAULT 0, CONSTRAINT FLIGHTAVAIL_PK Primary Key ( FLIGHT_ID, SEGMENT_NUMBER, FLIGHT_DATE), CONSTRAINT FLIGHTS_FK2 Foreign Key (FLIGHT_ID, SEGMENT_NUMBER) REFERENCES FLIGHTS ( FLIGHT_ID, SEGMENT_NUMBER) ) PARTITION BY COLUMN (FLIGHT_ID) COLOCATE WITH (FLIGHTS)");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTS_HISTORY ( FLIGHT_ID CHAR(6), SEGMENT_NUMBER INTEGER, ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), STATUS VARCHAR (20) ) PARTITION BY COLUMN (FLIGHT_ID) COLOCATE WITH (FLIGHTS)");
        this.startVMs(0, 1);
        this.clientSQLExecute(1, "DROP TABLE AIRLINES");
        this.clientSQLExecute(1, "DROP TABLE CITIES");
        this.clientSQLExecute(1, "DROP TABLE COUNTRIES");
        this.clientSQLExecute(1, "DROP TABLE FLIGHTAVAILABILITY");
        this.addExpectedException(new int[]{1}, null, UnsupportedOperationException.class);
        try {
            this.clientSQLExecute(1, "DROP TABLE FLIGHTS");
            CreateTableDUnit.fail((String)"Expected an exception while dropping dependent table");
        }
        catch (SQLException ex) {
            if (!"X0Y98".equals(ex.getSQLState())) {
                throw ex;
            }
            this.removeExpectedException(new int[]{1}, null, UnsupportedOperationException.class);
        }
        this.clientSQLExecute(1, "DROP TABLE FLIGHTS_HISTORY");
        this.clientSQLExecute(1, "DROP TABLE FLIGHTS");
        this.clientSQLExecute(1, "DROP TABLE MAPS");
        this.clientSQLExecute(1, "CREATE TABLE AIRLINES(AIRLINE CHAR(2) NOT NULL CONSTRAINT AIRLINES_PK PRIMARY KEY, AIRLINE_FULL VARCHAR(24), BASIC_RATE DOUBLE PRECISION,DISTANCE_DISCOUNT DOUBLE PRECISION, BUSINESS_LEVEL_FACTOR DOUBLE PRECISION,FIRSTCLASS_LEVEL_FACTOR DOUBLE PRECISION, ECONOMY_SEATS INTEGER,BUSINESS_SEATS INTEGER, FIRSTCLASS_SEATS INTEGER )");
        this.clientSQLExecute(1, "CREATE TABLE COUNTRIES ( COUNTRY VARCHAR(26) NOT NULL CONSTRAINT COUNTRIES_UNQ_NM Unique, COUNTRY_ISO_CODE CHAR(2) NOT NULL CONSTRAINT COUNTRIES_PK PRIMARY KEY, REGION VARCHAR(26), CONSTRAINT COUNTRIES_UC CHECK (country_ISO_code = upper(country_ISO_code) ) )");
        this.clientSQLExecute(1, "CREATE TABLE CITIES ( CITY_ID INTEGER NOT NULL CONSTRAINT CITIES_PK Primary Key , CITY_NAME VARCHAR(24) NOT NULL,COUNTRY VARCHAR(26) NOT NULL, AIRPORT VARCHAR(3), LANGUAGE  VARCHAR(16), COUNTRY_ISO_CODE CHAR(2) CONSTRAINT COUNTRIES_FK REFERENCES COUNTRIES (COUNTRY_ISO_CODE) )");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTS ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), CONSTRAINT FLIGHTS_PK Primary Key ( FLIGHT_ID, SEGMENT_NUMBER), CONSTRAINT MEAL_CONSTRAINT CHECK (meal IN ('B', 'L', 'D', 'S')) )");
        this.clientSQLExecute(1, "CREATE INDEX DESTINDEX ON FLIGHTS ( DEST_AIRPORT)");
        this.clientSQLExecute(1, "CREATE INDEX ORIGINDEX ON FLIGHTS ( ORIG_AIRPORT)");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTAVAILABILITY ( FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , FLIGHT_DATE DATE NOT NULL , ECONOMY_SEATS_TAKEN INTEGER DEFAULT 0, BUSINESS_SEATS_TAKEN INTEGER DEFAULT 0, FIRSTCLASS_SEATS_TAKEN INTEGER DEFAULT 0, CONSTRAINT FLIGHTAVAIL_PK Primary Key ( FLIGHT_ID, SEGMENT_NUMBER, FLIGHT_DATE), CONSTRAINT FLIGHTS_FK2 Foreign Key ( FLIGHT_ID, SEGMENT_NUMBER) REFERENCES FLIGHTS ( FLIGHT_ID, SEGMENT_NUMBER) )");
        this.clientSQLExecute(1, "CREATE TABLE MAPS ( MAP_ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY, MAP_NAME VARCHAR(24) NOT NULL, REGION VARCHAR(26), AREA DECIMAL(8,4) NOT NULL, PHOTO_FORMAT VARCHAR(26) NOT NULL, PICTURE BLOB(102400), UNIQUE (MAP_ID, MAP_NAME) )");
        this.clientSQLExecute(1, "CREATE TABLE FLIGHTS_HISTORY ( FLIGHT_ID CHAR(6), SEGMENT_NUMBER INTEGER, ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), STATUS VARCHAR (20))");
        this.startClientVMs(1, 0, null);
    }

    public void testDDLRollback() throws Exception {
        Statement stmt;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        this.startVMs(1, 3);
                                        Connection conn = TestUtil.jdbcConn;
                                        CreateTableTest.createTables(conn);
                                        CreateTableTest.populateData(conn, false, false);
                                        stmt = conn.createStatement();
                                        stmt.execute("alter table trade.customers drop constraint cust_uk");
                                        stmt.execute("insert into trade.customers (cid, cust_name, addr, tid)  values (200, 'CUST20', 'ADDR200', 20)");
                                        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{EntryExistsException.class, "java.sql.SQLIntegrityConstraintViolationException", SQLException.class, RegionDestroyedException.class});
                                        try {
                                            stmt.execute("alter table trade.customers add constraint cust_uk1 unique (tid)");
                                            CreateTableDUnit.fail((String)"expected unique constraint violation");
                                        }
                                        catch (SQLException ex) {
                                            if ("23505".equals(ex.getSQLState())) break block16;
                                            throw ex;
                                        }
                                    }
                                    try {
                                        stmt.execute("alter table trade.customers add constraint cust_uk1 unique (cust_name)");
                                        CreateTableDUnit.fail((String)"expected unique constraint violation");
                                    }
                                    catch (SQLException ex) {
                                        if ("23505".equals(ex.getSQLState())) break block17;
                                        throw ex;
                                    }
                                }
                                try {
                                    stmt.execute("alter table trade.customers add constraint cust_uk2 unique (cust_name)");
                                    CreateTableDUnit.fail((String)"expected unique constraint violation");
                                }
                                catch (SQLException ex) {
                                    if ("23505".equals(ex.getSQLState())) break block18;
                                    throw ex;
                                }
                            }
                            stmt.execute("delete from trade.customers where cid=200");
                            stmt.execute("alter table trade.customers add constraint cust_uk1 unique (tid)");
                            try {
                                stmt.execute("alter table trade.customers add constraint cust_uk1 unique (cust_name)");
                                CreateTableDUnit.fail((String)"expected duplicate index exception");
                            }
                            catch (SQLException ex) {
                                if ("X0Y32".equals(ex.getSQLState())) break block19;
                                throw ex;
                            }
                        }
                        stmt.execute("alter table trade.customers add constraint cust_uk2 unique (cust_name)");
                        try {
                            stmt.execute("insert into trade.customers (cid, cust_name, addr, tid) values (200, 'CUST200', 'ADDR200', 20)");
                            CreateTableDUnit.fail((String)"expected unique constraint violation");
                        }
                        catch (SQLException ex) {
                            if ("23505".equals(ex.getSQLState())) break block20;
                            throw ex;
                        }
                    }
                    try {
                        stmt.execute("insert into trade.customers (cid, cust_name, addr, tid) values (200, 'CUST20', 'ADDR200', 200)");
                        CreateTableDUnit.fail((String)"expected unique constraint violation");
                    }
                    catch (SQLException ex) {
                        if ("23505".equals(ex.getSQLState())) break block21;
                        throw ex;
                    }
                }
                try {
                    stmt.execute("insert into trade.customers (cid, cust_name, addr, tid) values (200, 'CUST20', 'ADDR200', 20)");
                    CreateTableDUnit.fail((String)"expected unique constraint violation");
                }
                catch (SQLException ex) {
                    if ("23505".equals(ex.getSQLState())) break block22;
                    throw ex;
                }
            }
            try {
                stmt.execute("insert into trade.customers (cid, cust_name, addr, tid) values (20, 'CUST200', 'ADDR200', 200)");
                CreateTableDUnit.fail((String)"expected primary key violation");
            }
            catch (SQLException ex) {
                if ("23505".equals(ex.getSQLState())) break block23;
                throw ex;
            }
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{EntryExistsException.class, "java.sql.SQLIntegrityConstraintViolationException", SQLException.class, RegionDestroyedException.class});
        stmt.execute("insert into trade.customers (cid, cust_name, addr, tid) values (200, 'CUST200', 'ADDR200', 201)");
    }

    public void testNoDataQueriesWithGlobalIndex_41271() throws Exception {
        this.basicNoDataQueriesWithGlobalIndex_41271(false);
    }

    public void testNoDataQueriesWithGlobalIndex_41271_OffHeap() throws Exception {
        this.basicNoDataQueriesWithGlobalIndex_41271(true);
    }

    private void basicNoDataQueriesWithGlobalIndex_41271(boolean enableOffHeap) throws Exception {
        ResultSet rs;
        int id;
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(2, 3, -1, null, extra);
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (exchange) (VALUES ('nasdaq'), VALUES ('nye', 'amex'), VALUES ('lse', 'fse', 'hkse', 'tse'))" + this.getConditionalOffheapSuffix(enableOffHeap));
        final AtomicInteger invocationCount = new AtomicInteger(0);
        GemFireXDQueryObserverAdapter countLookups = new GemFireXDQueryObserverAdapter(){

            public void beforeGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey) {
                invocationCount.incrementAndGet();
            }
        };
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)countLookups);
        PreparedStatement pstmt = TestUtil.getPreparedStatement("insert into trade.securities values(?, ?, ?, ?, ?)");
        final String[] symbols = new String[]{"SUN", "IBM", "MSFT", "RHAT"};
        final String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        int numKeys = 20;
        for (int id2 = 1; id2 <= 20; ++id2) {
            String idStr = String.valueOf(id2);
            pstmt.setInt(1, id2);
            pstmt.setString(2, symbols[id2 % symbols.length]);
            pstmt.setBigDecimal(3, new BigDecimal(idStr + '.' + idStr));
            pstmt.setString(4, exchanges[id2 % exchanges.length]);
            pstmt.setInt(5, id2 + 5);
            pstmt.execute();
        }
        CreateTableDUnit.assertEquals((int)0, (int)invocationCount.get());
        GemFireXDQueryObserverAdapter delRow = new GemFireXDQueryObserverAdapter(){
            private final Random rnd = new Random();

            public void afterGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey, Object result) {
                try {
                    CreateTableDUnit.this.serverSQLExecute(this.rnd.nextInt(3) + 1, "delete from trade.securities where sec_id=" + indexKey);
                }
                catch (Exception ex) {
                    throw GemFireXDRuntimeException.newRuntimeException((String)"unexpected exception", (Throwable)ex);
                }
            }
        };
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)delRow);
        for (int id3 = 1; id3 <= 20; ++id3) {
            this.sqlExecuteVerify(new int[]{1}, null, "select * from trade.securities where sec_id=" + id3, TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
            this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select * from trade.securities where sec_id=" + id3, TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        }
        CreateTableDUnit.assertEquals((int)40, (int)invocationCount.get());
        GemFireXDQueryObserverHolder.removeObserver(delRow.getClass());
        GemFireXDQueryObserverAdapter insRow = new GemFireXDQueryObserverAdapter(){
            private final Random rnd = new Random();

            public void afterGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey, Object result) {
                try {
                    DataValueDescriptor key = (DataValueDescriptor)indexKey;
                    int id = key.getInt();
                    String idStr = key.getString();
                    if (id % 2 == 1) {
                        CreateTableDUnit.this.serverSQLExecute(this.rnd.nextInt(3) + 1, "insert into trade.securities values(" + idStr + ",'" + symbols[id % symbols.length] + "'," + idStr + '.' + idStr + ",'" + exchanges[id % exchanges.length] + "'," + (id + 5) + ')');
                    }
                }
                catch (Exception ex) {
                    throw GemFireXDRuntimeException.newRuntimeException((String)"unexpected exception", (Throwable)ex);
                }
            }
        };
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)insRow);
        pstmt = TestUtil.getPreparedStatement("select * from trade.securities where sec_id = ?");
        for (id = 1; id <= 20; ++id) {
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            CreateTableDUnit.assertFalse((boolean)rs.next());
        }
        CreateTableDUnit.assertEquals((int)60, (int)invocationCount.get());
        GemFireXDQueryObserverHolder.removeObserver(insRow.getClass());
        for (id = 1; id <= 20; ++id) {
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            if (id % 2 == 0) {
                CreateTableDUnit.assertFalse((boolean)rs.next());
                continue;
            }
            CreateTableDUnit.assertTrue((boolean)rs.next());
            CreateTableDUnit.assertEquals((int)id, (int)rs.getInt("SEC_ID"));
            CreateTableDUnit.assertEquals((int)(id + 5), (int)rs.getInt("TID"));
            CreateTableDUnit.assertFalse((boolean)rs.next());
        }
        CreateTableDUnit.assertEquals((int)80, (int)invocationCount.get());
        GemFireXDQueryObserverHolder.clearInstance();
    }

    public void testDDLReplay_41311() throws Exception {
        this.startVMs(1, 2);
        VM server1 = (VM)this.serverVMs.get(1);
        SerializableRunnable addObserver = new SerializableRunnable("add observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                    public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        return false;
                    }
                });
            }
        };
        server1.invoke((Runnable)addObserver);
        this.threadEx = null;
        Thread t = new Thread((Runnable)new SerializableRunnable("start VM and signal"){

            public void run() throws CacheException {
                try {
                    Thread.sleep(5000L);
                    CreateTableDUnit.this.startVMs(0, 1);
                }
                catch (Throwable t) {
                    CreateTableDUnit.this.threadEx = t;
                    DistributedSQLTestBase.fail("unexpected exception when start server VM", t);
                }
            }
        });
        t.start();
        this.clientSQLExecute(1, "create table test (id int, addr varchar(64)) ");
        t.join();
        if (this.threadEx != null) {
            CreateTableDUnit.fail("unexpected exception in thread", this.threadEx);
        }
    }

    public void testConcurrentDDL() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG2", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG1, SG2", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG2,sg1", null);
        this.startClientVMs(1, 0, null);
        this.startClientVMs(1, 0, "SG1");
        this.joinVMs(true, async1, async2, async3);
        String scmCreate = "create schema trade default server groups (SG1)";
        String tblCreate = "create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid))";
        SerializableRunnable createRun = new SerializableRunnable("create schema and tables"){

            public void run() throws CacheException {
                Connection conn = TestUtil.jdbcConn;
                try {
                    Statement stmt;
                    block7: {
                        stmt = conn.createStatement();
                        try {
                            stmt.execute("create schema trade default server groups (SG1)");
                        }
                        catch (SQLException ex) {
                            if ("X0Y68".equals(ex.getSQLState())) break block7;
                            throw ex;
                        }
                    }
                    try {
                        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid))");
                    }
                    catch (SQLException ex) {
                        if (!"X0Y32".equals(ex.getSQLState())) {
                            throw ex;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new CacheException(ex){};
                }
            }
        };
        ArrayList<AsyncInvocation> tasks = this.executeTaskAsync(new int[]{2}, new int[]{1, 2, 3}, (Runnable)createRun);
        createRun.run();
        this.joinAsyncInvocation(tasks);
        SerializableRunnable insertRun = new SerializableRunnable("insert data"){

            public void run() throws CacheException {
                Connection conn = TestUtil.jdbcConn;
                try {
                    PreparedStatement pstmt = conn.prepareStatement("insert into trade.customers values (?, ?, ?, ?, ?)");
                    for (int count = 1; count <= 100; ++count) {
                        pstmt.setInt(1, count);
                        pstmt.setString(2, "XXXX" + count);
                        pstmt.setInt(3, count);
                        pstmt.setString(4, "BEAV" + count);
                        pstmt.setInt(5, count);
                        try {
                            pstmt.execute();
                            continue;
                        }
                        catch (SQLException ex) {
                            if ("23505".equals(ex.getSQLState())) continue;
                            throw ex;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new CacheException(ex){};
                }
            }
        };
        tasks = this.executeTaskAsync(new int[]{2}, new int[]{1, 2, 3}, (Runnable)insertRun);
        insertRun.run();
        this.joinAsyncInvocation(tasks);
        SerializableRunnable queryRun = new SerializableRunnable("query data"){

            public void run() throws CacheException {
                Connection conn = TestUtil.jdbcConn;
                try {
                    ResultSet rs = conn.createStatement().executeQuery("select * from trade.customers order by cid");
                    for (int count = 1; count <= 100; ++count) {
                        TestCase.assertTrue((boolean)rs.next());
                        TestCase.assertEquals((int)count, (int)rs.getInt(1));
                        TestCase.assertEquals((String)("XXXX" + count), (String)rs.getString(2));
                        TestCase.assertEquals((int)count, (int)rs.getInt(3));
                        TestCase.assertEquals((String)("BEAV" + count), (String)rs.getString(4));
                        TestCase.assertEquals((int)count, (int)rs.getInt(5));
                    }
                    TestCase.assertFalse((boolean)rs.next());
                }
                catch (Exception ex) {
                    throw new CacheException(ex){};
                }
            }
        };
        tasks = this.executeTaskAsync(new int[]{2}, new int[]{1, 2, 3}, (Runnable)queryRun);
        queryRun.run();
        this.joinAsyncInvocation(tasks);
    }

    public void DISABLED_testProperExceptionNoValidMembers() throws Exception {
        this.startServerVMs(2, 0, "sg2");
        this.startClientVMs(1, 0, null);
        try {
            this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
            this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) partition by column(secondid) LOADER ( com.pivotal.gemfirexd.ddl.GfxdTestRowLoader.createGfxdLoader)");
            this.sqlExecuteVerify(new int[]{1}, null, "select secondid from EMP.PARTITIONTESTTABLE where id = 1", null, "1");
            CreateTableDUnit.fail((String)"this test was expected to fail due to insufficient stores");
        }
        catch (SQLException e) {
            CreateTableDUnit.assertEquals((String)e.getSQLState().toUpperCase(), (String)"X0Z08");
            return;
        }
        CreateTableDUnit.fail((String)"this test was not expected to reach here");
    }

    public void testLoaderNullSchema() throws Exception {
        this.basicLoaderNullSchema(false);
    }

    public void testLoaderNullSchema_OffHeap() throws Exception {
        this.basicLoaderNullSchema(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicLoaderNullSchema(boolean enableOffHeap) throws Exception {
        boolean tablesCreated = false;
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        try {
            this.startServerVMs(2, -1, "SG1", extra);
            this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  replicate " + this.getConditionalOffheapSuffix(enableOffHeap));
            tablesCreated = true;
            this.startClientVMs(1, 0, null, extra);
            String schema = null;
            GfxdCallbacksTest.addLoader(schema, "TESTTABLE", "com.pivotal.gemfirexd.ddl.CreateTableDUnit$GfxdTestRowLoader", "");
            this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
            this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
            this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
        }
        finally {
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoaderEmptySchema() throws Exception {
        boolean tablesCreated = false;
        try {
            this.startServerVMs(2, -1, "SG1");
            this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  replicate ");
            tablesCreated = true;
            this.startClientVMs(1, 0, null);
            GfxdCallbacksTest.addLoader("", "TESTTABLE", "com.pivotal.gemfirexd.ddl.CreateTableDUnit$GfxdTestRowLoader", "");
            this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
            this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
            this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
        }
        finally {
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
        }
    }

    public void _testIdentityGeneratedAlways() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (tid int, cid int not null GENERATED ALWAYS AS IDENTITY (START WITH 8), primary key (cid), constraint cust_ck check (cid >= 0))");
        SQLWarning sw = stmt.getWarnings();
        CreateTableDUnit.assertNull((Object)sw);
        int numRows = 2000;
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, 8, 2, this, true);
        stmt.execute("drop table trade.customers");
        this.addExpectedException(new int[]{1}, new int[]{2}, SQLWarning.class);
        stmt.execute("create table trade.customers (tid int, cid bigint not null GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 7), addr varchar(100), primary key (cid), constraint cust_ck check (cid >= 0))");
        this.removeExpectedException(new int[]{1}, new int[]{2}, SQLWarning.class);
        sw = stmt.getWarnings();
        CreateTableDUnit.assertNotNull((Object)sw);
        if (!"X0Z12".equals(sw.getSQLState()) || !sw.getMessage().contains("7")) {
            throw sw;
        }
        CreateTableDUnit.assertNull((Object)sw.getNextWarning());
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, 1, 2, this, true);
        stmt.execute("drop table trade.customers");
    }

    public void testIdentityGeneratedByDefault(boolean enableOffHeap) throws Exception {
        this.basicIdentityGeneratedByDefault(false);
    }

    public void testIdentityGeneratedByDefault_OffHeap(boolean enableOffHeap) throws Exception {
        this.basicIdentityGeneratedByDefault(true);
    }

    private void basicIdentityGeneratedByDefault(boolean enableOffHeap) throws Exception {
        this.reduceLogLevelForTest("config");
        Properties extra = null;
        if (enableOffHeap) {
            extra = new Properties();
            extra.put("gemfire.off-heap-memory-size", "500m");
        }
        this.startVMs(1, 2, -1, null, extra);
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (tid int, cid int not null GENERATED by default AS IDENTITY (START WITH 8), primary key (cid), constraint cust_ck check (cid >= 0))" + this.getConditionalOffheapSuffix(enableOffHeap));
        SQLWarning sw = stmt.getWarnings();
        CreateTableDUnit.assertNull((Object)sw);
        int numRows = 2000;
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, 8, 2, this, false);
        stmt.execute("drop table trade.customers");
        this.addExpectedException(new int[]{1}, new int[]{2}, SQLWarning.class);
        stmt.execute("create table trade.customers (tid int, cid bigint not null GENERATED by default as IDENTITY (START WITH 1, INCREMENT BY 7), addr varchar(100), primary key (cid), constraint cust_ck check (cid >= 0))" + this.getConditionalOffheapSuffix(enableOffHeap));
        this.removeExpectedException(new int[]{1}, new int[]{2}, SQLWarning.class);
        sw = stmt.getWarnings();
        CreateTableDUnit.assertNull((Object)sw);
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, 1, 2, this, false);
        stmt.execute("drop table trade.customers");
    }

    public static void verifyFlagAndRegionEntryClass(String path, boolean expectedFlagValue, Class expectedRegionEntryClass) throws Exception {
        LocalRegion region = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
        CreateTableDUnit.assertTrue((region != null ? 1 : 0) != 0);
        CreateTableDUnit.assertEquals((boolean)expectedFlagValue, (boolean)region.getAttributes().getConcurrencyChecksEnabled());
        Iterator entryItr = region.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, region);
        while (entryItr.hasNext()) {
            RowLocation re = (RowLocation)entryItr.next();
            CreateTableDUnit.assertEquals((Object)expectedRegionEntryClass, re.getClass());
        }
    }

    public void _testTestFlagToEnableVersioning_True() throws Exception {
        Properties props = new Properties();
        props.put("gemfirexd.TEST_FLAG_ENABLE_CONCURRENCY_CHECKS", "true");
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.startVMs(0, 4, mcastPort, null, props);
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) partition by primary key persistent redundancy 1 ");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinDiskRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) partition by primary key redundancy 1 ");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) replicate");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedLocalRowLocationThinRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) persistent replicate");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedLocalRowLocationThinDiskRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.stopAllVMs();
    }

    public void _testTestFlagToEnableVersioning_False() throws Exception {
        Properties props = new Properties();
        props.put("gemfirexd.TEST_FLAG_ENABLE_CONCURRENCY_CHECKS", "false");
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.startVMs(0, 4, mcastPort, null, props);
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) partition by primary key persistent redundancy 1 ");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMBucketRowLocationThinDiskRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) partition by primary key redundancy 1 ");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMBucketRowLocationThinRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) replicate");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.serverSQLExecute(1, "create table APP.T1(id int primary key, name varchar(20)) persistent replicate");
        this.serverSQLExecute(1, "insert into APP.T1 values(1, 'name1')");
        this.serverSQLExecute(1, "insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinDiskRegionEntryHeap.class});
        this.serverSQLExecute(1, "drop table APP.T1");
        this.stopAllVMs();
    }

    public void testVersionedEntriesCreatedForPersistentPartitionedTables() throws Exception {
        this.startVMs(1, 4);
        Connection conn = TestUtil.jdbcConn;
        Statement s = conn.createStatement();
        s.execute("create table APP.T1(id int primary key, name varchar(20)) partition by primary key persistent redundancy 1 ");
        s.execute("insert into APP.T1 values(1, 'name1')");
        s.execute("insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinDiskRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(id int primary key, name varchar(20)) partition by column(name) persistent redundancy 1 ");
        s.execute("insert into APP.T1 values(1, 'name1')");
        s.execute("insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", true, VersionedBucketRowLocationThinDiskRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(id int primary key, name varchar(20))  partition by column(name) redundancy 1 ");
        s.execute("insert into APP.T1 values(1, 'name1')");
        s.execute("insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMBucketRowLocationThinRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(id int primary key, name varchar(20))  persistent replicate");
        s.execute("insert into APP.T1 values(1, 'name1')");
        s.execute("insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinDiskRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.execute("create table APP.T1(id int primary key, name varchar(20))  replicate");
        s.execute("insert into APP.T1 values(1, 'name1')");
        s.execute("insert into APP.T1 values(2, 'name2')");
        this.getServerVM(1).invoke((Object)this, "verifyFlagAndRegionEntryClass", new Object[]{"/APP/T1", false, VMLocalRowLocationThinRegionEntryHeap.class});
        s.execute("drop table APP.T1");
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_SPP_testFunctionTable() throws Exception {
        this.startVMs(1, 2, 0, "SG1", null);
        final int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + derbyPort + "/newDB;create=true;";
        NetworkServerControl derbyServer = DBSynchronizerTestBase.startNetworkServer(derbyPort);
        CreateTableDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                derbyServerPort = derbyPort;
            }
        });
        derbyServerPort = derbyPort;
        try {
            Runnable runnable = DBSynchronizerTestBase.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, false, null, null, null, 100000, "", false);
            runnable.run();
            Runnable startWBCL = DBSynchronizerTestBase.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.serverSQLExecute(1, "create table trade.customers (cid int not null, primary key (cid)) replicate");
            String secDDL = "create table trade.securities (sec_id int not null, sec_name varchar(20), primary key (sec_id))";
            this.serverSQLExecute(1, "create table trade.securities (sec_id int not null, sec_name varchar(20), primary key (sec_id)) redundancy 1 AsyncEventListener (WBCL1)");
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            Statement stmt = derbyConn.createStatement();
            stmt.execute("create table trade.securities (sec_id int not null, sec_name varchar(20), primary key (sec_id))");
            stmt.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int)");
            try {
                this.clientSQLExecute(1, "CREATE FUNCTION trade.portfolio () RETURNS TABLE (cid int, sid int, qty int, availQty int, subTotal decimal(30,20), tid int) LANGUAGE JAVA PARAMETER STYLE DERBY_JDBC_RESULT_SET READS SQL DATA EXTERNAL NAME '" + CreateTableDUnit.class.getName() + ".readPortfolio'");
                this.clientSQLExecute(1, "insert into trade.customers values (1), (2)");
                this.serverSQLExecute(2, "insert into trade.securities values (4, 'sec4'), (5, 'sec5')");
                Thread.sleep(3000L);
                stmt.execute("insert into trade.portfolio values (1, 4, 10, 20, 100.0, 5), (2, 5, 20, 25, 200.0, 6), (3, 6, 30, 40, 300.0, 7)");
                Statement gfxdStmt = TestUtil.jdbcConn.createStatement();
                ResultSet rs = gfxdStmt.executeQuery("select f.cid, f.sid, f.subTotal, f.qty from table (trade.portfolio()) f where f.cid < 5 and (qty = availQty or subTotal > 100.0) order by f.cid");
                CreateTableDUnit.assertTrue((boolean)rs.next());
                CreateTableDUnit.assertEquals((int)2, (int)rs.getInt(1));
                CreateTableDUnit.assertEquals((int)5, (int)rs.getInt(2));
                CreateTableDUnit.assertEquals((String)"200.00000000000000000000", (String)rs.getString(3));
                CreateTableDUnit.assertEquals((int)20, (int)rs.getInt(4));
                CreateTableDUnit.assertTrue((boolean)rs.next());
                CreateTableDUnit.assertEquals((int)3, (int)rs.getInt(1));
                CreateTableDUnit.assertEquals((int)6, (int)rs.getInt(2));
                CreateTableDUnit.assertEquals((String)"300.00000000000000000000", (String)rs.getString(3));
                CreateTableDUnit.assertEquals((int)30, (int)rs.getInt(4));
                CreateTableDUnit.assertFalse((boolean)rs.next());
                rs = gfxdStmt.executeQuery("select f.cid, s.sec_id, s.sec_name, f.subTotal, f.qty from trade.customers c, trade.securities s, table (trade.portfolio()) f where c.cid = f.cid and sec_id = f.sid and f.cid < 5 and (qty = availQty or subTotal > 100.0)");
                CreateTableDUnit.assertTrue((boolean)rs.next());
                CreateTableDUnit.assertEquals((int)2, (int)rs.getInt(1));
                CreateTableDUnit.assertEquals((int)5, (int)rs.getInt(2));
                CreateTableDUnit.assertEquals((String)"sec5", (String)rs.getString(3));
                CreateTableDUnit.assertEquals((String)"200.00000000000000000000", (String)rs.getString(4));
                CreateTableDUnit.assertEquals((int)20, (int)rs.getInt(5));
                CreateTableDUnit.assertFalse((boolean)rs.next());
                boolean gotTwo = false;
                boolean gotThree = false;
                rs = gfxdStmt.executeQuery("select f.cid, c.cid, f.subTotal, f.qty from table (trade.portfolio()) f left outer join trade.customers c on f.cid = c.cid where f.cid < 5 and (qty = availQty or subTotal > 100.0)");
                for (int i = 1; i <= 2; ++i) {
                    CreateTableDUnit.assertTrue((boolean)rs.next());
                    if (rs.getInt(1) == 2) {
                        CreateTableDUnit.assertEquals((int)2, (int)rs.getInt(1));
                        CreateTableDUnit.assertEquals((int)2, (int)rs.getInt(2));
                        CreateTableDUnit.assertEquals((String)"200.00000000000000000000", (String)rs.getString(3));
                        CreateTableDUnit.assertEquals((int)20, (int)rs.getInt(4));
                        gotTwo = true;
                        continue;
                    }
                    CreateTableDUnit.assertEquals((int)3, (int)rs.getInt(1));
                    CreateTableDUnit.assertNull((Object)rs.getObject(2));
                    CreateTableDUnit.assertEquals((String)"300.00000000000000000000", (String)rs.getString(3));
                    CreateTableDUnit.assertEquals((int)30, (int)rs.getInt(4));
                    gotThree = true;
                }
                CreateTableDUnit.assertFalse((boolean)rs.next());
                CreateTableDUnit.assertTrue((boolean)gotTwo);
                gotTwo = false;
                CreateTableDUnit.assertTrue((boolean)gotThree);
                gotThree = false;
                DBSynchronizerTestBase.stopAsyncEventListener("WBCL1").run();
                Thread.sleep(3000L);
            }
            finally {
                stmt.execute("drop table trade.portfolio");
                stmt.execute("drop table trade.securities");
                stmt.close();
                derbyConn.close();
            }
        }
        finally {
            derbyServer.shutdown();
        }
    }

    private String getConditionalOffheapSuffix(boolean enableOffheapForTable) {
        if (enableOffheapForTable) {
            return " offheap ";
        }
        return " ";
    }

    public static ResultSet readPortfolio() throws Exception {
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + derbyServerPort + "/newDB;";
        Connection conn = DriverManager.getConnection(derbyDbUrl);
        PreparedStatement ps = conn.prepareStatement("select * from trade.portfolio");
        return ps.executeQuery();
    }

    public static void checkBucketValuesInList(Object schemaName, Object tableName, List<Object> valueList, Boolean isRangeList) throws Exception {
        String fullTableName = TestUtil.getFullTableName(schemaName, tableName);
        PartitionedRegion pRegion = (PartitionedRegion)Misc.getRegionForTable((String)fullTableName, (boolean)false);
        CreateTableDUnit.assertNotNull((String)("Partitioned region for table " + fullTableName + " not found"), (Object)pRegion);
        for (Object bucket : pRegion.getDataStore().getAllLocalBuckets()) {
            BucketRegion bRegion = (BucketRegion)((Map.Entry)bucket).getValue();
            if (bRegion == null) continue;
            CreateTableDUnit.getGlobalLogger().info((Object)("checkBucketValuesInList: Iterating over bucket region: " + bRegion.getFullPath()));
            Object expectedValue = null;
            String keylog = "values in this bucketregion are: ";
            for (Object knkey : bRegion.keySet()) {
                keylog = keylog + knkey.toString() + ",";
            }
            CreateTableDUnit.getGlobalLogger().info((Object)("keys in this bucket region = " + bRegion.getName() + " are: " + keylog));
            for (Object bEntry : bRegion.entrySet()) {
                final Object bucketValue = ((RegionKey)((Map.Entry)bEntry).getKey()).getKeyColumn(0).getObject();
                CreateTableDUnit.getGlobalLogger().info((Object)("checkBucketValuesInList: Checking for bucket entry: " + bucketValue));
                final ResolverUtils.GfxdComparableFuzzy bvFuzzy = new ResolverUtils.GfxdComparableFuzzy(bucketValue);
                final Visitor expectedListVisitor = new Visitor(){
                    Object foundNode = null;

                    @Override
                    public boolean visit(Object node) {
                        DistributedTestBase.getGlobalLogger().info((Object)("KNS: visit being called for bvfuzzy: " + bvFuzzy + ", in range: " + node.toString()));
                        boolean found = node instanceof ResolverUtils.GfxdRange ? ((ResolverUtils.GfxdRange)node).inRange(bvFuzzy) == 0 : node.equals(bucketValue);
                        if (found) {
                            this.foundNode = node;
                        }
                        DistributedTestBase.getGlobalLogger().info((Object)("KNS: returning found = " + found));
                        return found;
                    }

                    @Override
                    public Object getState() {
                        return this.foundNode;
                    }
                };
                if (expectedValue == null) {
                    if (isRangeList.booleanValue()) {
                        CreateTableDUnit.assertTrue((String)("Value in bucket [" + bucketValue + "] not in the expected lists of values: " + valueList), (boolean)CreateTableDUnit.forEach(valueList, expectedListVisitor));
                        ResolverUtils.GfxdRange expectedRange = (ResolverUtils.GfxdRange)expectedListVisitor.getState();
                        expectedValue = expectedRange.clone();
                        CreateTableDUnit.getGlobalLogger().info((Object)("invalidate called while checking for entry: " + bucketValue));
                        expectedRange.invalidate();
                    } else {
                        Visitor valueListVisitor = new Visitor(){
                            Object foundList = null;

                            @Override
                            public boolean visit(Object node) {
                                if (node instanceof List && CreateTableDUnit.forEach((List)node, expectedListVisitor)) {
                                    this.foundList = node;
                                    return true;
                                }
                                return false;
                            }

                            @Override
                            public Object getState() {
                                return this.foundList;
                            }
                        };
                        CreateTableDUnit.assertTrue((String)("Value in bucket [" + bucketValue + "] not in the expected lists of values: " + valueList), (boolean)CreateTableDUnit.forEach(valueList, valueListVisitor));
                        ArrayList expectedList = (ArrayList)valueListVisitor.getState();
                        expectedValue = expectedList.clone();
                        expectedList.clear();
                    }
                    CreateTableDUnit.assertNotNull((String)("checkBucketValuesInList: expected to find a list/range for first bucket value [" + bucketValue + ']'), (Object)expectedValue);
                    CreateTableDUnit.getGlobalLogger().info((Object)("checkBucketValuesInList: found first bucket value [" + bucketValue + "] in list/range: " + expectedValue));
                    continue;
                }
                if (isRangeList.booleanValue()) {
                    CreateTableDUnit.assertTrue((String)("Value in bucket [" + bucketValue + "] not in the expected range of values: " + expectedValue), (((ResolverUtils.GfxdRange)expectedValue).inRange(bvFuzzy) == 0 ? 1 : 0) != 0);
                } else {
                    CreateTableDUnit.assertTrue((String)("Value in bucket [" + bucketValue + "] not in the expected list of values: " + expectedValue), (boolean)CreateTableDUnit.forEach((List)expectedValue, expectedListVisitor));
                }
                CreateTableDUnit.getGlobalLogger().info((Object)("checkBucketValuesInList: found bucket value [" + bucketValue + "] in list/range: " + expectedValue));
            }
        }
    }

    private static boolean forEach(Collection<?> values, Visitor visitor) {
        boolean valueFound = false;
        for (Object value : values) {
            if (!(value instanceof ResolverUtils.GfxdRange && ((ResolverUtils.GfxdRange)value).isInvalid() || !(valueFound = visitor.visit(value)))) break;
        }
        return valueFound;
    }

    public static interface Visitor {
        public boolean visit(Object var1);

        public Object getState();
    }

    public static class GfxdTestRowLoader
    implements RowLoader {
        private String params;

        public Object getRow(String schemaName, String tableName, Object[] primarykey) throws SQLException {
            System.out.println("Asif");
            SanityManager.DEBUG_PRINT((String)"GfxdTestRowLoader", (String)("load called with key=" + primarykey[0] + " in VM " + Misc.getDistributedSystem().getDistributedMember()));
            Integer num = (Integer)primarykey[0];
            Object[] values = new Object[]{num, "DESC" + num, "ADDR" + num, num};
            return values;
        }

        public String getParams() {
            return this.params;
        }

        public void init(String initStr) throws SQLException {
            this.params = initStr;
        }
    }

    public final class ServerStart
    extends SerializableRunnable {
        private final int netPort;
        private final Properties extraProps;

        ServerStart(int port, Properties props) {
            this.netPort = port;
            this.extraProps = props;
        }

        public void run() {
            Properties props = new Properties();
            CreateTableDUnit.this.setCommonProperties(props, 0, null, this.extraProps);
            FabricServer server = FabricServiceManager.getFabricServerInstance();
            try {
                server.start(props);
                server.startNetworkServer(InetAddress.getLocalHost().getCanonicalHostName(), this.netPort, null);
            }
            catch (Exception ex) {
                throw new TestException("failed to start server", (Throwable)ex);
            }
        }
    }
}

