/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import java.util.Properties;

public class CreateSchemaDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 2039821312825185649L;

    public CreateSchemaDUnit(String name) {
        super(name);
    }

    public void testDistributedCreateAndServerGroup() throws Exception {
        TestUtil.currentUserName = null;
        this.startServerVMs(2, 0, "sg1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema EMP");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        expectedAttrs.setDataPolicy(DataPolicy.EMPTY);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.clientVerifyRegionProperties(1, "EMP", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "EMP", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "EMP", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select schemaname, authorizationid, defaultservergroups from SYS.SYSSCHEMAS where schemaname='EMP'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_nosg");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select schemaname, authorizationid, defaultservergroups from SYS.SYSSCHEMAS where schemaname like 'EMP%'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_nosg");
        this.clientSQLExecute(1, "drop schema EMP restrict");
        this.clientVerifyRegionProperties(1, "EMP", null, null);
        this.serverVerifyRegionProperties(1, "EMP", null, null);
        this.serverVerifyRegionProperties(2, "EMP", null, null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from SYS.SYSSCHEMAS where schemaname like 'EMP%'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "empty");
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
        this.clientVerifyRegionProperties(1, "EMP", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "EMP", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "EMP", null, (RegionAttributes<?, ?>)expectedAttrs);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select schemaname, defaultservergroups from SYS.SYSSCHEMAS where schemaname='EMP'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_sg");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select schemaname, defaultservergroups from SYS.SYSSCHEMAS where defaultservergroups='SG1'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_sg");
        this.clientSQLExecute(1, "drop schema EMP restrict");
    }

    public void testDistributedSchemaTableCreate() throws Exception {
        this.startVMs(1, 1);
        this.startVMs(0, 1, 0, "SG1", null);
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First')");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        PartitionAttributes pa = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
        expectedAttrs.setPartitionAttributes(pa);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        pa = new PartitionAttributesFactory(expectedAttrs.getPartitionAttributes()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pa);
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.sqlExecuteVerify(new int[]{1}, null, "select ID, DESCRIPTION from EMP.TESTTABLE", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_tab_sel", false, false);
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from SYS.SYSTABLES where tablename='TESTTABLE'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "empty");
        this.clientSQLExecute(1, "drop schema EMP restrict");
        this.clientVerifyRegionProperties(1, "EMP", null, null);
        this.serverVerifyRegionProperties(1, "EMP", null, null);
        this.serverVerifyRegionProperties(2, "EMP", null, null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from SYS.SYSSCHEMAS where schemaname='EMP'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "empty");
    }

    public void testDistributedSchemaCreateWithMultipleServerGroups() throws Exception {
        Properties props = new Properties();
        props.setProperty("gemfirexd.test.skip-default-initial-capacity", "true");
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, null, props);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG1", props);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG1, Sg2", props);
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg2", props);
        this.startClientVMs(1, 0, null, props);
        this.joinVMs(true, async1, async2, async3, async4);
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1, SG2)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First')");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        PartitionAttributes pa = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
        expectedAttrs.setPartitionAttributes(pa);
        expectedAttrs.setInitialCapacity(10000);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        PartitionAttributes pa2 = new PartitionAttributesFactory(expectedAttrs.getPartitionAttributes()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pa2);
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select ID, DESCRIPTION from EMP.TESTTABLE", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_tab_sel", false, false);
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE", null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select * from SYS.SYSTABLES where tablename='TESTTABLE'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "empty");
        this.serverSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null, primary key (ID)) server groups (SG2)");
        this.serverSQLExecute(2, "insert into EMP.TESTTABLE values (1, 'First')");
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        expectedAttrs.setPartitionAttributes(pa);
        expectedAttrs.setInitialCapacity(10000);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select ID, DESCRIPTION from EMP.TESTTABLE", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_tab_sel", false, false);
        this.serverSQLExecute(2, "drop table EMP.TESTTABLE");
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE", null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select * from SYS.SYSTABLES where tablename='TESTTABLE'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "empty");
        this.serverSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null, primary key (ID)) replicate server groups (SG2)");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First')");
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.REPLICATE);
        expectedAttrs.setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs.setInitialCapacity(10000);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        expectedAttrs.setDataPolicy(DataPolicy.EMPTY);
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select ID, DESCRIPTION from EMP.TESTTABLE", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_tab_sel", false, false);
        this.serverSQLExecute(4, "drop table EMP.TESTTABLE");
        this.clientVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(3, "EMP", "TESTTABLE", null);
        this.serverVerifyRegionProperties(4, "EMP", "TESTTABLE", null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select * from SYS.SYSTABLES where tablename='TESTTABLE'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "empty");
        this.clientSQLExecute(1, "drop schema EMP restrict");
        this.clientVerifyRegionProperties(1, "EMP", null, null);
        this.serverVerifyRegionProperties(1, "EMP", null, null);
        this.serverVerifyRegionProperties(2, "EMP", null, null);
        this.serverVerifyRegionProperties(3, "EMP", null, null);
        this.serverVerifyRegionProperties(4, "EMP", null, null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select * from SYS.SYSSCHEMAS where schemaname='EMP'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "empty");
    }
}

