/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;

public class CreateIndexDUnit
extends DistributedSQLTestBase {
    public CreateIndexDUnit(String name) {
        super(name);
    }

    public void testDistributedIndexCreate() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table ORDERS (ID int not null, VOL int, SECURITY_ID varchar(10), NUM int, CUST_ID int)");
        this.clientSQLExecute(1, "create index VOLUMEIDX on ORDERS(VOL)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select CONGLOMERATENAME, DESCRIPTOR from SYS.SYSCONGLOMERATES where CONGLOMERATENAME = 'VOLUMEIDX'", TestUtil.getResourcesDir() + "/lib/checkIndex.xml", "orders_nogh");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select CONGLOMERATENAME, DESCRIPTOR from SYS.SYSCONGLOMERATES where CONGLOMERATENAME like 'VOLUMEIDX%'", TestUtil.getResourcesDir() + "/lib/checkIndex.xml", "orders_nogh");
    }

    public void testDistributedGlobalHashIndexCreate() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table ORDERS (ID int not null, VOL int, SECURITY_ID varchar(10), NUM int, CUST_ID int)");
        this.clientSQLExecute(1, "create global hash index VOLUMEIDX on ORDERS(VOL)");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        PartitionAttributes pa = new PartitionAttributesFactory().create();
        expectedAttrs.setPartitionAttributes(pa);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.serverVerifyRegionProperties(1, null, "VOLUMEIDX", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, null, "VOLUMEIDX", (RegionAttributes<?, ?>)expectedAttrs);
        pa = new PartitionAttributesFactory().setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pa);
        this.clientVerifyRegionProperties(1, null, "VOLUMEIDX", (RegionAttributes<?, ?>)expectedAttrs);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select CONGLOMERATENAME, DESCRIPTOR from SYS.SYSCONGLOMERATES where CONGLOMERATENAME='VOLUMEIDX'", TestUtil.getResourcesDir() + "/lib/checkIndex.xml", "orders_gh");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select CONGLOMERATENAME, DESCRIPTOR from SYS.SYSCONGLOMERATES where CONGLOMERATENAME like 'VOLUMEIDX%'", TestUtil.getResourcesDir() + "/lib/checkIndex.xml", "orders_gh");
    }
}

