/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.DDLHoplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HdfsSortedOplogOrganizer;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class CreateHDFSStoreDUnit
extends DistributedSQLTestBase {
    public CreateHDFSStoreDUnit(String name) {
        super(name);
    }

    public void testBug51481() throws Exception {
        int[] isolations;
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table t1 (col1 int primary key, col2 int) replicate");
        st.execute("create table t2 (col1 int primary key, col2 int) partition by primary key");
        for (int isolation : isolations = new int[]{0, 2, 4}) {
            conn.setTransactionIsolation(isolation);
            conn.setAutoCommit(true);
            st.execute("put into t1 values (11, 123)");
            st.execute("put into t1 values (11, 123)");
            st.execute("put into t2 values (11, 123)");
            st.execute("put into t2 values (11, 123)");
            st.execute("put into t1 values (11, 123), (11, 123), (12, 124)");
            st.execute("put into t2 values (11, 123), (11, 123), (12, 124)");
            conn.setAutoCommit(false);
            st.execute("put into t1 values (11, 123)");
            st.execute("put into t1 values (11, 123)");
            conn.commit();
            st.execute("put into t2 values (11, 123)");
            st.execute("put into t2 values (11, 123)");
            conn.commit();
            st.execute("put into t1 values (11, 123), (11, 123), (12, 124)");
            st.execute("put into t2 values (11, 123), (11, 123), (12, 124)");
            conn.commit();
        }
    }

    public void testBug49893() throws Exception {
        block3: {
            this.startVMs(1, 2);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            try {
                st.execute("create table t1 (col1 int primary key, col2 int) replicate enable concurrency checks");
                st.execute("insert into t1 values (11, 123)");
                PreparedStatement ps = conn.prepareStatement("insert into t1 values (?,?)");
                for (int i = 0; i < 1; ++i) {
                    int col1 = 11 + i;
                    ps.setInt(1, col1);
                    ps.setInt(2, i);
                    ps.addBatch();
                }
                ps.executeBatch();
                CreateHDFSStoreDUnit.fail((String)"Should throw duplicate primary key exception");
            }
            catch (SQLException e) {
                if (e.getSQLState().compareTo("23505") == 0) break block3;
                throw e;
            }
        }
    }

    public void testBug49236() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs' queuepersistent true");
        st.execute("CREATE TABLE emp.Booking (id bigint not null, beds int not null, primary key (id)) PARTITION BY PRIMARY KEY EVICTION BY CRITERIA (ID > 1000 ) EVICTION FREQUENCY 180 SECONDS PERSISTENT HDFSSTORE (myhdfs);");
        st.execute("insert into emp.Booking (id, beds) values (1, 2)");
        ResultSet set = st.executeQuery("select * from emp.Booking");
        int count = 0;
        while (set.next()) {
            ++count;
        }
        CreateHDFSStoreDUnit.assertEquals((int)1, (int)count);
        TestUtil.shutDown();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("insert into emp.Booking (id, beds) values (2, 3)");
        set = st.executeQuery("select * from emp.Booking");
        count = 0;
        while (set.next()) {
            ++count;
        }
        CreateHDFSStoreDUnit.assertEquals((int)2, (int)count);
        st.execute("drop table emp.Booking");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(new File("./myhdfs"));
        TestUtil.shutDown();
    }

    public void testRestart() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "'");
        st.execute("create table mytable (id int generated always as identity, item char(25)) PARTITION BY COLUMN (ID) PERSISTENT HDFSSTORE (myhdfs);");
        st.execute("insert into mytable values (default, 'widget');");
        this.stopAllVMs();
        this.restartVMNums(-1, -2);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("insert into mytable values (default, 'widget1');");
        st.execute("drop table mytable");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testPutDML() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 100 milliseconds ");
        st.execute("create table app.m1 (col1 int primary key , col2 int) hdfsstore (myhdfs)");
        st.execute("create index app.idx1 on app.m1(col2)");
        st.execute("insert into app.m1 values (11, 22)");
        st.execute("put into app.m1 values (11, 33)");
        st.execute("put into app.m1 values (66, 77)");
        st.execute("select * from app.m1 where col2 = 22");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 where col2 = 33");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)33, (int)rs.getInt(2));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 where col2 = 77");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)77, (int)rs.getInt(2));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreDUnit.assertEquals((int)2, (int)count);
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/M1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        this.stopAllVMs();
        this.restartVMNums(-1, -2);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 11");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)33, (int)rs.getInt(2));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 66");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)77, (int)rs.getInt(2));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = st.getResultSet();
        count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreDUnit.assertEquals((int)2, (int)count);
        st.execute("drop table app.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testBug52073() throws Exception {
        int i;
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE VOLTE.D_SUBSCRIPTION (imsi varchar(64) not null, market varchar(32), constraint volte_d_subscription_imsi_pk primary key (imsi)) PARTITION BY COLUMN(imsi) REDUNDANCY 1 PERSISTENT ASYNCHRONOUS");
        String putStmt = "PUT INTO VOLTE.D_SUBSCRIPTION VALUES (?, ?)";
        PreparedStatement ps = conn.prepareStatement(putStmt);
        for (int i2 = 0; i2 < 2; ++i2) {
            ps.setString(1, String.valueOf(i2));
            ps.setString(2, "abc");
            ps.addBatch();
        }
        int[] ret = ps.executeBatch();
        for (i = 0; i < 2; ++i) {
            CreateHDFSStoreDUnit.assertEquals((int)1, (int)ret[i]);
        }
        for (i = 0; i < 2; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "abc");
            ps.addBatch();
        }
        ret = ps.executeBatch();
        for (i = 0; i < 2; ++i) {
            CreateHDFSStoreDUnit.assertEquals((int)1, (int)ret[i]);
        }
    }

    public void testPutDMLSubSelect() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 100 milliseconds ");
        st.execute("create table app.m1 (col1 int primary key , col2 int) hdfsstore (myhdfs)");
        st.execute("create index app.idx1 on app.m1(col2)");
        st.execute("insert into app.m1 values (11, 22)");
        st.execute("create table app.m2 (col1 int primary key, col2 int)");
        st.execute("insert into app.m2 values (11, 12), (22, 23), (33, 34)");
        st.execute("put into app.m1 select * from app.m2");
        st.execute("select * from app.m1 where col2 = 22");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 where col2 = 12");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)11, (int)rs.getInt(1));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 where col2 = 23");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)22, (int)rs.getInt(1));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select count(*) from app.m1");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)3, (int)rs.getInt(1));
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/M1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        this.stopAllVMs();
        this.restartVMNums(-1, -2);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from app.m1");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 11");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)12, (int)rs.getInt(2));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 33");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)34, (int)rs.getInt(2));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select count(*) from app.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)3, (int)rs.getInt(1));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("drop table app.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testPutDMLSubSelectReplicated() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("create table t1 (col1 int primary key, col2 int) replicate");
        st.execute("create table t2 (col1 int primary key, col2 int) partition by primary key");
        st.execute("insert into t2 values (1, 11), (2, 22)");
        st.execute("put into t1 select * from t2");
        st.execute("put into t1 select * from t2");
    }

    public void testTruncateTableHDFS() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 100 milliseconds");
        st.execute("create table app.t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into app.t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        this.stopAllVMs();
        this.restartVMNums(-1, -2);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from app.t1");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
        st.execute("truncate table app.t1");
        st.execute("select * from app.t1");
        rs = st.getResultSet();
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        st.execute("select * from app.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, 0);
        st.execute("drop table app.t1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testDistributionOfHDFSStoreCreate() throws Exception {
        int i;
        this.startVMs(1, 2);
        this.checkDirExistence("./gemfire");
        this.clientSQLExecute(1, "create hdfsstore TEST namenode 'localhost'");
        this.sqlExecuteVerify(null, new int[]{1, 2}, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        SerializableRunnable verifier = this.verifyHDFSStoreExistence("TEST");
        for (i = 1; i < 3; ++i) {
            this.serverExecute(i, (Runnable)verifier);
        }
        this.startVMs(0, 1);
        this.sqlExecuteVerify(null, new int[]{3}, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.serverExecute(3, (Runnable)verifier);
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select NAME from SYS.SYSHDFSSTORES  ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.clientSQLExecute(1, "drop hdfsstore TEST");
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        verifier = this.verifyNoHDFSStoreExistence("TEST");
        for (i = 1; i < 3; ++i) {
            this.serverExecute(i, (Runnable)verifier);
        }
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select NAME from SYS.SYSHDFSSTORES  ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        HDFSStoreImpl hs = Misc.getGemFireCache().findHDFSStore("TEST");
        CreateHDFSStoreDUnit.assertNull((Object)hs);
        CreateHDFSStoreDUnit.delete(new File("./gemfire"));
    }

    public void testDistributionOfHDFSStoreDrop() throws Exception {
        this.startVMs(1, 2);
        this.checkDirExistence("./gemfire");
        this.clientSQLExecute(1, "create hdfsstore TEST namenode 'localhost'");
        this.sqlExecuteVerify(null, new int[]{1, 2}, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        this.serverExecute(1, (Runnable)this.verifyHDFSStoreExistence("TEST"));
        this.serverExecute(2, (Runnable)this.verifyHDFSStoreExistence("TEST"));
        this.clientSQLExecute(1, "drop hdfsstore TEST");
        this.serverExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        this.serverExecute(2, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        this.startVMs(0, 1);
        this.sqlExecuteVerify(null, new int[]{3}, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        this.serverExecute(3, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST'", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        CreateHDFSStoreDUnit.delete(new File("./gemfire"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistentAttributesForAccessor() throws Exception {
        RegionAttributes ra;
        Region rgn;
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "teststore");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        this.checkDirExistence(homeDir);
        s.execute("create hdfsstore teststore namenode 'localhost' homedir '" + homeDir + "'");
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TESTSTORE"));
        this.serverExecute(1, (Runnable)this.verifyHDFSStoreExistence("TESTSTORE"));
        this.serverExecute(2, (Runnable)this.verifyHDFSStoreExistence("TESTSTORE"));
        String persistentSuffix = "persistent hdfsstore (teststore)";
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), addr varchar(100), tid int, primary key (cid))   partition by range (cid) (VALUES BETWEEN 0.0 AND 99.0)  " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            ra = rgn.getAttributes();
            CreateHDFSStoreDUnit.assertEquals((Object)DataPolicy.HDFS_PARTITION, (Object)ra.getDataPolicy());
        }
        finally {
            s.execute("drop table trade.customers");
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            ra = rgn.getAttributes();
            CreateHDFSStoreDUnit.assertEquals((Object)DataPolicy.HDFS_PARTITION, (Object)ra.getDataPolicy());
        }
        finally {
            s.execute("drop table trade.customers");
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) partition by primary key   " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            ra = rgn.getAttributes();
            CreateHDFSStoreDUnit.assertEquals((Object)DataPolicy.HDFS_PARTITION, (Object)ra.getDataPolicy());
        }
        finally {
            s.execute("drop table trade.customers");
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) partition by column (cust_name)  " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            ra = rgn.getAttributes();
            CreateHDFSStoreDUnit.assertEquals((Object)DataPolicy.HDFS_PARTITION, (Object)ra.getDataPolicy());
        }
        finally {
            s.execute("drop table trade.customers");
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))PARTITION BY LIST ( tid ) ( VALUES (10, 20 ), VALUES (50, 60), VALUES (12, 34, 45)) " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            ra = rgn.getAttributes();
            CreateHDFSStoreDUnit.assertEquals((Object)DataPolicy.HDFS_PARTITION, (Object)ra.getDataPolicy());
        }
        finally {
            s.execute("drop table trade.customers");
        }
        s.execute("drop hdfsstore teststore");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testDDLPersistenceFromClientOnMultipleServers() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfsfromclient");
        String homeDir = homeDirFile.getAbsolutePath();
        this.clientSQLExecute(1, "create schema emp");
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create hdfsstore test namenode 'localhost' homedir '" + homeDir + "'");
        this.clientSQLExecute(1, "create table emp.mytab1 (col1 int primary key, col2 int) persistent hdfsstore (test)");
        this.shutDownAll();
        this.startVMs(2, 3);
        this.serverSQLExecute(3, "insert into emp.mytab1 values (1,2) ");
        this.serverSQLExecute(3, "insert into emp.mytab1 values (2,2) ");
        this.serverSQLExecute(3, "create alias a1 for 'b1'");
        this.clientSQLExecute(1, "create table emp.mytab2 (col1 int primary key, col2 int) persistent hdfsstore (test)");
        this.serverSQLExecute(1, "drop table emp.mytab1 ");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.sqlExecuteVerify(new int[]{1, 2}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        this.clientExecute(2, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        this.serverExecute(1, (Runnable)this.verifyDDLPersistence("TEST"));
        this.serverExecute(2, (Runnable)this.verifyDDLPersistence("TEST"));
        this.serverExecute(3, (Runnable)this.verifyDDLPersistence("TEST"));
        this.serverSQLExecute(1, "drop table emp.mytab2 ");
        this.clientSQLExecute(1, "drop hdfsstore test ");
        this.sqlExecuteVerify(new int[]{1, 2}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testDDLPersistenceFromClientOnSingleServer() throws Exception {
        this.startVMs(1, 1);
        File homeDirFile = new File(".", "myhdfsfromclient");
        String homeDir = homeDirFile.getAbsolutePath();
        this.clientSQLExecute(1, "create schema emp");
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create hdfsstore test namenode 'localhost' homedir '" + homeDir + "'");
        this.clientSQLExecute(1, "create table emp.mytab1 (col1 int primary key, col2 int) persistent hdfsstore (test)");
        this.serverSQLExecute(1, "create alias a1 for 'b1'");
        this.clientSQLExecute(1, "create table emp.mytab2 (col1 int primary key, col2 int) persistent hdfsstore (test)");
        this.serverSQLExecute(1, "drop table emp.mytab1 ");
        this.sqlExecuteVerify(null, new int[]{1}, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-dist1");
        this.serverExecute(1, (Runnable)this.verifyDDLPersistence("TEST"));
        this.serverSQLExecute(1, "drop table emp.mytab2 ");
        this.clientSQLExecute(1, "drop hdfsstore test ");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testDDLPersistenceFromClientWithNoServer() throws Exception {
        this.startVMs(1, 0);
        boolean exceptionthrown = false;
        try {
            this.clientSQLExecute(1, "create schema emp");
        }
        catch (Exception e) {
            exceptionthrown = true;
        }
        CreateHDFSStoreDUnit.assertTrue((String)"The command should have failed as there is no server", (boolean)exceptionthrown);
    }

    public void testBulkDMLInsertsForHDFSQueue() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfsfromclient");
        String homeDir = homeDirFile.getAbsolutePath();
        this.clientSQLExecute(1, "create schema emp");
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create hdfsstore clienttest namenode 'localhost' homedir '" + homeDir + "'");
        this.clientSQLExecute(1, "create table emp.mytab1 (col1 int primary key, col2 int) persistent hdfsstore (clienttest)");
        this.clientSQLExecute(1, "Insert into emp.mytab1 values(1,1)");
        this.clientSQLExecute(1, "Insert into emp.mytab1 values(2,2)");
        this.clientSQLExecute(1, "Insert into emp.mytab1 values(3,3)");
        this.clientExecute(1, (Runnable)this.execute());
        this.clientSQLExecute(1, "drop table emp.mytab1");
        this.clientSQLExecute(1, "drop hdfsstore clienttest");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testEstimateSize() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence(homeDir);
        st.execute("create schema hdfs");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "'  BatchTimeInterval 100 milliseconds");
        st.execute("create table hdfs.m1 (col1 int primary key , col2 int) hdfsstore (myhdfs)");
        st.execute("insert into hdfs.m1 values (11, 22)");
        st.execute("put into hdfs.m1 values (11, 33)");
        st.execute("put into hdfs.m1 values (66, 77)");
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/HDFS/M1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        this.stopAllVMs();
        this.restartVMNums(-1, -2);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("values COUNT_ESTIMATE('hdfs.m1')");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
            CreateHDFSStoreDUnit.assertEquals((long)2L, (long)rs.getLong(1));
        }
        CreateHDFSStoreDUnit.assertEquals((int)1, (int)count);
        st.execute("drop table hdfs.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testUpgradeHLLConstant() throws Exception {
        this.dotestUpgradeHLLConstant(false);
    }

    public void testUpgradeHLLConstantOneHoplog() throws Exception {
        this.dotestUpgradeHLLConstant(true);
    }

    private void dotestUpgradeHLLConstant(boolean compactBeforeShutdown) throws Exception {
        CreateHDFSStoreDUnit.invokeInEveryVM((SerializableCallable)new SerializableCallable(){

            public Object call() throws Exception {
                HdfsSortedOplogOrganizer.HLL_CONSTANT = 0.1;
                return null;
            }
        });
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        final String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence(homeDir);
        CreateHDFSStoreDUnit.assertEquals((int)0, (int)this.getNumberOfMajorCompactedFiles(homeDir));
        st.execute("create schema hdfs");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 1000 milliseconds ");
        st.execute("create table hdfs.m1 (col1 int primary key , col2 int) partition by primary key buckets 2 persistent hdfsstore (myhdfs)");
        for (int i = 1; i < 150; ++i) {
            st.execute("insert into hdfs.m1 values (" + i + ", " + i * 10 + ")");
            if (i % 10 != 0) continue;
            String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/HDFS/M1");
            st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/HDFS/M1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        if (compactBeforeShutdown) {
            st.execute("call SYS.HDFS_FORCE_COMPACTION('hdfs.m1', 0)");
            CreateHDFSStoreDUnit.assertEquals((int)2, (int)this.getNumberOfMajorCompactedFiles(homeDir));
        }
        this.stopAllVMs();
        CreateHDFSStoreDUnit.invokeInEveryVM((SerializableCallable)new SerializableCallable(){

            public Object call() throws Exception {
                HdfsSortedOplogOrganizer.HLL_CONSTANT = 0.03;
                return null;
            }
        });
        long timeBeforeRestart = System.currentTimeMillis();
        this.restartVMNums(-1, -2);
        this.restartVMNums(1);
        CreateHDFSStoreDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                return CreateHDFSStoreDUnit.this.getNumberOfMajorCompactedFiles(homeDir) == 2;
            }

            public String description() {
                return "expected 2 major compacted files, found " + CreateHDFSStoreDUnit.this.getNumberOfMajorCompactedFiles(homeDir);
            }
        }, (long)30000L, (long)1000L, (boolean)true);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        CreateHDFSStoreDUnit.assertTrue((boolean)st.execute("values SYS.HDFS_LAST_MAJOR_COMPACTION('hdfs.m1')"));
        rs = st.getResultSet();
        rs.next();
        CreateHDFSStoreDUnit.assertTrue((rs.getTimestamp(1).getTime() >= timeBeforeRestart ? 1 : 0) != 0);
        st.execute("values COUNT_ESTIMATE('hdfs.m1')");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
            CreateHDFSStoreDUnit.assertTrue((String)("estimate:" + rs.getLong(1)), (Math.abs(rs.getLong(1) - 150L) < 6L ? 1 : 0) != 0);
        }
        CreateHDFSStoreDUnit.assertEquals((int)1, (int)count);
        st.execute("drop table hdfs.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testCount() throws Exception {
        this.startVMs(1, 3);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence(homeDir);
        st.execute("create schema hdfs");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "'  BatchTimeInterval 100 milliseconds");
        st.execute("create table hdfs.m1 (col1 int primary key , col2 int) partition by primary key redundancy 1 hdfsstore (myhdfs)");
        for (int i = 0; i < 300; ++i) {
            st.execute("insert into hdfs.m1 values (" + i + ", " + i * 10 + ")");
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/HDFS/M1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        for (int i = 300; i < 600; ++i) {
            st.execute("insert into hdfs.m1 values (" + i + ", " + i * 10 + ")");
        }
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        st.execute("select count(*) from hdfs.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = st.getResultSet();
        rs.next();
        CreateHDFSStoreDUnit.assertEquals((int)600, (int)rs.getInt(1));
        this.stopAllVMs();
        this.restartVMNums(-1, -2, -3);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select count(*) from hdfs.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
            CreateHDFSStoreDUnit.assertEquals((long)600L, (long)rs.getLong(1));
        }
        CreateHDFSStoreDUnit.assertEquals((int)1, (int)count);
        this.stopVMNum(-1);
        Thread.sleep(3000L);
        st.execute("select count(*) from hdfs.m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = st.getResultSet();
        count = 0;
        while (rs.next()) {
            ++count;
            CreateHDFSStoreDUnit.assertEquals((long)600L, (long)rs.getLong(1));
        }
        CreateHDFSStoreDUnit.assertEquals((int)1, (int)count);
        st.execute("drop table hdfs.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testForceCompact() throws Exception {
        this.doForceCompact(false);
    }

    public void testSyncForceCompact() throws Exception {
        this.doForceCompact(true);
    }

    private void doForceCompact(boolean isSynchronous) throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        final String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.checkDirExistence(homeDir);
        CreateHDFSStoreDUnit.assertEquals((int)0, (int)this.getNumberOfMajorCompactedFiles(homeDir));
        st.execute("create schema hdfs");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 1000 milliseconds");
        st.execute("create table hdfs.m1 (col1 int primary key , col2 int) partition by primary key buckets 2 hdfsstore (myhdfs)");
        for (int i = 1; i <= 120; ++i) {
            st.execute("insert into hdfs.m1 values(" + i + ", " + i * 10 + ")");
            if (i % 10 != 0) continue;
            String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/HDFS/M1");
            st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        }
        CreateHDFSStoreDUnit.assertEquals((int)0, (int)this.getNumberOfMajorCompactedFiles(homeDir));
        CreateHDFSStoreDUnit.assertTrue((boolean)st.execute("values SYS.HDFS_LAST_MAJOR_COMPACTION('hdfs.m1')"));
        ResultSet rs = st.getResultSet();
        rs.next();
        CreateHDFSStoreDUnit.assertEquals((long)0L, (long)rs.getTimestamp(1).getTime());
        long b4Compaction = System.currentTimeMillis();
        st.execute("call SYS.HDFS_FORCE_COMPACTION('hdfs.m1', " + (isSynchronous ? 0 : 1) + ")");
        if (isSynchronous) {
            CreateHDFSStoreDUnit.assertTrue((boolean)st.execute("values SYS.HDFS_LAST_MAJOR_COMPACTION('hdfs.m1')"));
            rs = st.getResultSet();
            rs.next();
            CreateHDFSStoreDUnit.assertTrue((rs.getTimestamp(1).getTime() >= b4Compaction ? 1 : 0) != 0);
        } else {
            CreateHDFSStoreDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    return CreateHDFSStoreDUnit.this.getNumberOfMajorCompactedFiles(homeDir) == 2;
                }

                public String description() {
                    return "expected 2 major compacted files, found " + CreateHDFSStoreDUnit.this.getNumberOfMajorCompactedFiles(homeDir);
                }
            }, (long)30000L, (long)1000L, (boolean)true);
        }
        CreateHDFSStoreDUnit.assertEquals((int)2, (int)this.getNumberOfMajorCompactedFiles(homeDir));
        st.execute("drop table hdfs.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testFlushQueue() throws Exception {
        this.doFlushQueue(false, false);
    }

    public void testFlushQueueColocate() throws Exception {
        this.doFlushQueue(false, true);
    }

    public void testFlushQueueWO() throws Exception {
        this.doFlushQueue(true, false);
    }

    private void doFlushQueue(boolean wo, boolean colo) throws Exception {
        int i;
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.checkDirExistence(homeDir);
        st.execute("create schema hdfs");
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 300000 milliseconds");
        st.execute("create table hdfs.m1 (col1 int primary key , col2 int) partition by primary key buckets 2 hdfsstore (myhdfs) " + (wo ? "writeonly" : ""));
        for (i = 1; i <= 120; ++i) {
            st.execute("insert into hdfs.m1 values(" + i + ", " + i * 10 + ")");
        }
        if (!wo && colo) {
            st.execute("create table hdfs.m2 (col1 int primary key , col2 int) partition by primary key colocate with (hdfs.m1) buckets 2 hdfsstore (myhdfs)");
            for (i = 1; i <= 120; ++i) {
                st.execute("insert into hdfs.m2 values(" + i + ", " + i * 10 + ")");
            }
        }
        st.execute("call SYS.HDFS_FLUSH_QUEUE('hdfs.m1', 30000)");
        SerializableRunnable verify = new SerializableRunnable(){

            public void run() {
                DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                    public boolean done() {
                        return this.getQueueSize() == 0;
                    }

                    public String description() {
                        return "expected queue size == 0, found " + this.getQueueSize();
                    }

                    private int getQueueSize() {
                        return ((PartitionedRegion)Misc.getGemFireCache().getRegion("/HDFS/M1")).getHDFSEventQueueStats().getEventQueueSize();
                    }
                }, (long)30000L, (long)1000L, (boolean)true);
            }
        };
        this.serverExecute(1, (Runnable)verify);
        this.serverExecute(2, (Runnable)verify);
        if (colo) {
            st.execute("drop table hdfs.m2");
        }
        st.execute("drop table hdfs.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testForceFileRollover() throws Exception {
        int i;
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create schema hdfs");
        this.clientSQLExecute(1, "create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "' BatchTimeInterval 1 milliseconds");
        this.clientSQLExecute(1, "create table hdfs.m1 (col1 int primary key , col2 int) partition by primary key hdfsstore (myhdfs) writeonly buckets 73");
        for (i = 1; i <= 200; ++i) {
            this.clientSQLExecute(1, "insert into hdfs.m1 values(" + i + ", " + i * 10 + ")");
        }
        this.serverSQLExecute(1, "create table hdfs.m2 (col1 int primary key , col2 int) partition by primary key colocate with (hdfs.m1) buckets 73 hdfsstore (myhdfs) writeonly");
        for (i = 1; i <= 200; ++i) {
            this.serverSQLExecute(1, "insert into hdfs.m2 values(" + i + ", " + i * 10 + ")");
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/HDFS/M1");
        this.serverSQLExecute(1, "CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        this.serverExecute(1, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop.tmp", true, "HDFS_M1"));
        this.serverExecute(1, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop", false, "HDFS_M1"));
        this.serverExecute(2, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop.tmp", true, "HDFS_M2"));
        this.serverExecute(2, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop", false, "HDFS_M2"));
        this.serverSQLExecute(1, "call SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('hdfs.m1', 0)");
        this.serverExecute(1, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop.tmp", false, "HDFS_M1"));
        this.serverExecute(1, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop", true, "HDFS_M1"));
        this.serverExecute(2, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop.tmp", true, "HDFS_M2"));
        this.serverExecute(2, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop", false, "HDFS_M2"));
        this.clientSQLExecute(1, "call SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('HDFS.M2', 0)");
        this.serverExecute(1, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop.tmp", false, "HDFS_M1"));
        this.serverExecute(1, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop", true, "HDFS_M1"));
        this.serverExecute(2, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop.tmp", false, "HDFS_M1"));
        this.serverExecute(2, (Runnable)this.verifyExtensionCount("MYHDFS", ".shop", true, "HDFS_M2"));
        this.clientSQLExecute(1, "drop table hdfs.m2");
        this.clientSQLExecute(1, "drop table hdfs.m1");
        this.clientSQLExecute(1, "drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testBug48928() throws Exception {
        this.startVMs(1, 2);
        int netPort = this.startNetworkServer(2, null, null);
        Properties props = new Properties();
        props.put("skip-constraint-checks", "true");
        props.put("sync-commits", "true");
        Connection conn = TestUtil.getConnection(props);
        Connection conn2 = TestUtil.getConnection(props);
        this.runBug48928(conn, conn2);
        conn = TestUtil.getNetConnection(netPort, null, props);
        conn2 = TestUtil.getConnection(props);
        this.runBug48928(conn, conn2);
        conn = TestUtil.getNetConnection(netPort, null, props);
        conn2 = TestUtil.getNetConnection(netPort, null, props);
        this.runBug48928(conn, conn2);
        conn = TestUtil.getConnection(props);
        conn2 = TestUtil.getNetConnection(netPort, null, props);
        conn.setTransactionIsolation(2);
        conn2.setTransactionIsolation(2);
        this.runBug48928(conn, conn2);
        conn = TestUtil.getConnection(props);
        conn2 = TestUtil.getConnection(props);
        conn.setTransactionIsolation(2);
        conn2.setTransactionIsolation(2);
        this.runBug48928(conn, conn2);
        conn = TestUtil.getNetConnection(netPort, null, props);
        conn2 = TestUtil.getNetConnection(netPort, null, props);
        conn.setTransactionIsolation(4);
        conn2.setTransactionIsolation(4);
        this.runBug48928(conn, conn2);
    }

    public void testPeerClientWithUniqueConstraint() throws Exception {
        Statement st;
        File homeDirFile;
        block2: {
            this.startVMs(0, 2);
            homeDirFile = new File(".", "myhdfs");
            String homeDir = homeDirFile.getAbsolutePath();
            Properties props = new Properties();
            props.setProperty("host-data", "false");
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", this.getLocatorString());
            Connection conn = TestUtil.getConnection(props);
            st = conn.createStatement();
            Object rs = null;
            this.checkDirExistence(homeDir);
            st.execute("create hdfsstore myhdfs namenode 'localhost' homedir '" + homeDir + "'");
            st.execute("create table app.m1 (col1 int, col2 int, col3 int, primary key (col1, col2, col3), constraint cus_uq unique (col1, col2)) persistent hdfsstore (myhdfs) partition by (col1)");
            st.execute("insert into app.m1 values (11, 22, 33)");
            try {
                st.execute("insert into app.m1 values (11, 22, 34)");
                CreateHDFSStoreDUnit.fail((String)"Should have seen a unique constraint violation");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("23505")) break block2;
                throw e;
            }
        }
        st.execute("call sys.rebalance_all_buckets()");
        st.execute("drop table app.m1");
        st.execute("drop hdfsstore myhdfs");
        CreateHDFSStoreDUnit.delete(homeDirFile);
    }

    private void runBug48928(Connection conn, Connection conn2) throws Exception {
        Statement st = conn.createStatement();
        st.execute("create table trade.securities (sec_id int primary key) partition by primary key");
        st.execute("create table trade.customers (cid int primary key, tid int, constraint cus_uq unique (tid)) partition by primary key");
        st.execute("create table trade.buyorders (oid int primary key, cid int, sid int, tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id), constraint bo_cust_fk2 foreign key (tid) references trade.customers (tid)) partition by primary key");
        st.execute("insert into trade.securities values (11)");
        st.execute("insert into trade.customers values (12, 15)");
        st.execute("insert into trade.customers values (12, 16)");
        st.execute("insert into trade.customers values (13, 15)");
        st.execute("insert into trade.buyorders values (1, 10, 14, 18)");
        st.execute("update trade.buyorders set cid = 24 where oid = 1");
        st.execute("update trade.buyorders set sid = 24 where cid = 24");
        st.execute("update trade.buyorders set tid = 28 where oid = 1");
        st.execute("insert into trade.securities values (11)");
        conn.commit();
        st = conn2.createStatement();
        ResultSet rs = st.executeQuery("select * from trade.securities");
        CreateHDFSStoreDUnit.assertTrue((boolean)rs.next());
        CreateHDFSStoreDUnit.assertEquals((int)11, (int)rs.getInt(1));
        CreateHDFSStoreDUnit.assertFalse((boolean)rs.next());
        Object[][] expectedOutput = new Object[][]{{12, 16}, {13, 15}};
        rs = st.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        st.execute("delete from trade.customers where tid=15");
        expectedOutput = new Object[][]{{12, 16}};
        rs = st.executeQuery("select * from trade.customers where tid=16");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.customers where cid=12");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        expectedOutput = new Object[][]{{1, 10, 14, 18}};
        st.execute("insert into trade.buyorders values (1, 10, 14, 18)");
        rs = st.executeQuery("select * from trade.buyorders");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.buyorders where cid=10");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.buyorders where sid=14");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.buyorders where tid=18");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        st.execute("put into trade.buyorders values (1, 10, 14, 18)");
        conn2.commit();
        rs = st.executeQuery("select * from trade.buyorders");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.buyorders where cid=10");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.buyorders where sid=14");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs = st.executeQuery("select * from trade.buyorders where tid=18");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        conn2.commit();
        st.execute("drop table trade.buyorders");
        st.execute("drop table trade.customers");
        st.execute("drop table trade.securities");
        conn2.commit();
    }

    private SerializableRunnable execute() throws Exception {
        return new SerializableRunnable(){

            public void run() {
                try {
                    PreparedStatement pstmt = TestUtil.jdbcConn.prepareStatement("update emp.mytab1 set col2 = ? ");
                    pstmt.setInt(1, 100);
                    pstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private SerializableRunnable verifyExtensionCount(final String hdfsstore, final String extension, final boolean nonzerocount, final String tablepath) throws Exception {
        return new SerializableRunnable(){

            public void run() {
                try {
                    int extensioncount = this.getExtensioncount();
                    if (nonzerocount) {
                        TestCase.assertTrue((extensioncount > 0 ? 1 : 0) != 0);
                    } else {
                        TestCase.assertEquals((int)extensioncount, (int)0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            protected int getExtensioncount() throws Exception {
                int counter = 0;
                HDFSStoreImpl hdfsStore = GemFireCacheImpl.getInstance().findHDFSStore(hdfsstore);
                FileSystem fs = hdfsStore.getFileSystem();
                try {
                    Path basePath = new Path(hdfsStore.getHomeDir() + "/" + tablepath);
                    RemoteIterator files = fs.listFiles(basePath, true);
                    while (files.hasNext()) {
                        LocatedFileStatus next = (LocatedFileStatus)files.next();
                        if (!next.getPath().getName().endsWith(extension)) continue;
                        ++counter;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return counter;
            }
        };
    }

    private SerializableRunnable verifyDDLPersistence(final String name) {
        return new SerializableRunnable(){

            public void run() {
                ArrayList<DDLConflatable> ddlconflatables = null;
                try {
                    HDFSStoreImpl hdfsStore = Misc.getGemFireCache().findHDFSStore(name);
                    ddlconflatables = this.getDDLConflatables(hdfsStore);
                }
                catch (Exception e) {
                    Misc.getGemFireCache().getLoggerI18n().fine("EXCEPTION " + e);
                }
                TestCase.assertTrue((ddlconflatables.size() == 5 ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)ddlconflatables.get(0).getValueToConflate().startsWith("create schema"));
                TestCase.assertTrue((boolean)ddlconflatables.get(1).getValueToConflate().startsWith("create hdfsstore"));
                TestCase.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
                TestCase.assertTrue((boolean)ddlconflatables.get(3).getValueToConflate().startsWith("create alias"));
                TestCase.assertTrue((boolean)ddlconflatables.get(2).getValueToConflate().startsWith("create table"));
            }

            private ArrayList<DDLConflatable> getDDLConflatables(HDFSStoreImpl store) throws IOException, ClassNotFoundException {
                DDLHoplogOrganizer organizer = store.getDDLHoplogOrganizer();
                ArrayList ddls = organizer.getDDLStatementsForReplay().getDDLStatements();
                ArrayList<DDLConflatable> ddlconflatables = new ArrayList<DDLConflatable>();
                for (byte[] ddl : ddls) {
                    ddlconflatables.add((DDLConflatable)BlobHelper.deserializeBlob((byte[])ddl));
                }
                return ddlconflatables;
            }
        };
    }

    private SerializableRunnable verifyHDFSStoreExistence(final String name) {
        return new SerializableRunnable(){

            public void run() {
                TestCase.assertNotNull((Object)Misc.getGemFireCache().findHDFSStore(name));
            }
        };
    }

    private SerializableRunnable verifyNoHDFSStoreExistence(final String name) {
        return new SerializableRunnable(){

            public void run() {
                TestCase.assertNull((Object)Misc.getGemFireCache().findHDFSStore(name));
            }
        };
    }

    private void checkHDFSIteratorResultSet(ResultSet rs, int expectedSize) throws Exception {
        Vector<Object> v = new Vector<Object>();
        while (rs.next()) {
            v.add(rs.getObject(1));
        }
        Object[] arr = v.toArray();
        Arrays.sort(arr);
        CreateHDFSStoreDUnit.assertEquals((int)expectedSize, (int)arr.length);
        for (int i = 0; i < expectedSize; ++i) {
            CreateHDFSStoreDUnit.assertEquals((int)i, (int)((Integer)arr[i]));
        }
    }

    private void checkDirExistence(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            CreateHDFSStoreDUnit.delete(dir);
        }
    }

    private int getNumberOfMajorCompactedFiles(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            return 0;
        }
        ArrayList<String> expired = new ArrayList<String>();
        this.getExpiredMarkers(dir, expired);
        ArrayList<String> majorCompacted = new ArrayList<String>();
        this.getMajorCompactedFiles(dir, majorCompacted);
        Iterator it = majorCompacted.iterator();
        while (it.hasNext()) {
            String f = (String)it.next();
            if (!expired.contains(f + ".exp")) continue;
            it.remove();
        }
        return majorCompacted.size();
    }

    private void getExpiredMarkers(File file, List<String> expired) {
        if (file.isFile()) {
            if (!file.isHidden() && file.getName().endsWith(".exp")) {
                expired.add(file.getName());
            }
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.getExpiredMarkers(f, expired);
            }
        }
    }

    private void getMajorCompactedFiles(File file, List<String> majorCompactedFiles) {
        if (file.isFile()) {
            if (!file.isHidden() && file.getName().endsWith(".chop")) {
                majorCompactedFiles.add(file.getName());
            }
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.getMajorCompactedFiles(f, majorCompactedFiles);
            }
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

