/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.TestCase;

public class CreateDiskStoreDUnit
extends DistributedSQLTestBase {
    public CreateDiskStoreDUnit(String name) {
        super(name);
    }

    public void testDistributionOfDiskStoreCreate() throws Exception {
        int i;
        SerializableRunnable verifier;
        block9: {
            block8: {
                this.startVMs(1, 2);
                this.clientSQLExecute(1, "create diskstore TEST");
                this.sqlExecuteVerify(null, new int[]{1, 2}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist1");
                this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
                this.clientExecute(1, (Runnable)this.verifyNoDiskStoreExistence("TEST"));
                verifier = this.verifyDiskStoreExistence("TEST");
                for (int i2 = 1; i2 < 3; ++i2) {
                    this.serverExecute(i2, (Runnable)verifier);
                }
                this.startVMs(0, 1);
                this.sqlExecuteVerify(null, new int[]{3}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist1");
                this.serverExecute(3, (Runnable)verifier);
                this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select NAME from SYS.SYSDISKSTORES  ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist2");
                this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
                try {
                    this.serverSQLExecute(1, "CREATE DISKSTORE teststore1 MAXLOGSIZE 100 ('testdir1' 50)");
                    CreateDiskStoreDUnit.fail((String)"exception expected when creating with oplog size > diskdir size");
                }
                catch (RMIException re) {
                    if (re.getCause() instanceof SQLException && "X0Z33".equals(((SQLException)re.getCause()).getSQLState())) break block8;
                    throw re;
                }
            }
            try {
                this.clientSQLExecute(1, "CREATE DISKSTORE teststore1 MAXLOGSIZE 100 ('testdir1' 50)");
                CreateDiskStoreDUnit.fail((String)"exception expected when creating with oplog size > diskdir size");
            }
            catch (SQLException sqle) {
                if ("X0Z33".equals(sqle.getSQLState())) break block9;
                throw sqle;
            }
        }
        this.clientSQLExecute(1, "CREATE DISKSTORE teststore1 MAXLOGSIZE 100 ('testdir1' 150)");
        this.serverSQLExecute(3, "CREATE TABLE gfxdtest.cfg_config (id bigint NOT NULL, name varchar(255) NOT NULL, config blob NOT NULL, PRIMARY KEY (id)) EVICTION BY LRUCOUNT 1 EVICTACTION OVERFLOW PERSISTENT 'teststore1' ASYNCHRONOUS");
        this.serverSQLExecute(3, "CREATE TABLE gfxdtest.cfg_config2 (id bigint NOT NULL, name varchar(255) NOT NULL, config blob NOT NULL, PRIMARY KEY (id)) PARTITION BY PRIMARY KEY EVICTION BY LRUCOUNT 1 EVICTACTION OVERFLOW PERSISTENT 'teststore1' ASYNCHRONOUS");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TESTSTORE1' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist3");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TESTSTORE1' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
        this.clientExecute(1, (Runnable)this.verifyNoDiskStoreExistence("TESTSTORE1"));
        verifier = this.verifyDiskStoreExistence("TESTSTORE1");
        for (i = 1; i <= 3; ++i) {
            this.serverExecute(i, (Runnable)verifier);
        }
        this.startVMs(0, 1);
        this.sqlExecuteVerify(null, new int[]{4}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist1");
        this.sqlExecuteVerify(null, new int[]{4}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TESTSTORE1' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist3");
        this.serverExecute(4, (Runnable)verifier);
        this.sqlExecuteVerify(null, new int[]{1, 2, 3, 4}, "select NAME from SYS.SYSDISKSTORES", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist4");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TESTSTORE1'", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
        for (i = 1; i <= 4; ++i) {
            this.clientSQLExecute(1, "insert into gfxdtest.cfg_config values (" + i + ", 'name" + i + "', X'D" + i + "')");
            this.clientSQLExecute(1, "insert into gfxdtest.cfg_config2 values (" + i + ", 'name" + i + "', X'D" + i + "')");
        }
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select * from gfxdtest.cfg_config", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist5");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select * from gfxdtest.cfg_config2", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist5");
        this.clientSQLExecute(1, "drop diskstore test");
        this.clientSQLExecute(1, "drop table gfxdtest.cfg_config");
        this.clientSQLExecute(1, "drop table gfxdtest.cfg_config2");
        this.clientSQLExecute(1, "drop diskstore teststore1");
        for (int serverNum : new int[]{1, 2, 3, 4}) {
            this.serverExecute(serverNum, (Runnable)new SerializableRunnable(){

                public void run() {
                    String sysDirName = CreateDiskStoreDUnit.getSysDirName();
                    TestCase.assertTrue((boolean)new File(sysDirName, "testdir1").delete());
                }
            });
        }
    }

    public void testDistributionOfDiskStoreDrop() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create diskstore TEST");
        this.sqlExecuteVerify(null, new int[]{1, 2}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "ddl-dist1");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
        this.clientExecute(1, (Runnable)this.verifyNoDiskStoreExistence("TEST"));
        this.serverExecute(1, (Runnable)this.verifyDiskStoreExistence("TEST"));
        this.serverExecute(2, (Runnable)this.verifyDiskStoreExistence("TEST"));
        this.clientSQLExecute(1, "drop diskstore TEST");
        this.serverExecute(1, (Runnable)this.verifyNoDiskStoreExistence("TEST"));
        this.serverExecute(2, (Runnable)this.verifyNoDiskStoreExistence("TEST"));
        this.startVMs(0, 1);
        this.sqlExecuteVerify(null, new int[]{3}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
        this.serverExecute(3, (Runnable)this.verifyNoDiskStoreExistence("TEST"));
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST'", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
        this.sqlExecuteVerify(new int[]{1}, null, "select NAME from SYS.SYSDISKSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkDiskStore.xml", "empty");
    }

    public void testPersistDDonRecoveredClient() throws Exception {
        DistributedSQLTestBase.AsyncVM async2;
        DistributedSQLTestBase.AsyncVM async1;
        Properties props;
        block2: {
            props = new Properties();
            props.setProperty("persist-dd", "true");
            async1 = this.invokeStartServerVM(1, 0, null, props);
            async2 = this.invokeStartServerVM(2, 0, null, props);
            props.setProperty("persist-dd", "true");
            String expectedEx = "persist-dd property should be false for clients";
            props.put("test.expected-startup-exceptions", new Object[]{"Failed to start database", expectedEx});
            try {
                this.startVMs(1, 0, 0, null, props);
                CreateDiskStoreDUnit.fail((String)"Test should have failed with SQLException saying persist-dd property should be false for clients");
            }
            catch (SQLException e) {
                if (e.getCause().getMessage().startsWith(expectedEx)) break block2;
                CreateDiskStoreDUnit.fail("Got unexpected exception :", e);
            }
        }
        props.remove("test.expected-startup-exceptions");
        props.setProperty("persist-dd", "false");
        this.startVMs(1, 0, 0, null, props);
        this.joinVMs(true, async1, async2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key,DESCRIPTION varchar(1024))");
        this.clientSQLExecute(1, "insert into TESTTABLE values (1, 'ok')");
        this.stopVMNums(1);
        this.stopVMNums(-2, -1);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        this.restartVMNums(-2, -1);
        this.restartVMNums(1);
        this.joinVMs(false, async1, async2);
        this.clientSQLExecute(1, "insert into TESTTABLE values (2, 'still_ok')");
        this.clientSQLExecute(1, "drop table TESTTABLE");
    }

    public void testPersistDDOnNotConnectedClients() throws Exception {
        DistributedSQLTestBase.AsyncVM async2;
        DistributedSQLTestBase.AsyncVM async1;
        block4: {
            async1 = this.invokeStartServerVM(1, 0, null, null);
            async2 = this.invokeStartServerVM(2, 0, null, null);
            this.startVMs(1, 0, 0, null, null);
            this.joinVMs(true, async1, async2);
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key,DESCRIPTION varchar(1024))");
            this.clientSQLExecute(1, "insert into TESTTABLE values (1, 'ok')");
            this.stopVMNums(-2, -1);
            this.checkVMsDown((VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
            try {
                this.clientSQLExecute(1, "drop table TESTTABLE");
                CreateDiskStoreDUnit.fail((String)"Test should have failed with SQLException saying DDL can not be executed since no servers are available");
            }
            catch (SQLException sqle) {
                if ("X0Z08".equals(sqle.getSQLState())) break block4;
                throw sqle;
            }
        }
        try {
            this.clientSQLExecute(1, "insert into TESTTABLE values (1, 'ok')");
            CreateDiskStoreDUnit.fail((String)"Test should have failed due to lack of data stores");
        }
        catch (SQLException sqle) {
            CreateDiskStoreDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        this.restartVMNums(-2, -1);
        this.joinVMs(false, async1, async2);
        this.clientSQLExecute(1, "drop table TESTTABLE");
    }

    public void testCompatiblePersistDDOnServers() throws Exception {
        Properties props;
        block2: {
            props = new Properties();
            props.setProperty("persist-dd", "true");
            this.startVMs(0, 1, 0, null, props);
            this.startVMs(0, 1, 0, null, props);
            props.setProperty("persist-dd", "false");
            this.startVMs(1, 0, 0, null, props);
            props.setProperty("persist-dd", "false");
            String expectedExStr = "persist-dd should be same on all the servers";
            props.put("test.expected-startup-exceptions", new Object[]{"Failed to start database", "persist-dd should be same on all the servers"});
            try {
                this.startVMs(0, 1, 0, null, props);
                CreateDiskStoreDUnit.fail((String)"Test should have failed ");
            }
            catch (RMIException e) {
                if (e.getCause().getCause().getMessage().startsWith("persist-dd should be same on all the servers")) break block2;
                CreateDiskStoreDUnit.fail("Got unexpected exception :", e);
            }
        }
        props.remove("test.expected-startup-exceptions");
        props.setProperty("persist-dd", "true");
        this.startVMs(0, 1, 0, null, props);
    }

    public static SerializableRunnable createDiskStoreOnServer() throws Exception {
        SerializableRunnable createDiskStoreOnServer = new SerializableRunnable("createDiskStoreOnServer"){

            public void run() throws CacheException {
                File file1 = new File(DistributedSQLTestBase.fileSeparator + "a" + DistributedSQLTestBase.fileSeparator + "b" + DistributedSQLTestBase.fileSeparator + "c" + DistributedSQLTestBase.fileSeparator);
                File file2 = new File(DistributedSQLTestBase.fileSeparator + "a" + DistributedSQLTestBase.fileSeparator + "b" + DistributedSQLTestBase.fileSeparator + "d" + DistributedSQLTestBase.fileSeparator);
                file1.mkdirs();
                file2.mkdirs();
            }
        };
        return createDiskStoreOnServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ym_testPersistentAttributesForAccessor() throws Exception {
        Region rgn;
        Properties props = new Properties();
        props.put("host-data", "true");
        this.startVMs(0, 1, 0, null, props);
        props.put("host-data", "false");
        this.startVMs(1, 0, 0, null, props);
        Connection conn = TestUtil.getConnection(props);
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        this.serverExecute(1, (Runnable)CreateDiskStoreDUnit.createDiskStoreOnServer());
        File file1 = new File(fileSeparator + "a" + fileSeparator + "b" + fileSeparator + "c" + fileSeparator);
        File file2 = new File(fileSeparator + "a" + fileSeparator + "b" + fileSeparator + "d" + fileSeparator);
        file1.mkdirs();
        file2.mkdirs();
        File[] expectedDirs = new File[]{file1, file2};
        s.execute("create diskstore teststore ('" + file1.getPath() + "','" + file2.getPath() + "')");
        String persistentSuffix = "PERSISTENT 'teststore' ";
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   partition by range (cid) (VALUES BETWEEN 0.0 AND 99.0)  " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateDiskStoreDUnit.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateDiskStoreDUnit.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) partition by primary key   " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateDiskStoreDUnit.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) partition by column (cust_name)  " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateDiskStoreDUnit.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))PARTITION BY LIST ( tid ) ( VALUES (10, 20 ), VALUES (50, 60), VALUES (12, 34, 45)) " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateDiskStoreDUnit.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid int , cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))PARTITION BY column ( cid )  " + persistentSuffix);
        s.execute("create table trade.orders (oid decimal(30, 20), amount int,  tid int, cid int, primary key (oid))PARTITION BY column ( cid )  colocate with ( trade.customers) " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
            rgn = Misc.getRegionForTable((String)"TRADE.ORDERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.orders");
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateDiskStoreDUnit.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid int , cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))PARTITION BY column ( cid )  " + persistentSuffix);
        s.execute("create table trade.orders (oid decimal(30, 20), amount int,  tid int, cid int, primary key (oid))PARTITION BY column ( cid )  colocate with ( trade.customers) ");
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
            rgn = Misc.getRegionForTable((String)"TRADE.ORDERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.orders");
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateDiskStoreDUnit.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))replicate " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.EMPTY);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                TestUtil.deleteDir(file);
            }
        }
    }

    private void verify(Region rgn, File[] expectedDirs, DataPolicy expectedDP) {
        RegionAttributes ra = rgn.getAttributes();
        CreateDiskStoreDUnit.assertEquals((Object)expectedDP, (Object)ra.getDataPolicy());
        if (expectedDirs == null) {
            CreateDiskStoreDUnit.assertNull((Object)ra.getDiskStoreName());
            return;
        }
        File[] actualDirs = Misc.getGemFireCache().findDiskStore("TESTSTORE").getDiskDirs();
        CreateDiskStoreDUnit.assertEquals((int)actualDirs.length, (int)expectedDirs.length);
        HashSet<String> expected = new HashSet<String>(expectedDirs.length);
        for (File file : expectedDirs) {
            expected.add(file.getAbsolutePath());
        }
        for (File file : actualDirs) {
            CreateDiskStoreDUnit.assertTrue((boolean)expected.remove(file.getAbsolutePath()));
        }
        CreateDiskStoreDUnit.assertTrue((boolean)expected.isEmpty());
    }

    private void checkVMsDown(VM ... vms) {
        SerializableRunnable noGFE = new SerializableRunnable("GFE down"){

            public void run() throws CacheException {
                try {
                    CacheFactory.getAnyInstance();
                    TestCase.fail((String)"expected the cache to be closed");
                }
                catch (CacheClosedException cacheClosedException) {
                    // empty catch block
                }
                InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
                TestCase.assertNull((String)"expected the distributed system to be down", (Object)sys);
            }
        };
        for (VM vm : vms) {
            if (vm == null) {
                noGFE.run();
                continue;
            }
            vm.invoke((Runnable)noGFE);
        }
    }

    private SerializableRunnable verifyDiskStoreExistence(final String name) {
        return new SerializableRunnable(){

            public void run() {
                TestCase.assertNotNull((Object)Misc.getGemFireCache().findDiskStore(name));
            }
        };
    }

    private SerializableRunnable verifyNoDiskStoreExistence(final String name) {
        return new SerializableRunnable(){

            public void run() {
                TestCase.assertNull((Object)Misc.getGemFireCache().findDiskStore(name));
            }
        };
    }
}

