/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class ConcurrencyChecksDUnit
extends DistributedSQLTestBase {
    public ConcurrencyChecksDUnit(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        ConcurrencyChecksDUnit.invokeInEveryVM(ConcurrencyChecksDUnit.class, (String)"nullGIIRequestsTestLatch");
        ConcurrencyChecksDUnit.nullGIIRequestsTestLatch();
        ConcurrencyChecksDUnit.invokeInEveryVM(ConcurrencyChecksDUnit.class, (String)"nullGIIProcessingTestLatch");
        ConcurrencyChecksDUnit.nullGIIProcessingTestLatch();
        ConcurrencyChecksDUnit.invokeInEveryVM(ConcurrencyChecksDUnit.class, (String)"nullApplyAllSuspectsTestLatch");
        ConcurrencyChecksDUnit.nullApplyAllSuspectsTestLatch();
    }

    public void testSuspects() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.getConnection();
        String ddl = "create table APP.TEST_DIST(c1 int not null primary key, c2 int not null) replicate";
        this.runSuspects(conn, ddl);
    }

    public void testSuspects_REPLICATED_PERSISTENT() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.getConnection();
        String ddl = "create table APP.TEST_DIST(c1 int not null primary key, c2 int not null) replicate persistent";
        this.runSuspects(conn, ddl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSuspects(Connection conn, String createTableDdl) throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        Statement s = conn.createStatement();
        s.execute(createTableDdl);
        s.execute("alter table APP.TEST_DIST add constraint const_uk unique (c2)");
        s.execute("insert into APP.TEST_DIST values(1, 1)");
        VM serverVM = this.getServerVM(1);
        this.getLogWriter().info((Object)("Going to suspend GII requests in vm: " + serverVM));
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/APP/TEST_DIST"});
        try {
            async1 = this.invokeStartServerVM(1, 0, null, null);
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            try {
                s.execute("insert into APP.TEST_DIST values(2, 1)");
                ConcurrencyChecksDUnit.fail((String)"insert should have failed");
            }
            catch (SQLException se) {
                this.getLogWriter().info((Object)("failure sqlstate is on dup insert: " + se.getSQLState()), (Throwable)se);
                ConcurrencyChecksDUnit.assertTrue((boolean)"23505".equalsIgnoreCase(se.getSQLState()));
            }
            s.execute("update APP.TEST_DIST set c2 = 5 where c2 = 1");
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM newVM = null;
                    newVM = Host.getHost((int)0).getVM(1);
                    ConcurrencyChecksDUnit.this.getLogWriter().info((Object)("Going to call testMapSize on vm: " + newVM));
                    return Boolean.TRUE.equals(newVM.invoke(ConcurrencyChecksDUnit.class, "testMapSize", new Object[]{"/APP/TEST_DIST", 2}));
                }

                public String description() {
                    return "waiting for suspect events to queue up";
                }
            }, (long)180000L, (long)500L, (boolean)true);
        }
        catch (Throwable throwable) {
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.joinVM(true, async1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "nullGIIRequestsTestLatch");
        int netPort2 = this.startNetworkServer(2, null, null);
        String url2 = TestUtil.getNetProtocol(SocketCreator.getLocalHost().getHostName(), netPort2);
        Connection conn2 = DriverManager.getConnection(url2, TestUtil.getNetProperties(new Properties()));
        Statement s2 = conn2.createStatement();
        s2.execute("select * from APP.TEST_DIST");
        ResultSet rs = s2.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)rs.next());
        ConcurrencyChecksDUnit.assertEquals((int)5, (int)rs.getInt(2));
        ConcurrencyChecksDUnit.assertFalse((boolean)rs.next());
        s.execute("drop table APP.TEST_DIST");
    }

    public static Boolean testMapSize(String region, Integer size) {
        try {
            GemFireCacheImpl c = Misc.getGemFireCacheNoThrow();
            if (c == null) {
                return false;
            }
            LocalRegion lr = (LocalRegion)Misc.getRegionByPath((String)region, (boolean)false);
            if (lr == null) {
                return false;
            }
            RegionMap arm = lr.entries;
            if (arm == null) {
                return false;
            }
            Map susMap = arm.getTestSuspectMap();
            int sz = susMap != null ? susMap.size() : 0;
            return sz == size;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void suspendAllGIIRequests(Boolean giistop, String testRegionName) {
        if (giistop.booleanValue()) {
            InitialImageOperation.RequestImageMessage.testLatch = new CountDownLatch(1);
            InitialImageOperation.RequestImageMessage.testLatchWaiting = false;
            InitialImageOperation.RequestImageMessage.TEST_REGION_NAME = testRegionName;
        } else {
            InitialImageOperation.RequestImageMessage.testLatch.countDown();
        }
    }

    public static void nullGIIRequestsTestLatch() {
        InitialImageOperation.RequestImageMessage.testLatch = null;
        InitialImageOperation.RequestImageMessage.testLatchWaiting = false;
        InitialImageOperation.RequestImageMessage.TEST_REGION_NAME = null;
    }

    public static void suspendAllGIIProcessing(Boolean giistop, String testRegionName) {
        if (giistop.booleanValue()) {
            InitialImageOperation.imageProcessorTestLatch = new CountDownLatch(1);
            InitialImageOperation.imageProcessorTestLatchWaiting = false;
            InitialImageOperation.imageProcessorTEST_REGION_NAME = testRegionName;
        } else {
            InitialImageOperation.imageProcessorTestLatch.countDown();
        }
    }

    public static void nullGIIProcessingTestLatch() {
        InitialImageOperation.imageProcessorTestLatch = null;
        InitialImageOperation.imageProcessorTestLatchWaiting = false;
        InitialImageOperation.imageProcessorTEST_REGION_NAME = null;
    }

    public static Boolean testLatchWaiting() {
        return InitialImageOperation.RequestImageMessage.testLatchWaiting;
    }

    public static Boolean testLatchWaitingGIIComplete() {
        return DistributedRegion.testLatchWaiting;
    }

    public static Boolean testLatchWaitingGIIProcess() {
        return InitialImageOperation.imageProcessorTestLatchWaiting;
    }

    public static void suspendApplyAllSuspects(Boolean doSuspend, String testRegionName) {
        if (doSuspend.booleanValue()) {
            LocalRegion.applyAllSuspectTestLatch = new CountDownLatch(1);
            LocalRegion.applyAllSuspectTestLatchWaiting = false;
            LocalRegion.applyAllSuspectTEST_REGION_NAME = testRegionName;
        } else {
            LocalRegion.applyAllSuspectTestLatch.countDown();
        }
    }

    public static void nullApplyAllSuspectsTestLatch() {
        LocalRegion.applyAllSuspectTestLatch = null;
        LocalRegion.applyAllSuspectTestLatchWaiting = false;
        LocalRegion.applyAllSuspectTEST_REGION_NAME = null;
    }

    public static Boolean testLatchWaitingApplyAllSuspects() {
        return LocalRegion.applyAllSuspectTestLatchWaiting;
    }

    public void testBug48315() throws Exception {
        this.getLogWriter().info((Object)"Starting one client and two servers");
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.getLogWriter().info((Object)"Inserting data");
        st.execute("create table APP.T1_BUGTEST(id int primary key, name varchar(20), address varchar(50)) persistent replicate");
        st.execute("insert into APP.T1_BUGTEST values(1, 'name1', 'addr1')");
        st.execute("insert into APP.T1_BUGTEST values(2, 'name2', 'addr2')");
        st.execute("insert into APP.T1_BUGTEST values(3, 'name3', 'addr3')");
        st.execute("insert into APP.T1_BUGTEST values(4, 'name4', 'addr4')");
        this.getLogWriter().info((Object)"Stopping second server");
        VM vm = this.getServerVM(2);
        this.stopVMNums(-2);
        st.execute("insert into APP.T1_BUGTEST values(9, 'name9', 'addr9')");
        st.execute("insert into APP.T1_BUGTEST values(10, 'name10', 'addr10')");
        this.getLogWriter().info((Object)"Installing latch on second server");
        vm.invoke((Runnable)new SerializableRunnable(""){

            public void run() throws CacheException {
                DistributedRegion.testLatch = new CountDownLatch(1);
                DistributedRegion.testRegionName = "T1_BUGTEST";
            }
        });
        this.getLogWriter().info((Object)"Restarting second server async");
        DistributedSQLTestBase.AsyncVM asyncVM = this.restartServerVMAsync(2, 0, null, null);
        this.getLogWriter().info((Object)"Waiting until the test latch point arrives");
        ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(2);
                return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaitingGIIComplete"));
            }

            public String description() {
                return "waiting for applyAllSuspects to finish";
            }
        }, (long)180000L, (long)500L, (boolean)true);
        this.getLogWriter().info((Object)"Doing in-flight inserts");
        st.execute("insert into APP.T1_BUGTEST values(5, 'name5', 'addr5')");
        st.execute("insert into APP.T1_BUGTEST values(6, 'name6', 'addr6')");
        st.execute("insert into APP.T1_BUGTEST values(7, 'name7', 'addr7')");
        st.execute("insert into APP.T1_BUGTEST values(8, 'name8', 'addr8')");
        this.getLogWriter().info((Object)"Releasing the test latch");
        this.getServerVM(2).invoke((Runnable)new SerializableRunnable(""){

            public void run() throws CacheException {
                DistributedRegion.testLatch.countDown();
                DistributedRegion.testLatch = null;
                DistributedRegion.testLatchWaiting = false;
                DistributedRegion.testRegionName = null;
            }
        });
        this.getLogWriter().info((Object)"Waiting for the second server to restart completely");
        this.joinVM(true, asyncVM);
        this.getLogWriter().info((Object)"Verifying data on the second server");
        String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{2}, "select * from APP.T1_BUGTEST where id > 4 and id < 9", goldenTextFile, "result_t1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug48092_47945() throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table APP.T2_48092(c1 int not null primary key, c2 int not null) replicate persistent SYNCHRONOUS");
        s.execute("create index APP.INDEX1 on APP.T2_48092 (c2)");
        s.execute("insert into APP.T2_48092 values(1, 1)");
        this.stopVMNum(-2);
        VM serverVM = this.getServerVM(1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/APP/T2_48092"});
        try {
            async1 = this.restartServerVMAsync(2, 0, null, null);
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            s.execute("update APP.T2_48092 set c2 = 2");
            s.execute("update APP.T2_48092 set c2 = 3");
        }
        catch (Throwable throwable) {
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.stopVMNum(-1);
        this.joinVM(true, async1);
        s.execute("select count(*) from APP.T2_48092");
        ResultSet r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r1.getInt(1));
        s.execute("select count(*) from APP.T2_48092 where c2 > 0");
        r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r1.getInt(1));
        s.execute("select * from APP.T2_48092 where c2 > 0");
        ResultSet r2 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r2.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r2.getInt(1));
        ConcurrencyChecksDUnit.assertEquals((int)3, (int)r2.getInt(2));
        ConcurrencyChecksDUnit.assertFalse((boolean)r2.next());
    }

    public void testBug47945_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal int, tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))  REDUNDANCY 2 PERSISTENT SYNCHRONOUS");
        this.clientSQLExecute(1, "create index trade.index_1 on portfolio (subTotal asc)");
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into trade.portfolio values(?, ?, ?, ?, ?, ?)");
        for (int i = 1; i <= 17; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i * 10);
            ps.setInt(4, i * 10 - 2);
            ps.setInt(5, i * 1000);
            ps.setInt(6, i);
            ConcurrencyChecksDUnit.assertEquals((int)1, (int)ps.executeUpdate());
        }
        conn.commit();
        Statement st = conn.createStatement();
        this.stopVMNums(-3);
        st.execute("update trade.portfolio set subtotal = subtotal + 1 where cid = 12 and sid = 12 and tid = 12");
        conn.commit();
        this.restartVMNums(-3);
        this.sqlExecuteVerify(null, new int[]{3}, "select count(*) as count from trade.portfolio where subtotal = 12000 and tid = 12", null, "0");
        this.sqlExecuteVerify(null, new int[]{3}, "select count(*) as count from trade.portfolio where subtotal = 12001 and tid = 12", null, "1");
        this.sqlExecuteVerify(null, new int[]{3}, "select cid, sid, subtotal from trade.portfolio where subtotal = 12001 and tid = 12", TestUtil.getResourcesDir() + "/lib/checkIndex.xml", "testBug47945");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47945_2() throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table APP.T2_47945(c1 int not null primary key, c2 int not null) replicate persistent SYNCHRONOUS");
        s.execute("create index APP.INDEX1 on APP.T2_47945 (c2)");
        s.execute("insert into APP.T2_47945 values(1, 1)");
        this.stopVMNum(-2);
        VM serverVM = this.getServerVM(1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/APP/T2_47945"});
        try {
            async1 = this.restartServerVMAsync(2, 0, null, null);
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            s.execute("update APP.T2_47945 set c2 = 2");
            s.execute("update APP.T2_47945 set c2 = 3");
        }
        catch (Throwable throwable) {
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.stopVMNum(-1);
        this.joinVM(true, async1);
        s.execute("select count(*) from APP.T2_47945");
        ResultSet r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r1.getInt(1));
        s.execute("select count(*) from APP.T2_47945 where c2 > 0");
        r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r1.getInt(1));
        s.execute("select * from APP.T2_47945 where c2 > 0");
        ResultSet r2 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r2.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r2.getInt(1));
        ConcurrencyChecksDUnit.assertEquals((int)3, (int)r2.getInt(2));
        ConcurrencyChecksDUnit.assertFalse((boolean)r2.next());
    }

    public void testBugFKCheckReplicatePartition_44004() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table parent_partition(c1 int not null primary key, c2 int not null) partition by column(c2)");
        s.execute("create table child_replicate(cc1 int not null references parent_partition(c1), cc2 int not null) replicate");
        for (int i = 0; i < 2; ++i) {
            try {
                if (i > 0) {
                    conn.setTransactionIsolation(2);
                }
                s.execute("insert into child_replicate values(1, 1)");
                ConcurrencyChecksDUnit.fail((String)"insert should throw fk violation exception");
                continue;
            }
            catch (SQLException e) {
                ConcurrencyChecksDUnit.assertTrue((boolean)"23503".equalsIgnoreCase(e.getSQLState()));
            }
        }
    }

    public void dumpResults(int vmNum, String verifySql) throws Exception {
        InetAddress localHost = SocketCreator.getLocalHost();
        int netPort = this.startNetworkServer(vmNum, null, null);
        Connection connClient = TestUtil.getNetConnection(localHost.getHostAddress(), netPort, null, null);
        ResultSet rs = connClient.createStatement().executeQuery(verifySql);
        StringBuilder res = new StringBuilder("Result node" + vmNum + " : ");
        int count = 0;
        while (rs.next()) {
            res.append(rs.getInt(1));
            res.append(",");
            res.append(rs.getInt(2));
            res.append(",");
            res.append(rs.getString(3));
            res.append(",");
            res.append(rs.getString(4));
            res.append(";");
            ++count;
        }
        res.append("count=" + count);
        this.getLogWriter().info((Object)("viveklog:" + res));
        this.stopNetworkServer(vmNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug48725_1() throws Exception {
        this.getLogWriter().info((Object)"48725_1: Starting one client and three servers");
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.getLogWriter().info((Object)"48725_1: Inserting data");
        st.execute(" create table APP.T1_TABLE (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null,constraint sec_pk primary key (sec_id) ) ");
        st.execute("insert into APP.T1_TABLE values(1, 'name1', 'addr1')");
        st.execute("insert into APP.T1_TABLE values(2, 'name2', 'addr2')");
        st.execute("insert into APP.T1_TABLE values(3, 'name3', 'addr3')");
        st.execute("insert into APP.T1_TABLE values(4, 'name4', 'addr4')");
        st.execute("create table APP.T2_TABLE (id int primary key, fid int, name varchar(20), address varchar(50) ,constraint comp_fk foreign key (fid) references APP.T1_TABLE  (sec_id) on delete restrict) persistent replicate");
        st.execute("insert into APP.T2_TABLE values(1, 1, 'name1', 'addr1')");
        st.execute("insert into APP.T2_TABLE values(2, 2, 'name2', 'addr2')");
        st.execute("insert into APP.T2_TABLE values(3, 3, 'name3', 'addr3')");
        st.execute("insert into APP.T2_TABLE values(4, 4, 'name4', 'addr4')");
        st.execute("create index  APP.ndx_nm_addr on APP.T2_TABLE (name, address)");
        st.execute("create index  APP.ndx_id_nm_addr on APP.T2_TABLE (id, name, address)");
        this.getLogWriter().info((Object)"48725_1: Stopping second server");
        this.stopVMNums(-2);
        st.execute("update APP.T2_TABLE set name = 'name31' where id = 3 ");
        st.execute("update APP.T2_TABLE set name = 'name41' where id = 4 ");
        this.getLogWriter().info((Object)"48725_1: Installing latch on second server");
        VM serverVM = this.getServerVM(2);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", new Object[]{Boolean.TRUE, "/APP/T2_TABLE"});
        DistributedSQLTestBase.AsyncVM asyncVM = null;
        try {
            this.getLogWriter().info((Object)"48725_1: Restarting second server async");
            asyncVM = this.restartServerVMAsync(2, 0, null, null);
            this.getLogWriter().info((Object)"48725_1: Waiting until the test latch point arrives");
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(2);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaitingGIIProcess"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            this.getLogWriter().info((Object)"48725_1: Doing in-flight updates");
            st.execute("update APP.T2_TABLE set address = 'addr31' where id = 3 ");
            st.execute("update APP.T2_TABLE set address = 'addr41' where id = 4 ");
        }
        catch (Throwable throwable) {
            this.getLogWriter().info((Object)"48725_1: Releasing the test latch");
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        this.getLogWriter().info((Object)"48725_1: Releasing the test latch");
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.getLogWriter().info((Object)"48725_1: Waiting for the second server to restart completely");
        this.joinVM(true, asyncVM);
        String verifySql = "select * from APP.T2_TABLE";
        this.getLogWriter().info((Object)"48725_1: Verifying data on the second server");
        String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{2}, verifySql, goldenTextFile, "result_48725");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug48725_2() throws Exception {
        this.getLogWriter().info((Object)"48725_2: Starting one client and three servers");
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.getLogWriter().info((Object)"48725_2: Inserting data");
        st.execute("create table APP.T2_TABLE (id int primary key, fid int, name varchar(20), address varchar(50) ) persistent replicate");
        st.execute("insert into APP.T2_TABLE values(1, 1, 'name1', 'addr1')");
        st.execute("insert into APP.T2_TABLE values(2, 2, 'name2', 'addr2')");
        st.execute("insert into APP.T2_TABLE values(3, 3, 'name31', 'addr3')");
        st.execute("insert into APP.T2_TABLE values(4, 4, 'name41', 'addr4')");
        st.execute("create index  APP.ndx_nm_addr on APP.T2_TABLE (name, address)");
        st.execute("create index  APP.ndx_id_nm_addr on APP.T2_TABLE (id, name, address)");
        this.getLogWriter().info((Object)"48725_2: Stopping second server");
        this.stopVMNums(-2);
        this.getLogWriter().info((Object)"48725_2: Installing latch on second server");
        VM serverVM = this.getServerVM(2);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", new Object[]{Boolean.TRUE, "/APP/T2_TABLE"});
        DistributedSQLTestBase.AsyncVM asyncVM = null;
        try {
            this.getLogWriter().info((Object)"48725_2: Restarting second server async");
            asyncVM = this.restartServerVMAsync(2, 0, null, null);
            this.getLogWriter().info((Object)"48725_2: Waiting until the test latch point arrives");
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(2);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaitingGIIProcess"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            this.getLogWriter().info((Object)"48725_2: Doing in-flight updates");
            st.execute("update APP.T2_TABLE set address = 'addr31' where id = 3 ");
            st.execute("update APP.T2_TABLE set address = 'addr41' where id = 4 ");
        }
        catch (Throwable throwable) {
            this.getLogWriter().info((Object)"48725_2: Releasing the test latch");
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        this.getLogWriter().info((Object)"48725_2: Releasing the test latch");
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.getLogWriter().info((Object)"48725_2: Waiting for the second server to restart completely");
        this.joinVM(true, asyncVM);
        String verifySql = "select * from APP.T2_TABLE";
        this.getLogWriter().info((Object)"48725_2: Verifying data on the second server");
        String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{2}, verifySql, goldenTextFile, "result_48725");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug48725_3() throws Exception {
        this.getLogWriter().info((Object)"48725_3: Starting one client and three servers");
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.getLogWriter().info((Object)"48725_3: Inserting data");
        st.execute("create table APP.T2_TABLE (id int primary key, fid int, name varchar(20), address varchar(50) ) persistent replicate");
        st.execute("insert into APP.T2_TABLE values(1, 1, 'name1', 'addr1')");
        st.execute("insert into APP.T2_TABLE values(2, 2, 'name2', 'addr2')");
        st.execute("insert into APP.T2_TABLE values(3, 3, 'name3', 'addr3')");
        st.execute("insert into APP.T2_TABLE values(4, 4, 'name4', 'addr4')");
        st.execute("create index  APP.ndx_nm_addr on APP.T2_TABLE (name, address)");
        st.execute("create index  APP.ndx_id_nm_addr on APP.T2_TABLE (id, name, address)");
        this.getLogWriter().info((Object)"48725_3: Stopping second server");
        this.stopVMNums(-2);
        st.execute("update APP.T2_TABLE set name = 'name31' where id = 3 ");
        st.execute("update APP.T2_TABLE set name = 'name41' where id = 4 ");
        this.getLogWriter().info((Object)"48725_3: Installing latch on second server");
        VM serverVM = this.getServerVM(2);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", new Object[]{Boolean.TRUE, "/APP/T2_TABLE"});
        DistributedSQLTestBase.AsyncVM asyncVM = null;
        try {
            this.getLogWriter().info((Object)"48725_3: Restarting second server async");
            asyncVM = this.restartServerVMAsync(2, 0, null, null);
            this.getLogWriter().info((Object)"48725_3: Waiting until the test latch point arrives");
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(2);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaitingGIIProcess"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            this.getLogWriter().info((Object)"48725_3: Doing in-flight updates");
            st.execute("update APP.T2_TABLE set address = 'addr32' where id = 3 ");
            st.execute("update APP.T2_TABLE set address = 'addr42' where id = 4 ");
            st.execute("update APP.T2_TABLE set address = 'addr31' where id = 3 ");
            st.execute("update APP.T2_TABLE set address = 'addr41' where id = 4 ");
        }
        catch (Throwable throwable) {
            this.getLogWriter().info((Object)"48725_3: Releasing the test latch");
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        this.getLogWriter().info((Object)"48725_3: Releasing the test latch");
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIProcessing", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.getLogWriter().info((Object)"48725_3: Waiting for the second server to restart completely");
        this.joinVM(true, asyncVM);
        String verifySql = "select * from APP.T2_TABLE";
        this.getLogWriter().info((Object)"48725_3: Verifying data on the second server");
        String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{2}, verifySql, goldenTextFile, "result_48725");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapBug_48875_1() throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        this.configureDefaultOffHeap(true);
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table APP.T2_X(c1 int not null primary key, c2 int not null) replicate offheap");
        s.execute("create index APP.INDEX1 on APP.T2_X (c2)");
        s.execute("insert into APP.T2_X values(1, 1)");
        this.stopVMNum(-2);
        VM serverVM = this.getServerVM(1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/APP/T2_X"});
        try {
            async1 = this.restartServerVMAsync(2, 0, null, null);
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            s.execute("update APP.T2_X set c2 = 2");
            s.execute("update APP.T2_X set c2 = 3");
        }
        catch (Throwable throwable) {
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.stopVMNum(-1);
        this.joinVM(true, async1);
        s.execute("select * from APP.T2_X");
        ResultSet r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)3, (int)r1.getInt(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffHeapBug_48875_2() throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        this.configureDefaultOffHeap(true);
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table APP.T2_X1(c1 int not null primary key, c2 int not null) replicate offheap");
        s.execute("create index APP.INDEX1 on APP.T2_X1 (c2)");
        s.execute("insert into APP.T2_X1 values(1, 1)");
        this.stopVMNum(-2);
        VM serverVM = this.getServerVM(1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/APP/T2_X1"});
        try {
            async1 = this.restartServerVMAsync(2, 0, null, null);
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            s.execute("update APP.T2_X1 set c2 = 2");
            s.execute("update APP.T2_X1 set c2 = 3");
            s.execute("update APP.T2_X1 set c2 = 4");
            s.execute("insert into APP.T2_X1 values(5, 5)");
        }
        catch (Throwable throwable) {
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.stopVMNum(-1);
        this.joinVM(true, async1);
        s.execute("select * from APP.T2_X1");
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(4);
        expected.add(5);
        ResultSet r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        r1.getInt(1);
        ConcurrencyChecksDUnit.assertTrue((boolean)expected.remove(r1.getInt(2)));
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertTrue((boolean)expected.remove(r1.getInt(2)));
        ConcurrencyChecksDUnit.assertTrue((boolean)expected.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49221_1() throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        Properties props = new Properties();
        this.startVMs(1, 2, 0, null, props);
        Connection conn = TestUtil.getConnection();
        this.getLogWriter().info((Object)"49221_1: Create table and insert data");
        Statement s = conn.createStatement();
        s.execute("create table APP.T1_49221(c1 int primary key, c2 int) replicate");
        s.execute("create table APP.T2_49221(c1 int primary key, c2 int ,constraint comp_fk foreign key (c2) references APP.T1_49221  (c1) on delete restrict) replicate");
        s.execute("insert into APP.T1_49221 values(1, 1)");
        s.execute("insert into APP.T1_49221 values(2, 2)");
        s.execute("insert into APP.T2_49221 values(1, 1)");
        this.getLogWriter().info((Object)"49221_1: Stop 2nd server");
        this.stopVMNum(-2);
        VM serverVM = this.getServerVM(1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/APP/T2_49221"});
        this.getLogWriter().info((Object)"49221_1: Suspend GII request");
        try {
            async1 = this.restartServerVMAsync(2, 0, null, props);
            this.getLogWriter().info((Object)"49221_1: Second VM started request");
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            this.getLogWriter().info((Object)"49221_1: Doing in-flight insert");
            s.execute("insert into APP.T2_49221 values(2, 2)");
            this.getLogWriter().info((Object)"49221_1: Doing in-flight delete");
            s.execute("delete from APP.T2_49221 where c2 = 2");
        }
        catch (Throwable throwable) {
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.getLogWriter().info((Object)"49221_1: GII restarted");
        this.stopVMNum(-1);
        this.joinVM(true, async1);
        this.getLogWriter().info((Object)"49221_1: Verify data");
        s.execute("select count(*) from APP.T2_49221");
        ResultSet r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r1.getInt(1));
        s.execute("select count(*) from APP.T2_49221 where c2 > 0");
        r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r1.getInt(1));
        s.execute("select * from APP.T2_49221 where c2 > 0");
        ResultSet r2 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r2.next());
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r2.getInt(1));
        ConcurrencyChecksDUnit.assertEquals((int)1, (int)r2.getInt(2));
        ConcurrencyChecksDUnit.assertFalse((boolean)r2.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBug49506_1() throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        Properties props = new Properties();
        this.startVMs(1, 2, 0, null, props);
        Connection conn = TestUtil.getConnection();
        this.getLogWriter().info((Object)"49506_1: Create table and insert data");
        Statement s = conn.createStatement();
        s.execute("create table APP.T1_49506(c1 int primary key, c2 int) replicate");
        s.execute("create table APP.T2_49506(c1 int primary key, c2 int ,constraint comp_fk foreign key (c2) references APP.T1_49506  (c1) on delete restrict) replicate");
        s.execute("insert into APP.T1_49506 values(1, 1)");
        s.execute("insert into APP.T1_49506 values(2, 2)");
        s.execute("insert into APP.T1_49506 values(3, 3)");
        s.execute("insert into APP.T2_49506 values(1, 1)");
        this.getLogWriter().info((Object)"49506_1: Stop 2nd server");
        this.stopVMNum(-2);
        VM serverVM = this.getServerVM(1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/APP/T2_49506"});
        this.getLogWriter().info((Object)"49506_1: Suspend GII request");
        this.getLogWriter().info((Object)"49506_1:Installing latch on second server");
        this.getServerVM(2).invoke(ConcurrencyChecksDUnit.class, "suspendApplyAllSuspects", new Object[]{Boolean.TRUE, "/APP/T2_49506"});
        try {
            async1 = this.restartServerVMAsync(2, 0, null, props);
            this.getLogWriter().info((Object)"49506_1: Second VM started request");
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            this.getLogWriter().info((Object)"49506_1: Doing in-flight insert; val=2");
            s.execute("insert into APP.T2_49506 values(2, 2)");
        }
        catch (Throwable throwable) {
            this.getLogWriter().info((Object)"49506_1: reached finally block - 1");
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        this.getLogWriter().info((Object)"49506_1: reached finally block - 1");
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.getLogWriter().info((Object)"49506_1: GII restarted");
        try {
            this.getLogWriter().info((Object)"Waiting until applySuspects latch point arrives");
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(2);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaitingApplyAllSuspects"));
                }

                public String description() {
                    return "waiting for applyAllSuspects to finish";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            this.getLogWriter().info((Object)"49506_1: Doing in-flight insert; val=3");
            s.execute("insert into APP.T2_49506 values(3, 3)");
        }
        catch (Throwable throwable) {
            this.getLogWriter().info((Object)"49506_1: reached finally block - 2");
            this.getServerVM(2).invoke(ConcurrencyChecksDUnit.class, "suspendApplyAllSuspects", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        this.getLogWriter().info((Object)"49506_1: reached finally block - 2");
        this.getServerVM(2).invoke(ConcurrencyChecksDUnit.class, "suspendApplyAllSuspects", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.getLogWriter().info((Object)"49506_1: applyAllSuspects restarted");
        this.stopVMNum(-1);
        this.joinVM(true, async1);
        this.getLogWriter().info((Object)"49506_1: Verify data");
        s.execute("select count(*) from APP.T2_49506");
        ResultSet r1 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r1.next());
        ConcurrencyChecksDUnit.assertEquals((int)3, (int)r1.getInt(1));
        s.execute("select c1, c2 from APP.T2_49506 where c2 > 2");
        ResultSet r2 = s.getResultSet();
        ConcurrencyChecksDUnit.assertTrue((boolean)r2.next());
        ConcurrencyChecksDUnit.assertEquals((int)3, (int)r2.getInt(1));
        ConcurrencyChecksDUnit.assertFalse((boolean)r2.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug51427() throws Exception {
        DistributedSQLTestBase.AsyncVM async1;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal int, tid int, constraint portf_pk primary key (cid)) partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))  REDUNDANCY 2 PERSISTENT");
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create unique index uniq_idx on trade.portfolio(sid, tid)");
        s.execute("insert into trade.portfolio values(1, 1, 1, 1, 1, 1)");
        this.stopVMNum(-3);
        s.execute("update trade.portfolio set sid = 2 where tid = 1");
        this.stopVMNum(-2);
        VM serverVM = this.getServerVM(1);
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", new Object[]{Boolean.TRUE, "/__PR/_B__TRADE_PORTFOLIO_0"});
        try {
            async1 = this.restartServerVMAsync(3, 0, null, null);
            ConcurrencyChecksDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    VM serverVM = ConcurrencyChecksDUnit.this.getServerVM(1);
                    return Boolean.TRUE.equals(serverVM.invoke(ConcurrencyChecksDUnit.class, "testLatchWaiting"));
                }

                public String description() {
                    return "waiting for GII to start";
                }
            }, (long)180000L, (long)500L, (boolean)true);
            s.execute("insert into trade.portfolio values(2, 1, 1, 1, 1, 1)");
        }
        catch (Throwable throwable) {
            serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
            throw throwable;
        }
        serverVM.invoke(ConcurrencyChecksDUnit.class, "suspendAllGIIRequests", (Object[])new Boolean[]{Boolean.FALSE, null});
        this.joinVM(true, async1);
        this.serverExecute(3, (Runnable)new SerializableRunnable("wait for GII"){

            public void run() {
                try {
                    PartitionedRegion pr = (PartitionedRegion)GemFireCacheImpl.getExisting().getRegionByPath("/TRADE/PORTFOLIO", false);
                    pr.createBucket(0, 0, null);
                    pr.getDataStore().getCreatedBucketForId(null, 0).waitForData();
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("unexpected exception waiting for bucket region 0", e);
                }
            }
        });
        String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 3}, "select * from TRADE.PORTFOLIO where tid = 1", goldenTextFile, "result_51427");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 3}, "select * from TRADE.PORTFOLIO", goldenTextFile, "result_51427");
    }
}

