/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import com.pivotal.gemfirexd.ddl.IndexPersistenceDUnit;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.BugsTest;
import com.pivotal.gemfirexd.tools.internal.JarTools;
import com.pivotal.gemfirexd.tools.internal.MiscTools;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import udtexamples.UDTPrice;

public class BugsDUnit
extends DistributedSQLTestBase {
    private final String myjar = TestUtil.getResourcesDir() + "/lib/myjar.jar";
    private final String myfalsejar = TestUtil.getResourcesDir() + "/lib/myfalsejar.jar";
    private final String booksJar = TestUtil.getResourcesDir() + "/lib/USECASE1DAP.jar";

    public BugsDUnit(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public static void setUpCacheCloser() {
        CacheCloser cacheCloser = new CacheCloser();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)cacheCloser);
    }

    public static void unssetCacheCloser() {
        CacheCloser closer = (CacheCloser)GemFireXDQueryObserverHolder.getObserver(CacheCloser.class);
        if (closer != null) {
            BugsDUnit.assertTrue((boolean)GemFireXDQueryObserverHolder.removeObserver(CacheCloser.class));
        }
    }

    public static void setGiiExceptionSimulator(int after) {
        BugsDUnit.getGlobalLogger().info((Object)"setting Gii exception thrower");
        InitialImageOperation.giiExceptionSimulate = after > 0 ? new GIIExceptionThrower(after) : null;
    }

    public void testIndex() throws Exception {
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        this.startVMs(1, 3, 0, null, props);
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE app.t1 (c1 int not null, c2 int not null) persistent asynchronous");
        PreparedStatement ps = conn.prepareStatement("insert into app.t1 values (?, ?)");
        for (int i = 0; i < 2300000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            int cnt = ps.executeUpdate();
            BugsDUnit.assertEquals((int)1, (int)cnt);
        }
        st.execute("ALTER TABLE app.t1 ADD OPP_ID int");
        long start = System.currentTimeMillis();
        this.getLogWriter().info((Object)"Create index start");
        st.execute("create index i1 on app.t1(OPP_ID)");
        long diff = System.currentTimeMillis() - start;
        this.getLogWriter().info((Object)"Create index end");
        BugsDUnit.assertTrue((diff < 20000L ? 1 : 0) != 0);
    }

    public void testBug51039_51746() throws Throwable {
        this.reduceLogLevelForTest("config");
        Properties bprops = new Properties();
        bprops.setProperty("auth-provider", "BUILTIN");
        bprops.setProperty("gemfirexd.user.admin", "admin");
        bprops.setProperty("user", "admin");
        bprops.setProperty("password", "admin");
        bprops.setProperty(GfxdConstants.MAX_LOCKWAIT, "1000000000");
        this.startVMs(1, 3, 0, null, bprops);
        final int netPort = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        this.startNetworkServer(3, null, null);
        Properties sysProps = new Properties();
        sysProps.setProperty("user", "admin");
        sysProps.setProperty("password", "admin");
        final Properties props = new Properties();
        props.setProperty("user", "app");
        props.setProperty("password", "app");
        Connection sysConn = TestUtil.getConnection(sysProps);
        Statement sysSt = sysConn.createStatement();
        sysSt.execute("call sys.create_user('app', 'app')");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE APP.PERSON (CLNT_OBJ_ID VARCHAR(100) NOT NULL,PERS_OBJ_ID VARCHAR(100) NOT NULL) PARTITION BY COLUMN (CLNT_OBJ_ID,PERS_OBJ_ID) BUCKETS 163");
        String importDataFile = TestUtil.getResourcesDir() + "/lib/PERSON.dat";
        sysSt.execute("call syscs_util.import_data_ex('APP', 'PERSON', null,null, '" + importDataFile + "', ',', NULL, NULL, 0, 0, 8, 0, null, null)");
        try {
            Connection netConnC;
            Connection connC;
            String skipNetUrl;
            String skipUrl;
            Properties skipLocksProps;
            Thread checkNetThr;
            Thread checkThr;
            Thread ddlNetThr;
            Thread ddlThr;
            Thread queryNetThr;
            Thread queryThr;
            Throwable[] failure;
            block9: {
                block8: {
                    failure = new Throwable[1];
                    queryThr = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection conn;
                                block4: {
                                    conn = TestUtil.getNetConnection(netPort, null, props);
                                    Statement st = conn.createStatement();
                                    try {
                                        st.executeQuery("select count(*) from app.person p1, app.person p2, app.person p3 where p1.clnt_obj_id=p2.clnt_obj_id or p2.clnt_obj_id=p3.clnt_obj_id or p1.pers_obj_id=p3.pers_obj_id");
                                        TestCase.fail((String)"expected to fail with statement cancelled error");
                                    }
                                    catch (SQLException sqle) {
                                        if ("XCL56".equals(sqle.getSQLState())) break block4;
                                        throw sqle;
                                    }
                                }
                                conn.close();
                            }
                            catch (Throwable t) {
                                failure[0] = t;
                            }
                        }
                    });
                    queryNetThr = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection conn;
                                block4: {
                                    conn = TestUtil.getNetConnection(netPort, null, props);
                                    Statement st = conn.createStatement();
                                    try {
                                        st.executeQuery("select count(*) from app.person p1, app.person p2, app.person p3 where p1.clnt_obj_id=p2.clnt_obj_id or p2.clnt_obj_id=p3.clnt_obj_id or p1.pers_obj_id=p3.pers_obj_id");
                                        TestCase.fail((String)"expected to fail with statement cancelled error");
                                    }
                                    catch (SQLException sqle) {
                                        if ("XCL56".equals(sqle.getSQLState())) break block4;
                                        throw sqle;
                                    }
                                }
                                conn.close();
                            }
                            catch (Throwable t) {
                                failure[0] = t;
                            }
                        }
                    });
                    ddlThr = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection conn = TestUtil.getConnection(props);
                                Statement st = conn.createStatement();
                                st.execute("truncate table app.person");
                                conn.close();
                            }
                            catch (Throwable t) {
                                failure[0] = t;
                            }
                        }
                    });
                    ddlNetThr = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection conn = TestUtil.getNetConnection(netPort, null, props);
                                Statement st = conn.createStatement();
                                st.execute("truncate table app.person");
                                conn.close();
                            }
                            catch (Throwable t) {
                                failure[0] = t;
                            }
                        }
                    });
                    checkThr = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection conn = TestUtil.getConnection(props);
                                Statement st = conn.createStatement();
                                ResultSet rs = st.executeQuery("select count(*) from app.person");
                                TestCase.assertTrue((boolean)rs.next());
                                TestCase.assertEquals((int)0, (int)rs.getInt(1));
                                TestCase.assertFalse((boolean)rs.next());
                                conn.close();
                            }
                            catch (Throwable t) {
                                failure[0] = t;
                            }
                        }
                    });
                    checkNetThr = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection conn = TestUtil.getNetConnection(netPort, null, props);
                                Statement st = conn.createStatement();
                                ResultSet rs = st.executeQuery("select count(*) from app.person");
                                TestCase.assertTrue((boolean)rs.next());
                                TestCase.assertEquals((int)0, (int)rs.getInt(1));
                                TestCase.assertFalse((boolean)rs.next());
                                conn.close();
                            }
                            catch (Throwable t) {
                                failure[0] = t;
                            }
                        }
                    });
                    queryThr.start();
                    queryNetThr.start();
                    Thread.sleep(3000L);
                    ddlThr.start();
                    ddlNetThr.start();
                    Thread.sleep(3000L);
                    checkThr.start();
                    checkNetThr.start();
                    Thread.sleep(1000L);
                    BugsDUnit.assertTrue((boolean)queryThr.isAlive());
                    BugsDUnit.assertTrue((boolean)queryNetThr.isAlive());
                    BugsDUnit.assertTrue((boolean)ddlThr.isAlive());
                    BugsDUnit.assertTrue((boolean)ddlNetThr.isAlive());
                    BugsDUnit.assertTrue((boolean)checkThr.isAlive());
                    BugsDUnit.assertTrue((boolean)checkNetThr.isAlive());
                    skipLocksProps = new Properties();
                    skipLocksProps.setProperty("skip-locks", "true");
                    skipLocksProps.setProperty("user", "app");
                    skipLocksProps.setProperty("password", "app");
                    String hostName = SocketCreator.getLocalHost().getHostName();
                    skipUrl = TestUtil.getProtocol();
                    skipNetUrl = TestUtil.getNetProtocol(hostName, netPort);
                    try {
                        connC = DriverManager.getConnection(skipUrl, skipLocksProps);
                        BugsDUnit.fail((String)"expected auth exception expected admin user");
                    }
                    catch (SQLException sqle) {
                        if ("08004".equals(sqle.getSQLState())) break block8;
                        throw sqle;
                    }
                }
                try {
                    netConnC = DriverManager.getConnection(skipNetUrl, skipLocksProps);
                    BugsDUnit.fail((String)"expected auth exception expected admin user");
                }
                catch (SQLException sqle) {
                    if ("08004".equals(sqle.getSQLState())) break block9;
                    throw sqle;
                }
            }
            skipLocksProps.setProperty("user", "admin");
            skipLocksProps.setProperty("password", "admin");
            connC = DriverManager.getConnection(skipUrl, skipLocksProps);
            netConnC = DriverManager.getConnection(skipNetUrl, skipLocksProps);
            Statement netStmtC = netConnC.createStatement();
            ResultSet netrsC = netStmtC.executeQuery("select current_statement_uuid from sys.sessions where current_statement like '%from app.person p1%'");
            BugsDUnit.assertTrue((boolean)netrsC.next());
            String cancelId = netrsC.getString(1);
            netrsC.close();
            netStmtC.execute("call sys.cancel_statement('" + cancelId + "')");
            Thread.sleep(2000L);
            Statement stmtC = connC.createStatement();
            ResultSet rsC = stmtC.executeQuery("select current_statement_uuid from sys.sessions where current_statement like '%from app.person p1%'");
            Statement stmtC2 = connC.createStatement();
            BugsDUnit.assertTrue((boolean)rsC.next());
            do {
                stmtC2.execute("call sys.cancel_statement('" + rsC.getString(1) + "')");
            } while (rsC.next());
            connC.close();
            netConnC.close();
            queryThr.join();
            queryNetThr.join();
            ddlThr.join();
            ddlNetThr.join();
            checkThr.join();
            checkNetThr.join();
            if (failure[0] != null) {
                throw failure[0];
            }
            sysSt.execute("call syscs_util.import_data_ex('APP','PERSON',null,null,'" + importDataFile + "', ',', NULL, NULL, 0, 0, 8, 0, null, null)");
            ResultSet rs = st.executeQuery("select count(*) from app.person");
            BugsDUnit.assertTrue((boolean)rs.next());
            BugsDUnit.assertEquals((int)10000, (int)rs.getInt(1));
            BugsDUnit.assertFalse((boolean)rs.next());
            sysConn.close();
            conn.close();
        }
        catch (Throwable t) {
            this.getLogWriter().error((Object)"failed with exception", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug50207_replicated() throws Exception {
        try {
            int i;
            BugsDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"gemfire.GetInitialImage.TRACE_GII_FINER", "true"});
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create table test (c1 int not null, c2 int not null) replicate persistent");
            PreparedStatement ps = conn.prepareStatement("insert into test values(?, ?)");
            for (i = 0; i < 10; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.executeUpdate();
            }
            this.stopVMNum(-3);
            for (i = 10; i < 20; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.executeUpdate();
            }
            VM serverVM3 = (VM)this.serverVMs.get(2);
            serverVM3.invoke(BugsDUnit.class, "setGiiExceptionSimulator", new Object[]{5});
            long start = 0L;
            try {
                start = System.currentTimeMillis();
                this.restartServerVMNums(new int[]{3}, 0, null, null);
                BugsDUnit.fail((String)"Test should not have proceeded");
            }
            catch (Throwable t) {
                this.getLogWriter().info((Object)"exception during startup", t);
                long end = System.currentTimeMillis();
                long gap = end - start;
                if (gap > 60000L) {
                    BugsDUnit.fail((String)"Gap of greater than a minute. Something fishy");
                }
            }
        }
        catch (Throwable throwable) {
            BugsDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"gemfire.GetInitialImage.TRACE_GII_FINER", "false"});
            VM serverVM3 = (VM)this.serverVMs.get(2);
            serverVM3.invoke(BugsDUnit.class, "setGiiExceptionSimulator", new Object[]{0});
            throw throwable;
        }
        BugsDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"gemfire.GetInitialImage.TRACE_GII_FINER", "false"});
        VM serverVM3 = (VM)this.serverVMs.get(2);
        serverVM3.invoke(BugsDUnit.class, "setGiiExceptionSimulator", new Object[]{0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug50207_partitioned() throws Exception {
        try {
            int i;
            BugsDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"gemfire.GetInitialImage.TRACE_GII_FINER", "true"});
            this.startVMs(1, 2);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create table test (c1 int not null, c2 int not null) buckets 1 redundancy 1 persistent");
            PreparedStatement ps = conn.prepareStatement("insert into test values(?, ?)");
            for (i = 0; i < 10; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.executeUpdate();
            }
            this.stopVMNum(-2);
            for (i = 10; i < 20; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.executeUpdate();
            }
            VM serverVM2 = (VM)this.serverVMs.get(1);
            serverVM2.invoke(BugsDUnit.class, "setGiiExceptionSimulator", new Object[]{5});
            long start = 0L;
            try {
                start = System.currentTimeMillis();
                this.restartServerVMNums(new int[]{2}, 0, null, null);
                BugsDUnit.fail((String)"Test should not have proceeded");
            }
            catch (Throwable t) {
                this.getLogWriter().info((Object)"exception during startup", t);
                long end = System.currentTimeMillis();
                long gap = end - start;
                if (gap > 60000L) {
                    BugsDUnit.fail((String)"Gap of greater than a minute. Something fishy");
                }
            }
        }
        catch (Throwable throwable) {
            BugsDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"gemfire.GetInitialImage.TRACE_GII_FINER", "false"});
            VM serverVM3 = (VM)this.serverVMs.get(1);
            serverVM3.invoke(BugsDUnit.class, "setGiiExceptionSimulator", new Object[]{0});
            throw throwable;
        }
        BugsDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"gemfire.GetInitialImage.TRACE_GII_FINER", "false"});
        VM serverVM3 = (VM)this.serverVMs.get(1);
        serverVM3.invoke(BugsDUnit.class, "setGiiExceptionSimulator", new Object[]{0});
    }

    public void testBug48343() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table trade.customers(id int not null primary key, name varchar(20) not null, addr varchar(20) not null) partition by primary key persistent redundancy 1");
        st.execute("insert into trade.customers values(1, 'one', 'addr_1'), (2, 'two', 'addr_2')");
        this.stopVMNums(-2);
        st.execute("delete from trade.customers where id = 2");
        st.execute("insert into trade.customers values(3, 'three', 'addr_3')");
        st.execute("delete from trade.customers where id = 3");
        this.restartVMNums(-2);
        st.execute("call sys.rebalance_all_buckets();");
        this.stopVMNums(-1);
        st.execute("select * from trade.customers");
        ResultSet rs = st.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)1, (int)rs.getInt(1));
        BugsDUnit.assertFalse((boolean)rs.next());
        st.execute("select count(*) from trade.customers");
        rs = st.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)1, (int)rs.getInt(1));
        BugsDUnit.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void testBug48335() throws Exception {
        this.reduceLogLevelForTest("config");
        this.startVMs(0, 3, 0, "sync", null);
        this.startVMs(1, 0);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        dbPort = AvailablePort.getRandomAvailablePort((int)0);
        netServer = DBSynchronizerTestBase.startNetworkServer(dbPort);
        derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + dbPort + "/newDB3;";
        dbConn = DriverManager.getConnection(derbyDbUrl + "create=true");
        dbSt = dbConn.createStatement();
        partClause = "partition by COLUMN ( name ) REDUNDANCY 2 PERSISTENT";
        replClause = "replicate PERSISTENT";
        createDBSync = "create asynceventlistener T_3_SYNC(listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams  'org.apache.derby.jdbc.ClientDriver," + derbyDbUrl + "' ENABLEPERSISTENCE true MANUALSTART false ALERTTHRESHOLD 240000) " + "SERVER GROUPS(sync)";
        createDBSync2 = "create asynceventlistener T_3_SYNC(listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams  'org.apache.derby.jdbc.ClientDriver," + derbyDbUrl + "' ENABLEPERSISTENCE true MANUALSTART true ALERTTHRESHOLD 240000) " + "SERVER GROUPS(sync)";
        try {
            st.execute("CREATE TABLE t.t_3_1_1(name varchar(16) primary key, remark varchar(20)) partition by COLUMN ( name ) REDUNDANCY 2 PERSISTENT");
            st.execute("CREATE TABLE t.t_3_1_2(name varchar(16) primary key, remark varchar(20)) replicate PERSISTENT");
            st.execute(createDBSync2);
            st.execute("CREATE INDEX t_remark_idx on t.t_3_1_1(remark)");
            st.execute("CREATE INDEX t_remark_idx2 on t.t_3_1_2(remark)");
            dbSt.execute("CREATE TABLE t.t_3_1_1(name varchar(16) primary key, remark varchar(20))");
            dbSt.execute("CREATE TABLE t.t_3_1_2(name varchar(16) primary key, remark varchar(20))");
            st.execute("call sys.start_async_event_listener('T_3_SYNC')");
            st.execute("ALTER TABLE t.t_3_1_1 set asynceventlistener (t_3_sync)");
            st.execute("ALTER TABLE t.t_3_1_2 set asynceventlistener (t_3_sync)");
            ps = conn.prepareStatement("insert into t.t_3_1_1 values (?, ?)");
            ps12 = conn.prepareStatement("insert into t.t_3_1_2 values (?, ?)");
            num = 10000;
            for (i = 1; i <= 10000; ++i) {
                key = "N" + i;
                ps.setString(1, key);
                ps.setString(2, "Remark" + i);
                ps.addBatch();
                ps12.setString(1, key);
                ps12.setString(2, "Remark" + i);
                ps12.addBatch();
                if (i % 100 != 0) continue;
                res = ps.executeBatch();
                BugsDUnit.assertEquals((int)100, (int)res.length);
                res = ps12.executeBatch();
                BugsDUnit.assertEquals((int)100, (int)res.length);
            }
            this.addExpectedException((int[])null, new int[]{1, 2, 3}, new Object[]{SQLNonTransientConnectionException.class, CacheClosedException.class, RegionDestroyedException.class});
            this.stopVMNums(new int[]{-1, -2});
            st.execute("drop table t.t_3_1_1");
            st.execute("drop table t.t_3_1_2");
            st.execute("drop asynceventlistener t_3_sync");
            dbSt.execute("drop table t.t_3_1_1");
            dbSt.execute("drop table t.t_3_1_2");
            this.restartVMNums(new int[]{-1}, 0, "sync", null);
            netPort = this.startNetworkServer(1, null, null);
            conn2 = TestUtil.getNetConnection(netPort, null, null);
            st2 = conn2.createStatement();
            st2.execute("CREATE TABLE t.t_3_1_1(name varchar(16) primary key, remark varchar(20)) partition by COLUMN ( name ) REDUNDANCY 2 PERSISTENT");
            st.execute("CREATE TABLE t.t_3_1_2(name varchar(16) primary key, remark varchar(20)) replicate PERSISTENT");
            st2.execute(createDBSync);
            st.execute("ALTER TABLE t.t_3_1_1 set asynceventlistener (t_3_sync)");
            st.execute("ALTER TABLE t.t_3_1_2 set asynceventlistener (t_3_sync)");
            st.execute("CREATE INDEX t_remark_idx on t.t_3_1_1(remark)");
            st2.execute("CREATE INDEX t_remark_idx2 on t.t_3_1_2(remark)");
            dbSt.execute("CREATE TABLE t.t_3_1_1(name varchar(16) primary key, remark varchar(20))");
            dbSt.execute("CREATE TABLE t.t_3_1_2(name varchar(16) primary key, remark varchar(20))");
            ps2 = conn2.prepareStatement("insert into t.t_3_1_1 values (?, ?)");
            ps22 = conn2.prepareStatement("insert into t.t_3_1_2 values (?, ?)");
            for (i = 1; i <= 10000; ++i) {
                key = "N" + i;
                ps2.setString(1, key);
                ps2.setString(2, "Remark" + i);
                ps2.addBatch();
                ps22.setString(1, key);
                ps22.setString(2, "Remark" + i);
                ps22.addBatch();
                if (i % 100 != 0) continue;
                res = ps2.executeBatch();
                BugsDUnit.assertEquals((int)100, (int)res.length);
                res = ps22.executeBatch();
                BugsDUnit.assertEquals((int)100, (int)res.length);
            }
            st.execute("alter table t.t_3_1_1 set asynceventlistener ()");
            st.execute("alter table t.t_3_1_2 set asynceventlistener ()");
            st2.execute("drop asynceventlistener t_3_sync");
            dbSt.execute("drop table t.t_3_1_1");
            dbSt.execute("drop table t.t_3_1_2");
            st2.execute("drop table t.t_3_1_1");
            st.execute("drop table t.t_3_1_2");
            st.execute("CREATE TABLE t.t_3_1_1(name varchar(16) primary key, remark varchar(20)) partition by COLUMN ( name ) REDUNDANCY 2 PERSISTENT");
            st2.execute("CREATE TABLE t.t_3_1_2(name varchar(16) primary key, remark varchar(20)) replicate PERSISTENT");
            st2.execute("CREATE INDEX t_remark_idx on t.t_3_1_1(remark)");
            st.execute("CREATE INDEX t_remark_idx2 on t.t_3_1_2(remark)");
            dbSt.execute("CREATE TABLE t.t_3_1_1(name varchar(16) primary key, remark varchar(20))");
            dbSt.execute("CREATE TABLE t.t_3_1_2(name varchar(16) primary key, remark varchar(20))");
            st2.execute(createDBSync2);
            st.execute("ALTER TABLE t.t_3_1_1 set asynceventlistener (t_3_sync)");
            st.execute("ALTER TABLE t.t_3_1_2 set asynceventlistener (t_3_sync)");
            st.execute("call sys.start_async_event_listener('T_3_SYNC')");
            this.restartVMNums(new int[]{-2}, 0, "sync", null);
            netPort2 = this.startNetworkServer(2, null, null);
            conn3 = TestUtil.getNetConnection(netPort2, null, null);
            this.addExpectedException((int[])null, new int[]{1, 2, 3}, new Object[]{SQLNonTransientConnectionException.class, CacheClosedException.class, RegionDestroyedException.class});
            netServer.shutdown();
            while (true) lbl-1000:
            // 2 sources

            {
                Thread.sleep(500L);
                try {
                    netServer.ping();
                    continue;
                }
                catch (Exception e) {
                    ps3 = conn3.prepareStatement("insert into t.t_3_1_1 values (?, ?)");
                    ps32 = conn3.prepareStatement("insert into t.t_3_1_2 values (?, ?)");
                    keys = new THashSet(10000);
                    for (i = 1; i <= 10000; ++i) {
                        key = "N" + i;
                        ps3.setString(1, key);
                        ps3.setString(2, "Remark" + i);
                        ps3.addBatch();
                        ps32.setString(1, key);
                        ps32.setString(2, "Remark" + i);
                        ps32.addBatch();
                        keys.add((Object)key);
                        if (i % 100 != 0) continue;
                        res = ps3.executeBatch();
                        BugsDUnit.assertEquals((int)100, (int)res.length);
                        res = ps32.executeBatch();
                        BugsDUnit.assertEquals((int)100, (int)res.length);
                    }
                    allKeys = Collections.unmodifiableSet(new THashSet((Collection)keys));
                    rs = st.executeQuery("select * from t.t_3_1_1");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = st.executeQuery("select * from t.t_3_1_1 where remark > 'Remark'");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = st.executeQuery("select * from t.t_3_1_2");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = st.executeQuery("select * from t.t_3_1_2 where remark > 'Remark'");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    this.stopVMNums(new int[]{-1, -3});
                    st.execute("call sys.rebalance_all_buckets()");
                    this.stopVMNums(new int[]{-2});
                    netServer.start(SanityManager.GET_DEBUG_STREAM());
                    while (true) {
                        Thread.sleep(500L);
                        try {
                            netServer.ping();
                        }
                        catch (Exception var28_31) {
                            continue;
                        }
                        break;
                    }
                    this.restartVMNums(new int[]{-2}, 0, "sync", null);
                    this.restartVMNums(new int[]{-1, -3});
                    this.removeExpectedException((int[])null, new int[]{1, 2, 3}, new Object[]{SQLNonTransientConnectionException.class, CacheClosedException.class, RegionDestroyedException.class});
                    keys.addAll(allKeys);
                    rs = st.executeQuery("select * from t.t_3_1_1");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = st.executeQuery("select * from t.t_3_1_1 where remark > 'Remark'");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = st.executeQuery("select * from t.t_3_1_2");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = st.executeQuery("select * from t.t_3_1_2 where remark > 'Remark'");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    st.execute("call sys.wait_for_sender_queue_flush('t_3_sync', 1, 0)");
                    try {
                        dbConn.close();
                    }
                    catch (Exception var28_32) {
                        // empty catch block
                    }
                    dbConn = DriverManager.getConnection(derbyDbUrl);
                    dbSt = dbConn.createStatement();
                    keys.addAll(allKeys);
                    rs = dbSt.executeQuery("select * from t.t_3_1_1");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = dbSt.executeQuery("select * from t.t_3_1_1 where remark > 'Remark'");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = dbSt.executeQuery("select * from t.t_3_1_2");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    keys.addAll(allKeys);
                    rs = dbSt.executeQuery("select * from t.t_3_1_2 where remark > 'Remark'");
                    while (rs.next()) {
                        key = rs.getString(1);
                        BugsDUnit.assertTrue((boolean)keys.remove((Object)key));
                    }
                    BugsDUnit.assertEquals((int)0, (int)keys.size());
                    st.execute("drop table t.t_3_1_1");
                    st.execute("drop table t.t_3_1_2");
                    dbSt.execute("drop table t.t_3_1_1");
                    dbSt.execute("drop table t.t_3_1_2");
                    dbConn.close();
                    try {
                        netServer.shutdown();
                    }
                    catch (Exception var12_13) {}
                }
                break;
            }
        }
        catch (Throwable var29_34) {
            try {
                netServer.shutdown();
            }
            catch (Exception var30_35) {
                // empty catch block
            }
            throw var29_34;
        }
        {
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertFailoverbug_47407() throws Exception {
        try {
            this.startVMs(0, 2, 0, null, null);
            int netPort = this.startNetworkServer(1, null, null);
            this.startNetworkServer(2, null, null);
            this.startNetworkServer(3, null, null);
            VM vm1 = this.getServerVM(1);
            vm1.invoke(BugsDUnit.class, "setUpCacheCloser");
            VM vm2 = this.getServerVM(2);
            vm2.invoke(BugsDUnit.class, "setUpCacheCloser");
            VM vm3 = this.getServerVM(3);
            vm3.invoke(BugsDUnit.class, "setUpCacheCloser");
            InetAddress localHost = SocketCreator.getLocalHost();
            Connection connClient = TestUtil.getNetConnection(localHost.getHostAddress(), netPort, null, null);
            connClient.createStatement().execute("create schema trade");
            Statement s = connClient.createStatement();
            s.execute("set current schema trade");
            s.execute("create table trade.customers(cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid))");
            PreparedStatement psInsert = connClient.prepareStatement("insert into trade.customers values(?, ?, ?, ?)");
            for (int i = 0; i < 1; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setString(3, "addr" + i);
                psInsert.setInt(4, i);
                psInsert.addBatch();
            }
            try {
                int[] res = psInsert.executeBatch();
                this.getLogWriter().info((Object)("KN: result of batch insert: " + res + " length: " + res.length + " 1st element: " + (res.length > 0 ? Integer.valueOf(res[0]) : "nothing")));
                BugsDUnit.fail((String)"insert should not get past this point");
            }
            catch (Exception ex) {
                this.getLogWriter().info((Object)"got exception", (Throwable)ex);
            }
        }
        finally {
            VM vm1 = this.getServerVM(1);
            vm1.invoke(BugsDUnit.class, "unssetCacheCloser");
            VM vm2 = this.getServerVM(2);
            vm2.invoke(BugsDUnit.class, "unssetCacheCloser");
            VM vm3 = this.getServerVM(3);
            vm3.invoke(BugsDUnit.class, "unssetCacheCloser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47148() throws Exception {
        Properties p = new Properties();
        int netPort = this.startNetworkServer(1, null, p);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        boolean secondServerStarted = false;
        try {
            Statement s = conn.createStatement();
            s.execute("Create Table TEST_TABLE(idx numeric(12),AccountID varchar(10),OrderNo varchar(20),primary key(idx))PARTITION BY COLUMN ( AccountID )");
            s.execute("CREATE INDEX idx_AccountID ON test_Table (AccountID ASC)");
            PreparedStatement insps = conn.prepareStatement("insert into test_table values(?,?,?)");
            insps.setInt(1, 9);
            insps.setString(2, "8");
            insps.setString(3, "8");
            insps.executeUpdate();
            String query = "select accountid from test_table where accountid like '8'";
            ResultSet rs = conn.createStatement().executeQuery(query);
            int num = 0;
            while (rs.next()) {
                ++num;
                BugsDUnit.assertEquals((String)"8", (String)rs.getString(1));
            }
            BugsDUnit.assertEquals((int)1, (int)num);
            rs.close();
        }
        finally {
            this.stopNetworkServer(1);
        }
    }

    public void testBug46584() throws Exception {
        this.startVMs(1, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort1);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate");
        st.execute("create view trade.securities_vw (sec_id, symbol, exchange) as select sec_id, symbol, exchange from trade.securities");
        st.execute("insert into trade.securities values (1, 'VMW', 'nye')");
        st.execute("select length(symbol) from trade.securities_vw where symbol = 'VMW'");
        rs = st.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)3, (int)rs.getInt(1));
        st.execute("select length(symbol) from trade.securities_vw where symbol = 'VMW '");
        rs = st.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)3, (int)rs.getInt(1));
        st.execute("insert into trade.securities values (2, 'EMC ', 'nye')");
        st.execute("select length(symbol) from trade.securities_vw where symbol = 'EMC'");
        rs = st.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)4, (int)rs.getInt(1));
        st.execute("select length(symbol) from trade.securities_vw where symbol = 'EMC '");
        rs = st.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)4, (int)rs.getInt(1));
    }

    public void testDAPBugsFromUseCase1() throws Exception {
        this.startVMs(0, 2, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        Connection conn = null;
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        conn = DriverManager.getConnection(url, TestUtil.getNetProperties(new Properties()));
        Statement s = conn.createStatement();
        s.execute("CREATE TABLE APP.BOOKS(ID VARCHAR(10) NOT NULL, NAME VARCHAR(25), TAG VARCHAR(25), SIZE BIGINT, LOCATION VARCHAR(25), CONSTRAINT BOOK_PK PRIMARY KEY (ID)) PARTITION BY PRIMARY KEY REDUNDANCY 1 EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW PERSISTENT ASYNCHRONOUS");
        s.execute("insert into APP.BOOKS values ('1', 'Spring1','TAG1',20,'Mumbai')");
        s.execute("insert into APP.BOOKS values ('2', 'Spring2','TAG2',10,'Pune')");
        s.execute("insert into APP.BOOKS values ('3', 'Spring3','TAG3',15,'Bangalore')");
        s.execute("insert into APP.BOOKS values ('4', 'Spring4','TAG4',20,'Chennai')");
        s.execute("insert into APP.BOOKS values ('5', 'Spring5','TAG5',10,'calcutta')");
        s.execute("insert into APP.BOOKS values ('6', 'Spring6','TAG6',15,'Bhubaneswar')");
        s.execute("insert into APP.BOOKS values ('7', 'Spring7','TAG7',20,'Delhi')");
        s.execute("insert into APP.BOOKS values ('8', 'Spring8','TAG8',10,'Cuttack')");
        s.execute("insert into APP.BOOKS values ('9', 'Spring9','TAG9',15,'Balangir')");
        s.execute("insert into APP.BOOKS values ('10', 'Spring10','TAG10',20,'Baleswar')");
        s.execute("insert into APP.BOOKS values ('11', 'Spring11','TAG11',10,'Phulbani')");
        s.execute("insert into APP.BOOKS values ('12', 'Spring12','TAG12',15,'Purushoottampur')");
        s.execute("insert into APP.BOOKS values ('13', 'Spring13','TAG13',20,'Puri')");
        s.execute("insert into APP.BOOKS values ('14', 'Spring14','TAG14',10,'Pipili')");
        s.execute("insert into APP.BOOKS values ('15', 'Spring15','TAG15',15,'Keondujhar')");
        s.execute("insert into APP.BOOKS values ('16', 'Spring16','TAG16',20,'Sundargarh')");
        s.execute("insert into APP.BOOKS values ('17', 'Spring17','TAG17',10,'Baripada')");
        s.execute("insert into APP.BOOKS values ('18', 'Spring18','TAG18',15,'Paradip')");
        s.execute("insert into APP.BOOKS values ('19', 'Spring19','TAG19',20,'Parlakhemundi')");
        s.execute("insert into APP.BOOKS values ('20', 'Spring20','TAG20',10,'Gunpur')");
        s.execute("insert into APP.BOOKS values ('21', 'Spring21','TAG21',15,'Aska')");
        s.execute("CALL SQLJ.INSTALL_JAR('" + this.booksJar + "', 'APP.GFXD_LISTBOOKSP', 0);");
        s.execute("CREATE PROCEDURE LIST_BOOKS(IN ID VARCHAR(100) ) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.vfabric.booksdb.storedproc.ListBooksStoreProc.execute'");
        CallableStatement stmt = conn.prepareCall("CALL LIST_BOOKS(?)");
        System.out.println("1.--------- CALL LIST_BOOKS(?): with valid ID : ID=10 ------");
        this.getLogWriter().info((Object)"expecting single valid value for 10 ... no extension ... local execution");
        BugsDUnit.callStoredProc(stmt, "10", true, false);
        this.getLogWriter().info((Object)"expecting no valid value for 111 ... no extension ... local execution");
        BugsDUnit.callStoredProc(stmt, "111", false, false);
        CallableStatement stmtOnAll = conn.prepareCall("{CALL LIST_BOOKS(?) ON ALL}");
        this.getLogWriter().info((Object)"expecting duplicate valid value for 10 ... on all extension");
        BugsDUnit.callStoredProc(stmtOnAll, "10", true, true);
        this.getLogWriter().info((Object)"expecting no valid value for 111 ... on all extension");
        BugsDUnit.callStoredProc(stmtOnAll, "111", false, false);
        CallableStatement stmtWithDefaultRP = conn.prepareCall("{CALL LIST_BOOKS(?) WITH RESULT PROCESSOR com.pivotal.gemfirexd.internal.engine.procedure.coordinate.DefaultProcedureResultProcessor}");
        this.getLogWriter().info((Object)"expecting single valid value for 10 ... only default processor ... local execution");
        BugsDUnit.callStoredProc(stmtWithDefaultRP, "10", true, false);
        this.getLogWriter().info((Object)"expecting no valid value for 111 ... only default processor ... local execution");
        BugsDUnit.callStoredProc(stmtWithDefaultRP, "111", false, false);
        CallableStatement stmtWithCustomRP = conn.prepareCall("{CALL LIST_BOOKS(?) WITH RESULT PROCESSOR com.pivotal.vfabric.booksdb.storedproc.ListBookResultProcessor}");
        this.getLogWriter().info((Object)"expecting single valid value for 10 ... only custom processor ... local execution");
        BugsDUnit.callStoredProc(stmtWithCustomRP, "10", true, false);
        this.getLogWriter().info((Object)"expecting no valid value for 111 ... only custom processor ... local execution");
        BugsDUnit.callStoredProc(stmtWithCustomRP, "111", false, false);
        s.execute("create alias myprocessor for 'com.pivotal.vfabric.booksdb.storedproc.ListBookResultProcessor'");
        CallableStatement stmtWithAliasRP = conn.prepareCall("{CALL LIST_BOOKS(?) WITH RESULT PROCESSOR myprocessor}");
        this.getLogWriter().info((Object)"expecting single valid value for 10 ... only default processor(alias) ... local execution");
        BugsDUnit.callStoredProc(stmtWithAliasRP, "10", true, false);
        this.getLogWriter().info((Object)"expecting no valid value for 111 ... only default processor(alias) ... local execution");
        BugsDUnit.callStoredProc(stmtWithAliasRP, "111", false, false);
        CallableStatement stmtWithCustomRPAndOnALL = conn.prepareCall("{CALL LIST_BOOKS(?) WITH RESULT PROCESSOR com.pivotal.vfabric.booksdb.storedproc.ListBookResultProcessor ON ALL}");
        this.getLogWriter().info((Object)"expecting duplicate valid value for 10 ... only custom processor ... local execution");
        BugsDUnit.callStoredProc(stmtWithCustomRPAndOnALL, "10", true, true);
    }

    public void testBucketIdNotFoundUseCase1_47210() throws Exception {
        this.startVMs(0, 2, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        TestUtil.loadNetDriver();
        Connection conn = null;
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        conn = DriverManager.getConnection(url, new Properties());
        Statement s = conn.createStatement();
        s.execute("create table Parent_1 (txn_id varchar(26) not null, dummy1 int, dummy2 smallint, constraint prnt_pk primary key(txn_id))  partition by primary key redundancy 1 eviction by lruheappercent evictaction overflow persistent asynchronous");
        s.execute("create table Parent_Hist (ts timestamp with default current_timestamp, txn_id varchar(26) not null, dummy1 int, dummy2 smallint)  partition by column (txn_id) colocate with (Parent_1) redundancy 1 eviction by lruheappercent evictaction overflow persistent asynchronous");
        s.execute("insert into parent_1 values ('one', 1, 1), ('two', 2,2), ('three', 3,3)");
        s.execute("insert into parent_hist (txn_id, dummy1, dummy2) values ('one', 1, 1), ('two', 2,2), ('three', 3,3)");
        s.execute("create table Parent_RAW (txn_id varchar(26) not null, dummy1 int, dummy2 smallint, constraint prnt_raw_pk primary key(txn_id))  partition by primary key colocate with (parent_1) redundancy 1");
        s.execute("create table Parent_RAW2 (txn_id varchar(26) not null, dummy1 int, dummy2 smallint, constraint prnt_raw_pk2 primary key(txn_id))  partition by primary key colocate with (parent_1) redundancy 1 eviction by lruheappercent evictaction overflow persistent asynchronous");
        this.stopVMNums(-1, -2);
        this.restartVMNums(-1, -2);
        netPort = this.startNetworkServer(1, null, null);
        TestUtil.loadNetDriver();
        conn = null;
        url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        conn = DriverManager.getConnection(url, new Properties());
        s = conn.createStatement();
        PreparedStatement pstmt = conn.prepareStatement("delete from parent_raw where txn_id in (select txn_id from parent_1 where dummy2 > ?)");
        int rowsAffected = s.executeUpdate("delete from parent_raw where txn_id in (select txn_id from parent_1 where dummy2 > 0)");
        BugsDUnit.assertEquals((int)0, (int)rowsAffected);
        pstmt.setInt(1, 0);
        rowsAffected = pstmt.executeUpdate();
        BugsDUnit.assertEquals((int)0, (int)rowsAffected);
        s.execute("insert into Parent_RAW values ('one', 1, 1)");
        rowsAffected = s.executeUpdate("delete from parent_raw where txn_id in (select txn_id from parent_1 where dummy2 > 0)");
        BugsDUnit.assertEquals((int)1, (int)rowsAffected);
        s.execute("insert into Parent_RAW values ('one', 1, 1)");
        rowsAffected = pstmt.executeUpdate();
        BugsDUnit.assertEquals((int)1, (int)rowsAffected);
        pstmt = conn.prepareStatement("delete from parent_raw2 where txn_id in (select txn_id from parent_1 where dummy2 > ?)");
        rowsAffected = s.executeUpdate("delete from parent_raw2 where txn_id in (select txn_id from parent_1 where dummy2 > 0)");
        BugsDUnit.assertEquals((int)0, (int)rowsAffected);
        pstmt.setInt(1, 0);
        rowsAffected = pstmt.executeUpdate();
        BugsDUnit.assertEquals((int)0, (int)rowsAffected);
        s.execute("insert into Parent_RAW2 values ('one', 1, 1)");
        rowsAffected = s.executeUpdate("delete from parent_raw2 where txn_id in (select txn_id from parent_1 where dummy2 > 0)");
        BugsDUnit.assertEquals((int)1, (int)rowsAffected);
        s.execute("insert into Parent_RAW2 values ('one', 1, 1)");
        rowsAffected = pstmt.executeUpdate();
        BugsDUnit.assertEquals((int)1, (int)rowsAffected);
    }

    private static void callStoredProc(CallableStatement stmt, String id, boolean resultExpected, boolean dupsExpected) throws Exception {
        BugsDUnit.getGlobalLogger().info((Object)("callStoredProc called with id: , resultExpected: " + resultExpected + ", dupsExpected: " + dupsExpected));
        int count = 0;
        stmt.setString(1, id);
        stmt.execute();
        ResultSet rs = stmt.getResultSet();
        while (rs.next()) {
            ++count;
        }
        if (resultExpected) {
            BugsDUnit.assertTrue((count > 0 ? 1 : 0) != 0);
            BugsDUnit.getGlobalLogger().info((Object)("callStoredProc called with id: , resultExpected assertion through with count: " + count));
        }
        if (dupsExpected) {
            BugsDUnit.assertEquals((int)2, (int)count);
            BugsDUnit.getGlobalLogger().info((Object)("callStoredProc called with id: , dupsExpected assertion through with count: " + count));
        }
    }

    public void testBug43115() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table test_table (id int primary key, val int) partition by (id) redundancy 1");
        PreparedStatement ps = conn.prepareStatement("insert into test_table values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 100 + i);
            ps.executeUpdate();
        }
        st.execute("insert into test_table values (10, 100)");
        st.execute("insert into test_table values (11, 100)");
        ResultSet rs = st.executeQuery("select * from test_table where id in (0, 10, 11)");
        int count = 0;
        while (rs.next()) {
            ++count;
            System.out.println("#43115 result=" + rs.getInt(1) + "\t" + rs.getInt(2));
        }
        BugsDUnit.assertEquals((int)3, (int)count);
    }

    public void testBug43290_precisionProblemWithDecimals() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (balance decimal(12,2))");
        s.execute("insert into t1 values(0.0)");
        s.execute("update t1 set balance = 5559.09");
        s.execute("update t1 set balance = balance + 1596.15");
        s.execute("select balance from t1");
        ResultSet rs = s.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((Object)7155.24, (Object)rs.getDouble(1));
    }

    public void testGfxdJarCommands() throws Exception {
        PreparedStatement mergeCS;
        String sql;
        Statement st;
        Connection conn;
        int netPort;
        String locatorBindAddress;
        block6: {
            Properties serverProps;
            block5: {
                Properties locatorProps = new Properties();
                this.setMasterCommonProperties(locatorProps);
                locatorBindAddress = SocketCreator.getLocalHost().getHostName();
                int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
                BugsDUnit._startNewLocator(((Object)((Object)this)).getClass().getName(), this.getName(), locatorBindAddress, locatorPort, null, locatorProps);
                netPort = AvailablePort.getRandomAvailablePort((int)0);
                TestUtil.startNetServer(netPort, null);
                serverProps = new Properties();
                serverProps.setProperty("locators", locatorBindAddress + '[' + locatorPort + ']');
                this.startVMs(0, 1, 0, null, serverProps);
                this.startNetworkServer(1, null, null);
                conn = TestUtil.getNetConnection(locatorBindAddress, netPort, null, new Properties());
                st = conn.createStatement();
                sql = null;
                mergeCS = null;
                JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=app.sample1", "-client-port=" + netPort, "-client-bind-address=" + locatorBindAddress});
                String ddl = "create table EMP.TESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID) REDUNDANCY 1";
                st.execute(ddl);
                st.execute("INSERT INTO EMP.TESTTABLE VALUES (2, 2, '3')");
                st.execute("INSERT INTO EMP.TESTTABLE VALUES (3, 3, '3')");
                st.execute("INSERT INTO EMP.TESTTABLE VALUES (2, 2, '4')");
                st.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
                st.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
                sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.TESTTABLE WHERE 1=1";
                if (mergeCS == null) {
                    mergeCS = conn.prepareCall(sql);
                }
                mergeCS.execute();
                this.checkMergeResults((CallableStatement)mergeCS);
                this.startVMs(0, 1, 0, null, serverProps);
                this.startNetworkServer(2, null, null);
                st.execute("call sys.rebalance_all_buckets()");
                this.stopVMNums(-1);
                mergeCS.execute();
                this.checkMergeResults((CallableStatement)mergeCS);
                JarTools.main((String[])new String[]{"replace-jar", "-file=" + this.myfalsejar, "-name=app.sample1", "-client-port=" + netPort, "-client-bind-address=" + locatorBindAddress});
                try {
                    mergeCS.execute();
                    BugsDUnit.fail((String)"Should throw 42X51: The class 'myexamples.MergeSortProcessor' does not exist or is inaccessible");
                }
                catch (SQLException sqle) {
                    if ("42X51".equals(sqle.getSQLState())) break block5;
                    throw sqle;
                }
            }
            this.restartVMNums(new int[]{-1}, 0, null, serverProps);
            this.startNetworkServer(1, null, null);
            st.execute("call sys.rebalance_all_buckets()");
            this.stopVMNums(-2);
            try {
                mergeCS.execute();
                BugsDUnit.fail((String)"Should throw 42X51: The class 'myexamples.MergeSortProcessor' does not exist or is inaccessible");
            }
            catch (SQLException sqle) {
                if ("42X51".equals(sqle.getSQLState())) break block6;
                throw sqle;
            }
        }
        JarTools.main((String[])new String[]{"replace-jar", "-file=" + this.myjar, "-name=app.sample1", "-client-port=" + netPort, "-client-bind-address=" + locatorBindAddress});
        mergeCS = conn.prepareCall(sql);
        mergeCS.execute();
        this.checkMergeResults((CallableStatement)mergeCS);
        st.execute("drop alias MergeSortProcessor");
        st.execute("drop procedure MergeSort");
        st.execute("drop table EMP.TESTTABLE");
        JarTools.main((String[])new String[]{"remove-jar", "-name=APP.sample1", "-client-port=" + netPort, "-client-bind-address=" + locatorBindAddress});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46843_1() throws Exception {
        this.startVMs(1, 4);
        final ArrayList exceptions = new ArrayList();
        Statement stmt = null;
        String query = "select sid, count(*) from txhistory where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1";
        Connection conn = null;
        Statement derbyStmt = null;
        String table = "create table txhistory(cid int,  sid int, qty int)";
        String index = "create index txhistory_sid on txhistory(sid)";
        try {
            String tempDerbyUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                tempDerbyUrl = tempDerbyUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            final String derbyDbUrl = tempDerbyUrl;
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute(table);
            derbyStmt.execute(index);
            Statement derbyStmt1 = derbyConn.createStatement();
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute(table + "  replicate");
            stmt.execute(index);
            PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory values(?,?,?)");
            PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?)");
            ps_insert_derby.setInt(1, 1);
            ps_insert_derby.setInt(2, 1);
            ps_insert_derby.setInt(3, 100);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 1);
            ps_insert_gfxd.setInt(2, 1);
            ps_insert_gfxd.setInt(3, 100);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 11);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 300);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 11);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 300);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 22);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 600);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 22);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 600);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 3);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 900);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 3);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 900);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 6);
            ps_insert_derby.setInt(2, 4);
            ps_insert_derby.setInt(3, 2400);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 6);
            ps_insert_gfxd.setInt(2, 4);
            ps_insert_gfxd.setInt(3, 2400);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 12);
            ps_insert_derby.setInt(2, 4);
            ps_insert_derby.setInt(3, 4800);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 12);
            ps_insert_gfxd.setInt(2, 4);
            ps_insert_gfxd.setInt(3, 4800);
            ps_insert_gfxd.executeUpdate();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection gfxdConn = TestUtil.getConnection();
                        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
                        PreparedStatement derbyStmt = derbyConn.prepareStatement("select sid, count(*) from txhistory where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1");
                        PreparedStatement stmt = gfxdConn.prepareStatement("select sid, count(*) from txhistory where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1");
                        int cid = 10;
                        int sid = 100;
                        stmt.setInt(1, cid);
                        stmt.setInt(2, sid);
                        derbyStmt.setInt(1, cid);
                        derbyStmt.setInt(2, sid);
                        TestUtil.validateResults(derbyStmt, stmt, "select sid, count(*) from txhistory where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1", false);
                    }
                    catch (Throwable th) {
                        exceptions.add(th);
                    }
                }
            };
            runnable.run();
            if (!exceptions.isEmpty()) {
                for (Throwable e : exceptions) {
                    e.printStackTrace();
                }
                BugsDUnit.fail((String)((Object)exceptions).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsDUnit.fail((String)("Test failed because of exception " + e));
        }
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46843_2() throws Exception {
        this.startVMs(1, 4);
        final ArrayList exceptions = new ArrayList();
        Statement stmt = null;
        String query = "select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1";
        Connection conn = null;
        Statement derbyStmt = null;
        String table = "create table txhistory(cid int,  sid int, qty int, type varchar(10))";
        String index = "create index txhistory_sid on txhistory(sid,cid)";
        try {
            String tempDerbyUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                tempDerbyUrl = tempDerbyUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            final String derbyDbUrl = tempDerbyUrl;
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute(table);
            derbyStmt.execute(index);
            Statement derbyStmt1 = derbyConn.createStatement();
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute(table + "  replicate");
            stmt.execute(index);
            PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory  values(?,?,?,?)");
            PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?,?)");
            ps_insert_derby.setInt(1, 1);
            ps_insert_derby.setInt(2, 1);
            ps_insert_derby.setInt(3, 100);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 1);
            ps_insert_gfxd.setInt(2, 1);
            ps_insert_gfxd.setInt(3, 100);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 11);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 300);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 11);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 300);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 11);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 300);
            ps_insert_derby.setString(4, "buy");
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 11);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 300);
            ps_insert_gfxd.setString(4, "buy");
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 11);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 300);
            ps_insert_derby.setString(4, "buy");
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 11);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 300);
            ps_insert_gfxd.setString(4, "buy");
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 22);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 600);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 22);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 600);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 3);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 900);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 3);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 900);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 6);
            ps_insert_derby.setInt(2, 4);
            ps_insert_derby.setInt(3, 2400);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 6);
            ps_insert_gfxd.setInt(2, 4);
            ps_insert_gfxd.setInt(3, 2400);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 12);
            ps_insert_derby.setInt(2, 4);
            ps_insert_derby.setInt(3, 4800);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 12);
            ps_insert_gfxd.setInt(2, 4);
            ps_insert_gfxd.setInt(3, 4800);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection gfxdConn = TestUtil.getConnection();
                        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
                        PreparedStatement derbyStmt = derbyConn.prepareStatement("select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1");
                        PreparedStatement stmt = gfxdConn.prepareStatement("select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1");
                        int cid = 10;
                        int sid = 100;
                        stmt.setInt(1, cid);
                        stmt.setInt(2, sid);
                        derbyStmt.setInt(1, cid);
                        derbyStmt.setInt(2, sid);
                        TestUtil.validateResults(derbyStmt, stmt, "select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1", false);
                        String query2 = "select cid, sum(qty) as amount from txhistory where sid = ?  GROUP BY cid, type ORDER BY amount";
                        stmt = gfxdConn.prepareStatement(query2);
                        derbyStmt = derbyConn.prepareStatement(query2);
                        stmt.setInt(1, 3);
                        derbyStmt.setInt(1, 3);
                        TestUtil.validateResults(derbyStmt, stmt, query2, false);
                    }
                    catch (Throwable th) {
                        exceptions.add(th);
                    }
                }
            };
            runnable.run();
            if (!exceptions.isEmpty()) {
                for (Throwable e : exceptions) {
                    e.printStackTrace();
                }
                BugsDUnit.fail((String)((Object)exceptions).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsDUnit.fail((String)("Test failed because of exception " + e));
        }
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46843_3() throws Exception {
        this.startVMs(1, 4);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Statement stmt1 = null;
        String query = "select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1";
        Connection conn = null;
        Statement derbyStmt1 = null;
        String table = "create table txhistory(cid int,  sid int, qty int, type varchar(10))";
        String index = "create index txhistory_cid on txhistory(cid)";
        try {
            String tempDerbyUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                tempDerbyUrl = tempDerbyUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            String derbyDbUrl = tempDerbyUrl;
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt1 = derbyConn.createStatement();
            derbyStmt1.execute(table);
            derbyStmt1.execute(index);
            conn = TestUtil.getConnection();
            stmt1 = conn.createStatement();
            stmt1.execute(table + "  ");
            stmt1.execute(index);
            PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory  values(?,?,?,?)");
            PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?,?)");
            ps_insert_derby.setInt(1, 1);
            ps_insert_derby.setInt(2, 1);
            ps_insert_derby.setInt(3, 100);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 1);
            ps_insert_gfxd.setInt(2, 1);
            ps_insert_gfxd.setInt(3, 100);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 11);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 300);
            ps_insert_derby.setString(4, "sell");
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 11);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 300);
            ps_insert_gfxd.setString(4, "sell");
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 11);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 300);
            ps_insert_derby.setString(4, "buy");
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 11);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 300);
            ps_insert_gfxd.setString(4, "buy");
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 11);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 300);
            ps_insert_derby.setString(4, "buy");
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 11);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 300);
            ps_insert_gfxd.setString(4, "buy");
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 22);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 600);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 22);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 600);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 3);
            ps_insert_derby.setInt(2, 3);
            ps_insert_derby.setInt(3, 900);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 3);
            ps_insert_gfxd.setInt(2, 3);
            ps_insert_gfxd.setInt(3, 900);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 6);
            ps_insert_derby.setInt(2, 4);
            ps_insert_derby.setInt(3, 2400);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 6);
            ps_insert_gfxd.setInt(2, 4);
            ps_insert_gfxd.setInt(3, 2400);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 12);
            ps_insert_derby.setInt(2, 4);
            ps_insert_derby.setInt(3, 4800);
            ps_insert_derby.setNull(4, 12);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 12);
            ps_insert_gfxd.setInt(2, 4);
            ps_insert_gfxd.setInt(3, 4800);
            ps_insert_gfxd.setNull(4, 12);
            ps_insert_gfxd.executeUpdate();
            try {
                Connection gfxdConn = TestUtil.getConnection();
                PreparedStatement derbyStmt = derbyConn.prepareStatement("select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1");
                PreparedStatement stmt = gfxdConn.prepareStatement("select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1");
                int cid = 10;
                int sid = 100;
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                derbyStmt.setInt(1, cid);
                derbyStmt.setInt(2, sid);
                TestUtil.validateResults(derbyStmt, stmt, "select sid, count(*) from txhistory  where cid>? and sid<?  GROUP BY sid HAVING count(*) >=1", false);
                SerializableRunnable csr = new SerializableRunnable("set observer"){

                    public void run() {
                        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                                return Double.MAX_VALUE;
                            }

                            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                                return 1.0;
                            }
                        });
                    }
                };
                this.serverExecute(4, (Runnable)csr);
                String query2 = "select cid, sum(qty) as amount from txhistory  where sid = ?  GROUP BY cid, type ORDER BY amount";
                stmt = gfxdConn.prepareStatement(query2);
                derbyStmt = derbyConn.prepareStatement(query2);
                stmt.setInt(1, 3);
                derbyStmt.setInt(1, 3);
                TestUtil.validateResults(derbyStmt, stmt, query2, false);
            }
            catch (Throwable th) {
                exceptions.add(th);
            }
            if (!exceptions.isEmpty()) {
                for (Throwable e : exceptions) {
                    e.printStackTrace();
                }
                BugsDUnit.fail((String)((Object)exceptions).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsDUnit.fail((String)("Test failed because of exception " + e));
        }
        finally {
            if (derbyStmt1 != null) {
                try {
                    derbyStmt1.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
        }
    }

    public void testBug46803_1() throws Exception {
        int n;
        ResultSet rs;
        Statement s;
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                int i;
                                this.startVMs(1, 4);
                                PreparedStatement psInsert4 = null;
                                s = null;
                                rs = null;
                                Connection conn = TestUtil.getConnection();
                                s = conn.createStatement();
                                s.execute(" create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) ");
                                s.execute(" create table companies (symbol varchar(10) not null,  exchange varchar(10) not null,  companyname char(100),  tid int, constraint comp_pk primary key (symbol, exchange) ,constraint comp_fk foreign key (symbol, exchange) references securities (symbol, exchange) on delete restrict)");
                                psInsert4 = conn.prepareStatement("insert into securities values (?, ?, ?,?)");
                                for (i = 1; i < 6; ++i) {
                                    psInsert4.setInt(1, i);
                                    psInsert4.setString(2, "symbol" + i);
                                    psInsert4.setString(3, "lse");
                                    psInsert4.setInt(4, 1);
                                    BugsDUnit.assertEquals((int)1, (int)psInsert4.executeUpdate());
                                }
                                PreparedStatement psInsert1 = conn.prepareStatement("insert into companies values (?, ?,?,?)");
                                for (i = 1; i < 6; ++i) {
                                    psInsert1.setString(1, "symbol" + i);
                                    psInsert1.setString(2, "lse");
                                    psInsert1.setString(3, "name" + i);
                                    psInsert1.setInt(4, 1);
                                    BugsDUnit.assertEquals((int)1, (int)psInsert1.executeUpdate());
                                }
                                n = s.executeUpdate("update securities set tid=7  where sec_id = 1");
                                BugsDUnit.assertEquals((int)1, (int)n);
                                try {
                                    n = s.executeUpdate("update securities set symbol = 'random1', exchange = 'amex' where sec_id = 1");
                                    BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                                }
                                catch (SQLException expected) {
                                    if (expected.getSQLState().equals("23503")) break block14;
                                    expected.printStackTrace();
                                    BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                                }
                            }
                            try {
                                s.executeUpdate("update securities set symbol = 'random1' , exchange = 'amex' where sec_id = 2");
                                BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                            }
                            catch (SQLException expected) {
                                if (expected.getSQLState().equals("23503")) break block15;
                                expected.printStackTrace();
                                BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                            }
                        }
                        try {
                            s.executeUpdate("update securities set symbol = 'random1' , exchange = 'amex' where sec_id = 3");
                            BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                        }
                        catch (SQLException expected) {
                            if (expected.getSQLState().equals("23503")) break block16;
                            expected.printStackTrace();
                            BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                        }
                    }
                    try {
                        s.executeUpdate("update securities set  exchange = 'amex' , symbol = 'random1'  where sec_id = 4");
                        BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                    }
                    catch (SQLException expected) {
                        if (expected.getSQLState().equals("23503")) break block17;
                        expected.printStackTrace();
                        BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                    }
                }
                try {
                    s.executeUpdate("update securities set exchange = 'amex'  where sec_id = 1");
                    BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                }
                catch (SQLException expected) {
                    if (expected.getSQLState().equals("23503")) break block18;
                    expected.printStackTrace();
                    BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                }
            }
            try {
                s.executeUpdate("update securities set symbol = 'random1'  where sec_id = 1");
                BugsDUnit.fail((String)"Should have thrown constraint violation exception");
            }
            catch (SQLException expected) {
                if (expected.getSQLState().equals("23503")) break block19;
                expected.printStackTrace();
                BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
            }
        }
        n = s.executeUpdate("update securities set symbol = 'symbol1'  where sec_id = 1");
        BugsDUnit.assertEquals((int)1, (int)n);
        rs = s.executeQuery("select * from securities where symbol = 'random1'");
        BugsDUnit.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46803_2() throws Exception {
        int i;
        this.startVMs(1, 4);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        try {
            conn = TestUtil.getConnection();
            s = conn.createStatement();
            statements.add(s);
            s.execute(" create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) ");
            s.execute(" create table companies (symbol varchar(10) not null,  exchange varchar(10) not null,  companyname char(100),  tid int, constraint comp_pk primary key (symbol, exchange) ,constraint comp_fk foreign key (symbol, exchange) references securities (symbol, exchange) on delete restrict)");
            s.execute("create table buyorders(oid int not null constraint buyorders_pk primary key, sid int,  tid int,  constraint bo_sec_fk foreign key (sid) references securities (sec_id)  on delete restrict)");
            psInsert4 = conn.prepareStatement("insert into securities values (?, ?, ?,?)");
            statements.add(psInsert4);
            for (i = 1; i < 10; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i);
                psInsert4.setString(3, "lse");
                psInsert4.setInt(4, 1);
                BugsDUnit.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert1 = conn.prepareStatement("insert into companies values (?, ?,?,?)");
            statements.add(psInsert1);
            for (i = 1; i < 4; ++i) {
                psInsert1.setString(1, "symbol" + i);
                psInsert1.setString(2, "lse");
                psInsert1.setString(3, "name" + i);
                psInsert1.setInt(4, 1);
                BugsDUnit.assertEquals((int)1, (int)psInsert1.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into buyorders values (?, ?,?)");
            statements.add(psInsert2);
            for (i = 1; i < 10; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, 1);
                BugsDUnit.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            int n = s.executeUpdate("update securities set tid = 7 where sec_id = 3");
            BugsDUnit.assertEquals((int)1, (int)n);
            n = s.executeUpdate("update securities set exchange = 'amex' where sec_id = 9");
            BugsDUnit.assertEquals((int)1, (int)n);
        }
        finally {
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46803_3() throws Exception {
        int i;
        this.startVMs(1, 4);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        try {
            int n;
            block12: {
                block11: {
                    conn = TestUtil.getConnection();
                    s = conn.createStatement();
                    statements.add(s);
                    s.execute(" create table securities ( id int primary key, sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, constraint sec_id_uq unique (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) ");
                    s.execute(" create table companies (symbol varchar(10) not null,  exchange varchar(10) not null,  companyname char(100),  tid int, constraint comp_pk primary key (symbol, exchange) ,constraint comp_fk foreign key (symbol, exchange) references securities (symbol, exchange) on delete restrict)");
                    s.execute("create table buyorders(oid int not null constraint buyorders_pk primary key, sid int,  tid int,  constraint bo_sec_fk foreign key (sid) references securities (sec_id)  on delete restrict)");
                    psInsert4 = conn.prepareStatement("insert into securities values (?,?, ?, ?,?)");
                    statements.add(psInsert4);
                    for (i = 1; i < 10; ++i) {
                        psInsert4.setInt(1, i);
                        psInsert4.setInt(2, i);
                        psInsert4.setString(3, "symbol" + i);
                        psInsert4.setString(4, "lse");
                        psInsert4.setInt(5, 1);
                        BugsDUnit.assertEquals((int)1, (int)psInsert4.executeUpdate());
                    }
                    PreparedStatement psInsert1 = conn.prepareStatement("insert into companies values (?, ?,?,?)");
                    statements.add(psInsert1);
                    for (i = 1; i < 4; ++i) {
                        psInsert1.setString(1, "symbol" + i);
                        psInsert1.setString(2, "lse");
                        psInsert1.setString(3, "name" + i);
                        psInsert1.setInt(4, 1);
                        BugsDUnit.assertEquals((int)1, (int)psInsert1.executeUpdate());
                    }
                    PreparedStatement psInsert2 = conn.prepareStatement("insert into buyorders values (?, ?,?)");
                    statements.add(psInsert2);
                    for (i = 1; i < 10; ++i) {
                        psInsert2.setInt(1, i);
                        psInsert2.setInt(2, i);
                        psInsert2.setInt(3, 1);
                        BugsDUnit.assertEquals((int)1, (int)psInsert2.executeUpdate());
                    }
                    n = s.executeUpdate("update securities set sec_id = 7, symbol='random7' where sec_id = 7");
                    BugsDUnit.assertEquals((int)1, (int)n);
                    try {
                        s.executeUpdate("update securities set symbol = 'random2' , sec_id = 2 where sec_id = 2");
                        BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                    }
                    catch (SQLException expected) {
                        if (expected.getSQLState().equals("23503")) break block11;
                        expected.printStackTrace();
                        BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                    }
                }
                try {
                    s.executeUpdate("update securities set symbol = 'random8' , sec_id = 18 where sec_id = 8");
                    BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                }
                catch (SQLException expected) {
                    if (expected.getSQLState().equals("23503")) break block12;
                    expected.printStackTrace();
                    BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                }
            }
            n = s.executeUpdate("update securities set symbol = 'symbol2' , sec_id = 2 where sec_id = 2");
            BugsDUnit.assertEquals((int)1, (int)n);
        }
        finally {
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46803_4() throws Exception {
        int i;
        this.startVMs(1, 4);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        try {
            int n;
            block12: {
                block11: {
                    conn = TestUtil.getConnection();
                    s = conn.createStatement();
                    statements.add(s);
                    s.execute(" create table securities ( id int primary key, sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, constraint sec_id_uq unique (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) ");
                    s.execute(" create table companies (symbol varchar(10) not null,  exchange varchar(10) not null,  companyname char(100),  tid int, constraint comp_pk primary key (symbol, exchange) ,constraint comp_fk foreign key (symbol, exchange) references securities (symbol, exchange) on delete restrict)");
                    s.execute("create table buyorders(oid int not null constraint buyorders_pk primary key, sid int,  tid int,  constraint bo_sec_fk foreign key (sid) references securities (sec_id)  on delete restrict)");
                    psInsert4 = conn.prepareStatement("insert into securities values (?,?, ?, ?,?)");
                    statements.add(psInsert4);
                    for (i = 1; i < 50; ++i) {
                        psInsert4.setInt(1, i);
                        psInsert4.setInt(2, i);
                        psInsert4.setString(3, "symbol" + i);
                        psInsert4.setString(4, "lse");
                        psInsert4.setInt(5, 1);
                        BugsDUnit.assertEquals((int)1, (int)psInsert4.executeUpdate());
                    }
                    PreparedStatement psInsert1 = conn.prepareStatement("insert into companies values (?, ?,?,?)");
                    statements.add(psInsert1);
                    for (i = 1; i < 20; ++i) {
                        psInsert1.setString(1, "symbol" + i);
                        psInsert1.setString(2, "lse");
                        psInsert1.setString(3, "name" + i);
                        psInsert1.setInt(4, 1);
                        BugsDUnit.assertEquals((int)1, (int)psInsert1.executeUpdate());
                    }
                    PreparedStatement psInsert2 = conn.prepareStatement("insert into buyorders values (?, ?,?)");
                    statements.add(psInsert2);
                    for (i = 1; i < 20; ++i) {
                        psInsert2.setInt(1, i);
                        psInsert2.setInt(2, i);
                        psInsert2.setInt(3, 1);
                        BugsDUnit.assertEquals((int)1, (int)psInsert2.executeUpdate());
                    }
                    n = s.executeUpdate("update securities set sec_id = 2100, symbol='random21' where id = 21");
                    BugsDUnit.assertEquals((int)1, (int)n);
                    try {
                        s.executeUpdate("update securities set symbol = 'random2' , sec_id = 2 where id = 2");
                        BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                    }
                    catch (SQLException expected) {
                        if (expected.getSQLState().equals("23503")) break block11;
                        expected.printStackTrace();
                        BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                    }
                }
                try {
                    s.executeUpdate("update securities set symbol = 'symbol8' , sec_id = 18 where id = 8");
                    BugsDUnit.fail((String)"Should have thrown constraint violation exception");
                }
                catch (SQLException expected) {
                    if (expected.getSQLState().equals("23503")) break block12;
                    expected.printStackTrace();
                    BugsDUnit.fail((String)("unexpected sql state for sql exception =" + expected));
                }
            }
            n = s.executeUpdate("update securities set symbol = 'symbol2' , sec_id = 2 where id = 2");
            BugsDUnit.assertEquals((int)1, (int)n);
        }
        finally {
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46803_5() throws Exception {
        int i;
        this.startClientVMs(1, 0, null);
        this.startServerVMs(1, 0, "sg1");
        this.startServerVMs(2, 0, "sg2");
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        try {
            conn = TestUtil.getConnection();
            s = conn.createStatement();
            statements.add(s);
            s.execute(" create table securities ( id int primary key, sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, sec_id2 int, constraint sec_id_uq unique (sec_id),constraint sec_id2_uq unique (sec_id2), constraint  exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) server groups (sg1)");
            psInsert4 = conn.prepareStatement("insert into securities values (?,?, ?, ?,?,?)");
            statements.add(psInsert4);
            for (i = 1; i < 3; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setInt(2, i);
                psInsert4.setString(3, "symbol" + i);
                psInsert4.setString(4, "lse");
                psInsert4.setInt(5, 1);
                psInsert4.setInt(6, i * 3);
                BugsDUnit.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            s.execute("create table buyorders(oid int not null constraint buyorders_pk primary key, sid int,  tid int, sec_id2 int, constraint bo_sec_fk foreign key (sid) references securities (sec_id)  on delete restrict,   constraint bo_sec_fk2 foreign key (sec_id2) references securities (sec_id2)  on delete restrict) server groups (sg2)");
            PreparedStatement psInsert2 = conn.prepareStatement("insert into buyorders values (?, ?,?,?)");
            statements.add(psInsert2);
            for (i = 1; i < 2; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, 1);
                psInsert2.setNull(4, 4);
                BugsDUnit.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            int n = s.executeUpdate("update securities set sec_id = sec_id * sec_id , sec_id2 = sec_id2*4 ");
            BugsDUnit.assertEquals((int)2, (int)n);
        }
        finally {
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    public void testBug47204() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table warehouse2 (w_id        integer   not null,w_zip       char(9)) replicate persistent");
        this.serverSQLExecute(1, "alter table warehouse2 add constraint pk_warehouse primary key (w_id)");
        this.clientSQLExecute(1, "insert into warehouse2 values (5, '95020')");
        this.clientSQLExecute(1, "insert into warehouse2 values (4, '95020')");
        this.clientSQLExecute(1, "insert into warehouse2 values (3, '95020')");
        this.clientSQLExecute(1, "insert into warehouse2 values (2, '95020')");
        this.clientSQLExecute(1, "insert into warehouse2 values (1, '95020')");
        this.stopVMNums(-1, 1, -2);
        this.restartVMNums(1, -1, -2);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from warehouse2", null, "5");
    }

    public void test47193() throws Exception {
        int numResults;
        ResultSet rs;
        block46: {
            block45: {
                Statement stmt;
                block44: {
                    block43: {
                        PreparedStatement pstmt;
                        block42: {
                            String addr;
                            block41: {
                                block40: {
                                    String addr2;
                                    String id2;
                                    ResultSet rs2;
                                    block38: {
                                        block37: {
                                            block35: {
                                                block34: {
                                                    Properties props = new Properties();
                                                    props.setProperty(GfxdConstants.MAX_LOCKWAIT, "6000");
                                                    this.startVMs(2, 1, 0, null, props);
                                                    Connection conn = TestUtil.getConnection();
                                                    stmt = conn.createStatement(1004, 1007);
                                                    stmt.execute("create table emp (id int primary key, id2 char(10), addr varchar(100) not null)");
                                                    stmt.execute("insert into emp values (1, 'one', 'addr1')");
                                                    stmt.execute("insert into emp values (2, 'two', 'addr2')");
                                                    stmt.execute("insert into emp values (3, 'three', 'addr3')");
                                                    pstmt = conn.prepareStatement("select * from emp");
                                                    rs = stmt.executeQuery("select * from emp");
                                                    rs2 = pstmt.executeQuery();
                                                    try {
                                                        stmt.execute("alter table emp drop column id2");
                                                        BugsDUnit.fail((String)"expected an open result set in drop index");
                                                    }
                                                    catch (SQLException sqle) {
                                                        if ("X0X95".equals(sqle.getSQLState())) break block34;
                                                        throw sqle;
                                                    }
                                                }
                                                BugsDUnit.assertTrue((boolean)rs.isClosed());
                                                BugsDUnit.assertFalse((boolean)rs2.isClosed());
                                                try {
                                                    this.clientSQLExecute(2, "alter table emp drop column id2");
                                                    BugsDUnit.fail((String)"expected a lock timeout in drop index");
                                                }
                                                catch (RMIException ex) {
                                                    if (ex.getCause() instanceof SQLException && "40XL1".equals(((SQLException)ex.getCause()).getSQLState())) break block35;
                                                    throw ex;
                                                }
                                            }
                                            numResults = 0;
                                            rs = stmt.executeQuery("select * from emp");
                                            BugsDUnit.assertEquals((int)1, (int)rs.findColumn("ID"));
                                            BugsDUnit.assertEquals((int)2, (int)rs.findColumn("ID2"));
                                            BugsDUnit.assertEquals((int)3, (int)rs.findColumn("ADDR"));
                                            while (rs.next()) {
                                                block36: {
                                                    int id = rs.getInt(1);
                                                    id2 = rs.getString(2);
                                                    addr2 = rs.getString(3);
                                                    BugsDUnit.assertTrue((String)("unexpected id=" + id), (id >= 1 && id <= 3 ? 1 : 0) != 0);
                                                    BugsDUnit.assertNotNull((Object)id2);
                                                    BugsDUnit.assertEquals((String)("addr" + id), (String)addr2);
                                                    if (numResults == 0) {
                                                        try {
                                                            this.clientSQLExecute(1, "alter table emp drop column id2");
                                                            BugsDUnit.fail((String)"expected a lock timeout in drop index");
                                                        }
                                                        catch (SQLException sqle) {
                                                            if ("40XL1".equals(sqle.getSQLState())) break block36;
                                                            throw sqle;
                                                        }
                                                    }
                                                }
                                                ++numResults;
                                            }
                                            BugsDUnit.assertEquals((int)3, (int)numResults);
                                            rs.close();
                                            try {
                                                stmt.execute("alter table emp drop column id2");
                                                BugsDUnit.fail((String)"expected an open result set in drop index");
                                            }
                                            catch (SQLException sqle) {
                                                if ("X0X95".equals(sqle.getSQLState())) break block37;
                                                throw sqle;
                                            }
                                        }
                                        BugsDUnit.assertFalse((boolean)rs2.isClosed());
                                        try {
                                            this.clientSQLExecute(2, "alter table emp drop column id2");
                                            BugsDUnit.fail((String)"expected a lock timeout in drop index");
                                        }
                                        catch (RMIException ex) {
                                            if (ex.getCause() instanceof SQLException && "40XL1".equals(((SQLException)ex.getCause()).getSQLState())) break block38;
                                            throw ex;
                                        }
                                    }
                                    numResults = 0;
                                    BugsDUnit.assertEquals((int)1, (int)rs2.findColumn("ID"));
                                    BugsDUnit.assertEquals((int)2, (int)rs2.findColumn("ID2"));
                                    BugsDUnit.assertEquals((int)3, (int)rs2.findColumn("ADDR"));
                                    while (rs2.next()) {
                                        block39: {
                                            int id = rs2.getInt(1);
                                            id2 = rs2.getString(2);
                                            addr2 = rs2.getString(3);
                                            BugsDUnit.assertTrue((String)("unexpected id=" + id), (id >= 1 && id <= 3 ? 1 : 0) != 0);
                                            BugsDUnit.assertNotNull((Object)id2);
                                            BugsDUnit.assertEquals((String)("addr" + id), (String)addr2);
                                            if (numResults == 1) {
                                                try {
                                                    this.clientSQLExecute(2, "alter table emp drop column id2");
                                                    BugsDUnit.fail((String)"expected a lock timeout in drop index");
                                                }
                                                catch (RMIException ex) {
                                                    if (ex.getCause() instanceof SQLException && "40XL1".equals(((SQLException)ex.getCause()).getSQLState())) break block39;
                                                    throw ex;
                                                }
                                            }
                                        }
                                        ++numResults;
                                    }
                                    BugsDUnit.assertEquals((int)3, (int)numResults);
                                    this.clientSQLExecute(2, "alter table emp drop column id2");
                                    numResults = 0;
                                    rs = pstmt.executeQuery();
                                    BugsDUnit.assertEquals((int)2, (int)rs.getMetaData().getColumnCount());
                                    try {
                                        rs.findColumn("ID2");
                                        BugsDUnit.fail((String)"expected failure in ID2 lookup");
                                    }
                                    catch (SQLException sqle) {
                                        if ("S0022".equals(sqle.getSQLState())) break block40;
                                        throw sqle;
                                    }
                                }
                                while (rs.next()) {
                                    int id = rs.getInt(1);
                                    addr = rs.getString(2);
                                    BugsDUnit.assertTrue((String)("unexpected id=" + id), (id >= 1 && id <= 3 ? 1 : 0) != 0);
                                    BugsDUnit.assertEquals((String)("addr" + id), (String)addr);
                                    ++numResults;
                                }
                                BugsDUnit.assertEquals((int)3, (int)numResults);
                                rs = stmt.executeQuery("select * from emp");
                                BugsDUnit.assertEquals((int)2, (int)rs.getMetaData().getColumnCount());
                                try {
                                    rs.findColumn("ID2");
                                    BugsDUnit.fail((String)"expected failure in ID2 lookup");
                                }
                                catch (SQLException sqle) {
                                    if ("S0022".equals(sqle.getSQLState())) break block41;
                                    throw sqle;
                                }
                            }
                            numResults = 0;
                            while (rs.next()) {
                                int id = rs.getInt(1);
                                addr = rs.getString(2);
                                BugsDUnit.assertTrue((String)("unexpected id=" + id), (id >= 1 && id <= 3 ? 1 : 0) != 0);
                                BugsDUnit.assertEquals((String)("addr" + id), (String)addr);
                                ++numResults;
                            }
                            BugsDUnit.assertEquals((int)3, (int)numResults);
                            try {
                                this.clientSQLExecute(1, "alter table emp drop column addr");
                                BugsDUnit.fail((String)"expected a lock timeout in drop index");
                            }
                            catch (SQLException sqle) {
                                if ("40XL1".equals(sqle.getSQLState())) break block42;
                                throw sqle;
                            }
                        }
                        rs.close();
                        this.clientSQLExecute(2, "alter table emp drop column addr");
                        numResults = 0;
                        rs = pstmt.executeQuery();
                        BugsDUnit.assertEquals((int)1, (int)rs.getMetaData().getColumnCount());
                        try {
                            rs.findColumn("ID2");
                            BugsDUnit.fail((String)"expected failure in ID2 lookup");
                        }
                        catch (SQLException sqle) {
                            if ("S0022".equals(sqle.getSQLState())) break block43;
                            throw sqle;
                        }
                    }
                    try {
                        rs.findColumn("ADDR");
                        BugsDUnit.fail((String)"expected failure in ADDR lookup");
                    }
                    catch (SQLException sqle) {
                        if ("S0022".equals(sqle.getSQLState())) break block44;
                        throw sqle;
                    }
                }
                while (rs.next()) {
                    int id = rs.getInt(1);
                    BugsDUnit.assertTrue((String)("unexpected id=" + id), (id >= 1 && id <= 3 ? 1 : 0) != 0);
                    ++numResults;
                }
                BugsDUnit.assertEquals((int)3, (int)numResults);
                numResults = 0;
                rs = stmt.executeQuery("select * from emp");
                BugsDUnit.assertEquals((int)1, (int)rs.getMetaData().getColumnCount());
                try {
                    rs.findColumn("ID2");
                    BugsDUnit.fail((String)"expected failure in ID2 lookup");
                }
                catch (SQLException sqle) {
                    if ("S0022".equals(sqle.getSQLState())) break block45;
                    throw sqle;
                }
            }
            try {
                rs.findColumn("ADDR");
                BugsDUnit.fail((String)"expected failure in ADDR lookup");
            }
            catch (SQLException sqle) {
                if ("S0022".equals(sqle.getSQLState())) break block46;
                throw sqle;
            }
        }
        while (rs.next()) {
            int id = rs.getInt(1);
            BugsDUnit.assertTrue((String)("unexpected id=" + id), (id >= 1 && id <= 3 ? 1 : 0) != 0);
            ++numResults;
        }
        BugsDUnit.assertEquals((int)3, (int)numResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47289() throws Exception {
        block8: {
            this.startVMs(1, 2);
            Statement st = null;
            ResultSet rs = null;
            Connection conn = null;
            String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            try {
                conn = TestUtil.getConnection();
                st = conn.createStatement();
                st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
                st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
                st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (exchange) (VALUES ('nasdaq','nye'), VALUES ('amex','lse'), VALUES ('fse','hkse','tse'))");
                PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?)");
                for (int i = 1; i < 20; ++i) {
                    psSec.setInt(1, i);
                    psSec.setString(2, this.getSymbol(1, 8));
                    psSec.setString(3, exchanges[i % 7]);
                    psSec.setInt(4, 50);
                    psSec.executeUpdate();
                }
                this.startServerVMs(2, 0, null);
                st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype int, tid int, constraint comp_pk primary key (symbol, exchange))");
                PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, tid) values (?,?,?,?)");
                rs = st.executeQuery("select * from trade.securities");
                int k = 0;
                while (rs.next()) {
                    String symbol = rs.getString(2);
                    String exchange = rs.getString(3);
                    psComp.setString(1, symbol);
                    psComp.setString(2, exchange);
                    psComp.setInt(3, k);
                    psComp.setInt(4, 50);
                    psComp.executeUpdate();
                    ++k;
                }
                BugsDUnit.assertTrue((k >= 1 ? 1 : 0) != 0);
                try {
                    st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict");
                    BugsDUnit.fail((String)"FK constraint addition should fail");
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().equals("0A000")) {
                        break block8;
                    }
                    throw sqle;
                }
            }
            finally {
                TestUtil.shutDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47289_1() throws Exception {
        this.startVMs(1, 4);
        Statement st = null;
        ResultSet rs = null;
        Connection conn = null;
        String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        try {
            conn = TestUtil.getConnection();
            st = conn.createStatement();
            st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (exchange) (VALUES ('nasdaq','nye'), VALUES ('amex','lse'), VALUES ('fse','hkse','tse'))");
            PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?)");
            for (int i = 1; i < 20; ++i) {
                psSec.setInt(1, i);
                psSec.setString(2, this.getSymbol(1, 6) + "_" + i);
                psSec.setString(3, exchanges[i % 7]);
                psSec.setInt(4, 50);
                psSec.executeUpdate();
            }
            st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype int, tid int, constraint comp_pk primary key (symbol, exchange)) replicate");
            PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, tid) values (?,?,?,?)");
            rs = st.executeQuery("select * from trade.securities");
            int k = 0;
            while (rs.next()) {
                String symbol = rs.getString(2);
                String exchange = rs.getString(3);
                psComp.setString(1, symbol);
                psComp.setString(2, exchange);
                psComp.setInt(3, k);
                psComp.setInt(4, 50);
                psComp.executeUpdate();
                ++k;
            }
            BugsDUnit.assertTrue((k >= 1 ? 1 : 0) != 0);
            st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict");
        }
        finally {
            TestUtil.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug47655() throws Exception {
        block4: {
            this.startVMs(1, 2);
            VM dataStore1 = null;
            Connection conn = TestUtil.getConnection();
            Statement s = conn.createStatement();
            try {
                s.execute("create table securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null,tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange))   partition by column(tid) redundancy 1");
                PreparedStatement ps = conn.prepareStatement("insert into securities values (?,?,?,?)");
                for (int i = 1; i < 22; ++i) {
                    ps.setInt(1, i);
                    ps.setString(2, "symbol" + i);
                    ps.setString(3, "fse");
                    ps.setInt(4, i);
                    ps.executeUpdate();
                }
                this.startServerVMs(2, -1, null);
                Thread.sleep(5000L);
                dataStore1 = (VM)this.serverVMs.get(0);
                dataStore1.invoke((Runnable)new SerializableRunnable("cache closer"){

                    public void run() {
                        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

                            public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                                try {
                                    TestUtil.shutDown();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                            }
                        };
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                    }
                });
                s.executeUpdate("update securities set symbol = 'symbol20', exchange = 'fse' where sec_id= 20 and tid = 20");
                s.executeUpdate("delete from securities where sec_id = 20");
                if (dataStore1 == null) break block4;
            }
            catch (Throwable throwable) {
                if (dataStore1 != null) {
                    dataStore1.invoke((Runnable)new SerializableRunnable("reset"){

                        public void run() {
                            GemFireXDQueryObserverHolder.clearInstance();
                            try {
                                DistributedSQLTestBase._startNewServer(BugsDUnit.class.getName(), BugsDUnit.this.getName(), -1, null, null, false);
                            }
                            catch (Exception ignore) {
                                ignore.printStackTrace();
                            }
                        }
                    });
                }
                TestUtil.shutDown();
                throw throwable;
            }
            dataStore1.invoke((Runnable)new /* invalid duplicate definition of identical inner class */);
        }
        TestUtil.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47289_2() throws Exception {
        block6: {
            this.startVMs(1, 4);
            Statement st = null;
            ResultSet rs = null;
            Connection conn = null;
            String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            try {
                conn = TestUtil.getConnection();
                st = conn.createStatement();
                st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (exchange) (VALUES ('nasdaq','nye'), VALUES ('amex','lse'), VALUES ('fse','hkse','tse'))");
                st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype int, tid int, constraint comp_pk primary key (symbol, exchange)) replicate");
                PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, tid) values (?,?,?,?)");
                rs = st.executeQuery("select * from trade.securities");
                String symbol = "xxx";
                String exchange = "amex";
                psComp.setString(1, symbol);
                psComp.setString(2, exchange);
                psComp.setInt(3, 1);
                psComp.setInt(4, 50);
                BugsDUnit.assertEquals((int)1, (int)psComp.executeUpdate());
                try {
                    st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict");
                    BugsDUnit.fail((String)"FK constraint addition should fail");
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().equals("X0Y45")) {
                        break block6;
                    }
                    throw sqle;
                }
            }
            finally {
                TestUtil.shutDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47289_3() throws Exception {
        this.startVMs(1, 4);
        Statement st = null;
        ResultSet rs = null;
        Connection conn = null;
        String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        try {
            conn = TestUtil.getConnection();
            st = conn.createStatement();
            st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange, tid), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by column (symbol,tid) ");
            PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?)");
            for (int i = 1; i < 20; ++i) {
                psSec.setInt(1, i);
                psSec.setString(2, this.getSymbol(1, 6) + "_" + i);
                psSec.setString(3, exchanges[i % 7]);
                psSec.setInt(4, i);
                psSec.executeUpdate();
            }
            st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype int, tid int, constraint comp_pk primary key (symbol, exchange)) replicate");
            PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, tid) values (?,?,?,?)");
            rs = st.executeQuery("select * from trade.securities");
            int k = 0;
            while (rs.next()) {
                String symbol = rs.getString(2);
                String exchange = rs.getString(3);
                int tid = rs.getInt(4);
                psComp.setString(1, symbol);
                psComp.setString(2, exchange);
                psComp.setInt(3, k);
                psComp.setInt(4, tid);
                psComp.executeUpdate();
                ++k;
            }
            BugsDUnit.assertTrue((k >= 1 ? 1 : 0) != 0);
            st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange, tid) references trade.securities (symbol, exchange, tid) on delete restrict");
        }
        finally {
            TestUtil.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47289_47611_4() throws Exception {
        this.startVMs(1, 4);
        Statement st = null;
        ResultSet rs = null;
        Connection conn = null;
        String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        try {
            conn = TestUtil.getConnection();
            st = conn.createStatement();
            st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange, tid), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by column (symbol) ");
            PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?)");
            for (int i = 1; i < 20; ++i) {
                psSec.setInt(1, i);
                psSec.setString(2, this.getSymbol(1, 6) + "_" + i);
                psSec.setString(3, exchanges[i % 7]);
                psSec.setInt(4, i);
                psSec.executeUpdate();
            }
            st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype int, tid int, constraint comp_pk primary key (symbol, exchange)) replicate");
            PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, tid) values (?,?,?,?)");
            rs = st.executeQuery("select * from trade.securities");
            int k = 0;
            while (rs.next()) {
                String symbol = rs.getString(2);
                String exchange = rs.getString(3);
                int tid = rs.getInt(4);
                psComp.setString(1, symbol);
                psComp.setString(2, exchange);
                psComp.setInt(3, k);
                psComp.setInt(4, tid);
                psComp.executeUpdate();
                ++k;
            }
            BugsDUnit.assertTrue((k >= 1 ? 1 : 0) != 0);
            st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange, tid) references trade.securities (symbol, exchange, tid) on delete restrict");
        }
        finally {
            TestUtil.shutDown();
        }
    }

    public void testBug48263() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table t1 (col1 int, col2 int, col3 int, constraint pk1 primary key (col1))");
        st.execute("insert into t1 values (1, 1, 1), (2, 2, 2)");
        SerializableRunnable csr = new SerializableRunnable("_48263_"){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void beforeQueryReprepare(GenericPreparedStatement gp, LanguageConnectionContext lcc) throws StandardException {
                        gp.makeInvalid(3, lcc);
                    }
                });
            }
        };
        this.clientExecute(1, (Runnable)csr);
        PreparedStatement ps1 = conn.prepareStatement("update t1 set col2 = ? where col1 = ?");
        for (int i = 1; i <= 2; ++i) {
            ps1.setInt(1, 10);
            ps1.setInt(2, i);
            ps1.addBatch();
        }
        ps1.executeBatch();
        ResultSet rs = st.executeQuery("select col1, col2 from t1 order by col1");
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)10, (int)rs.getInt(2));
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)10, (int)rs.getInt(2));
        BugsDUnit.assertFalse((boolean)rs.next());
    }

    public void testBug48232() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema scott");
        Properties props = new Properties();
        props.put("user", "scott");
        this.startClientVMs(1, 0, null, props);
        this.clientSQLExecute(2, "create table scott.t1(col1 int)");
        this.clientSQLExecute(2, "insert into scott.t1 values(1)");
        this.sqlExecuteVerify(new int[]{2}, null, "select * from t1", null, "1");
        this.clientSQLExecute(2, "drop table scott.t1");
        this.clientSQLExecute(2, "drop schema scott restrict");
        this.startClientVMs(1, 0, null, props);
        this.clientSQLExecute(3, "create table t1(col1 int)");
        this.clientSQLExecute(3, "insert into scott.t1 values(1)");
        this.sqlExecuteVerify(new int[]{3}, null, "select * from t1", null, "1");
    }

    public void testBug48232_2() throws Exception {
        Properties props = new Properties();
        props.put("user", "scott1");
        props.put("password", "pwd");
        this.startVMs(1, 1, 0, null, props);
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema s1");
        st.execute("set current schema s1");
        st.execute("create table t1 (col1 int)");
        conn.close();
        props.put("user", "scott2");
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("create schema s2");
        st.execute("set current schema s2");
        st.execute("create table t2 (col1 int)");
        conn.close();
        this.stopVMNums(-1);
        this.restartVMNums(-1);
        this.serverSQLExecute(1, "insert into s1.t1 values(1)");
        this.serverSQLExecute(1, "insert into s2.t2 values(1)");
        this.sqlExecuteVerify(null, new int[]{1}, "select * from s1.t1", null, "1");
        this.sqlExecuteVerify(null, new int[]{1}, "select * from s2.t2", null, "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTSMCImportFailureBug() throws Exception {
        this.startVMs(1, 2);
        try {
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create table app.t1(col1 int, col2 int, col3 int, constraint pk1 primary key (col1)) partition by (col1)");
            st.execute("create table app.t1_hist(col1 int, col2 int, col3 int, constraint pk2 primary key (col1)) partition by (col1)");
            st.execute("create trigger app.trig1 after insert on app.t1 referencing new as newrow for each row insert into app.t1_hist values (newrow.col1, newrow.col2, newrow.col3)");
            st.execute("insert into app.t1_hist values (1, 1, 1), (4, 4, 4), (5, 5, 5)");
            PrintWriter p = new PrintWriter(new File("data.csv"));
            p.write("1,2,2,\n");
            p.close();
            try {
                this.addExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                st.executeUpdate("call SYSCS_UTIL.IMPORT_TABLE('app', 't1', 'data.csv', null, null, null, 0)");
            }
            catch (SQLException se) {
                block7: {
                    try {
                        if (se.getSQLState().equals("XIE0R") && se.getMessage().contains("The statement was aborted because it would have caused a duplicate key value in a unique or primary key constraint or unique index identified by 'primary key constraint'")) break block7;
                        throw se;
                    }
                    catch (Throwable throwable) {
                        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                        throw throwable;
                    }
                }
                this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
            this.getLogWriter().info((Object)"Creating a table on the same coonnection where an import failed");
            st.execute("create table app.t3 (col1 int, col2 int, col3 int)");
            st.execute("insert into app.t3 values(0, 0, 0)");
            st.execute("select col1 from app.t3");
            ResultSet rs = st.getResultSet();
            BugsDUnit.assertTrue((boolean)rs.next());
            BugsDUnit.assertEquals((int)0, (int)rs.getInt(1));
            BugsDUnit.assertFalse((boolean)rs.next());
            st.execute("drop table app.t3");
        }
        finally {
            new File("data.csv").delete();
        }
    }

    public void testTSMCExecuteBatchBug() throws Exception {
        int locPort = AvailablePort.getRandomAvailablePort((int)0);
        Properties props = new Properties();
        props.setProperty("start-locator", "localhost[" + locPort + ']');
        this.startVMs(0, 1, 0, null, props);
        props.clear();
        props.setProperty("locators", "localhost[" + locPort + ']');
        this.startVMs(1, 3, 0, null, props);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE APP.TEST1( ID varchar(20), COL1 int, COL2 int, COL3 int, COL4 int, PRIMARY KEY (ID, COL1)) PARTITION BY PRIMARY KEY REDUNDANCY 1 PERSISTENT ASYNCHRONOUS");
        st.execute("insert into APP.test1 values ('3', 3, 1, 1, 1)");
        conn.setAutoCommit(false);
        PreparedStatement stmt = conn.prepareStatement("UPDATE APP.TEST1 SET COL2 = ? WHERE ID = ? AND COL1 = ?");
        for (int i = 0; i < 1; ++i) {
            stmt.setInt(1, 9);
            stmt.setString(2, "3");
            stmt.setInt(3, 3);
            stmt.addBatch();
            if ((i + 1) % 10 != 0) continue;
            stmt.executeBatch();
            conn.commit();
        }
        stmt.executeBatch();
        conn.commit();
        ResultSet rs = st.executeQuery("select * from app.test1");
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)9, (int)rs.getInt(3));
        BugsDUnit.assertFalse((boolean)rs.next());
    }

    public void testBug47976() throws Exception {
        this.startVMs(1, 4);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE COMSPC.COM_SPC_CHART_MGMT (SYS_NAME               VARCHAR(12)      NOT NULL,GROUP_NO               DECIMAL(10,0)                 NOT NULL,CHART_NO               DECIMAL(10,0)                 NOT NULL,CHART_TYPE_NO          NUMERIC(8,2)                 NOT NULL,CHART_NAME             VARCHAR(40)      NOT NULL,CHART_DESC             VARCHAR(64),DC_ITEM_NAME           VARCHAR(40)      NOT NULL,UNIT_NAME              VARCHAR(12),USL_VAL                DECIMAL(30,20)                 NOT NULL,UWL_VAL                DECIMAL(30,20)                 NOT NULL,UCL_VAL                DECIMAL(30,20)                 NOT NULL,TARGET_VAL             DECIMAL(30,20)                 NOT NULL,MEAN_VAL               DECIMAL(30,20)                 NOT NULL,LCL_VAL                DECIMAL(30,20)                 NOT NULL,LWL_VAL                DECIMAL(30,20)                 NOT NULL,LSL_VAL                DECIMAL(30,20)                 NOT NULL,CHART_IDNTFY_1_CMT     VARCHAR(64),CHART_IDNTFY_2_CMT     VARCHAR(64),CHART_IDNTFY_3_CMT     VARCHAR(64),UPDATE_TIME            DATE                   NOT NULL,UPDATE_USER_NAME       VARCHAR(11)      NOT NULL,CHART_CREATE_TIME      DATE,CHART_CTRL_TYPE        VARCHAR(10),TGHTN_TYPE             VARCHAR(10),TGHTN_DERIVE_CHART_NO  DECIMAL(30,20),TGHTN_RULE             DECIMAL(30,20),TGHTN_TIME             DATE,TGHTN_DERIVE_SBGRP_NO  NUMERIC(10,5),FAB_NAME               VARCHAR(12),PRIMARY KEY (SYS_NAME,GROUP_NO,CHART_NO)) REPLICATE PERSISTENT SYNCHRONOUS");
        st.execute("CREATE INDEX COMSPC.COM_SPC_CHART_MGMT_PK ON COMSPC.COM_SPC_CHART_MGMT (SYS_NAME,GROUP_NO,CHART_NO)");
        st.execute("CREATE TABLE COMSPC.COM_SPC_CHART_MGMT_HIST (SYS_NAME               VARCHAR(12)      NOT NULL,GROUP_NO               DECIMAL(10,0)                 NOT NULL,CHART_NO               DECIMAL(10,0)                 NOT NULL,CHART_TYPE_NO          NUMERIC(8,2)                 NOT NULL,CHART_NAME             VARCHAR(40)      NOT NULL,CHART_DESC             VARCHAR(64),DC_ITEM_NAME           VARCHAR(40)      NOT NULL,UNIT_NAME              VARCHAR(12),USL_VAL                DECIMAL(30,20)                 NOT NULL,UWL_VAL                DECIMAL(30,20)                 NOT NULL,UCL_VAL                DECIMAL(30,20)                 NOT NULL,TARGET_VAL             DECIMAL(30,20)                 NOT NULL,MEAN_VAL               DECIMAL(30,20)                 NOT NULL,LCL_VAL                DECIMAL(30,20)                 NOT NULL,LWL_VAL                DECIMAL(30,20)                 NOT NULL,LSL_VAL                DECIMAL(30,20)                 NOT NULL,CHART_IDNTFY_1_CMT     VARCHAR(64),CHART_IDNTFY_2_CMT     VARCHAR(64),CHART_IDNTFY_3_CMT     VARCHAR(64),UPDATE_TIME            DATE                   NOT NULL,UPDATE_USER_NAME       VARCHAR(11)      NOT NULL,OPER_DESC             VARCHAR(3),OPER_TIME             TIMESTAMP,CHART_CREATE_TIME      DATE,CHART_CTRL_TYPE        VARCHAR(10),TGHTN_TYPE             VARCHAR(10),TGHTN_DERIVE_CHART_NO  DECIMAL(30,20),TGHTN_RULE             DECIMAL(30,20),TGHTN_TIME             DATE,TGHTN_DERIVE_SBGRP_NO  NUMERIC(10,5),FAB_NAME               VARCHAR(12),PRIMARY KEY (SYS_NAME,GROUP_NO,CHART_NO,OPER_TIME,DC_ITEM_NAME)) PARTITION BY COLUMN (SYS_NAME,GROUP_NO)REDUNDANCY 1 PERSISTENT ASYNCHRONOUS");
        st.execute("CREATE TRIGGER COMSPC.CHART_MGMT_DEL AFTER DELETE ON COMSPC.COM_SPC_CHART_MGMT REFERENCING OLD AS OLD FOR EACH ROW INSERT INTO COMSPC.COM_SPC_CHART_MGMT_HIST(SYS_NAME, GROUP_NO, CHART_NO, CHART_TYPE_NO, CHART_NAME, CHART_DESC, DC_ITEM_NAME, UNIT_NAME,USL_VAL, UWL_VAL, UCL_VAL, TARGET_VAL, MEAN_VAL, LCL_VAL, LWL_VAL, LSL_VAL, CHART_IDNTFY_1_CMT, CHART_IDNTFY_2_CMT, CHART_IDNTFY_3_CMT, UPDATE_TIME, UPDATE_USER_NAME,OPER_DESC, OPER_TIME)VALUES (OLD.SYS_NAME, OLD.GROUP_NO, OLD.CHART_NO, OLD.CHART_TYPE_NO, OLD.CHART_NAME, OLD.CHART_DESC, OLD.DC_ITEM_NAME, OLD.UNIT_NAME,OLD.USL_VAL, OLD.UWL_VAL, OLD.UCL_VAL, OLD.TARGET_VAL, OLD.MEAN_VAL, OLD.LCL_VAL, OLD.LWL_VAL, OLD.LSL_VAL, OLD.CHART_IDNTFY_1_CMT, OLD.CHART_IDNTFY_2_CMT, OLD.CHART_IDNTFY_3_CMT, OLD.UPDATE_TIME, OLD.UPDATE_USER_NAME,'DEL', CURRENT_TIMESTAMP)");
        this.stopVMNums(-2);
        this.restartVMNums(-2);
    }

    public void testBug46799() throws Exception {
        this.startVMs(1, 4);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = TestUtil.startNetserverAndReturnPort();
        Connection conn = TestUtil.getConnection();
        Connection conn2 = TestUtil.getNetConnection(netPort, null, null);
        Connection conn3 = TestUtil.getNetConnection(netPort2, null, null);
        Statement st = conn.createStatement();
        Statement st2 = conn2.createStatement();
        Statement st3 = conn3.createStatement();
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid char(36), companyname char(100), companyinfo clob, note long varchar, histprice decimal(20,5), asset bigint, logo varchar(100) for bit data, tid int, pvt blob, constraint comp_pk primary key (symbol, exchange)) partition by column(logo)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyInfo, note, histprice, asset, logo, tid, pvt) values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        Random rnd = PartitionedRegion.rand;
        char[] clobChars = new char[10000];
        byte[] blobBytes = new byte[20000];
        char[] chooseChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_".toCharArray();
        for (int i = 0; i < clobChars.length; ++i) {
            clobChars[i] = chooseChars[rnd.nextInt(chooseChars.length)];
        }
        rnd.nextBytes(blobBytes);
        SerialClob clob = new SerialClob(clobChars);
        SerialBlob blob = new SerialBlob(blobBytes);
        Object[] row = new Object[]{"mzto109", "fse", (short)8, new byte[]{62, -73, -54, 72, 34, -24, 69, -63, -110, 24, 50, 105, 62, 53, -17, -90}, "3eb7ca48-22e8-45c1-9218-32693e35efa6", "`8vCV`;=h;6s/W$e 0h0^eh", clob, "BB(BfoRJWVYh'&6dU `gb2*||Yz>=2+!:7C jz->F1}V", "50.29", 8397740485201787197L, new byte[]{127, -18, -85, 16, 79, 86, 50, 90, -70, 121, -38, -97, -114, -62, -54, -43, 109, -14, -22, 62, -70, 51, 71, -17, 83, -70, 21, 126, -73, -113, -7, 121, 43, -24, -53, -44, 38, -93, -87, -86, 13, -61, -7, -47, 37, 18, -51, 101, 47, 34, -14, 77, 45, 70, -123, 7, -117, -36, 35, 73, 73, 127, 117, 17}, 109, blob};
        int col = 1;
        for (Object o : row) {
            psComp.setObject(col, o);
            ++col;
        }
        psComp.executeUpdate();
        ResultSet rs = st.executeQuery("select symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histPrice, asset, logo, tid, pvt from TRADE.COMPANIES where tid >= 105 and tid < 110");
        BugsTest.checkLobs(rs, clobChars, blobBytes);
        rs = st2.executeQuery("select symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histPrice, asset, logo, tid, pvt from TRADE.COMPANIES where tid >= 105 and tid < 110");
        BugsTest.checkLobs(rs, clobChars, blobBytes);
        rs = st3.executeQuery("select symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histPrice, asset, logo, tid, pvt from TRADE.COMPANIES where tid >= 105 and tid < 110");
        BugsTest.checkLobs(rs, clobChars, blobBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47943() throws Exception {
        this.startVMs(1, 4);
        try {
            int sum;
            int count;
            int i;
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create schema trade");
            st.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle varchar(10), c_next varchar(10),c_id int  primary key, c_tid int not null) partition by column (c_first)");
            st.execute("create table trade.customerrep (c_balance int not null, c_first int not null, c_middle varchar(10), c_next varchar(10), c_id int  primary key, c_tid int not null) replicate");
            String[] securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?, ?, ?)");
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.customerrep values (?, ?, ?, ?, ?, ?)");
            for (int i2 = 0; i2 < 30; ++i2) {
                psInsert.setInt(1, i2);
                psInsert2.setInt(1, i2);
                psInsert.setInt(2, i2 * 2);
                psInsert2.setInt(2, i2 * 2);
                psInsert.setString(3, securities[i2 % 9]);
                psInsert2.setString(3, securities[i2 % 9]);
                psInsert.setString(4, securities[2 * i2 % 9]);
                psInsert2.setString(4, securities[2 * i2 % 9]);
                psInsert.setInt(5, i2 * 4);
                psInsert2.setInt(5, i2 * 4);
                psInsert.setInt(6, i2 % 10);
                psInsert2.setInt(6, i2 % 10);
                psInsert.executeUpdate();
                psInsert2.executeUpdate();
            }
            String query = "SELECT * FROM trade.customer order by c_first offset 3 row fetch first row only";
            Statement st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)3, (int)r.getInt(1));
                    ++count;
                }
                BugsDUnit.assertEquals((int)1, (int)count);
                r.close();
            }
            query = "SELECT * FROM trade.customerrep order by c_first offset 3 row fetch first row only";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)3, (int)r.getInt(1));
                    ++count;
                }
                BugsDUnit.assertEquals((int)1, (int)count);
                r.close();
            }
            query = "SELECT * FROM trade.customer order by c_first offset 3 row fetch next 4 row only";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 3;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)count, (int)r.getInt(1));
                    ++count;
                }
                BugsDUnit.assertEquals((int)7, (int)count);
                r.close();
            }
            query = "SELECT * FROM trade.customerrep order by c_first offset 3 row fetch next 4 row only";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 3;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)count, (int)r.getInt(1));
                    ++count;
                }
                BugsDUnit.assertEquals((int)7, (int)count);
                r.close();
            }
            query = "SELECT * FROM trade.customer offset 25 row";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                while (r.next()) {
                    ++count;
                }
                BugsDUnit.assertEquals((int)5, (int)count);
                r.close();
            }
            query = "SELECT * FROM trade.customerrep offset 25 row";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                while (r.next()) {
                    ++count;
                }
                BugsDUnit.assertEquals((int)5, (int)count);
                r.close();
            }
            query = "select c_tid, max(c_id * c_first) as largest_order from trade.customer where c_balance > ?  GROUP BY c_tid HAVING max(c_id*c_first) > ? ORDER BY max(c_id*c_first) DESC";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                st1.setInt(1, 20);
                st1.setInt(2, 20);
                ResultSet r = st1.executeQuery();
                count = 9;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)count, (int)r.getInt(1));
                    --count;
                }
                BugsDUnit.assertEquals((int)0, (int)count);
                r.close();
            }
            query = "select c_tid, max(c_id * c_first) as largest_order from trade.customerrep where c_balance > ?  GROUP BY c_tid HAVING max(c_id*c_first) > ? ORDER BY max(c_id*c_first) DESC";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                st1.setInt(1, 20);
                st1.setInt(2, 20);
                ResultSet r = st1.executeQuery();
                count = 9;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)count, (int)r.getInt(1));
                    --count;
                }
                BugsDUnit.assertEquals((int)0, (int)count);
                r.close();
            }
            query = "select c_tid, max(c_id * c_first) as largest_order from trade.customer where c_balance > ?  GROUP BY c_tid HAVING max(c_id*c_first) > ? ORDER BY max(c_id*c_first) DESC OFFSET 3 ROWS FETCH NEXT 2 ROWS ONLY";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                st1.setInt(1, 20);
                st1.setInt(2, 20);
                ResultSet r = st1.executeQuery();
                count = 6;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)count, (int)r.getInt(1));
                    --count;
                }
                BugsDUnit.assertEquals((int)4, (int)count);
                r.close();
            }
            query = "select c_tid, max(c_id * c_first) as largest_order from trade.customerrep where c_balance > ?  GROUP BY c_tid HAVING max(c_id*c_first) > ? ORDER BY max(c_id*c_first) DESC OFFSET 3 ROWS FETCH NEXT 2 ROWS ONLY";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                st1.setInt(1, 20);
                st1.setInt(2, 20);
                ResultSet r = st1.executeQuery();
                count = 6;
                while (r.next()) {
                    BugsDUnit.assertEquals((int)count, (int)r.getInt(1));
                    --count;
                }
                BugsDUnit.assertEquals((int)4, (int)count);
                r.close();
            }
            query = "SELECT (CASE WHEN c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END), count(*) B FROM trade.customer GROUP BY case when c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END ORDER BY B DESC";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                sum = 0;
                while (r.next()) {
                    sum += r.getInt(2);
                    ++count;
                }
                BugsDUnit.assertEquals((int)8, (int)count);
                BugsDUnit.assertEquals((int)30, (int)sum);
                r.close();
            }
            query = "SELECT (CASE WHEN c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END), count(*) B FROM trade.customerrep GROUP BY case when c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END ORDER BY B DESC";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                sum = 0;
                while (r.next()) {
                    sum += r.getInt(2);
                    ++count;
                }
                BugsDUnit.assertEquals((int)8, (int)count);
                BugsDUnit.assertEquals((int)30, (int)sum);
                r.close();
            }
            query = "SELECT (CASE WHEN c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END), count(*) B FROM trade.customer GROUP BY case when c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END ORDER BY B DESC FETCH FIRST 5 ROWS ONLY";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                sum = 0;
                while (r.next()) {
                    sum += r.getInt(2);
                    ++count;
                }
                BugsDUnit.assertEquals((int)5, (int)count);
                BugsDUnit.assertEquals((int)21, (int)sum);
                r.close();
            }
            query = "SELECT (CASE WHEN c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END), count(*) B FROM trade.customerrep GROUP BY case when c_middle < c_next THEN c_middle||c_next ELSE c_next||c_middle END ORDER BY B DESC FETCH FIRST 5 ROWS ONLY";
            st1 = conn.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                ResultSet r = st1.executeQuery();
                count = 0;
                sum = 0;
                while (r.next()) {
                    sum += r.getInt(2);
                    ++count;
                }
                BugsDUnit.assertEquals((int)5, (int)count);
                BugsDUnit.assertEquals((int)21, (int)sum);
                r.close();
            }
            Connection conn1 = TestUtil.getConnection();
            st1 = conn1.createStatement();
            st1.execute("drop table trade.customer");
            st1.execute("drop table trade.customerrep");
            st1.execute("drop schema trade restrict");
        }
        finally {
            TestUtil.shutDown();
        }
    }

    public void testBug48212_48355() throws Exception {
        int locPort = AvailablePort.getRandomAvailablePort((int)0);
        this.startLocatorVM("localhost", locPort, null, null);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        this.startVMs(1, 1, 0, null, props);
        this.serverSQLExecute(2, "CREATE TABLE t.t_1(name varchar(16) primary key, remark varchar(20)) partition by primary key persistent redundancy 1");
        this.startVMs(0, 1, 0, null, props);
        this.serverSQLExecute(3, "CREATE TABLE t.t_2(name varchar(16) primary key, remark varchar(20)) partition by primary key persistent redundancy 1");
        this.stopVMNums(1, -2, -3);
        this.stopVMNums(-1);
        BugsDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                String currentDir = new File(".").getAbsolutePath();
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setIncludes(new String[]{"*GFXD-DEFAULT-DISKSTORE*.*"});
                scanner.setBasedir(currentDir);
                scanner.setCaseSensitive(false);
                scanner.scan();
                for (String file : scanner.getIncludedFiles()) {
                    new File(currentDir, file).delete();
                }
            }
        });
        this.restartLocatorVM(1, "localhost", locPort, null, null);
        this.restartVMNums(new int[]{1, -2}, 0, null, props);
        this.startVMs(0, 1, 0, null, props);
        this.serverSQLExecute(4, "CREATE TABLE t.t_3(name varchar(16) primary key, remark varchar(20)) partition by primary key persistent redundancy 1");
        this.restartVMNums(new int[]{-3}, 0, null, props);
        this.serverSQLExecute(3, "insert into t.t_1 values ('n1', 'r1')");
        this.serverSQLExecute(3, "insert into t.t_2 values ('n1', 'r1')");
        this.serverSQLExecute(3, "insert into t.t_3 values ('n1', 'r1')");
        this.serverSQLExecute(4, "insert into t.t_1 values ('n2', 'r2')");
        this.serverSQLExecute(4, "insert into t.t_2 values ('n2', 'r2')");
        this.serverSQLExecute(3, "insert into t.t_3 values ('n2', 'r2')");
        Statement stmt = TestUtil.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select * from t.t_1 order by name");
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((String)"n1", (String)rs.getString(1));
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((String)"n2", (String)rs.getString(1));
        BugsDUnit.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from t.t_2 order by name");
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((String)"n1", (String)rs.getString(1));
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((String)"n2", (String)rs.getString(1));
        BugsDUnit.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from t.t_3 order by name");
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((String)"n1", (String)rs.getString(1));
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((String)"n2", (String)rs.getString(1));
        BugsDUnit.assertFalse((boolean)rs.next());
        this.clientSQLExecute(1, "CREATE TABLE UNIQUE_SEGMENT_II_TEMP(UNIQUE_ID VARCHAR(50), CUSTOMER_TYPE VARCHAR(20),UNIQUE_SEG_RANK INTEGER) REPLICATE");
        stmt.execute("insert into UNIQUE_SEGMENT_II_TEMP values ('U2', 'T2', 4)");
        stmt.execute("insert into UNIQUE_SEGMENT_II_TEMP values ('U1', 'T1', 1)");
        stmt.execute("insert into UNIQUE_SEGMENT_II_TEMP values ('U2', 'T2', 3)");
        stmt.execute("insert into UNIQUE_SEGMENT_II_TEMP values ('U1', 'T1', 2)");
        rs = stmt.executeQuery("SELECT UNIQUE_ID, CUSTOMER_TYPE, UNIQUE_SEG_RANK FROM UNIQUE_SEGMENT_II_TEMP ORDER BY UNIQUE_SEG_RANK");
        Object[][] expected = new Object[][]{{"U1", "T1", 1}, {"U1", "T1", 2}, {"U2", "T2", 3}, {"U2", "T2", 4}};
        JDBC.assertFullResultSet(rs, expected, false);
    }

    public void testIdentityColumns() throws Throwable {
        int i;
        int i2;
        this.reduceLogLevelForTest("config");
        Properties props = new Properties();
        props.setProperty("conserve-sockets", PartitionedRegion.rand.nextBoolean() ? "true" : "false");
        this.startVMs(1, 1, 0, null, props);
        this.serverSQLExecute(1, "CREATE TABLE t.t_1(id int generated by default as identity primary key, remark varchar(20)) partition by primary key redundancy 2 persistent");
        this.serverSQLExecute(1, "CREATE TABLE t.t_2(remark varchar(20), id2 bigint generated by default as identity (start with 2, increment by 5) primary key) partition by primary key redundancy 2 persistent");
        int numInserts = 1000;
        int numThreads = 100;
        Thread[] threads = new Thread[100];
        final Throwable[] failure = new Throwable[1];
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        PreparedStatement pstmt = conn.prepareStatement("insert into t.t_1(remark) values (?)");
        PreparedStatement pstmt2 = conn.prepareStatement("insert into t.t_2(remark) values (?)");
        for (i2 = 1; i2 <= 1000; ++i2) {
            pstmt.setString(1, "REM" + i2);
            pstmt.executeUpdate();
            pstmt2.setString(1, "REM" + i2);
            pstmt2.executeUpdate();
        }
        stmt.execute("drop table t.t_1");
        stmt.execute("CREATE TABLE t.t_1(id int generated by default as identity primary key, remark varchar(20)) partition by primary key persistent redundancy 2");
        stmt.execute("drop table t.t_2");
        stmt.execute("CREATE TABLE t.t_2(remark varchar(20), id2 bigint generated by default as identity (start with 2, increment by 5) primary key) partition by primary key redundancy 2 persistent");
        for (i2 = 1; i2 <= 1000; ++i2) {
            pstmt.setString(1, "REM" + i2);
            pstmt.executeUpdate();
            pstmt2.setString(1, "REM" + i2);
            pstmt2.executeUpdate();
        }
        stmt.execute("truncate table T.T_1");
        stmt.execute("truncate table T.T_2");
        this.startVMs(0, 3, 0, null, props);
        stmt.execute("call sys.create_all_buckets('T.T_1')");
        stmt.execute("call sys.create_all_buckets('T.T_2')");
        for (i2 = 1; i2 <= 1000; ++i2) {
            pstmt.setString(1, "REM" + i2);
            pstmt.executeUpdate();
            pstmt2.setString(1, "REM" + i2);
            pstmt2.executeUpdate();
        }
        stmt.execute("truncate table T.T_1");
        stmt.execute("truncate table T.T_2");
        stmt.execute("call sys.create_all_buckets('T.T_1')");
        stmt.execute("call sys.create_all_buckets('T.T_2')");
        Runnable doInserts1 = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    PreparedStatement pstmt = conn.prepareStatement("insert into t.t_1(remark) values (?)");
                    for (int i = 1; i <= 1000; ++i) {
                        pstmt.setString(1, "REM" + i);
                        TestCase.assertEquals((int)1, (int)BugsDUnit.executeUpdate(pstmt, null));
                    }
                }
                catch (Throwable t) {
                    failure[0] = t;
                }
            }
        };
        Runnable doInserts2 = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    PreparedStatement pstmt = conn.prepareStatement("insert into t.t_2(remark) values (?)");
                    for (int i = 1; i <= 1000; ++i) {
                        pstmt.setString(1, "REM" + i);
                        TestCase.assertEquals((int)1, (int)BugsDUnit.executeUpdate(pstmt, null));
                    }
                }
                catch (Throwable t) {
                    failure[0] = t;
                }
            }
        };
        for (int i3 = 0; i3 < 100; ++i3) {
            threads[i3] = new Thread(doInserts1);
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            threads[i].join();
        }
        this.getLogWriter().info((Object)("Time taken " + (System.currentTimeMillis() - start) + "ms"));
        if (failure[0] != null) {
            throw failure[0];
        }
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(doInserts2);
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            threads[i].join();
        }
        this.getLogWriter().info((Object)("Time taken " + (System.currentTimeMillis() - start) + "ms"));
        if (failure[0] != null) {
            throw failure[0];
        }
        this.checkIdentityData(conn, 100000, 0, 0);
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(doInserts1);
        }
        for (i = 0; i < 100; ++i) {
            threads[i].start();
        }
        Thread.sleep(500L);
        this.addExpectedException((int[])null, new int[]{1, 2}, new Object[]{CacheClosedException.class, RegionDestroyedException.class, ForceReattemptException.class, BucketMovedException.class, PrimaryBucketException.class});
        this.stopVMNums(-1);
        for (i = 0; i < 100; ++i) {
            threads[i].join();
        }
        if (failure[0] != null) {
            throw failure[0];
        }
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(doInserts2);
        }
        for (i = 0; i < 100; ++i) {
            threads[i].start();
        }
        Thread.sleep(500L);
        this.stopVMNums(-2);
        for (i = 0; i < 100; ++i) {
            threads[i].join();
        }
        if (failure[0] != null) {
            throw failure[0];
        }
        this.checkIdentityData(conn, 100000, 100000, 200);
        this.stopVMNums(-3, -4);
        this.restartVMNums(-1, -2, -3, -4);
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(doInserts1);
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            threads[i].join();
        }
        this.getLogWriter().info((Object)("Time taken " + (System.currentTimeMillis() - start) + "ms"));
        if (failure[0] != null) {
            throw failure[0];
        }
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(doInserts2);
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            threads[i].join();
        }
        this.getLogWriter().info((Object)("Time taken " + (System.currentTimeMillis() - start) + "ms"));
        if (failure[0] != null) {
            throw failure[0];
        }
        this.checkIdentityData(conn, 100000, 200000, 200);
    }

    private void checkIdentityData(Connection conn, int numInserts, int start, int possibleError) throws Exception {
        Statement stmt = conn.createStatement();
        BitSetSet found = new BitSetSet(numInserts + start + possibleError);
        ResultSet rs = stmt.executeQuery("select * from t.t_1");
        while (rs.next()) {
            int id = rs.getInt(1);
            if (id > numInserts + start + possibleError) {
                BugsDUnit.fail((String)("unexpected id=" + id));
            }
            if (found.addInt(id - 1)) continue;
            BugsDUnit.fail((String)("duplicate for " + id));
        }
        int size = found.size();
        if (possibleError == 0) {
            BugsDUnit.assertEquals((int)(numInserts + start), (int)size);
        } else {
            BugsDUnit.assertTrue((String)("unexpected size=" + size + " expected=" + (numInserts + start) + " with error=" + possibleError), (size >= numInserts + start && size <= numInserts + start + possibleError ? 1 : 0) != 0);
        }
        BitSetSet found2 = new BitSetSet(numInserts + start + possibleError);
        rs = stmt.executeQuery("select * from t.t_2");
        while (rs.next()) {
            long id2 = rs.getLong(2);
            long index2 = (id2 - 2L) / 5L;
            if (index2 >= (long)(numInserts + start + possibleError)) {
                BugsDUnit.fail((String)("unexpected id=" + id2));
            }
            if (found2.addInt((int)index2)) continue;
            BugsDUnit.fail((String)("duplicate in id2 for " + id2));
        }
        size = found2.size();
        if (possibleError == 0) {
            if (size != numInserts + start) {
                TIntArrayList missing = new TIntArrayList();
                for (int i = 0; i < numInserts + start; ++i) {
                    if (found2.containsInt(i)) continue;
                    missing.add(i);
                }
                BugsDUnit.fail((String)("unexpected size=" + size + " expected=" + (numInserts + start) + " with error=" + possibleError + ", missing=" + missing));
            }
        } else {
            BugsDUnit.assertTrue((String)("unexpected size=" + size + " expected=" + (numInserts + start) + " with error=" + possibleError), (size >= numInserts + start && size <= numInserts + start + possibleError ? 1 : 0) != 0);
        }
    }

    private String getSymbol(int minLength, int maxLength) {
        int aVal = 97;
        Random rand = new Random();
        int symbolLength = rand.nextInt(maxLength - minLength + 1) + minLength;
        char[] charArray = new char[symbolLength];
        for (int j = 0; j < symbolLength; ++j) {
            charArray[j] = (char)(rand.nextInt(26) + aVal);
        }
        return new String(charArray);
    }

    private void checkMergeResults(CallableStatement cs) throws SQLException {
        ResultSet rs = cs.getResultSet();
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)2, (int)rs.getInt(1));
        BugsDUnit.assertEquals((int)2, (int)rs.getInt(2));
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)2, (int)rs.getInt(1));
        BugsDUnit.assertEquals((int)2, (int)rs.getInt(2));
        BugsDUnit.assertTrue((boolean)rs.next());
        BugsDUnit.assertEquals((int)3, (int)rs.getInt(1));
        BugsDUnit.assertEquals((int)3, (int)rs.getInt(2));
        BugsDUnit.assertFalse((boolean)rs.next());
    }

    public void test48808() throws Exception {
        int i;
        this.reduceLogLevelForTest("config");
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        stmt.execute("create function trade.getLowPrice(DP1 trade.UDTPrice) RETURNS NUMERIC PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'udtexamples.UDTPrice.getLowPrice'");
        stmt.execute("create function trade.createPrice(low NUMERIC(6,2), high NUMERIC(6,2)) RETURNS trade.UDTPrice PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'udtexamples.UDTPrice.setPrice'");
        stmt.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, tid int,constraint comp_pk primary key (companyname)) partition by column(histprice)");
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.companies values (?,?,?,?,?,?,?,?)");
        UDTPrice udt = new UDTPrice(new BigDecimal("27.58"), new BigDecimal("37.58"));
        for (i = 1; i < 20; ++i) {
            pstmt.setString(1, "sym" + i);
            pstmt.setString(2, "e" + i);
            pstmt.setInt(3, i);
            pstmt.setString(4, "c" + i);
            pstmt.setString(5, "ci" + i);
            pstmt.setString(6, "Q" + i + "\"6>$?3-D=T");
            pstmt.setObject(7, udt);
            pstmt.setInt(8, i * 2);
            BugsDUnit.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        stmt.execute("call sys.rebalance_all_buckets()");
        pstmt = conn.prepareStatement("update trade.companies set tid=? where histprice=? and symbol=?");
        for (i = 1; i < 20; ++i) {
            pstmt.setInt(1, i);
            pstmt.setObject(2, udt);
            pstmt.setString(3, "sym" + i);
            BugsDUnit.assertEquals((String)("failed for i=" + i), (int)1, (int)pstmt.executeUpdate());
        }
        pstmt = conn.prepareStatement("delete from trade.companies where tid=? and trade.getLowPrice(histPrice) <=? and note like ? and companyType = ?");
        for (i = 1; i < 20; ++i) {
            pstmt.setInt(1, i);
            pstmt.setBigDecimal(2, new BigDecimal("27.58"));
            pstmt.setString(3, "%" + i + "\"%");
            pstmt.setInt(4, i);
            BugsDUnit.assertEquals((String)("failed for i=" + i), (int)1, (int)pstmt.executeUpdate());
        }
        ResultSet rs = stmt.executeQuery("select * from trade.companies");
        JDBC.assertEmpty(rs);
    }

    public void test47662() throws Exception {
        int effected;
        int i;
        this.startVMs(0, 2);
        int netPort = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        TestUtil.deletePersistentFiles = true;
        Properties connProps = new Properties();
        connProps.setProperty("load-balance", "false");
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn = DriverManager.getConnection(url, connProps);
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.txhistory (cid int, sid int, tid int)  partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000)  REDUNDANCY 1");
        PreparedStatement ps = conn.prepareStatement("insert into trade.txhistory values (?,?,?)");
        for (i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i);
            effected = ps.executeUpdate();
            BugsDUnit.assertEquals((int)1, (int)effected);
        }
        ps.close();
        conn.close();
        this.stopVMNums(-1);
        this.restartVMNums(-1);
        netPort = this.startNetworkServer(1, null, null);
        this.stopVMNums(-2);
        this.restartVMNums(-2);
        this.startNetworkServer(2, null, null);
        url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        conn = DriverManager.getConnection(url, connProps);
        ps = conn.prepareStatement("insert into trade.txhistory values (?,?,?)");
        for (i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i);
            effected = ps.executeUpdate();
            BugsDUnit.assertEquals((int)1, (int)effected);
        }
    }

    public void testBug49621() throws Exception {
        this.startVMs(0, 1);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("create table testBug49621(id int)");
        Connection conn2 = TestUtil.getNetConnection(netPort, null, null);
        PreparedStatement ps = conn2.prepareStatement("insert into testBug49621 values(?)");
        ps.close();
        conn2.close();
        stmt.execute("drop table testBug49621");
        stmt.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug51249() throws Exception {
        Properties authProp = new Properties();
        authProp.setProperty("gemfirexd.auth-provider", "BUILTIN");
        authProp.setProperty("table-default-partitioned", "false");
        String sysUser = "USECASE11_SYSTEM_USER";
        String sysPwd = "USECASE11_SYSTEM_USER_PWD";
        try {
            authProp.setProperty("gemfirexd.user.USECASE11_SYSTEM_USER", AuthenticationServiceBase.encryptPassword((String)"USECASE11_SYSTEM_USER", (String)"USECASE11_SYSTEM_USER_PWD"));
            authProp.setProperty("user", "USECASE11_SYSTEM_USER");
            authProp.setProperty("password", "USECASE11_SYSTEM_USER_PWD");
        }
        catch (StandardException se) {
            throw new IllegalArgumentException(se);
        }
        BugsDUnit.invokeInEveryVM((SerializableCallable)new SerializableCallable(){

            public Object call() throws Exception {
                TestUtil.bootUserName = "USECASE11_SYSTEM_USER";
                TestUtil.bootUserPassword = "USECASE11_SYSTEM_USER_PWD";
                return null;
            }
        });
        int locPort1 = AvailablePort.getRandomAvailablePort((int)0);
        this.startLocatorVM("localhost", locPort1, null, authProp);
        int locPort2 = AvailablePort.getRandomAvailablePort((int)0);
        this.startLocatorVM("localhost", locPort2, null, authProp);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort1 + "]");
        props.putAll((Map<?, ?>)authProp);
        props.setProperty("log-level", "info");
        this.startVMs(1, 2, 0, null, props);
        int netPort1 = this.startNetworkServer(1, null, props);
        int netPort2 = this.startNetworkServer(2, null, props);
        int netPort3 = this.startNetworkServer(3, null, props);
        int netPort4 = this.startNetworkServer(4, null, props);
        Connection conn = TestUtil.getNetConnection(netPort1, null, props);
        String basePath = TestUtil.getResourcesDir() + "/lib/useCase11/51249/";
        String ddls = basePath + "/ddl";
        File ddlFiles = new File(ddls);
        BugsDUnit.assertTrue((ddlFiles.exists() && ddlFiles.isDirectory() ? 1 : 0) != 0);
        File[] files = ddlFiles.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        String[] scripts = new String[files.length];
        int i = 0;
        for (File ddl : files) {
            this.getLogWriter().info((Object)("Picking up " + ddl.getAbsolutePath()));
            scripts[i++] = ddl.getAbsolutePath();
        }
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])scripts, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)true);
        this.getLogWriter().info((Object)"About to import data that takes around one minute.");
        String localHostName = SocketCreator.getLocalHost().getHostName();
        ByteArrayOutputStream output = new ByteArrayOutputStream(20480);
        try {
            MiscTools.outputStream = new PrintStream(output);
            MiscTools.main((String[])new String[]{"run", "-path=" + basePath + "/data/", "-file=" + basePath + "/queries/import.sql", "-client-port=" + netPort1, "-client-bind-address=" + localHostName, "-user=USECASE11_SYSTEM_USER", "-password=USECASE11_SYSTEM_USER_PWD"});
            this.getLogWriter().info((Object)output.toString());
        }
        finally {
            MiscTools.outputStream = null;
        }
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{basePath + "/queries/queryOk_1.sql"}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)true);
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{basePath + "/queries/queryOk_2.sql"}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)true);
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{basePath + "/queries/queryOk_3.sql"}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)true);
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{basePath + "/queries/queryFail.sql"}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTMG_GEMXD_1() throws Exception {
        this.reduceLogLevelForTest("config");
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE t1 (c1 int primary key, c2 int not null) partition by primary key persistent asynchronous");
        stmt.execute("CREATE DISKSTORE ds1");
        stmt.execute("CREATE TABLE t2 (c1 int not null, c2 int not null) replicate persistent 'ds1'");
        for (int i = 1; i <= 5; ++i) {
            stmt.execute("insert into t1 values (" + i + ", " + (i + 1) + ')');
            stmt.execute("insert into t2 values (" + i + ", " + (i + 1) + ')');
        }
        Object[][] expected = new Object[][]{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}};
        ResultSet rs = stmt.executeQuery("select * from t1");
        JDBC.assertUnorderedResultSet(rs, expected, false);
        rs = stmt.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, expected, false);
        this.stopVMNums(-1, -2, -3);
        BugsDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("set recoverValuesSync"){

            public void run() {
                System.setProperty(DiskStoreImpl.RECOVER_VALUES_SYNC_PROPERTY_NAME, "true");
            }
        });
        try {
            this.restartVMNums(-1, -2, -3);
            rs = stmt.executeQuery("select * from t1");
            JDBC.assertUnorderedResultSet(rs, expected, false);
            rs = stmt.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, expected, false);
            conn.close();
        }
        catch (Throwable throwable) {
            BugsDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("clear recoverValuesSync"){

                public void run() {
                    System.clearProperty(DiskStoreImpl.RECOVER_VALUES_SYNC_PROPERTY_NAME);
                }
            });
            throw throwable;
        }
        BugsDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
    }

    static class GIIExceptionThrower
    implements InitialImageOperation.TEST_GII_EXCEPTION {
        int after = 0;
        int cnt = 0;

        public GIIExceptionThrower(int after) {
            this.after = after;
        }

        public void throwException() {
            DistributedTestBase.getGlobalLogger().info((Object)"GIIExceptionThrower.throwExceptionDuringGII called", (Throwable)new Exception());
            if (this.cnt == this.after) {
                DistributedTestBase.getGlobalLogger().info((Object)"GIIExceptionThrower.throwExceptionDuringGII actually throwing exception");
                throw new RuntimeException();
            }
            ++this.cnt;
        }
    }

    public static class CacheCloser
    extends GemFireXDQueryObserverAdapter {
        public void invokeCacheCloseAtMultipleInsert() {
            throw new CacheClosedException("just for testing");
        }

        public boolean isCacheClosedForTesting() {
            return true;
        }
    }
}

