/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.jdbc.AlterTableTest;
import com.pivotal.gemfirexd.jdbc.CreateTableTest;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AlterTableDUnit
extends DistributedSQLTestBase {
    private static final String DISKSTORE = "TestPersistentAlterTable";

    public AlterTableDUnit(String name) {
        super(name);
    }

    private String getPersistenceSuffix() {
        return " PERSISTENT 'TestPersistentAlterTable'";
    }

    private String getPRSuffix() {
        return " REDUNDANCY 2";
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        FileUtil.delete((File)new File("DSYS"));
        FileUtil.delete((File)new File("DSYS2"));
    }

    public void testConstraints() throws Exception {
        this.startVMs(1, 1);
        TestUtil.addExpectedException(EntryExistsException.class);
        this.serverSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
        String ckFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, "select * from trade.customers", ckFile, "empty");
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        CreateTableTest.populateData(conn, false, true);
        try {
            this.serverSQLExecute(1, "alter table trade.customers add constraint cust_pk primary key (cid)");
            AlterTableDUnit.fail((String)"Expected unsupported exception for PK add in ALTER TABLE");
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                SQLException sqlEx = (SQLException)ex.getCause();
                if (!"0A000".equals(sqlEx.getSQLState())) {
                    throw ex;
                }
            }
            throw ex;
        }
        this.clientSQLExecute(1, "drop table trade.customers");
        this.serverSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
        this.serverSQLExecute(1, "alter table trade.customers add constraint cust_pk primary key (cid)");
        CreateTableTest.populateData(conn, false, true);
        this.startVMs(0, 1);
        this.serverSQLExecute(1, "alter table trade.customers add constraint cust_uk unique (tid)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from trade.customers", null, "100");
        AlterTableTest.ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
        AlterTableTest.ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
        Properties props = new Properties();
        props.setProperty("sys-disk-dir", "DSYS");
        props.setProperty("persist-dd", "true");
        this.startVMs(0, 1, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.customers", null, "100");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.serverSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
        this.serverSQLExecute(3, "alter table trade.customers add constraint cust_uk unique (tid)");
        this.clientSQLExecute(1, "alter table trade.customers add constraint cust_pk primary key (cid)");
        CreateTableTest.populateData(conn, false, true);
        AlterTableTest.ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
        AlterTableTest.ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
        this.stopVMNums(-1, 1);
        this.stopVMNums(-3, -2);
        this.addExpectedException(null, new int[]{1, 2, 3}, EntryNotFoundException.class);
        DistributedSQLTestBase.AsyncVM async1 = this.restartServerVMAsync(1, 0, null, props);
        DistributedSQLTestBase.AsyncVM async2 = this.restartServerVMAsync(2, 0, null, null);
        props.setProperty("sys-disk-dir", "DSYS2");
        props.setProperty("persist-dd", "true");
        this.waitForDDCreation(-2);
        DistributedSQLTestBase.AsyncVM async3 = this.restartServerVMAsync(3, 0, null, props);
        this.restartVMNums(1);
        this.joinVMs(false, async1, async2, async3);
        this.removeExpectedException(null, new int[]{1, 2, 3}, EntryNotFoundException.class);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from trade.customers", ckFile, "empty");
        CreateTableTest.populateData(TestUtil.jdbcConn, false, true);
        this.serverSQLExecute(1, "call sys.rebalance_all_buckets()");
        VM datastore1 = (VM)this.serverVMs.get(0);
        VM datastore2 = (VM)this.serverVMs.get(1);
        VM datastore3 = (VM)this.serverVMs.get(2);
        VM client1 = (VM)this.clientVMs.get(0);
        SelectQueryInfo[] sqi = new SelectQueryInfo[1];
        this.setupObservers(new VM[]{datastore1, datastore2, datastore3}, sqi);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver on DataStore Node"){

            public void run() throws CacheException {
                try {
                    isQueryExecutedOnNode = false;
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                            AlterTableDUnit.this.getLogWriter().info((Object)("Invoked DistributedSQLTestBase query observer for prepared statement query: " + rs.getActivation().getPreparedStatement().getUserQueryString(rs.getActivation().getLanguageConnectionContext())));
                            isQueryExecutedOnNode = true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        setObserver.run();
        this.sqlExecuteVerify(new int[]{1}, null, "select count(*) from trade.customers", null, "100");
        this.checkQueryExecution(false, datastore1, datastore2, datastore3, client1);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverHolder());
        datastore2.invoke((Runnable)setObserver);
        this.sqlExecuteVerify(null, new int[]{2}, "select count(*) from trade.customers", null, "100");
        this.checkQueryExecution(false, datastore1, datastore2, datastore3);
        this.setupObservers(new VM[]{datastore2}, sqi);
        datastore3.invoke((Runnable)setObserver);
        this.sqlExecuteVerify(null, new int[]{3}, "select count(*) from trade.customers", null, "100");
        this.checkQueryExecution(false, datastore1, datastore2, datastore3);
        this.setupObservers(new VM[]{datastore3}, sqi);
        datastore1.invoke((Runnable)setObserver);
        this.sqlExecuteVerify(null, new int[]{1}, "select count(*) from trade.customers", null, "100");
        this.checkQueryExecution(false, datastore1, datastore2, datastore3);
        TestUtil.removeExpectedException(EntryExistsException.class);
    }

    public void testConstraintsWithGlobalOrHashIndex_42514() throws Exception {
        int index;
        Properties props = new Properties();
        props.setProperty("disable-streaming", "true");
        this.startVMs(1, 3, 0, null, props);
        this.serverExecute(2, (Runnable)AlterTableDUnit.getDiskStoreCreator(DISKSTORE));
        this.serverSQLExecute(2, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))" + this.getPRSuffix());
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))" + this.getPRSuffix());
        this.serverSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) partition by column (cid, sid)" + this.getPRSuffix());
        this.serverSQLExecute(3, "create table tradep.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))" + this.getPRSuffix() + this.getPersistenceSuffix());
        this.clientSQLExecute(1, "create table tradep.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id, tid), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))" + this.getPRSuffix() + this.getPersistenceSuffix());
        this.serverSQLExecute(2, "create table tradep.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references tradep.customers (cid) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) partition by column (cid, sid)" + this.getPRSuffix() + this.getPersistenceSuffix());
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.customers", null, "0");
        Connection conn = TestUtil.jdbcConn;
        CreateTableTest.populateData(conn, true, false);
        CreateTableTest.populateData(conn, true, false, false, false, false, "tradep.customers", "tradep.portfolio");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.customers", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.portfolio", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from tradep.customers", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from tradep.portfolio", null, "100");
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{SQLException.class, EntryExistsException.class});
        this.checkKeyViolation(1, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        this.checkKeyViolation(-1, "alter table tradep.portfolio add constraint sec_fk foreign key (sid, tid) references tradep.securities (sec_id, tid)", "X0Y45", "FK violation");
        PreparedStatement prepStmt = conn.prepareStatement("insert into trade.securities (sec_id, symbol, exchange, tid) values (?, ?, ?, ?)");
        PreparedStatement prepStmt2 = conn.prepareStatement("insert into tradep.securities (sec_id, symbol, exchange, tid) values (?, ?, ?, ?)");
        for (index = 20; index < 70; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "amex");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        for (index = 20; index < 70; ++index) {
            prepStmt2.setInt(1, index + 2);
            prepStmt2.setString(2, "SYM" + index);
            prepStmt2.setString(3, "amex");
            prepStmt2.setInt(4, index);
            prepStmt2.execute();
        }
        this.checkKeyViolation(-2, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        this.checkKeyViolation(-3, "alter table tradep.portfolio add constraint sec_fk foreign key (sid, tid) references tradep.securities (sec_id, tid)", "X0Y45", "FK violation");
        for (index = 0; index < 20; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "fse");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        for (index = 71; index < 100; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "nasdaq");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        for (index = 0; index < 20; ++index) {
            prepStmt2.setInt(1, index + 2);
            prepStmt2.setString(2, "SYM" + index);
            prepStmt2.setString(3, "fse");
            prepStmt2.setInt(4, index);
            prepStmt2.execute();
        }
        for (index = 71; index < 100; ++index) {
            prepStmt2.setInt(1, index + 2);
            prepStmt2.setString(2, "SYM" + index);
            prepStmt2.setString(3, "nasdaq");
            prepStmt2.setInt(4, index);
            prepStmt2.execute();
        }
        this.checkKeyViolation(-1, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        this.checkKeyViolation(1, "alter table tradep.portfolio add constraint sec_fk foreign key (sid, tid) references tradep.securities (sec_id, tid)", "X0Y45", "FK violation");
        index = 70;
        prepStmt.setInt(1, index + 2);
        prepStmt.setString(2, "SYM" + index);
        prepStmt.setString(3, "fse");
        prepStmt.setInt(4, index);
        prepStmt.execute();
        this.clientSQLExecute(1, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)");
        prepStmt2.setInt(1, index + 2);
        prepStmt2.setString(2, "SYM" + index);
        prepStmt2.setString(3, "fse");
        prepStmt2.setInt(4, index);
        prepStmt2.execute();
        this.serverSQLExecute(1, "alter table tradep.portfolio add constraint sec_fk foreign key (sid, tid) references tradep.securities (sec_id, tid)");
        for (index = 120; index < 150; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "nye");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        this.serverSQLExecute(1, "alter table trade.portfolio drop constraint sec_fk");
        this.serverSQLExecute(3, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)");
        for (index = 120; index < 150; ++index) {
            prepStmt2.setInt(1, index + 2);
            prepStmt2.setString(2, "SYM" + index);
            prepStmt2.setString(3, "nye");
            prepStmt2.setInt(4, index);
            prepStmt2.execute();
        }
        this.serverSQLExecute(2, "alter table tradep.portfolio drop constraint sec_fk");
        this.clientSQLExecute(1, "alter table tradep.portfolio add constraint sec_fk foreign key (sid, tid) references tradep.securities (sec_id, tid)");
        this.serverSQLExecute(2, "alter table trade.portfolio drop constraint sec_fk");
        this.clientSQLExecute(1, "delete from trade.securities where sec_id=32");
        this.checkKeyViolation(-3, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        this.serverSQLExecute(3, "alter table tradep.portfolio drop constraint sec_fk");
        this.serverSQLExecute(2, "delete from tradep.securities where sec_id=62");
        this.checkKeyViolation(-2, "alter table tradep.portfolio add constraint sec_fk foreign key (sid, tid) references tradep.securities (sec_id, tid)", "X0Y45", "FK violation");
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{SQLException.class, EntryExistsException.class});
        index = 30;
        prepStmt.setInt(1, index + 2);
        prepStmt.setString(2, "SYM" + index);
        prepStmt.setString(3, "hkse");
        prepStmt.setInt(4, index);
        prepStmt.execute();
        this.serverSQLExecute(2, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)");
        index = 60;
        prepStmt2.setInt(1, index + 2);
        prepStmt2.setString(2, "SYM" + index);
        prepStmt2.setString(3, "hkse");
        prepStmt2.setInt(4, index);
        prepStmt2.execute();
        this.serverSQLExecute(1, "alter table tradep.portfolio add constraint sec_fk foreign key (sid, tid) references tradep.securities (sec_id, tid)");
        this.startVMs(0, 1);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.customers", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.securities", null, "130");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.portfolio", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from tradep.customers", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from tradep.securities", null, "130");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from tradep.portfolio", null, "100");
        this.addExpectedException((int[])null, new int[]{2, 3}, new Object[]{PartitionOfflineException.class, ForceReattemptException.class});
        this.stopVMNums(-2, -3);
        props.setProperty("sys-disk-dir", "DSYS");
        props.setProperty("persist-dd", "true");
        this.restartServerVMNums(new int[]{2}, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 4}, "select count(*) from trade.securities", null, "130");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 4}, "select count(*) from trade.portfolio", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 4}, "select count(*) from tradep.securities", null, "130");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 4}, "select count(*) from tradep.portfolio", null, "100");
        this.addExpectedException((int[])null, new int[]{1, 2, 4}, new Object[]{PartitionOfflineException.class, ForceReattemptException.class});
        this.stopVMNums(1, -1, -2, -4);
        this.getServerVM(3).invoke(DistributedSQLTestBase.class, "deleteDataDictionaryDir");
        props.setProperty("sys-disk-dir", "DSYS");
        props.setProperty("persist-dd", "true");
        Properties testProps = new Properties();
        testProps.put("test.expected-startup-exceptions", new Object[]{PartitionOfflineException.class.getName()});
        testProps.setProperty("disable-streaming", "true");
        props.put("test.expected-startup-exceptions", new Object[]{PartitionOfflineException.class.getName()});
        DistributedSQLTestBase.AsyncVM async1 = this.restartServerVMAsync(1, 0, null, testProps);
        DistributedSQLTestBase.AsyncVM async2 = this.restartServerVMAsync(2, 0, null, props);
        DistributedSQLTestBase.AsyncVM async4 = this.restartServerVMAsync(4, 0, null, testProps);
        this.waitForDDCreation(-2);
        DistributedSQLTestBase.AsyncVM async3 = this.restartServerVMAsync(3, 0, null, testProps);
        this.restartVMNums(1);
        this.joinVMs(false, async1, async2, async3, async4);
        this.serverSQLExecute(3, "call sys.rebalance_all_buckets()");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.customers", null, "0");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.securities", null, "0");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.portfolio", null, "0");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from tradep.customers", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from tradep.securities", null, "130");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from tradep.portfolio", null, "100");
    }

    public void testConstraintsWithGlobalOrHashIndex_42514_2() throws Exception {
        int index;
        Properties props = new Properties();
        props.setProperty("persist-dd", "false");
        this.startVMs(1, 3, 0, null, props);
        this.serverExecute(2, (Runnable)AlterTableDUnit.getDiskStoreCreator(DISKSTORE));
        this.serverSQLExecute(2, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))" + this.getPRSuffix());
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))" + this.getPRSuffix());
        this.serverSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) partition by column (cid, sid)" + this.getPRSuffix());
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.customers", null, "0");
        Connection conn = TestUtil.jdbcConn;
        CreateTableTest.populateData(conn, true, false);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.customers", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.portfolio", null, "100");
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{SQLException.class, EntryExistsException.class});
        this.checkKeyViolation(1, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        PreparedStatement prepStmt = conn.prepareStatement("insert into trade.securities (sec_id, symbol, exchange, tid) values (?, ?, ?, ?)");
        for (index = 20; index < 70; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "amex");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        this.checkKeyViolation(-2, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        for (index = 0; index < 20; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "fse");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        for (index = 71; index < 100; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "nasdaq");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        this.checkKeyViolation(-1, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        index = 70;
        prepStmt.setInt(1, index + 2);
        prepStmt.setString(2, "SYM" + index);
        prepStmt.setString(3, "fse");
        prepStmt.setInt(4, index);
        prepStmt.execute();
        this.clientSQLExecute(1, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)");
        for (index = 120; index < 150; ++index) {
            prepStmt.setInt(1, index + 2);
            prepStmt.setString(2, "SYM" + index);
            prepStmt.setString(3, "nye");
            prepStmt.setInt(4, index);
            prepStmt.execute();
        }
        this.serverSQLExecute(1, "alter table trade.portfolio drop constraint sec_fk");
        this.serverSQLExecute(3, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)");
        this.serverSQLExecute(2, "alter table trade.portfolio drop constraint sec_fk");
        this.clientSQLExecute(1, "delete from trade.securities where sec_id=32");
        this.checkKeyViolation(-3, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)", "X0Y45", "FK violation");
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{SQLException.class, EntryExistsException.class});
        index = 30;
        prepStmt.setInt(1, index + 2);
        prepStmt.setString(2, "SYM" + index);
        prepStmt.setString(3, "hkse");
        prepStmt.setInt(4, index);
        prepStmt.execute();
        this.serverSQLExecute(2, "alter table trade.portfolio add constraint sec_fk foreign key (sid) references trade.securities (sec_id)");
        index = 60;
        this.startVMs(0, 1, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.customers", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.securities", null, "130");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3, 4}, "select count(*) from trade.portfolio", null, "100");
        this.addExpectedException(null, new int[]{2, 3}, PartitionOfflineException.class);
        this.stopVMNums(-2, -3);
        props.setProperty("persist-dd", "false");
        this.restartServerVMNums(new int[]{2}, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 4}, "select count(*) from trade.securities", null, "130");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 4}, "select count(*) from trade.portfolio", null, "100");
    }

    public void testColumns() throws Exception {
        this.startVMs(1, 1);
        TestUtil.addExpectedException(EntryExistsException.class);
        this.serverSQLExecute(1, "create table trade.customers (cust_name varchar(100), tid int)");
        String ckFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, "select * from trade.customers", ckFile, "empty");
        this.clientSQLExecute(1, "insert into trade.customers (cust_name, tid) values ('CUST1', 1)");
        Connection conn = TestUtil.jdbcConn;
        AlterTableTest.checkAddColumnWithData(conn);
        this.clientSQLExecute(1, "drop table trade.customers");
        this.serverSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
        this.clientSQLExecute(1, "alter table trade.customers drop column tid cascade");
        this.serverSQLExecute(1, "alter table trade.customers add column tid int not null default 1");
        CreateTableTest.populateData(conn, false, true);
        this.startVMs(0, 1);
        this.clientSQLExecute(1, "alter table trade.customers drop column cid cascade");
        this.serverSQLExecute(1, "alter table trade.customers drop column tid cascade");
        this.serverSQLExecute(1, "alter table trade.customers add column tid int not null default 1");
        PreparedStatement prepStmt = conn.prepareStatement("alter table trade.customers add column cid int not null default 1");
        prepStmt.execute();
        SerializableRunnable checkData = new SerializableRunnable(){
            boolean afterUpdate = false;

            public void run() {
                try {
                    AlterTableTest.verifyAddColumnWithData(TestUtil.getConnection(), 100, this.afterUpdate);
                    this.afterUpdate = true;
                }
                catch (SQLException sqle) {
                    AlterTableDUnit.this.getLogWriter().error((Object)"unexpected exception", (Throwable)sqle);
                    DistributedSQLTestBase.fail("unexpected exception", sqle);
                }
            }
        };
        checkData.run();
        this.serverExecute(1, (Runnable)checkData);
        this.serverExecute(2, (Runnable)checkData);
        Properties props = new Properties();
        props.setProperty("sys-disk-dir", "DSYS");
        props.setProperty("persist-dd", "true");
        this.startVMs(0, 1, 0, null, props);
        checkData.run();
        this.serverExecute(1, (Runnable)checkData);
        this.serverExecute(2, (Runnable)checkData);
        this.serverExecute(3, (Runnable)checkData);
        this.clientSQLExecute(1, "drop table trade.customers");
        this.serverSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
        this.serverSQLExecute(3, "alter table trade.customers drop column tid cascade");
        this.serverSQLExecute(3, "alter table trade.customers add column sid int not null default 1");
        this.clientSQLExecute(1, "alter table trade.customers add column tid int not null default 1");
        CreateTableTest.populateData(conn, false, true);
        this.stopVMNums(-1, 1);
        this.stopVMNums(-3, -2);
        DistributedSQLTestBase.AsyncVM async1 = this.restartServerVMAsync(1, 0, null, props);
        DistributedSQLTestBase.AsyncVM async2 = this.restartServerVMAsync(2, 0, null, null);
        props.setProperty("sys-disk-dir", "DSYS2");
        props.setProperty("persist-dd", "true");
        this.waitForDDCreation(-2);
        DistributedSQLTestBase.AsyncVM async3 = this.restartServerVMAsync(3, 0, null, props);
        this.restartVMNums(1);
        this.joinVMs(false, async1, async2, async3);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.customers", null, "0");
        CreateTableTest.populateData(TestUtil.jdbcConn, false, true);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from trade.customers", null, "100");
        conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("drop table trade.customers");
        CreateTableTest.createTables(conn);
        AlterTableTest.checkDropColumnWithData(conn);
        SerializableRunnable verifyDrop = new SerializableRunnable(){

            public void run() {
                try {
                    AlterTableTest.verifyDropColumnWithData(TestUtil.getConnection(), true, false, false, false);
                }
                catch (SQLException sqle) {
                    AlterTableDUnit.this.getLogWriter().error((Object)"unexpected exception", (Throwable)sqle);
                    DistributedSQLTestBase.fail("unexpected exception", sqle);
                }
            }
        };
        this.serverExecute(1, (Runnable)verifyDrop);
        this.serverExecute(2, (Runnable)verifyDrop);
        this.serverExecute(3, (Runnable)verifyDrop);
        int netPort = this.startNetworkServer(2, null, null);
        conn = TestUtil.getNetConnection(netPort, null, null);
        stmt.execute("drop table trade.portfolio");
        stmt = conn.createStatement();
        stmt.execute("drop table trade.customers");
        CreateTableTest.createTables(conn);
        AlterTableTest.checkDropColumnWithData(conn);
        this.serverExecute(1, (Runnable)verifyDrop);
        this.serverExecute(2, (Runnable)verifyDrop);
        this.serverExecute(3, (Runnable)verifyDrop);
        TestUtil.removeExpectedException(EntryExistsException.class);
    }

    public void testTruncateTable() throws Exception {
        Statement stmt;
        Connection conn;
        block2: {
            this.startVMs(1, 2);
            TestUtil.addExpectedException(EntryExistsException.class);
            conn = TestUtil.jdbcConn;
            CreateTableTest.createTables(conn);
            stmt = conn.createStatement();
            this.serverSQLExecute(1, "alter table trade.portfolio add constraint port_uk unique (tid)");
            CreateTableTest.populateData(conn, true, false);
            AlterTableTest.checkConstraints(stmt, AlterTableTest.ConstraintNumber.CUST_PK, AlterTableTest.ConstraintNumber.CUST_UK, AlterTableTest.ConstraintNumber.CUST_FK, AlterTableTest.ConstraintNumber.PORT_PK, AlterTableTest.ConstraintNumber.PORT_CK1, AlterTableTest.ConstraintNumber.PORT_CK2);
            this.clientSQLExecute(1, "truncate table trade.portfolio");
            this.serverSQLExecute(1, "delete from trade.customers where 1=1");
            CreateTableTest.populateData(conn, true, false);
            AlterTableTest.checkConstraints(stmt, AlterTableTest.ConstraintNumber.CUST_PK, AlterTableTest.ConstraintNumber.CUST_UK, AlterTableTest.ConstraintNumber.CUST_FK, AlterTableTest.ConstraintNumber.PORT_PK, AlterTableTest.ConstraintNumber.PORT_CK1, AlterTableTest.ConstraintNumber.PORT_CK2);
            try {
                stmt.execute("truncate table trade.customers");
                AlterTableDUnit.fail((String)"Expected exception in truncate table due to child table");
            }
            catch (SQLException ex) {
                if ("XCL48".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        this.clientSQLExecute(1, "drop table trade.portfolio");
        this.serverSQLExecute(1, "truncate table trade.customers");
        CreateTableTest.populateData(conn, false, true);
        AlterTableTest.ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
        AlterTableTest.ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
        this.clientSQLExecute(1, "truncate table trade.customers");
        CreateTableTest.populateData(conn, false, true);
        AlterTableTest.ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
        AlterTableTest.ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
        stmt.execute("drop table trade.customers");
        TestUtil.removeExpectedException(EntryExistsException.class);
    }

    public void test44231() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        String script = TestUtil.getResourcesDir() + "/lib/bug44231.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{script}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)false);
        this.stopVMNums(-1, -2);
        this.restartVMNums(-1, -2);
        ResultSet rs = conn.createStatement().executeQuery("select empno from emp where deptno=10 order by empno");
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)7782, (int)rs.getInt(1));
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)7839, (int)rs.getInt(1));
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)7934, (int)rs.getInt(1));
        AlterTableDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select deptno, job from emp where empno=7654");
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)30, (int)rs.getInt(1));
        AlterTableDUnit.assertEquals((String)"SALESMAN", (String)rs.getString(2));
        AlterTableDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select deptno, job from emp where empno=7655");
        AlterTableDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select deptno, job from emp where empno=7654");
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)30, (int)rs.getInt(1));
        AlterTableDUnit.assertEquals((String)"SALESMAN", (String)rs.getString(2));
        AlterTableDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select deptno, job from emp where empno=7876");
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)20, (int)rs.getInt(1));
        AlterTableDUnit.assertEquals((String)"CLERK", (String)rs.getString(2));
        AlterTableDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select deptno, job from emp where empno=7872");
        AlterTableDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select deptno, job from emp where empno=7654");
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)30, (int)rs.getInt(1));
        AlterTableDUnit.assertEquals((String)"SALESMAN", (String)rs.getString(2));
        AlterTableDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select deptno, job from emp where empno=7698");
        AlterTableDUnit.assertTrue((boolean)rs.next());
        AlterTableDUnit.assertEquals((int)30, (int)rs.getInt(1));
        AlterTableDUnit.assertEquals((String)"MANAGER", (String)rs.getString(2));
        AlterTableDUnit.assertFalse((boolean)rs.next());
        conn.createStatement().execute("delete from emp");
        conn.createStatement().execute("delete from dept");
    }

    public void testAddGeneratedIdentityColumn() throws Exception {
        int v;
        this.startServerVMs(3, 0, null, null);
        this.startClientVMs(1, 0, null, null);
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (tid int, cid int not null, primary key (cid), constraint cust_ck check (cid >= 0))");
        int maxValue = 1000;
        int stepValue = 3;
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.customers values (?, ?)");
        for (int v2 = 1; v2 <= 1000; v2 += stepValue) {
            pstmt.setInt(1, v2 * stepValue);
            pstmt.setInt(2, v2);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("alter table trade.customers alter column cid SET GENERATED ALWAYS AS IDENTITY");
        SQLWarning sw = stmt.getWarnings();
        AlterTableDUnit.assertNull((Object)sw);
        int numRows = 2000;
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, -1000, 3, this, true);
        stmt.execute("drop table trade.customers");
        stmt.execute("create table trade.customers (tid int, cid bigint not null, addr varchar(100), primary key (cid), constraint cust_ck check (cid >= 0))");
        stepValue = 2;
        pstmt = conn.prepareStatement("insert into trade.customers (cid, tid) values (?, ?)");
        for (v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(2, v);
            pstmt.setInt(1, v * stepValue);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("alter table trade.customers alter cid SET GENERATED ALWAYS AS IDENTITY");
        AlterTableDUnit.assertNull((Object)stmt.getWarnings());
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, -(1000 * stepValue), 3, this, true);
        stmt.execute("drop table trade.customers");
        stmt.execute("create table trade.customers (tid int, cid int not null, primary key (cid), constraint cust_ck check (cid >= 0)) persistent");
        pstmt = conn.prepareStatement("insert into trade.customers values (?, ?)");
        for (v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(1, v * stepValue);
            pstmt.setInt(2, v);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("alter table trade.customers alter column cid SET GENERATED ALWAYS AS IDENTITY");
        sw = stmt.getWarnings();
        AlterTableDUnit.assertNull((Object)sw);
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, -1000, 3, this, true);
        this.stopVMNums(1, -1, -2, -3);
        this.restartServerVMNums(new int[]{1, 2, 3}, 0, null, null);
        this.restartClientVMNums(new int[]{1}, 0, null, null);
        conn = TestUtil.getConnection();
        stmt = conn.createStatement();
        pstmt = conn.prepareStatement("insert into trade.customers (tid) values (?)");
        for (v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(1, v * stepValue);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, 0, 3, this, true);
        stmt.execute("drop table trade.customers");
        stmt.execute("create table trade.customers (tid int, cid bigint not null, addr varchar(100), primary key (cid), constraint cust_ck check (cid >= 0)) persistent");
        stepValue = 2;
        pstmt = conn.prepareStatement("insert into trade.customers (cid, tid) values (?, ?)");
        for (v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(2, v);
            pstmt.setInt(1, v * stepValue);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("alter table trade.customers alter cid SET GENERATED ALWAYS AS IDENTITY");
        AlterTableDUnit.assertNull((Object)stmt.getWarnings());
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, 0, 3, this, true);
        this.stopVMNums(1, -1, -2, -3);
        this.restartServerVMNums(new int[]{1, 2, 3}, 0, null, null);
        this.restartClientVMNums(new int[]{1}, 0, null, null);
        conn = TestUtil.getConnection();
        stmt = conn.createStatement();
        pstmt = conn.prepareStatement("insert into trade.customers (tid) values (?)");
        for (v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(1, v * stepValue);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, 0, 3, this, true);
        stmt.execute("drop table trade.customers");
    }

    public void testAlterRestrictCKUndo() throws Exception {
        this.startVMs(1, 3);
        this.serverSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null,price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id),constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))partition by range (sec_id) ( VALUES BETWEEN 0 AND 409, VALUES BETWEEN 409 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1477, VALUES BETWEEN 1477 AND 1700, VALUES BETWEEN 1700 AND 10000)");
        try {
            this.serverSQLExecute(2, "alter table trade.securities drop column symbol restrict");
            AlterTableDUnit.fail((String)"alter table drop column restrict should have failed w/sqlstate X0Y25");
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                SQLException sqlEx = (SQLException)ex.getCause();
                if (!"X0Y25".equals(sqlEx.getSQLState())) {
                    throw ex;
                }
            }
            throw ex;
        }
        this.serverSQLExecute(3, "alter table trade.securities drop unique SEC_UQ");
        this.serverSQLExecute(2, "alter table trade.securities drop column symbol restrict");
        this.serverSQLExecute(1, "alter table trade.securities add column symbol varchar(10)");
        this.serverSQLExecute(3, "alter table trade.securities add constraint sec_uq unique (symbol,exchange)");
        this.serverSQLExecute(1, "update trade.securities set price = 5.0 where sec_id = 5 and tid=5");
    }

    public void testAlterTableMetaDataChangeReplay_44280() throws Exception {
        int i;
        this.startVMs(1, 1);
        this.serverSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int) REPLICATE EVICTION BY LRUCOUNT 20 EVICTACTION OVERFLOW");
        this.serverSQLExecute(1, "create table trade.customers2 (cid int not null, cust_name varchar(100), addr varchar(100), tid int) REPLICATE EVICTION BY LRUCOUNT 20 EVICTACTION OVERFLOW PERSISTENT");
        this.serverSQLExecute(1, "create table trade.customers3 (cid int not null, cust_name varchar(100), addr varchar(100), tid int) REDUNDANCY 1 EVICTION BY LRUCOUNT 20 EVICTACTION OVERFLOW PERSISTENT");
        this.serverSQLExecute(1, "create table trade.customers4 (cid int not null, cust_name varchar(100), addr varchar(100), tid int) REPLICATE PERSISTENT");
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        this.clientSQLExecute(1, "alter table trade.customers add constraint cust_pk primary key (cid)");
        this.serverSQLExecute(1, "alter table trade.customers2 add constraint cust_pk2 primary key (cid)");
        this.clientSQLExecute(1, "alter table trade.customers3 add constraint cust_pk3 primary key (cid)");
        this.serverSQLExecute(1, "alter table trade.customers4 add constraint cust_pk4 primary key (cid)");
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.customers values (?, ?, ?, ?)");
        PreparedStatement pstmt2 = conn.prepareStatement("insert into trade.customers2 values (?, ?, ?, ?)");
        PreparedStatement pstmt3 = conn.prepareStatement("insert into trade.customers3 values (?, ?, ?, ?)");
        PreparedStatement pstmt4 = conn.prepareStatement("insert into trade.customers4 values (?, ?, ?, ?)");
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(1, 0, null, null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(2, 0, null, null);
        for (i = 1; i <= 5000; ++i) {
            pstmt.setInt(1, i);
            pstmt.setString(2, "name" + i);
            pstmt.setString(3, "addr" + i);
            pstmt.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt.executeUpdate());
            pstmt2.setInt(1, i);
            pstmt2.setString(2, "name" + i);
            pstmt2.setString(3, "addr" + i);
            pstmt2.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt2.executeUpdate());
            pstmt3.setInt(1, i);
            pstmt3.setString(2, "name" + i);
            pstmt3.setString(3, "addr" + i);
            pstmt3.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt3.executeUpdate());
            pstmt4.setInt(1, i);
            pstmt4.setString(2, "name" + i);
            pstmt4.setString(3, "addr" + i);
            pstmt4.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt4.executeUpdate());
        }
        this.joinVMCheckXBM09(async2);
        this.joinVMCheckXBM09(async3);
        stmt.execute("call sys.rebalance_all_buckets()");
        this.stopVMNum(-2);
        for (i = 1; i <= 500; ++i) {
            block40: {
                block39: {
                    block38: {
                        pstmt.setInt(1, i);
                        pstmt.setString(2, "name" + i);
                        pstmt.setString(3, "addr" + i);
                        pstmt.setInt(4, i + 10);
                        try {
                            pstmt.execute();
                            AlterTableDUnit.fail((String)"expected a PK constraint violation");
                        }
                        catch (SQLException sqle) {
                            if ("23505".equals(sqle.getSQLState())) break block38;
                            throw sqle;
                        }
                    }
                    pstmt2.setInt(1, i);
                    pstmt2.setString(2, "name" + i);
                    pstmt2.setString(3, "addr" + i);
                    pstmt2.setInt(4, i + 10);
                    try {
                        pstmt2.execute();
                        AlterTableDUnit.fail((String)"expected a PK constraint violation");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block39;
                        throw sqle;
                    }
                }
                pstmt3.setInt(1, i);
                pstmt3.setString(2, "name" + i);
                pstmt3.setString(3, "addr" + i);
                pstmt3.setInt(4, i + 10);
                try {
                    pstmt3.execute();
                    AlterTableDUnit.fail((String)"expected a PK constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block40;
                    throw sqle;
                }
            }
            pstmt4.setInt(1, i);
            pstmt4.setString(2, "name" + i);
            pstmt4.setString(3, "addr" + i);
            pstmt4.setInt(4, i + 10);
            try {
                pstmt4.execute();
                AlterTableDUnit.fail((String)"expected a PK constraint violation");
                continue;
            }
            catch (SQLException sqle) {
                if ("23505".equals(sqle.getSQLState())) continue;
                throw sqle;
            }
        }
        for (i = 4500; i <= 5000; ++i) {
            block43: {
                block42: {
                    block41: {
                        pstmt.setInt(1, i);
                        pstmt.setString(2, "name" + i);
                        pstmt.setString(3, "addr" + i);
                        pstmt.setInt(4, i + 10);
                        try {
                            pstmt.execute();
                            AlterTableDUnit.fail((String)"expected a PK constraint violation");
                        }
                        catch (SQLException sqle) {
                            if ("23505".equals(sqle.getSQLState())) break block41;
                            throw sqle;
                        }
                    }
                    pstmt2.setInt(1, i);
                    pstmt2.setString(2, "name" + i);
                    pstmt2.setString(3, "addr" + i);
                    pstmt2.setInt(4, i + 10);
                    try {
                        pstmt2.execute();
                        AlterTableDUnit.fail((String)"expected a PK constraint violation");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block42;
                        throw sqle;
                    }
                }
                pstmt3.setInt(1, i);
                pstmt3.setString(2, "name" + i);
                pstmt3.setString(3, "addr" + i);
                pstmt3.setInt(4, i + 10);
                try {
                    pstmt3.execute();
                    AlterTableDUnit.fail((String)"expected a PK constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block43;
                    throw sqle;
                }
            }
            pstmt4.setInt(1, i);
            pstmt4.setString(2, "name" + i);
            pstmt4.setString(3, "addr" + i);
            pstmt4.setInt(4, i + 10);
            try {
                pstmt4.execute();
                AlterTableDUnit.fail((String)"expected a PK constraint violation");
                continue;
            }
            catch (SQLException sqle) {
                if ("23505".equals(sqle.getSQLState())) continue;
                throw sqle;
            }
        }
        this.startServerVMs(1, 0, null, null);
        for (i = 11000; i <= 12000; ++i) {
            pstmt.setInt(1, i);
            pstmt.setString(2, "name" + i);
            pstmt.setString(3, "addr" + i);
            pstmt.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt.executeUpdate());
            pstmt2.setInt(1, i);
            pstmt2.setString(2, "name" + i);
            pstmt2.setString(3, "addr" + i);
            pstmt2.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt2.executeUpdate());
            pstmt3.setInt(1, i);
            pstmt3.setString(2, "name" + i);
            pstmt3.setString(3, "addr" + i);
            pstmt3.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt3.executeUpdate());
            pstmt4.setInt(1, i);
            pstmt4.setString(2, "name" + i);
            pstmt4.setString(3, "addr" + i);
            pstmt4.setInt(4, i + 10);
            AlterTableDUnit.assertEquals((int)1, (int)pstmt4.executeUpdate());
        }
        for (i = 3000; i <= 3100; ++i) {
            block46: {
                block45: {
                    block44: {
                        pstmt.setInt(1, i);
                        pstmt.setString(2, "name" + i);
                        pstmt.setString(3, "addr" + i);
                        pstmt.setInt(4, i + 10);
                        try {
                            pstmt.execute();
                            AlterTableDUnit.fail((String)"expected a PK constraint violation");
                        }
                        catch (SQLException sqle) {
                            if ("23505".equals(sqle.getSQLState())) break block44;
                            throw sqle;
                        }
                    }
                    pstmt2.setInt(1, i);
                    pstmt2.setString(2, "name" + i);
                    pstmt2.setString(3, "addr" + i);
                    pstmt2.setInt(4, i + 10);
                    try {
                        pstmt2.execute();
                        AlterTableDUnit.fail((String)"expected a PK constraint violation");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block45;
                        throw sqle;
                    }
                }
                pstmt3.setInt(1, i);
                pstmt3.setString(2, "name" + i);
                pstmt3.setString(3, "addr" + i);
                pstmt3.setInt(4, i + 10);
                try {
                    pstmt3.execute();
                    AlterTableDUnit.fail((String)"expected a PK constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block46;
                    throw sqle;
                }
            }
            pstmt4.setInt(1, i);
            pstmt4.setString(2, "name" + i);
            pstmt4.setString(3, "addr" + i);
            pstmt4.setInt(4, i + 10);
            try {
                pstmt4.execute();
                AlterTableDUnit.fail((String)"expected a PK constraint violation");
                continue;
            }
            catch (SQLException sqle) {
                if ("23505".equals(sqle.getSQLState())) continue;
                throw sqle;
            }
        }
        for (i = 11500; i <= 11600; ++i) {
            block49: {
                block48: {
                    block47: {
                        pstmt.setInt(1, i);
                        pstmt.setString(2, "name" + i);
                        pstmt.setString(3, "addr" + i);
                        pstmt.setInt(4, i + 10);
                        try {
                            pstmt.execute();
                            AlterTableDUnit.fail((String)"expected a PK constraint violation");
                        }
                        catch (SQLException sqle) {
                            if ("23505".equals(sqle.getSQLState())) break block47;
                            throw sqle;
                        }
                    }
                    pstmt2.setInt(1, i);
                    pstmt2.setString(2, "name" + i);
                    pstmt2.setString(3, "addr" + i);
                    pstmt2.setInt(4, i + 10);
                    try {
                        pstmt2.execute();
                        AlterTableDUnit.fail((String)"expected a PK constraint violation");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block48;
                        throw sqle;
                    }
                }
                pstmt3.setInt(1, i);
                pstmt3.setString(2, "name" + i);
                pstmt3.setString(3, "addr" + i);
                pstmt3.setInt(4, i + 10);
                try {
                    pstmt3.execute();
                    AlterTableDUnit.fail((String)"expected a PK constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block49;
                    throw sqle;
                }
            }
            pstmt4.setInt(1, i);
            pstmt4.setString(2, "name" + i);
            pstmt4.setString(3, "addr" + i);
            pstmt4.setInt(4, i + 10);
            try {
                pstmt4.execute();
                AlterTableDUnit.fail((String)"expected a PK constraint violation");
                continue;
            }
            catch (SQLException sqle) {
                if ("23505".equals(sqle.getSQLState())) continue;
                throw sqle;
            }
        }
    }

    private void joinVMCheckXBM09(DistributedSQLTestBase.AsyncVM async) throws Exception {
        try {
            this.joinVM(true, async);
        }
        catch (RMIException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException && "XBM09".equals(((SQLException)cause).getSQLState())) {
                this.startServerVMs(1, 0, null);
            }
            throw ex;
        }
    }

    public void testAlterTableDependentTables_46573() throws Exception {
        Statement stmt;
        Properties props;
        int locPort;
        block7: {
            block6: {
                locPort = AvailablePort.getRandomAvailablePort((int)0);
                props = new Properties();
                props.setProperty("start-locator", "localhost[" + locPort + ']');
                this.startVMs(0, 1, 0, null, props);
                props.clear();
                props.setProperty("locators", "localhost[" + locPort + ']');
                this.startVMs(1, 1, 0, null, props);
                this.serverSQLExecute(1, "CREATE TABLE TPCEGFXD.ADDRESS(AD_ID DECIMAL(11,0) NOT NULL,AD_LINE1 VARCHAR(80),AD_LINE2 VARCHAR(80),AD_ZC_CODE CHAR(12) NOT NULL,AD_CTRY VARCHAR(80),PRIMARY KEY (AD_ID)) PERSISTENT");
                this.serverSQLExecute(2, "CREATE TABLE ADDRESS2(AD_ID DECIMAL(11,0) NOT NULL,AD_LINE1 VARCHAR(80),AD_LINE2 VARCHAR(80),AD_ZC_CODE CHAR(12) NOT NULL,AD_CTRY VARCHAR(80),PRIMARY KEY (AD_ID)) PARTITION BY COLUMN (AD_ZC_CODE) PERSISTENT");
                this.serverSQLExecute(1, "CREATE TABLE ADDRESS3(AD_ID DECIMAL(11,0) NOT NULL,AD_LINE1 VARCHAR(80),AD_LINE2 VARCHAR(80),AD_ZC_CODE CHAR(12) NOT NULL,AD_CTRY VARCHAR(80),PRIMARY KEY (AD_ID)) PARTITION BY COLUMN (AD_ZC_CODE) PERSISTENT");
                this.serverSQLExecute(2, "CREATE INDEX ADDRESS_I_FK_ADDRESS_ZC ON TPCEGFXD.ADDRESS (AD_ZC_CODE)");
                this.serverSQLExecute(1, "CREATE INDEX ADDRESS2_I_FK_ADDRESS_ZC ON ADDRESS2 (AD_ZC_CODE)");
                this.serverSQLExecute(1, "CREATE INDEX ADDRESS3_I_FK_ADDRESS_ZC ON ADDRESS3 (AD_ZC_CODE)");
                Connection conn = TestUtil.jdbcConn;
                stmt = conn.createStatement();
                PreparedStatement pstmt = conn.prepareStatement("insert into TPCEGFXD.ADDRESS values (?, ?, ?, ?, ?)");
                PreparedStatement pstmt2 = conn.prepareStatement("insert into ADDRESS2 values (?, ?, ?, ?, ?)");
                PreparedStatement pstmt3 = conn.prepareStatement("insert into ADDRESS3 values (?, ?, ?, ?, ?)");
                for (int i = 1; i <= 100; ++i) {
                    pstmt.setString(1, Integer.toString(i * 6));
                    pstmt.setString(2, "ADDR1_" + i);
                    pstmt.setString(3, "ADDR2_" + i);
                    pstmt.setString(4, "ZP" + i / 2);
                    pstmt.setString(5, "CT" + i);
                    pstmt.execute();
                    pstmt2.setString(1, Integer.toString(i * 6));
                    pstmt2.setString(2, "ADDR1_" + i);
                    pstmt2.setString(3, "ADDR2_" + i);
                    pstmt2.setString(4, "ZP" + i / 2);
                    pstmt2.setString(5, "CT" + i);
                    pstmt2.execute();
                    pstmt3.setString(1, Integer.toString(i * 6));
                    pstmt3.setString(2, "ADDR1_" + i);
                    pstmt3.setString(3, "ADDR2_" + i);
                    pstmt3.setString(4, "ZP" + i / 2);
                    pstmt3.setString(5, "CT" + i);
                    pstmt3.execute();
                }
                this.serverSQLExecute(2, "CREATE TABLE TPCEGFXD.ZIP_CODE(ZC_CODE CHAR(12) NOT NULL,ZC_TOWN VARCHAR(80) NOT NULL,ZC_DIV VARCHAR(80) NOT NULL,PRIMARY KEY (ZC_CODE)) PERSISTENT");
                this.serverSQLExecute(1, "CREATE TABLE ZIP_CODE2(ZC_CODE CHAR(12) NOT NULL,ZC_TOWN VARCHAR(80) NOT NULL,ZC_DIV VARCHAR(80) NOT NULL,PRIMARY KEY (ZC_CODE)) PARTITION BY PRIMARY KEY PERSISTENT");
                this.serverSQLExecute(1, "CREATE TABLE ZIP_CODE3(ZC_CODE CHAR(12) NOT NULL,ZC_TOWN VARCHAR(80) NOT NULL,ZC_DIV VARCHAR(80) NOT NULL,PRIMARY KEY (ZC_CODE)) PARTITION BY PRIMARY KEY COLOCATE WITH (ADDRESS3) PERSISTENT");
                PreparedStatement pstmt4 = conn.prepareStatement("insert into TPCEGFXD.ZIP_CODE values (?, ?, ?)");
                PreparedStatement pstmt5 = conn.prepareStatement("insert into ZIP_CODE2 values (?, ?, ?)");
                PreparedStatement pstmt6 = conn.prepareStatement("insert into ZIP_CODE3 values (?, ?, ?)");
                for (int i = 1; i <= 50; ++i) {
                    pstmt4.setString(1, "ZP" + i);
                    pstmt4.setString(2, "TW" + i);
                    pstmt4.setString(3, "DV" + i);
                    pstmt4.execute();
                    pstmt5.setString(1, "ZP" + i);
                    pstmt5.setString(2, "TW" + i);
                    pstmt5.setString(3, "DV" + i);
                    pstmt5.execute();
                    pstmt6.setString(1, "ZP" + i);
                    pstmt6.setString(2, "TW" + i);
                    pstmt6.setString(3, "DV" + i);
                    pstmt6.execute();
                }
                String alterTable = "ALTER TABLE TPCEGFXD.ADDRESS ADD CONSTRAINT FK_ADDRESS_ZC FOREIGN KEY (AD_ZC_CODE) REFERENCES TPCEGFXD.ZIP_CODE (ZC_CODE) ON DELETE RESTRICT";
                String alterTable2 = "ALTER TABLE ADDRESS2 ADD CONSTRAINT FK_ADDRESS2_ZC FOREIGN KEY (AD_ZC_CODE) REFERENCES ZIP_CODE2 (ZC_CODE) ON DELETE RESTRICT";
                String alterTable3 = "ALTER TABLE ADDRESS3 DROP COLUMN AD_CTRY CASCADE";
                String alterTable4 = "ALTER TABLE ADDRESS3 ADD COLUMN AD_CTRY INT";
                try {
                    stmt.execute("ALTER TABLE TPCEGFXD.ADDRESS ADD CONSTRAINT FK_ADDRESS_ZC FOREIGN KEY (AD_ZC_CODE) REFERENCES TPCEGFXD.ZIP_CODE (ZC_CODE) ON DELETE RESTRICT");
                    AlterTableDUnit.fail((String)"expected constraint violation");
                }
                catch (SQLException sqle) {
                    if ("X0Y45".equals(sqle.getSQLState())) break block6;
                    throw sqle;
                }
            }
            try {
                stmt.execute("ALTER TABLE ADDRESS2 ADD CONSTRAINT FK_ADDRESS2_ZC FOREIGN KEY (AD_ZC_CODE) REFERENCES ZIP_CODE2 (ZC_CODE) ON DELETE RESTRICT");
                AlterTableDUnit.fail((String)"expected constraint violation");
            }
            catch (SQLException sqle) {
                if ("X0Y45".equals(sqle.getSQLState())) break block7;
                throw sqle;
            }
        }
        stmt.execute("delete from TPCEGFXD.ADDRESS where AD_ZC_CODE='ZP0'");
        stmt.execute("delete from ADDRESS2 where AD_ZC_CODE='ZP0'");
        stmt.execute("ALTER TABLE TPCEGFXD.ADDRESS ADD CONSTRAINT FK_ADDRESS_ZC FOREIGN KEY (AD_ZC_CODE) REFERENCES TPCEGFXD.ZIP_CODE (ZC_CODE) ON DELETE RESTRICT");
        stmt.execute("ALTER TABLE ADDRESS2 ADD CONSTRAINT FK_ADDRESS2_ZC FOREIGN KEY (AD_ZC_CODE) REFERENCES ZIP_CODE2 (ZC_CODE) ON DELETE RESTRICT");
        stmt.execute("ALTER TABLE ADDRESS3 DROP COLUMN AD_CTRY CASCADE");
        stmt.execute("ALTER TABLE ADDRESS3 ADD COLUMN AD_CTRY INT");
        this.startVMs(0, 1, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from TPCEGFXD.ADDRESS", null, "99");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from TPCEGFXD.ZIP_CODE", null, "50");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ADDRESS2", null, "99");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ADDRESS3", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(AD_CTRY) from ADDRESS3", null, "0");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ZIP_CODE2", null, "50");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ZIP_CODE3", null, "50");
        this.stopVMNums(-1, -2, -3, 1);
        props.clear();
        props.setProperty("start-locator", "localhost[" + locPort + ']');
        DistributedSQLTestBase.AsyncVM async1 = this.restartServerVMAsync(1, 0, null, props);
        Thread.sleep(3000L);
        props.clear();
        props.setProperty("locators", "localhost[" + locPort + ']');
        DistributedSQLTestBase.AsyncVM async2 = this.restartServerVMAsync(2, 0, null, props);
        DistributedSQLTestBase.AsyncVM async3 = this.restartServerVMAsync(3, 0, null, props);
        this.joinVMs(false, async1, async2, async3);
        this.restartVMNums(new int[]{1}, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from TPCEGFXD.ADDRESS", null, "99");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from TPCEGFXD.ZIP_CODE", null, "50");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ADDRESS2", null, "99");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ADDRESS3", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(AD_CTRY) from ADDRESS3", null, "0");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct AD_CTRY from ADDRESS3", null, "null");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ZIP_CODE2", null, "50");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ZIP_CODE3", null, "50");
        stmt = TestUtil.getStatement();
        AlterTableDUnit.assertEquals((int)50, (int)stmt.executeUpdate("UPDATE ADDRESS3 SET AD_CTRY=20 WHERE AD_ID > 300"));
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(*) from ADDRESS3", null, "100");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select count(AD_CTRY) from ADDRESS3", null, "50");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct AD_CTRY from ADDRESS3 WHERE AD_ID > 300", null, "20");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select distinct AD_CTRY from ADDRESS3 WHERE AD_ID <= 300", null, "null");
    }

    public void testAlterExpireEntryTimeToLive() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, " CREATE TABLE testtable (id int, firstName varchar(20), lastName varchar(20), primary key (id)) PARTITION BY PRIMARY KEY EXPIRE ENTRY WITH TIMETOLIVE 60 ACTION DESTROY");
        this.clientSQLExecute(1, "ALTER TABLE testtable set EXPIRE ENTRY WITH TIMETOLIVE 300 ACTION DESTROY");
        this.stopVMNums(-1);
        this.restartVMNums(-1);
    }

    public void testAlterExpireEntryTimeToLive_2() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, " CREATE TABLE testtable (id int, firstName varchar(20), lastName varchar(20), primary key (id)) PARTITION BY PRIMARY KEY EXPIRE ENTRY WITH TIMETOLIVE 60 ACTION DESTROY");
        this.clientSQLExecute(1, "ALTER TABLE testtable set EXPIRE ENTRY WITH TIMETOLIVE 300 ACTION DESTROY");
        this.stopVMNums(-1, -2);
        this.restartVMNums(-1, -2);
    }

    public void testAlterEvictionMaxSize() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, " CREATE TABLE testtable (id int, firstName varchar(20), lastName varchar(20), primary key (id)) PARTITION BY PRIMARY KEY EVICTION BY LRUMEMSIZE 5 EVICTACTION OVERFLOW");
        this.clientSQLExecute(1, "ALTER TABLE testtable set EVICTION MAXSIZE 10");
        this.stopVMNums(-1);
        this.restartVMNums(-1);
    }

    public void testAddGeneratedIdentityColumn_49851() throws Exception {
        this.startServerVMs(3, 0, null, null);
        this.startClientVMs(1, 0, null, null);
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (tid int, cid int not null, primary key (cid), constraint cust_ck check (cid >= 0))");
        int maxValue = 1000000;
        int stepValue = 3;
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.customers values (?, ?)");
        for (int v = 1; v <= 1000000; v += stepValue) {
            pstmt.setInt(1, v * stepValue);
            pstmt.setInt(2, v);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("alter table trade.customers alter column cid SET GENERATED ALWAYS AS IDENTITY");
        SQLWarning sw = stmt.getWarnings();
        AlterTableDUnit.assertNull((Object)sw);
        int numRows = 2000;
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, -1000000, 3, this, true);
        stmt.execute("drop table trade.customers");
    }

    public void testBug50116() throws Exception {
        this.startVMs(1, 1);
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.portfolio (oid int not null, cid int, sid int, tid int, constraint portfolio_pk primary key (cid, sid)) replicate");
        st.execute("create table trade.sellorders (oid int not null constraint sellorders_pk primary key, cid int, sid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, tid int)  replicate");
        st.execute("insert into trade.portfolio values (30283943, 1928331, 1928331, 0)");
        st.execute("insert into trade.portfolio values (11905633, 5617222, 5617222, 0)");
        st.execute("insert into trade.portfolio values (49839007, 8315666, 8315666, 0)");
        st.execute("insert into trade.portfolio values (52380433, 1261892, 1261892, 0)");
        st.execute("insert into trade.portfolio values (47088533, 7536715, 6536715, 0)");
        st.execute("insert into trade.portfolio values (77004261, 6937081, 6937081, 0)");
        st.execute("insert into trade.portfolio values (79722922, 9489519, 9489519, 0)");
        st.execute("insert into trade.portfolio values (14562576, 6404345, 6404345, 0)");
        st.execute("insert into trade.portfolio values (46568823, 2482798, 2482798, 0)");
        st.execute("insert into trade.portfolio values (29198498, 4508782, 4508782, 0)");
        st.execute("insert into trade.sellorders values (30283943, 1928331, 1928331, 0)");
        st.execute("insert into trade.sellorders values (11905633, 5617222, 5617222, 0)");
        st.execute("insert into trade.sellorders values (49839007, 8315666, 8315666, 0)");
        st.execute("insert into trade.sellorders values (52380433, 1261892, 1261892, 0)");
        st.execute("insert into trade.sellorders values (47088533, 7536715, 6536715, 0)");
        st.execute("insert into trade.sellorders values (77004261, 6937081, 6937081, 0)");
        st.execute("insert into trade.sellorders values (79722922, 9489519, 9489519, 0)");
        st.execute("insert into trade.sellorders values (14562576, 6404345, 6404345, 0)");
        st.execute("insert into trade.sellorders values (46568823, 2482798, 2482798, 0)");
        st.execute("insert into trade.sellorders values (29198498, 4508782, 4508782, 0)");
        props = new Properties();
        conn = TestUtil.getConnection(props);
        String query = " select tid  from trade.portfolio";
        PreparedStatement st2 = conn.prepareStatement(query);
        ResultSet r = st2.executeQuery();
        int count = 0;
        while (r.next()) {
            AlterTableDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        AlterTableDUnit.assertEquals((int)10, (int)count);
        r.close();
        props = new Properties();
        conn = TestUtil.getConnection(props);
        query = " select tid  from trade.sellorders";
        st2 = conn.prepareStatement(query);
        r = st2.executeQuery();
        count = 0;
        while (r.next()) {
            AlterTableDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        AlterTableDUnit.assertEquals((int)10, (int)count);
        r.close();
        props = new Properties();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("alter table trade.sellorders drop FOREIGN KEY portf_fk");
        this.startVMs(0, 1);
        props = new Properties();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("drop table if exists trade.portfolio");
        try {
            props = new Properties();
            conn = TestUtil.getConnection(props);
            query = " select tid  from trade.portfolio";
            st2 = conn.prepareStatement(query);
            r = st2.executeQuery();
            count = 0;
            while (r.next()) {
                AlterTableDUnit.assertEquals((int)0, (int)r.getInt(1));
                ++count;
            }
            AlterTableDUnit.assertEquals((int)10, (int)count);
            r.close();
            AlterTableDUnit.fail((String)"Test should fail with Syntax Error exception");
        }
        catch (SQLException sqle) {
            AlterTableDUnit.assertEquals((String)"42X05", (String)sqle.getSQLState());
        }
        this.startVMs(0, 1);
        props = new Properties();
        conn = TestUtil.getConnection(props);
        query = " select tid  from trade.sellorders";
        st2 = conn.prepareStatement(query);
        r = st2.executeQuery();
        count = 0;
        while (r.next()) {
            AlterTableDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        AlterTableDUnit.assertEquals((int)10, (int)count);
        r.close();
    }
}

