/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.DDLHoplogOrganizer;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.io.IOException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import junit.framework.TestCase;

public class AlterHDFSStoreDUnit
extends DistributedSQLTestBase {
    public AlterHDFSStoreDUnit(String name) {
        super(name);
    }

    public void testDistributionOfHDFSStoreAlter() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create hdfsstore TEST namenode 'localhost' homedir '" + homeDir + "'");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select NAME, MAXWRITEONLYFILESIZE, WRITEONLYFILEROLLOVERINTERVALSECS,  MAXINPUTFILECOUNT ,  MAXINPUTFILESIZE, MININPUTFILECOUNT, MINORCOMPACT, MAJORCOMPACTIONINTERVALMINS , MAJORCOMPACT, PURGEINTERVALMINS ,BATCHSIZE, BATCHTIMEINTERVALMILLIS, MINORCOMPACTIONTHREADS,  MAJORCOMPACTIONTHREADS from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-original");
        this.clientSQLExecute(1, "alter hdfsstore TEST SET MaxWriteOnlyFileSize 47 SET WriteOnlyFileRolloverInterval 347 minutes SET MaxInputFileCount 98 SET MaxInputFileSize 38 SET MinorCompactionThreads 35 SET MinInputFileCount 24 SET MinorCompact false SET MajorCompactionInterval 372 minutes SET MajorCompactionThreads 29 SET MajorCompact false SET PurgeInterval 2392 minutes SET BatchSize 23 SET batchtimeinterval 2 seconds ");
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        SerializableRunnable verifier = this.verifyHDFSStoreExistence("TEST");
        for (int i = 1; i < 3; ++i) {
            this.serverExecute(i, (Runnable)verifier);
        }
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select NAME, MAXWRITEONLYFILESIZE, WRITEONLYFILEROLLOVERINTERVALSECS,  MAXINPUTFILECOUNT ,  MAXINPUTFILESIZE, MININPUTFILECOUNT, MINORCOMPACT, MAJORCOMPACTIONINTERVALMINS , MAJORCOMPACT, PURGEINTERVALMINS ,BATCHSIZE, BATCHTIMEINTERVALMILLIS, MINORCOMPACTIONTHREADS,  MAJORCOMPACTIONTHREADS from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-altered");
        this.startVMs(0, 1);
        this.sqlExecuteVerify(null, new int[]{3}, "select NAME, MAXWRITEONLYFILESIZE, WRITEONLYFILEROLLOVERINTERVALSECS,  MaxInputFileCount ,  MaxInputFileSize, MinInputFileCount, MINORCOMPACT, MAJORCOMPACTIONINTERVALMINS , MAJORCOMPACT, PURGEINTERVALMINS ,BatchSize, BATCHTIMEINTERVALMILLIS, MINORCOMPACTIONTHREADS,  MAJORCOMPACTIONTHREADS from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-altered");
        this.serverExecute(3, (Runnable)verifier);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select NAME, MAXWRITEONLYFILESIZE, WRITEONLYFILEROLLOVERINTERVALSECS,  MaxInputFileCount ,  MaxInputFileSize, MinInputFileCount, MINORCOMPACT, MAJORCOMPACTIONINTERVALMINS , MAJORCOMPACT, PURGEINTERVALMINS ,BatchSize, BATCHTIMEINTERVALMILLIS, MINORCOMPACTIONTHREADS, MAJORCOMPACTIONTHREADS from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-altered");
        this.clientSQLExecute(1, "drop hdfsstore TEST ");
        AlterHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testDDLPersistenceFromClientOnMultipleServers() throws Exception {
        this.startVMs(2, 3);
        File homeDirFile1 = new File(".", "myhdfsfromclient");
        String homeDir1 = homeDirFile1.getAbsolutePath();
        File homeDirFile2 = new File(".", "myhdfsfromclient1");
        String homeDir2 = homeDirFile2.getAbsolutePath();
        this.checkDirExistence(homeDir1);
        this.checkDirExistence(homeDir2);
        this.clientSQLExecute(1, "create hdfsstore test namenode 'localhost' homedir '" + homeDir1 + "'");
        this.clientSQLExecute(1, "create table mytab (col1 int primary key, col2 int) persistent hdfsstore (test)");
        this.clientSQLExecute(1, "create hdfsstore test1 namenode 'localhost' homedir '" + homeDir2 + "'");
        this.clientSQLExecute(1, "create table mytab1 (col1 int primary key, col2 int) persistent hdfsstore (test1)");
        this.clientSQLExecute(1, "alter hdfsstore TEST SET MaxWriteOnlyFileSize 47 SET WriteOnlyFileRolloverInterval 347 minutes SET MaxInputFileCount 98 SET MaxInputFileSize 38 SET MinorCompactionThreads 35 SET MinInputFileCount 24 SET MinorCompact false SET MajorCompactionInterval 372 minutes SET MajorCompactionThreads 29 SET MajorCompact false SET PurgeInterval 2392 minutes SET BatchSize 23 SET batchtimeinterval 2 seconds ");
        this.serverExecute(1, (Runnable)this.verifyDDLPersistenceForTest());
        this.serverExecute(2, (Runnable)this.verifyDDLPersistenceForTest());
        this.serverExecute(3, (Runnable)this.verifyDDLPersistenceForTest());
        this.serverExecute(1, (Runnable)this.verifyDDLPersistenceForTest1());
        this.serverExecute(2, (Runnable)this.verifyDDLPersistenceForTest1());
        this.serverExecute(3, (Runnable)this.verifyDDLPersistenceForTest1());
        this.clientSQLExecute(1, "drop table mytab1 ");
        this.clientSQLExecute(1, "drop table mytab ");
        this.clientSQLExecute(1, "drop hdfsstore test ");
        this.clientSQLExecute(1, "drop hdfsstore test1 ");
        this.sqlExecuteVerify(new int[]{1, 2}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        AlterHDFSStoreDUnit.delete(homeDirFile1);
        AlterHDFSStoreDUnit.delete(homeDirFile2);
    }

    public void testDDLPersistenceFromServer() throws Exception {
        this.startVMs(2, 3);
        File homeDirFile1 = new File(".", "myhdfsfromclient");
        String homeDir1 = homeDirFile1.getAbsolutePath();
        File homeDirFile2 = new File(".", "myhdfsfromclient1");
        String homeDir2 = homeDirFile2.getAbsolutePath();
        this.checkDirExistence(homeDir1);
        this.checkDirExistence(homeDir2);
        this.serverSQLExecute(1, "create hdfsstore test namenode 'localhost' homedir '" + homeDir1 + "'");
        this.serverSQLExecute(1, "create table mytab (col1 int primary key, col2 int) persistent hdfsstore (test)");
        this.serverSQLExecute(1, "create hdfsstore test1 namenode 'localhost' homedir '" + homeDir2 + "'");
        this.serverSQLExecute(1, "create table mytab1 (col1 int primary key, col2 int) persistent hdfsstore (test1)");
        this.serverSQLExecute(1, "alter hdfsstore TEST SET MaxWriteOnlyFileSize 47 SET WriteOnlyFileRolloverInterval 347 minutes SET MaxInputFileCount 98 SET MaxInputFileSize 38 SET MinorCompactionThreads 35 SET MinInputFileCount 24 SET MinorCompact false SET MajorCompactionInterval 372 minutes SET MajorCompactionThreads 29 SET MajorCompact false SET PurgeInterval 2392 minutes SET BatchSize 23 SET batchtimeinterval 2 seconds ");
        this.serverExecute(1, (Runnable)this.verifyDDLPersistenceForTest());
        this.serverExecute(2, (Runnable)this.verifyDDLPersistenceForTest());
        this.serverExecute(3, (Runnable)this.verifyDDLPersistenceForTest());
        this.serverExecute(1, (Runnable)this.verifyDDLPersistenceForTest1());
        this.serverExecute(2, (Runnable)this.verifyDDLPersistenceForTest1());
        this.serverExecute(3, (Runnable)this.verifyDDLPersistenceForTest1());
        this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select NAME, MAXWRITEONLYFILESIZE, WRITEONLYFILEROLLOVERINTERVALSECS,  MaxInputFileCount ,  MaxInputFileSize, MinInputFileCount, MINORCOMPACT, MAJORCOMPACTIONINTERVALMINS , MAJORCOMPACT, PURGEINTERVALMINS ,BatchSize, BATCHTIMEINTERVALMILLIS, MINORCOMPACTIONTHREADS, MAJORCOMPACTIONTHREADS from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-altered");
        this.serverSQLExecute(1, "drop table mytab1 ");
        this.serverSQLExecute(1, "drop table mytab ");
        this.serverSQLExecute(1, "drop hdfsstore test ");
        this.serverSQLExecute(1, "drop hdfsstore test1 ");
        this.sqlExecuteVerify(new int[]{1, 2}, null, "select NAME from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "empty");
        AlterHDFSStoreDUnit.delete(homeDirFile1);
        AlterHDFSStoreDUnit.delete(homeDirFile2);
    }

    public void testRestart() throws Exception {
        this.startVMs(1, 1);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create hdfsstore TEST namenode 'localhost'  homedir '" + homeDir + "'");
        this.clientSQLExecute(1, "alter hdfsstore TEST SET MaxWriteOnlyFileSize 47 SET WriteOnlyFileRolloverInterval 347 minutes SET MaxInputFileCount 98 SET MaxInputFileSize 38 SET MinorCompactionThreads 35 SET MinInputFileCount 24 SET MinorCompact false SET MajorCompactionInterval 372 minutes SET MajorCompactionThreads 29 SET MajorCompact false SET PurgeInterval 2392 minutes SET BatchSize 23 SET batchtimeinterval 2 seconds ");
        this.stopAllVMs();
        this.restartVMNums(-1);
        this.restartVMNums(1);
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        SerializableRunnable verifier = this.verifyHDFSStoreExistence("TEST");
        this.serverExecute(1, (Runnable)verifier);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, "select NAME, MAXWRITEONLYFILESIZE, WRITEONLYFILEROLLOVERINTERVALSECS,  MAXINPUTFILECOUNT ,  MAXINPUTFILESIZE, MININPUTFILECOUNT, MINORCOMPACT, MAJORCOMPACTIONINTERVALMINS , MAJORCOMPACT, PURGEINTERVALMINS ,BATCHSIZE, BATCHTIMEINTERVALMILLIS, MINORCOMPACTIONTHREADS,  MAJORCOMPACTIONTHREADS from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-altered");
        this.clientSQLExecute(1, "drop hdfsstore TEST ");
        AlterHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testRollback() throws Exception {
        this.startVMs(1, 3);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create hdfsstore TEST namenode 'localhost'  homedir '" + homeDir + "'");
        this.setupObservers((VM)this.serverVMs.get(2));
        boolean exception = false;
        this.addExpectedException(null, new int[]{3}, SQLNonTransientConnectionException.class);
        try {
            this.serverSQLExecute(1, "alter hdfsstore TEST SET MaxWriteOnlyFileSize 47 SET WriteOnlyFileRolloverInterval 347 minutes SET MaxInputFileCount 98 SET MaxInputFileSize 38 SET MinorCompactionThreads 35 SET MinInputFileCount 24 SET MinorCompact false SET MajorCompactionInterval 372 minutes SET MajorCompactionThreads 29 SET MajorCompact false SET PurgeInterval 2392 minutes SET BatchSize 23 SET batchtimeinterval 2 seconds ");
        }
        catch (Exception e) {
            exception = true;
        }
        this.removeExpectedException(null, new int[]{3}, SQLNonTransientConnectionException.class);
        AlterHDFSStoreDUnit.assertTrue((String)"Exception should have been thrown from the server sql execute ", (boolean)exception);
        this.clearObservers((VM)this.serverVMs.get(2));
        this.clientExecute(1, (Runnable)this.verifyNoHDFSStoreExistence("TEST"));
        SerializableRunnable verifier = this.verifyHDFSStoreExistence("TEST", true);
        this.serverExecute(1, (Runnable)verifier);
        this.serverExecute(2, (Runnable)verifier);
        this.serverExecute(3, (Runnable)verifier);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select NAME, MAXWRITEONLYFILESIZE, WRITEONLYFILEROLLOVERINTERVALSECS,  MAXINPUTFILECOUNT ,  MAXINPUTFILESIZE, MININPUTFILECOUNT, MINORCOMPACT, MAJORCOMPACTIONINTERVALMINS , MAJORCOMPACT, PURGEINTERVALMINS ,BATCHSIZE, BATCHTIMEINTERVALMILLIS, MINORCOMPACTIONTHREADS,  MAJORCOMPACTIONTHREADS from SYS.SYSHDFSSTORES WHERE NAME = 'TEST' ", TestUtil.getResourcesDir() + "/lib/checkHDFSStore.xml", "ddl-original");
        this.clientSQLExecute(1, "drop hdfsstore TEST ");
        AlterHDFSStoreDUnit.delete(homeDirFile);
    }

    public void testAlterForNonExistentHDFSStore() throws Exception {
        this.startVMs(1, 2);
        File homeDirFile = new File(".", "myhdfs");
        String homeDir = homeDirFile.getAbsolutePath();
        this.checkDirExistence(homeDir);
        this.clientSQLExecute(1, "create hdfsstore TEST namenode 'localhost' homedir '" + homeDir + "'");
        boolean exception = false;
        try {
            this.clientSQLExecute(1, "alter hdfsstore TEST1 SET MaxWriteOnlyFileSize 47 ");
        }
        catch (SQLSyntaxErrorException e) {
            exception = true;
        }
        AlterHDFSStoreDUnit.assertTrue((String)"alter command for a non existent HDFSStore should have failed", (boolean)exception);
        exception = false;
        try {
            this.serverSQLExecute(1, "alter hdfsstore TEST1 SET MaxWriteOnlyFileSize 47 ");
        }
        catch (Exception e) {
            exception = true;
        }
        AlterHDFSStoreDUnit.assertTrue((String)"alter command for a non existent HDFSStore should have failed", (boolean)exception);
        this.clientSQLExecute(1, "drop hdfsstore TEST ");
        AlterHDFSStoreDUnit.delete(homeDirFile);
    }

    private SerializableRunnable verifyDDLPersistenceForTest1() {
        return new SerializableRunnable(){

            public void run() {
                ArrayList ddlconflatables = null;
                try {
                    HDFSStoreImpl hdfsStore = Misc.getGemFireCache().findHDFSStore("TEST1");
                    ddlconflatables = AlterHDFSStoreDUnit.this.getDDLConflatables(hdfsStore);
                }
                catch (Exception e) {
                    Misc.getGemFireCache().getLoggerI18n().fine("EXCEPTION " + e);
                }
                TestCase.assertTrue((ddlconflatables.size() == 2 ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)((DDLConflatable)ddlconflatables.get(0)).getValueToConflate().startsWith("create hdfsstore"));
                TestCase.assertTrue((boolean)((DDLConflatable)ddlconflatables.get(1)).getValueToConflate().startsWith("create table"));
            }
        };
    }

    private SerializableRunnable verifyDDLPersistenceForTest() {
        return new SerializableRunnable(){

            public void run() {
                ArrayList ddlconflatables = null;
                try {
                    HDFSStoreImpl hdfsStore = Misc.getGemFireCache().findHDFSStore("TEST");
                    ddlconflatables = AlterHDFSStoreDUnit.this.getDDLConflatables(hdfsStore);
                }
                catch (Exception e) {
                    AlterHDFSStoreDUnit.this.getLogWriter().warn((Object)("EXCEPTION " + e));
                }
                TestCase.assertTrue((ddlconflatables.size() == 3 ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)((DDLConflatable)ddlconflatables.get(0)).getValueToConflate().startsWith("create hdfsstore"));
                TestCase.assertTrue((boolean)((DDLConflatable)ddlconflatables.get(1)).getValueToConflate().startsWith("create table"));
                TestCase.assertTrue((boolean)((DDLConflatable)ddlconflatables.get(2)).getValueToConflate().startsWith("alter hdfsstore"));
            }
        };
    }

    private ArrayList<DDLConflatable> getDDLConflatables(HDFSStoreImpl store) throws IOException, ClassNotFoundException {
        DDLHoplogOrganizer organizer = store.getDDLHoplogOrganizer();
        ArrayList ddls = organizer.getDDLStatementsForReplay().getDDLStatements();
        ArrayList<DDLConflatable> ddlconflatables = new ArrayList<DDLConflatable>();
        for (byte[] ddl : ddls) {
            ddlconflatables.add((DDLConflatable)BlobHelper.deserializeBlob((byte[])ddl));
        }
        return ddlconflatables;
    }

    private SerializableRunnable verifyHDFSStoreExistence(String name) {
        return this.verifyHDFSStoreExistence(name, false);
    }

    private SerializableRunnable verifyHDFSStoreExistence(final String name, final boolean original) {
        return new SerializableRunnable(){

            public void run() {
                HDFSStoreImpl hdfsstore = null;
                hdfsstore = Misc.getGemFireCache().findHDFSStore(name);
                TestCase.assertNotNull((Object)hdfsstore);
                if (!original) {
                    TestCase.assertEquals((int)hdfsstore.getMaxFileSize(), (int)47);
                    TestCase.assertEquals((int)hdfsstore.getFileRolloverInterval(), (int)20820);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMaxInputFileCount(), (int)98);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMaxInputFileSizeMB(), (int)38);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMaxThreads(), (int)35);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMinInputFileCount(), (int)24);
                    TestCase.assertEquals((boolean)hdfsstore.getHDFSCompactionConfig().getAutoCompaction(), (boolean)false);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMajorCompactionIntervalMins(), (int)372);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMajorCompactionMaxThreads(), (int)29);
                    TestCase.assertEquals((boolean)hdfsstore.getHDFSCompactionConfig().getAutoMajorCompaction(), (boolean)false);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getOldFilesCleanupIntervalMins(), (int)2392);
                    TestCase.assertEquals((int)hdfsstore.getHDFSEventQueueAttributes().getBatchSizeMB(), (int)23);
                    TestCase.assertEquals((int)hdfsstore.getHDFSEventQueueAttributes().getBatchTimeInterval(), (int)2000);
                } else {
                    TestCase.assertEquals((int)hdfsstore.getMaxFileSize(), (int)256);
                    TestCase.assertEquals((int)hdfsstore.getFileRolloverInterval(), (int)3600);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMaxInputFileCount(), (int)10);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMaxInputFileSizeMB(), (int)512);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMaxThreads(), (int)10);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMinInputFileCount(), (int)4);
                    TestCase.assertEquals((boolean)hdfsstore.getHDFSCompactionConfig().getAutoCompaction(), (boolean)true);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMajorCompactionIntervalMins(), (int)720);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getMajorCompactionMaxThreads(), (int)2);
                    TestCase.assertEquals((boolean)hdfsstore.getHDFSCompactionConfig().getAutoMajorCompaction(), (boolean)true);
                    TestCase.assertEquals((int)hdfsstore.getHDFSCompactionConfig().getOldFilesCleanupIntervalMins(), (int)30);
                    TestCase.assertEquals((int)hdfsstore.getHDFSEventQueueAttributes().getBatchSizeMB(), (int)32);
                    TestCase.assertEquals((int)hdfsstore.getHDFSEventQueueAttributes().getBatchTimeInterval(), (int)60000);
                }
            }
        };
    }

    protected void setupObservers(VM dataStore) {
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver on DataStore Node"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void afterQueryParsing(String query, StatementNode qt, LanguageConnectionContext lcc) {
                            throw new GemFireXDRuntimeException("");
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore.invoke((Runnable)setObserver);
    }

    protected void clearObservers(VM dataStore) {
        SerializableRunnable clearObserver = new SerializableRunnable("Clear GemFireXDObserver on DataStore Node"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.clearInstance();
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore.invoke((Runnable)clearObserver);
    }

    private SerializableRunnable verifyNoHDFSStoreExistence(final String name) {
        return new SerializableRunnable(){

            public void run() {
                TestCase.assertNull((Object)Misc.getGemFireCache().findHDFSStore(name));
            }
        };
    }

    private void checkDirExistence(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            AlterHDFSStoreDUnit.delete(dir);
        }
    }
}

