/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dbsync;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import com.pivotal.gemfirexd.tools.GfxdSystemAdmin;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derbyTesting.junit.JDBC;

public class SerialDBSynchronizerPart2DUnit
extends DBSynchronizerTestBase {
    public SerialDBSynchronizerPart2DUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testOracle_UseCase1_2() throws Throwable {
        final int isolationLevel = PartitionedRegion.rand.nextBoolean() ? 2 : 0;
        this.startVMs(1, 2, 0, "CHANNELDATAGRP", null);
        final int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE gemfire.SECL_BO_DATA2 (       BO_TXN_ID VARCHAR (36) NOT NULL primary key,       LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP )      PARTITION BY COLUMN (BO_TXN_ID)      REDUNDANCY 1        EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW      PERSISTENT ASYNCHRONOUS");
        stmt.execute("CREATE TABLE gemfire.SECL_BO_DATA_STATUS_HIST2 (       BO_TXN_ID VARCHAR (36) NOT NULL ,       CLIENT_ID VARCHAR (100) ,       CLIENT_NAME VARCHAR (100) ,       CLIENT_ACCOUNT VARCHAR (100) ,       COMPANY_ID VARCHAR (100) ,       CLIENT_REF_NO VARCHAR (100) ,       VALUE_DATE TIMESTAMP ,       AMOUNT DECIMAL (16,2) ,       CURRENCY VARCHAR (20) ,       ORIG_BANK_ID VARCHAR (100) ,       BACKOFFICE_CODE VARCHAR (100) NOT NULL ,       BENE_ACCNT_NO VARCHAR (100) ,       BENE_NAME VARCHAR (100) ,       BENE_ADDR VARCHAR (256) ,       BENE_BANK_ID VARCHAR (100) ,       BENE_BANK_NAME VARCHAR (100) ,       BENE_BANK_ADDR VARCHAR (256) ,       INSTR_CREATED_TIME TIMESTAMP ,       INSTR_CREATED_BY VARCHAR (100) ,       DATA_LIFE_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_DATE TIMESTAMP ,       MATCH_CATEG_ID INTEGER ,       MATCHING_TIME INTEGER WITH DEFAULT -1 ,       MANUAL_MATCH CHAR (1) WITH DEFAULT 'N' ,       MATCHING_REASON VARCHAR (128) ,       SCREENING_TIME INTEGER NOT NULL ,       IS_MANUAL CHAR (1) WITH DEFAULT 'N' ,       IS_RESENT CHAR (1) WITH DEFAULT 'N' ,       CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,       TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,       OFAC_MSG_ID VARCHAR (64) NOT NULL ,       HIT_STATUS SMALLINT ,       FILE_TYPE VARCHAR (36) WITH DEFAULT 'NA',       ACTUAL_VALUE_DATE TIMESTAMP ,       LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,       FOREIGN KEY (BO_TXN_ID) REFERENCES gemfire.SECL_BO_DATA2(BO_TXN_ID))      PARTITION BY COLUMN (BO_TXN_ID)      REDUNDANCY 1        EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW      PERSISTENT ASYNCHRONOUS");
        String oraUser = "gemfire";
        String oraPasswd = "lu5Pheko";
        String oraUrl = "jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE)))";
        final String encryptedPassword1 = new GfxdSystemAdmin().encryptForExternal("encrypt-password", Arrays.asList("-locators=" + SerialDBSynchronizerPart2DUnit.getDUnitLocatorString()), "gemfire", "lu5Pheko");
        final Throwable[] failure = new Throwable[1];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                DistributedTestBase.ExpectedException expectedEx = DistributedTestBase.addExpectedException((String)"java.sql.SQLRecoverableException");
                for (int tries = 1; tries <= 5; ++tries) {
                    try {
                        Connection conn = TestUtil.getConnection();
                        Statement stmt = conn.createStatement();
                        stmt.execute("create asynceventlistener SECL_BO_DATA_STATUS_HIST_SYNC(listenerclass 'com.jpmorgan.tss.securitas.strategic.logsynctable.db.gemfirexd.callbacks.SectDBSynchronizer' initparams    'oracle.jdbc.driver.OracleDriver,jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE))),gemfire," + encryptedPassword1 + "' ENABLEPERSISTENCE true MANUALSTART false " + "ALERTTHRESHOLD 2000) SERVER GROUPS(CHANNELDATAGRP)");
                        failure[0] = null;
                        break;
                    }
                    catch (Throwable t) {
                        failure[0] = t;
                        continue;
                    }
                }
                expectedEx.remove();
            }
        });
        t.start();
        Connection oraConn = this.createOraConnection("jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE)))", "gemfire", "lu5Pheko");
        Statement oraStmt = oraConn.createStatement();
        t.join();
        if (failure[0] != null) {
            throw failure[0];
        }
        try {
            oraStmt.execute("CREATE TABLE gemfire.SECL_BO_DATA2 (    BO_TXN_ID VARCHAR2(36) NOT NULL primary key,    LAST_UPDATE_TIME TIMESTAMP)");
            oraStmt.execute("CREATE TABLE gemfire.SECL_BO_DATA_STATUS_HIST2(    BO_TXN_ID VARCHAR2(36) NOT NULL,    CLIENT_ID VARCHAR2(100),    CLIENT_NAME VARCHAR2(100),    CLIENT_ACCOUNT VARCHAR2(100),    COMPANY_ID VARCHAR2(100),    CLIENT_REF_NO VARCHAR2(100),    VALUE_DATE TIMESTAMP,    AMOUNT NUMBER(16,2),    CURRENCY VARCHAR2(20),    ORIG_BANK_ID VARCHAR2(100),    BACKOFFICE_CODE VARCHAR2(100) NOT NULL,    BENE_ACCNT_NO VARCHAR2(100),    BENE_NAME VARCHAR2(100),    BENE_ADDR VARCHAR2(256),    BENE_BANK_ID VARCHAR2(100),    BENE_BANK_NAME VARCHAR2(100),    BENE_BANK_ADDR VARCHAR2(256),    INSTR_CREATED_TIME TIMESTAMP,    INSTR_CREATED_BY VARCHAR2(100),    DATA_LIFE_STATUS NUMBER(5) DEFAULT 0,    MATCH_STATUS NUMBER(5) DEFAULT 0,    MATCH_DATE TIMESTAMP,    MATCH_CATEG_ID INTEGER,    MATCHING_TIME INTEGER DEFAULT -1,    MANUAL_MATCH CHAR(1) DEFAULT 'N',    MATCHING_REASON VARCHAR2(128),    SCREENING_TIME INTEGER NOT NULL,    IS_MANUAL CHAR(1) DEFAULT 'N',    IS_RESENT CHAR(1) DEFAULT 'N',    CHANNEL_NAME VARCHAR2(100) DEFAULT 'UNKNOWN',    TXN_TYPE VARCHAR2(30) DEFAULT 'UNKNOWN',    OFAC_MSG_ID VARCHAR2(64) NOT NULL,    HIT_STATUS NUMBER(5),    FILE_TYPE VARCHAR2(36) DEFAULT 'NA',    ACTUAL_VALUE_DATE TIMESTAMP,    LAST_UPDATE_TIME TIMESTAMP,    FOREIGN KEY (BO_TXN_ID)       REFERENCES gemfire.SECL_BO_DATA2(BO_TXN_ID))");
            oraConn.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        oraConn.setAutoCommit(false);
        String lockKey = "DBSP_LOCK";
        boolean locked = false;
        try {
            int i;
            int numTries = 0;
            while (!locked) {
                oraStmt.execute("lock table gemfire.SECL_BO_DATA2 in exclusive mode");
                ResultSet rs = oraStmt.executeQuery("select count(*) from gemfire.SECL_BO_DATA2 where BO_TXN_ID='DBSP_LOCK'");
                rs.next();
                if (rs.getInt(1) == 0 || ++numTries > 100) {
                    oraStmt.execute("truncate table gemfire.SECL_BO_DATA_STATUS_HIST2");
                    oraStmt.execute("delete from gemfire.SECL_BO_DATA2");
                    oraStmt.execute("INSERT INTO gemfire.SECL_BO_DATA2 (BO_TXN_ID) values ('DBSP_LOCK')");
                    locked = true;
                } else {
                    Thread.sleep(5000L);
                }
                oraConn.commit();
            }
            stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA2 SET  asynceventlistener(SECL_BO_DATA_STATUS_HIST_SYNC)");
            stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST2 SET  asynceventlistener(SECL_BO_DATA_STATUS_HIST_SYNC)");
            conn.setTransactionIsolation(isolationLevel);
            PreparedStatement pstmt2 = conn.prepareStatement("INSERT INTO   gemfire.SECL_BO_DATA_STATUS_HIST2 (      BO_TXN_ID,   CLIENT_ID,    CLIENT_NAME,  CLIENT_ACCOUNT,       COMPANY_ID,  CLIENT_REF_NO,    VALUE_DATE, AMOUNT,         CURRENCY,       ORIG_BANK_ID,   BACKOFFICE_CODE,     BENE_ACCNT_NO,  BENE_NAME,    BENE_ADDR,   BENE_BANK_ID,   BENE_BANK_NAME, BENE_BANK_ADDR, INSTR_CREATED_TIME,     INSTR_CREATED_BY,  DATA_LIFE_STATUS,       MATCH_STATUS,   MATCH_DATE, MATCH_CATEG_ID, MATCHING_TIME,  MANUAL_MATCH,   MATCHING_REASON,   SCREENING_TIME, IS_MANUAL,    IS_RESENT,      CHANNEL_NAME,   TXN_TYPE,   OFAC_MSG_ID, HIT_STATUS,   ACTUAL_VALUE_DATE, LAST_UPDATE_TIME) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)");
            SerializableRunnable parentInserts = new SerializableRunnable(){

                public void run() {
                    try {
                        Connection conn = TestUtil.getNetConnection(netPort, null, null);
                        conn.setTransactionIsolation(isolationLevel);
                        PreparedStatement pstmt = conn.prepareStatement("INSERT INTO   gemfire.SECL_BO_DATA2 (      BO_TXN_ID, LAST_UPDATE_TIME) values(?,CURRENT_TIMESTAMP)");
                        for (int i = 1; i <= 200; ++i) {
                            pstmt.setObject(1, "09824f04-26ef-49b0-95b2-955d3742" + String.format("%04d", i));
                            TestCase.assertEquals((int)1, (int)pstmt.executeUpdate());
                            conn.commit();
                        }
                        conn.commit();
                    }
                    catch (Throwable t) {
                        SerialDBSynchronizerPart2DUnit.this.getLogWriter().error((Object)t);
                        throw new CacheException(t){};
                    }
                }
            };
            VM serverVM = this.getServerVM(2);
            AsyncInvocation async1 = serverVM.invokeAsync((Runnable)parentInserts);
            ArrayList<String> childInserts = new ArrayList<String>(100);
            for (int i2 = 1; i2 <= 200; ++i2) {
                String txId = "09824f04-26ef-49b0-95b2-955d3742" + String.format("%04d", i2);
                pstmt2.setObject(1, txId);
                pstmt2.setObject(2, "party name");
                pstmt2.setObject(3, null);
                pstmt2.setObject(4, "12345678");
                pstmt2.setObject(5, "1874563");
                pstmt2.setObject(6, "PB130482");
                pstmt2.setTimestamp(7, Timestamp.valueOf("2012-07-18 00:00:00.0"));
                pstmt2.setObject(8, "158.26");
                pstmt2.setObject(9, "CAD");
                pstmt2.setObject(10, "CHASGB2LXXX");
                pstmt2.setObject(11, "IPAY");
                pstmt2.setObject(12, null);
                pstmt2.setObject(13, null);
                pstmt2.setObject(14, null);
                pstmt2.setObject(15, null);
                pstmt2.setObject(16, null);
                pstmt2.setObject(17, null);
                pstmt2.setObject(18, Timestamp.valueOf("2013-03-13 14:20:04.05"));
                pstmt2.setObject(19, null);
                pstmt2.setObject(20, 1);
                pstmt2.setObject(21, 1);
                pstmt2.setObject(22, Timestamp.valueOf("2013-03-13 14:20:04.28"));
                pstmt2.setObject(23, 2);
                pstmt2.setObject(24, 0);
                pstmt2.setObject(25, "N");
                pstmt2.setObject(26, null);
                pstmt2.setObject(27, -1);
                pstmt2.setObject(28, "N");
                pstmt2.setObject(29, "N");
                pstmt2.setObject(30, "PYS");
                pstmt2.setObject(31, "UNKNOWN");
                pstmt2.setObject(32, "MITHUN0621                                                      ");
                pstmt2.setObject(33, null);
                pstmt2.setObject(34, Timestamp.valueOf("2010-03-19 00:00:00.0"));
                try {
                    SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt2.executeUpdate());
                    conn.commit();
                    childInserts.add(txId);
                    continue;
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState()) || "23503".equals(sqle.getSQLState())) continue;
                    throw sqle;
                }
            }
            async1.getResult();
            stmt.execute("call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SECL_BO_DATA_STATUS_HIST_SYNC', 1, 0)");
            conn.commit();
            ResultSet rs = oraStmt.executeQuery("select * from gemfire.SECL_BO_DATA2 where BO_TXN_ID <> 'DBSP_LOCK' order by BO_TXN_ID");
            for (i = 1; i <= 200; ++i) {
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)rs.next());
                SerialDBSynchronizerPart2DUnit.assertEquals((String)("09824f04-26ef-49b0-95b2-955d3742" + String.format("%04d", i)), (String)rs.getString(1));
            }
            SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
            rs.close();
            rs = oraStmt.executeQuery("select * from gemfire.SECL_BO_DATA_STATUS_HIST2 order by BO_TXN_ID");
            for (i = 1; i <= childInserts.size(); ++i) {
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)rs.next());
                SerialDBSynchronizerPart2DUnit.assertEquals((String)((String)childInserts.get(i - 1)), (String)rs.getString(1));
            }
            SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
            rs.close();
        }
        finally {
            try {
                oraConn.commit();
            }
            catch (SQLException numTries) {}
            if (locked) {
                while (true) {
                    try {
                        oraStmt.execute("delete from gemfire.SECL_BO_DATA2 where BO_TXN_ID='DBSP_LOCK'");
                    }
                    catch (SQLException sqle) {
                        try {
                            oraStmt.close();
                        }
                        catch (SQLException sQLException) {}
                        try {
                            oraConn.commit();
                        }
                        catch (SQLException sQLException) {}
                        try {
                            oraConn.close();
                        }
                        catch (SQLException sQLException) {}
                        oraConn = this.createOraConnection("jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE)))", "gemfire", "lu5Pheko");
                        oraStmt = oraConn.createStatement();
                        continue;
                    }
                    break;
                }
            }
            try {
                oraStmt.execute("truncate table gemfire.SECL_BO_DATA_STATUS_HIST2");
                oraConn.commit();
            }
            catch (SQLException sQLException) {}
            try {
                oraStmt.execute("delete from gemfire.SECL_BO_DATA2");
                oraConn.commit();
            }
            catch (SQLException sQLException) {}
            try {
                oraConn.close();
            }
            catch (SQLException sQLException) {}
        }
        conn.commit();
        stmt.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExternalDBSyncPropertiesFile() throws Throwable {
        this.startVMs(1, 2, 0, "CHANNELDATAGRP", null);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE gemfire.SECL_BO_DATA_STATUS_HIST (       BO_TXN_ID VARCHAR (36) NOT NULL ,       CLIENT_ID VARCHAR (100) ,       CLIENT_NAME VARCHAR (100) ,       CLIENT_ACCOUNT VARCHAR (100) ,       COMPANY_ID VARCHAR (100) ,       CLIENT_REF_NO VARCHAR (100) ,       VALUE_DATE TIMESTAMP ,       AMOUNT DECIMAL (16,2) ,       CURRENCY VARCHAR (20) ,       ORIG_BANK_ID VARCHAR (100) ,       BACKOFFICE_CODE VARCHAR (100) NOT NULL ,       BENE_ACCNT_NO VARCHAR (100) ,       BENE_NAME VARCHAR (100) ,       BENE_ADDR VARCHAR (256) ,       BENE_BANK_ID VARCHAR (100) ,       BENE_BANK_NAME VARCHAR (100) ,       BENE_BANK_ADDR VARCHAR (256) ,       INSTR_CREATED_TIME TIMESTAMP ,       INSTR_CREATED_BY VARCHAR (100) ,       DATA_LIFE_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_DATE TIMESTAMP ,       MATCH_CATEG_ID INTEGER ,       MATCHING_TIME INTEGER WITH DEFAULT -1 ,       MANUAL_MATCH CHAR (1) WITH DEFAULT 'N' ,       MATCHING_REASON VARCHAR (128) ,       SCREENING_TIME INTEGER NOT NULL ,       IS_MANUAL CHAR (1) WITH DEFAULT 'N' ,       IS_RESENT CHAR (1) WITH DEFAULT 'N' ,       CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,       TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,       OFAC_MSG_ID VARCHAR (64) NOT NULL ,       HIT_STATUS SMALLINT ,       FILE_TYPE VARCHAR (36) WITH DEFAULT 'NA',       ACTUAL_VALUE_DATE TIMESTAMP ,       LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP )      PARTITION BY COLUMN (BO_TXN_ID)      REDUNDANCY 1        EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW      PERSISTENT ASYNCHRONOUS");
        String dbUser = "gemfire";
        String dbPasswd = "lu5Pheko";
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        NetworkServerControl netServer = this.startNetworkServer();
        final String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;";
        Connection dbConn = DriverManager.getConnection(derbyDbUrl + "create=true", "gemfire", "lu5Pheko");
        String transformation = "Blowfish/CBC/NOPADDING";
        int keySize = 64;
        final String encryptedPassword1 = new GfxdSystemAdmin().encryptForExternal("encrypt-password", Arrays.asList("-locators=" + SerialDBSynchronizerPart2DUnit.getDUnitLocatorString()), "gemfire", "lu5Pheko");
        String encryptedPassword2 = new GfxdSystemAdmin().encryptForExternal("encrypt-password", Arrays.asList("-locators=" + SerialDBSynchronizerPart2DUnit.getDUnitLocatorString(), "-transformation=Blowfish/CBC/NOPADDING", "-keysize=64"), "gemfire", "lu5Pheko");
        File dbFile1 = new File(".", "db1.props");
        Properties dbProps = new Properties();
        dbProps.setProperty("user", "gemfire");
        dbProps.setProperty("Password", encryptedPassword1);
        dbProps.setProperty("URL", derbyDbUrl);
        dbProps.setProperty("driver", "org.apache.derby.jdbc.ClientDriver");
        FileOutputStream out = new FileOutputStream(dbFile1);
        dbProps.store(out, "Generated file -- do not change manually");
        out.flush();
        out.close();
        File dbFile2 = new File(".", "ora2.props");
        out = new FileOutputStream(dbFile2);
        dbProps.remove("Password");
        dbProps.setProperty("Secret", encryptedPassword2);
        dbProps.setProperty("transformation", "Blowfish/CBC/NOPADDING");
        dbProps.setProperty("KeySize", Integer.toString(64));
        dbProps.store(out, "Generated file -- do not change manually");
        out.flush();
        out.close();
        final Throwable[] failure = new Throwable[1];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement stmt = conn.createStatement();
                    stmt.execute("create asynceventlistener SECL_BO_DATA_STATUS_HIST_SYNC(listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams  'org.apache.derby.jdbc.ClientDriver," + derbyDbUrl + ',' + "gemfire" + ",secret=" + encryptedPassword1 + "' ENABLEPERSISTENCE true MANUALSTART false " + "ALERTTHRESHOLD 2000) SERVER GROUPS(CHANNELDATAGRP)");
                }
                catch (Throwable t) {
                    failure[0] = t;
                }
            }
        });
        t.start();
        Statement dbStmt = dbConn.createStatement();
        t.join();
        if (failure[0] != null) {
            throw failure[0];
        }
        dbStmt.execute("CREATE TABLE gemfire.SECL_BO_DATA_STATUS_HIST (       BO_TXN_ID VARCHAR (36) NOT NULL ,       CLIENT_ID VARCHAR (100) ,       CLIENT_NAME VARCHAR (100) ,       CLIENT_ACCOUNT VARCHAR (100) ,       COMPANY_ID VARCHAR (100) ,       CLIENT_REF_NO VARCHAR (100) ,       VALUE_DATE TIMESTAMP ,       AMOUNT DECIMAL (16,2) ,       CURRENCY VARCHAR (20) ,       ORIG_BANK_ID VARCHAR (100) ,       BACKOFFICE_CODE VARCHAR (100) NOT NULL ,       BENE_ACCNT_NO VARCHAR (100) ,       BENE_NAME VARCHAR (100) ,       BENE_ADDR VARCHAR (256) ,       BENE_BANK_ID VARCHAR (100) ,       BENE_BANK_NAME VARCHAR (100) ,       BENE_BANK_ADDR VARCHAR (256) ,       INSTR_CREATED_TIME TIMESTAMP ,       INSTR_CREATED_BY VARCHAR (100) ,       DATA_LIFE_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_DATE TIMESTAMP ,       MATCH_CATEG_ID INTEGER ,       MATCHING_TIME INTEGER WITH DEFAULT -1 ,       MANUAL_MATCH CHAR (1) WITH DEFAULT 'N' ,       MATCHING_REASON VARCHAR (128) ,       SCREENING_TIME INTEGER NOT NULL ,       IS_MANUAL CHAR (1) WITH DEFAULT 'N' ,       IS_RESENT CHAR (1) WITH DEFAULT 'N' ,       CHANNEL_NAME VARCHAR (100),       TXN_TYPE VARCHAR (30),       OFAC_MSG_ID VARCHAR (64) NOT NULL ,       HIT_STATUS SMALLINT ,       FILE_TYPE VARCHAR (36),       ACTUAL_VALUE_DATE TIMESTAMP ,       LAST_UPDATE_TIME TIMESTAMP)");
        try {
            stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET  asynceventlistener(SECL_BO_DATA_STATUS_HIST_SYNC)");
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO   gemfire.SECL_BO_DATA_STATUS_HIST (      BO_TXN_ID,   CLIENT_ID,    CLIENT_NAME,  CLIENT_ACCOUNT,       COMPANY_ID,  CLIENT_REF_NO,    VALUE_DATE, AMOUNT,         CURRENCY,       ORIG_BANK_ID,   BACKOFFICE_CODE,     BENE_ACCNT_NO,  BENE_NAME,    BENE_ADDR,   BENE_BANK_ID,   BENE_BANK_NAME, BENE_BANK_ADDR, INSTR_CREATED_TIME,     INSTR_CREATED_BY,  DATA_LIFE_STATUS,       MATCH_STATUS,   MATCH_DATE, MATCH_CATEG_ID, MATCHING_TIME,  MANUAL_MATCH,   MATCHING_REASON,   SCREENING_TIME, IS_MANUAL,    IS_RESENT,      CHANNEL_NAME,   TXN_TYPE,   OFAC_MSG_ID, HIT_STATUS,   ACTUAL_VALUE_DATE, LAST_UPDATE_TIME) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)");
            for (int i = 1; i <= 2000; ++i) {
                pstmt.setObject(1, "09824f04-26ef-49b0-95b2-955d3742" + String.format("%04d", i));
                pstmt.setObject(2, "party name");
                pstmt.setObject(3, null);
                pstmt.setObject(4, "12345678");
                pstmt.setObject(5, "1874563");
                pstmt.setObject(6, "PB130482");
                pstmt.setTimestamp(7, Timestamp.valueOf("2012-07-18 00:00:00.0"));
                pstmt.setObject(8, "158.26");
                pstmt.setObject(9, "CAD");
                pstmt.setObject(10, "CHASGB2LXXX");
                pstmt.setObject(11, "IPAY");
                pstmt.setObject(12, null);
                pstmt.setObject(13, null);
                pstmt.setObject(14, null);
                pstmt.setObject(15, null);
                pstmt.setObject(16, null);
                pstmt.setObject(17, null);
                pstmt.setObject(18, Timestamp.valueOf("2013-03-13 14:20:04.05"));
                pstmt.setObject(19, null);
                pstmt.setObject(20, 1);
                pstmt.setObject(21, 1);
                pstmt.setObject(22, Timestamp.valueOf("2013-03-13 14:20:04.28"));
                pstmt.setObject(23, 2);
                pstmt.setObject(24, 0);
                pstmt.setObject(25, "N");
                pstmt.setObject(26, null);
                pstmt.setObject(27, -1);
                pstmt.setObject(28, "N");
                pstmt.setObject(29, "N");
                pstmt.setObject(30, "PYS");
                pstmt.setObject(31, "UNKNOWN");
                pstmt.setObject(32, "MITHUN0621                                                      ");
                pstmt.setObject(33, null);
                pstmt.setObject(34, Timestamp.valueOf("2010-03-19 00:00:00.0"));
                SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt.executeUpdate());
                conn.commit();
                if (i == 500) {
                    stmt.execute("call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SECL_BO_DATA_STATUS_HIST_SYNC', 1, 0)");
                    conn.commit();
                    stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET asynceventlistener()");
                    stmt.execute("DROP ASYNCEVENTLISTENER SECL_BO_DATA_STATUS_HIST_SYNC");
                    stmt.execute("create asynceventlistener SECL_BO_DATA_STATUS_HIST_SYNC(listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'file=" + dbFile1.getAbsolutePath() + "' ENABLEPERSISTENCE true MANUALSTART true ALERTTHRESHOLD 2000) " + "SERVER GROUPS(CHANNELDATAGRP)");
                    stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET  asynceventlistener(SECL_BO_DATA_STATUS_HIST_SYNC)");
                    stmt.execute("call sys.start_async_event_listener('SECL_BO_DATA_STATUS_HIST_SYNC')");
                    continue;
                }
                if (i == 1000) {
                    stmt.execute("call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SECL_BO_DATA_STATUS_HIST_SYNC', 1, 0)");
                    conn.commit();
                    stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET asynceventlistener()");
                    stmt.execute("DROP ASYNCEVENTLISTENER SECL_BO_DATA_STATUS_HIST_SYNC");
                    stmt.execute("create asynceventlistener SECL_BO_DATA_STATUS_HIST_SYNC (listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams  'org.apache.derby.jdbc.ClientDriver," + derbyDbUrl + ',' + "gemfire" + ",secret=" + encryptedPassword2 + ",Transformation=" + "Blowfish/CBC/NOPADDING" + ",keySize=" + 64 + "' ENABLEPERSISTENCE true MANUALSTART true " + "ALERTTHRESHOLD 2000) SERVER GROUPS(CHANNELDATAGRP)");
                    stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET  asynceventlistener(SECL_BO_DATA_STATUS_HIST_SYNC)");
                    stmt.execute("call sys.start_async_event_listener('SECL_BO_DATA_STATUS_HIST_SYNC')");
                    continue;
                }
                if (i != 1500) continue;
                stmt.execute("call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SECL_BO_DATA_STATUS_HIST_SYNC', 1, 0)");
                conn.commit();
                stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET asynceventlistener()");
                stmt.execute("DROP ASYNCEVENTLISTENER SECL_BO_DATA_STATUS_HIST_SYNC");
                stmt.execute("create asynceventlistener SECL_BO_DATA_STATUS_HIST_SYNC(listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'file=" + dbFile2.getAbsolutePath() + "' ENABLEPERSISTENCE true MANUALSTART true ALERTTHRESHOLD 2000) " + "SERVER GROUPS(CHANNELDATAGRP)");
                stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET  asynceventlistener(SECL_BO_DATA_STATUS_HIST_SYNC)");
                stmt.execute("call sys.start_async_event_listener('SECL_BO_DATA_STATUS_HIST_SYNC')");
            }
            stmt.execute("call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SECL_BO_DATA_STATUS_HIST_SYNC', 1, 0)");
            conn.commit();
            ResultSet rs = dbStmt.executeQuery("select * from gemfire.SECL_BO_DATA_STATUS_HIST order by BO_TXN_ID");
            for (int i = 1; i <= 2000; ++i) {
                SerialDBSynchronizerPart2DUnit.assertTrue((String)("no row found for i=" + i), (boolean)rs.next());
                SerialDBSynchronizerPart2DUnit.assertEquals((String)("09824f04-26ef-49b0-95b2-955d3742" + String.format("%04d", i)), (String)rs.getString(1));
            }
            SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
            rs.close();
        }
        finally {
            try {
                dbConn.commit();
            }
            catch (SQLException sQLException) {}
            try {
                dbStmt.execute("drop table gemfire.SECL_BO_DATA_STATUS_HIST");
                dbConn.commit();
            }
            catch (SQLException sQLException) {}
            try {
                dbConn.close();
            }
            catch (SQLException sQLException) {}
            try {
                netServer.shutdown();
            }
            catch (Exception exception) {}
            dbFile1.delete();
            dbFile2.delete();
        }
        conn.commit();
        stmt.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalBehaviourOfDBSynchronizer_1() throws Exception {
        NetworkServerControl server;
        block9: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(1, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL1)");
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                Connection conn = TestUtil.jdbcConn;
                conn.setTransactionIsolation(2);
                conn.setAutoCommit(false);
                Statement stmt = conn.createStatement();
                stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(227,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(340,'desc340','Add340',340)");
                conn.rollback();
                stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(2,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(224,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(331,'desc340','Add340',340)");
                conn.commit();
                stmt.executeUpdate("update TESTTABLE set ID1 = ID1 +1 ");
                conn.rollback();
                stmt.executeUpdate("delete from TESTTABLE where ID = 1");
                conn.commit();
                this.blockForValidation();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
            }
            catch (Throwable throwable) {
                block10: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block10;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block9;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalBehaviourOfDBSynchronizer_2() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startVMs(1, 1, -1, "SG1", null);
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL1) ");
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                Connection conn = TestUtil.jdbcConn;
                conn.setTransactionIsolation(2);
                conn.setAutoCommit(false);
                Statement stmt = conn.createStatement();
                PreparedStatement pstmt1 = conn.prepareStatement("insert into testtable values(?,?,?,?)");
                for (int i = 1; i < 10; ++i) {
                    pstmt1.setInt(1, i);
                    pstmt1.setString(2, "desc" + i);
                    pstmt1.setString(3, "Add" + i);
                    pstmt1.setInt(4, i);
                    SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt1.executeUpdate());
                }
                conn.commit();
                PreparedStatement pstmt2 = conn.prepareStatement("update testtable set ID1 = ? where description = ?");
                for (int i = 1; i < 5; ++i) {
                    pstmt2.setInt(1, i * 10);
                    pstmt2.setString(2, "desc" + i);
                    SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt2.executeUpdate());
                }
                conn.commit();
                PreparedStatement pstmt3 = conn.prepareStatement("select ID1 from TestTable where description = ?");
                for (int i = 1; i < 5; ++i) {
                    pstmt3.setString(1, "desc" + i);
                    ResultSet rs = pstmt3.executeQuery();
                    SerialDBSynchronizerPart2DUnit.assertTrue((boolean)rs.next());
                    SerialDBSynchronizerPart2DUnit.assertEquals((int)(i * 10), (int)rs.getInt(1));
                }
                SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)stmt.executeUpdate("delete from TESTTABLE where ADDRESS = 'Add5'"));
                pstmt1.setInt(1, 5);
                pstmt1.setString(2, "desc.5");
                pstmt1.setString(3, "Add5");
                pstmt1.setInt(4, 5);
                SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt1.executeUpdate());
                conn.commit();
                stmt.executeUpdate("delete from TESTTABLE where ID = 1");
                conn.commit();
                this.blockForValidation();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
            }
            catch (Throwable throwable) {
                block13: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalBehaviourOfAsyncEventListener_1() throws Exception {
        NetworkServerControl server;
        block9: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(1, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL1)");
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", TXAsyncEventListener.class.getName(), null, derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, null, false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                Connection conn = TestUtil.jdbcConn;
                conn.setTransactionIsolation(2);
                conn.setAutoCommit(false);
                Statement stmt = conn.createStatement();
                stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(227,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(340,'desc340','Add340',340)");
                conn.rollback();
                stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(2,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(224,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(331,'desc340','Add340',340)");
                conn.commit();
                stmt.executeUpdate("update TESTTABLE set ID1 = ID1 +1 ");
                conn.rollback();
                stmt.executeUpdate("delete from TESTTABLE where ID = 1");
                conn.commit();
                this.blockForValidation();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
            }
            catch (Throwable throwable) {
                block10: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block10;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block9;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalBehaviourOfAsyncEventListener_2() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startVMs(1, 1, -1, "SG1", null);
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL1)");
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", TXAsyncEventListener.class.getName(), null, derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, null, false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                Connection conn = TestUtil.jdbcConn;
                conn.setTransactionIsolation(2);
                conn.setAutoCommit(false);
                Statement stmt = conn.createStatement();
                PreparedStatement pstmt1 = conn.prepareStatement("insert into testtable values(?,?,?,?)");
                for (int i = 1; i < 10; ++i) {
                    pstmt1.setInt(1, i);
                    pstmt1.setString(2, "desc" + i);
                    pstmt1.setString(3, "Add" + i);
                    pstmt1.setInt(4, i);
                    SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt1.executeUpdate());
                }
                conn.commit();
                PreparedStatement pstmt2 = conn.prepareStatement("update testtable set ID1 = ? where description = ?");
                for (int i = 1; i < 5; ++i) {
                    pstmt2.setInt(1, i * 10);
                    pstmt2.setString(2, "desc" + i);
                    SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt2.executeUpdate());
                }
                conn.commit();
                PreparedStatement pstmt3 = conn.prepareStatement("select ID1 from TestTable where description = ?");
                for (int i = 1; i < 5; ++i) {
                    pstmt3.setString(1, "desc" + i);
                    ResultSet rs = pstmt3.executeQuery();
                    SerialDBSynchronizerPart2DUnit.assertTrue((boolean)rs.next());
                    SerialDBSynchronizerPart2DUnit.assertEquals((int)(i * 10), (int)rs.getInt(1));
                }
                SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)stmt.executeUpdate("delete from TESTTABLE where ADDRESS = 'Add5'"));
                pstmt1.setInt(1, 5);
                pstmt1.setString(2, "desc.5");
                pstmt1.setString(3, "Add5");
                pstmt1.setInt(4, 5);
                SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)pstmt1.executeUpdate());
                conn.commit();
                stmt.executeUpdate("delete from TESTTABLE where ID = 1");
                conn.commit();
                this.blockForValidation();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
            }
            catch (Throwable throwable) {
                block13: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42706_1() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  replicate ");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                String schema = ((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection().getCurrentSchemaName();
                if (schema == null) {
                    schema = Misc.getDefaultSchemaName((LanguageConnectionContext)((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection());
                }
                conn.createStatement();
                GfxdCallbacksTest.addLoader(schema, "TESTTABLE", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$GfxdTestRowLoader", "");
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
                SerializableCallable queueChecker = this.getEmptyQueueChecker();
                Boolean retVal = (Boolean)this.serverExecute(1, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                retVal = (Boolean)this.serverExecute(2, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                ResultSet rs = derbyStmt.executeQuery("select * from testtable ");
                SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    derbyStmt.executeUpdate("delete from testtable");
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            derbyStmt.executeUpdate("delete from testtable");
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42706_2() throws Exception {
        NetworkServerControl server;
        block14: {
            boolean tablesCreated;
            block13: {
                Connection derbyConn = null;
                Statement derbyStmt = null;
                server = null;
                tablesCreated = false;
                try {
                    server = this.startNetworkServer();
                    this.createDerbyValidationArtefacts();
                    String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                    if (TestUtil.currentUserName != null) {
                        derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                    }
                    derbyConn = DriverManager.getConnection(derbyDbUrl);
                    derbyStmt = derbyConn.createStatement();
                    this.startServerVMs(2, -1, "SG1");
                    this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int ) partition by column(ID1) AsyncEventListener (WBCL2)   ");
                    tablesCreated = true;
                    Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                    this.serverExecute(1, runnable);
                    Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                    this.serverExecute(1, startWBCL);
                    this.startClientVMs(1, 0, null);
                    Connection conn = TestUtil.jdbcConn;
                    String schema = ((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection().getCurrentSchemaName();
                    if (schema == null) {
                        schema = Misc.getDefaultSchemaName((LanguageConnectionContext)((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection());
                    }
                    conn.createStatement();
                    GfxdCallbacksTest.addLoader(schema, "TESTTABLE", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$GfxdTestRowLoader", "");
                    this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
                    this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
                    this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
                    SerializableCallable queueChecker = this.getEmptyQueueChecker();
                    Boolean retVal = (Boolean)this.serverExecute(1, (Callable<?>)queueChecker);
                    SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                    retVal = (Boolean)this.serverExecute(2, (Callable<?>)queueChecker);
                    SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                    ResultSet rs = derbyStmt.executeQuery("select * from testtable ");
                    SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
                    ok = false;
                    if (derbyStmt == null) break block13;
                }
                catch (Throwable throwable) {
                    block15: {
                        ok = false;
                        if (derbyStmt != null) {
                            derbyStmt.executeUpdate("delete from testtable");
                            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                        }
                        if (tablesCreated) {
                            this.clientSQLExecute(1, "drop table TESTTABLE");
                        }
                        try {
                            DriverManager.getConnection("jdbc:derby:;shutdown=true");
                        }
                        catch (SQLException sqle) {
                            if (sqle.getMessage().indexOf("shutdown") != -1) break block15;
                            sqle.printStackTrace();
                            throw sqle;
                        }
                    }
                    if (server != null) {
                        server.shutdown();
                    }
                    throw throwable;
                }
                derbyStmt.executeUpdate("delete from testtable");
                this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            }
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42706_3() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)   ");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                String schema = ((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection().getCurrentSchemaName();
                if (schema == null) {
                    schema = Misc.getDefaultSchemaName((LanguageConnectionContext)((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection());
                }
                conn.createStatement();
                GfxdCallbacksTest.addLoader(schema, "TESTTABLE", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$GfxdTestRowLoader", "");
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
                SerializableCallable queueChecker = this.getEmptyQueueChecker();
                Boolean retVal = (Boolean)this.serverExecute(1, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                retVal = (Boolean)this.serverExecute(2, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                ResultSet rs = derbyStmt.executeQuery("select * from testtable ");
                SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    derbyStmt.executeUpdate("delete from testtable");
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            derbyStmt.executeUpdate("delete from testtable");
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalBehaviourOfBug42706_1() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  replicate ");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                String schema = ((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection().getCurrentSchemaName();
                if (schema == null) {
                    schema = Misc.getDefaultSchemaName((LanguageConnectionContext)((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection());
                }
                GfxdCallbacksTest.addLoader(schema, "TESTTABLE", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$GfxdTestRowLoader", "");
                conn.setTransactionIsolation(2);
                conn.createStatement();
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
                conn.commit();
                SerializableCallable queueChecker = this.getEmptyQueueChecker();
                Boolean retVal = (Boolean)this.serverExecute(1, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                retVal = (Boolean)this.serverExecute(2, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                ResultSet rs = derbyStmt.executeQuery("select * from testtable ");
                SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    derbyStmt.executeUpdate("delete from testtable");
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            derbyStmt.executeUpdate("delete from testtable");
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalBehaviourOfBug42706_2() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  ");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                String schema = ((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection().getCurrentSchemaName();
                if (schema == null) {
                    schema = Misc.getDefaultSchemaName((LanguageConnectionContext)((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection());
                }
                GfxdCallbacksTest.addLoader(schema, "TESTTABLE", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$GfxdTestRowLoader", "");
                conn.setTransactionIsolation(2);
                conn.createStatement();
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
                conn.commit();
                SerializableCallable queueChecker = this.getEmptyQueueChecker();
                Boolean retVal = (Boolean)this.serverExecute(1, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                retVal = (Boolean)this.serverExecute(2, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                ResultSet rs = derbyStmt.executeQuery("select * from testtable ");
                SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    derbyStmt.executeUpdate("delete from testtable");
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            derbyStmt.executeUpdate("delete from testtable");
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalBehaviourOfBug42706_3() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int) partition by column(ID1)AsyncEventListener (WBCL2)");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                String schema = ((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection().getCurrentSchemaName();
                if (schema == null) {
                    schema = Misc.getDefaultSchemaName((LanguageConnectionContext)((EmbedConnection)TestUtil.jdbcConn).getLanguageConnection());
                }
                GfxdCallbacksTest.addLoader(schema, "TESTTABLE", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$GfxdTestRowLoader", "");
                conn.setTransactionIsolation(2);
                conn.createStatement();
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 1", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 2", null, null);
                this.sqlExecuteVerify(new int[]{1}, null, "select ID from TESTTABLE where ID = 3", null, null);
                conn.commit();
                SerializableCallable queueChecker = this.getEmptyQueueChecker();
                Boolean retVal = (Boolean)this.serverExecute(1, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                retVal = (Boolean)this.serverExecute(2, (Callable<?>)queueChecker);
                SerialDBSynchronizerPart2DUnit.assertTrue((boolean)retVal);
                ResultSet rs = derbyStmt.executeQuery("select * from testtable ");
                SerialDBSynchronizerPart2DUnit.assertFalse((boolean)rs.next());
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    derbyStmt.executeUpdate("delete from testtable");
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            derbyStmt.executeUpdate("delete from testtable");
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    public void testSkipListenerBehaviourForDBSynchronizerReplicate() throws Exception {
        this.skipListenerforDBSynchronizer(true, false, -1);
    }

    public void testSkipListenerBehaviourForDBSynchronizerPR() throws Exception {
        this.skipListenerforDBSynchronizer(false, false, -1);
    }

    public void testSkipListenerBehaviourForDBSynchronizerReplicateUsingNetConnection() throws Exception {
        this.skipListenerforDBSynchronizer(true, true, 2724);
    }

    public void testSkipListenerBehaviourForDBSynchronizerPRUsingNetConnection() throws Exception {
        this.skipListenerforDBSynchronizer(false, true, 2725);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipListenerforDBSynchronizer(boolean useReplicate, boolean useNetConnection, int port) throws Exception {
        NetworkServerControl server;
        block12: {
            Statement dStmt = null;
            Connection derbyConn = null;
            server = null;
            try {
                Statement derbyStmt;
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                dStmt = derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(3, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL1) " + (useReplicate ? " replicate " : ""));
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(3,'desc3','Add3',3)");
                if (useNetConnection) {
                    TestUtil.startNetServer(port, null);
                }
                Properties props = new Properties();
                props.put("skip-listeners", "true");
                Connection conn = useNetConnection ? TestUtil.getNetConnection(port, null, props) : TestUtil.getConnection(props);
                Statement stmt = conn.createStatement();
                stmt.execute("Insert into TESTTABLE values(4,'desc4','Add4',4)");
                stmt.execute("Insert into TESTTABLE values(5,'desc5','Add5',5)");
                stmt.execute("Insert into TESTTABLE values(6,'desc6','Add6',6)");
                stmt.execute("update TESTTABLE set ID1 = ID1 +1 ");
                stmt.execute("update TESTTABLE set ID1 =100 where ID = 1");
                stmt.execute("delete from testtable ");
                stmt.execute("delete from testtable where ID = 2");
                SerialDBSynchronizerPart2DUnit.pause((int)2000);
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                SerialDBSynchronizerPart2DUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){
                    private int numItems;

                    public boolean done() {
                        try {
                            ResultSet rs = derbyStmt.executeQuery("select * from testtable order by ID asc");
                            this.numItems = 1;
                            while (rs.next()) {
                                TestCase.assertEquals((int)rs.getInt(1), (int)this.numItems);
                                TestCase.assertEquals((String)rs.getString(2), (String)("desc" + this.numItems));
                                TestCase.assertEquals((String)rs.getString(3), (String)("Add" + this.numItems));
                                TestCase.assertEquals((int)rs.getInt(4), (int)this.numItems);
                                ++this.numItems;
                            }
                            return this.numItems == 4;
                        }
                        catch (SQLException sqle) {
                            DistributedSQLTestBase.fail("unexpected SQLException", sqle);
                            return false;
                        }
                    }

                    public String description() {
                        return "number of items in testtable should be 4 but got " + this.numItems;
                    }
                }, (long)60000L, (long)500L, (boolean)true);
            }
            catch (Throwable throwable) {
                block13: {
                    this.cleanDerbyArtifacts(dStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                if (useNetConnection) {
                    TestUtil.stopNetServer();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(dStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
        if (useNetConnection) {
            TestUtil.stopNetServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreventBulkLoadDBSynchInvocationBug42706_1() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            Statement stmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                int i;
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                this.startServerVMs(3, -1, "SG1");
                this.startClientVMs(1, 0, null);
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  partition by range (ID) (VALUES BETWEEN 0 AND 5,  VALUES BETWEEN 5  AND 10 , VALUES BETWEEN 10  AND 20 )");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                Connection conn = TestUtil.jdbcConn;
                stmt = conn.createStatement();
                String str = "insert into TESTTABLE values";
                for (i = 0; i < 20; ++i) {
                    str = str + "(" + i + ", 'First', 'J 604'," + i + "),";
                }
                str = str.substring(0, str.length() - 1);
                stmt.executeUpdate(str);
                str = "insert into TESTTABLE values";
                for (i = 20; i < 30; ++i) {
                    str = str + "(" + i + ", 'First', 'J 604'," + i + "),";
                }
                str = str.substring(0, str.length() - 1);
                stmt.executeUpdate(str);
                str = "insert into TESTTABLE values";
                for (i = 30; i < 40; ++i) {
                    str = str + "(" + i + ", 'First', 'J 604'," + i + "),";
                }
                str = str.substring(0, str.length() - 1);
                stmt.executeUpdate(str);
                this.addExpectedException(null, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
                startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                SerialDBSynchronizerPart2DUnit.assertEquals((int)1, (int)stmt.executeUpdate("delete from TESTTABLE where ID = 1"));
                this.getServerVM(1).invoke(DBSynchronizerTestBase.class, "waitForAsyncQueueFlush", new Object[]{"WBCL2"});
                this.getServerVM(2).invoke(DBSynchronizerTestBase.class, "waitForAsyncQueueFlush", new Object[]{"WBCL2"});
                this.getServerVM(3).invoke(DBSynchronizerTestBase.class, "waitForAsyncQueueFlush", new Object[]{"WBCL2"});
                this.blockForValidation();
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.validateResults(derbyStmt, "select * from testtable where ID < 20", this.netPort, true);
                ResultSet rs = derbyStmt.executeQuery("select * from TESTTABLE where ID >= 20 and ID <=39");
                rs = stmt.executeQuery("select count(*) from TESTTABLE where ID >= 20 and ID <=39");
                rs.next();
                SerialDBSynchronizerPart2DUnit.assertEquals((int)rs.getInt(1), (int)20);
                this.removeExpectedException(null, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerAfterTruncateTable_Partition() throws Exception {
        NetworkServerControl server;
        block9: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(1, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) partition by primary key AsyncEventListener (WBCL1) ");
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                Connection conn = TestUtil.jdbcConn;
                conn.setTransactionIsolation(2);
                Statement stmt = conn.createStatement();
                stmt.executeUpdate("Insert into TESTTABLE values(1114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(11,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(1227,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(1340,'desc340','Add340',340)");
                conn.commit();
                stmt.executeUpdate("truncate table TESTTABLE");
                conn.commit();
                ResultSet rs = stmt.executeQuery("select count(*) from TESTTABLE");
                JDBC.assertSingleValueResultSet(rs, "0");
                stmt.executeUpdate("delete from TESTTABLE");
                stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(2,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(224,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(331,'desc340','Add340',340)");
                conn.commit();
                stmt.executeUpdate("update TESTTABLE set ID1 = ID1 +1 ");
                conn.rollback();
                stmt.executeUpdate("delete from TESTTABLE where ID = 1");
                conn.commit();
                this.blockForValidation();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
            }
            catch (Throwable throwable) {
                block10: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block10;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block9;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerWithIdentity_UseCase9() throws Exception {
        NetworkServerControl server;
        block12: {
            Statement derbyStmt = null;
            Connection derbyConn = null;
            server = null;
            try {
                int i;
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(3, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int GENERATED BY DEFAULT AS IDENTITY primary key,DESCRIPTION varchar(1024),ADDRESS varchar(1024),ID1 int) server groups(SG1) redundancy 1");
                this.clientSQLExecute(1, "create table TESTTABLE2 (ID int GENERATED BY DEFAULT AS IDENTITY primary key,DESCRIPTION varchar(1024),ADDRESS varchar(1024),ID1 int) server groups(SG1) redundancy 1");
                this.clientSQLExecute(1, "alter table TESTTABLE set AsyncEventListener (WBCL1)");
                this.clientSQLExecute(1, "alter table TESTTABLE2 set AsyncEventListener (WBCL2)");
                derbyStmt.execute("create table TESTTABLE2 (ID int GENERATED BY DEFAULT AS IDENTITY primary key,DESCRIPTION varchar(1024),ADDRESS varchar(1024),ID1 int)");
                derbyConn.commit();
                String dbsyncDerbyUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true";
                if (TestUtil.currentUserName != null) {
                    dbsyncDerbyUrl = dbsyncDerbyUrl + ",user=" + TestUtil.currentUserName + ",password=" + TestUtil.currentUserPassword + ',';
                }
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", dbsyncDerbyUrl + ",app,app,skipIdentityColumns=false", true, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", dbsyncDerbyUrl + ",app,app", true, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
                runnable.run();
                startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL2");
                this.clientExecute(1, startWBCL);
                SerialDBSynchronizerPart2DUnit.pause((int)5000);
                this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
                this.clientSQLExecute(1, "Insert into TESTTABLE(DESCRIPTION, ADDRESS, ID1) values('desc3','Add3',3)");
                this.clientSQLExecute(1, "Insert into TESTTABLE(DESCRIPTION, ADDRESS, ID1) values('desc4','Add4',4)");
                this.clientSQLExecute(1, "Insert into TESTTABLE(DESCRIPTION, ADDRESS, ID1) values('desc5','Add5',5)");
                this.clientSQLExecute(1, "Insert into TESTTABLE(DESCRIPTION, ADDRESS, ID1) values('desc6','Add6',6)");
                PreparedStatement pstmt = TestUtil.getPreparedStatement("insert into TESTTABLE (DESCRIPTION, ADDRESS, ID1) values (?, ?, ?)");
                for (i = 7; i < 30; ++i) {
                    pstmt.setString(1, "desc" + i);
                    pstmt.setString(2, "Addr" + i);
                    pstmt.setInt(3, i);
                    pstmt.addBatch();
                }
                SerialDBSynchronizerPart2DUnit.assertEquals((int)23, (int)pstmt.executeBatch().length);
                this.clientSQLExecute(1, "update TESTTABLE set ID1 = ID1 +1 ");
                this.clientSQLExecute(1, "delete from testtable where ADDRESS = 'Add5'");
                this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
                this.clientSQLExecute(1, "Insert into TESTTABLE2 values(1,'desc1','Add1',1)");
                this.clientSQLExecute(1, "Insert into TESTTABLE2 values(2,'desc2','Add2',2)");
                this.clientSQLExecute(1, "Insert into TESTTABLE2(DESCRIPTION, ADDRESS, ID1) values('desc3','Add3',3)");
                this.clientSQLExecute(1, "Insert into TESTTABLE2(DESCRIPTION, ADDRESS, ID1) values('desc4','Add4',4)");
                this.clientSQLExecute(1, "Insert into TESTTABLE2(DESCRIPTION, ADDRESS, ID1) values('desc5','Add5',5)");
                this.clientSQLExecute(1, "Insert into TESTTABLE2(DESCRIPTION, ADDRESS, ID1) values('desc6','Add6',6)");
                pstmt = TestUtil.getPreparedStatement("insert into TESTTABLE2 (DESCRIPTION, ADDRESS, ID1) values (?, ?, ?)");
                for (i = 7; i < 30; ++i) {
                    pstmt.setString(1, "desc" + i);
                    pstmt.setString(2, "Addr" + i);
                    pstmt.setInt(3, i);
                    pstmt.addBatch();
                }
                SerialDBSynchronizerPart2DUnit.assertEquals((int)23, (int)pstmt.executeBatch().length);
                this.clientSQLExecute(1, "update TESTTABLE2 set ID1 = ID1 +1 ");
                this.clientSQLExecute(1, "delete from testtable2 where ADDRESS = 'Add5'");
                this.clientSQLExecute(1, "delete from TESTTABLE2 where ID = 1");
                this.blockForValidation();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL2").run();
                Thread.sleep(5000L);
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
                this.validateResults(derbyStmt, "select * from testtable2", this.netPort, true);
            }
            catch (Throwable throwable) {
                block13: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE2"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE2"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDBSynchronizerAfterTruncateTable_Replicate() throws Exception {
        NetworkServerControl server;
        block9: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(1, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) replicate AsyncEventListener (WBCL1) ");
                Runnable runnable = SerialDBSynchronizerPart2DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart2DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                Connection conn = TestUtil.jdbcConn;
                conn.setTransactionIsolation(2);
                Statement stmt = conn.createStatement();
                stmt.executeUpdate("Insert into TESTTABLE values(1114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(11,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(1227,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(1340,'desc340','Add340',340)");
                conn.commit();
                stmt.executeUpdate("truncate table TESTTABLE");
                conn.commit();
                ResultSet rs = stmt.executeQuery("select count(*) from TESTTABLE");
                JDBC.assertSingleValueResultSet(rs, "0");
                stmt.executeUpdate("delete from TESTTABLE");
                stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
                stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(2,'desc1','Add1',1)");
                stmt.executeUpdate("Insert into TESTTABLE values(224,'desc227','Add227',227)");
                stmt.executeUpdate("Insert into TESTTABLE values(331,'desc340','Add340',340)");
                conn.commit();
                stmt.executeUpdate("update TESTTABLE set ID1 = ID1 +1 ");
                conn.rollback();
                stmt.executeUpdate("delete from TESTTABLE where ID = 1");
                conn.commit();
                this.blockForValidation();
                SerialDBSynchronizerPart2DUnit.stopAsyncEventListener("WBCL1").run();
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
            }
            catch (Throwable throwable) {
                block10: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block10;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block9;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    private SerializableCallable getEmptyQueueChecker() {
        SerializableCallable queueChecker = new SerializableCallable("Check For Empty Queue"){

            public Object call() throws CacheException {
                GatewaySender sender;
                GemFireCacheImpl cache = Misc.getGemFireCache();
                Boolean qEmpty = Boolean.TRUE;
                Set senders = cache.getAllGatewaySenders();
                if (senders.isEmpty()) {
                    return Boolean.TRUE;
                }
                Iterator i$ = senders.iterator();
                while (i$.hasNext() && (qEmpty = Boolean.valueOf(((AbstractGatewaySender)(sender = (GatewaySender)i$.next())).getQueue().size() == 0)).booleanValue()) {
                }
                return qEmpty;
            }
        };
        return queueChecker;
    }

    public static class TXAsyncEventListener
    implements AsyncEventListener {
        private Connection conn;
        private final AsyncEventHelper helper = new AsyncEventHelper();

        public void init(String initParamStr) {
            try {
                this.conn = DriverManager.getConnection(initParamStr);
            }
            catch (SQLException sqle) {
                throw new GemFireXDRuntimeException((Throwable)sqle);
            }
        }

        public void start() {
        }

        public boolean processEvents(List<Event> events) {
            try {
                for (Event ev : events) {
                    if (ev.getType().isBulkInsert()) {
                        ResultSet rows = ev.getNewRowsAsResultSet();
                        TableMetaData metaData = ev.getResultSetMetaData();
                        int numCols = metaData.getColumnCount();
                        String insertStr = AsyncEventHelper.getInsertString((String)ev.getTableName(), (TableMetaData)metaData, (boolean)false);
                        PreparedStatement ps = this.conn.prepareStatement(insertStr);
                        int numRows = 0;
                        while (rows.next()) {
                            for (int i = 1; i <= numCols; ++i) {
                                ps.setObject(i, rows.getObject(i));
                            }
                            ps.addBatch();
                            ++numRows;
                        }
                        int[] results = ps.executeBatch();
                        TestCase.assertEquals((int)numRows, (int)results.length);
                        for (int r : results) {
                            TestCase.assertEquals((int)1, (int)r);
                        }
                        continue;
                    }
                    if (!ev.getType().isBulkOperation()) continue;
                    PreparedStatement ps = this.conn.prepareStatement(ev.getDMLString());
                    this.helper.setParamsInBulkPreparedStatement(ev, ev.getType(), ps, null, null);
                    ps.execute();
                }
            }
            catch (SQLException sqle) {
                throw new GemFireXDRuntimeException((Throwable)sqle);
            }
            return true;
        }

        public void close() {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException sqle) {
                throw new GemFireXDRuntimeException((Throwable)sqle);
            }
        }
    }
}

