/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dbsync;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisee;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.tools.GfxdSystemAdmin;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.error.ShutdownException;

public class SerialDBSynchronizerPart1DUnit
extends DBSynchronizerTestBase {
    public SerialDBSynchronizerPart1DUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerPRWithSynchronizerOnNonRedundantDataStoreAndDMLOnAccessor() throws Exception {
        NetworkServerControl server;
        block9: {
            Statement derbyStmt = null;
            Connection derbyConn = null;
            server = null;
            try {
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(3, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int) server groups(SG1) redundancy 1");
                this.clientSQLExecute(1, "alter table TESTTABLE set AsyncEventListener (WBCL1)");
                Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl + ",app,app", true, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                SerialDBSynchronizerPart1DUnit.pause((int)5000);
                this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(3,'desc3','Add3',3)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(4,'desc4','Add4',4)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(5,'desc5','Add5',5)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(6,'desc6','Add6',6)");
                this.clientSQLExecute(1, "update TESTTABLE set ID1 = ID1 +1 ");
                this.clientSQLExecute(1, "delete from testtable where ADDRESS = 'Add5'");
                this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
                this.blockForValidation();
                SerialDBSynchronizerPart1DUnit.stopAsyncEventListener("WBCL1").run();
                Thread.sleep(5000L);
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
            }
            catch (Throwable throwable) {
                block10: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block10;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block9;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerRemovalBehaviour() throws Exception {
        NetworkServerControl server;
        block14: {
            Statement derbyStmt = null;
            Connection derbyConn = null;
            server = null;
            try {
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                server = this.startNetworkServer();
                this.addExpectedDerbyException(".*derby\\.daemons\\] \\(DATABASE = newDB\\), \\(DRDAID.*");
                this.createDerbyValidationArtefacts();
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyStmt = derbyConn.createStatement();
                this.startClientVMs(1, 0, null);
                this.startServerVMs(3, -1, "SG1");
                this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL1)");
                Runnable createConfig = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
                createConfig.run();
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                server.shutdown();
                this.addExpectedException(null, new int[]{1, 2, 3}, SQLNonTransientConnectionException.class);
                this.addExpectedException(null, new int[]{1, 2, 3}, GemFireXDRuntimeException.class);
                this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(3,'desc3','Add3',3)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(4,'desc4','Add4',4)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(5,'desc5','Add5',5)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(6,'desc6','Add6',6)");
                SerialDBSynchronizerPart1DUnit.stopAsyncEventListener("WBCL1").run();
                Thread.sleep(5000L);
                this.clientSQLExecute(1, "alter table testtable set AsyncEventListener ()");
                Runnable remove = SerialDBSynchronizerPart1DUnit.dropAsyncEventListener("WBCL1");
                remove.run();
                this.clientSQLExecute(1, "alter table testtable set AsyncEventListener (WBCL1)");
                server = this.startNetworkServer();
                createConfig.run();
                Callable<?> checkQueueEmpty = SerialDBSynchronizerPart1DUnit.getExecutorToCheckQueueEmpty("WBCL1");
                SerialDBSynchronizerPart1DUnit.assertTrue((boolean)((Boolean)this.serverExecute(1, checkQueueEmpty)));
                SerialDBSynchronizerPart1DUnit.assertTrue((boolean)((Boolean)this.serverExecute(2, checkQueueEmpty)));
                SerialDBSynchronizerPart1DUnit.assertTrue((boolean)((Boolean)this.serverExecute(3, checkQueueEmpty)));
            }
            catch (Throwable throwable) {
                block15: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block15;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    try {
                        server.shutdown();
                    }
                    catch (Exception ex) {
                        this.getLogWriter().error((Object)"unexpected exception", (Throwable)ex);
                    }
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            try {
                server.shutdown();
            }
            catch (Exception ex) {
                this.getLogWriter().error((Object)"unexpected exception", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerPRWithSynchronizerOnRedundantDataStoreAndDMLOnAccessor() throws Exception {
        NetworkServerControl server;
        block13: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                Runnable runnable;
                block12: {
                    server = this.startNetworkServer();
                    this.createDerbyValidationArtefacts();
                    String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                    if (TestUtil.currentUserName != null) {
                        derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                    }
                    derbyConn = DriverManager.getConnection(derbyDbUrl);
                    derbyStmt = derbyConn.createStatement();
                    this.startClientVMs(1, 0, null);
                    this.startServerVMs(1, -1, "SG0");
                    this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) redundancy 1");
                    runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
                    try {
                        runnable.run();
                        SerialDBSynchronizerPart1DUnit.fail((String)"expected exception when starting WBCL1 without available store");
                    }
                    catch (RuntimeException re) {
                        if (!(re.getCause() instanceof SQLException)) {
                            throw re;
                        }
                        SQLException sqle = (SQLException)re.getCause();
                        if ("X0Z08".equals(sqle.getSQLState())) break block12;
                        throw re;
                    }
                }
                this.clientSQLExecute(1, "Insert into TESTTABLE values(114,'desc114','Add114',114)");
                this.startServerVMs(1, -1, "SG1");
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                this.addExpectedException(null, new int[]{2}, "java.sql.SQLIntegrityConstraintViolationException");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(227,'desc227','Add227',227)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(340,'desc340','Add340',340)");
                this.clientSQLExecute(1, "update TESTTABLE set ID1 = ID1 +1 ");
                this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
                this.blockForValidation();
                SerialDBSynchronizerPart1DUnit.stopAsyncEventListener("WBCL1").run();
                this.removeExpectedException(null, new int[]{2}, "java.sql.SQLIntegrityConstraintViolationException");
                this.validateResults(derbyStmt, "select * from testtable where ID <> 114", this.netPort, true);
            }
            catch (Throwable throwable) {
                block14: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerPRWithSynchronizerOnNonRedundantNonPrimaryDataStoreAndDMLOnAccessor() throws Exception {
        NetworkServerControl server;
        block13: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                Runnable runnable;
                block12: {
                    server = this.startNetworkServer();
                    this.createDerbyValidationArtefacts();
                    String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                    if (TestUtil.currentUserName != null) {
                        derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                    }
                    derbyConn = DriverManager.getConnection(derbyDbUrl);
                    derbyStmt = derbyConn.createStatement();
                    this.startClientVMs(1, 0, null);
                    this.startServerVMs(1, -1, "SG0");
                    this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
                    runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
                    try {
                        runnable.run();
                        SerialDBSynchronizerPart1DUnit.fail((String)"expected exception when starting WBCL1 without available store");
                    }
                    catch (RuntimeException re) {
                        if (!(re.getCause() instanceof SQLException)) {
                            throw re;
                        }
                        SQLException sqle = (SQLException)re.getCause();
                        if ("X0Z08".equals(sqle.getSQLState())) break block12;
                        throw re;
                    }
                }
                this.clientSQLExecute(1, "Insert into TESTTABLE values(114,'desc114','Add114',114)");
                this.startServerVMs(1, -1, "SG1");
                runnable.run();
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL1");
                this.clientExecute(1, startWBCL);
                this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(227,'desc227','Add227',227)");
                this.clientSQLExecute(1, "Insert into TESTTABLE values(340,'desc340','Add340',340)");
                this.clientSQLExecute(1, "update TESTTABLE set ID1 = ID1 +1 ");
                this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
                this.blockForValidation();
                SerialDBSynchronizerPart1DUnit.stopAsyncEventListener("WBCL1").run();
                this.validateResults(derbyStmt, "select * from testtable where ID <> 114", this.netPort, true);
            }
            catch (Throwable throwable) {
                block14: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerPRWithSynchronizerOnNonRedundantNonPrimaryDataStoreAndDMLOnPrimaryDataStore() throws Exception {
        NetworkServerControl server;
        block14: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            try {
                Runnable runnable;
                block13: {
                    server = this.startNetworkServer();
                    this.createDerbyValidationArtefacts();
                    String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                    if (TestUtil.currentUserName != null) {
                        derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                    }
                    derbyConn = DriverManager.getConnection(derbyDbUrl);
                    derbyStmt = derbyConn.createStatement();
                    this.startServerVMs(1, -1, "SG0");
                    this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
                    runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
                    try {
                        this.serverExecute(1, runnable);
                        SerialDBSynchronizerPart1DUnit.fail((String)"expected exception when starting WBCL1 without available store");
                    }
                    catch (RMIException rmie) {
                        if (!(rmie.getCause() instanceof RuntimeException)) {
                            throw rmie;
                        }
                        if (!(rmie.getCause().getCause() instanceof SQLException)) {
                            throw rmie;
                        }
                        SQLException sqle = (SQLException)rmie.getCause().getCause();
                        if ("X0Z08".equals(sqle.getSQLState())) break block13;
                        throw rmie;
                    }
                }
                this.serverSQLExecute(1, "Insert into TESTTABLE values(114,'desc114','Add114',114)");
                this.startServerVMs(1, -1, "SG1");
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL1");
                this.serverExecute(1, startWBCL);
                this.serverSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
                this.serverSQLExecute(1, "Insert into TESTTABLE values(227,'desc227','Add227',227)");
                this.serverSQLExecute(1, "Insert into TESTTABLE values(340,'desc340','Add340',340)");
                this.serverSQLExecute(1, "update TESTTABLE set ID1 = ID1 +1 ");
                this.serverSQLExecute(1, "delete from TESTTABLE where ID = 1");
                this.blockForValidation();
                this.serverExecute(1, SerialDBSynchronizerPart1DUnit.stopAsyncEventListener("WBCL1"));
                this.startClientVMs(1, 0, null);
                this.validateResults(derbyStmt, "select * from testtable where ID <> 114", this.netPort, true);
            }
            catch (Throwable throwable) {
                block15: {
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block15;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    public void testBug41585_BulkOpsOnPRWithResolver() throws Exception {
        this.common_1(" partition by list (ID) ( VALUES (0, 5) , VALUES (10, 15),VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))", false);
    }

    public void testDBSynchronizerOnDataStoreAndDMLOnAccessorPRWithPrms() throws Exception {
        this.common_1("", false);
    }

    public void testBug41593() throws Exception {
        this.common_1("", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void common_1(String extnClause, boolean useGfxdNetworkClient) throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(1, -1, "SG1");
        Statement derbyStmt = null;
        NetworkServerControl server = null;
        server = this.startNetworkServer();
        this.createDerbyValidationArtefacts();
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        derbyStmt = derbyConn.createStatement();
        String tableDef = "create table TESTTABLE1 (ID int not null primary key, test_bigint BIGINT, test_boolean smallint, test_bit smallint, test_date DATE, test_numeric NUMERIC, test_decimal DECIMAL, test_double DOUBLE, test_float FLOAT, test_real REAL, test_smallint SMALLINT, test_tinyint smallint, test_varchar varchar(1024), test_char char(40), test_longvarchar long varchar, test_time TIME, test_timestamp Timestamp )";
        derbyStmt.execute(tableDef);
        boolean tablesCreated = false;
        try {
            if (useGfxdNetworkClient) {
                Connection conn;
                TestUtil.jdbcConn = conn = TestUtil.startNetserverAndGetLocalNetConnection();
            }
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL2) ");
            this.clientSQLExecute(1, tableDef + " AsyncEventListener(WBCL2) " + extnClause);
            tablesCreated = true;
            Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
            this.clientExecute(1, runnable);
            Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("wbcl2");
            this.clientExecute(1, startWBCL);
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            Connection conn = TestUtil.jdbcConn;
            PreparedStatement insertData = conn.prepareStatement("insert into TESTTABLE1 values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            for (int i = 1; i < 51; ++i) {
                insertData.setInt(1, i);
                insertData.setLong(2, Long.MIN_VALUE + (long)i);
                insertData.setInt(3, 1);
                insertData.setInt(4, 0);
                insertData.setDate(5, new Date(System.currentTimeMillis() + (long)i));
                insertData.setBigDecimal(6, new BigDecimal(Double.MIN_VALUE + (double)i));
                insertData.setBigDecimal(7, new BigDecimal(Double.MIN_VALUE + (double)i));
                insertData.setDouble(8, Double.MIN_VALUE + (double)i);
                insertData.setFloat(9, Float.MIN_VALUE + (float)i);
                insertData.setFloat(10, Float.MIN_VALUE + (float)i);
                insertData.setInt(11, 127);
                insertData.setInt(12, 128);
                insertData.setString(13, "test" + i);
                insertData.setString(14, "test" + i);
                insertData.setString(15, "test" + i);
                insertData.setTime(16, new Time(System.currentTimeMillis() + (long)i));
                insertData.setTimestamp(17, new Timestamp(System.currentTimeMillis() + (long)i));
                SerialDBSynchronizerPart1DUnit.assertEquals((int)insertData.executeUpdate(), (int)1);
            }
            PreparedStatement updateData = conn.prepareStatement("Update TESTTABLE1 set test_bigint = ?, test_boolean = ?, test_bit  = ?, test_date = ?, test_numeric = ?, test_decimal = ? , test_double = ?, test_float = ?, test_real = ?,  test_smallint =  ?, test_tinyint = ?, test_varchar = ? ,  test_char = ?, test_longvarchar = ?, test_time = ?, test_timestamp = ? where test_varchar =?");
            updateData.setLong(1, Long.MAX_VALUE);
            updateData.setInt(2, 127);
            updateData.setInt(3, 127);
            updateData.setDate(4, new Date(Integer.MAX_VALUE));
            updateData.setBigDecimal(5, new BigDecimal(Short.MAX_VALUE));
            updateData.setBigDecimal(6, new BigDecimal(Short.MAX_VALUE));
            updateData.setDouble(7, 1.79769E308);
            updateData.setFloat(8, 3.402E38f);
            updateData.setFloat(9, 3.402E38f);
            updateData.setInt(10, 127);
            updateData.setInt(11, 127);
            updateData.setString(12, "test01");
            updateData.setString(13, "test01");
            updateData.setString(14, "test01");
            updateData.setTime(15, new Time(Integer.MAX_VALUE));
            updateData.setTimestamp(16, new Timestamp(Integer.MAX_VALUE));
            updateData.setString(17, "test10");
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)updateData.executeUpdate());
            PreparedStatement deleteData = conn.prepareStatement("delete from testtable1 where  ID > ?");
            deleteData.setInt(1, 46);
            SerialDBSynchronizerPart1DUnit.assertEquals((int)4, (int)deleteData.executeUpdate());
            this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
            this.blockForValidation();
            this.validateResults(derbyStmt, "select * from testtable1", this.netPort, true);
            Connection conn1 = TestUtil.jdbcConn;
            Statement stmt1 = conn1.createStatement();
            ResultSet rs = stmt1.executeQuery("select * from testtable1 where ID = 10");
            SerialDBSynchronizerPart1DUnit.assertTrue((boolean)rs.next());
            SerialDBSynchronizerPart1DUnit.assertEquals((int)rs.getInt(1), (int)10);
            SerialDBSynchronizerPart1DUnit.assertEquals((long)rs.getLong(2), (long)Long.MAX_VALUE);
            SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getDate(5).toString(), (String)new Date(Integer.MAX_VALUE).toString());
            SerialDBSynchronizerPart1DUnit.assertEquals((Object)rs.getDouble(8), (Object)1.79769E308);
            SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getString(13), (String)"test01");
            SerialDBSynchronizerPart1DUnit.assertFalse((boolean)rs.next());
            ok = false;
        }
        catch (Throwable throwable) {
            ok = false;
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            this.addExpectedDerbyException("java.sql.SQLNonTransientException");
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE1");
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            if (useGfxdNetworkClient) {
                TestUtil.stopNetServer();
            }
            if (server != null) {
                server.shutdown();
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
        this.addExpectedDerbyException(ShutdownException.class.getName());
        this.addExpectedDerbyException("java.sql.SQLNonTransientException");
        if (tablesCreated) {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
            this.clientSQLExecute(1, "drop table TESTTABLE");
        }
        if (useGfxdNetworkClient) {
            TestUtil.stopNetServer();
        }
        if (server != null) {
            server.shutdown();
        }
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    public void testDBSynchronizerBehaviourWithNetworkClient() throws Exception {
        this.common_1("", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testDBSynchronizerWithPrmsRedundancyBehaviour() throws Exception {
        Connection derbyConn = null;
        Statement derbyStmt = null;
        NetworkServerControl server = null;
        boolean tablesCreated = false;
        try {
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            String tableDef = " create table TESTTABLE1 ( ID int not null primary key , test_bigint BIGINT,  test_boolean smallint, test_bit smallint, test_date DATE,  test_numeric NUMERIC,  test_decimal DECIMAL, test_double DOUBLE, test_float FLOAT, test_real REAL,  test_smallint SMALLINT, test_tinyint smallint, test_varchar varchar(1024) ,  test_char char(40), test_longvarchar long varchar, test_time TIME, test_timestamp Timestamp )";
            derbyStmt.execute(tableDef);
            this.startClientVMs(1, 0, null);
            this.startServerVMs(1, -1, "SG1");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2) ");
            this.clientSQLExecute(1, tableDef + " AsyncEventListener(WBCL2) ");
            tablesCreated = true;
            Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
            this.clientExecute(1, runnable);
            Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL2");
            this.clientExecute(1, startWBCL);
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
            this.blockForValidation();
            ((VM)this.serverVMs.get(0)).invoke((Runnable)new SerializableRunnable(){

                public void run() {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsMod, Statement ps, String dml) {
                            try {
                                AsyncEventQueue asyncQueue;
                                while ((asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL2")) == null || asyncQueue.isRunning()) {
                                    Thread.sleep(100L);
                                }
                            }
                            catch (InterruptedException e) {
                                AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL2");
                                if (!asyncQueue.isRunning()) {
                                    throw GemFireXDRuntimeException.newRuntimeException((String)"IGNORE_EXCEPTION_test :Asynch DB Synchronizer thread encountered exception", (Throwable)e);
                                }
                                throw GemFireXDRuntimeException.newRuntimeException((String)"Asynch DB Synchronizer thread encountered exception", (Throwable)e);
                            }
                        }
                    });
                }
            });
            Connection conn = TestUtil.jdbcConn;
            PreparedStatement insertData = conn.prepareStatement("insert into TESTTABLE1 values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            for (int i = 1; i < 51; ++i) {
                insertData.setInt(1, i);
                insertData.setLong(2, Long.MIN_VALUE + (long)i);
                insertData.setInt(3, 1);
                insertData.setInt(4, 0);
                insertData.setDate(5, new Date(System.currentTimeMillis() + (long)i));
                insertData.setBigDecimal(6, new BigDecimal(Double.MIN_VALUE + (double)i));
                insertData.setBigDecimal(7, new BigDecimal(Double.MIN_VALUE + (double)i));
                insertData.setDouble(8, Double.MIN_VALUE + (double)i);
                insertData.setFloat(9, Float.MIN_VALUE + (float)i);
                insertData.setFloat(10, Float.MIN_VALUE + (float)i);
                insertData.setInt(11, 127);
                insertData.setInt(12, 128);
                insertData.setString(13, "test" + i);
                insertData.setString(14, "test" + i);
                insertData.setString(15, "test" + i);
                insertData.setTime(16, new Time(System.currentTimeMillis() + (long)i));
                insertData.setTimestamp(17, new Timestamp(System.currentTimeMillis() + (long)i));
                SerialDBSynchronizerPart1DUnit.assertEquals((int)insertData.executeUpdate(), (int)1);
            }
            PreparedStatement updateData1 = conn.prepareStatement("Update TESTTABLE1 set  test_boolean = ? where test_varchar = ?");
            updateData1.setInt(1, 11);
            updateData1.setString(2, "test8");
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)updateData1.executeUpdate());
            PreparedStatement updateData = conn.prepareStatement("Update TESTTABLE1 set test_bigint = ?, test_boolean = ?, test_bit  = ?, test_date = ?, test_numeric = ?, test_decimal = ? , test_double = ?, test_float = ?, test_real = ?,  test_smallint =  ?, test_tinyint = ?, test_varchar = ? ,  test_char = ?, test_longvarchar = ?, test_time = ?, test_timestamp = ? where test_varchar =?");
            updateData.setLong(1, Long.MAX_VALUE);
            updateData.setInt(2, 127);
            updateData.setInt(3, 127);
            updateData.setDate(4, new Date(Integer.MAX_VALUE));
            updateData.setBigDecimal(5, new BigDecimal(Short.MAX_VALUE));
            updateData.setBigDecimal(6, new BigDecimal(Short.MAX_VALUE));
            updateData.setDouble(7, 1.79769E308);
            updateData.setFloat(8, 3.402E38f);
            updateData.setFloat(9, 3.402E38f);
            updateData.setInt(10, 127);
            updateData.setInt(11, 127);
            updateData.setString(12, "test01");
            updateData.setString(13, "test01");
            updateData.setString(14, "test01");
            updateData.setTime(15, new Time(Integer.MAX_VALUE));
            updateData.setTimestamp(16, new Timestamp(Integer.MAX_VALUE));
            updateData.setString(17, "test10");
            SerialDBSynchronizerPart1DUnit.assertEquals((int)updateData.executeUpdate(), (int)1);
            PreparedStatement deleteData = conn.prepareStatement("delete from testtable1 where  ID > ?");
            deleteData.setInt(1, 46);
            SerialDBSynchronizerPart1DUnit.assertEquals((int)4, (int)deleteData.executeUpdate());
            this.startServerVMs(1, -1, "SG1");
            ResultSet rs = derbyStmt.executeQuery("select * from testtable1 where ID = 10");
            SerialDBSynchronizerPart1DUnit.assertTrue((boolean)rs.next());
            SerialDBSynchronizerPart1DUnit.assertEquals((int)rs.getInt(1), (int)10);
            SerialDBSynchronizerPart1DUnit.assertTrue((rs.getLong(2) != Long.MAX_VALUE ? 1 : 0) != 0);
            SerialDBSynchronizerPart1DUnit.assertTrue((!rs.getString(13).equals("test01") ? 1 : 0) != 0);
            SerialDBSynchronizerPart1DUnit.assertFalse((boolean)rs.next());
            this.startServerVMs(1, -1, "SG1");
            this.serverExecute(1, (Runnable)new SerializableRunnable(){

                public void run() {
                    Misc.getGemFireCache().getAsyncEventQueue("WBCL2").stop();
                }
            });
            this.createDerbyValidationArtefacts();
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
            this.blockForValidation();
            this.validateResults(derbyStmt, "select * from testtable1", this.netPort, true);
            Connection conn1 = TestUtil.jdbcConn;
            Statement stmt1 = conn1.createStatement();
            rs = stmt1.executeQuery("select * from testtable1 where ID = 10");
            SerialDBSynchronizerPart1DUnit.assertTrue((boolean)rs.next());
            SerialDBSynchronizerPart1DUnit.assertEquals((int)rs.getInt(1), (int)10);
            SerialDBSynchronizerPart1DUnit.assertEquals((long)rs.getLong(2), (long)Long.MAX_VALUE);
            SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getDate(5).toString(), (String)new Date(Integer.MAX_VALUE).toString());
            SerialDBSynchronizerPart1DUnit.assertEquals((Object)rs.getDouble(8), (Object)1.79769E308);
            SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getString(13), (String)"test01");
            SerialDBSynchronizerPart1DUnit.assertFalse((boolean)rs.next());
            ok = false;
        }
        catch (Throwable throwable) {
            ok = false;
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE1");
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            if (server != null) {
                server.shutdown();
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
        this.addExpectedDerbyException(ShutdownException.class.getName());
        if (tablesCreated) {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
            this.clientSQLExecute(1, "drop table TESTTABLE");
        }
        if (server != null) {
            server.shutdown();
        }
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerOnReplicatedRegionWithDMLOnDataStoreAndHubOnDataStore() throws Exception {
        NetworkServerControl server;
        block11: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                String tableDef = " create table TESTTABLE1 ( ID int not null primary key , test_bigint BIGINT,  test_boolean smallint, test_bit smallint, test_date DATE,  test_numeric NUMERIC,  test_decimal DECIMAL, test_double DOUBLE, test_float FLOAT, test_real REAL,  test_smallint SMALLINT, test_tinyint smallint, test_varchar varchar(1024) ,  test_char char(40), test_longvarchar long varchar, test_time TIME, test_timestamp Timestamp )";
                derbyStmt.execute(tableDef);
                this.startClientVMs(1, 0, null);
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2) ");
                this.serverSQLExecute(1, tableDef + " REPLICATE  AsyncEventListener(WBCL2) ");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                SerializableRunnable sr = new SerializableRunnable(){

                    public void run() {
                        try {
                            Connection conn = TestUtil.jdbcConn;
                            Statement stmt = conn.createStatement();
                            TestCase.assertEquals((int)1, (int)stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)"));
                            PreparedStatement insertData = conn.prepareStatement("insert into TESTTABLE1 values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            for (int i = 1; i < 51; ++i) {
                                insertData.setInt(1, i);
                                insertData.setLong(2, Long.MIN_VALUE + (long)i);
                                insertData.setInt(3, 1);
                                insertData.setInt(4, 0);
                                insertData.setDate(5, new Date(System.currentTimeMillis() + (long)i));
                                insertData.setBigDecimal(6, new BigDecimal(Double.MIN_VALUE + (double)i));
                                insertData.setBigDecimal(7, new BigDecimal(Double.MIN_VALUE + (double)i));
                                insertData.setDouble(8, Double.MIN_VALUE + (double)i);
                                insertData.setFloat(9, Float.MIN_VALUE + (float)i);
                                insertData.setFloat(10, Float.MIN_VALUE + (float)i);
                                insertData.setInt(11, 127);
                                insertData.setInt(12, 128);
                                insertData.setString(13, "test" + i);
                                insertData.setString(14, "test" + i);
                                insertData.setString(15, "test" + i);
                                insertData.setTime(16, new Time(System.currentTimeMillis() + (long)i));
                                insertData.setTimestamp(17, new Timestamp(System.currentTimeMillis() + (long)i));
                                TestCase.assertEquals((int)insertData.executeUpdate(), (int)1);
                            }
                            PreparedStatement updateData = conn.prepareStatement("Update TESTTABLE1 set test_bigint = ?, test_boolean = ?, test_bit  = ?, test_date = ?, test_numeric = ?, test_decimal = ? , test_double = ?, test_float = ?, test_real = ?,  test_smallint =  ?, test_tinyint = ?, test_varchar = ? ,  test_char = ?, test_longvarchar = ?, test_time = ?, test_timestamp = ? where test_varchar =?");
                            updateData.setLong(1, Long.MAX_VALUE);
                            updateData.setInt(2, 127);
                            updateData.setInt(3, 127);
                            updateData.setDate(4, new Date(Integer.MAX_VALUE));
                            updateData.setBigDecimal(5, new BigDecimal(Short.MAX_VALUE));
                            updateData.setBigDecimal(6, new BigDecimal(Short.MAX_VALUE));
                            updateData.setDouble(7, 1.79769E308);
                            updateData.setFloat(8, 3.402E38f);
                            updateData.setFloat(9, 3.402E38f);
                            updateData.setInt(10, 127);
                            updateData.setInt(11, 127);
                            updateData.setString(12, "test01");
                            updateData.setString(13, "test01");
                            updateData.setString(14, "test01");
                            updateData.setTime(15, new Time(Integer.MAX_VALUE));
                            updateData.setTimestamp(16, new Timestamp(Integer.MAX_VALUE));
                            updateData.setString(17, "test10");
                            TestCase.assertEquals((int)updateData.executeUpdate(), (int)1);
                            PreparedStatement deleteData = conn.prepareStatement("delete from testtable1 where  ID > ?");
                            deleteData.setInt(1, 46);
                            TestCase.assertEquals((int)4, (int)deleteData.executeUpdate());
                            TestCase.assertEquals((int)1, (int)stmt.executeUpdate("delete from TESTTABLE where ID = 1"));
                        }
                        catch (Exception e) {
                            throw GemFireXDRuntimeException.newRuntimeException((String)"Exception in the test", (Throwable)e);
                        }
                    }
                };
                this.serverExecute(1, (Runnable)sr);
                this.blockForValidation();
                this.startClientVMs(1, -1, "SG");
                this.validateResults(derbyStmt, "select * from testtable1", this.netPort, true);
                Connection conn1 = TestUtil.jdbcConn;
                Statement stmt1 = conn1.createStatement();
                ResultSet rs = stmt1.executeQuery("select * from testtable1 where ID = 10");
                SerialDBSynchronizerPart1DUnit.assertTrue((boolean)rs.next());
                SerialDBSynchronizerPart1DUnit.assertEquals((int)rs.getInt(1), (int)10);
                SerialDBSynchronizerPart1DUnit.assertEquals((long)rs.getLong(2), (long)Long.MAX_VALUE);
                SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getDate(5).toString(), (String)new Date(Integer.MAX_VALUE).toString());
                SerialDBSynchronizerPart1DUnit.assertEquals((Object)rs.getDouble(8), (Object)1.79769E308);
                SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getString(13), (String)"test01");
                SerialDBSynchronizerPart1DUnit.assertFalse((boolean)rs.next());
                ok = false;
            }
            catch (Throwable throwable) {
                block12: {
                    ok = false;
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE1");
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE1");
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block11;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerOnReplicatedRegionWithDMLOnAccesoreAndHubOnDataStore() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            Statement stmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                String tableDef = "create table TESTTABLE1 (ID int not null primary key, test_bigint BIGINT, test_boolean smallint, test_bit smallint, test_date DATE, test_numeric NUMERIC, test_decimal DECIMAL, test_double DOUBLE, test_float FLOAT, test_real REAL, test_smallint SMALLINT, test_tinyint smallint, test_varchar varchar(1024), test_char char(40), test_longvarchar long varchar, test_time TIME, test_timestamp Timestamp)";
                derbyStmt.execute(tableDef);
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2) ");
                this.serverSQLExecute(1, tableDef + " REPLICATE  AsyncEventListener(WBCL2) ");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                stmt = conn.createStatement();
                SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)"));
                PreparedStatement insertData = conn.prepareStatement("insert into TESTTABLE1 values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                for (int i = 1; i < 51; ++i) {
                    insertData.setInt(1, i);
                    insertData.setLong(2, Long.MIN_VALUE + (long)i);
                    insertData.setInt(3, 1);
                    insertData.setInt(4, 0);
                    insertData.setDate(5, new Date(System.currentTimeMillis() + (long)i));
                    insertData.setBigDecimal(6, new BigDecimal(Double.MIN_VALUE + (double)i));
                    insertData.setBigDecimal(7, new BigDecimal(Double.MIN_VALUE + (double)i));
                    insertData.setDouble(8, Double.MIN_VALUE + (double)i);
                    insertData.setFloat(9, Float.MIN_VALUE + (float)i);
                    insertData.setFloat(10, Float.MIN_VALUE + (float)i);
                    insertData.setInt(11, 127);
                    insertData.setInt(12, 128);
                    insertData.setString(13, "test" + i);
                    insertData.setString(14, "test" + i);
                    insertData.setString(15, "test" + i);
                    insertData.setTime(16, new Time(System.currentTimeMillis() + (long)i));
                    insertData.setTimestamp(17, new Timestamp(System.currentTimeMillis() + (long)i));
                    SerialDBSynchronizerPart1DUnit.assertEquals((int)insertData.executeUpdate(), (int)1);
                }
                PreparedStatement updateData = conn.prepareStatement("Update TESTTABLE1 set test_bigint = ?, test_boolean = ?, test_bit  = ?, test_date = ?, test_numeric = ?, test_decimal = ? , test_double = ?, test_float = ?, test_real = ?,  test_smallint =  ?, test_tinyint = ?, test_varchar = ? ,  test_char = ?, test_longvarchar = ?, test_time = ?, test_timestamp = ? where test_varchar =?");
                updateData.setLong(1, Long.MAX_VALUE);
                updateData.setInt(2, 127);
                updateData.setInt(3, 127);
                updateData.setDate(4, new Date(Integer.MAX_VALUE));
                updateData.setBigDecimal(5, new BigDecimal(Short.MAX_VALUE));
                updateData.setBigDecimal(6, new BigDecimal(Short.MAX_VALUE));
                updateData.setDouble(7, 1.79769E308);
                updateData.setFloat(8, 3.402E38f);
                updateData.setFloat(9, 3.402E38f);
                updateData.setInt(10, 127);
                updateData.setInt(11, 127);
                updateData.setString(12, "test01");
                updateData.setString(13, "test01");
                updateData.setString(14, "test01");
                updateData.setTime(15, new Time(Integer.MAX_VALUE));
                updateData.setTimestamp(16, new Timestamp(Integer.MAX_VALUE));
                updateData.setString(17, "test10");
                SerialDBSynchronizerPart1DUnit.assertEquals((int)updateData.executeUpdate(), (int)1);
                PreparedStatement deleteData = conn.prepareStatement("delete from testtable1 where  ID > ?");
                deleteData.setInt(1, 46);
                SerialDBSynchronizerPart1DUnit.assertEquals((int)4, (int)deleteData.executeUpdate());
                SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)stmt.executeUpdate("delete from TESTTABLE where ID = 1"));
                this.blockForValidation();
                this.startClientVMs(1, -1, "SG");
                this.validateResults(derbyStmt, "select * from testtable1", this.netPort, true);
                Connection conn1 = TestUtil.jdbcConn;
                Statement stmt1 = conn1.createStatement();
                ResultSet rs = stmt1.executeQuery("select * from testtable1 where ID = 10");
                SerialDBSynchronizerPart1DUnit.assertTrue((boolean)rs.next());
                SerialDBSynchronizerPart1DUnit.assertEquals((int)rs.getInt(1), (int)10);
                SerialDBSynchronizerPart1DUnit.assertEquals((long)rs.getLong(2), (long)Long.MAX_VALUE);
                SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getDate(5).toString(), (String)new Date(Integer.MAX_VALUE).toString());
                SerialDBSynchronizerPart1DUnit.assertEquals((Object)rs.getDouble(8), (Object)1.79769E308);
                SerialDBSynchronizerPart1DUnit.assertEquals((String)rs.getString(13), (String)"test01");
                SerialDBSynchronizerPart1DUnit.assertFalse((boolean)rs.next());
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
                    this.addExpectedDerbyException(ShutdownException.class.getName());
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE1");
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE", "TESTTABLE1"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE1");
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42430_1() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            Statement stmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  partition by range (ID) (VALUES BETWEEN 0 AND 5,  VALUES BETWEEN 5  AND 10 , VALUES BETWEEN 10  AND 20 )");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                stmt = conn.createStatement();
                String str = "insert into TESTTABLE values";
                for (int i = 0; i < 20; ++i) {
                    str = str + "(" + i + ", 'First', 'J 604'," + i + "),";
                }
                str = str.substring(0, str.length() - 1);
                stmt.executeUpdate(str);
                SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)stmt.executeUpdate("delete from TESTTABLE where ID = 1"));
                this.blockForValidation();
                this.startClientVMs(1, -1, "SG");
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42430_2() throws Exception {
        NetworkServerControl server;
        block12: {
            Connection derbyConn = null;
            Statement derbyStmt = null;
            Statement stmt = null;
            server = null;
            boolean tablesCreated = false;
            try {
                server = this.startNetworkServer();
                this.createDerbyValidationArtefacts();
                String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
                if (TestUtil.currentUserName != null) {
                    derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
                }
                derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                this.startServerVMs(2, -1, "SG1");
                this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL2)  replicate ");
                tablesCreated = true;
                Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
                this.serverExecute(1, runnable);
                Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL2");
                this.serverExecute(1, startWBCL);
                this.startClientVMs(1, 0, null);
                Connection conn = TestUtil.jdbcConn;
                stmt = conn.createStatement();
                String str = "insert into TESTTABLE values";
                for (int i = 0; i < 20; ++i) {
                    str = str + "(" + i + ", 'First', 'J 604'," + i + "),";
                }
                str = str.substring(0, str.length() - 1);
                stmt.executeUpdate(str);
                SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)stmt.executeUpdate("delete from TESTTABLE where ID = 1"));
                this.blockForValidation();
                this.startClientVMs(1, -1, "SG");
                this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
                ok = false;
            }
            catch (Throwable throwable) {
                block13: {
                    ok = false;
                    this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
                    if (tablesCreated) {
                        this.clientSQLExecute(1, "drop table TESTTABLE");
                    }
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                if (server != null) {
                    server.shutdown();
                }
                throw throwable;
            }
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            if (tablesCreated) {
                this.clientSQLExecute(1, "drop table TESTTABLE");
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block12;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemberSetForBulkOpDistributionForPRAndReplicatedTables() throws Exception {
        this.startServerVMs(2, -1, "SG0");
        this.startServerVMs(1, -1, "SG1");
        this.startClientVMs(1, 0, null);
        NetworkServerControl nsc = null;
        boolean tablesCreated = false;
        try {
            String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            nsc = this.startNetworkServer();
            String tableDef = " create table TESTTABLE1 ( ID int not null primary key , test_bigint BIGINT,  test_boolean smallint )";
            this.clientSQLExecute(1, tableDef + "  AsyncEventListener (WBCL2) ");
            tablesCreated = true;
            Runnable runnable = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG1", "WBCL2", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
            runnable.run();
            Runnable startWBCL = SerialDBSynchronizerPart1DUnit.startAsyncEventListener("WBCL2");
            startWBCL.run();
            String schemaName = SerialDBSynchronizerPart1DUnit.getCurrentDefaultSchemaName();
            this.validate(schemaName + ".TESTTABLE1");
            tableDef = " create table TESTTABLE2 ( ID int not null primary key , test_bigint BIGINT,  test_boolean smallint )";
            this.clientSQLExecute(1, tableDef + "  replicate AsyncEventListener (WBCL2) ");
            this.validate(schemaName + ".TESTTABLE2");
        }
        finally {
            block11: {
                if (nsc != null) {
                    nsc.shutdown();
                }
                if (tablesCreated) {
                    this.clientSQLExecute(1, "drop table if exists TESTTABLE1");
                    this.clientSQLExecute(1, "drop table if exists TESTTABLE2");
                }
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block11;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
        }
    }

    private void validate(final String tablename) throws Exception {
        Region rgn = Misc.getRegionForTable((String)tablename, (boolean)true);
        Set synchronizerMmbrs = ((CacheDistributionAdvisee)rgn).getCacheDistributionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
        SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)synchronizerMmbrs.size());
        InternalDistributedMember dm = (InternalDistributedMember)synchronizerMmbrs.iterator().next();
        VM vm = (VM)this.serverVMs.get(2);
        Iterator itr = this.members.entrySet().iterator();
        boolean foundMember = false;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            VM temp = (VM)entry.getValue();
            if (temp == null || !temp.equals(vm)) continue;
            SerialDBSynchronizerPart1DUnit.assertEquals((Object)dm, entry.getKey());
            foundMember = true;
        }
        SerialDBSynchronizerPart1DUnit.assertTrue((boolean)foundMember);
        SerializableRunnable sr = new SerializableRunnable(){

            public void run() {
                Region rgn = Misc.getRegionForTable((String)tablename, (boolean)true);
                Set synchronizerMmbrs = ((CacheDistributionAdvisee)rgn).getCacheDistributionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
                TestCase.assertEquals((int)0, (int)synchronizerMmbrs.size());
            }
        };
        this.serverExecute(3, (Runnable)sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disabled_testGfxdMemberAdviseAPIForPartitionedTable_1() throws Exception {
        this.startNetworkServer();
        this.createDerbyValidationArtefacts();
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, -1, "SG1", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, -1, "SG2", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, -1, "SG3", null);
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, -1, "SG4", null);
        this.startClientVMs(1, -1, "SG0");
        this.joinVMs(true, async1, async2, async3, async4);
        Runnable gtwayHubCreator = SerialDBSynchronizerPart1DUnit.getHubCreatorExecutor("SG1, SG0", "MyHub", null, 128, null, null, null);
        gtwayHubCreator.run();
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Runnable asynchDBSynch = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG3, SG4, SG0", "MyAsyncDBSynchro", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl + ",app,app", true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
        asynchDBSynch.run();
        try {
            int vmIndex;
            this.serverSQLExecute(1, "create table TESTTABLE1 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) gatewaysender (MyHub) ");
            this.serverSQLExecute(1, "create table TESTTABLE2 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (MYASYNCEVENTLISTENER) ");
            this.serverSQLExecute(1, "create table TESTTABLE3 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (MyAsyncDBSynchro) ");
            String schemaName = SerialDBSynchronizerPart1DUnit.getCurrentDefaultSchemaName();
            PartitionedRegion pr1 = (PartitionedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE1", null), (boolean)true, (boolean)false);
            Set membs = pr1.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)membs.size());
            membs = pr1.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)0, (int)membs.size());
            PartitionedRegion pr2 = (PartitionedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE2", null), (boolean)true, (boolean)false);
            membs = pr2.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)0, (int)membs.size());
            membs = pr2.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)0, (int)membs.size());
            Runnable asyncEventConfig = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG2, SG0", "MYASYNCEVENTLISTENER", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "init-param-str", false);
            asyncEventConfig.run();
            membs = pr2.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)0, (int)membs.size());
            membs = pr2.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)membs.size());
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                int vmIndex2 = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex2 == 1 ? 1 : 0) != 0);
            }
            PartitionedRegion pr3 = (PartitionedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE3", null), (boolean)true, (boolean)false);
            membs = pr3.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
            membs = pr3.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
            this.clientSQLExecute(1, "drop table TESTTABLE2");
            this.clientSQLExecute(1, "drop table TESTTABLE3");
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            Statement derbyStmt = derbyConn.createStatement();
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.clientSQLExecute(1, "drop table TESTTABLE1");
        this.clientSQLExecute(1, "drop table TESTTABLE2");
        this.clientSQLExecute(1, "drop table TESTTABLE3");
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
        this.addExpectedDerbyException(ShutdownException.class.getName());
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disable_testGfxdMemberAdviseAPIForPartitionedTable_2() throws Exception {
        this.startNetworkServer();
        this.createDerbyValidationArtefacts();
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, -1, "SG1", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, -1, "SG2", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, -1, "SG3", null);
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, -1, "SG4", null);
        this.startClientVMs(1, -1, "SG0");
        this.joinVMs(true, async1, async2, async3, async4);
        Runnable gtwayHubCreator = SerialDBSynchronizerPart1DUnit.getHubCreatorExecutor("SG1, SG0", "MYSENDER", null, 128, null, null, null);
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Runnable asynchDBSynch = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG3, SG4, SG0", "MYASYNCDBSYNCHRO", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
        try {
            int vmIndex;
            this.serverSQLExecute(1, "create table TESTTABLE1 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) gatewaysender (MYSENDER) ");
            this.serverSQLExecute(1, "create table TESTTABLE2 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (MYASYNCEVENTLISTENER) ");
            this.serverSQLExecute(1, "create table TESTTABLE3 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (MYASYNCDBSYNCHRO) ");
            asynchDBSynch.run();
            gtwayHubCreator.run();
            String schemaName = SerialDBSynchronizerPart1DUnit.getCurrentDefaultSchemaName();
            PartitionedRegion pr1 = (PartitionedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE1", null), (boolean)true, (boolean)false);
            Set membs = pr1.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)membs.size());
            membs = pr1.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            PartitionedRegion pr2 = (PartitionedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE2", null), (boolean)true, (boolean)false);
            membs = pr2.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            membs = pr2.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            Runnable asyncEventConfig = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG2, SG0", "MYASYNCEVENTLISTENER", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "init-param-str", false);
            asyncEventConfig.run();
            membs = pr2.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            membs = pr2.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)1);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                int vmIndex2 = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex2 == 1 ? 1 : 0) != 0);
            }
            PartitionedRegion pr3 = (PartitionedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE3", null), (boolean)true, (boolean)false);
            membs = pr3.getRegionAdvisor().adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
            membs = pr3.getRegionAdvisor().adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
            this.clientSQLExecute(1, "drop table TESTTABLE2");
            this.clientSQLExecute(1, "drop table TESTTABLE3");
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            Statement derbyStmt = derbyConn.createStatement();
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.clientSQLExecute(1, "drop table TESTTABLE1");
        this.clientSQLExecute(1, "drop table TESTTABLE2");
        this.clientSQLExecute(1, "drop table TESTTABLE3");
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
        this.addExpectedDerbyException(ShutdownException.class.getName());
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disable_testGfxdMemberAdviseAPIForReplicatedTable_1_Bug42758() throws Exception {
        this.startNetworkServer();
        this.createDerbyValidationArtefacts();
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, -1, "SG1", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, -1, "SG2", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, -1, "SG3", null);
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, -1, "SG4", null);
        this.startClientVMs(1, -1, "SG0");
        this.joinVMs(true, async1, async2, async3, async4);
        Runnable gtwayHubCreator = SerialDBSynchronizerPart1DUnit.getHubCreatorExecutor("SG1, SG0", "MYSENDER", null, 128, null, null, null);
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Runnable asynchDBSynch = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG3, SG4, SG0", "MYASYNCDBSYNCRO", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl + ",app", true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
        try {
            int vmIndex;
            this.serverSQLExecute(1, "create table TESTTABLE1 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) replicate gatewaysender (MYSENDER) ");
            this.serverSQLExecute(1, "create table TESTTABLE2 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) replicate AsyncEventListener (MYASYNCEVENTLISTENER) ");
            this.serverSQLExecute(1, "create table TESTTABLE3 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) replicate  AsyncEventListener (MYASYNCDBSYNCRO) ");
            gtwayHubCreator.run();
            asynchDBSynch.run();
            String schemaName = SerialDBSynchronizerPart1DUnit.getCurrentDefaultSchemaName();
            DistributedRegion dr1 = (DistributedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE1", null), (boolean)true, (boolean)false);
            CacheDistributionAdvisor advisor = dr1.getCacheDistributionAdvisor();
            Set membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)membs.size());
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            DistributedRegion dr2 = (DistributedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE2", null), (boolean)true, (boolean)false);
            advisor = dr2.getCacheDistributionAdvisor();
            membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            Runnable asyncEventConfig = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG2, SG0", "MYASYNCEVENTLISTENER", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "init-param-str", false);
            asyncEventConfig.run();
            membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)0, (int)membs.size());
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)membs.size());
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                int vmIndex2 = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex2 == 1 ? 1 : 0) != 0);
            }
            DistributedRegion dr3 = (DistributedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE3", null), (boolean)true, (boolean)false);
            advisor = dr3.getCacheDistributionAdvisor();
            membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
            this.clientSQLExecute(1, "drop table TESTTABLE2");
            this.clientSQLExecute(1, "drop table TESTTABLE3");
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            Statement derbyStmt = derbyConn.createStatement();
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.clientSQLExecute(1, "drop table TESTTABLE1");
        this.clientSQLExecute(1, "drop table TESTTABLE2");
        this.clientSQLExecute(1, "drop table TESTTABLE3");
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
        this.addExpectedDerbyException(ShutdownException.class.getName());
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disable_testGfxdMemberAdviseAPIForReplicatedTable_2() throws Exception {
        this.startNetworkServer();
        this.createDerbyValidationArtefacts();
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, -1, "SG1", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, -1, "SG2", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, -1, "SG3", null);
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, -1, "SG4", null);
        this.startClientVMs(1, -1, "SG0");
        this.joinVMs(true, async1, async2, async3, async4);
        Runnable gtwayHubCreator = SerialDBSynchronizerPart1DUnit.getHubCreatorExecutor("SG1, SG0", "MYSENDER", null, 128, null, null, null);
        gtwayHubCreator.run();
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + this.netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Runnable asynchDBSynch = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG3, SG4, SG0", "MYASYNCDBSYNCHRO", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl + ",app,app", true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
        asynchDBSynch.run();
        try {
            int vmIndex;
            this.serverSQLExecute(1, "create table TESTTABLE1 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) replicate gatewaysender (MYSENDER) ");
            this.serverSQLExecute(1, "create table TESTTABLE2 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) replicate AsyncEventListener (MYASYNCEVENTLISTENER) ");
            this.serverSQLExecute(1, "create table TESTTABLE3 (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) replicate  AsyncEventListener (MYASYNCDBSYNCHRO) ");
            String schemaName = SerialDBSynchronizerPart1DUnit.getCurrentDefaultSchemaName();
            DistributedRegion dr1 = (DistributedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE1", null), (boolean)true, (boolean)false);
            CacheDistributionAdvisor advisor = dr1.getDistributionAdvisor();
            Set membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)membs.size());
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            DistributedRegion dr2 = (DistributedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE2", null), (boolean)true, (boolean)false);
            advisor = dr2.getCacheDistributionAdvisor();
            membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)0);
            Runnable asyncEventConfig = SerialDBSynchronizerPart1DUnit.getExecutorForWBCLConfiguration("SG2, SG0", "MYASYNCEVENTLISTENER", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "init-param-str", false);
            asyncEventConfig.run();
            membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)0, (int)membs.size());
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)membs.size());
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                int vmIndex2 = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex2 == 1 ? 1 : 0) != 0);
            }
            DistributedRegion dr3 = (DistributedRegion)Misc.getRegion((String)Misc.getRegionPath((String)schemaName, (String)"TESTTABLE3", null), (boolean)true, (boolean)false);
            advisor = dr3.getCacheDistributionAdvisor();
            membs = advisor.adviseSerialAsyncEventQueueOrGatewaySender();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
            membs = advisor.adviseAsyncEventQueue();
            SerialDBSynchronizerPart1DUnit.assertEquals((int)membs.size(), (int)2);
            for (Object mem : membs) {
                VM vm = (VM)this.members.get(mem);
                vmIndex = this.serverVMs.indexOf(vm);
                SerialDBSynchronizerPart1DUnit.assertTrue((vmIndex == 2 || vmIndex == 3 ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
            this.clientSQLExecute(1, "drop table TESTTABLE2");
            this.clientSQLExecute(1, "drop table TESTTABLE3");
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            Statement derbyStmt = derbyConn.createStatement();
            this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.clientSQLExecute(1, "drop table TESTTABLE1");
        this.clientSQLExecute(1, "drop table TESTTABLE2");
        this.clientSQLExecute(1, "drop table TESTTABLE3");
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        this.cleanDerbyArtifacts(derbyStmt, new String[]{"validateTestEnd"}, new String[]{"test_ok"}, new String[]{"TESTTABLE"}, derbyConn);
        this.addExpectedDerbyException(ShutdownException.class.getName());
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testOracle_UseCase1() throws Throwable {
        this.startVMs(1, 2, 0, "CHANNELDATAGRP", null);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE gemfire.SECL_BO_DATA_STATUS_HIST (       BO_TXN_ID VARCHAR (36) NOT NULL ,       CLIENT_ID VARCHAR (100) ,       CLIENT_NAME VARCHAR (100) ,       CLIENT_ACCOUNT VARCHAR (100) ,       COMPANY_ID VARCHAR (100) ,       CLIENT_REF_NO VARCHAR (100) ,       VALUE_DATE TIMESTAMP ,       AMOUNT DECIMAL (16,2) ,       CURRENCY VARCHAR (20) ,       ORIG_BANK_ID VARCHAR (100) ,       BACKOFFICE_CODE VARCHAR (100) NOT NULL ,       BENE_ACCNT_NO VARCHAR (100) ,       BENE_NAME VARCHAR (100) ,       BENE_ADDR VARCHAR (256) ,       BENE_BANK_ID VARCHAR (100) ,       BENE_BANK_NAME VARCHAR (100) ,       BENE_BANK_ADDR VARCHAR (256) ,       INSTR_CREATED_TIME TIMESTAMP ,       INSTR_CREATED_BY VARCHAR (100) ,       DATA_LIFE_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_STATUS SMALLINT WITH DEFAULT 0 ,       MATCH_DATE TIMESTAMP ,       MATCH_CATEG_ID INTEGER ,       MATCHING_TIME INTEGER WITH DEFAULT -1 ,       MANUAL_MATCH CHAR (1) WITH DEFAULT 'N' ,       MATCHING_REASON VARCHAR (128) ,       SCREENING_TIME INTEGER NOT NULL ,       IS_MANUAL CHAR (1) WITH DEFAULT 'N' ,       IS_RESENT CHAR (1) WITH DEFAULT 'N' ,       CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,       TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,       OFAC_MSG_ID VARCHAR (64) NOT NULL ,       HIT_STATUS SMALLINT ,       FILE_TYPE VARCHAR (36) WITH DEFAULT 'NA',       ACTUAL_VALUE_DATE TIMESTAMP ,       LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP )      PARTITION BY COLUMN (BO_TXN_ID)      REDUNDANCY 1        EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW      PERSISTENT ASYNCHRONOUS");
        String oraUser = "gemfire";
        String oraPasswd = "lu5Pheko";
        String oraUrl = "jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE)))";
        String transformation = "Blowfish/CBC/NOPADDING";
        int keySize = 64;
        String oraFile = "ora.props";
        String encryptedPassword = new GfxdSystemAdmin().encryptForExternal("encrypt-password", Arrays.asList("-locators=" + SerialDBSynchronizerPart1DUnit.getDUnitLocatorString(), "-transformation=Blowfish/CBC/NOPADDING", "-keysize=64"), "gemfire", "lu5Pheko");
        Properties oraProps = new Properties();
        oraProps.setProperty("user", "gemfire");
        oraProps.setProperty("Secret", encryptedPassword);
        oraProps.setProperty("URL", "jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE)))");
        oraProps.setProperty("driver", "oracle.jdbc.driver.OracleDriver");
        oraProps.setProperty("transformation", "Blowfish/CBC/NOPADDING");
        oraProps.setProperty("KeySize", Integer.toString(64));
        FileOutputStream out = new FileOutputStream("ora.props");
        oraProps.store(out, "Generated file -- do not change manually");
        out.flush();
        out.close();
        final Throwable[] failure = new Throwable[1];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                DistributedTestBase.ExpectedException expectedEx = DistributedTestBase.addExpectedException((String)"java.sql.SQLRecoverableException");
                for (int tries = 1; tries <= 5; ++tries) {
                    try {
                        Connection conn = TestUtil.getConnection();
                        Statement stmt = conn.createStatement();
                        stmt.execute("create asynceventlistener SECL_BO_DATA_STATUS_HIST_SYNC (listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'file=ora.props' ENABLEPERSISTENCE true MANUALSTART false ALERTTHRESHOLD 2000) SERVER GROUPS(CHANNELDATAGRP)");
                        failure[0] = null;
                        break;
                    }
                    catch (Throwable t) {
                        failure[0] = t;
                        continue;
                    }
                }
                expectedEx.remove();
            }
        });
        t.start();
        Connection oraConn = this.createOraConnection("jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE)))", "gemfire", "lu5Pheko");
        Statement oraStmt = oraConn.createStatement();
        t.join();
        if (failure[0] != null) {
            throw failure[0];
        }
        try {
            oraStmt.execute("CREATE TABLE gemfire.SECL_BO_DATA_STATUS_HIST(    BO_TXN_ID VARCHAR2(36) NOT NULL,    CLIENT_ID VARCHAR2(100),    CLIENT_NAME VARCHAR2(100),    CLIENT_ACCOUNT VARCHAR2(100),    COMPANY_ID VARCHAR2(100),    CLIENT_REF_NO VARCHAR2(100),    VALUE_DATE TIMESTAMP,    AMOUNT NUMBER(16,2),    CURRENCY VARCHAR2(20),    ORIG_BANK_ID VARCHAR2(100),    BACKOFFICE_CODE VARCHAR2(100) NOT NULL,    BENE_ACCNT_NO VARCHAR2(100),    BENE_NAME VARCHAR2(100),    BENE_ADDR VARCHAR2(256),    BENE_BANK_ID VARCHAR2(100),    BENE_BANK_NAME VARCHAR2(100),    BENE_BANK_ADDR VARCHAR2(256),    INSTR_CREATED_TIME TIMESTAMP,    INSTR_CREATED_BY VARCHAR2(100),    DATA_LIFE_STATUS NUMBER(5) DEFAULT 0,    MATCH_STATUS NUMBER(5) DEFAULT 0,    MATCH_DATE TIMESTAMP,    MATCH_CATEG_ID INTEGER,    MATCHING_TIME INTEGER DEFAULT -1,    MANUAL_MATCH CHAR(1) DEFAULT 'N',    MATCHING_REASON VARCHAR2(128),    SCREENING_TIME INTEGER NOT NULL,    IS_MANUAL CHAR(1) DEFAULT 'N',    IS_RESENT CHAR(1) DEFAULT 'N',    CHANNEL_NAME VARCHAR2(100) DEFAULT 'UNKNOWN',    TXN_TYPE VARCHAR2(30) DEFAULT 'UNKNOWN',    OFAC_MSG_ID VARCHAR2(64) NOT NULL,    HIT_STATUS NUMBER(5),    FILE_TYPE VARCHAR2(36) DEFAULT 'NA',    ACTUAL_VALUE_DATE TIMESTAMP,    LAST_UPDATE_TIME TIMESTAMP)");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        oraConn.setAutoCommit(false);
        String lockKey = "DBSP_LOCK";
        boolean locked = false;
        try {
            int numTries = 0;
            while (!locked) {
                oraStmt.execute("lock table gemfire.SECL_BO_DATA_STATUS_HIST in exclusive mode");
                ResultSet rs = oraStmt.executeQuery("select count(*) from gemfire.SECL_BO_DATA_STATUS_HIST where BO_TXN_ID='DBSP_LOCK'");
                rs.next();
                if (rs.getInt(1) == 0 || ++numTries > 100) {
                    oraStmt.execute("truncate table gemfire.SECL_BO_DATA_STATUS_HIST");
                    oraStmt.execute("INSERT INTO gemfire.SECL_BO_DATA_STATUS_HIST (BO_TXN_ID, BACKOFFICE_CODE, SCREENING_TIME, OFAC_MSG_ID) values ('DBSP_LOCK', 'NA', 0, 'NA')");
                    locked = true;
                } else {
                    Thread.sleep(5000L);
                }
                oraConn.commit();
            }
            stmt.execute("ALTER TABLE gemfire.SECL_BO_DATA_STATUS_HIST SET  asynceventlistener(SECL_BO_DATA_STATUS_HIST_SYNC)");
            conn.setTransactionIsolation(2);
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO   gemfire.SECL_BO_DATA_STATUS_HIST (      BO_TXN_ID,   CLIENT_ID,    CLIENT_NAME,  CLIENT_ACCOUNT,       COMPANY_ID,  CLIENT_REF_NO,    VALUE_DATE, AMOUNT,         CURRENCY,       ORIG_BANK_ID,   BACKOFFICE_CODE,     BENE_ACCNT_NO,  BENE_NAME,    BENE_ADDR,   BENE_BANK_ID,   BENE_BANK_NAME, BENE_BANK_ADDR, INSTR_CREATED_TIME,     INSTR_CREATED_BY,  DATA_LIFE_STATUS,       MATCH_STATUS,   MATCH_DATE, MATCH_CATEG_ID, MATCHING_TIME,  MANUAL_MATCH,   MATCHING_REASON,   SCREENING_TIME, IS_MANUAL,    IS_RESENT,      CHANNEL_NAME,   TXN_TYPE,   OFAC_MSG_ID, HIT_STATUS,   ACTUAL_VALUE_DATE, LAST_UPDATE_TIME) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)");
            for (int i = 1; i <= 200; ++i) {
                pstmt.setObject(1, "09824f04-26ef-49b0-95b2-955d3742" + String.format("%04d", i));
                pstmt.setObject(2, "party name");
                pstmt.setObject(3, null);
                pstmt.setObject(4, "12345678");
                pstmt.setObject(5, "1874563");
                pstmt.setObject(6, "PB130482");
                pstmt.setTimestamp(7, Timestamp.valueOf("2012-07-18 00:00:00.0"));
                pstmt.setObject(8, "158.26");
                pstmt.setObject(9, "CAD");
                pstmt.setObject(10, "CHASGB2LXXX");
                pstmt.setObject(11, "IPAY");
                pstmt.setObject(12, null);
                pstmt.setObject(13, null);
                pstmt.setObject(14, null);
                pstmt.setObject(15, null);
                pstmt.setObject(16, null);
                pstmt.setObject(17, null);
                pstmt.setObject(18, Timestamp.valueOf("2013-03-13 14:20:04.05"));
                pstmt.setObject(19, null);
                pstmt.setObject(20, 1);
                pstmt.setObject(21, 1);
                pstmt.setObject(22, Timestamp.valueOf("2013-03-13 14:20:04.28"));
                pstmt.setObject(23, 2);
                pstmt.setObject(24, 0);
                pstmt.setObject(25, "N");
                pstmt.setObject(26, null);
                pstmt.setObject(27, -1);
                pstmt.setObject(28, "N");
                pstmt.setObject(29, "N");
                pstmt.setObject(30, "PYS");
                pstmt.setObject(31, "UNKNOWN");
                pstmt.setObject(32, "MITHUN0621                                                      ");
                pstmt.setObject(33, null);
                pstmt.setObject(34, Timestamp.valueOf("2010-03-19 00:00:00.0"));
                SerialDBSynchronizerPart1DUnit.assertEquals((int)1, (int)pstmt.executeUpdate());
                conn.commit();
            }
            stmt.execute("call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SECL_BO_DATA_STATUS_HIST_SYNC', 1, 0)");
            conn.commit();
            ResultSet rs = oraStmt.executeQuery("select * from gemfire.SECL_BO_DATA_STATUS_HIST where BO_TXN_ID <> 'DBSP_LOCK' order by BO_TXN_ID");
            for (int i = 1; i <= 200; ++i) {
                SerialDBSynchronizerPart1DUnit.assertTrue((boolean)rs.next());
                SerialDBSynchronizerPart1DUnit.assertEquals((String)("09824f04-26ef-49b0-95b2-955d3742" + String.format("%04d", i)), (String)rs.getString(1));
            }
            SerialDBSynchronizerPart1DUnit.assertFalse((boolean)rs.next());
            rs.close();
        }
        finally {
            try {
                oraConn.commit();
            }
            catch (SQLException numTries) {}
            if (locked) {
                while (true) {
                    try {
                        oraStmt.execute("delete from gemfire.SECL_BO_DATA_STATUS_HIST where BO_TXN_ID='DBSP_LOCK'");
                    }
                    catch (SQLException sqle) {
                        try {
                            oraStmt.close();
                        }
                        catch (SQLException sQLException) {}
                        try {
                            oraConn.commit();
                        }
                        catch (SQLException sQLException) {}
                        try {
                            oraConn.close();
                        }
                        catch (SQLException sQLException) {}
                        oraConn = this.createOraConnection("jdbc:oracle:thin:@(DESCRIPTION=(CONNECT_TIMEOUT=60)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle.gemstone.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=XE)))", "gemfire", "lu5Pheko");
                        oraStmt = oraConn.createStatement();
                        continue;
                    }
                    break;
                }
            }
            try {
                oraStmt.execute("truncate table gemfire.SECL_BO_DATA_STATUS_HIST");
                oraConn.commit();
            }
            catch (SQLException sQLException) {}
            try {
                oraConn.close();
            }
            catch (SQLException sQLException) {}
            new File("ora.props").delete();
        }
        conn.commit();
        stmt.close();
        conn.close();
    }
}

