/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dbsync;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.dbsync.CallbackObserverAdapter;
import com.pivotal.gemfirexd.dbsync.CallbackObserverHolder;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerBasicDUnit;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.JDBC;

public class SerialDBSynchronizerDUnit
extends DBSynchronizerBasicDUnit {
    public SerialDBSynchronizerDUnit(String name) {
        super(name);
    }

    @Override
    protected Runnable createAsyncQueueConfigurationForBasicTests(String derbyUrl) {
        return SerialDBSynchronizerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyUrl, false);
    }

    public void _testPrimaryDBSynchronizerOnAccessorNodeWithReplicateTable() throws Exception {
    }

    public void DISABLED_BUG_50101_testBug48674() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        String derbyDbUrl = SerialDBSynchronizerDUnit.getDerbyURL(this.netPort);
        server = this.startNetworkServer();
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        derbyConn = DriverManager.getConnection(derbyDbUrl);
        derbyStmt = derbyConn.createStatement();
        String schemaName = SerialDBSynchronizerDUnit.getCurrentDefaultSchemaName();
        ResultSet rs = derbyConn.getMetaData().getTables(null, schemaName, "TESTTABLE", null);
        boolean foundTesttable = false;
        while (rs.next()) {
            foundTesttable = rs.getString(3).equalsIgnoreCase("TESTTABLE") && rs.getString(2).equalsIgnoreCase(schemaName);
            if (!foundTesttable) continue;
            derbyStmt.executeUpdate("delete from TESTTABLE");
            break;
        }
        if (!foundTesttable) {
            derbyStmt.execute("create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) ");
        }
        this.startVMs(0, 4, 0, "SG1", null);
        this.addExpectedException(new int[0], new int[]{1, 2, 3, 4}, new Object[]{"org.apache.derby.client.am.SqlException", "java.sql.SQLIntegrityConstraintViolationException", "java.sql.SQLTransactionRollbackException", "java.sql.SQLSyntaxErrorException"});
        Runnable createWBCLConfig = SerialDBSynchronizerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, false, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
        this.serverExecute(1, createWBCLConfig);
        this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int, ID2 int)PARTITION BY PRIMARY KEY AsyncEventListener (WBCL1) server groups (SG1)");
        this.serverSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1, 1)");
        this.serverSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2, 2)");
        this.serverSQLExecute(1, "Insert into TESTTABLE values(3,'desc3','Add3',3, 3)");
        this.serverSQLExecute(1, "Insert into TESTTABLE values(4,'desc4','Add4',4, 4)");
        this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 0, -1)");
        this.serverExecute(1, SerialDBSynchronizerDUnit.stopAsyncEventListener("WBCL1"));
        this.serverSQLExecute(1, "drop table TESTTABLE");
        this.serverExecute(1, SerialDBSynchronizerDUnit.dropAsyncEventListener("WBCL1"));
        String systemDir = this.getSysDiskDir();
        try {
            derbyStmt.execute("drop table TESTTABLE");
            derbyStmt.close();
            derbyConn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String xmlLogLocation = systemDir.substring(0, systemDir.lastIndexOf(File.separator));
        String logRoot = xmlLogLocation + File.separator + "dbsync_failed_dmls.xml";
        String logEntries = xmlLogLocation + File.separator + "dbsync_failed_dmls_entries.xml";
        File logRootFile = new File(logRoot);
        this.getLogWriter().info((Object)("LOG ROOT FILE:" + logRoot));
        SerialDBSynchronizerDUnit.assertTrue((boolean)logRootFile.exists());
        this.getLogWriter().info((Object)("LOG ENTRIES FILE:" + logEntries));
        File logEntriesFile = new File(logEntries);
        SerialDBSynchronizerDUnit.assertTrue((boolean)logEntriesFile.exists());
        this.stopAllVMs();
    }

    public void DISABLED_BUG_50101_testDBSyncErrorXMLGeneration() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        String derbyDbUrl = SerialDBSynchronizerDUnit.getDerbyURL(this.netPort);
        server = this.startNetworkServer();
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        derbyConn = DriverManager.getConnection(derbyDbUrl);
        derbyStmt = derbyConn.createStatement();
        String schemaName = SerialDBSynchronizerDUnit.getCurrentDefaultSchemaName();
        ResultSet rs = derbyConn.getMetaData().getTables(null, schemaName, "TESTTABLE", null);
        boolean foundTesttable = false;
        while (rs.next()) {
            foundTesttable = rs.getString(3).equalsIgnoreCase("TESTTABLE") && rs.getString(2).equalsIgnoreCase(schemaName);
            if (!foundTesttable) continue;
            derbyStmt.executeUpdate("delete from TESTTABLE");
            break;
        }
        if (!foundTesttable) {
            derbyStmt.execute("create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int,constraint unique_id1 UNIQUE(ID1)) ");
        }
        this.startVMs(0, 4, 0, "SG1", null);
        this.addExpectedException(new int[0], new int[]{1, 2, 3, 4}, new Object[]{"org.apache.derby.client.am.SqlException", "java.sql.SQLIntegrityConstraintViolationException", "java.sql.SQLTransactionRollbackException"});
        Runnable createWBCLConfig = SerialDBSynchronizerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
        this.serverExecute(1, createWBCLConfig);
        this.serverSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int) AsyncEventListener (WBCL1) server groups (SG1)");
        Runnable startWBCL = SerialDBSynchronizerDUnit.startAsyncEventListener("WBCL1");
        this.serverExecute(1, startWBCL);
        this.serverSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
        this.serverSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',1)");
        this.serverSQLExecute(1, "Insert into TESTTABLE values(3,'desc3','Add3',2)");
        this.serverSQLExecute(1, "Insert into TESTTABLE values(4,'desc4','Add4',2)");
        this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 0, -1)");
        this.serverExecute(1, SerialDBSynchronizerDUnit.stopAsyncEventListener("WBCL1"));
        this.serverSQLExecute(1, "drop table TESTTABLE");
        this.serverExecute(1, SerialDBSynchronizerDUnit.dropAsyncEventListener("WBCL1"));
        String systemDir = this.getSysDiskDir();
        try {
            derbyStmt.execute("drop table TESTTABLE");
            derbyStmt.close();
            derbyConn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String xmlLogLocation = systemDir.substring(0, systemDir.lastIndexOf(File.separator));
        String logRoot = xmlLogLocation + File.separator + "dbsync_failed_dmls.xml";
        String logEntries = xmlLogLocation + File.separator + "dbsync_failed_dmls_entries.xml";
        File logRootFile = new File(logRoot);
        this.getLogWriter().info((Object)("LOG ROOT FILE:" + logRoot));
        SerialDBSynchronizerDUnit.assertTrue((boolean)logRootFile.exists());
        this.getLogWriter().info((Object)("LOG ENTRIES FILE:" + logEntries));
        File logEntriesFile = new File(logEntries);
        SerialDBSynchronizerDUnit.assertTrue((boolean)logEntriesFile.exists());
        this.stopAllVMs();
    }

    protected CallbackObserverAdapter getCallbackObserver() {
        CallbackObserverAdapter observerAdapter = new CallbackObserverAdapter(){
            private int numTimesStartCalled = 0;
            private int numTimesCloseCalled = 0;

            @Override
            public void asyncEventListenerStart() {
                SerialDBSynchronizerDUnit.this.getLogWriter().info((Object)"CallbackObserver::asyncEventListenerStart");
                ++this.numTimesStartCalled;
                TestCase.assertEquals((int)1, (int)this.numTimesStartCalled);
            }

            @Override
            public void asyncEventListenerClose() {
                SerialDBSynchronizerDUnit.this.getLogWriter().info((Object)"CallbackObserver::asyncEventListenerClose");
                ++this.numTimesCloseCalled;
                TestCase.assertTrue((this.numTimesCloseCalled >= 1 ? 1 : 0) != 0);
            }
        };
        return observerAdapter;
    }

    public void testBug49975() throws Exception {
        this.startVMs(0, 4, 0, "SG1", null);
        Runnable createWBCLConfig = SerialDBSynchronizerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestStartStopGatewayEventListener", "org.apache.derby.jdbc.ClientDriver", "", true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver,", false);
        CallbackObserverAdapter observerAdapter1 = this.getCallbackObserver();
        Object[] args = new Object[]{observerAdapter1};
        SerialDBSynchronizerDUnit.invokeInEveryVM(CallbackObserverHolder.class, (String)new String("setInstance"), (Object[])args);
        this.serverExecute(1, createWBCLConfig);
        Runnable startWBCL = SerialDBSynchronizerDUnit.startAsyncEventListener("WBCL1");
        this.serverExecute(1, startWBCL);
        Runnable stopWBCL = SerialDBSynchronizerDUnit.stopAsyncEventListener("WBCL1");
        this.serverExecute(1, stopWBCL);
        this.serverExecute(1, SerialDBSynchronizerDUnit.dropAsyncEventListener("WBCL1"));
        this.stopAllVMs();
        this.restartVMNums(new int[]{-1, -2, -3, -4}, 0, "SG1", null);
        Runnable createWBCLConfig2 = SerialDBSynchronizerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestStartStopGatewayEventListener", "org.apache.derby.jdbc.ClientDriver", "", false, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver,", false);
        CallbackObserverAdapter observerAdapter2 = this.getCallbackObserver();
        Object[] args2 = new Object[]{observerAdapter1};
        SerialDBSynchronizerDUnit.invokeInEveryVM(CallbackObserverHolder.class, (String)new String("setInstance"), (Object[])args2);
        this.serverExecute(1, createWBCLConfig);
        this.serverExecute(1, stopWBCL);
        this.serverExecute(1, SerialDBSynchronizerDUnit.dropAsyncEventListener("WBCL1"));
        this.stopAllVMs();
    }

    public void testBug51353() throws Exception {
        this.startVMs(0, 4, 0, "SG1", null);
        Runnable createListener = SerialDBSynchronizerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestAsyncEventListener", "", "", false, 1, null, Boolean.FALSE, null, null, null, 100000, "", false);
        this.serverExecute(1, createListener);
        Runnable stopListener = SerialDBSynchronizerDUnit.stopAsyncEventListener("WBCL1");
        this.serverExecute(1, stopListener);
        Runnable startListener = SerialDBSynchronizerDUnit.startAsyncEventListener("WBCL1");
        this.serverExecute(1, startListener);
        this.stopAllVMs();
        this.restartVMNums(new int[]{-1, -2, -3, -4}, 0, "SG1", null);
        this.serverExecute(1, SerialDBSynchronizerDUnit.dropAsyncEventListener("WBCL1"));
        this.stopAllVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDBSynchronizerWithTruncateTable_Replicate() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = SerialDBSynchronizerDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) REPLICATE AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = SerialDBSynchronizerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyDbUrl, false);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = SerialDBSynchronizerDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(3,'desc3','Add3',3)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(4,'desc4','Add4',4)");
            this.clientSQLExecute(1, "truncate table TESTTABLE");
            Connection conn = TestUtil.jdbcConn;
            Statement stmt = conn.createStatement();
            ResultSet gfxdRs = stmt.executeQuery("select count(*) from TESTTABLE");
            JDBC.assertSingleValueResultSet(gfxdRs, "0");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            ResultSet derbyRS = derbyStmt.executeQuery("select count(*) from TESTTABLE");
            JDBC.assertSingleValueResultSet(derbyRS, "4");
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }
}

