/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dbsync;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdGatewayEventListener;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialAsyncEventListenerDUnit
extends DBSynchronizerTestBase {
    public SerialAsyncEventListenerDUnit(String name) {
        super(name);
    }

    public void testBug50091() throws Exception {
        this.startVMs(1, 2, -1, "SG1", null);
        this.clientSQLExecute(1, "create table app.raw_sensor(id bigint, timestamp bigint, value float(23), property smallint, plug_id integer, household_id integer, house_id integer, weekday smallint, time_slice smallint ) partition by column (house_id) ");
        this.clientSQLExecute(1, "create index app.raw_sensor_idx on app.raw_sensor (weekday, time_slice, plug_id)");
        this.clientSQLExecute(1, "create table app.load_averages (house_id integer not null, household_id integer, plug_id integer not null, weekday smallint not null, time_slice smallint not null, total_load float(23), event_count integer) partition by column (house_id) colocate with (app.raw_sensor)");
        this.clientSQLExecute(1, "alter table app.load_averages add constraint LOAD_AVERAGES_PK PRIMARY KEY (house_id, plug_id, weekday, time_slice)");
        this.clientSQLExecute(1, "create index app.load_averages_idx on app.load_averages (weekday, time_slice, plug_id)");
        Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG1", "AggListener", "com.pivotal.gemfirexd.dbsync.SerialAsyncEventListenerDUnit$AggregationListener", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:newDB;create=true,app,app", true, 1, null, Boolean.TRUE, null, null, null, 100000, null, false);
        runnable.run();
        this.clientSQLExecute(1, "alter table app.raw_sensor set asynceventlistener (AggListener)");
        this.clientSQLExecute(1, "call sys.start_async_event_listener('AggListener')");
        this.clientSQLExecute(1, "insert into app.raw_sensor values(1, null, 1.1, 1, 1, 1, 1, 1, 1)");
        this.clientSQLExecute(1, "insert into app.raw_sensor values(1, null, 1.1, 1, 1, 1, 1, 1, 1)");
        this.clientSQLExecute(1, "insert into app.raw_sensor values(1, null, 1.1, 1, 1, 1, 1, 1, 1)");
        this.clientSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('AGGLISTENER', 'true', 0)");
        this.clientSQLExecute(1, "drop table if exists app.load_averages");
        Connection connection = TestUtil.getConnection();
        ResultSet metadataRs = connection.getMetaData().getTables(null, "APP", "LOAD_AVERAGES", null);
        boolean foundTable = false;
        while (metadataRs.next()) {
            foundTable = metadataRs.getString(3).equalsIgnoreCase("LOAD_AVERAGES") && metadataRs.getString(2).equalsIgnoreCase("APP");
            SerialAsyncEventListenerDUnit.assertFalse((boolean)foundTable);
        }
        metadataRs.close();
        connection.close();
    }

    public void testAsyncEventListenerConfiguration() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, -1, "SG1");
        this.startServerVMs(2, -1, "SG2");
        Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:newDB;create=true,app,app", true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true", false);
        runnable.run();
        SerializableRunnable listenerNotAttached = DBSynchronizerTestBase.getExecutorToCheckListenerNotAttached("WBCL1");
        SerializableRunnable listenerAttached = DBSynchronizerTestBase.getExecutorToCheckListenerAttached("WBCL1");
        this.clientExecute(1, (Runnable)listenerNotAttached);
        this.serverExecute(3, (Runnable)listenerNotAttached);
        this.serverExecute(4, (Runnable)listenerNotAttached);
        this.serverExecute(1, (Runnable)listenerAttached);
        this.serverExecute(2, (Runnable)listenerAttached);
        Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
        this.clientExecute(1, startWBCL);
        this.checkHubRunningAndIsPrimaryVerifier("WBCL1");
        Runnable wbclConfigVerifier = this.getExecutorForWBCLConfigurationVerification("WBCL1", 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true,app,app");
        this.serverExecute(1, wbclConfigVerifier);
        this.serverExecute(2, wbclConfigVerifier);
    }

    public void testCreateAsyncEventListenerDDLReplay() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, -1, "SG1");
        Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:newDB;create=true", true, 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true", false);
        runnable.run();
        SerializableRunnable listenerNotAttached = SerialAsyncEventListenerDUnit.getExecutorToCheckListenerNotAttached("WBCL1");
        SerialAsyncEventListenerDUnit.getExecutorToCheckListenerAttached("WBCL1");
        this.clientExecute(1, (Runnable)listenerNotAttached);
        Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
        this.clientExecute(1, startWBCL);
        this.startServerVMs(2, -1, "SG2");
        Callable<?> hubRunningAndIsPrimaryVerifier = SerialAsyncEventListenerDUnit.getExecutorToCheckForHubRunningAndIsPrimary("WBCL1", true);
        boolean[] isHubRunningAndPrimary1 = (boolean[])this.serverExecute(1, hubRunningAndIsPrimaryVerifier);
        boolean[] isHubRunningAndPrimary2 = (boolean[])this.serverExecute(2, hubRunningAndIsPrimaryVerifier);
        SerialAsyncEventListenerDUnit.assertTrue((boolean)isHubRunningAndPrimary2[0]);
        SerialAsyncEventListenerDUnit.assertTrue((boolean)isHubRunningAndPrimary1[0]);
        SerialAsyncEventListenerDUnit.assertTrue((isHubRunningAndPrimary1[1] || isHubRunningAndPrimary2[1] ? 1 : 0) != 0);
        SerialAsyncEventListenerDUnit.assertFalse((isHubRunningAndPrimary1[1] && isHubRunningAndPrimary2[1] ? 1 : 0) != 0);
        Runnable wbclConfigVerifier = this.getExecutorForWBCLConfigurationVerification("WBCL1", 1, null, Boolean.TRUE, null, null, null, 100000, "org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true");
        this.serverExecute(1, wbclConfigVerifier);
        this.serverExecute(2, wbclConfigVerifier);
        this.serverExecute(3, (Runnable)listenerNotAttached);
        this.serverExecute(4, (Runnable)listenerNotAttached);
    }

    public void testAsyncEventListenerStopPropagationAndReplay() throws Exception {
        this.startVMs(1, 2, -1, "SG1", null);
        Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:newDB;create=true,app,app", true, 1, null, Boolean.TRUE, null, null, null, 100000, null, false);
        runnable.run();
        SerializableRunnable listenerNotAttached = SerialAsyncEventListenerDUnit.getExecutorToCheckListenerNotAttached("WBCL1");
        SerializableRunnable listenerAttached = SerialAsyncEventListenerDUnit.getExecutorToCheckListenerAttached("WBCL1");
        this.clientExecute(1, (Runnable)listenerNotAttached);
        this.serverExecute(1, (Runnable)listenerAttached);
        this.serverExecute(2, (Runnable)listenerAttached);
        Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
        this.clientExecute(1, startWBCL);
        this.checkHubRunningAndIsPrimaryVerifier("WBCL1");
        Runnable stopWBCL = SerialAsyncEventListenerDUnit.stopAsyncEventListener("WBCL1");
        this.clientExecute(1, stopWBCL);
        Callable<?> hubStoppedVerifier = SerialAsyncEventListenerDUnit.getExecutorToCheckForHubRunningAndIsPrimary("WBCL1", false);
        this.serverExecute(1, hubStoppedVerifier);
        this.serverExecute(2, hubStoppedVerifier);
        this.startServerVMs(1, -1, "SG1");
        this.startServerVMs(1, -1, "SG2");
        this.serverExecute(3, (Runnable)listenerAttached);
        this.serverExecute(3, hubStoppedVerifier);
        this.serverExecute(4, (Runnable)listenerNotAttached);
    }

    public void testAsyncEventListenerRemovePropagationAndReplay() throws Exception {
        this.startVMs(1, 2, -1, "SG1", null);
        Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListener", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:newDB;create=true", true, 1, null, Boolean.TRUE, null, null, null, 100000, null, false);
        runnable.run();
        SerializableRunnable listenerNotAttached = SerialAsyncEventListenerDUnit.getExecutorToCheckListenerNotAttached("WBCL1");
        SerializableRunnable listenerAttached = SerialAsyncEventListenerDUnit.getExecutorToCheckListenerAttached("WBCL1");
        this.clientExecute(1, (Runnable)listenerNotAttached);
        this.serverExecute(1, (Runnable)listenerAttached);
        this.serverExecute(2, (Runnable)listenerAttached);
        Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
        this.clientExecute(1, startWBCL);
        this.checkHubRunningAndIsPrimaryVerifier("WBCL1");
        Runnable stopWBCL = SerialAsyncEventListenerDUnit.stopAsyncEventListener("WBCL1");
        this.clientExecute(1, stopWBCL);
        Callable<?> hubStoppedVerifier = SerialAsyncEventListenerDUnit.getExecutorToCheckForHubRunningAndIsPrimary("WBCL1", false);
        this.serverExecute(1, hubStoppedVerifier);
        this.serverExecute(2, hubStoppedVerifier);
        Runnable removeWBCL = SerialAsyncEventListenerDUnit.dropAsyncEventListener("WBCL1");
        this.clientExecute(1, removeWBCL);
        Callable<?> wbclRemovedVerifier = SerialAsyncEventListenerDUnit.getExecutorToCheckWBCLRemoved("WBCL1");
        this.serverExecute(1, wbclRemovedVerifier);
        this.serverExecute(2, wbclRemovedVerifier);
        this.startServerVMs(1, -1, "SG1");
        this.startServerVMs(1, -1, "SG2");
        this.serverExecute(3, wbclRemovedVerifier);
        this.serverExecute(4, (Runnable)listenerNotAttached);
    }

    public void _testAsyncEventListenerDispatching() throws Exception {
        this.startVMs(1, 1, -1, "SG2", null);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (WBCL1)");
        this.clientSQLExecute(1, "insert into testtable values(114,'desc114','add114')");
        this.startServerVMs(1, -1, "SG2");
        Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG2", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListenerNotify", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:newDB;create=true", true, 1, null, Boolean.FALSE, null, null, null, 100000, null, false);
        runnable.run();
        SerializableCallable sr = new SerializableCallable("Set Events Collector"){

            public Object call() {
                AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                Event[] events = new Event[2];
                tgen.setEventsExpected(events);
                return GemFireStore.getMyId().toString();
            }
        };
        String listenerMember = (String)this.serverExecute(2, (Callable<?>)sr);
        Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
        this.clientExecute(1, startWBCL);
        this.clientSQLExecute(1, "insert into testtable values(1,'desc1','add1')");
        this.clientSQLExecute(1, "update TESTTABLE set description = 'modified' where ID =1");
        SerializableRunnable sc = new SerializableRunnable("validate callback data"){

            public void run() {
                try {
                    AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                    GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                    DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                    while (tgen.getNumEventsProcessed() != 2) {
                        Thread.sleep(1000L);
                    }
                    Event createdEvent = tgen.getEvents()[0];
                    Object pk = createdEvent.getPrimaryKey()[0];
                    Event ev = tgen.getEvents()[1];
                    TestCase.assertNotNull((Object)ev);
                    List list = ev.getNewRow();
                    TestCase.assertEquals((int)list.size(), (int)3);
                    TestCase.assertEquals(list.get(1), (Object)"modified");
                    TestCase.assertNull(list.get(0));
                    TestCase.assertNull(list.get(2));
                    TestCase.assertEquals((Object)pk, (Object)ev.getPrimaryKey()[0]);
                }
                catch (Exception e) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                }
            }
        };
        this.serverExecute(2, (Runnable)sc);
    }

    public void Bug51213testAsyncEventListenerOnNonBucketHostingNode() throws Exception {
        this.startVMs(1, 1, -1, "SG1", null);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (WBCL1)");
        this.clientSQLExecute(1, "insert into testtable values(114,'desc114','add114')");
        this.startServerVMs(1, -1, "SG2");
        Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG2", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListenerNotify", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:newDB;create=true", true, 1, null, Boolean.FALSE, null, null, null, 100000, null, false);
        runnable.run();
        SerializableCallable sr = new SerializableCallable("Set Events Collector"){

            public Object call() {
                AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                Event[] events = new Event[2];
                tgen.setEventsExpected(events);
                return GemFireStore.getMyId().toString();
            }
        };
        String listenerMember = (String)this.serverExecute(2, (Callable<?>)sr);
        Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
        this.clientExecute(1, startWBCL);
        this.clientSQLExecute(1, "insert into testtable values(1,'desc1','add1')");
        this.clientSQLExecute(1, "update TESTTABLE set description = 'modified' where id =1");
        SerializableRunnable sc = new SerializableRunnable("validate callback data"){

            public void run() {
                try {
                    AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                    GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                    DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                    while (tgen.getNumEventsProcessed() != 2) {
                        Thread.sleep(1000L);
                    }
                    Event createdEvent = tgen.getEvents()[0];
                    Object pk = createdEvent.getPrimaryKey()[0];
                    Event ev = tgen.getEvents()[1];
                    TestCase.assertNotNull((Object)ev);
                    List list = ev.getNewRow();
                    TestCase.assertEquals((int)list.size(), (int)3);
                    TestCase.assertEquals(list.get(1), (Object)"modified");
                    TestCase.assertNull(list.get(0));
                    TestCase.assertNull(list.get(2));
                    TestCase.assertEquals((Object)pk, (Object)ev.getPrimaryKey()[0]);
                }
                catch (Exception e) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                }
            }
        };
        this.serverExecute(2, (Runnable)sc);
        Statement stmt = TestUtil.jdbcConn.createStatement();
        ResultSet rs = stmt.executeQuery("select t.*, m.ID DSID from SYS.SYSTABLES t, SYS.MEMBERS m where t.tablename='TESTTABLE' and m.SERVERGROUPS='SG2'");
        SerialAsyncEventListenerDUnit.assertTrue((boolean)rs.next());
        SerialAsyncEventListenerDUnit.assertEquals((String)"TESTTABLE", (String)rs.getString("TABLENAME"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"PARTITION", (String)rs.getString("DATAPOLICY"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"PARTITION BY COLUMN ()", (String)rs.getString("RESOLVER"));
        SerialAsyncEventListenerDUnit.assertTrue((boolean)rs.getBoolean("GATEWAYENABLED"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"WBCL1", (String)rs.getString("ASYNCLISTENERS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("EVICTIONATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("DISKATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("EXPIRATIONATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("LOADER"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("WRITER"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("LISTENERS"));
        SerialAsyncEventListenerDUnit.assertEquals((Object)listenerMember, (Object)rs.getObject("DSID"));
        SerialAsyncEventListenerDUnit.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select t.*, m.ID DSID from SYS.SYSTABLES t, SYS.MEMBERS m, SYS.ASYNCEVENTLISTENERS a where t.tablename='TESTTABLE' and groupsintersect(a.SERVER_GROUPS, m.SERVERGROUPS) and groupsintersect(t.ASYNCLISTENERS, a.ID)");
        SerialAsyncEventListenerDUnit.assertTrue((boolean)rs.next());
        SerialAsyncEventListenerDUnit.assertEquals((String)"TESTTABLE", (String)rs.getString("TABLENAME"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"PARTITION", (String)rs.getString("DATAPOLICY"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"PARTITION BY COLUMN ()", (String)rs.getString("RESOLVER"));
        SerialAsyncEventListenerDUnit.assertTrue((boolean)rs.getBoolean("GATEWAYENABLED"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"WBCL1", (String)rs.getString("ASYNCLISTENERS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("EVICTIONATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("DISKATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("EXPIRATIONATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("LOADER"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("WRITER"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("LISTENERS"));
        SerialAsyncEventListenerDUnit.assertEquals((Object)listenerMember, (Object)rs.getObject("DSID"));
        SerialAsyncEventListenerDUnit.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from SYS.SYSTABLES where tablename='TESTTABLE'");
        SerialAsyncEventListenerDUnit.assertTrue((boolean)rs.next());
        SerialAsyncEventListenerDUnit.assertEquals((String)"TESTTABLE", (String)rs.getString("TABLENAME"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"PARTITION", (String)rs.getString("DATAPOLICY"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"PARTITION BY COLUMN ()", (String)rs.getString("RESOLVER"));
        SerialAsyncEventListenerDUnit.assertTrue((boolean)rs.getBoolean("GATEWAYENABLED"));
        SerialAsyncEventListenerDUnit.assertEquals((String)"WBCL1", (String)rs.getString("ASYNCLISTENERS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("EVICTIONATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("DISKATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("EXPIRATIONATTRS"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("LOADER"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("WRITER"));
        SerialAsyncEventListenerDUnit.assertNull((Object)rs.getString("LISTENERS"));
        SerialAsyncEventListenerDUnit.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Bug51213testAsyncEventListenerOnNonPkBasedTable() throws Exception {
        this.startVMs(1, 2, -1, "SG1", null);
        try {
            int i;
            this.clientSQLExecute(1, "create table TESTTABLE (ID int  , DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (WBCL1)");
            this.clientSQLExecute(1, "insert into testtable values(114,'desc114','add114')");
            this.startServerVMs(1, -1, "SG2");
            Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG2", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListenerNotify", null, null, true, 1, null, Boolean.FALSE, null, null, null, 100000, null, false);
            runnable.run();
            SerializableRunnable sr = new SerializableRunnable("Set Events Collector"){

                public void run() {
                    AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                    GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                    DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                    Event[] events = new Event[25];
                    tgen.setEventsExpected(events);
                }
            };
            this.serverExecute(3, (Runnable)sr);
            Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            for (i = 1; i < 11; ++i) {
                this.clientSQLExecute(1, "insert into testtable values(" + i + ",'desc" + i + "','add" + i + "')");
            }
            for (i = 1; i < 11; ++i) {
                this.clientSQLExecute(1, "update TESTTABLE set description = 'modified" + (i + 1) + "' where id = " + i);
            }
            for (i = 1; i < 6; ++i) {
                this.clientSQLExecute(1, "Delete from TESTTABLE where id = " + i);
            }
            SerializableRunnable sc = new SerializableRunnable("validate callback data"){

                public void run() {
                    try {
                        List list;
                        Event ev;
                        int i;
                        AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                        GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                        DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                        while (tgen.getNumEventsProcessed() != 25) {
                            Thread.sleep(1000L);
                        }
                        Long[] createdPKs = new Long[10];
                        for (i = 0; i < 10; ++i) {
                            ev = tgen.getEvents()[i];
                            TestCase.assertNotNull((Object)ev);
                            list = ev.getNewRow();
                            TestCase.assertEquals((int)list.size(), (int)3);
                            TestCase.assertEquals(list.get(0), (Object)new Integer(i + 1));
                            TestCase.assertEquals(list.get(1), (Object)("desc" + (i + 1)));
                            TestCase.assertEquals(list.get(2), (Object)("add" + (i + 1)));
                            createdPKs[i] = (Long)ev.getPrimaryKey()[0];
                        }
                        for (i = 10; i < 20; ++i) {
                            ev = tgen.getEvents()[i];
                            TestCase.assertNotNull((Object)ev);
                            list = ev.getNewRow();
                            TestCase.assertEquals((int)list.size(), (int)3);
                            TestCase.assertEquals(list.get(1), (Object)("modified" + (i - 8)));
                            TestCase.assertNull(list.get(0));
                            TestCase.assertNull(list.get(2));
                            TestCase.assertEquals((Object)ev.getPrimaryKey()[0], (Object)createdPKs[i - 10]);
                        }
                        for (i = 20; i < 25; ++i) {
                            ev = tgen.getEvents()[i];
                            TestCase.assertNotNull((Object)ev);
                            list = ev.getNewRow();
                            TestCase.assertNull((Object)list);
                            TestCase.assertEquals((Object)ev.getPrimaryKey()[0], (Object)createdPKs[i - 20]);
                        }
                    }
                    catch (Exception e) {
                        throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                    }
                }
            };
            this.serverExecute(3, (Runnable)sc);
        }
        finally {
            this.clientSQLExecute(1, "drop table TESTTABLE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Bug51213testAsyncEventListenerOnMultiColumnPkBasedTable() throws Exception {
        this.startVMs(1, 2, -1, "SG1", null);
        try {
            int i;
            this.clientSQLExecute(1, "create table TESTTABLE (ID int  , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), constraint pk primary key (ID, ADDRESS)) AsyncEventListener (WBCL1)");
            this.clientSQLExecute(1, "insert into testtable values(114,'desc114','add114')");
            this.startServerVMs(1, -1, "SG2");
            Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG2", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListenerNotify", null, null, true, 1, null, Boolean.FALSE, null, null, null, 100000, null, false);
            runnable.run();
            SerializableRunnable sr = new SerializableRunnable("Set Events Collector"){

                public void run() {
                    AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                    GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                    DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                    Event[] events = new Event[25];
                    tgen.setEventsExpected(events);
                }
            };
            this.serverExecute(3, (Runnable)sr);
            Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            for (i = 1; i < 11; ++i) {
                this.clientSQLExecute(1, "insert into testtable values(" + i + ",'desc" + i + "','add" + i + "')");
            }
            for (i = 1; i < 11; ++i) {
                this.clientSQLExecute(1, "update TESTTABLE set description = 'modified" + (i + 1) + "' where id = " + i);
            }
            for (i = 1; i < 6; ++i) {
                this.clientSQLExecute(1, "Delete from TESTTABLE where id = " + i);
            }
            SerializableRunnable sc = new SerializableRunnable("validate callback data"){

                public void run() {
                    try {
                        Object[] pkArrCreate;
                        List list;
                        Event ev;
                        int i;
                        AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                        GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                        DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                        while (tgen.getNumEventsProcessed() != 25) {
                            SerialAsyncEventListenerDUnit.this.getLogWriter().info((Object)("Number of events  processed  = " + tgen.getNumEventsProcessed() + ". Total events expected = " + tgen.getEvents().length));
                            Thread.sleep(1000L);
                        }
                        Object[] createdPKs = new Object[10];
                        for (i = 0; i < 10; ++i) {
                            ev = tgen.getEvents()[i];
                            TestCase.assertNotNull((Object)ev);
                            list = ev.getNewRow();
                            TestCase.assertEquals((int)list.size(), (int)3);
                            TestCase.assertEquals(list.get(0), (Object)new Integer(i + 1));
                            TestCase.assertEquals(list.get(1), (Object)("desc" + (i + 1)));
                            TestCase.assertEquals(list.get(2), (Object)("add" + (i + 1)));
                            createdPKs[i] = ev.getPrimaryKey();
                        }
                        for (i = 10; i < 20; ++i) {
                            ev = tgen.getEvents()[i];
                            TestCase.assertNotNull((Object)ev);
                            list = ev.getNewRow();
                            TestCase.assertEquals((int)list.size(), (int)3);
                            TestCase.assertEquals(list.get(1), (Object)("modified" + (i - 8)));
                            TestCase.assertNull(list.get(0));
                            TestCase.assertNull(list.get(2));
                            Object[] pkArrUpdate = ev.getPrimaryKey();
                            pkArrCreate = (Object[])createdPKs[i - 10];
                            TestCase.assertTrue((boolean)Arrays.equals(pkArrCreate, pkArrUpdate));
                        }
                        for (i = 20; i < 25; ++i) {
                            ev = tgen.getEvents()[i];
                            TestCase.assertNotNull((Object)ev);
                            list = ev.getNewRow();
                            TestCase.assertNull((Object)list);
                            Object[] pkArrDelete = ev.getPrimaryKey();
                            pkArrCreate = (Object[])createdPKs[i - 20];
                            TestCase.assertTrue((boolean)Arrays.equals(pkArrCreate, pkArrDelete));
                        }
                    }
                    catch (Exception e) {
                        throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                    }
                }
            };
            this.serverExecute(3, (Runnable)sc);
        }
        finally {
            this.clientSQLExecute(1, "drop table TESTTABLE");
        }
    }

    public void testSkipListenerBehaviourForAsyncEventListenerReplicate() throws Exception {
        this.skipListenerBehaviourForAsyncEventListener(true, false, -1);
    }

    public void testSkipListenerBehaviourForAsyncEventListenerPR() throws Exception {
        this.skipListenerBehaviourForAsyncEventListener(false, false, -1);
    }

    public void testSkipListenerBehaviourForAsyncEventListenerReplicateUsingNetConnection() throws Exception {
        this.skipListenerBehaviourForAsyncEventListener(true, true, 2726);
    }

    public void testSkipListenerBehaviourForAsyncEventListenerPRUsingNetConnection() throws Exception {
        this.skipListenerBehaviourForAsyncEventListener(false, true, 2727);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipListenerBehaviourForAsyncEventListener(boolean useReplicate, boolean useNetConnection, int port) throws Exception {
        try {
            this.startVMs(1, 2, -1, "SG1", null);
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (WBCL1) " + (useReplicate ? " replicate " : ""));
            this.clientSQLExecute(1, "insert into testtable values(114,'desc114','add114')");
            this.clientSQLExecute(1, "insert into testtable values(115,'desc115','add115')");
            this.clientSQLExecute(1, "insert into testtable values(116,'desc116','add116')");
            if (useNetConnection) {
                TestUtil.startNetServer(port, null);
            }
            Runnable runnable = SerialAsyncEventListenerDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$TestNewGatewayEventListenerNotify", null, null, true, 1, null, Boolean.FALSE, null, null, null, 100000, null, false);
            runnable.run();
            SerializableRunnable sr = new SerializableRunnable("Set Events Collector"){

                public void run() {
                    AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                    GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                    DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                    Event[] events = new Event[]{};
                    tgen.setEventsExpected(events);
                }
            };
            this.serverExecute(1, (Runnable)sr);
            this.serverExecute(2, (Runnable)sr);
            Runnable startWBCL = SerialAsyncEventListenerDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            Properties props = new Properties();
            props.put("skip-listeners", "true");
            Connection conn = useNetConnection ? TestUtil.getNetConnection(port, null, props) : TestUtil.getConnection(props);
            Statement stmt = conn.createStatement();
            stmt.execute("insert into testtable values(1,'desc1','add1')");
            stmt.execute("insert into testtable values(2,'desc2','add2')");
            stmt.execute("update TESTTABLE set description = 'modified' where id = 114");
            stmt.execute("update TESTTABLE set description = 'modified' ");
            stmt.execute("delete from  TESTTABLE where id = 114");
            stmt.execute("delete from  TESTTABLE ");
            Thread.sleep(3000L);
            SerializableRunnable sc = new SerializableRunnable("validate callback data"){

                public void run() {
                    try {
                        AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
                        GfxdGatewayEventListener listener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                        DBSynchronizerTestBase.TestNewGatewayEventListenerNotify tgen = (DBSynchronizerTestBase.TestNewGatewayEventListenerNotify)listener.getAsyncEventListenerForTest();
                        TestCase.assertFalse((boolean)tgen.exceptionOccured);
                        TestCase.assertEquals((int)0, (int)tgen.getNumCallbacks());
                    }
                    catch (Exception e) {
                        throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                    }
                }
            };
            this.serverExecute(1, (Runnable)sc);
            this.serverExecute(2, (Runnable)sc);
        }
        finally {
            if (useNetConnection) {
                TestUtil.stopNetServer();
            }
        }
    }

    public static class AggregationListener
    implements AsyncEventListener {
        private static final Logger LOG = LoggerFactory.getLogger((String)AggregationListener.class.getName());
        private static final String DRIVER = "com.pivotal.gemfirexd.jdbc.ClientDriver";
        private static final String CONN_URL = "jdbc:gemfirexd:";
        private static final String SELECT_SQL = "select * from load_averages where weekday=? and time_slice=? and plug_id=?";
        private static final String UPDATE_SQL = "update load_averages set total_load=?, event_count=? where weekday=? and time_slice=? and plug_id=?";
        private String valueColumn;
        private static ThreadLocal<Connection> dConn;
        private static ThreadLocal<PreparedStatement> selectStmt;
        private static ThreadLocal<PreparedStatement> updateStmt;

        private static Connection getConnection() {
            Connection conn;
            try {
                conn = DriverManager.getConnection(CONN_URL);
            }
            catch (SQLException e) {
                throw new IllegalStateException("Unable to create connection", e);
            }
            return conn;
        }

        public boolean processEvents(List<Event> events) {
            for (Event e : events) {
                LOG.info("AggregateListener::Processing event" + e);
                if (e.getType() != Event.Type.AFTER_INSERT) continue;
                ResultSet eventRS = e.getNewRowsAsResultSet();
                try {
                    PreparedStatement s = selectStmt.get();
                    s.setInt(1, eventRS.getInt("weekday"));
                    s.setInt(2, eventRS.getInt("time_slice"));
                    s.setInt(3, eventRS.getInt("plug_id"));
                    ResultSet queryRS = s.executeQuery();
                    if (!queryRS.next()) continue;
                    PreparedStatement update = updateStmt.get();
                    update.setFloat(1, queryRS.getFloat("total_load") + eventRS.getFloat(this.valueColumn));
                    update.setInt(2, queryRS.getInt("event_count") + 1);
                    update.setInt(3, queryRS.getInt("weekday"));
                    update.setInt(4, queryRS.getInt("time_slice"));
                    update.setInt(5, queryRS.getInt("plug_id"));
                    update.executeUpdate();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }

        public void close() {
            System.out.println("--->>> Closing connection from AEQ listener");
            try {
                AggregationListener.getConnection().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public void init(String s) {
            this.valueColumn = s;
            SanityManager.TRACE_ON((String)"TraceLock_RAW_SENSOR");
            SanityManager.TRACE_ON((String)"TraceLock_APP.RAW_SENSOR");
            SanityManager.TRACE_ON((String)"TraceLock_LOAD_AVERAGES");
            SanityManager.TRACE_ON((String)"TraceLock_APP.LOAD_AVERAGES");
        }

        public void start() {
        }

        static {
            try {
                Class.forName(DRIVER).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to load the JDBC driver", cnfe);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("Unable to instantiate the JDBC driver", ie);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Not allowed to access the JDBC driver", iae);
            }
            dConn = new ThreadLocal<Connection>(){

                @Override
                protected Connection initialValue() {
                    return AggregationListener.getConnection();
                }
            };
            selectStmt = new ThreadLocal<PreparedStatement>(){

                @Override
                protected PreparedStatement initialValue() {
                    PreparedStatement stmt = null;
                    try {
                        stmt = ((Connection)dConn.get()).prepareStatement(AggregationListener.SELECT_SQL);
                    }
                    catch (SQLException se) {
                        throw new IllegalStateException("Unable to retrieve statement ", se);
                    }
                    return stmt;
                }
            };
            updateStmt = new ThreadLocal<PreparedStatement>(){

                @Override
                protected PreparedStatement initialValue() {
                    PreparedStatement stmt = null;
                    try {
                        stmt = ((Connection)dConn.get()).prepareStatement(AggregationListener.UPDATE_SQL);
                    }
                    catch (SQLException se) {
                        throw new IllegalStateException("Unable to retrieve statement ", se);
                    }
                    return stmt;
                }
            };
        }
    }
}

