/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dbsync;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.RowLoader;
import com.pivotal.gemfirexd.dbsync.CallbackObserver;
import com.pivotal.gemfirexd.dbsync.CallbackObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdGatewayEventListener;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.services.monitor.Monitor;

public class DBSynchronizerTestBase
extends DistributedSQLTestBase {
    static final int DELETED_KEY = 1;
    static volatile boolean ok = false;
    protected int netPort;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.netPort = AvailablePort.getRandomAvailablePort((int)0);
    }

    @Override
    protected void vmTearDown() throws Exception {
        ok = false;
        super.vmTearDown();
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public DBSynchronizerTestBase(String name) {
        super(name);
    }

    protected void blockForValidation() throws Exception {
        DBSynchronizerTestBase.blockForValidation(this.netPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockForValidation(int netPort) throws Exception {
        Class<DBSynchronizerTestBase> clazz = DBSynchronizerTestBase.class;
        synchronized (DBSynchronizerTestBase.class) {
            while (!ok) {
                DBSynchronizerTestBase.class.wait(1000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + netPort + "/newDB;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            Statement derbyStmt = derbyConn.createStatement();
            derbyStmt.execute("drop procedure validateTestEnd ");
            derbyConn.commit();
            Monitor.getStream().println("<ExpectedException action=add>lock could not be obtained</ExpectedException>");
            for (int tries = 1; tries <= 5; ++tries) {
                try {
                    derbyStmt.execute("drop trigger test_ok");
                    break;
                }
                catch (SQLException sqle) {
                    if (!sqle.getSQLState().startsWith("40XL")) {
                        throw sqle;
                    }
                    System.gc();
                    continue;
                }
            }
            Monitor.getStream().println("<ExpectedException action=remove>lock could not be obtained</ExpectedException>");
            derbyConn.commit();
            derbyConn.close();
            return;
        }
    }

    public static void waitForAsyncQueueFlush(String asycQueueId) throws InterruptedException {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null) {
            RegionQueue rq;
            AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)cache.getAsyncEventQueue(asycQueueId);
            while (asyncQueue != null && asyncQueue.isRunning() && asyncQueue.getSender() != null && (rq = asyncQueue.getSender().getQueue()) != null && rq.size() != 0) {
                Thread.sleep(500L);
            }
        }
    }

    public String getDerbyURL() throws Exception {
        return DBSynchronizerTestBase.getDerbyURL(this.netPort);
    }

    public static String getDerbyURL(int port) throws Exception {
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + port + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        return derbyDbUrl;
    }

    public NetworkServerControl startNetworkServer() throws Exception {
        return DBSynchronizerTestBase.startNetworkServer(this.netPort);
    }

    public static NetworkServerControl startNetworkServer(int netPort) throws Exception {
        DBSynchronizerTestBase.getGlobalLogger().info((Object)("Starting a Derby Network Server on " + InetAddress.getLocalHost().getHostName() + ":" + netPort));
        NetworkServerControl server = new NetworkServerControl(InetAddress.getLocalHost(), netPort);
        server.start(SanityManager.GET_DEBUG_STREAM());
        while (true) {
            Thread.sleep(500L);
            try {
                server.ping();
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        server.logConnections(true);
        return server;
    }

    protected void createDerbyValidationArtefacts() throws Exception {
        DBSynchronizerTestBase.createDerbyValidationArtefacts(this.netPort);
    }

    public static void createDerbyValidationArtefacts(int netPort) throws Exception {
        ok = false;
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        String schemaName = DBSynchronizerTestBase.getCurrentDefaultSchemaName();
        ResultSet rs = derbyConn.getMetaData().getTables(null, schemaName, "TESTTABLE", null);
        boolean foundTesttable = false;
        while (rs.next()) {
            foundTesttable = rs.getString(3).equalsIgnoreCase("TESTTABLE") && rs.getString(2).equalsIgnoreCase(schemaName);
            if (!foundTesttable) continue;
            derbyStmt.executeUpdate("delete from TESTTABLE");
            break;
        }
        if (!foundTesttable) {
            derbyStmt.execute("create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) ");
        }
        derbyStmt.execute("create procedure validateTestEnd( IN deletedPk INT) LANGUAGE JAVA PARAMETER STYLE JAVA  EXTERNAL NAME 'com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase.notifyThreadOnOK(java.lang.Integer)'  ");
        derbyStmt.execute("CREATE TRIGGER test_ok   AFTER  DELETE   ON  TESTTABLE REFERENCING OLD AS DELETEDROW  FOR EACH  ROW MODE DB2SQL call validateTestEnd(DELETEDROW.ID)");
        derbyConn.commit();
        derbyStmt.close();
        derbyConn.close();
    }

    static SerializableRunnable getExecutorToCheckListenerAttached(final String hubID) {
        SerializableRunnable checkListenerAttached = new SerializableRunnable("Verify if listener attached"){

            public void run() throws CacheException {
                AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue(hubID);
                TestCase.assertNotNull((Object)asyncQueue);
                TestCase.assertEquals((int)asyncQueue.getSender().getAsyncEventListeners().size(), (int)1);
            }
        };
        return checkListenerAttached;
    }

    static SerializableRunnable getExecutorToCheckListenerNotAttached(final String hubID) {
        SerializableRunnable checkListenerNotAttached = new SerializableRunnable("Verify listener not  attached"){

            public void run() throws CacheException {
                GemFireCacheImpl cache = Misc.getGemFireCache();
                AsyncEventQueue asyncQueue = cache.getAsyncEventQueue(hubID);
                TestCase.assertNull((Object)asyncQueue);
            }
        };
        return checkListenerNotAttached;
    }

    public static Runnable getExecutorForWBCLConfiguration(final String serverGroups, final String ID, final String className, final String driverClass, final String dbUrl, final Boolean manualStart, final Integer batchSize, final Integer batchTimeInterval, final Boolean batchConflation, final Boolean enablePersistence, final Integer maxQueueMem, final String diskStoreName, final Integer alertHreshold, String initParamtr, final Boolean isParallel) {
        SerializableRunnable wbclConfigurator = new SerializableRunnable("WBCL Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    str.append("CREATE asyncEventListener ");
                    str.append(ID);
                    str.append(" ( listenerclass '" + className + "'");
                    str.append(" initparams '" + (driverClass != null ? driverClass + "," : "") + dbUrl + "'");
                    if (manualStart != null) {
                        str.append(" MANUALSTART " + manualStart);
                    }
                    if (isParallel != null) {
                        str.append(" ISPARALLEL " + isParallel);
                    }
                    if (batchConflation != null) {
                        str.append(" ENABLEBATCHCONFLATION " + batchConflation);
                    }
                    if (batchSize != null) {
                        str.append(" BATCHSIZE " + batchSize);
                    }
                    if (batchTimeInterval != null) {
                        str.append(" BATCHTIMEINTERVAL " + batchTimeInterval);
                    }
                    if (enablePersistence != null) {
                        str.append(" ENABLEPERSISTENCE " + enablePersistence);
                    }
                    if (diskStoreName != null) {
                        str.append(" DISKSTORENAME " + diskStoreName);
                    }
                    if (maxQueueMem != null) {
                        str.append(" MAXQUEUEMEMORY " + maxQueueMem);
                    }
                    if (alertHreshold != null) {
                        str.append(" ALERTTHRESHOLD " + alertHreshold + ") ");
                    }
                    if (serverGroups != null) {
                        str.append("SERVER GROUPS ( " + serverGroups + " )");
                    }
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return wbclConfigurator;
    }

    Runnable getExecutorForWBCLConfigurationVerification(final String ID, final Integer batchSize, final Integer batchTimeInterval, final Boolean batchConflation, final Boolean enablePersistence, final Integer mqm, final String diskStoreName, final Integer alertHreshold, final String initParamStr) {
        SerializableRunnable wbclConfigVerifier = new SerializableRunnable("WBCL Configuration Verifier"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() throws CacheException {
                AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue(ID);
                AbstractGatewaySender sender = asyncQueue.getSender();
                if (batchSize != null) {
                    TestCase.assertEquals((int)sender.getBatchSize(), (int)batchSize);
                } else {
                    TestCase.assertEquals((int)sender.getBatchSize(), (int)100);
                }
                if (batchTimeInterval != null) {
                    TestCase.assertEquals((int)sender.getBatchTimeInterval(), (int)batchTimeInterval);
                } else {
                    TestCase.assertEquals((int)sender.getBatchTimeInterval(), (int)5);
                }
                if (batchConflation != null) {
                    TestCase.assertEquals((boolean)sender.isBatchConflationEnabled(), (boolean)batchConflation);
                } else {
                    TestCase.assertEquals((boolean)sender.isBatchConflationEnabled(), (boolean)false);
                }
                if (mqm != null) {
                    TestCase.assertEquals((int)sender.getMaximumQueueMemory(), (int)mqm);
                } else {
                    TestCase.assertEquals((int)sender.getMaximumQueueMemory(), (int)100);
                }
                if (diskStoreName != null) {
                    TestCase.assertEquals((String)sender.getDiskStoreName(), (String)diskStoreName);
                } else {
                    TestCase.assertEquals((String)"GFXD-DEFAULT-DISKSTORE", (String)sender.getDiskStoreName());
                }
                if (alertHreshold != null) {
                    TestCase.assertEquals((int)sender.getAlertThreshold(), (int)alertHreshold);
                } else {
                    TestCase.assertEquals((int)sender.getAlertThreshold(), (int)0);
                }
                if (enablePersistence != null) {
                    TestCase.assertEquals((boolean)sender.isPersistenceEnabled(), (boolean)enablePersistence);
                } else {
                    TestCase.assertEquals((boolean)sender.isPersistenceEnabled(), (boolean)false);
                }
                GfxdGatewayEventListener sgel = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
                AsyncEventListener ael = sgel.getAsyncEventListenerForTest();
                if (initParamStr != null) {
                    if (!(ael instanceof MyListener)) throw new IllegalStateException("Test is trying to verify the init param string but not exposing means to access the data from AsyncEventListener");
                    TestCase.assertEquals((String)initParamStr, (String)((MyListener)ael).getInitStr());
                    return;
                } else {
                    if (!(ael instanceof MyListener)) return;
                    TestCase.assertNull((Object)((MyListener)ael).getInitStr());
                }
            }
        };
        return wbclConfigVerifier;
    }

    static Callable<?> getExecutorToCheckForHubRunningAndIsPrimary(final String id, boolean shouldWBCLBeRunning) {
        SerializableCallable checkForHubRunningAndPrimary = new SerializableCallable("Check Hub Running & is Primary"){

            public Object call() throws CacheException {
                try {
                    boolean[] isHubRunningAndPrimary = new boolean[]{false, false};
                    GemFireCacheImpl cache = Misc.getGemFireCache();
                    for (AsyncEventQueue asyncQueue : cache.getAsyncEventQueues()) {
                        if (!id.equals(asyncQueue.getId())) continue;
                        isHubRunningAndPrimary[0] = asyncQueue.isRunning();
                        isHubRunningAndPrimary[1] = asyncQueue.isPrimary();
                        return isHubRunningAndPrimary;
                    }
                    return isHubRunningAndPrimary;
                }
                catch (Exception e) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                }
            }
        };
        return checkForHubRunningAndPrimary;
    }

    static Callable<?> getExecutorToCheckWBCLRemoved(final String id) {
        SerializableCallable checkWBCLRemoved = new SerializableCallable("Check WBCL Removed"){

            public Object call() throws CacheException {
                try {
                    GemFireCacheImpl cache = Misc.getGemFireCache();
                    return cache.getAsyncEventQueue(id) == null;
                }
                catch (Exception e) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                }
            }
        };
        return checkWBCLRemoved;
    }

    static Callable<?> getExecutorToCheckQueueEmpty(final String id) {
        SerializableCallable checkEmpty = new SerializableCallable("Check WBCL Queue empty"){

            public Object call() throws CacheException {
                Boolean empty = Boolean.FALSE;
                try {
                    GemFireCacheImpl cache = Misc.getGemFireCache();
                    AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)cache.getAsyncEventQueue(id);
                    if (asyncQueue != null) {
                        empty = asyncQueue.getSender().getQueue() == null || asyncQueue.getSender().getQueue().size() == 0;
                    }
                    return empty;
                }
                catch (Exception e) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                }
            }
        };
        return checkEmpty;
    }

    public static Runnable doBatchInsert() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.setAutoCommit(false);
                    Statement st = conn.createStatement();
                    st.addBatch("insert into TESTTABLE values(1,'desc1','Add1',1)");
                    st.addBatch("insert into TESTTABLE values(2,'desc2','Add2',2)");
                    st.executeBatch();
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable doBatchUpdate() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.setAutoCommit(false);
                    Statement st = conn.createStatement();
                    st.addBatch("Update TESTTABLE set DESCRIPTION = 'desc1Mod' where ID = 1");
                    st.addBatch("Update TESTTABLE set DESCRIPTION = 'desc2Mod' where ID = 2");
                    st.executeBatch();
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable doBatchDelete() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.setAutoCommit(false);
                    Statement st = conn.createStatement();
                    st.addBatch("Delete from TESTTABLE where ID = 1");
                    st.addBatch("Delete from TESTTABLE where ID = 2");
                    st.executeBatch();
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable startAsyncEventListener(final String id) {
        SerializableRunnable startWBCL = new SerializableRunnable("Start WBCL"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    CallableStatement cs = conn.prepareCall("call SYS.START_ASYNC_EVENT_LISTENER (?)");
                    cs.setString(1, id);
                    cs.execute();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return startWBCL;
    }

    public static Runnable stopAsyncEventListener(final String id) {
        SerializableRunnable stopWBCL = new SerializableRunnable("Start WBCL"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    CallableStatement cs = conn.prepareCall("call SYS.STOP_ASYNC_EVENT_LISTENER (?)");
                    cs.setString(1, id);
                    cs.execute();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return stopWBCL;
    }

    static Runnable dropAsyncEventListener(final String id) {
        SerializableRunnable removeWBCL = new SerializableRunnable("Remove WBCL"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.createStatement().execute("DROP ASYNCEVENTLISTENER " + id);
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return removeWBCL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void notifyThreadOnOK(Integer deletedPK) {
        if (deletedPK != 1) return;
        Class<DBSynchronizerTestBase> clazz = DBSynchronizerTestBase.class;
        synchronized (DBSynchronizerTestBase.class) {
            ok = true;
            DBSynchronizerTestBase.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Runnable getHubCreatorExecutor(final String servGrp, final String hubID, Integer port, Integer socketBufferSize, Integer maxPingTimeIntrval, String startUpPolicy, Boolean manualStart) {
        SerializableRunnable hubCreator = new SerializableRunnable(){

            public void run() {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    str.append("CREATE gatewaysender ");
                    str.append(hubID);
                    str.append(" ( remotedsid 2 ");
                    str.append(" MANUALSTART FALSE  maxqueuememory 100 ) ");
                    if (servGrp != null) {
                        str.append("SERVER GROUPS ( " + servGrp + " )");
                    }
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return hubCreator;
    }

    void checkHubRunningAndIsPrimaryVerifier(String id) {
        final Callable<?> hubRunningAndIsPrimaryVerifier = DBSynchronizerTestBase.getExecutorToCheckForHubRunningAndIsPrimary(id, true);
        DBSynchronizerTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                try {
                    boolean[] isHubRunningAndPrimary1 = (boolean[])DBSynchronizerTestBase.this.serverExecute(1, hubRunningAndIsPrimaryVerifier);
                    boolean[] isHubRunningAndPrimary2 = (boolean[])DBSynchronizerTestBase.this.serverExecute(2, hubRunningAndIsPrimaryVerifier);
                    return !(!isHubRunningAndPrimary2[0] || !isHubRunningAndPrimary1[0] || !isHubRunningAndPrimary1[1] && !isHubRunningAndPrimary2[1] || isHubRunningAndPrimary1[1] && isHubRunningAndPrimary2[1]);
                }
                catch (Exception ex) {
                    return false;
                }
            }

            public String description() {
                boolean[] isHubRunningAndPrimary1 = null;
                boolean[] isHubRunningAndPrimary2 = null;
                try {
                    isHubRunningAndPrimary1 = (boolean[])DBSynchronizerTestBase.this.serverExecute(1, hubRunningAndIsPrimaryVerifier);
                    isHubRunningAndPrimary2 = (boolean[])DBSynchronizerTestBase.this.serverExecute(2, hubRunningAndIsPrimaryVerifier);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "waiting for primary and secondary hubs to start isHubRunningAndPrimary1=" + Arrays.toString(isHubRunningAndPrimary1) + ", isHubRunningAndPrimary2=" + Arrays.toString(isHubRunningAndPrimary2);
            }
        }, (long)20000L, (long)500L, (boolean)true);
    }

    protected Connection createOraConnection(String oraUrl, String oraUser, String oraPasswd) throws SQLException {
        for (int tries = 1; tries <= 5; ++tries) {
            try {
                return DriverManager.getConnection(oraUrl, oraUser, oraPasswd);
            }
            catch (SQLRecoverableException sqlre) {
                continue;
            }
        }
        return DriverManager.getConnection(oraUrl, oraUser, oraPasswd);
    }

    public static class GfxdTestRowLoader
    implements RowLoader {
        private String params;

        public Object getRow(String schemaName, String tableName, Object[] primarykey) throws SQLException {
            SanityManager.DEBUG_PRINT((String)"GfxdTestRowLoader", (String)("load called with key=" + primarykey[0] + " in VM " + Misc.getDistributedSystem().getDistributedMember()));
            Integer num = (Integer)primarykey[0];
            Object[] values = new Object[]{num, "DESC" + num, "ADDR" + num, num};
            return values;
        }

        public String getParams() {
            return this.params;
        }

        public void init(String initStr) throws SQLException {
            this.params = initStr;
        }
    }

    public static class TestNewGatewayEventListenerNotify
    implements AsyncEventListener,
    MyListener {
        private volatile Event[] eventsProcessed = null;
        private int currEventNum = 0;
        volatile int eventsExpected = -1;
        volatile boolean allowEventsRemoval = true;
        public String initStr;
        boolean exceptionOccured = false;
        private int numCallback = 0;

        public void setEventsExpected(Event[] events) {
            this.eventsProcessed = events;
            this.eventsExpected = events.length;
        }

        public void setEventsRemovalFlag(boolean allowEventsRemoval) {
            this.allowEventsRemoval = allowEventsRemoval;
            if (!this.allowEventsRemoval) {
                this.eventsExpected = -1;
            }
        }

        public boolean exceptionOccurred() {
            return this.exceptionOccured;
        }

        public Event[] getEvents() {
            return this.eventsProcessed;
        }

        public int getNumEventsProcessed() {
            return this.currEventNum;
        }

        public int getNumCallbacks() {
            return this.numCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean processEvents(List<Event> events) {
            ++this.numCallback;
            try {
                if (this.eventsExpected == -1) {
                    Class<TestNewGatewayEventListenerNotify> clazz = TestNewGatewayEventListenerNotify.class;
                    synchronized (TestNewGatewayEventListenerNotify.class) {
                        TestNewGatewayEventListenerNotify.class.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return this.allowEventsRemoval;
                    }
                }
                for (Event event : events) {
                    Event.Type type = event.getType();
                    switch (type) {
                        case AFTER_INSERT: 
                        case AFTER_UPDATE: {
                            Assert.assertTrue((boolean)event.getNewRowsAsResultSet().next());
                            Assert.assertNull((Object)event.getOldRowAsResultSet());
                            break;
                        }
                        case AFTER_DELETE: {
                            Assert.assertTrue((boolean)event.getOldRowAsResultSet().next());
                            Assert.assertNull((Object)event.getNewRowsAsResultSet());
                        }
                    }
                    this.eventsProcessed[this.currEventNum++] = event;
                }
                if (this.eventsExpected != this.currEventNum) return this.allowEventsRemoval;
                Class<TestNewGatewayEventListenerNotify> clazz = TestNewGatewayEventListenerNotify.class;
                synchronized (TestNewGatewayEventListenerNotify.class) {
                    TestNewGatewayEventListenerNotify.class.notify();
                    // ** MonitorExit[var3_6] (shouldn't be in output)
                    return this.allowEventsRemoval;
                }
            }
            catch (Exception e) {
                this.exceptionOccured = true;
                throw new GemFireXDRuntimeException((Throwable)e);
            }
        }

        public void close() {
        }

        public void start() {
        }

        public void init(String initParamStr) {
            this.initStr = initParamStr;
        }

        @Override
        public String getInitStr() {
            return this.initStr;
        }
    }

    public static class TestNewGatewayEventListener
    implements AsyncEventListener,
    MyListener {
        String initStr;

        public boolean processEvents(List<Event> events) {
            return false;
        }

        public void close() {
        }

        public void start() {
        }

        public void init(String initParamStr) {
            this.initStr = initParamStr;
        }

        @Override
        public String getInitStr() {
            return this.initStr;
        }
    }

    public static class TestStartStopGatewayEventListener
    implements AsyncEventListener {
        public boolean processEvents(List<Event> events) {
            return false;
        }

        public void close() {
            CallbackObserver observer = CallbackObserverHolder.getInstance();
            observer.asyncEventListenerClose();
        }

        public void init(String initParamStr) {
        }

        public void start() {
            CallbackObserver observer = CallbackObserverHolder.getInstance();
            observer.asyncEventListenerStart();
        }
    }

    public static class TestAsyncEventListener
    implements AsyncEventListener {
        public boolean processEvents(List<Event> events) {
            return true;
        }

        public void close() {
        }

        public void init(String initParamStr) {
        }

        public void start() {
        }
    }

    public static interface MyListener {
        public String getInitStr();
    }
}

