/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dbsync;

import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.derby.drda.NetworkServerControl;

public class DBSynchronizerBasicDUnit
extends DBSynchronizerTestBase {
    public DBSynchronizerBasicDUnit(String name) {
        super(name);
    }

    protected Runnable createAsyncQueueConfigurationForBasicTests(String derbyUrl) {
        return DBSynchronizerBasicDUnit.getExecutorForWBCLConfiguration("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyUrl, true, 1, null, Boolean.FALSE, null, null, null, 100000, "org.apache.derby.jdbc.ClientDriver," + derbyUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicInsert() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasic_jsonCol() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = this.getDerbyURL();
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            derbyStmt.execute("CREATE table t1(col1 int primary key, col2 varchar(100))");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "CREATE table t1(col1 int primary key, col2 json) persistent partition by (col1) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into t1 values(1,'{\n  \"f1\" : 1,\n  \"f2\" : true\n}')");
            this.clientSQLExecute(1, "Insert into t1 values(2,'{\n  \"f3\" : 1,\n  \"f4\" : true\n}')");
            this.clientSQLExecute(1, "Insert into t1 values(3,'{\n  \"f5\" : 1,\n  \"f6\" : true\n}')");
            this.clientSQLExecute(1, "Insert into t1 values(4,'{\n  \"f7\" : 1,\n  \"f8\" : true\n}')");
            this.clientSQLExecute(1, "Insert into t1 values(5, NULL)");
            this.clientSQLExecute(1, "delete from t1 where col1 = 2");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from t1", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicUpdate() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.clientSQLExecute(1, "Update TESTTABLE set DESCRIPTION = 'desc1Mod' where DESCRIPTION = 'desc1'");
            this.clientSQLExecute(1, "Update TESTTABLE set DESCRIPTION = 'desc2Mod' where ID = 2");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicDelete() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
            this.clientSQLExecute(1, "delete from TESTTABLE where ID = 2");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchInsert() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientExecute(1, DBSynchronizerBasicDUnit.doBatchInsert());
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchUpdate() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.clientExecute(1, DBSynchronizerBasicDUnit.doBatchUpdate());
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchDelete() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.clientExecute(1, DBSynchronizerBasicDUnit.doBatchDelete());
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertOnNonPKBasedTable() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testUpdateOnNonPKBasedTable() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.clientSQLExecute(1, "Update TESTTABLE set DESCRIPTION = 'desc1Mod' where ID = 1");
            this.clientSQLExecute(1, "Update TESTTABLE set DESCRIPTION = 'desc2Mod' where ID = 2");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testDeleteOnNonPKBasedTable() throws Exception {
        Statement derbyStmt = null;
        Connection derbyConn = null;
        NetworkServerControl server = null;
        try {
            String derbyDbUrl = DBSynchronizerBasicDUnit.getDerbyURL(this.netPort);
            server = this.startNetworkServer();
            this.createDerbyValidationArtefacts();
            derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            this.getLogWriter().info((Object)"Started derby network server");
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, -1, "SG1");
            this.getLogWriter().info((Object)"Started the accessor and datastore vms");
            this.clientSQLExecute(1, "create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (WBCL1) ");
            Runnable createWBCLConfig = this.createAsyncQueueConfigurationForBasicTests(derbyDbUrl);
            this.clientExecute(1, createWBCLConfig);
            Runnable startWBCL = DBSynchronizerBasicDUnit.startAsyncEventListener("WBCL1");
            this.clientExecute(1, startWBCL);
            this.getLogWriter().info((Object)"Created and started AsyncEventListener WBCL1");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(1,'desc1','Add1',1)");
            this.clientSQLExecute(1, "Insert into TESTTABLE values(2,'desc2','Add2',2)");
            this.clientSQLExecute(1, "delete from TESTTABLE where ID = 1");
            this.clientSQLExecute(1, "delete from TESTTABLE where ID = 2");
            this.serverSQLExecute(1, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('WBCL1', 1, 30)");
            this.validateResults(derbyStmt, "select * from testtable", this.netPort, true);
        }
        catch (Throwable throwable) {
            this.derbyCleanup(derbyStmt, derbyConn, server);
            throw throwable;
        }
        this.derbyCleanup(derbyStmt, derbyConn, server);
    }
}

