/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dataawareprocedure.listAgg;

import com.pivotal.gemfirexd.dataawareprocedure.listAgg.ColumnDef;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ListAggProcedure {
    static Logger logger = Logger.getLogger("com.pivotal.gemfirexd");
    static final String BAD_COL_ERROR = "Unexpected Groupby or ListAgg column definition";
    static final String NO_DELIMITER = "Invalid delimiter specified for Groupby or ListAgg column names";
    public static final String DUPLICATE_LISTAGG = "ListAgg column cannot also be a GroupBy column or duplicated in list";
    public static String version = ".95";

    public static void ListAgg(String groupBy, String listAggCols, String tableName, String whereClause, String whereParams, String delimiter, ResultSet[] dynamicRS, ProcedureExecutionContext c) throws SQLException {
        Statement stmt;
        ResultSet rs;
        ArrayList<ColumnDef> cols;
        System.out.println("LISTAGG: Invoking ListAgg version:" + version);
        if (delimiter != null && delimiter.length() > 0) {
            boolean hasWhereParams;
            Connection cxn = c.getConnection();
            cols = ListAggProcedure.processInputParameters(listAggCols, groupBy, delimiter);
            if (whereClause != null) {
                whereClause = whereClause.trim();
            }
            if (whereParams != null) {
                whereParams = whereParams.trim();
            }
            String queryString = ListAggProcedure.buildQueryString(cols, tableName, whereClause);
            boolean bl = hasWhereParams = whereParams != null && whereParams.length() > 0;
            if (hasWhereParams || whereClause == null || whereClause.length() == 0) {
                PreparedStatement pstmt = cxn.prepareStatement(queryString);
                if (hasWhereParams) {
                    StringTokenizer tokenizer = new StringTokenizer(whereParams, ",");
                    int paramIndex = 1;
                    while (tokenizer.hasMoreTokens()) {
                        String param = tokenizer.nextToken();
                        pstmt.setString(paramIndex++, param);
                    }
                }
                rs = pstmt.executeQuery();
                stmt = pstmt;
            } else {
                stmt = cxn.createStatement();
                rs = stmt.executeQuery(queryString);
            }
        } else {
            throw new SQLException(NO_DELIMITER);
        }
        OutgoingResultSet outRS = ListAggProcedure.createOutgoingResultSet(c, cols);
        ArrayList<ColumnDef> colsRow = cols;
        outRS.addRow(colsRow);
        ListAggProcedure.processListAggInResultSet(cols, rs, outRS);
        rs.close();
        stmt.close();
    }

    public static String buildQueryString(ArrayList<ColumnDef> cdList, String tableName, String whereClause) {
        boolean firstRow = true;
        StringBuilder queryString = new StringBuilder();
        queryString.append("<local> SELECT ");
        for (ColumnDef cd : cdList) {
            if (!firstRow) {
                queryString.append(',');
            } else {
                firstRow = false;
            }
            queryString.append(cd.columnName);
        }
        queryString.append(" FROM ").append(tableName);
        if (whereClause != null && whereClause.length() > 0) {
            queryString.append(" WHERE ").append(whereClause);
        }
        queryString.append(" ORDER BY ");
        for (ColumnDef cd : cdList) {
            if (!cd.getOrderBy(queryString)) continue;
            queryString.append(',');
        }
        assert (queryString.charAt(queryString.length() - 1) == ',');
        queryString.setLength(queryString.length() - 1);
        return queryString.toString();
    }

    public static void processListAggInResultSet(ArrayList<ColumnDef> cols, ResultSet rs, OutgoingResultSet outRS) {
        int numCols = cols.size();
        int numGroupByCols = 0;
        for (ColumnDef col : cols) {
            if (!col.isGroupByCol()) break;
            ++numGroupByCols;
        }
        try {
            Object[] groupingKey = new Object[numGroupByCols];
            ArrayList<Object> listAggValues = new ArrayList<Object>(numCols);
            block3: while (rs.next()) {
                ArrayList agg;
                int i;
                if (listAggValues.size() > 0) {
                    for (i = 0; i < numGroupByCols; ++i) {
                        int j;
                        Object v1 = rs.getObject(i + 1);
                        Object v2 = listAggValues.get(i);
                        groupingKey[i] = v1;
                        if ((v1 != null || v2 == null) && v1.equals(v2)) continue;
                        outRS.addRow(listAggValues);
                        listAggValues = new ArrayList(numCols);
                        for (j = 0; j <= i; ++j) {
                            listAggValues.add(groupingKey[j]);
                        }
                        ++j;
                        while (j <= numCols) {
                            ArrayList<Object> agg2 = new ArrayList<Object>();
                            agg2.add(rs.getObject(j));
                            listAggValues.add(agg2);
                            ++j;
                        }
                        continue block3;
                    }
                    while (i < numCols) {
                        agg = (ArrayList)listAggValues.get(i);
                        agg.add(rs.getObject(i + 1));
                        ++i;
                    }
                    continue;
                }
                for (i = 1; i <= numGroupByCols; ++i) {
                    listAggValues.add(rs.getObject(i));
                }
                while (i <= numCols) {
                    agg = new ArrayList();
                    agg.add(rs.getObject(i));
                    listAggValues.add(agg);
                    ++i;
                }
            }
            if (listAggValues.size() > 0) {
                outRS.addRow(listAggValues);
            }
            outRS.endResults();
        }
        catch (SQLException e) {
            System.err.println("LISTAGG: Gemfirexd exception:" + e.getMessage());
            e.printStackTrace();
        }
    }

    static void displayResultRow(ArrayList<Object> col, ArrayList<ColumnDef> colsMeta) {
        System.out.println("LISTAGG: ------------------------------------");
        System.out.println("LISTAGG: Result Row");
        System.out.println("LISTAGG: Group By Columns:");
        int i = 0;
        for (Object o : col) {
            ColumnDef meta = colsMeta.get(i);
            if (meta.aggType == 0) {
                System.out.print("Group By:\t");
            } else if (meta.aggType == 1) {
                System.out.print("List Agg:\t");
            } else if (meta.aggType == 2) {
                System.out.print("Group By and List Agg:\t");
            }
            System.out.println("LISTAGG: ----->" + o.toString());
            ++i;
        }
        System.out.println("LISTAGG: ------------------------------------");
    }

    public static OutgoingResultSet createOutgoingResultSet(ProcedureExecutionContext c, ArrayList<ColumnDef> cols) {
        OutgoingResultSet outRS = c.getOutgoingResultSet(1);
        outRS.setBatchSize(5000);
        for (ColumnDef col : cols) {
            outRS.addColumn(col.columnName);
        }
        return outRS;
    }

    public static ArrayList<ColumnDef> processInputParameters(String listAgg, String groupBy, String delimiter) throws SQLException {
        ArrayList<ColumnDef> columnList = new ArrayList<ColumnDef>();
        if (listAgg != null && groupBy != null && listAgg.length() > 0 && groupBy.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(groupBy, ",");
            int columnNumber = 1;
            while (tokenizer.hasMoreTokens()) {
                columnList.add(new ColumnDef(tokenizer.nextToken().trim(), columnNumber++));
            }
            tokenizer = new StringTokenizer(listAgg, ",");
            boolean hasListAgg = false;
            while (tokenizer.hasMoreTokens()) {
                ColumnDef cd = new ColumnDef(tokenizer.nextToken().trim(), columnNumber++, delimiter);
                int index = columnList.indexOf(cd);
                if (index != -1) {
                    cd = columnList.get(index);
                    cd.delimiter = delimiter;
                    cd.setListAggCol();
                } else {
                    columnList.add(cd);
                }
                hasListAgg = true;
            }
            if (!hasListAgg) {
                columnList.clear();
            }
        } else {
            throw new SQLException(BAD_COL_ERROR);
        }
        return columnList;
    }
}

