/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dataawareprocedure.listAgg;

import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.dataawareprocedure.listAgg.ColumnDef;
import com.pivotal.gemfirexd.dataawareprocedure.listAgg.ListAggProcedure;
import com.pivotal.gemfirexd.procedure.IncomingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureProcessorContext;
import com.pivotal.gemfirexd.procedure.ProcedureResultProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public final class LISTAGGPROCESSOR
implements ProcedureResultProcessor {
    private ProcedureProcessorContext context;
    int counter = 0;
    long startTime = 0L;
    THashMap aggResultsMap;
    ColumnDef[] metaRow;
    int numGroupByCols;
    int numCols;
    private Iterator<List<Object>> newRsItr;
    Logger logger = Logger.getLogger("com.pivotal.gemfirexd");
    private static final String DEFAULT_DELIM = ",";

    public void close() {
        this.logger.config("Closing result set processor");
        this.context = null;
    }

    public List<Object> getNextResultRow(int resultSetNumber) throws InterruptedException {
        return this.gatherFancyRow(resultSetNumber);
    }

    private List<Object> gatherFancyRow(int resultSetNumber) throws InterruptedException {
        assert (resultSetNumber == 0) : "unexpected resultSetNumber=" + resultSetNumber;
        if (this.aggResultsMap == null) {
            TObjectHashingStrategy hashingStrategy = new TObjectHashingStrategy(){
                private static final long serialVersionUID = 1L;

                public boolean equals(Object o1, Object o2) {
                    ArrayList row1 = (ArrayList)o1;
                    ArrayList row2 = (ArrayList)o2;
                    for (int i = 0; i < LISTAGGPROCESSOR.this.numGroupByCols; ++i) {
                        Object col1 = row1.get(i);
                        Object col2 = row2.get(i);
                        if ((col1 != null || col2 == null) && col1.equals(col2)) continue;
                        return false;
                    }
                    return true;
                }

                public int computeHashCode(Object o) {
                    int h = 0;
                    ArrayList row = (ArrayList)o;
                    for (int i = 0; i < LISTAGGPROCESSOR.this.numGroupByCols; ++i) {
                        Object col = row.get(i);
                        if (col == null) continue;
                        h ^= col.hashCode();
                    }
                    return h;
                }
            };
            this.aggResultsMap = new THashMap(hashingStrategy);
            this.startTime = System.currentTimeMillis();
            this.organizeResults(this.context.getIncomingResultSets(0));
            this.logger.config("LISTAGGPROC:Before Sort:" + (System.currentTimeMillis() - this.startTime));
            Iterator iter = this.aggResultsMap.values().iterator();
            this.newRsItr = iter;
        }
        if (this.newRsItr.hasNext()) {
            List<Object> row = this.newRsItr.next();
            for (int i = this.numGroupByCols; i < this.numCols; ++i) {
                List agg = (List)row.get(i);
                row.set(i, LISTAGGPROCESSOR.convertToCSV(agg, this.metaRow[i].delimiter));
            }
            return row;
        }
        return null;
    }

    private void organizeResults(IncomingResultSet[] inSets) throws InterruptedException {
        ArrayList<List> unprocessedRows = new ArrayList<List>();
        for (IncomingResultSet inSet : inSets) {
            List nextRow;
            while ((nextRow = inSet.takeRow()) != IncomingResultSet.END_OF_RESULTS) {
                if (nextRow.get(0) instanceof ColumnDef) {
                    if (this.metaRow != null) continue;
                    ArrayList mrow = (ArrayList)nextRow;
                    this.numGroupByCols = 0;
                    for (ColumnDef col : mrow) {
                        if (col.isGroupByCol()) {
                            ++this.numGroupByCols;
                            continue;
                        }
                        if (col.delimiter != null) continue;
                        col.delimiter = DEFAULT_DELIM;
                    }
                    this.numCols = mrow.size();
                    this.metaRow = mrow.toArray(new ColumnDef[this.numCols]);
                    if (unprocessedRows.size() > 0) {
                        for (List row : unprocessedRows) {
                            this.processRow(row);
                        }
                    }
                    unprocessedRows = null;
                    continue;
                }
                if (this.metaRow != null) {
                    this.processRow(nextRow);
                    continue;
                }
                unprocessedRows.add(nextRow);
            }
        }
    }

    private void processRow(List<Object> nextRow) {
        Object rowsForThisGroupBy = this.aggResultsMap.get(nextRow);
        if (rowsForThisGroupBy == null) {
            this.aggResultsMap.put(nextRow, nextRow);
        } else {
            List row = (List)rowsForThisGroupBy;
            for (int i = this.numGroupByCols; i < this.numCols; ++i) {
                List agg1 = (List)row.get(i);
                List agg2 = (List)nextRow.get(i);
                agg1.addAll(agg2);
            }
        }
    }

    static String convertToCSV(List<Object> agg, String delim) {
        StringBuilder sb = new StringBuilder();
        boolean firstCall = true;
        for (Object o : agg) {
            if (!firstCall) {
                sb.append(delim).append(o);
                continue;
            }
            firstCall = false;
            sb.append(o);
        }
        return sb.toString();
    }

    public Object[] getOutParameters() throws InterruptedException {
        throw new AssertionError((Object)"this procedure has no out parameters");
    }

    public void init(ProcedureProcessorContext context) {
        this.context = context;
        this.logger.config("LISTAGGRESULT: Using version:" + ListAggProcedure.version);
        this.logger.config("LISTAGGRESULT: Initializing the ListAggResultProcessor");
    }
}

