/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dataawareprocedure.listAgg;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ColumnDef
implements DataSerializable {
    private static final long serialVersionUID = 7402578193767651032L;
    static final int ASC = 1;
    static final int DESC = 2;
    static final int NONE = 0;
    static final int GROUPBY = 0;
    static final int LISTAGG = 1;
    static final int GROUPBY_AND_LISTAGG = 2;
    String columnName;
    String delimiter = null;
    int sortOrder = 0;
    int colNumber = -1;
    int aggType;

    public ColumnDef() {
    }

    public ColumnDef(String colName, int c) {
        int splitIndex = colName.lastIndexOf(32);
        if (splitIndex > 0) {
            this.columnName = colName.substring(0, splitIndex).trim();
            String orderDef = colName.substring(splitIndex + 1);
            this.sortOrder = "DESC".equalsIgnoreCase(orderDef) ? 2 : 1;
        } else {
            this.columnName = colName;
            this.sortOrder = 1;
        }
        this.aggType = 0;
        this.delimiter = null;
        this.colNumber = c;
    }

    public ColumnDef(String colName, int c, String d) {
        int splitIndex = colName.lastIndexOf(32);
        if (splitIndex > 0) {
            this.columnName = colName.substring(0, splitIndex).trim();
            String orderDef = colName.substring(splitIndex + 1);
            this.sortOrder = "DESC".equalsIgnoreCase(orderDef) ? 2 : ("ASC".equalsIgnoreCase(orderDef) ? 1 : 0);
        } else {
            this.columnName = colName;
            this.sortOrder = 0;
        }
        this.aggType = 1;
        this.delimiter = d;
        this.colNumber = c;
    }

    public String toString() {
        return "ColumnDef: columnName=" + this.columnName + " number=" + this.colNumber + " aggregate=" + this.aggType + " delim=" + this.delimiter + " sortOrder=" + this.sortOrder;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isListAggCol() {
        return this.aggType != 0;
    }

    public boolean isGroupByCol() {
        return this.aggType != 1;
    }

    public void setListAggCol() {
        if (this.aggType == 0) {
            this.aggType = 2;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDef other = (ColumnDef)obj;
        return !(this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName));
    }

    public boolean getOrderBy(StringBuilder result) {
        if (this.sortOrder != 0) {
            result.append(this.columnName);
            if (this.sortOrder == 2) {
                result.append(" DESC");
            } else {
                result.append(" ASC");
            }
            return true;
        }
        return false;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.columnName, (DataOutput)out);
        DataSerializer.writeString((String)this.delimiter, (DataOutput)out);
        out.writeByte(this.sortOrder);
        out.writeByte(this.aggType);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.columnName = DataSerializer.readString((DataInput)in);
        this.delimiter = DataSerializer.readString((DataInput)in);
        this.sortOrder = in.readByte();
        this.aggType = in.readByte();
    }
}

