/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dataawareprocedure;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.procedure.ProcedureChunkMessage;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;

public class ProcedureTestDUnit
extends DistributedSQLTestBase {
    private static final String[] PROCEDURES = new String[]{"CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".retrieveDynamicResults' " + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS_WITH_GLOBAL(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".retrieveDynamicResultsWithGlobalEscape' " + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS_WITH_LOCAL(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".retrieveDynamicResultsWithLocalEscape' " + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_OUTGOING_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".retrieveDynamicResultsWithOutgoingResultSet'" + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE PROCEDURE_INOUT_PARAMETERS(number INT, INOUT name VARCHAR(25), OUT total INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".procedureWithInAndOutParameters'" + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE PROCEDURE_WITHOUT_RESULTSET(number INT, INOUT name VARCHAR(20) ) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".procedureWithoutDynamicResultSets'", "CREATE PROCEDURE PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(number INT, name VARCHAR(20) ) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".procedureWithoutDynamicResultSetsAndOutParameters'", "CREATE PROCEDURE RETRIEVE_CLOSED_RESULT() LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".retrieveClosedResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE RETRIEVE_EXTERNAL_RESULT(DBNAME VARCHAR(128), DBUSER VARCHAR(128), DBPWD VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".retrieveExternalResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE PROC_WITH_SIDE_EFFECTS(ret INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".procWithSideEffects' " + "DYNAMIC RESULT SETS 2", "CREATE PROCEDURE NESTED_RESULT_SETS(proctext VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".nestedDynamicResultSets' " + "DYNAMIC RESULT SETS 6"};
    private static final String[][] TABLES = new String[][]{{"SIMPLE_TABLE", "CREATE TABLE SIMPLE_TABLE (id INT)"}};

    public ProcedureTestDUnit(String name) {
        super(name);
    }

    public static void serverGroupProc(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        ProcedureTestDUnit.getGlobalLogger().info((Object)("executing serverGroupProc on id: " + InternalDistributedSystem.getConnectedInstance().getProperties()));
        ResultSet r = c.createStatement().executeQuery("values dsid()");
        ProcedureTestDUnit.assertTrue((boolean)r.next());
        String dsid = r.getString(1);
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        c.close();
    }

    public static void serverGroupProcWith5SecWait(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            ProcedureTestDUnit.fail((String)"why an uninterrpted exception in serverGroupProcWith5SecWait sleep");
        }
        ProcedureTestDUnit.getGlobalLogger().info((Object)("executing serverGroupProcWith5SecWait on id: " + InternalDistributedSystem.getConnectedInstance().getProperties()));
        ResultSet r = c.createStatement().executeQuery("values dsid()");
        ProcedureTestDUnit.assertTrue((boolean)r.next());
        String dsid = r.getString(1);
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("select servergroups from sys.members where id = '" + dsid + "'");
        }
        c.close();
    }

    public static void testLocal(int number, ResultSet[] rs1, ProcedureExecutionContext pec) throws SQLException {
        Connection c = pec.getConnection();
        ProcedureTestDUnit.getGlobalLogger().info((Object)("executing testLocal on id: " + InternalDistributedSystem.getConnectedInstance().getProperties()));
        rs1[0] = number > 0 ? c.createStatement().executeQuery("<LOCAL> SELECT ID, NAME from APP.EMP where ID='1'") : c.createStatement().executeQuery("SELECT ID, NAME from APP.EMP where ID='1'");
        Misc.getCacheLogWriter().fine("KN: exec own");
        ResultSet rs = c.createStatement().executeQuery("<LOCAL> SELECT ID, NAME from APP.EMP where ID='1'");
        while (rs.next()) {
            Misc.getCacheLogWriter().fine("KN: " + rs.getObject(1) + ", " + rs.getObject(2));
        }
        Misc.getCacheLogWriter().fine("KN: exec own ends");
    }

    public void testDAPLocalBug() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE APP.EMP (ID VARCHAR(10) NOT NULL, NAME VARCHAR(25), CONSTRAINT EMP_PK PRIMARY KEY (ID)) PARTITION BY PRIMARY KEY REDUNDANCY 1");
        st.execute("insert into APP.EMP values('1', 'one'), ('2', 'two'), ('3', 'three')");
        st.execute("CREATE PROCEDURE TESTLOCAL(loc INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".testLocal' " + "DYNAMIC RESULT SETS 1");
        CallableStatement cs = conn.prepareCall("CALL TESTLOCAL(?) on table APP.EMP");
        cs.setInt(1, 3);
        cs.execute();
        int rsIndex = 0;
        int cnt = 0;
        do {
            ++rsIndex;
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                ++cnt;
                System.out.println("KN: " + rs.getObject(1) + ", " + rs.getObject(2));
            }
        } while (cs.getMoreResults());
        ProcedureTestDUnit.assertEquals((int)1, (int)rsIndex);
        ProcedureTestDUnit.assertEquals((int)1, (int)cnt);
        conn.close();
    }

    public void testExecuteOnServerGroupProcedureCall() throws Exception {
        this.startServerVMs(3, 0, "sg1");
        this.startServerVMs(1, 0, "SG2");
        int clientPort = this.startNetworkServer(2, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.serverSQLExecute(1, "CREATE PROCEDURE SERVER_GROUP_PROC(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".serverGroupProc' " + "DYNAMIC RESULT SETS 4");
        CallableStatement cs = conn.prepareCall("CALL SERVER_GROUP_PROC(?) ON SERVER GROUPS (sg1)");
        cs.setInt(1, 3);
        cs.execute();
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                    ProcedureTestDUnit.assertTrue((String)row, (boolean)row.equalsIgnoreCase("sg1"));
                }
                this.getLogWriter().info((Object)("testExecuteQueryWithDataAwareProcedureCall row=" + row + " resultset index=" + rsIndex + " rowIndex=" + rowIndex));
            }
        } while (cs.getMoreResults());
        conn.close();
    }

    public void testNCExecuteOnServerGroupProcedureCall() throws Exception {
        this.startServerVMs(3, 0, "sg1");
        this.startServerVMs(1, 0, "SG2");
        int netPort = this.startNetworkServer(2, null, null);
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = netConn.createStatement();
        stmt.execute("CREATE PROCEDURE SERVER_GROUP_PROC(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".serverGroupProc' " + "DYNAMIC RESULT SETS 4");
        CallableStatement cs = netConn.prepareCall("CALL SERVER_GROUP_PROC(4)");
        cs.execute();
        int rsNumber = 0;
        do {
            ++rsNumber;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    ProcedureTestDUnit.assertTrue(((row = row + value.toString()).equalsIgnoreCase("sg1") || row.equalsIgnoreCase("sg2") ? 1 : 0) != 0);
                }
                this.getLogWriter().info((Object)("testNCExecuteQueryWithDataAwareProcedureCall row=" + row + " resultset index=" + rsNumber + " rowIndex=" + rowIndex));
            }
        } while (cs.getMoreResults());
        ProcedureTestDUnit.assertEquals((int)4, (int)rsNumber);
        cs.close();
    }

    public void testExecuteOnServerGroupProcedureCallWithWait() throws Exception {
        this.startServerVMs(3, 0, "sg1");
        this.startServerVMs(1, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "CREATE PROCEDURE SERVER_GROUP_PROC_WAIT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".serverGroupProcWith5SecWait' " + "DYNAMIC RESULT SETS 4");
        CallableStatement cs = this.prepareCall("CALL SERVER_GROUP_PROC_WAIT(?) ON SERVER GROUPS (sg1)");
        cs.setInt(1, 3);
        long start = System.currentTimeMillis();
        cs.execute();
        long end = System.currentTimeMillis();
        long wait = end - start;
        ProcedureTestDUnit.assertTrue((wait >= 5000L ? 1 : 0) != 0);
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                    ProcedureTestDUnit.assertTrue((boolean)row.equalsIgnoreCase("sg1"));
                }
                System.out.println("XXX testExecuteQueryWithDataAwareProcedureCall the row=" + row + " resultset index=" + rsIndex + " rowIndex=" + rowIndex);
            }
        } while (cs.getMoreResults());
    }

    public void testExecuteOnServerGroupProcedureCallWithNoWait() throws Exception {
        this.startServerVMs(3, 0, "sg1");
        this.startServerVMs(1, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "CREATE PROCEDURE SERVER_GROUP_PROC_WAIT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".serverGroupProcWith5SecWait' " + "DYNAMIC RESULT SETS 4");
        CallableStatement cs = this.prepareCall("CALL SERVER_GROUP_PROC_WAIT(?) ON SERVER GROUPS (sg1) NOWAIT");
        cs.setInt(1, 3);
        long start = System.currentTimeMillis();
        cs.execute();
        long end = System.currentTimeMillis();
        long wait = end - start;
        ProcedureTestDUnit.assertTrue((wait < 50L ? 1 : 0) != 0);
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                    ProcedureTestDUnit.assertTrue((boolean)row.equalsIgnoreCase("sg1"));
                }
                System.out.println("XXX testExecuteQueryWithDataAwareProcedureCall the row=" + row + " resultset index=" + rsIndex + " rowIndex=" + rowIndex);
            }
        } while (cs.getMoreResults());
    }

    public void testExecuteQueryWithDataAwareProcedureCall() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID in (?,?,?) AND THIRDID='3'");
        cs.setInt(1, 2);
        cs.setInt(2, 3);
        cs.setInt(3, 4);
        cs.setInt(4, 5);
        cs.execute();
        String[][] results = new String[2][2];
        results[0][0] = "1";
        results[0][1] = "1";
        results[1][0] = "1";
        results[1][1] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                System.out.println("XXX testExecuteQueryWithDataAwareProcedureCall the row=" + row + "resultset index=" + rsIndex + " rowIndex=" + rowIndex);
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
            if (rsIndex > 1 || rowIndex == 2) continue;
            ProcedureTestDUnit.fail((String)("the number of row to be excpected is 2 not " + rowIndex));
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("the number of result sets to be excpected is 4 not" + (rsIndex + 1)));
        }
    }

    public void testExecuteQueryWithDataAwareProcedureCallWithGlobalEscape() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS_WITH_GLOBAL(?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        cs.setInt(1, 2);
        cs.execute();
        HashSet<String> expectedResults = new HashSet<String>();
        expectedResults.add("223");
        expectedResults.add("333");
        expectedResults.add("443");
        expectedResults.add("553");
        expectedResults.add("222");
        expectedResults.add("224");
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            HashSet<String> results = new HashSet<String>();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (expectedResults.contains(row)) {
                    if (results.contains(row)) {
                        ProcedureTestDUnit.fail((String)("the duplicated row" + row));
                    } else {
                        results.add(row);
                    }
                } else {
                    ProcedureTestDUnit.fail((String)("the expected results do not contain this row " + row));
                }
                System.out.println("XXX testExecuteQueryWithDataAwareProcedureCall the row=" + row + "resultset index=" + rsIndex + " rowIndex=" + rowIndex);
            }
            if (rsIndex < 2) {
                if (results.size() == expectedResults.size()) continue;
                ProcedureTestDUnit.fail((String)("The number of rows in the results is supposed to be " + expectedResults.size() + " not " + results.size()));
                continue;
            }
            if (results.size() == 0) continue;
            ProcedureTestDUnit.fail((String)("The number of rows in the results is supposed to be 0 not " + results.size()));
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("the number of result sets to be excpected is 4 not" + (rsIndex + 1)));
        }
    }

    public void _testExecuteQueryWithDataAwareProcedureCallWithLocalEscape() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS_WITH_LOCAL(?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        cs.setInt(1, 2);
        cs.execute();
        int rsIndex = -1;
        do {
            ++rsIndex;
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                ProcedureTestDUnit.fail((String)"The result set is supposed to be empty!");
            }
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("the number of result sets to be excpected is 4 not" + (rsIndex + 1)));
        }
    }

    public void testDataAwareProcedureCallUsingGlobalIndex() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?) ON TABLE EMP.PARTITIONTESTTABLE1 WHERE SECONDID in (?,?,?) AND THIRDID='3'");
        cs.setInt(1, 2);
        cs.setInt(2, 3);
        cs.setInt(3, 4);
        cs.setInt(4, 5);
        cs.execute();
        String[][] results = new String[2][2];
        results[0][0] = "1";
        results[0][1] = "1";
        results[1][0] = "1";
        results[1][1] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
            if (rsIndex > 1 || rowIndex == 2) continue;
            ProcedureTestDUnit.fail((String)("the number of row to be excpected is 2 not " + rowIndex));
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("the number of result sets to be excpected is 4 not" + (rsIndex + 1)));
        }
    }

    public void testDataAwareProcedureWithoutResultSets() throws Exception {
        ParameterMetaData pmd;
        int numParameters;
        this.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET(?, ?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        cs.registerOutParameter(2, 12, 20);
        int number = 2;
        String name = "INOUTPARAMETER";
        cs.setInt(1, number);
        cs.setString(2, name);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTestDUnit.fail((String)"no dynamic result set for the procedure!");
        }
        ProcedureTestDUnit.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object parameter2 = cs.getObject(2);
        ProcedureTestDUnit.assertTrue((String)("the second inout parameter is " + name + number), (boolean)parameter2.equals(name + number));
    }

    public void testDataAwareProcedureWithoutResultSetsUsingGlobalIndex() throws Exception {
        ParameterMetaData pmd;
        int numParameters;
        this.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET(?, ?) ON TABLE EMP.PARTITIONTESTTABLE1 WHERE SECONDID=4 AND THIRDID='3'");
        cs.registerOutParameter(2, 12, 20);
        int number = 2;
        String name = "INOUTPARAMETER";
        cs.setInt(1, number);
        cs.setString(2, name);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTestDUnit.fail((String)"no dynamic result set for the procedure!");
        }
        ProcedureTestDUnit.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object parameter2 = cs.getObject(2);
        ProcedureTestDUnit.assertTrue((String)("the second inout parameter is " + name + number), (boolean)parameter2.equals(name + number));
    }

    public void testDataAwareProcedureWithoutResultSetsAndOutParameters() throws Exception {
        ParameterMetaData pmd;
        int numParameters;
        this.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(?, ?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        int number = 2;
        String name = "INOUTPARAMETER";
        cs.setInt(1, number);
        cs.setString(2, name);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTestDUnit.fail((String)"no dynamic result set for the procedure!");
        }
        ProcedureTestDUnit.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cs.getObject(2);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDataAwareProcedureWithoutResultSetsAndOutParametersAndQuestionMark() throws Exception {
        ParameterMetaData pmd;
        int numParameters;
        this.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(2, 'INOUTPARAMETER') ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTestDUnit.fail((String)"no dynamic result set for the procedure!");
        }
        ProcedureTestDUnit.assertTrue((String)" the number of parameter is 0", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 0 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cs.getObject(2);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testProcedureWithoutResultSetsAndOutParameters() throws Exception {
        ParameterMetaData pmd;
        int numParameters;
        this.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(?, ?)");
        int number = 2;
        String name = "INOUTPARAMETER";
        cs.setInt(1, number);
        cs.setString(2, name);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTestDUnit.fail((String)"no dynamic result set for the procedure!");
        }
        ProcedureTestDUnit.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cs.getObject(2);
            ProcedureTestDUnit.fail((String)"the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDataAwareProcedureWithOutgoingResultSets() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        int number = 2;
        cs.setInt(1, number);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureWithOutgoingResultSetsAndNoRoutingObjects() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONRANGETESTTABLE WHERE SECONDID in (?, ?, ?)");
        int number = 2;
        cs.setInt(1, number);
        cs.setInt(2, 2);
        cs.setInt(3, 3);
        cs.setInt(4, 4);
        cs.execute();
        String[][] results = new String[2][20];
        results[0][0] = "1";
        results[0][1] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
            results[1][i + 10] = i + "String" + i;
        }
        int[] numRows = new int[]{2, 20, 0, 0};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex >= numRows[rsIndex]) {
                    ProcedureTestDUnit.fail((String)("the result is not correct!  ResultSet Index=" + rsIndex + " row count=" + rowIndex + " expected Row count=" + numRows[rsIndex]));
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
            if (rowIndex == numRows[rsIndex]) continue;
            ProcedureTestDUnit.fail((String)("The " + rsIndex + " result set has " + numRows[rsIndex] + " instead of " + rowIndex));
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("The number of result sets is 4! instead of " + (rsIndex + 1)));
        }
    }

    public void testDataAwareProcedureWithOutgoingResultSetsOnAll() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON ALL");
        int number = 2;
        cs.setInt(1, number);
        cs.execute();
        String[][] results = new String[2][30];
        results[0][0] = "1";
        results[0][1] = "1";
        results[0][2] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
            results[1][i + 10] = i + "String" + i;
            results[1][i + 20] = i + "String" + i;
        }
        int[] numRows = new int[]{3, 30, 0, 0};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex >= numRows[rsIndex]) {
                    ProcedureTestDUnit.fail((String)("the result is not correct!  ResultSet Index=" + rsIndex + " row count=" + rowIndex + " expected Row count=" + numRows[rsIndex]));
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
            if (rowIndex == numRows[rsIndex]) continue;
            ProcedureTestDUnit.fail((String)("The " + rsIndex + " result set has " + numRows[rsIndex] + " instead of " + rowIndex));
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("The number of result sets is 4! instead of " + (rsIndex + 1)));
        }
    }

    public void _testDataAwareProcedureWithOutgoingResultSetsWithoutNodesToExecute() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONEMPTYTESTTABLE WHERE ID in (?, ?, ?)");
        int number = 2;
        cs.setInt(1, number);
        cs.setInt(2, 2);
        cs.setInt(3, 3);
        cs.setInt(4, 4);
        cs.execute();
        do {
            ResultSet rs;
            ResultSetMetaData metaData;
            int rowCount;
            if ((rowCount = (metaData = (rs = cs.getResultSet()).getMetaData()).getColumnCount()) == 0 && !rs.next()) continue;
            ProcedureTestDUnit.fail((String)"The result set is supposed to be empty!");
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureWithOutgoingResultSetsOnRangePartitionTable() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONRANGETESTTABLE WHERE ID>1 and ID<15");
        int number = 2;
        final int delaySeq = PartitionedRegion.rand.nextInt(4) + 1;
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void beforeProcedureChunkMessageSend(ProcedureChunkMessage m) {
                        if (m.getSeqNumber() == delaySeq) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                CacheFactory.getAnyInstance();
                            }
                        }
                    }
                });
            }
        });
        cs.setInt(1, number);
        cs.execute();
        String[][] results = new String[2][20];
        results[0][0] = "1";
        results[0][1] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
            results[1][i + 10] = i + "String" + i;
        }
        int[] numRows = new int[]{2, 20, 0, 0};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                this.getLogWriter().info((Object)("XXX row index=" + rowIndex + " row=" + row));
                if (rsIndex > 1 || rowIndex >= numRows[rsIndex]) {
                    ProcedureTestDUnit.fail((String)("the result is not correct!  ResultSet Index=" + rsIndex + " row count=" + rowIndex + " expected Row count=" + numRows[rsIndex]));
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
            if (rowIndex == numRows[rsIndex]) continue;
            ProcedureTestDUnit.fail((String)("The " + rsIndex + " result set has " + numRows[rsIndex] + " instead of " + rowIndex));
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("The number of result sets should 4 instead of " + (rsIndex + 1)));
        }
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                GemFireXDQueryObserverHolder.clearInstance();
            }
        });
    }

    public void testDataAwareProcedureWithOutgoingResultSetsOnListPartitionTable() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONLISTTESTTABLE WHERE ID in (?, ?, ?)");
        int number = 2;
        cs.setInt(1, number);
        cs.setInt(2, 10);
        cs.setInt(3, 15);
        cs.setInt(4, 5);
        cs.execute();
        String[][] results = new String[2][20];
        results[0][0] = "1";
        results[0][1] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
            results[1][i + 10] = i + "String" + i;
        }
        int[] numRows = new int[]{2, 20, 0, 0};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                System.out.println("XXX row index=" + rowIndex + " row=" + row);
                if (rsIndex > 1 || rowIndex >= numRows[rsIndex]) {
                    ProcedureTestDUnit.fail((String)("the result is not correct!  ResultSet Index=" + rsIndex + " row count=" + rowIndex + " expected Row count=" + numRows[rsIndex]));
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
            if (rowIndex == numRows[rsIndex]) continue;
            ProcedureTestDUnit.fail((String)("The " + rsIndex + " result set has " + numRows[rsIndex] + " instead of " + rowIndex));
        } while (cs.getMoreResults());
        if (rsIndex != 3) {
            ProcedureTestDUnit.fail((String)("The number of result sets is 4! instead of " + (rsIndex + 1)));
        }
    }

    public void testExecuteQueryWithOutgoingResultSetInDerbyCall() throws Exception {
        this.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?)");
        cs.setInt(1, 2);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testCallProcedureWithInAndOutParameter() throws Exception {
        int parameter3;
        String outParameter;
        this.setup();
        int number = 2;
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_INOUT_PARAMETERS(?, ?, ?)");
        cs.setInt(1, number);
        cs.registerOutParameter(2, 12);
        cs.setString(2, "INOUT_PARAMETER");
        cs.registerOutParameter(3, 4);
        cs.execute();
        String[][] results = new String[2][1];
        results[0][0] = "1";
        results[1][0] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTestDUnit.fail((String)"the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
        String outValue = cs.getString(2);
        if (!outValue.equals(outParameter = "INOUT_PARAMETERModified")) {
            ProcedureTestDUnit.fail((String)("the out parameter is supposed to " + outParameter + " but " + outValue));
        }
        if ((parameter3 = cs.getInt(3)) != number) {
            ProcedureTestDUnit.fail((String)("the out parameter is supposed to " + number + " but " + parameter3));
        }
    }

    public void testDataAwareProcedureWithInAndOutParameter() throws Exception {
        Statement stmt;
        block12: {
            int parameter3;
            String outParameter;
            String outValue;
            this.setup();
            int number = 2;
            CallableStatement cs = this.prepareCall("CALL PROCEDURE_INOUT_PARAMETERS(?, ?, ?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
            cs.setInt(1, number);
            cs.registerOutParameter(2, 12);
            cs.setString(2, "INOUT_PARAMETER");
            cs.registerOutParameter(3, 4);
            cs.execute();
            String[][] results = new String[2][2];
            results[0][0] = "1";
            results[0][1] = "1";
            results[1][0] = "1";
            results[1][1] = "1";
            int rsIndex = -1;
            do {
                ++rsIndex;
                int rowIndex = 0;
                ResultSet rs = cs.getResultSet();
                ResultSetMetaData metaData = rs.getMetaData();
                int rowCount = metaData.getColumnCount();
                while (rs.next()) {
                    String row = "";
                    for (int i = 1; i <= rowCount; ++i) {
                        Object value = rs.getObject(i);
                        row = row + value.toString();
                    }
                    if (rsIndex > 1 || rowIndex > 1) {
                        ProcedureTestDUnit.fail((String)"the result is not correct!");
                    }
                    if (!row.equals(results[rsIndex][rowIndex])) {
                        ProcedureTestDUnit.fail((String)"the result is not correct!");
                    }
                    ++rowIndex;
                }
                if (rsIndex > 1 || rowIndex == true) continue;
                ProcedureTestDUnit.fail((String)("the number of row to be excpected is 1 not " + rowIndex));
            } while (cs.getMoreResults());
            if (rsIndex != 3) {
                ProcedureTestDUnit.fail((String)("the number of result sets to be excpected is 4 not" + (rsIndex + 1)));
            }
            if (!(outValue = cs.getString(2)).equals(outParameter = "INOUT_PARAMETERModified")) {
                ProcedureTestDUnit.fail((String)("the out parameter is supposed to " + outParameter + " but " + outValue));
            }
            if ((parameter3 = cs.getInt(3)) != number) {
                ProcedureTestDUnit.fail((String)("the out parameter is supposed to " + number + " but " + parameter3));
            }
            stmt = cs.getConnection().createStatement();
            stmt.execute("CREATE PROCEDURE CHECK_STACK_OVERFLOW(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".checkStackOverflow' " + "DYNAMIC RESULT SETS 1");
            try {
                stmt.execute("call CHECK_STACK_OVERFLOW(-1) on table SIMPLE_TABLE");
                ProcedureTestDUnit.fail((String)"expected an exception due to stack overflow");
            }
            catch (SQLException sqle) {
                if (!"38000".equals(sqle.getSQLState())) {
                    throw sqle;
                }
                Throwable cause = sqle.getCause();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (cause instanceof StackOverflowError) break block12;
                throw sqle;
            }
        }
        ProcedureTestDUnit.assertTrue((boolean)stmt.execute("call CHECK_STACK_OVERFLOW(1) on table SIMPLE_TABLE"));
        ResultSet rs = stmt.getResultSet();
        ProcedureTestDUnit.assertEquals((int)1, (int)rs.getMetaData().getColumnCount());
        ProcedureTestDUnit.assertTrue((boolean)rs.next());
        ProcedureTestDUnit.assertEquals((int)0, (int)rs.getInt(1));
        ProcedureTestDUnit.assertTrue((boolean)rs.next());
        ProcedureTestDUnit.assertEquals((int)0, (int)rs.getInt(1));
        ProcedureTestDUnit.assertFalse((boolean)rs.next());
        ProcedureTestDUnit.assertFalse((boolean)stmt.getMoreResults());
        ProcedureTestDUnit.assertEquals((int)4, (int)stmt.executeUpdate("insert into simple_table values (1), (2), (3), (4)"));
        int cnt = 0;
        ProcedureTestDUnit.assertTrue((boolean)stmt.execute("call CHECK_STACK_OVERFLOW(10) on table SIMPLE_TABLE"));
        rs = stmt.getResultSet();
        ProcedureTestDUnit.assertEquals((int)1, (int)rs.getMetaData().getColumnCount());
        ProcedureTestDUnit.assertTrue((boolean)rs.next());
        cnt += rs.getInt(1);
        ProcedureTestDUnit.assertTrue((boolean)rs.next());
        ProcedureTestDUnit.assertFalse((boolean)rs.next());
        ProcedureTestDUnit.assertFalse((boolean)stmt.getMoreResults());
        ProcedureTestDUnit.assertEquals((int)4, (int)(cnt += rs.getInt(1)));
    }

    public void testDAPRelatedStatsOnTable() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE APP.EMP (ID VARCHAR(10) NOT NULL, NAME VARCHAR(25), CONSTRAINT EMP_PK PRIMARY KEY (ID)) PARTITION BY PRIMARY KEY REDUNDANCY 1");
        st.execute("insert into APP.EMP values('1', 'one'), ('2', 'two'), ('3', 'three')");
        st.execute("CREATE PROCEDURE TESTLOCAL(loc INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTestDUnit.class.getName() + ".testLocal' " + "DYNAMIC RESULT SETS 1");
        CallableStatement cs = conn.prepareCall("CALL TESTLOCAL(?) on table APP.EMP");
        cs.setInt(1, 3);
        cs.execute();
        ProcedureTestDUnit.assertEquals((boolean)true, (boolean)ProcedureTestDUnit.verifyAccessorDapStats());
        VM dataNode1 = (VM)this.serverVMs.get(0);
        ProcedureTestDUnit.assertEquals((boolean)true, (boolean)((Boolean)dataNode1.invoke(ProcedureTestDUnit.class, "verifyDataNodeDapStats")));
        VM dataNode2 = (VM)this.serverVMs.get(0);
        ProcedureTestDUnit.assertEquals((boolean)true, (boolean)((Boolean)dataNode2.invoke(ProcedureTestDUnit.class, "verifyDataNodeDapStats")));
        conn.close();
    }

    public static Boolean verifyAccessorDapStats() {
        final InternalDistributedSystem iDS = InternalDistributedSystem.getAnyInstance().getDistributionManager().getSystem();
        DistributedTestBase.WaitCriterion waitForStat = new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                FunctionStats stats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)iDS);
                return stats.getFunctionExecutionsCompletedDN() == 0;
            }

            public String description() {
                return "waiting for DAP call statistic on accessor";
            }
        };
        ProcedureTestDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)waitForStat, (long)60000L, (long)500L, (boolean)false);
        FunctionStats stats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)iDS);
        if (stats.getFunctionExecutionsCompletedDN() != 0) {
            return false;
        }
        return true;
    }

    public static Boolean verifyDataNodeDapStats() {
        final InternalDistributedSystem iDS = InternalDistributedSystem.getAnyInstance().getDistributionManager().getSystem();
        DistributedTestBase.WaitCriterion waitForStat = new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                FunctionStats stats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)iDS);
                return stats.getFunctionExecutionsCompletedDN() == 0;
            }

            public String description() {
                return "waiting for DAP call statistic on data node";
            }
        };
        ProcedureTestDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)waitForStat, (long)60000L, (long)500L, (boolean)false);
        FunctionStats stats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)iDS);
        if (stats.getFunctionExecutionsCompletedDN() == 0) {
            return false;
        }
        return true;
    }

    public static final void checkStackOverflow(int arg, ResultSet[] rs) throws SQLException {
        if (arg == 0) {
            Connection conn = DriverManager.getConnection("jdbc:default:connection");
            rs[0] = conn.createStatement().executeQuery("<local> select count(*) from simple_table");
        } else {
            ProcedureTestDUnit.checkStackOverflow(arg - 1, rs);
        }
    }

    public static void retrieveDynamicResults(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void retrieveDynamicResultsWithGlobalEscape(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("<GLOBAL> SELECT * FROM EMP.PARTITIONTESTTABLE ");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("<GLOBAL> SELECT * FROM EMP.PARTITIONTESTTABLE ");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("<GLOBAL> SELECT * FROM EMP.PARTITIONTESTTABLE ");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("<GLOBAL> SELECT * FROM EMP.PARTITIONTESTTABLE ");
        }
    }

    public static void retrieveDynamicResultsWithLocalEscape(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("<LOCAL> SELECT * FROM EMP.PARTITIONTESTTABLE WHERE ID=5");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("<LOCAL> SELECT * FROM EMP.PARTITIONTESTTABLE WHERE ID=5");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("<LOCAL> SELECT * FROM EMP.PARTITIONTESTTABLE WHERE ID=5");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("<LOCAL> SELECT * FROM EMP.PARTITIONTESTTABLE WHERE ID=5");
        }
    }

    public static void procedureWithInAndOutParameters(int number, String[] name, int[] total, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        name[0] = name[0] + "Modified";
        total[0] = number;
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void procedureWithoutDynamicResultSets(int number, String[] name) throws SQLException {
        name[0] = name[0] + number;
    }

    public static void procedureWithoutDynamicResultSetsAndOutParameters(int number, String name) throws SQLException {
    }

    public static void retrieveDynamicResultsWithOutgoingResultSet(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ProcedureExecutionContext pec) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            OutgoingResultSet ors = pec.getOutgoingResultSet(2);
            for (int i = 0; i < 10; ++i) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Integer(i));
                row.add("String" + i);
                ors.addRow(row);
            }
            ors.endResults();
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        c.close();
    }

    public static void retrieveClosedResult(ResultSet[] closed2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        closed2[0] = c.createStatement().executeQuery("VALUES(1)");
        closed2[0].close();
    }

    public static void retrieveExternalResult(String dbName, String user, String password, ResultSet[] external) throws SQLException {
        String url = "jdbc:derby:" + dbName;
        Connection conn = DriverManager.getConnection(url, user, password);
        external[0] = conn.createStatement().executeQuery("VALUES(1)");
    }

    public static void procWithSideEffects(int returnResults, ResultSet[] rs1, ResultSet[] rs2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = c.createStatement();
        stmt.executeUpdate("INSERT INTO SIMPLE_TABLE VALUES (42)");
        if (returnResults > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (returnResults > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void nestedDynamicResultSets(String procedureText, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ResultSet[] rs5, ResultSet[] rs6) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        CallableStatement cs = c.prepareCall("CALL " + procedureText);
        cs.execute();
        rs6[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs3[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs4[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs2[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs1[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs5[0] = cs.getResultSet();
    }

    private void setup() throws Exception {
        this.setupVMs();
        this.setupData();
        this.setupTablesAndProcedures();
    }

    private void setupVMs() throws Exception {
        this.startVMs(1, 2);
    }

    private void setupData() throws Exception {
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID))");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE VALUES (4, 4, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE VALUES (5, 5, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '2') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4') ");
        this.clientSQLExecute(1, "SELECT * FROM EMP.PARTITIONTESTTABLE WHERE (SECONDID=10 AND THIRDID='20') OR (SECONDID=10 AND THIRDID='20')");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE1 (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (3, 3, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (4, 4, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (5, 5, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '2') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '4') ");
        this.clientSQLExecute(1, "create table EMP.PARTITIONRANGETESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 10, VALUES BETWEEN 10 and 20, VALUES BETWEEN 20 and 30, VALUES BETWEEN 30 and 40 )");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (1, 2, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (10, 3, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (15, 4, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (21, 5, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (30, 2, '2') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (35, 2, '4') ");
        this.clientSQLExecute(1, "create table EMP.PARTITIONLISTTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY LIST ( ID ) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (0, 2, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (5, 3, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (15, 4, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (20, 4, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (30, 5, '3') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (31, 2, '2') ");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (25, 2, '4') ");
        this.clientSQLExecute(1, "create table EMP.PARTITIONEMPTYTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN ( ID )");
    }

    private void setupTablesAndProcedures() throws Exception {
        int i;
        for (i = 0; i < PROCEDURES.length; ++i) {
            this.clientSQLExecute(1, PROCEDURES[i]);
        }
        for (i = 0; i < TABLES.length; ++i) {
            this.clientSQLExecute(1, TABLES[i][1]);
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall(sql);
        return cs;
    }
}

