/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dataawareprocedure;

import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureExecutionContextImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import io.snappydata.test.dunit.VM;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;

public class ProcedureTest2DUnit
extends DistributedSQLTestBase {
    private static String[] colocatedTableNames;
    private static String filter;
    private static String procedureName;
    private static String tableName;
    private static final int onTable = 0;
    private static final int onAll = 1;
    private static final int onServerGroups = 2;
    private static final int noOnClause = 3;
    public static final int onTableNoWhereClause = 5;

    public ProcedureTest2DUnit(String name) {
        super(name);
    }

    public static void setStaticValues(String[] ctns, String filt, String procName, String tabName) {
        ProcedureTest2DUnit.getGlobalLogger().info((Object)("setStaticValues called with ctns: " + ctns + ", filt: " + filt + ", procName: " + procName + ", tabName: " + tabName));
        colocatedTableNames = ctns;
        filter = filt;
        procedureName = procName;
        tableName = tabName;
    }

    private static void checkPECsAPIs(ProcedureExecutionContext pec) {
        String[] colnames = pec.getColocatedTableNames();
        ProcedureTest2DUnit.getGlobalLogger().info((Object)("static Values and corresponding from contexts are ctns: " + colocatedTableNames + ", from context: " + pec.getColocatedTableNames() + ", filt: " + filter + " from context: " + pec.getFilter() + ", procName: " + procedureName + " from context: " + pec.getProcedureName() + ", tabName: " + tableName + " from context: " + pec.getTableName()));
        if (colocatedTableNames == null) {
            ProcedureTest2DUnit.assertNull((Object)colnames);
        } else {
            int len = colnames.length;
            ProcedureTest2DUnit.assertEquals((int)len, (int)colocatedTableNames.length);
            for (int i = 0; i < len; ++i) {
                String name = colnames[i];
                boolean found = false;
                for (int j = 0; j < len; ++j) {
                    if (!name.equalsIgnoreCase(colocatedTableNames[j])) continue;
                    found = true;
                    break;
                }
                ProcedureTest2DUnit.assertTrue((boolean)found);
            }
        }
        String filt = pec.getFilter();
        if (filt == null) {
            ProcedureTest2DUnit.assertNull((Object)filter);
        } else {
            ProcedureTest2DUnit.assertTrue((boolean)filt.equalsIgnoreCase(filter));
        }
        String procName = pec.getProcedureName();
        if (procName == null) {
            ProcedureTest2DUnit.assertNull((Object)procedureName);
        } else {
            ProcedureTest2DUnit.assertTrue((boolean)procName.equalsIgnoreCase(procedureName));
        }
        String tabName = pec.getTableName();
        if (tabName == null) {
            ProcedureTest2DUnit.assertNull((Object)tableName);
        } else {
            ProcedureTest2DUnit.assertTrue((boolean)tabName.equalsIgnoreCase(tableName));
        }
    }

    public static void checkPECsAPIs_one(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ProcedureExecutionContext pec) throws SQLException {
        ProcedureTest2DUnit.assertTrue((boolean)pec.isPartitioned("DAP.T1_PARTITIONED"));
        ProcedureTest2DUnit.assertFalse((boolean)pec.isPartitioned("DAP.T2_REPLICATE"));
        String userName = pec.getConnection().getMetaData().getUserName();
        ProcedureTest2DUnit.getGlobalLogger().info((Object)("checkPECsAPIs_one username: " + userName));
        ProcedureTest2DUnit.checkPECsAPIs(pec);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall(sql);
        return cs;
    }

    public void testExecuteOnServerGroupProcedureCall() throws Exception {
        this.startServerVMs(1, 0, "SG2");
        this.startClientVMs(1, 0, null);
        VM vm = (VM)this.serverVMs.get(0);
        vm.invoke(ProcedureTest2DUnit.class, "setStaticValues", new Object[]{null, null, "checkPECsAPIs_one", null});
        this.clientSQLExecute(1, "CREATE schema dap");
        this.clientSQLExecute(1, "CREATE table dap.t1_partitioned(field1 int not null primary key, field2 varchar(20) not null)");
        this.clientSQLExecute(1, "CREATE table dap.t2_replicate(field1 int not null primary key, field2 varchar(20) not null) replicate");
        this.clientSQLExecute(1, "CREATE table t1_partitioned(field1 int not null primary key, field2 varchar(20) not null)");
        this.clientSQLExecute(1, "CREATE table t2_replicate(field1 int not null primary key, field2 varchar(20) not null) replicate");
        this.clientSQLExecute(1, "CREATE PROCEDURE proc_num_one(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest2DUnit.class.getName() + ".checkPECsAPIs_one' " + "DYNAMIC RESULT SETS 4");
        CallableStatement cs = this.prepareCall("CALL proc_num_one(?) ON SERVER GROUPS (sg2)");
        cs.setInt(1, 3);
        cs.execute();
    }

    private static String getInvocationType(int invocationType) {
        switch (invocationType) {
            case 0: {
                return "onTable";
            }
            case 1: {
                return "onAll";
            }
            case 2: {
                return "onServerGroups";
            }
            case 3: {
                return "noOnClause";
            }
            case 5: {
                return "onTableNoWhereClause";
            }
        }
        return "unknown";
    }

    public void testExecuteOnTableWithWhereClauseAndLocalAndGlobalEscape() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 ) redundancy 2");
        this.clientSQLExecute(1, "insert into emp.partitiontesttable values (20, 'r1'), (50, 'r2'), (30, 'r1'), (70, 'r3')");
        this.clientSQLExecute(1, "CREATE PROCEDURE MY_ESCAPE_SELECT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest2DUnit.class.getName() + ".select_proc' " + "DYNAMIC RESULT SETS 4");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("CALL MY_ESCAPE_SELECT(?) ON TABLE EMP.PARTITIONTESTTABLE where ID >= 20 and ID < 40");
        cs.setInt(1, 0);
        cs.execute();
        int escapeSeq = 0;
        do {
            ResultSet rs = cs.getResultSet();
            this.getLogWriter().info((Object)("result set no: " + escapeSeq));
            this.getLogWriter().info((Object)"*********************");
            int totalRows = 0;
            HashSet<String> rows = new HashSet<String>();
            while (rs.next()) {
                String row = rs.getInt(1) + ", " + rs.getString(2);
                this.getLogWriter().info((Object)row);
                ++totalRows;
                rows.add(row);
            }
            this.getLogWriter().info((Object)"*********************");
            switch (escapeSeq) {
                case 0: {
                    ProcedureTest2DUnit.assertEquals((int)2, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)2, (int)rows.size());
                    break;
                }
                case 1: {
                    ProcedureTest2DUnit.assertEquals((int)2, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)2, (int)rows.size());
                    break;
                }
                case 2: {
                    ProcedureTest2DUnit.assertEquals((int)2, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)2, (int)rows.size());
                    break;
                }
            }
            ++escapeSeq;
        } while (cs.getMoreResults());
    }

    public void testExecuteOnTableWithNoWhereClauseAndLocalAndGlobalEscape() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 ) redundancy 2");
        this.clientSQLExecute(1, "insert into emp.partitiontesttable values (20, 'r1'), (50, 'r2'), (30, 'r1'), (70, 'r3')");
        this.clientSQLExecute(1, "CREATE PROCEDURE MY_ESCAPE_SELECT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest2DUnit.class.getName() + ".select_proc' " + "DYNAMIC RESULT SETS 4");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("CALL MY_ESCAPE_SELECT(?) ON TABLE EMP.PARTITIONTESTTABLE");
        cs.setInt(1, 5);
        cs.execute();
        int escapeSeq = 0;
        do {
            ResultSet rs = cs.getResultSet();
            this.getLogWriter().info((Object)("result set no: " + escapeSeq));
            this.getLogWriter().info((Object)"*********************");
            int totalRows = 0;
            HashSet<String> rows = new HashSet<String>();
            while (rs.next()) {
                String row = rs.getInt(1) + ", " + rs.getString(2);
                this.getLogWriter().info((Object)row);
                ++totalRows;
                rows.add(row);
            }
            this.getLogWriter().info((Object)"*********************");
            switch (escapeSeq) {
                case 0: {
                    ProcedureTest2DUnit.assertEquals((int)12, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 1: {
                    ProcedureTest2DUnit.assertEquals((int)4, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 2: {
                    ProcedureTest2DUnit.assertEquals((int)12, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
            }
            ++escapeSeq;
        } while (cs.getMoreResults());
    }

    public static void select_proc(int invocationType, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ProcedureExecutionContext pec) throws SQLException {
        ProcedureTest2DUnit.getGlobalLogger().info((Object)("select_proc called with invocation type: " + ProcedureTest2DUnit.getInvocationType(invocationType) + " and pec: " + pec));
        ProcedureExecutionContextImpl cimpl = (ProcedureExecutionContextImpl)pec;
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        ProcedureTest2DUnit.getGlobalLogger().info((Object)("from pec tablename is: " + pec.getTableName()));
        if (cimpl.getTableName() != null) {
            ProcedureTest2DUnit.assertTrue((boolean)cimpl.getTableName().equalsIgnoreCase("emp.partitiontestTable"));
        }
        String filter = " where " + cimpl.getFilter();
        String sql = "select * from emp.partitiontestTable";
        String local_sql = "";
        String global_sql = "";
        String default_sql = "";
        switch (invocationType) {
            case 0: {
                filter = " where " + cimpl.getFilter();
                sql = sql + " " + filter;
                local_sql = "<LOCAL> " + sql;
                global_sql = "<GLOBAL> " + sql;
                default_sql = sql;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                local_sql = "<LOCAL> " + sql;
                global_sql = "<GLOBAL> " + sql;
                default_sql = sql;
                break;
            }
        }
        ProcedureTest2DUnit.getGlobalLogger().info((Object)("select_proc def sql is: " + sql + " local sql is: " + local_sql + " and global sql is: " + global_sql));
        rs1[0] = c.createStatement().executeQuery(default_sql);
        rs2[0] = c.createStatement().executeQuery(local_sql);
        rs3[0] = c.createStatement().executeQuery(global_sql);
    }

    public void testExecuteOnAllAndLocalAndGlobalEscape() throws Exception {
        ResultSet rs;
        this.startVMs(1, 3);
        this.serverSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 ) redundancy 2");
        this.clientSQLExecute(1, "insert into emp.partitiontesttable values (20, 'r1'), (50, 'r2'), (30, 'r1'), (70, 'r3')");
        this.serverSQLExecute(1, "CREATE PROCEDURE MY_ESCAPE_SELECT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest2DUnit.class.getName() + ".select_proc' " + "DYNAMIC RESULT SETS 4");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("CALL MY_ESCAPE_SELECT(?) ON ALL");
        cs.setInt(1, 1);
        cs.execute();
        int escapeSeq = 0;
        do {
            rs = cs.getResultSet();
            this.getLogWriter().info((Object)("result set no: " + escapeSeq));
            this.getLogWriter().info((Object)"*********************");
            ResultSetMetaData rsmd = rs.getMetaData();
            this.getLogWriter().info((Object)("metadata: " + rsmd.getColumnCount()));
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                this.getLogWriter().info((Object)("metadata: " + rsmd.getColumnName(col) + '[' + rsmd.getColumnType(col) + ']'));
            }
            int totalRows = 0;
            HashSet<String> rows = new HashSet<String>();
            while (rs.next()) {
                String row = rs.getInt(1) + ", " + rs.getString(2);
                this.getLogWriter().info((Object)row);
                ++totalRows;
                rows.add(row);
            }
            this.getLogWriter().info((Object)"*********************");
            switch (escapeSeq) {
                case 0: {
                    ProcedureTest2DUnit.assertEquals((int)16, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 1: {
                    ProcedureTest2DUnit.assertEquals((int)4, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 2: {
                    ProcedureTest2DUnit.assertEquals((int)16, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
            }
            ++escapeSeq;
        } while (cs.getMoreResults());
        cs.close();
        conn.close();
        int clientPort = this.startNetworkServer(1, null, null);
        this.startNetworkServer(3, null, null);
        conn = TestUtil.getNetConnection(clientPort, null, null);
        cs = conn.prepareCall("CALL MY_ESCAPE_SELECT(?) ON ALL");
        cs.setInt(1, 1);
        cs.execute();
        escapeSeq = 0;
        do {
            rs = cs.getResultSet();
            this.getLogWriter().info((Object)("result set no: " + escapeSeq));
            this.getLogWriter().info((Object)"*********************");
            ResultSetMetaData rsmd = rs.getMetaData();
            this.getLogWriter().info((Object)("metadata: " + rsmd.getColumnCount()));
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                this.getLogWriter().info((Object)("metadata: " + rsmd.getColumnName(col) + '[' + rsmd.getColumnType(col) + ']'));
            }
            int totalRows = 0;
            HashSet<String> rows = new HashSet<String>();
            while (rs.next()) {
                String row = rs.getInt(1) + ", " + rs.getString(2);
                this.getLogWriter().info((Object)row);
                ++totalRows;
                rows.add(row);
            }
            this.getLogWriter().info((Object)"*********************");
            switch (escapeSeq) {
                case 0: {
                    ProcedureTest2DUnit.assertEquals((int)16, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 1: {
                    ProcedureTest2DUnit.assertEquals((int)4, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 2: {
                    ProcedureTest2DUnit.assertEquals((int)16, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
            }
            ++escapeSeq;
        } while (cs.getMoreResults());
        cs.close();
        conn.close();
    }

    public void testExecuteOnServerGroupsAndLocalAndGlobalEscape() throws Exception {
        this.startServerVMs(2, 0, "SG2");
        this.startServerVMs(1, 0, null);
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema EMP default server groups (SG2)");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 ) redundancy 2");
        this.clientSQLExecute(1, "insert into emp.partitiontesttable values (20, 'r1'), (50, 'r2'), (30, 'r1'), (70, 'r3')");
        this.clientSQLExecute(1, "CREATE PROCEDURE MY_ESCAPE_SELECT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest2DUnit.class.getName() + ".select_proc' " + "DYNAMIC RESULT SETS 4");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("CALL MY_ESCAPE_SELECT(?) ON server groups (sg2)");
        cs.setInt(1, 2);
        cs.execute();
        int escapeSeq = 0;
        do {
            ResultSet rs = cs.getResultSet();
            this.getLogWriter().info((Object)("result set no: " + escapeSeq));
            this.getLogWriter().info((Object)"*********************");
            ResultSetMetaData rsmd = rs.getMetaData();
            this.getLogWriter().info((Object)("metadata: " + rsmd.getColumnCount()));
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                this.getLogWriter().info((Object)("metadata: " + rsmd.getColumnName(col) + '[' + rsmd.getColumnType(col) + ']'));
            }
            int totalRows = 0;
            HashSet<String> rows = new HashSet<String>();
            while (rs.next()) {
                String row = rs.getInt(1) + ", " + rs.getString(2);
                this.getLogWriter().info((Object)row);
                ++totalRows;
                rows.add(row);
            }
            this.getLogWriter().info((Object)"*********************");
            switch (escapeSeq) {
                case 0: {
                    ProcedureTest2DUnit.assertEquals((int)8, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 1: {
                    ProcedureTest2DUnit.assertEquals((int)4, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 2: {
                    ProcedureTest2DUnit.assertEquals((int)8, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
            }
            ++escapeSeq;
        } while (cs.getMoreResults());
    }

    public void testExecuteAndLocalAndGlobalEscape() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 ) redundancy 2");
        this.clientSQLExecute(1, "insert into emp.partitiontesttable values (20, 'r1'), (50, 'r2'), (30, 'r1'), (70, 'r3')");
        this.clientSQLExecute(1, "CREATE PROCEDURE MY_ESCAPE_SELECT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest2DUnit.class.getName() + ".select_proc' " + "DYNAMIC RESULT SETS 4");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("CALL MY_ESCAPE_SELECT(?)");
        cs.setInt(1, 3);
        cs.execute();
        int escapeSeq = 0;
        do {
            ResultSet rs = cs.getResultSet();
            this.getLogWriter().info((Object)("result set no: " + escapeSeq));
            this.getLogWriter().info((Object)"*********************");
            int totalRows = 0;
            HashSet<String> rows = new HashSet<String>();
            while (rs.next()) {
                String row = rs.getInt(1) + ", " + rs.getString(2);
                this.getLogWriter().info((Object)row);
                ++totalRows;
                rows.add(row);
            }
            this.getLogWriter().info((Object)"*********************");
            switch (escapeSeq) {
                case 0: {
                    ProcedureTest2DUnit.assertEquals((int)4, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
                case 1: {
                    ProcedureTest2DUnit.assertEquals((int)0, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)0, (int)rows.size());
                    break;
                }
                case 2: {
                    ProcedureTest2DUnit.assertEquals((int)4, (int)totalRows);
                    ProcedureTest2DUnit.assertEquals((int)4, (int)rows.size());
                    break;
                }
            }
            ++escapeSeq;
        } while (cs.getMoreResults());
    }

    public static void txn_proc(int number, ProcedureExecutionContext context) throws SQLException {
        Connection c = context.getConnection();
        GemFireTransaction gftxn = (GemFireTransaction)((EmbedConnection)c).getLanguageConnectionContext().getTransactionExecute();
        TXId txid = gftxn.getActiveTXState().getTransactionId();
        ProcedureTest2DUnit.getGlobalLogger().info((Object)("from proc txid is: " + txid));
    }

    public void testTxn() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 59, VALUES BETWEEN 60 and 80 ) redundancy 2");
        this.clientSQLExecute(1, "insert into emp.partitiontesttable values (20, 'r1'), (50, 'r2'), (30, 'r1'), (70, 'r3')");
        this.clientSQLExecute(1, "CREATE PROCEDURE MY_TXN_PROC(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest2DUnit.class.getName() + ".txn_proc'");
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(2);
        TXId txid = TXManagerImpl.getCurrentTXId();
        this.getLogWriter().info((Object)("in controller txid is: " + txid));
        CallableStatement cs = conn.prepareCall("CALL MY_TXN_PROC(?) ON ALL");
        cs.setInt(1, 10);
        cs.execute();
        conn.commit();
    }
}

