/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.dataawareprocedure;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import junit.framework.TestCase;

public class ListAggDUnit
extends DistributedSQLTestBase {
    private final String importOraJar = TestUtil.getResourcesDir() + "/lib/import.jar";
    private final String dataFile = TestUtil.getResourcesDir() + "/lib/fedexDataFile.dat";
    static volatile boolean failed = false;
    static final int numTimesEachThread = 100;
    static final int numThreads = 20;
    static volatile Exception exceptiongot = null;

    public ListAggDUnit(String name) {
        super(name);
    }

    protected String reduceLogLevel() {
        return "config";
    }

    public void testDummy() {
    }

    public void _testListAggUnderLoad() throws Exception {
        this.startVMs(1, 4);
        this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        this.startNetworkServer(3, null, null);
        this.startNetworkServer(4, null, null);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        String createTableddl = "CREATE TABLE CDSDBA.XML_DOC_1 ( XML_DOC_ID_NBR DECIMAL(19) NOT NULL, STRUCTURE_ID_NBR DECIMAL(22) NOT NULL, CREATE_MINT_CD CHAR(1) NOT NULL, MSG_PAYLOAD_QTY DECIMAL(22) NOT NULL, MSG_PAYLOAD1_IMG BLOB(2000) NOT NULL, MSG_PAYLOAD2_IMG BLOB(2000), MSG_PAYLOAD_SIZE_NBR DECIMAL(22), MSG_PURGE_DT DATE, DELETED_FLG CHAR(1) NOT NULL, LAST_UPDATE_SYSTEM_NM VARCHAR(30), LAST_UPDATE_TMSTP TIMESTAMP NOT NULL, MSG_MAJOR_VERSION_NBR DECIMAL(22), MSG_MINOR_VERSION_NBR DECIMAL(22), OPT_LOCK_TOKEN_NBR DECIMAL(22) DEFAULT 1, PRESET_DICTIONARY_ID_NBR DECIMAL(22) DEFAULT 0 NOT NULL ) PARTITION BY COLUMN (STRUCTURE_ID_NBR) REDUNDANCY 1 ";
        String indexsql = "CREATE UNIQUE INDEX CDSDBA.XML_DOC_1_UK1 ON CDSDBA.XML_DOC_1(XML_DOC_ID_NBR,STRUCTURE_ID_NBR)";
        s.execute(createTableddl);
        s.execute(indexsql);
        s.execute("call sqlj.install_jar('" + this.importOraJar + "', 'importOra', 0)");
        String createProcSql = "CREATE PROCEDURE CDSDBA.ListAgg(IN groupBy VARCHAR(256), IN ListAggCols VARCHAR(256), IN tableName VARCHAR(128), IN whereClause VARCHAR(256), IN whereParams VARCHAR(256), IN delimiter VARCHAR(10)) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.gemfirexd.dataawareprocedure.listAgg.ListAggProcedure.ListAgg'";
        String createAliasSQL = "CREATE ALIAS ListAggProcessor FOR 'com.pivotal.gemfirexd.dataawareprocedure.listAgg.LISTAGGPROCESSOR'";
        s.execute(createProcSql);
        s.execute(createAliasSQL);
        s.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX('CDSDBA','XML_DOC_1', '" + this.dataFile + "', '|', " + "NULL, NULL, 0, 0 /* don't lock the table */, " + "6 /* number of threads */, 0, " + "'ImportOra' /* the Import class implementation*/, NULL)");
        Thread[] threads = new Thread[20];
        for (int i = 0; i < 20; ++i) {
            threads[i] = new Thread(new RunListAggAndVerify());
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        if (exceptiongot != null) {
            ListAggDUnit.fail("test failed due to exception ", exceptiongot);
        }
        ListAggDUnit.assertFalse((String)"test failed", (boolean)failed);
    }

    static class RunListAggAndVerify
    implements Runnable {
        private static final String callProcStr = "CALL CDSDBA.ListAgg('structure_id_nbr DESC','create_mint_cd','CDSDBA.XML_DOC_1','MSG_PAYLOAD_QTY=?','5',',') WITH RESULT PROCESSOR ListAggProcessor ON TABLE CDSDBA.XML_DOC_1;";
        Connection conn;
        CallableStatement callableStmt;

        RunListAggAndVerify() {
        }

        @Override
        public void run() {
            try {
                int cnt = -1;
                while (cnt++ < 100) {
                    if (this.conn == null) {
                        this.conn = TestUtil.getConnection();
                        this.callableStmt = this.conn.prepareCall(callProcStr);
                    }
                    this.callableStmt.execute();
                    this.verifyResults();
                }
            }
            catch (Exception ex) {
                failed = true;
                exceptiongot = ex;
            }
        }

        private void verifyResults() throws Exception {
            ResultSet thisResultSet = this.callableStmt.getResultSet();
            ResultSetMetaData resultMetaData = thisResultSet.getMetaData();
            resultMetaData.getColumnCount();
            TestCase.assertTrue((thisResultSet != null ? 1 : 0) != 0);
            while (thisResultSet.next()) {
            }
        }
    }
}

