/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.consistency;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derbyTesting.junit.JDBC;

public class TableIndicesConsistencyDUnit
extends DistributedSQLTestBase {
    public TableIndicesConsistencyDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnPartitionTable() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRD int not null Unique, FOURTH int not null, FIFTH int not null Unique, primary key (ID, SECONDID)) PARTITION BY COLUMN (ID)");
        this.clientSQLExecute(1, "create index fourth_index on EMP.PARTITIONTESTTABLE (FOURTH)");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE values(1,2,3,4, 10)");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE values(4,5,6,4, 11)");
        this.clientSQLExecute(1, "INSERT INTO EMP.PARTITIONTESTTABLE values(7,8,9,4, 12)");
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.checkKeyViolation(1, "INSERT INTO EMP.PARTITIONTESTTABLE values(1,3,3,4,13)");
        this.checkKeyViolation(-1, "INSERT INTO EMP.PARTITIONTESTTABLE values(1,3,3,4,13)");
        this.checkKeyViolation(-2, "INSERT INTO EMP.PARTITIONTESTTABLE values(1,3,3,4,13)");
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','PARTITIONTESTTABLE')", null, "1");
        ResultSet rs = null;
        PreparedStatement ps = null;
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.PARTITIONTESTTABLE where id=1 and secondid=3");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        String[][] expectedRows = new String[][]{{"1", "2", "3", "4", "10"}};
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.PARTITIONTESTTABLE where THIRD=3");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "Select * from EMP.PARTITIONTESTTABLE where FOURTH=4", TestUtil.getResourcesDir() + "/lib/checkTableIndicesConsistency.xml", "rs1");
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.checkKeyViolation(1, "INSERT INTO EMP.PARTITIONTESTTABLE values(1,2,5,4,13)");
        this.checkKeyViolation(-1, "INSERT INTO EMP.PARTITIONTESTTABLE values(1,2,5,4,13)");
        this.checkKeyViolation(-2, "INSERT INTO EMP.PARTITIONTESTTABLE values(1,2,5,4,13)");
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','PARTITIONTESTTABLE')", null, "1");
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.PARTITIONTESTTABLE where id=1 and secondid=2");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.PARTITIONTESTTABLE where THIRD=5");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "Select * from EMP.PARTITIONTESTTABLE where FOURTH=4", TestUtil.getResourcesDir() + "/lib/checkTableIndicesConsistency.xml", "rs1");
        try {
            this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
            this.checkKeyViolation(1, "UPDATE EMP.PARTITIONTESTTABLE SET third=6, fifth=20 where id=1 and secondid=2");
            this.checkKeyViolation(-1, "UPDATE EMP.PARTITIONTESTTABLE SET third=6, fifth=20 where id=1 and secondid=2");
            this.checkKeyViolation(-2, "UPDATE EMP.PARTITIONTESTTABLE SET third=6, fifth=20 where id=1 and secondid=2");
        }
        catch (Throwable throwable) {
            this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
            throw throwable;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','PARTITIONTESTTABLE')", null, "1");
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.PARTITIONTESTTABLE where id=1 and secondid=2");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.PARTITIONTESTTABLE where THIRD=5");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "Select * from EMP.PARTITIONTESTTABLE where FOURTH=4", TestUtil.getResourcesDir() + "/lib/checkTableIndicesConsistency.xml", "rs1");
        this.clientSQLExecute(1, "DELETE FROM EMP.PARTITIONTESTTABLE WHERE id=1");
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','PARTITIONTESTTABLE')", null, "1");
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.PARTITIONTESTTABLE where id=1 and secondid=2");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        this.clientSQLExecute(1, "drop table EMP.PARTITIONTESTTABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnReplicateTable() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table EMP.REPLICATETABLE (ID int not null,  SECONDID int not null, THIRD int not null, FOURTH int not null, FIFTH int not null, primary key (SECONDID)) REPLICATE");
        this.clientSQLExecute(1, "create unique index third_index on EMP.REPLICATETABLE (THIRD)");
        this.clientSQLExecute(1, "create index fourth_index on EMP.REPLICATETABLE (FOURTH)");
        this.clientSQLExecute(1, "create unique index fifth_index on EMP.REPLICATETABLE (fifth)");
        this.clientSQLExecute(1, "INSERT INTO EMP.REPLICATETABLE values(1,2,3,4, 10)");
        this.clientSQLExecute(1, "INSERT INTO EMP.REPLICATETABLE values(4,5,6,4, 11)");
        this.clientSQLExecute(1, "INSERT INTO EMP.REPLICATETABLE values(7,8,9,4, 12)");
        try {
            this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{EntryExistsException.class, FunctionExecutionException.class});
            this.checkKeyViolation(1, "INSERT INTO EMP.REPLICATETABLE values(1,3,3,4,13)");
            this.checkKeyViolation(-1, "INSERT INTO EMP.REPLICATETABLE values(1,3,3,4,13)");
            this.checkKeyViolation(-2, "INSERT INTO EMP.REPLICATETABLE values(1,3,3,4,13)");
        }
        catch (Throwable throwable) {
            this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class});
            throw throwable;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class});
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','REPLICATETABLE')", null, "1");
        ResultSet rs = null;
        PreparedStatement ps = null;
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.REPLICATETABLE where id=1 and secondid=3");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        String[][] expectedRows = new String[][]{{"1", "2", "3", "4", "10"}};
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.REPLICATETABLE where THIRD=3");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "Select * from EMP.REPLICATETABLE where FOURTH=4", TestUtil.getResourcesDir() + "/lib/checkTableIndicesConsistency.xml", "rs1");
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.checkKeyViolation(1, "INSERT INTO EMP.REPLICATETABLE values(1,2,5,4,13)");
        this.checkKeyViolation(-1, "INSERT INTO EMP.REPLICATETABLE values(1,2,5,4,13)");
        this.checkKeyViolation(-2, "INSERT INTO EMP.REPLICATETABLE values(1,2,5,4,13)");
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','REPLICATETABLE')", null, "1");
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.REPLICATETABLE where id=1 and secondid=2");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.REPLICATETABLE where THIRD=5");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "Select * from EMP.REPLICATETABLE where FOURTH=4", TestUtil.getResourcesDir() + "/lib/checkTableIndicesConsistency.xml", "rs1");
        try {
            this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
            this.checkKeyViolation(1, "UPDATE EMP.REPLICATETABLE SET third=6, fifth=20 where id=1 and secondid=2");
            this.checkKeyViolation(-1, "UPDATE EMP.REPLICATETABLE SET third=6, fifth=20 where id=1 and secondid=2");
            this.checkKeyViolation(-2, "UPDATE EMP.REPLICATETABLE SET third=6, fifth=20 where id=1 and secondid=2");
        }
        catch (Throwable throwable) {
            this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
            throw throwable;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{FunctionExecutionException.class, EntryExistsException.class});
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','REPLICATETABLE')", null, "1");
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.REPLICATETABLE where id=1 and secondid=2");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.REPLICATETABLE where THIRD=5");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "Select * from EMP.REPLICATETABLE where FOURTH=4", TestUtil.getResourcesDir() + "/lib/checkTableIndicesConsistency.xml", "rs1");
        this.clientSQLExecute(1, "DELETE FROM EMP.REPLICATETABLE WHERE id=1");
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('EMP','REPLICATETABLE')", null, "1");
        ps = TestUtil.jdbcConn.prepareStatement("Select * from EMP.REPLICATETABLE where id=1 and secondid=2");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 0);
        this.clientSQLExecute(1, "drop table EMP.REPLICATETABLE");
    }
}

