/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.log4j.Logger;

public class ToursDBUtil {
    public static void createAndLoadToursDB(Connection conn) throws SQLException {
        String[] quickstartScripts = new String[]{"ToursDB_schema.sql", "create_colocated_schema.sql", "loadCOUNTRIES.sql", "loadCITIES.sql", "loadAIRLINES.sql", "loadFLIGHTS1.sql", "loadFLIGHTS2.sql", "loadFLIGHTAVAILABILITY1.sql", "loadFLIGHTAVAILABILITY2.sql"};
        File qsDir = ToursDBUtil.getQuickstartDir();
        String[] scriptPaths = new String[quickstartScripts.length];
        for (int i = 0; i < scriptPaths.length; ++i) {
            scriptPaths[i] = new File(qsDir, quickstartScripts[i]).toString();
        }
        ToursDBUtil.executeSQLScripts(conn, scriptPaths);
        Statement s = conn.createStatement();
        Assert.assertEquals((int)87, (int)JDBC.assertDrainResults(s.executeQuery("SELECT * FROM CITIES")));
    }

    private static void executeSQLScripts(Connection conn, String[] scripts) {
        try {
            GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])scripts, (boolean)false, (Logger)TestUtil.getLogger(), null, null, (boolean)false);
            conn.commit();
        }
        catch (Exception e) {
            AssertionError ae = new AssertionError((Object)"unexpected exception");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public static File getQuickstartDir() {
        String productDir = System.getProperty("GEMFIREXD");
        return new File(productDir, "quickstart");
    }
}

