/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.GemFireTestCase;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.UserSpecifiedRegionAttributes;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.OSType;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransactionContext;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeap;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalHashIndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.Hash1IndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.Scan;
import io.snappydata.test.dunit.DistributedTestBase;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestUtil
extends TestCase {
    private static final String driver = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    private static final String netDriver = "com.pivotal.gemfirexd.jdbc.ClientDriver";
    private static final String protocol = "jdbc:gemfirexd:";
    private static final String odbcBridge = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String USE_ODBC_BRIDGE_PROP = "test.use-odbc-bridge";
    public static final boolean USE_ODBC_BRIDGE = TestConfiguration.USE_ODBC_BRIDGE;
    public static Connection jdbcConn = null;
    public static final Logger globalLogger = LogManager.getLogger(TestUtil.class);
    public final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private static Map<String, Integer> expectedExceptions = new HashMap<String, Integer>();
    public static final String EXPECTED_STARTUP_EXCEPTIONS = "test.expected-startup-exceptions";
    public static String currentTest = null;
    public static Class<?> currentTestClass = null;
    public static String currentUserName = null;
    public static String bootUserName = null;
    public static String bootUserPassword = null;
    public static String currentUserPassword = null;
    private static final Set<String> initSysProperties;
    public static boolean isTransactional;
    public static volatile boolean deletePersistentFiles;
    public static volatile boolean skipDefaultPartitioned;
    public static final int TEST_DEFAULT_INITIAL_CAPACITY = 5;
    public static final String TEST_SKIP_DEFAULT_INITIAL_CAPACITY = "gemfirexd.test.skip-default-initial-capacity";
    public static final String TEST_FLAG_ENABLE_CONCURRENCY_CHECKS = "gemfirexd.TEST_FLAG_ENABLE_CONCURRENCY_CHECKS";
    private static boolean oldDMVerbose;
    protected static NetworkInterface netServer;
    public static final String EmbeddedeXADsClassName = "com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource";
    public static final String NetClientXADsClassName = "com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource";

    protected TestUtil(String name) {
        super(name);
    }

    protected String reduceLogging() {
        return null;
    }

    protected void reduceLogLevelForTest(String logLevel) {
        TestUtil.reduceLogLevel(logLevel);
    }

    public static final void reduceLogLevel(String logLevel) {
        if (logLevel != null) {
            oldDMVerbose = DistributionManager.VERBOSE;
            if (!logLevel.startsWith("fine")) {
                DistributionManager.VERBOSE = false;
                System.setProperty("DistributionManager.VERBOSE", "false");
            }
            System.setProperty("gemfire.log-level", logLevel);
        } else {
            DistributionManager.VERBOSE = oldDMVerbose;
            System.setProperty("DistributionManager.VERBOSE", Boolean.toString(oldDMVerbose));
            System.clearProperty("gemfire.log-level");
        }
    }

    protected void setUp() throws Exception {
        currentTest = this.getName();
        currentTestClass = this.getTestClass();
        String logLevel = this.reduceLogging();
        if (logLevel != null) {
            this.reduceLogLevelForTest(logLevel);
        }
    }

    protected void tearDown() throws Exception {
        TestUtil.clearStatics();
        TestUtil.deleteDir(new File("datadictionary"));
        TestUtil.deleteDir(new File("globalIndex"));
        TestConfiguration.odbcIni.delete();
        deletePersistentFiles = false;
        skipDefaultPartitioned = false;
        if (this.reduceLogging() != null || System.getProperty("gemfire.log-level") != null) {
            this.reduceLogLevelForTest(null);
        }
    }

    public static void setCurrentTestClass(Class<?> c) {
        currentTestClass = c;
    }

    public static String getDriver() {
        return driver;
    }

    public static String getProtocol() {
        return protocol;
    }

    public static String getNetDriver() {
        return USE_ODBC_BRIDGE ? odbcBridge : netDriver;
    }

    public static Properties getNetProperties(Properties props) {
        if (USE_ODBC_BRIDGE) {
            if (props != null) {
                Properties newProps = new Properties();
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propName = String.valueOf(propNames.nextElement());
                    String propValue = props.getProperty(propName);
                    newProps.setProperty(propName.replace("-", ""), propValue);
                }
                return newProps;
            }
            return null;
        }
        return props;
    }

    public static String getNetProtocol(String hostName, int port) {
        return TestConfiguration.getNetProtocol(hostName, port);
    }

    protected Class<?> getTestClass() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        while (clazz.getDeclaringClass() != null) {
            clazz = clazz.getDeclaringClass();
        }
        return clazz;
    }

    public static DistributedMember setupConnection() throws SQLException {
        InternalDistributedSystem ids;
        if (jdbcConn == null || jdbcConn.isClosed()) {
            TestUtil.loadDriver();
            TestUtil.getConnection();
        }
        if ((ids = InternalDistributedSystem.getConnectedInstance()) != null) {
            return ids.getDistributedMember();
        }
        return null;
    }

    public static DistributedMember setupConnection(Properties props, Class<?> testClass) throws SQLException {
        return TestUtil.setupConnection(props, testClass, null);
    }

    public static DistributedMember setupConnection(Properties props, Class<?> testClass, String testName) throws SQLException {
        if (testClass != null) {
            currentTestClass = testClass;
            if (currentTest == null) {
                currentTest = testName == null ? "testAll" : testName;
            } else if (testName != null) {
                currentTest = testName;
            }
        }
        return TestUtil.setupConnection(props);
    }

    public static DistributedMember setupConnection(Properties props) throws SQLException {
        InternalDistributedSystem ids;
        FabricServer server = FabricServiceManager.getFabricServerInstance();
        if (jdbcConn == null || jdbcConn.isClosed() || server.status() != FabricService.State.RUNNING) {
            jdbcConn = null;
            TestUtil.loadDriver();
            props = TestUtil.doCommonSetup(props);
            Object[] expectedExceptions = (Object[])props.remove(EXPECTED_STARTUP_EXCEPTIONS);
            if (expectedExceptions != null) {
                GemFireStore.EXPECTED_STARTUP_EXCEPTIONS = expectedExceptions;
            }
            server.start(props);
            TestUtil.getLogger().info((Object)("Fabric Server setup connection status : " + server.status()));
            props.remove("rebalance");
            TestUtil.getConnection(props);
            TestUtil.getLogger().info((Object)"Acquired connection ");
        }
        if ((ids = InternalDistributedSystem.getConnectedInstance()) != null) {
            return ids.getDistributedMember();
        }
        return null;
    }

    public static DistributedMember setupConnection(String locatorBindAdress, int locatorPort, String extraLocatorArgs, Properties props) throws SQLException {
        InternalDistributedSystem ids;
        FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
        if (jdbcConn == null || jdbcConn.isClosed() || locator.status() != FabricService.State.RUNNING) {
            jdbcConn = null;
            TestUtil.loadDriver();
            props = TestUtil.doCommonSetup(props);
            Object[] expectedExceptions = (Object[])props.remove(EXPECTED_STARTUP_EXCEPTIONS);
            if (expectedExceptions != null) {
                GemFireStore.EXPECTED_STARTUP_EXCEPTIONS = expectedExceptions;
            }
            locator.start(locatorBindAdress, locatorPort, props);
            TestUtil.getLogger().info((Object)("Fabric Locator setup connection status : " + locator.status()));
            TestUtil.getConnection(props);
            TestUtil.getLogger().info((Object)"Acquired connection ");
        }
        if ((ids = InternalDistributedSystem.getConnectedInstance()) != null) {
            return ids.getDistributedMember();
        }
        return null;
    }

    public static boolean setPropertyIfAbsent(Properties props, String key, String value) {
        if (props == null) {
            if (!key.startsWith("gemfire.") && !key.startsWith(GfxdConstants.GFXD_PREFIX)) {
                key = "gemfire." + key;
            }
            if (System.getProperty(key) == null) {
                System.setProperty(key, value);
                return true;
            }
        } else if (!props.containsKey(key)) {
            props.put(key, value);
            return true;
        }
        return false;
    }

    protected static String getTestName() {
        return currentTestClass.getName() + "-" + currentTest;
    }

    public static Connection getConnection(Properties props) throws SQLException {
        return TestUtil.getConnection(TestUtil.getProtocol(), props);
    }

    public static String getResourcesDir() {
        return GemFireTestCase.getResourcesDir();
    }

    public static String getProcessOutput(Process p, int expectedExitValue, int maxWaitMillis, int[] exitValue) throws IOException, InterruptedException {
        return GemFireTestCase.getProcessOutput((Process)p, (int)expectedExitValue, (int)maxWaitMillis, (int[])exitValue);
    }

    public static Properties doMinimalSetup(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        Object skipSPSPrecompile = props.remove("SKIP_SPS_PRECOMPILE");
        if (GemFireCacheImpl.getInstance() == null) {
            FabricDatabase.SKIP_SPS_PRECOMPILE = skipSPSPrecompile == null || !"false".equalsIgnoreCase(skipSPSPrecompile.toString());
        }
        if (currentTestClass != null && currentTest != null) {
            String testName = TestUtil.getTestName();
            if (TestUtil.setPropertyIfAbsent(props, "log-file", testName + ".log")) {
                TestUtil.setPropertyIfAbsent(null, GfxdConstants.GFXD_LOG_FILE, testName + ".log");
            }
            TestUtil.setPropertyIfAbsent(props, "statistic-archive-file", testName + ".gfs");
            TestUtil.setPropertyIfAbsent(null, "gemfirexd.client.log-file", testName + "-client.log");
        }
        TestUtil.setPropertyIfAbsent(props, "mcast-port", "0");
        return props;
    }

    public static Properties doCommonSetup(Properties props) {
        props = TestUtil.doMinimalSetup(props);
        if (!skipDefaultPartitioned) {
            TestUtil.setPropertyIfAbsent(props, "table-default-partitioned", "true");
        }
        if (System.getProperty("gemfirexd.debug.true") == null) {
            TestUtil.setPropertyIfAbsent(null, "gemfirexd.debug.false", "TraceDDLQueue,QueryDistribution,TraceNCJ,TraceNCJIter,TraceNCJDump,TraceConglomUpdate,TraceByteCompareOptimization,StatementMatching,TraceClientHA,TraceSingleHop");
        }
        TestUtil.setPropertyIfAbsent(props, GfxdConstants.MAX_LOCKWAIT, "60000");
        TestUtil.setPropertyIfAbsent(props, "default-recovery-delay", "1000");
        if (props.remove(TEST_SKIP_DEFAULT_INITIAL_CAPACITY) == null) {
            TestUtil.setPropertyIfAbsent(props, "default-initial-capacity", String.valueOf(5));
        }
        Random rand = PartitionedRegion.rand;
        if (currentUserName != null) {
            if (!props.containsKey("UserName")) {
                TestUtil.setPropertyIfAbsent(props, "user", currentUserName);
            }
            TestUtil.setPropertyIfAbsent(props, "password", currentUserPassword);
        }
        TestUtil.setPropertyIfAbsent(null, "gemfire.prrecovery-close-timeout", "5");
        TestUtil.setPropertyIfAbsent(null, "gemfire.READ_LOCK_TIMEOUT", "100");
        TestUtil.setPropertyIfAbsent(null, "gemfire.LOCK_MAX_TIMEOUT", "20000");
        TestUtil.setPropertyIfAbsent(null, "jline.terminal", "scala.tools.jline.UnsupportedTerminal");
        TestUtil.setPropertyIfAbsent(props, "disable-streaming", Boolean.toString(rand.nextBoolean()));
        if (props.containsKey(TEST_FLAG_ENABLE_CONCURRENCY_CHECKS)) {
            System.setProperty(TEST_FLAG_ENABLE_CONCURRENCY_CHECKS, props.getProperty(TEST_FLAG_ENABLE_CONCURRENCY_CHECKS));
        }
        System.setProperty("gemfire.ALLOW_STANDALONE_HDFS_FILESYSTEM", "true");
        return props;
    }

    public static synchronized Connection getConnection(String protocol, Properties props) throws SQLException {
        TestUtil.loadDriverClass(TestUtil.getDriver());
        props = TestUtil.doCommonSetup(props);
        Connection conn = DriverManager.getConnection(protocol, props);
        if (jdbcConn == null || jdbcConn.isClosed()) {
            jdbcConn = conn;
            currentUserName = props.getProperty("user");
            currentUserName = currentUserName == null ? props.getProperty("UserName") : currentUserName;
            currentUserPassword = props.getProperty("password");
        }
        return conn;
    }

    public static Connection getNetConnection(int port, String urlSuffix, Properties props) throws SQLException {
        return TestUtil.getNetConnection(null, port, urlSuffix, props);
    }

    public static synchronized Connection getNetConnection(String host, int port, String urlSuffix, Properties props) throws SQLException {
        TestUtil.loadNetDriver();
        if (urlSuffix == null) {
            urlSuffix = (props == null || props.size() == 0) && currentUserName != null ? ";user=" + currentUserName + ";password=" + currentUserPassword + ';' : "";
        } else if (urlSuffix.length() > 0 && urlSuffix.charAt(0) == '/') {
            urlSuffix = urlSuffix.substring(1, urlSuffix.length());
        }
        props = TestUtil.doCommonSetup(props);
        try {
            if (host == null) {
                host = SocketCreator.getLocalHost().getHostName();
            }
            Connection conn = DriverManager.getConnection(TestUtil.getNetProtocol(host, port) + urlSuffix, TestUtil.getNetProperties(props));
            return conn;
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void setRandomUserName() {
        currentUserPassword = currentUserName = GemFireXDUtils.getRandomString((boolean)true);
    }

    public static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return false;
        }
        TestUtil.deleteDirContents(dir);
        return TestUtil.deleteDirOnly(dir);
    }

    protected static void deleteDirContents(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    TestUtil.deleteDirContents(f);
                }
                TestUtil.deleteDirOnly(f);
            }
        }
    }

    protected static boolean deleteDirOnly(File dir) {
        int numTries = 10;
        while (numTries-- > 0 && dir.exists()) {
            if (!dir.delete()) continue;
            return true;
        }
        return numTries > 0;
    }

    public static String getCurrentDefaultSchemaName() {
        String schemaName = currentUserName != null ? StringUtil.SQLToUpperCase((String)currentUserName) : "APP";
        return schemaName;
    }

    public static PreparedStatement getPreparedStatement(String sql) throws SQLException {
        return jdbcConn.prepareStatement(sql);
    }

    public static Statement getStatement() throws SQLException {
        return jdbcConn.createStatement();
    }

    public static Connection getConnection() throws SQLException {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        return TestUtil.getConnection(props);
    }

    public static void loadDriver() {
    }

    public static void loadNetDriver() {
        TestUtil.loadDriverClass(TestUtil.getNetDriver());
    }

    protected static void loadDriverClass(String driver) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            TestUtil.fail("Unable to load the JDBC driver " + driver + ":" + cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            TestUtil.fail("Unable to instantiate the JDBC driver " + driver + ":" + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            TestUtil.fail("Not allowed to access the JDBC driver " + driver + ":" + iae.getMessage());
        }
    }

    public static void loadDerbyDriver() throws Exception {
        Driver autoDriver = (Driver)Class.forName("org.apache.derby.jdbc.AutoloadedDriver40").newInstance();
        Class<?> autoDriverBaseClass = Class.forName("org.apache.derby.jdbc.AutoloadedDriver");
        Method m = autoDriverBaseClass.getDeclaredMethod("registerMe", autoDriverBaseClass);
        m.setAccessible(true);
        m.invoke(null, autoDriver);
    }

    public static void shutDown() throws SQLException {
        TestUtil.shutDown(null);
    }

    public static void shutDown(Properties shutdownProperties) throws SQLException {
        TestUtil.shutDown(TestUtil.getProtocol(), shutdownProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clearStatics() {
        currentTest = null;
        currentTestClass = null;
        currentUserName = null;
        currentUserPassword = null;
        bootUserName = null;
        bootUserPassword = null;
        isTransactional = false;
        Properties sysProps = System.getProperties();
        HashSet<String> keysToRemove = new HashSet<String>();
        Properties properties = sysProps;
        synchronized (properties) {
            Enumeration<?> propNames = sysProps.propertyNames();
            while (propNames.hasMoreElements()) {
                Object prop = propNames.nextElement();
                String key = prop.toString();
                if (key.startsWith("gemfire.DUnitLauncher") || initSysProperties.contains(key) || !key.startsWith("gemfire.") && !key.startsWith(GfxdConstants.GFXD_PREFIX) && !key.startsWith("gemfirexd.client.") && !key.startsWith("javax.net.ssl.")) continue;
                keysToRemove.add(key);
            }
        }
        for (String key : keysToRemove) {
            System.clearProperty(key);
        }
    }

    private static synchronized void shutDown(String protocol, Properties shutdownProperties) throws SQLException {
        block12: {
            try {
                for (Map.Entry<String, Integer> exEntry : expectedExceptions.entrySet()) {
                    if ((exEntry.getValue() & 1) <= 0) continue;
                    TestUtil.addLogString("<ExpectedException action=remove>" + exEntry.getKey() + "</ExpectedException>");
                }
                expectedExceptions.clear();
                SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
                Connection conn = jdbcConn;
                if (conn != null) {
                    jdbcConn = null;
                }
                if (shutdownProperties == null) {
                    shutdownProperties = new Properties();
                }
                if (bootUserName != null) {
                    shutdownProperties.setProperty("user", bootUserName);
                    shutdownProperties.setProperty("password", bootUserPassword);
                    TestUtil.getLogger().info((Object)("shutting down with " + bootUserName + " and boot password " + bootUserPassword));
                } else if (currentUserName != null) {
                    shutdownProperties.setProperty("user", currentUserName);
                    if (currentUserPassword != null) {
                        shutdownProperties.setProperty("password", currentUserPassword);
                    }
                    TestUtil.getLogger().info((Object)("shutting down with " + currentUserName + " and password " + currentUserPassword));
                }
                TestUtil.stopNetServer();
                FabricService service = FabricServiceManager.currentFabricServiceInstance();
                if (service != null) {
                    service.stop(shutdownProperties);
                    TestUtil.getLogger().info((Object)("Fabric Server shutdown status " + service.status()));
                } else if (GemFireStore.getBootingInstance() != null) {
                    DriverManager.getConnection(TestUtil.getProtocol() + ";shutdown=true", shutdownProperties);
                }
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) break block12;
                throw se;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropAllUsers(Connection conn) throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("call sys.show_users()");
        try (Statement pstmt = null;
             ResultSet rs = stmt.getResultSet();){
            while (rs.next()) {
                if (!rs.getString(2).equalsIgnoreCase("USER")) continue;
                if (pstmt == null) {
                    pstmt = conn.prepareStatement("call sys.drop_user(?)");
                }
                pstmt.setString(1, rs.getString(1));
                pstmt.execute();
            }
        }
    }

    public static String convertByteArrayToString(byte[] byteArray) {
        if (byteArray == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (byte b : byteArray) {
            sb.append(b + ", ");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append('}');
        return sb.toString();
    }

    public static final boolean compareResults(ResultSet expected, ResultSet rs, boolean ignoreTypeInfo) throws Exception {
        Element resultElement = Misc.resultSetToXMLElement((ResultSet)rs, (boolean)true, (boolean)ignoreTypeInfo);
        Element expectedElement = Misc.resultSetToXMLElement((ResultSet)expected, (boolean)true, (boolean)ignoreTypeInfo);
        Map<String, Integer> resultMap = TestUtil.xmlElementToFrequencyMap(resultElement);
        Map<String, Integer> expectedResultMap = TestUtil.xmlElementToFrequencyMap(expectedElement);
        String resultStr = Misc.serializeXML((Element)resultElement);
        String expectedStr = Misc.serializeXML((Element)expectedElement);
        if (TestUtil.compareFrequencyMaps(expectedResultMap, resultMap)) {
            return true;
        }
        TestUtil.getLogger().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
        TestUtil.getLogger().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
        return false;
    }

    public static final void validateResults(ResultSet derbyRS, ResultSet gfxdRS, boolean ignoreTypeInfo) throws Exception {
        if (!TestUtil.compareResults(derbyRS, gfxdRS, ignoreTypeInfo)) {
            TestUtil.fail("Expected string in derby does not match the result from GemFireXD.");
        }
    }

    public static final void validateResults(Statement derbyStmt, Statement stmt, String validationQuery, boolean ignoreTypeInfo) throws Exception {
        ResultSet derbyRS = derbyStmt instanceof PreparedStatement ? ((PreparedStatement)derbyStmt).executeQuery() : derbyStmt.executeQuery(validationQuery);
        ResultSet gfxdRS = stmt instanceof PreparedStatement ? ((PreparedStatement)stmt).executeQuery() : stmt.executeQuery(validationQuery);
        TestUtil.validateResults(derbyRS, gfxdRS, ignoreTypeInfo);
    }

    public static void sqlExecute(String jdbcSQL, Boolean usePrepStmt) throws SQLException {
        TestUtil.sqlExecute(jdbcSQL, usePrepStmt, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sqlExecute(String jdbcSQL, Boolean usePrepStmt, Boolean consumeResults) throws SQLException {
        TestUtil.setupConnection();
        TestUtil.getLogger().info((Object)("For user '" + jdbcConn.getMetaData().getUserName() + '[' + currentUserName + "]' executing SQL: " + jdbcSQL));
        if (usePrepStmt.booleanValue()) {
            try (PreparedStatement stmt = jdbcConn.prepareStatement(jdbcSQL);){
                if (!stmt.execute() || !consumeResults.booleanValue()) return;
                int numResults = 0;
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    ++numResults;
                }
                TestUtil.getLogger().info((Object)("Got numResults=" + numResults + " for SQL: " + jdbcSQL));
                return;
            }
        }
        try (Statement stmt = jdbcConn.createStatement();){
            if (!stmt.execute(jdbcSQL) || !consumeResults.booleanValue()) return;
            int numResults = 0;
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ++numResults;
            }
            TestUtil.getLogger().info((Object)("Got numResults=" + numResults + " for SQL: " + jdbcSQL));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sqlExecuteVerify(String jdbcSQL, Boolean usePrepStmt) throws SQLException {
        boolean resultType;
        Statement stmt;
        TestUtil.setupConnection();
        TestUtil.getLogger().info((Object)("For user '" + jdbcConn.getMetaData().getUserName() + '[' + currentUserName + "]' executing SQL with verification: " + jdbcSQL));
        if (usePrepStmt.booleanValue()) {
            stmt = jdbcConn.prepareStatement(jdbcSQL);
            resultType = ((PreparedStatement)stmt).execute();
        } else {
            stmt = jdbcConn.createStatement();
            resultType = stmt.execute(jdbcSQL);
        }
        int count = 0;
        try {
            if (resultType) {
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    ++count;
                }
            } else {
                count = stmt.getUpdateCount();
            }
        }
        finally {
            stmt.close();
        }
        TestUtil.getLogger().info((Object)("sqlExecuteVerify: got the number of changes/results as: " + count));
        return count;
    }

    public static void sqlExecuteVerifyText(String jdbcSQL, String goldenTextFile, String resultSetID, Boolean usePrepStmt, Boolean checkTypeInfo) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException {
        boolean resultType;
        Statement stmt;
        TestUtil.setupConnection();
        if (usePrepStmt.booleanValue()) {
            stmt = jdbcConn.prepareStatement(jdbcSQL);
            resultType = ((PreparedStatement)stmt).execute();
        } else {
            stmt = jdbcConn.createStatement();
            resultType = stmt.execute(jdbcSQL);
        }
        TestUtil.verifyResults(resultType, stmt, checkTypeInfo, goldenTextFile, resultSetID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyResults(boolean resultType, Statement stmt, boolean checkTypeInfo, String goldenTextFile, String resultSetID) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException {
        block15: {
            try {
                String expectedResult;
                if (resultType) {
                    boolean comparisonResult;
                    String resultStr = null;
                    String expectedStr = null;
                    if (goldenTextFile == null) {
                        ResultSet rs = stmt.getResultSet();
                        expectedStr = resultSetID;
                        comparisonResult = rs.next();
                        if (comparisonResult) {
                            resultStr = String.valueOf(rs.getObject(1));
                            comparisonResult = expectedStr.equals(resultStr);
                            TestUtil.assertFalse((String)("Expected exactly one scalar result: " + expectedStr + " already read: " + resultStr), (boolean)rs.next());
                        } else {
                            comparisonResult = resultSetID == null;
                        }
                        rs.close();
                    } else {
                        Element resultElement = Misc.resultSetToXMLElement((ResultSet)stmt.getResultSet(), (boolean)checkTypeInfo, (boolean)false);
                        Element expectedElement = TestUtil.readResultSetXMLFromFile(goldenTextFile, resultSetID);
                        if ("true".equals(expectedElement.getAttribute("ordered"))) {
                            resultStr = Misc.serializeXML((Element)resultElement);
                            expectedElement.removeAttribute("ordered");
                            expectedStr = Misc.serializeXML((Element)expectedElement);
                            comparisonResult = expectedStr.equals(resultStr);
                        } else {
                            resultStr = Misc.serializeXML((Element)resultElement);
                            expectedStr = Misc.serializeXML((Element)expectedElement);
                            TestUtil.getLogger().info((Object)("sqlExecuteVerifyText: Verifying for result XML:\n" + resultStr + "\nexpectedStr:\n" + expectedStr));
                            Map<String, Integer> resultMap = TestUtil.xmlElementToFrequencyMap(resultElement);
                            Map<String, Integer> expectedResultMap = TestUtil.xmlElementToFrequencyMap(expectedElement);
                            comparisonResult = TestUtil.compareFrequencyMaps(expectedResultMap, resultMap);
                        }
                    }
                    if (!comparisonResult) {
                        TestUtil.getLogger().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
                        System.out.println("sqlExecuteVerifyText: The result XML is:\n" + resultStr);
                        TestUtil.getLogger().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
                        TestUtil.fail("Expected string in golden file does not match the result.");
                    } else {
                        TestUtil.getLogger().info((Object)("sqlExecuteVerifyText: Verified for result XML:\n" + resultStr));
                    }
                    break block15;
                }
                String result = String.valueOf(stmt.getUpdateCount());
                try (BufferedReader reader = new BufferedReader(new FileReader(goldenTextFile));){
                    char[] expectedChars = new char[result.length()];
                    int numRead = reader.read(expectedChars, 0, expectedChars.length);
                    TestUtil.assertEquals((String)"Number of characters in golden file does not match.", (int)numRead, (int)expectedChars.length);
                    TestUtil.assertEquals((String)"Expected the golden file to end.", (int)-1, (int)reader.read());
                    expectedResult = new String(expectedChars);
                }
                TestUtil.assertEquals((String)"Expected number of results does not match the obtained number.", (String)expectedResult, (String)result);
            }
            finally {
                stmt.close();
            }
        }
    }

    public static void verifyRegionProperties(Object schemaName, Object tableName, Object propsStr) {
        String fullTableName = TestUtil.getFullTableName(schemaName, tableName);
        TestUtil.getLogger().info((Object)("For current user '" + currentUserName + "' verifying region properties for table " + fullTableName));
        Region tableRegion = Misc.getRegionForTable((String)fullTableName, (boolean)false);
        if (propsStr != null) {
            TestUtil.assertFalse((String)("Expected the region for [" + fullTableName + "] to exist."), (tableRegion == null || tableRegion.isDestroyed() ? 1 : 0) != 0);
            String tableRegionAttrsStr = TestUtil.regionAttributesToXML(tableRegion.getAttributes());
            TestUtil.getLogger().info((Object)("verifyRegionProperties: The expected properties are:\n" + propsStr.toString()));
            TestUtil.getLogger().info((Object)("verifyRegionProperties: The result properties are:\n" + tableRegionAttrsStr));
            TestUtil.assertEquals((String)"Expected the region attributes to match.", (String)propsStr.toString(), (String)tableRegionAttrsStr);
        } else {
            TestUtil.assertTrue((String)("Expected the region for [" + fullTableName + "] to be destroyed."), (tableRegion == null || tableRegion.isDestroyed() ? 1 : 0) != 0);
            TestUtil.getLogger().info((Object)("verifyRegionProperties: Got the region for [" + fullTableName + "] as destroyed as expected."));
        }
    }

    public static String getFullTableName(Object schemaName, Object tableName) {
        if (schemaName == null) {
            schemaName = TestUtil.getCurrentDefaultSchemaName();
        }
        String tableSubPath = "";
        if (tableName != null) {
            tableSubPath = "." + tableName.toString().toUpperCase();
        }
        return schemaName.toString() + tableSubPath;
    }

    public static String regionAttributesToXML(RegionAttributes<?, ?> attrs) {
        if (attrs == null) {
            return null;
        }
        if (attrs.getPartitionAttributes() != null) {
            try {
                ((PartitionAttributesImpl)attrs.getPartitionAttributes()).computeLocalMaxMemory();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        UserSpecifiedRegionAttributes usra = null;
        if (attrs instanceof UserSpecifiedRegionAttributes) {
            usra = (UserSpecifiedRegionAttributes)attrs;
        }
        CacheCreation cache = new CacheCreation();
        RegionCreation rgn = (RegionCreation)cache.createRegion("_ATTRS_TMP_TABLE", attrs);
        RegionAttributesCreation rac = (RegionAttributesCreation)rgn.getAttributes();
        if (usra != null) {
            rac.setHasDiskDirs(usra.hasDiskDirs());
            rac.setHasDiskWriteAttributes(usra.hasDiskWriteAttributes());
        } else {
            rac.setHasDiskDirs(false);
            rac.setHasDiskWriteAttributes(false);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static Element readResultSetXMLFromFile(String xmlFile, String resultSetID) throws IOException, SAXException, ParserConfigurationException, UnsupportedEncodingException {
        Element expectedElement;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        if (resultSetID == null) {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream bis = new ByteArrayInputStream(xmlFile.getBytes("UTF-8"));
            expectedElement = (Element)builder.parse(bis).getFirstChild();
        } else {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            XmlErrorHandler errorHandler = new XmlErrorHandler(xmlFile);
            builder.setErrorHandler(errorHandler);
            Document doc = builder.parse(xmlFile);
            expectedElement = doc.getElementById(resultSetID);
            expectedElement.removeAttribute("id");
        }
        return expectedElement;
    }

    public static Logger getLogger() {
        return globalLogger;
    }

    public static void fail(String message) {
        TestUtil.getLogger().error((Object)message);
        TestCase.fail((String)message);
    }

    public static void fail(String message, Throwable t) {
        StringPrintWriter pw = new StringPrintWriter();
        pw.append((CharSequence)message).append((CharSequence)": ");
        t.printStackTrace((PrintWriter)pw);
        TestUtil.fail(pw.toString());
    }

    public static void addLogString(String logStr) {
        SanityManager.DEBUG_PRINT((String)"ExpectedEx", (String)logStr);
        System.out.println(logStr);
    }

    public static void addExpectedException(Object exceptionClass) {
        TestUtil.addExpectedException(new Object[]{exceptionClass});
    }

    public static void addExpectedException(Object[] exceptionClasses) {
        for (Object exObj : exceptionClasses) {
            String exStr = GemFireXDUtils.getExpectedExceptionString((Object)exObj, (boolean)false);
            TestUtil.addLogString(exStr);
            Integer flag = expectedExceptions.get(exStr);
            flag = flag != null ? Integer.valueOf(flag | 1) : Integer.valueOf(1);
            expectedExceptions.put(exStr, flag);
        }
    }

    public static void addExpectedExceptions(Object[] exceptionClasses) {
        TestUtil.addExpectedException(exceptionClasses);
    }

    public static void removeExpectedException(Object exceptionClass) {
        TestUtil.removeExpectedException(new Object[]{exceptionClass});
    }

    public static void removeExpectedException(Object[] exceptionClasses) {
        for (Object exObj : exceptionClasses) {
            String exStr = GemFireXDUtils.getExpectedExceptionString((Object)exObj, (boolean)true);
            TestUtil.addLogString(exStr);
            Integer flag = expectedExceptions.get(exStr);
            if (flag == null) continue;
            if ((flag = Integer.valueOf(flag ^ 1)) == 0) {
                expectedExceptions.remove(exStr);
                continue;
            }
            expectedExceptions.put(exStr, flag);
        }
    }

    public static void removeExpectedExceptions(Object[] exceptionClasses) {
        TestUtil.removeExpectedException(exceptionClasses);
    }

    public static PartitionAttributesImpl getPartitionAttributes(String tableName) {
        Region custRegion = Misc.getRegionForTable((String)StringUtil.SQLToUpperCase((String)tableName), (boolean)true);
        PartitionAttributesImpl pattrs = (PartitionAttributesImpl)custRegion.getAttributes().getPartitionAttributes();
        TestUtil.assertNotNull((String)"Expected partitioned attributes to be non-null", (Object)pattrs);
        TestUtil.assertTrue((String)"Expected resolver to be GfxdPartitionResolver", (boolean)(pattrs.getPartitionResolver() instanceof GfxdPartitionResolver));
        return pattrs;
    }

    public static void checkServerGroups(String tableName, String ... serverGroups) {
        PartitionAttributesImpl pattrs = TestUtil.getPartitionAttributes(tableName);
        GfxdPartitionResolver resolver = (GfxdPartitionResolver)pattrs.getPartitionResolver();
        SortedSet actualServerGroups = resolver.getDistributionDescriptor().getServerGroups();
        if (serverGroups == null) {
            TestUtil.assertTrue((String)"expected target server groups to be null", (actualServerGroups == null || actualServerGroups.size() == 0 ? 1 : 0) != 0);
            return;
        }
        TestUtil.assertEquals((int)serverGroups.length, (int)actualServerGroups.size());
        for (String serverGroup : serverGroups) {
            TestUtil.assertTrue((boolean)actualServerGroups.contains(StringUtil.SQLToUpperCase((String)serverGroup)));
        }
    }

    public static GfxdPartitionResolver checkColocation(String tableName, String targetSchema, String targetTable) {
        PartitionAttributesImpl pattrs = TestUtil.getPartitionAttributes(tableName);
        GfxdPartitionResolver resolver = (GfxdPartitionResolver)pattrs.getPartitionResolver();
        DistributionDescriptor dd = resolver.getDistributionDescriptor();
        String targetRegionPath = null;
        if (targetTable != null && targetTable.length() > 0) {
            targetTable = Misc.getFullTableName((String)StringUtil.SQLToUpperCase((String)targetSchema), (String)StringUtil.SQLToUpperCase((String)targetTable), null);
            targetRegionPath = "/" + targetTable.replace('.', '/');
        }
        TestUtil.assertEquals((String)"Failure in checking colocation of tables: ", targetRegionPath, (String)dd.getColocateTableName());
        TestUtil.assertEquals((String)"Failure in checking colocation of regions: ", targetRegionPath, (String)pattrs.getColocatedWith());
        return resolver;
    }

    public static Map<String, Integer> xmlElementToFrequencyMap(Element resultSetElement) throws SQLException, IOException, TransformerException {
        NodeList rowList = resultSetElement.getChildNodes();
        HashMap<String, Integer> frequencyMap = new HashMap<String, Integer>();
        for (int index = 0; index < rowList.getLength(); ++index) {
            Element rowElement = (Element)rowList.item(index);
            TreeMap<ColumnNameValue, Element> rowMap = new TreeMap<ColumnNameValue, Element>();
            HashMap<ColumnNameValue, Integer> repeatedColumns = new HashMap<ColumnNameValue, Integer>();
            NodeList fieldList = rowElement.getChildNodes();
            while (fieldList.getLength() > 0) {
                Element fieldElement = (Element)fieldList.item(0);
                String columnName = fieldElement.getAttribute("name");
                if (columnName != null) {
                    ColumnNameValue col = new ColumnNameValue(columnName, fieldElement.getTextContent());
                    if (repeatedColumns.containsKey(col)) {
                        Integer suffix = (Integer)repeatedColumns.get(col);
                        repeatedColumns.put(col, suffix + 1);
                        col.colName = col.colName + ("." + suffix.toString());
                        rowMap.put(col, fieldElement);
                    } else {
                        repeatedColumns.put(col, 1);
                        rowMap.put(col, fieldElement);
                    }
                }
                rowElement.removeChild(fieldElement);
            }
            for (Map.Entry row : rowMap.entrySet()) {
                rowElement.appendChild((Node)row.getValue());
            }
            String rowXML = Misc.serializeXML((Element)rowElement);
            Object numRowInstances = frequencyMap.get(rowXML);
            if (numRowInstances == null) {
                frequencyMap.put(rowXML, 1);
                continue;
            }
            frequencyMap.put(rowXML, (Integer)numRowInstances + 1);
        }
        return frequencyMap;
    }

    public static boolean compareFrequencyMaps(Map<String, Integer> expectedMap, Map<String, Integer> resultMap) {
        if (expectedMap.size() != resultMap.size()) {
            TestUtil.getLogger().info((Object)("Expected size of result set: " + expectedMap.size() + "; obtained size: " + resultMap.size()));
            return false;
        }
        for (Map.Entry<String, Integer> entry : expectedMap.entrySet()) {
            Integer resultValue = resultMap.get(entry.getKey());
            if (entry.getValue().equals(resultValue)) continue;
            TestUtil.getLogger().info((Object)("Expected entry [" + entry.getValue() + "] for row [" + entry.getKey() + "] but got [" + resultValue + ']'));
            return false;
        }
        return true;
    }

    public static FabricService getFabricService() {
        FabricService service = FabricServiceManager.currentFabricServiceInstance();
        if (service == null) {
            service = FabricServiceManager.getFabricServerInstance();
        }
        return service;
    }

    public static Connection startNetserverAndGetLocalNetConnection() throws Exception {
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.loadNetDriver();
        TestUtil.startNetServer(netPort, null);
        return TestUtil.getNetConnection(netPort, null, null);
    }

    public static Connection startNetserverAndGetLocalNetConnection(Properties props) throws Exception {
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.loadNetDriver();
        TestUtil.startNetServer(netPort, null);
        return TestUtil.getNetConnection(netPort, null, props);
    }

    public static int startNetserverAndReturnPort() throws Exception {
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.loadNetDriver();
        TestUtil.startNetServer(netPort, null);
        return netPort;
    }

    public static int startNetserverAndReturnPort(String sql) throws Exception {
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.loadNetDriver();
        TestUtil.startNetServer(netPort, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        if (sql != null) {
            Statement stmnt = conn.createStatement();
            stmnt.execute(sql);
        }
        return netPort;
    }

    public static String startNetServer() throws Exception {
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.loadNetDriver();
        return TestUtil.startNetServer(netPort, null);
    }

    public static String startNetServer(int netPort, Properties extraProps) throws Exception {
        String localHostName = SocketCreator.getLocalHost().getHostName();
        return TestUtil.startNetServer(localHostName, netPort, extraProps);
    }

    public static String startNetServer(String hostName, int netPort, Properties extraProps) throws Exception {
        if (netServer != null) {
            TestUtil.stopNetServer();
        }
        TestUtil.getLogger().info((Object)("Starting a gemfirexd network server on " + hostName + ":" + netPort));
        if (extraProps == null) {
            extraProps = new Properties();
        }
        extraProps.setProperty("gemfirexd.drda.logConnections", "true");
        netServer = TestUtil.getFabricService().startNetworkServer(hostName, netPort, extraProps);
        return hostName + ':' + netPort;
    }

    public static boolean stopNetServer() {
        if (netServer != null) {
            Logger logger = null;
            try {
                logger = TestUtil.getLogger();
                netServer.stop();
                logger.info((Object)(netServer.status() + " gemfirexd network server on host " + SocketCreator.getLocalHost().getHostName()));
            }
            catch (Exception ex) {
                if (logger != null) {
                    logger.error((Object)"Failed in gemfirexd network server shutdown", (Throwable)ex);
                }
                TestUtil.fail("Failed in gemfirexd network server shutdown: " + ex);
            }
            netServer = null;
            return true;
        }
        return false;
    }

    public static int startLocator(String addr, int netPort, Properties props) throws Exception {
        FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
        if (props == null) {
            props = TestUtil.doCommonSetup(null);
        }
        int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        locator.start(addr, locatorPort, props);
        if (netPort > 0) {
            TestUtil.startNetServer(netPort, null);
        }
        return locatorPort;
    }

    public static GemFireTransaction getGFT(EmbedConnection conn) {
        ContextManager cm = conn.getContextManager();
        GemFireTransactionContext tc = (GemFireTransactionContext)cm.getContext("UserTransaction");
        return tc.getTransaction();
    }

    public static GemFireContainer getIndexContainer(LocalRegion baseTableRegion, String indexName) {
        List allIndexes = ((GfxdIndexManager)baseTableRegion.getIndexUpdater()).getAllIndexes();
        for (GemFireContainer gfc : allIndexes) {
            if (!gfc.getName().equals(indexName)) continue;
            return gfc;
        }
        return null;
    }

    public static RegionKey getGemFireKey(int arg, Region<?, ?> tableRegion) throws StandardException {
        DataValueFactory df = Misc.getMemStore().getDatabase().getDataValueFactory();
        NumberDataValue dvd = df.getDataValue(arg);
        return GemFireXDUtils.convertIntoGemfireRegionKey((DataValueDescriptor)dvd, (GemFireContainer)((GemFireContainer)tableRegion.getUserAttribute()), (boolean)true);
    }

    public static String numstr(int i) {
        switch (i) {
            case 0: {
                return "zero";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "three";
            }
            case 4: {
                return "four";
            }
            case 5: {
                return "five";
            }
            case 6: {
                return "six";
            }
            case 7: {
                return "seven";
            }
            case 8: {
                return "eight";
            }
            case 9: {
                return "nine";
            }
        }
        return TestUtil.numstr(i / 10) + TestUtil.numstr(i % 10);
    }

    public static Object getXADataSource(String xaDsClassName) {
        ClassLoader contextLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            Object ds = null;
            if (contextLoader != null) {
                try {
                    ds = Class.forName(xaDsClassName, true, contextLoader).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ds == null) {
                ds = Class.forName(xaDsClassName).newInstance();
            }
            return ds;
        }
        catch (Exception e) {
            TestUtil.fail(e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStatementCache() throws SQLException {
        EmbedConnection conn = null;
        try {
            LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContextOrNull((String)"LanguageConnectionContext");
            if (lcc == null) {
                conn = GemFireXDUtils.getTSSConnection((boolean)true, (boolean)true, (boolean)false);
                conn.getTR().setupContextStack();
                lcc = (LanguageConnectionContext)ContextService.getContextOrNull((String)"LanguageConnectionContext");
            }
            CacheManager cm = lcc.getLanguageConnectionFactory().getStatementCache();
            cm.cleanAll();
            cm.ageOut();
        }
        catch (Exception e) {
            TestUtil.fail("Exception occured in clearing cache ", e);
        }
        finally {
            if (conn != null) {
                conn.getTR().restoreContextStack();
                conn.close();
            }
        }
    }

    public static <T> Object getField(Class<T> clazz, T instance, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field f = clazz.getDeclaredField(fieldName);
        f.setAccessible(true);
        return f.get(instance);
    }

    public static void assertTimerLibraryLoaded() {
        OSType ostype = NativeCalls.getInstance().getOSType();
        if (ostype == OSType.LINUX) {
            TestUtil.assertTrue((String)("Couldn't initialize jni native timer for " + ostype), (boolean)NanoTimer.isJNINativeTimerEnabled());
            TestUtil.assertTrue((String)("Couldn't initialize the native timer for " + ostype), (boolean)NanoTimer.isNativeTimerEnabled());
        }
    }

    static {
        isTransactional = false;
        deletePersistentFiles = false;
        skipDefaultPartitioned = false;
        oldDMVerbose = false;
        DistributedTestBase.InitializeRun.setUp();
        initSysProperties = System.getProperties().stringPropertyNames();
        netServer = null;
    }

    public static enum ScanType {
        NONE,
        TABLE,
        HASH1INDEX,
        SORTEDMAPINDEX,
        GLOBALHASHINDEX,
        BACKINGSTORE;

    }

    public static class ScanTypeQueryObserver
    extends GemFireXDQueryObserverAdapter {
        private final Map<String, Object> expectedScanTypes = new HashMap<String, Object>();
        private final Map<String, Map<String, ScanType>> foundScanTypes = new HashMap<String, Map<String, ScanType>>();
        private final Set<Scan> foundSorters = new HashSet<Scan>();

        public void addExpectedScanType(String conglomName, ScanType scanType) {
            this.addNewScanType(this.expectedScanTypes, StringUtil.SQLToUpperCase((String)conglomName), null, scanType);
        }

        public void addExpectedScanType(String conglomName, String scanConglomName, ScanType scanType) {
            this.addNewScanType(this.expectedScanTypes, StringUtil.SQLToUpperCase((String)conglomName), StringUtil.SQLToUpperCase((String)scanConglomName), scanType);
        }

        public void scanControllerOpened(Object sc, Conglomerate conglom) {
            if (this.isManagementLayerCall()) {
                return;
            }
            GemFireContainer baseContainer = null;
            String conglomContainerName = null;
            ScanType scanType = null;
            if (sc instanceof MemHeapScanController) {
                baseContainer = ((MemHeap)conglom).getGemFireContainer();
                conglomContainerName = baseContainer.getQualifiedTableName();
                scanType = ScanType.TABLE;
            } else if (sc instanceof MemIndexScanController) {
                MemIndex index = (MemIndex)conglom;
                baseContainer = index.getBaseContainer();
                if (sc instanceof Hash1IndexScanController) {
                    conglomContainerName = "HASH1INDEX:" + baseContainer.getQualifiedTableName();
                    scanType = ScanType.HASH1INDEX;
                } else {
                    conglomContainerName = index.getGemFireContainer().getQualifiedTableName().replaceFirst(":base-table:.*$", "");
                    if (sc instanceof GlobalHashIndexScanController) {
                        scanType = ScanType.GLOBALHASHINDEX;
                    } else if (sc instanceof SortedMap2IndexScanController) {
                        scanType = ScanType.SORTEDMAPINDEX;
                    }
                }
            } else if (sc instanceof BackingStoreHashtable) {
                scanType = ScanType.BACKINGSTORE;
                GemFireContainer container = ((MemConglomerate)conglom).getGemFireContainer();
                if (conglom instanceof MemIndex) {
                    baseContainer = ((MemIndex)conglom).getBaseContainer();
                    conglomContainerName = container.getQualifiedTableName().replaceFirst(":base-table:.*$", "") + ".BACKINGSTORE";
                } else {
                    baseContainer = container;
                    conglomContainerName = container.getQualifiedTableName() + ".BACKINGSTORE";
                }
            } else if (sc instanceof Scan) {
                this.foundSorters.add((Scan)sc);
                return;
            }
            if (scanType == null) {
                throw new IllegalStateException("Unknown scan controller received: " + sc.getClass());
            }
            this.addNewScanType(this.foundScanTypes, baseContainer.getQualifiedTableName(), conglomContainerName, scanType);
        }

        private boolean isManagementLayerCall() {
            StackTraceElement[] stack;
            for (StackTraceElement frame : stack = Thread.currentThread().getStackTrace()) {
                String frameCls = frame.getClassName();
                if (!"com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService".equals(frameCls)) continue;
                return true;
            }
            return false;
        }

        public Set<Scan> getSorters() {
            return this.foundSorters;
        }

        public void checkAndClear() {
            for (Map.Entry<String, Object> entry : this.expectedScanTypes.entrySet()) {
                String conglomName = entry.getKey();
                Object expectedScans = entry.getValue();
                Set expectedScanSet = null;
                Map expectedScanMap = null;
                Map<String, ScanType> gotScans = this.foundScanTypes.get(conglomName);
                if (expectedScans instanceof Set) {
                    expectedScanSet = (Set)expectedScans;
                } else {
                    expectedScanMap = (Map)expectedScans;
                }
                if (expectedScanSet != null && expectedScanSet.contains((Object)ScanType.NONE) || expectedScanMap != null && expectedScanMap.containsValue((Object)ScanType.NONE)) {
                    TestCase.assertNull((String)("Did not expect to find any scans for conglomerate [" + conglomName + "] but got: " + gotScans), gotScans);
                    continue;
                }
                TestCase.assertNotNull((String)("Did not find scans for conglomerate: " + conglomName + " [ actual = " + this.foundScanTypes + " ]"), gotScans);
                if (expectedScanSet != null) {
                    Collection<ScanType> gotScanTypes = gotScans.values();
                    if (gotScanTypes.contains((Object)ScanType.BACKINGSTORE) && !expectedScanSet.contains((Object)ScanType.BACKINGSTORE)) {
                        expectedScanSet.add(ScanType.BACKINGSTORE);
                    }
                    if (expectedScanSet.size() != gotScans.size() || !expectedScanSet.containsAll(gotScanTypes)) {
                        throw new AssertionError((Object)("The expected scans [" + expectedScanSet + "] does not match with actual [" + gotScans + "] for conglomerate: " + conglomName));
                    }
                    continue;
                }
                if (expectedScanMap.size() != gotScans.size() || !expectedScanMap.equals(gotScans)) {
                    throw new AssertionError((Object)("The expected scans [" + expectedScanMap + "] does not match with actual [" + gotScans + "] for conglomerate: " + conglomName));
                }
            }
            this.clear();
        }

        public void clear() {
            this.expectedScanTypes.clear();
            this.foundScanTypes.clear();
            this.foundSorters.clear();
        }

        public void clearExpectedScanTypes() {
            this.expectedScanTypes.clear();
        }

        private void addNewScanType(Map<String, Object> indexMap, String conglomName, String scanConglom, ScanType expectedScan) {
            Cloneable indexes = indexMap.get(conglomName);
            if (indexes == null) {
                indexes = scanConglom == null ? new HashSet() : new HashMap();
                indexMap.put(conglomName, indexes);
            }
            if (scanConglom == null) {
                ((HashSet)indexes).add(expectedScan);
            } else {
                ((HashMap)indexes).put(scanConglom, expectedScan);
            }
        }
    }

    public static class XmlErrorHandler
    implements ErrorHandler {
        private final String xmlFileName;

        public XmlErrorHandler(String xmlFileName) {
            this.xmlFileName = xmlFileName;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXParseException("Error while parsing XML at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), null);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXParseException("Fatal error while parsing XML at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), null);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            TestUtil.getLogger().info((Object)("Warning while parsing XML [" + this.xmlFileName + "] at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage()));
        }
    }

    private static class ColumnNameValue
    implements Comparable<ColumnNameValue> {
        private String colName;
        private final String colValue;

        public ColumnNameValue(String name, String value) {
            this.colName = name;
            this.colValue = value;
        }

        @Override
        public int compareTo(ColumnNameValue other) {
            if (other == null) {
                return -1;
            }
            int res = this.colName.compareTo(other.colName);
            if (res != 0) {
                return res;
            }
            return this.colValue.compareTo(other.colValue);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ColumnNameValue)) {
                return false;
            }
            ColumnNameValue other = (ColumnNameValue)obj;
            return this.colName.equals(other.colName) && this.colValue.equals(other.colValue);
        }

        public int hashCode() {
            return this.colName.hashCode() ^ this.colValue.hashCode();
        }
    }
}

