/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.client.am.SingleHopPreparedStatement;
import io.snappydata.test.dunit.SerializableRunnable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public class SingleHopDUnit
extends DistributedSQLTestBase {
    public SingleHopDUnit(String name) {
        super(name);
    }

    public void testSingleHopDuplicateResults() throws Exception {
        this.startVMs(0, 4, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        InetAddress localHost = SocketCreator.getLocalHost();
        Connection connSHOP = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, connSHOPProps);
        Statement st = connSHOP.createStatement();
        st.execute("create schema trade");
        String ddl = "create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, status varchar(10), tid int, constraint status_ch check (status in ('cancelled', 'open', 'filled')))  partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 10000)  REDUNDANCY 1";
        st.execute(ddl);
        PreparedStatement pInsert = connSHOP.prepareStatement("insert into trade.sellorders values(?, ?, ?, ?, ?, ?)");
        for (int i = 0; i < 20; ++i) {
            pInsert.setInt(1, i);
            if (i < 10) {
                pInsert.setInt(2, 1251 + i);
            } else {
                pInsert.setInt(2, 1577 + i % 10);
            }
            pInsert.setInt(3, i);
            pInsert.setInt(4, i * 100);
            pInsert.setString(5, "open");
            pInsert.setInt(6, 10);
            int cnt = pInsert.executeUpdate();
            SingleHopDUnit.assertEquals((int)1, (int)cnt);
        }
        PreparedStatement pSelect = connSHOP.prepareStatement("select oid, sid, cid, status from trade.sellorders  where status = ? and cid IN (?, ?, ?, ?, ?) and tid =?");
        pSelect.setString(1, "open");
        pSelect.setInt(2, 1251);
        pSelect.setInt(3, 1577);
        pSelect.setInt(4, 1253);
        pSelect.setInt(5, 1580);
        pSelect.setInt(6, 1255);
        pSelect.setInt(7, 10);
        ResultSet rs = pSelect.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            System.out.println(rs.getInt(1) + ", " + rs.getInt(2) + ", " + rs.getInt(3) + ", " + rs.getString(4));
        }
        rs.close();
        SingleHopDUnit.assertEquals((int)5, (int)cnt);
    }

    public void testSingleHopHA_clientParamType() throws Exception {
        Properties locatorProps = new Properties();
        this.setMasterCommonProperties(locatorProps);
        String locatorBindAddress = SocketCreator.getLocalHost().getHostName();
        int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        SingleHopDUnit._startNewLocator(((Object)((Object)this)).getClass().getName(), this.getName(), locatorBindAddress, locatorPort, null, locatorProps);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.startNetServer(netPort, null);
        Properties serverProps = new Properties();
        serverProps.setProperty("locators", locatorBindAddress + '[' + locatorPort + ']');
        this.startVMs(0, 1, 0, null, serverProps);
        int netPort1 = this.startNetworkServer(1, null, null);
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        connSHOPProps.setProperty("read-timeout", "10");
        Connection conn = TestUtil.getNetConnection(locatorBindAddress, netPort, null, connSHOPProps);
        Statement s = conn.createStatement();
        String ddl = "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (sec_id, price)  REDUNDANCY 2";
        s.execute(ddl);
        ddl = "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 10000)  REDUNDANCY 2";
        s.execute(ddl);
        s.execute("insert into trade.securities values (1204, 'lo', 33.9, 'hkse', 53)");
        s.execute("insert into trade.portfolio values (508, 1204, 1080, 1080, 36612.00000000000000000000, 100)");
        String updStmnt = "update trade.portfolio set subTotal=? * qty where cid = ? and sid = ?";
        String selStmnt = "select * from trade.securities where sec_id = ?";
        PreparedStatement ps2 = conn.prepareStatement(selStmnt);
        ps2.setInt(1, 1204);
        ResultSet rs = ps2.executeQuery();
        SingleHopDUnit.assertTrue((boolean)rs.next());
        BigDecimal price = rs.getBigDecimal(3);
        SingleHopDUnit.assertFalse((boolean)rs.next());
        rs.close();
        String updStmnt2 = "update trade.portfolio set subTotal = ? * qty  where cid = ? and sid = ?  and tid= ?";
        PreparedStatement ps = conn.prepareStatement(updStmnt2);
        ps.setBigDecimal(1, price);
        ps.setInt(2, 508);
        ps.setInt(3, 1204);
        ps.setInt(4, 53);
        ps.executeUpdate();
        ps.executeUpdate();
        this.startVMs(0, 2, 0, null, serverProps);
        int netPort2 = this.startNetworkServer(2, null, null);
        this.stopVMNum(-1);
        ps.executeUpdate();
    }

    public void test_Bug47392() throws Exception {
        this.startVMs(0, 4, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        int netPort3 = this.startNetworkServer(3, null, null);
        int netPort4 = this.startNetworkServer(4, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        InetAddress localHost = SocketCreator.getLocalHost();
        Connection connSHOP = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, connSHOPProps);
        Statement st = connSHOP.createStatement();
        st.execute("create schema trade");
        String ddl = "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid),  constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) partition by column (tid)";
        st.execute(ddl);
        PreparedStatement psInsert = connSHOP.prepareStatement("insert into trade.portfolio values (?, ?,?,?,?,?)");
        for (int i = 1; i < 5; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(3, i + 10000);
            psInsert.setInt(4, i + 1000);
            psInsert.setFloat(5, 30.4f);
            psInsert.setInt(6, 2);
            for (int j = -2; j < 0; ++j) {
                psInsert.setInt(2, j);
                SingleHopDUnit.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
        }
        String query = "select count(distinct cid) as num_distinct_cid from trade.portfolio where (subTotal<? or subTotal >=?) and tid =?";
        System.out.println(query);
        PreparedStatement ps = connSHOP.prepareStatement(query);
        ps.setObject(1, (Object)50, 3);
        ps.setObject(2, (Object)0, 3);
        ps.setInt(3, 2);
        System.out.println("Results: ");
        ResultSet rs = ps.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            System.out.print("[" + rs.getString(1) + "] ");
            SingleHopDUnit.assertEquals((int)4, (int)rs.getInt(1));
        }
        rs.close();
        SingleHopDUnit.assertEquals((int)1, (int)cnt);
        System.out.println();
        st.execute("drop table trade.portfolio");
        st.execute("drop schema trade restrict");
    }

    public void testSingleHopHA() throws Exception {
        Properties locatorProps = new Properties();
        this.setMasterCommonProperties(locatorProps);
        String locatorBindAddress = SocketCreator.getLocalHost().getHostName();
        int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        SingleHopDUnit._startNewLocator(((Object)((Object)this)).getClass().getName(), this.getName(), locatorBindAddress, locatorPort, null, locatorProps);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.startNetServer(netPort, null);
        final Properties serverProps = new Properties();
        serverProps.setProperty("locators", locatorBindAddress + '[' + locatorPort + ']');
        this.startVMs(0, 4, 0, null, serverProps);
        int netPort1 = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        int netPort3 = this.startNetworkServer(3, null, null);
        int netPort4 = this.startNetworkServer(4, null, null);
        final THashMap serverNumberToNetworkPort = new THashMap();
        serverNumberToNetworkPort.put((Object)1, (Object)netPort1);
        serverNumberToNetworkPort.put((Object)2, (Object)netPort2);
        serverNumberToNetworkPort.put((Object)3, (Object)netPort3);
        serverNumberToNetworkPort.put((Object)4, (Object)netPort4);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        connSHOPProps.setProperty("read-timeout", "10");
        Connection connSHOP = TestUtil.getNetConnection(locatorBindAddress, netPort, null, connSHOPProps);
        Statement st = connSHOP.createStatement();
        String ddl = "create table emp.partitiontesttable (ID int NOT NULL, SECONDID int not null, THIRDID varchar(20) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID) redundancy 2";
        st.execute(ddl);
        this.populate(st, 10000);
        String selectDML = "select * from emp.partitiontesttable where id = ?";
        String selectNoSHOP_DML = "select * from emp.partitiontesttable";
        String updateDML = "update emp.partitiontesttable set secondid = secondid + 1 where id = ?";
        String deleteDML = "delete from emp.partitiontesttable where id = ?";
        String insertDML = "insert into emp.partitiontesttable values(?, ?, ?)";
        String[] dmls = new String[]{selectDML, selectNoSHOP_DML, updateDML, deleteDML, insertDML};
        PreparedStatement pselect = connSHOP.prepareStatement(selectDML);
        PreparedStatement pselectNOSHOP = connSHOP.prepareStatement(selectNoSHOP_DML);
        PreparedStatement pupdate = connSHOP.prepareStatement(updateDML);
        PreparedStatement pdelete = connSHOP.prepareStatement(deleteDML);
        PreparedStatement pinsert = connSHOP.prepareStatement(insertDML);
        ArrayList<PreparedStatement> pslist = new ArrayList<PreparedStatement>();
        Throwable[] failure = new Throwable[1];
        int totOps = 50000;
        pslist.add(pselect);
        pslist.add(pselectNOSHOP);
        pslist.add(pupdate);
        pslist.add(pdelete);
        pslist.add(pinsert);
        final int[] serverStopStartStatus = new int[]{0};
        final Random randomServerSelector = new Random();
        final AtomicBoolean stopServerFlag = new AtomicBoolean(false);
        Thread stopStartTask = new Thread((Runnable)new SerializableRunnable(){

            public void run() {
                while (!stopServerFlag.get()) {
                    int serverNumber = randomServerSelector.nextInt(4) + 1;
                    int netport = (Integer)serverNumberToNetworkPort.get((Object)serverNumber);
                    try {
                        SingleHopDUnit.this.getLogWriter().info((Object)("going to stop server vm: " + serverNumber + " with netport: " + serverNumberToNetworkPort.get((Object)serverNumber)));
                        SingleHopDUnit.this.stopVMNum(-serverNumber);
                        SingleHopDUnit.this.getLogWriter().info((Object)("stopped server vm: " + serverNumber + " and slept for 20 ms, going to restart servervm: " + serverNumber));
                        Thread.sleep(20L);
                        SingleHopDUnit.this.restartServerVMNums(new int[]{serverNumber}, 0, null, serverProps);
                        SingleHopDUnit.this.getLogWriter().info((Object)("starting network server on vm: " + serverNumber));
                        int netPort = SingleHopDUnit.this.startNetworkServer(serverNumber, null, null);
                        SingleHopDUnit.this.getLogWriter().info((Object)("started network server on vm: " + serverNumber + " netport: " + netPort + " and putting in map"));
                        serverNumberToNetworkPort.put((Object)serverNumber, (Object)netPort);
                    }
                    catch (Exception e) {
                        serverStopStartStatus[0] = 1;
                        SingleHopDUnit.this.getLogWriter().error((Object)("problem encountered in stopping vm: " + serverNumber), (Throwable)e);
                        return;
                    }
                }
            }
        });
        stopStartTask.start();
        for (int numOps = 0; numOps < 50000; ++numOps) {
            int idx = randomServerSelector.nextInt(5);
            try {
                this.getLogWriter().info((Object)("going to execute prep statement corresponding to dml: " + dmls[idx]));
                boolean ret = this.executePreparedStatement(pslist, idx, randomServerSelector, 50000, dmls);
                if (ret) continue;
                failure[0] = new Exception("false result");
            }
            catch (SQLException e) {
                this.getLogWriter().error((Object)"got error in executing dmlOPs", (Throwable)e);
                failure[0] = e;
            }
            break;
        }
        stopServerFlag.set(true);
        stopStartTask.join();
        if (failure[0] != null) {
            SingleHopDUnit.fail("problem encountered in executing dmlOps", failure[0]);
        }
        if (serverStopStartStatus[0] != 0) {
            SingleHopDUnit.fail((String)"problem encountered in executing stop start server task");
        }
    }

    private boolean executePreparedStatement(ArrayList<PreparedStatement> pslist, int idx, Random randomServerSelector, int totalOPs, String[] dmls) throws SQLException {
        int val = randomServerSelector.nextInt(totalOPs);
        this.getLogWriter().info((Object)("going to execute prep statement corresponding to dml: " + dmls[idx] + " with val: " + val));
        PreparedStatement ps = pslist.get(idx);
        switch (idx) {
            case 0: {
                ps.setInt(1, val);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && !rs.getString(3).equalsIgnoreCase("number" + val)) {
                    this.getLogWriter().info((Object)("returning false as 3rd column is not equal to: " + "number" + val + " but it is: " + rs.getString(3)));
                    rs.close();
                    return false;
                }
                rs.close();
                return true;
            }
            case 1: {
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    int c1 = rs.getInt(1);
                    this.getLogWriter().info((Object)("col1 is: " + c1 + " and col3 is: " + rs.getString(3)));
                    SingleHopDUnit.assertTrue((boolean)rs.getString(3).equalsIgnoreCase("number" + c1));
                }
                rs.close();
                return true;
            }
            case 2: 
            case 3: {
                ps.setInt(1, val);
                int cnt = ps.executeUpdate();
                return true;
            }
            case 4: {
                ps.setInt(1, val += 1000);
                ps.setInt(2, val);
                ps.setString(3, "number" + val);
                int cnt = 0;
                try {
                    cnt = ps.executeUpdate();
                }
                catch (SQLException sqle) {
                    if (!"23505".equalsIgnoreCase(sqle.getSQLState())) {
                        throw sqle;
                    }
                    return true;
                }
                if (cnt != 1) {
                    this.getLogWriter().info((Object)("returning false as cnt not equal to 1 but: " + cnt + " for val: " + val));
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static void setDRDADebugToTrue() {
        System.setProperty("gemfirexd.drda.debug", "true");
    }

    public void testSingleHopDataCorrectness_allDMLs() throws Exception {
        int firstField;
        this.startVMs(0, 4, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        int netPort3 = this.startNetworkServer(3, null, null);
        int netPort4 = this.startNetworkServer(4, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        InetAddress localHost = SocketCreator.getLocalHost();
        Connection connSHOP = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, connSHOPProps);
        Statement st = connSHOP.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(20) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID) redundancy 2";
        st.execute(ddl);
        this.populate(st, 10);
        String selectDML = "select * from EMP.PARTITIONTESTTABLE";
        PreparedStatement ps = connSHOP.prepareStatement(selectDML);
        ps.execute();
        ResultSet rs = ps.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int expectedSecondField = firstField = rs.getInt(1);
            String expectedThirdField = "number" + firstField;
            SingleHopDUnit.assertEquals((int)expectedSecondField, (int)rs.getInt(2));
            SingleHopDUnit.assertEquals((String)expectedThirdField, (String)rs.getString(3));
        }
        rs.close();
        SingleHopDUnit.assertEquals((int)10, (int)cnt);
        selectDML = "select * from EMP.PARTITIONTESTTABLE where id = ? or id = ?";
        ps = connSHOP.prepareStatement(selectDML);
        ps.setInt(1, 0);
        ps.setInt(2, 5);
        ps.execute();
        rs = ps.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            firstField = rs.getInt(1);
            int secondField = rs.getInt(2);
            String thirdField = rs.getString(3);
            if (firstField == 0) {
                SingleHopDUnit.assertEquals((int)0, (int)rs.getInt(2));
                SingleHopDUnit.assertEquals((String)"number0", (String)rs.getString(3));
                continue;
            }
            if (firstField == 5) {
                SingleHopDUnit.assertEquals((int)5, (int)rs.getInt(2));
                SingleHopDUnit.assertEquals((String)"number5", (String)rs.getString(3));
                continue;
            }
            SingleHopDUnit.fail((String)("expected field 1 to be 0 or 5 but got: " + firstField));
        }
        rs.close();
        SingleHopDUnit.assertEquals((int)2, (int)cnt);
        String updateDML = "update EMP.PARTITIONTESTTABLE set secondid = ? where id = ? or id = ?";
        ps = connSHOP.prepareStatement(updateDML);
        ps.setInt(1, 100);
        ps.setInt(2, 0);
        ps.setInt(3, 5);
        cnt = ps.executeUpdate();
        SingleHopDUnit.assertEquals((int)2, (int)cnt);
        selectDML = "select * from EMP.PARTITIONTESTTABLE";
        ps = connSHOP.prepareStatement(selectDML);
        ps.execute();
        rs = ps.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            int firstGot = rs.getInt(1);
            int secondGot = rs.getInt(2);
            if (firstGot == 0 || firstGot == 5) {
                SingleHopDUnit.assertEquals((int)100, (int)secondGot);
                continue;
            }
            SingleHopDUnit.assertEquals((int)firstGot, (int)secondGot);
        }
        rs.close();
        SingleHopDUnit.assertEquals((int)10, (int)cnt);
        String deleteDML = "delete from EMP.PARTITIONTESTTABLE where id = ? or id = ? or id = 9";
        ps = connSHOP.prepareStatement(deleteDML);
        ps.setInt(1, 0);
        ps.setInt(2, 5);
        cnt = ps.executeUpdate();
        SingleHopDUnit.assertEquals((int)3, (int)cnt);
        selectDML = "select * from EMP.PARTITIONTESTTABLE";
        ps = connSHOP.prepareStatement(selectDML);
        ps.execute();
        rs = ps.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            int firstGot = rs.getInt(1);
            if (firstGot != 0 && firstGot != 5 && firstGot != 9) continue;
            SingleHopDUnit.fail((String)"got deleted rows");
        }
        rs.close();
        SingleHopDUnit.assertEquals((int)7, (int)cnt);
    }

    public void testCompareSingleHopVsSimpleClientConnection_allDMLs() throws Exception {
        int numTimes = 1000;
        boolean warmup = numTimes > 100;
        Properties props = new Properties();
        props.put("log-level", "config");
        if (warmup) {
            SingleHopDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                public void run() {
                    DistributionManager.VERBOSE = false;
                }
            });
        }
        this.startVMs(0, 4, 0, null, props);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        int netPort3 = this.startNetworkServer(3, null, null);
        int netPort4 = this.startNetworkServer(4, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        InetAddress localHost = SocketCreator.getLocalHost();
        Connection connSHOP = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, connSHOPProps);
        Connection connSimple = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, new Properties());
        Statement st = connSimple.createStatement();
        for (int itrNum = 0; itrNum < 6; ++itrNum) {
            String dml = this.getDMLFromItrNum(itrNum, false);
            int redundancy = this.getRedundancyFromItrNum(itrNum);
            String ddlNoRedundancy = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(20) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
            String ddl = redundancy > 0 ? ddlNoRedundancy + " redundancy " + redundancy : ddlNoRedundancy;
            st.execute(ddl);
            this.populate(st, numTimes);
            PreparedStatement psimple = connSimple.prepareStatement(dml);
            PreparedStatement pshop = connSHOP.prepareStatement(dml);
            this.getLogWriter().info((Object)("executing dml: " + dml + " with redundancy: " + redundancy + " and ddl: " + ddl));
            boolean isDelete = dml.startsWith("delete");
            if (warmup) {
                int numTimesToWarmUp = isDelete ? numTimes : numTimes * 5;
                int itrs = isDelete ? 5 : 1;
                for (int i = 0; i < itrs; ++i) {
                    if (isDelete && i > 0) {
                        this.populate(st, numTimes);
                    }
                    this.executeNTimesAndLogTime(psimple, numTimesToWarmUp, "SIMPLE", false, numTimes, dml, redundancy, !warmup);
                    if (isDelete) {
                        this.populate(st, numTimes);
                    }
                    this.executeNTimesAndLogTime(pshop, numTimesToWarmUp, "SINHOP", false, numTimes, dml, redundancy, !warmup);
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (warmup && isDelete || !warmup && isDelete && i > 0) {
                    this.getLogWriter().info((Object)("repopulating before executing dml: " + dml + " with redundancy: " + redundancy + " and ddl: " + ddl));
                    this.populate(st, numTimes);
                }
                if (i % 2 == 0) {
                    this.executeNTimesAndLogTime(pshop, numTimes, "SINHOP", true, numTimes, dml, redundancy, !warmup);
                    continue;
                }
                this.executeNTimesAndLogTime(psimple, numTimes, "SIMPLE", true, numTimes, dml, redundancy, !warmup);
            }
            st.execute("drop table EMP.PARTITIONTESTTABLE");
        }
    }

    public void testCompareSingleHopVsSimpleClientConnection_allDMLs_noPK() throws Exception {
        int numTimes = 10000;
        boolean warmup = numTimes > 100;
        Properties props = new Properties();
        props.put("log-level", "config");
        if (warmup) {
            SingleHopDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                public void run() {
                    DistributionManager.VERBOSE = false;
                }
            });
        }
        this.startVMs(0, 4, 0, null, props);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        int netPort3 = this.startNetworkServer(3, null, null);
        int netPort4 = this.startNetworkServer(4, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        InetAddress localHost = SocketCreator.getLocalHost();
        Connection connSHOP = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, connSHOPProps);
        Connection connSimple = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, new Properties());
        Statement st = connSimple.createStatement();
        for (int itrNum = 0; itrNum < 6; ++itrNum) {
            String dml = this.getDMLFromItrNum_NOPK(itrNum, false);
            int redundancy = this.getRedundancyFromItrNum(itrNum);
            String ddlNoRedundancy = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(20) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
            String ddl = redundancy > 0 ? ddlNoRedundancy + " redundancy " + redundancy : ddlNoRedundancy;
            st.execute(ddl);
            this.populate(st, numTimes);
            PreparedStatement psimple = connSimple.prepareStatement(dml);
            PreparedStatement pshop = connSHOP.prepareStatement(dml);
            this.getLogWriter().info((Object)("executing dml: " + dml + " with redundancy: " + redundancy + " and ddl: " + ddl));
            boolean isDelete = dml.startsWith("delete");
            if (warmup) {
                int numTimesToWarmUp = isDelete ? numTimes : numTimes * 5;
                int itrs = isDelete ? 5 : 1;
                for (int i = 0; i < itrs; ++i) {
                    if (isDelete && i > 0) {
                        this.populate(st, numTimes);
                    }
                    this.executeNTimesAndLogTime(psimple, numTimesToWarmUp, "SIMPLE", false, numTimes, dml, redundancy, !warmup);
                    if (isDelete) {
                        this.populate(st, numTimes);
                    }
                    this.executeNTimesAndLogTime(pshop, numTimesToWarmUp, "SINHOP", false, numTimes, dml, redundancy, !warmup);
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (warmup && isDelete || !warmup && isDelete && i > 0) {
                    this.getLogWriter().info((Object)("repopulating before executing dml: " + dml + " with redundancy: " + redundancy + " and ddl: " + ddl));
                    this.populate(st, numTimes);
                }
                if (i % 2 == 0) {
                    this.executeNTimesAndLogTime(pshop, numTimes, "SINHOP", true, numTimes, dml, redundancy, !warmup);
                    continue;
                }
                this.executeNTimesAndLogTime(psimple, numTimes, "SIMPLE", true, numTimes, dml, redundancy, !warmup);
            }
            st.execute("drop table EMP.PARTITIONTESTTABLE");
        }
    }

    private void populate(Statement st, int numTimes) throws SQLException {
        for (int i = 0; i < numTimes; ++i) {
            String insertSQL = "insert into EMP.PARTITIONTESTTABLE values (" + i + ", " + i + ", 'number" + i + "')";
            st.execute(insertSQL);
        }
    }

    private int getRedundancyFromItrNum(int itrNum) {
        if (itrNum % 2 == 0) {
            return 0;
        }
        return 1;
    }

    private String getDMLFromItrNum(int itrNum, boolean debug) {
        if (!debug) {
            switch (itrNum) {
                case 0: 
                case 1: {
                    return "select * from EMP.PARTITIONTESTTABLE where id = ?";
                }
                case 2: 
                case 3: {
                    return "update EMP.PARTITIONTESTTABLE set secondid = secondid + 1 where id = ?";
                }
                case 4: 
                case 5: {
                    return "delete from EMP.PARTITIONTESTTABLE where id = ?";
                }
            }
            return null;
        }
        switch (itrNum) {
            case 0: {
                return "select * from EMP.PARTITIONTESTTABLE where id = ?";
            }
            case 1: {
                return "update EMP.PARTITIONTESTTABLE set secondid = secondid + 1 where id = ?";
            }
            case 2: {
                return "delete from EMP.PARTITIONTESTTABLE where id = ?";
            }
        }
        return null;
    }

    private String getDMLFromItrNum_NOPK(int itrNum, boolean debug) {
        if (!debug) {
            switch (itrNum) {
                case 0: 
                case 1: {
                    return "select * from EMP.PARTITIONTESTTABLE where id = ?";
                }
                case 2: 
                case 3: {
                    return "update EMP.PARTITIONTESTTABLE set thirdid = 'updated' where id = ?";
                }
                case 4: 
                case 5: {
                    return "delete from EMP.PARTITIONTESTTABLE where id = ?";
                }
            }
            return null;
        }
        switch (itrNum) {
            case 0: {
                return "select * from EMP.PARTITIONTESTTABLE where id = ?";
            }
            case 1: {
                return "update EMP.PARTITIONTESTTABLE set thirdid = 'updated' where id = ?";
            }
            case 2: {
                return "delete from EMP.PARTITIONTESTTABLE where id = ?";
            }
        }
        return null;
    }

    private void executeNTimesAndLogTime(PreparedStatement ps, int times, String type, boolean log, int noOfInserts, String dml, int redundancy, boolean logEach) throws SQLException {
        boolean callExecuteUpdate = this.shouldCallTypeBeExecuteUpdate(dml);
        long starttime = 0L;
        long endtime = 0L;
        if (log) {
            starttime = System.nanoTime();
        }
        for (int j = 0; j < times; ++j) {
            int i = j % noOfInserts;
            ps.setInt(1, i);
            if (callExecuteUpdate) {
                int cnt = ps.executeUpdate();
                if (logEach) {
                    this.getLogWriter().info((Object)("KN: execute update called on dml: " + dml + " and i: " + i + " type: " + type + " and cnt: " + cnt));
                }
                SingleHopDUnit.assertEquals((int)1, (int)cnt);
                continue;
            }
            ps.execute();
            ResultSet rs = ps.getResultSet();
            int cnt = 0;
            while (rs.next()) {
                if (logEach) {
                    this.getLogWriter().info((Object)("KN: (" + type + ") for i = " + i + " result is: " + rs.getInt(1) + ", " + rs.getInt(2) + ", " + rs.getString(3)));
                }
                ++cnt;
            }
            rs.close();
            SingleHopDUnit.assertEquals((int)1, (int)cnt);
        }
        if (log) {
            endtime = System.nanoTime();
        }
        long diff = endtime - starttime;
        if (log) {
            this.getLogWriter().info((Object)("for executing " + dml + " " + times + " times, with redundancy " + redundancy + " time taken by " + type + " was " + diff + " ns"));
        }
        if (type.equals("SINHOP")) {
            SingleHopDUnit.assertTrue((boolean)((SingleHopPreparedStatement)ps).wasSingleHopCalledInExecution());
        }
    }

    private boolean shouldCallTypeBeExecuteUpdate(String dml) {
        return dml.startsWith("delete") || dml.startsWith("update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug48553() throws Exception {
        this.startVMs(1, 4);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        int netPort3 = this.startNetworkServer(3, null, null);
        int netPort4 = this.startNetworkServer(4, null, null);
        TestUtil.loadNetDriver();
        try {
            int rowcount;
            ResultSet r;
            int i;
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create schema trade");
            st.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle varchar(10), c_next varchar(10),c_id int  primary key, c_tid int not null) partition by column (c_tid)");
            st.execute("create table trade.customerrep (c_balance int not null, c_first int not null, c_middle varchar(10), c_next varchar(10), c_id int  primary key, c_tid int not null) replicate");
            st.execute("create INDEX t1index on trade.customer(c_tid)");
            st.execute("create INDEX trep1index on trade.customer(c_tid)");
            String[] securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?, ?, ?)");
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.customerrep values (?, ?, ?, ?, ?, ?)");
            for (int i2 = 0; i2 < 30; ++i2) {
                psInsert.setInt(1, i2);
                psInsert2.setInt(1, i2);
                psInsert.setInt(2, i2 % 3);
                psInsert2.setInt(2, i2 % 3);
                psInsert.setString(3, securities[i2 % 9]);
                psInsert2.setString(3, securities[i2 % 9]);
                psInsert.setString(4, securities[2 * i2 % 9]);
                psInsert2.setString(4, securities[2 * i2 % 9]);
                psInsert.setInt(5, i2 * 4);
                psInsert2.setInt(5, i2 * 4);
                psInsert.setInt(6, i2 % 10);
                psInsert2.setInt(6, i2 % 10);
                psInsert.executeUpdate();
                psInsert2.executeUpdate();
            }
            Properties connSHOPProps = new Properties();
            connSHOPProps.setProperty("single-hop-enabled", "true");
            connSHOPProps.setProperty("single-hop-max-connections", "5");
            connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
            InetAddress localHost = SocketCreator.getLocalHost();
            Connection connSHOP = TestUtil.getNetConnection(localHost.getHostName(), netPort, null, connSHOPProps);
            String query = "select c_first, max(c_id) as amount from trade.customer where c_tid = ? GROUP BY c_first, c_balance ";
            PreparedStatement pst = connSHOP.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                pst.setInt(1, 1);
                r = pst.executeQuery();
                rowcount = 0;
                while (r.next()) {
                    SingleHopDUnit.assertEquals((int)rowcount, (int)r.getInt(1));
                    ++rowcount;
                }
                SingleHopDUnit.assertEquals((int)3, (int)rowcount);
                SingleHopDUnit.assertEquals((int)2, (int)r.getMetaData().getColumnCount());
                r.close();
            }
            query = "select c_first, max(c_id * c_balance) as largest_order from trade.customer where c_tid = ? GROUP BY c_first HAVING max(c_id * c_balance) > 20 ORDER BY max(c_id * c_balance) DESC";
            pst = connSHOP.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                pst.setInt(1, 1);
                r = pst.executeQuery();
                rowcount = 0;
                while (r.next()) {
                    SingleHopDUnit.assertEquals((int)rowcount, (int)r.getInt(1));
                    rowcount += 2;
                }
                SingleHopDUnit.assertEquals((int)4, (int)rowcount);
                SingleHopDUnit.assertEquals((int)2, (int)r.getMetaData().getColumnCount());
                r.close();
            }
            query = "select c_first, cast(avg(c_id * c_balance) as decimal (30, 20)) as amount from trade.customer where c_tid = ? GROUP BY c_first ORDER BY amount";
            pst = connSHOP.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                pst.setInt(1, 1);
                r = pst.executeQuery();
                rowcount = 1;
                while (r.next()) {
                    SingleHopDUnit.assertEquals((int)(rowcount % 3), (int)r.getInt(1));
                    ++rowcount;
                }
                SingleHopDUnit.assertEquals((int)4, (int)rowcount);
                SingleHopDUnit.assertEquals((int)2, (int)r.getMetaData().getColumnCount());
                r.close();
            }
            query = "select c_first, max(c_id) as amount from trade.customerrep where c_tid = ? GROUP BY c_first, c_balance ";
            pst = connSHOP.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                pst.setInt(1, 1);
                r = pst.executeQuery();
                rowcount = 0;
                while (r.next()) {
                    SingleHopDUnit.assertEquals((int)rowcount, (int)r.getInt(1));
                    ++rowcount;
                }
                SingleHopDUnit.assertEquals((int)3, (int)rowcount);
                SingleHopDUnit.assertEquals((int)2, (int)r.getMetaData().getColumnCount());
                r.close();
            }
            query = "select c_first, max(c_id * c_balance) as largest_order from trade.customerrep where c_tid = ? GROUP BY c_first HAVING max(c_id * c_balance) > 20 ORDER BY max(c_id * c_balance) DESC";
            pst = connSHOP.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                pst.setInt(1, 1);
                r = pst.executeQuery();
                rowcount = 0;
                while (r.next()) {
                    SingleHopDUnit.assertEquals((int)rowcount, (int)r.getInt(1));
                    rowcount += 2;
                }
                SingleHopDUnit.assertEquals((int)4, (int)rowcount);
                SingleHopDUnit.assertEquals((int)2, (int)r.getMetaData().getColumnCount());
                r.close();
            }
            query = "select c_first, cast(avg(c_id * c_balance) as decimal (30, 20)) as amount from trade.customerrep where c_tid = ? GROUP BY c_first ORDER BY amount";
            pst = connSHOP.prepareStatement(query);
            for (i = 0; i < 2; ++i) {
                pst.setInt(1, 1);
                r = pst.executeQuery();
                rowcount = 1;
                while (r.next()) {
                    SingleHopDUnit.assertEquals((int)(rowcount % 3), (int)r.getInt(1));
                    ++rowcount;
                }
                SingleHopDUnit.assertEquals((int)4, (int)rowcount);
                SingleHopDUnit.assertEquals((int)2, (int)r.getMetaData().getColumnCount());
                r.close();
            }
            Connection conn1 = TestUtil.getConnection();
            Statement st1 = conn1.createStatement();
            st1.execute("drop table trade.customer");
            st1.execute("drop table trade.customerrep");
            st1.execute("drop schema trade restrict");
        }
        finally {
            TestUtil.shutDown();
        }
    }
}

