/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.junit.UnitTest;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class ShutdownTest
extends TestUtil
implements UnitTest {
    public ShutdownTest(String name) {
        super(name);
    }

    public void testSQLError20001OnFabricServiceStop() throws SQLException {
        try {
            Statement stmt;
            Connection conn;
            block17: {
                Statement childStmnt;
                Connection childConn;
                block16: {
                    block15: {
                        conn = ShutdownTest.getConnection();
                        conn.setTransactionIsolation(2);
                        conn.setAutoCommit(false);
                        stmt = conn.createStatement();
                        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)");
                        stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))");
                        conn.commit();
                        childConn = ShutdownTest.getConnection();
                        childConn.setTransactionIsolation(2);
                        childConn.setAutoCommit(false);
                        childStmnt = childConn.createStatement();
                        childStmnt.execute("insert into t1 values(1, 1, 1)");
                        stmt = conn.createStatement();
                        boolean gotException = false;
                        try {
                            stmt.execute("insert into t2 values(1, 1, 1)");
                        }
                        catch (SQLException sqle) {
                            if (!"X0Z02".equals(sqle.getSQLState())) {
                                throw sqle;
                            }
                            gotException = true;
                        }
                        ShutdownTest.assertTrue((boolean)gotException);
                        childConn.commit();
                        stmt.execute("insert into t2 values(1, 1, 1)");
                        try {
                            childStmnt.execute("update t1 set c2 = 2 where c1 = 1");
                            ShutdownTest.fail("expected conflict exception");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block15;
                            throw sqle;
                        }
                    }
                    try {
                        childStmnt.execute("delete from t1 where c1 = 1");
                        ShutdownTest.fail("expected conflict exception");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block16;
                        throw sqle;
                    }
                }
                conn.rollback();
                childStmnt.execute("update t1 set c2 = 2 where c1 = 1");
                childStmnt.execute("delete from t1 where c1 = 1");
                childConn.commit();
                stmt.execute("delete from t2 where c1 = 1");
                stmt.execute("insert into t1 values(1, 1, 1)");
                conn.commit();
                stmt.execute("insert into t2 values(1, 1, 1)");
                try {
                    stmt.execute("delete from t1 where c1 = 1");
                    ShutdownTest.fail("expected a constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23503".equals(sqle.getSQLState())) break block17;
                    throw sqle;
                }
            }
            stmt.execute("update t1 set c2 = 3 where c1 = 1");
            conn.commit();
            ResultSet rs = stmt.executeQuery("select c2, c3 from t1 where c1 = 1");
            ShutdownTest.assertTrue((boolean)rs.next());
            ShutdownTest.assertEquals((int)3, (int)rs.getInt(1));
            ShutdownTest.assertEquals((int)1, (int)rs.getInt(2));
            ShutdownTest.assertFalse((boolean)rs.next());
            rs.close();
            conn.commit();
            Properties shutdownProperties = new Properties();
            if (bootUserName != null) {
                shutdownProperties.setProperty("user", bootUserName);
                shutdownProperties.setProperty("password", bootUserPassword);
                ShutdownTest.getLogger().info((Object)("shutting down with " + bootUserName + " and boot password " + bootUserPassword));
            } else if (currentUserName != null) {
                shutdownProperties.setProperty("user", currentUserName);
                shutdownProperties.setProperty("password", currentUserPassword);
                ShutdownTest.getLogger().info((Object)("shutting down with " + currentUserName + " and password " + currentUserPassword));
            }
            ShutdownTest.stopNetServer();
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                service.stop(shutdownProperties);
                ShutdownTest.getLogger().info((Object)("Fabric Server shutdown status " + service.status()));
            }
        }
        catch (SQLException e) {
            ShutdownTest.assertFalse((boolean)e.getSQLState().equals("25001"));
            throw e;
        }
    }
}

