/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.tools.GfxdSystemAdmin;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.VM;
import java.util.Arrays;

public class ShutdownDUnit
extends DistributedSQLTestBase {
    public ShutdownDUnit(String name) {
        super(name);
    }

    public boolean verifyFabricServiceRunningStatus(boolean expectedRunning) {
        int numServers = this.serverVMs.size();
        for (int i = 1; i <= numServers; ++i) {
            VM executeVM = this.getServerVM(i);
            Object r = executeVM.invoke(ShutdownDUnit.class, "isFabricServiceRunning");
            if (!(r instanceof Boolean)) {
                return false;
            }
            Boolean running = (Boolean)r;
            if (running.equals(expectedRunning)) continue;
            return false;
        }
        return true;
    }

    public static Boolean isFabricServiceRunning() throws Exception {
        FabricService service = FabricServiceManager.currentFabricServiceInstance();
        return service == null ? false : service.status().equals((Object)FabricService.State.RUNNING);
    }

    public void testBug45163() throws Exception {
        this.startVMs(0, 3);
        ShutdownDUnit.assertTrue((boolean)this.verifyFabricServiceRunningStatus(true));
        new GfxdSystemAdmin().shutDownAll("shut-down-all", Arrays.asList("-locators=" + this.getLocatorString(), "-log-level=fine"));
        ShutdownDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                return ShutdownDUnit.this.verifyFabricServiceRunningStatus(false);
            }

            public String description() {
                return "waiting for servers to stop";
            }
        }, (long)30000L, (long)200L, (boolean)true);
    }
}

