/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.cache.locks.ReentrantReadWriteWriteShareLock;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.ByteCompareTest;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.ServerResolverUtils;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class OffHeapByteCompareTest
extends ByteCompareTest {
    private final int maxBatchSize;
    private final Map<Integer, ReentrantReadWriteWriteShareLock> map;
    private OffHeapByteSource[] byteSources;

    public OffHeapByteCompareTest(String name) throws Exception {
        super(name);
        Class<OffHeapRegionEntryUtils> clazz = OffHeapRegionEntryUtils.class;
        Field field = clazz.getDeclaredField("MAX_BATCH_SIZE");
        field.setAccessible(true);
        this.maxBatchSize = field.getInt(null);
        this.map = new HashMap<Integer, ReentrantReadWriteWriteShareLock>();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(OffHeapByteCompareTest.class));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    public void _testBug() throws Exception {
        int numObj = 500;
        for (int i = 0; i < 500; ++i) {
            this.map.put(i, new ReentrantReadWriteWriteShareLock());
        }
        int NUM_THREAD = 20;
        final CyclicBarrier barrier = new CyclicBarrier(20);
        OffHeapByteCompareTest.setupConnection();
        final LogWriter logger = Misc.getDistributedSystem().getLogWriter();
        int BATCH_SIZE = 20000;
        int TOTAL_BYTE_SOURCES = 8000;
        this.byteSources = new OffHeapByteSource[20000];
        Random rand = new Random();
        for (int i = 0; i < 8000; ++i) {
            OffHeapByteSource bs;
            int num = -1;
            while (num == -1) {
                int temp = rand.nextInt(1000);
                if (temp <= 10) continue;
                num = temp;
            }
            String str = OffHeapByteCompareTest.getMultiByteUTF_8String(num);
            byte[] data = str.getBytes("UTF-8");
            this.byteSources[i] = bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        }
        Runnable bulkPutAndRelease = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("waiting on barrier");
                    barrier.await();
                    logger.info("barrier broken");
                    Random random = new Random();
                    long startTime = System.currentTimeMillis();
                    int loopCount = 0;
                    LinkedList<OffHeapByteSource> bss = new LinkedList<OffHeapByteSource>();
                    while (true) {
                        char[] chars = new char[1000];
                        for (int j = 0; j < 20000; ++j) {
                            OffHeapByteSource bs = OffHeapByteCompareTest.this.byteSources[random.nextInt(8000)];
                            bs.retain();
                            logger.info("Written batch =" + j + " for loop count =" + loopCount);
                            bss.add(bs);
                            ReentrantReadWriteWriteShareLock obj = (ReentrantReadWriteWriteShareLock)OffHeapByteCompareTest.this.map.get(j % 500);
                            TestCase.assertTrue((boolean)obj.attemptLock(LockMode.SH, 300000L, (Object)Thread.currentThread()));
                        }
                        logger.info("Written batch for loop count =" + loopCount);
                        for (OffHeapByteSource bs : bss) {
                            SQLChar.readIntoCharsForTesting((Object)bs, (int)0, (int)bs.getLength(), (char[])chars);
                        }
                        logger.info("read batch for loop count =" + loopCount);
                        int k = 0;
                        for (OffHeapByteSource bs : bss) {
                            bs.release();
                            ((ReentrantReadWriteWriteShareLock)OffHeapByteCompareTest.this.map.get(k % 500)).releaseLock(LockMode.SH, false, (Object)Thread.currentThread());
                            ++k;
                        }
                        logger.info("released batch for loop count =" + loopCount);
                        bss.clear();
                        if (loopCount % 100 != 0 || System.currentTimeMillis() - startTime <= 3600000L) {
                            ++loopCount;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread[] ths = new Thread[20];
        for (int i = 0; i < 20; ++i) {
            ths[i] = new Thread(bulkPutAndRelease);
        }
        for (Thread th : ths) {
            th.start();
        }
        Thread[] arr$ = ths;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Thread th;
            th = arr$[i$];
            th.join();
        }
        for (int i = 0; i < 500; ++i) {
            ReentrantReadWriteWriteShareLock lock = this.map.get(i);
            OffHeapByteCompareTest.assertTrue((boolean)lock.attemptLock(LockMode.EX, 300000L, (Object)Thread.currentThread()));
            lock.releaseLock(LockMode.EX, false, (Object)Thread.currentThread());
        }
        for (OffHeapByteSource bs : this.byteSources) {
            bs.release();
        }
    }

    public void testServerResolverUtilsHashCode() throws Exception {
        int i;
        OffHeapByteCompareTest.setupConnection();
        byte[] data = new byte[10];
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = (byte)(i2 % 255);
        }
        OffHeapRow bs = (OffHeapRow)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)ResolverUtils.addBytesToHash((byte[])data, (int)0, (int)data.length, (int)7), (int)ServerResolverUtils.addBytesToHash((OffHeapByteSource)bs, (int)0, (int)data.length, (int)7));
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize - 10];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        bs = (OffHeapRow)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)ResolverUtils.addBytesToHash((byte[])data, (int)5, (int)(data.length - 10), (int)7), (int)ServerResolverUtils.addBytesToHash((OffHeapByteSource)bs, (int)5, (int)(data.length - 10), (int)7));
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize * 5];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        bs = (OffHeapRow)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)ResolverUtils.addBytesToHash((byte[])data, (int)21, (int)(data.length - 103), (int)7), (int)ServerResolverUtils.addBytesToHash((OffHeapByteSource)bs, (int)21, (int)(data.length - 103), (int)7));
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        bs = (OffHeapRow)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)ResolverUtils.addBytesToHash((byte[])data, (int)0, (int)data.length, (int)7), (int)ServerResolverUtils.addBytesToHash((OffHeapByteSource)bs, (int)0, (int)data.length, (int)7));
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        bs = (OffHeapRow)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)ResolverUtils.addBytesToHash((byte[])data, (int)0, (int)data.length, (int)7), (int)ServerResolverUtils.addBytesToHash((OffHeapByteSource)bs, (int)0, (int)bs.getLength(), (int)7));
        OffHeapHelper.release((Object)bs);
    }

    private static int compareString(OffHeapByteSource lhs, OffHeapByteSource rhs, int lhsOffset, int lhsColumnWidth, int rhsOffset, int rhsColumnWidth) {
        return SQLChar.compareString((UnsafeWrapper)UnsafeMemoryChunk.getUnsafeWrapper(), (long)lhs.getUnsafeAddress(lhsOffset, lhsColumnWidth), (int)lhsColumnWidth, (OffHeapByteSource)lhs, (long)rhs.getUnsafeAddress(rhsOffset, rhsColumnWidth), (int)rhsColumnWidth, (OffHeapByteSource)rhs);
    }

    private static int compareString(byte[] lhs, OffHeapByteSource rhs, int lhsOffset, int lhsColumnWidth, int rhsOffset, int rhsColumnWidth) {
        return SQLChar.compareString((UnsafeWrapper)UnsafeMemoryChunk.getUnsafeWrapper(), (byte[])lhs, (int)lhsOffset, (int)lhsColumnWidth, (long)rhs.getUnsafeAddress(rhsOffset, rhsColumnWidth), (int)rhsColumnWidth, (OffHeapByteSource)rhs);
    }

    private static int compareStringIgnoreCase(OffHeapByteSource lhs, OffHeapByteSource rhs, int lhsOffset, int lhsColumnWidth, int rhsOffset, int rhsColumnWidth) {
        return SQLChar.compareStringIgnoreCase((UnsafeWrapper)UnsafeMemoryChunk.getUnsafeWrapper(), (long)lhs.getUnsafeAddress(lhsOffset, lhsColumnWidth), (int)lhsColumnWidth, (OffHeapByteSource)lhs, (long)rhs.getUnsafeAddress(rhsOffset, rhsColumnWidth), (int)rhsColumnWidth, (OffHeapByteSource)rhs);
    }

    private static int compareStringIgnoreCase(byte[] lhs, OffHeapByteSource rhs, int lhsOffset, int lhsColumnWidth, int rhsOffset, int rhsColumnWidth) {
        return SQLChar.compareStringIgnoreCase((UnsafeWrapper)UnsafeMemoryChunk.getUnsafeWrapper(), (byte[])lhs, (int)lhsOffset, (int)lhsColumnWidth, (long)rhs.getUnsafeAddress(rhsOffset, rhsColumnWidth), (int)rhsColumnWidth, (OffHeapByteSource)rhs);
    }

    public void testSQLCharCompareString() throws Exception {
        OffHeapByteCompareTest.setupConnection();
        byte[] data = new byte[this.maxBatchSize - 50];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        OffHeapByteSource bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(bs, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(data, bs, 5, data.length - 5, 5, bs.getLength() - 5));
        bs.release();
        data = new byte[2 * this.maxBatchSize + 87];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(bs, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(data, bs, 5, data.length - 5, 5, bs.getLength() - 5));
        bs.release();
        String str = OffHeapByteCompareTest.getMultiByteUTF_8String(this.maxBatchSize * 3 + 103);
        data = str.getBytes("UTF-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(bs, bs, 0, data.length, 0, bs.getLength()));
        bs.release();
        data = new byte[2 * this.maxBatchSize + 87];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        String b = new String(data);
        b = b + "abcdefgh";
        byte[] bBytes = b.getBytes("UTF-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareString(bs, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertTrue((SQLChar.compareString((byte[])bBytes, (int)0, (int)bBytes.length, (byte[])data, (int)0, (int)data.length) > 0 ? 1 : 0) != 0);
        OffHeapByteCompareTest.assertTrue((OffHeapByteCompareTest.compareString(bBytes, bs, 0, bBytes.length, 0, bs.getLength()) > 0 ? 1 : 0) != 0);
        bs.release();
    }

    public void testSQLCharCompareStringIgnoreCase() throws Exception {
        OffHeapByteCompareTest.setupConnection();
        byte[] data = new byte[this.maxBatchSize - 50];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        String str = new String(data);
        data = str.toLowerCase().getBytes("UTF-8");
        OffHeapByteSource bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        data = str.toUpperCase().getBytes("UTF-8");
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(bs, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(data, bs, 5, data.length - 5, 5, bs.getLength() - 5));
        bs.release();
        data = new byte[2 * this.maxBatchSize + 87];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        str = new String(data);
        data = str.toLowerCase().getBytes("UTF-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        data = str.toUpperCase().getBytes("UTF-8");
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(bs, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(data, bs, 5, data.length - 5, 5, bs.getLength() - 5));
        bs.release();
        str = OffHeapByteCompareTest.getMultiByteUTF_8String(this.maxBatchSize * 3 + 103);
        data = str.getBytes("UTF-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(bs, bs, 0, data.length, 0, bs.getLength()));
        bs.release();
        data = new byte[2 * this.maxBatchSize + 87];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        String b = new String(data);
        b = b + "abcdefgh";
        byte[] bBytes = b.getBytes("UTF-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(data, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertEquals((int)0, (int)OffHeapByteCompareTest.compareStringIgnoreCase(bs, bs, 0, data.length, 0, bs.getLength()));
        OffHeapByteCompareTest.assertTrue((OffHeapByteCompareTest.compareStringIgnoreCase(bBytes, bs, 0, bBytes.length, 0, bs.getLength()) > 0 ? 1 : 0) != 0);
        OffHeapByteCompareTest.assertTrue((SQLChar.compareStringIgnoreCase((byte[])bBytes, (int)0, (int)bBytes.length, (byte[])data, (int)0, (int)data.length) > 0 ? 1 : 0) != 0);
        bs.release();
    }

    public void testSQLCharReadIntoCharsFromByteSource() throws Exception {
        OffHeapByteCompareTest.setupConnection();
        byte[] data = new byte[this.maxBatchSize * 2 + 53];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        String controlData = new String(data, "utf-8");
        OffHeapByteSource bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        char[] chars = new char[data.length];
        SQLChar.readIntoCharsForTesting((Object)bs, (int)0, (int)data.length, (char[])chars);
        String controlOutput = new String(chars);
        OffHeapByteCompareTest.assertEquals((String)controlData, (String)controlOutput);
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize - 53];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        controlData = new String(data, "utf-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        chars = new char[data.length];
        SQLChar.readIntoCharsForTesting((Object)bs, (int)0, (int)data.length, (char[])chars);
        controlOutput = new String(chars);
        OffHeapByteCompareTest.assertEquals((String)controlData, (String)controlOutput);
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        controlData = new String(data, "utf-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        chars = new char[data.length];
        SQLChar.readIntoCharsForTesting((Object)bs, (int)0, (int)data.length, (char[])chars);
        controlOutput = new String(chars);
        OffHeapByteCompareTest.assertEquals((String)controlData, (String)controlOutput);
        OffHeapHelper.release((Object)bs);
        String multiByteString = OffHeapByteCompareTest.getMultiByteUTF_8String(this.maxBatchSize * 2 + 76);
        data = multiByteString.getBytes("UTF-8");
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        chars = new char[data.length];
        int n = SQLChar.readIntoCharsForTesting((Object)bs, (int)0, (int)data.length, (char[])chars);
        controlOutput = new String(chars, 0, n);
        OffHeapByteCompareTest.assertEquals((String)multiByteString, (String)controlOutput);
        OffHeapHelper.release((Object)bs);
    }

    public void testSQLCharReadIntoCharsFromByteSourceSampleUTF_8() throws Exception {
        OffHeapByteCompareTest.setupConnection();
        String sample = "Russian :\u041d\u0430 \u0431\u0435\u0440\u0435\u0433\u0443 \u043f\u0443\u0441\u0442\u044b\u043d\u043d\u044b\u0445 \u0432\u043e\u043b\u043d\u0421\u0442\u043e\u044f\u043b \u043e\u043d, \u0434\u0443\u043c \u0432\u0435\u043b\u0438\u043a\u0438\u0445 \u043f\u043e\u043b\u043d,\u0418 \u0432\u0434\u0430\u043b\u044c \u0433\u043b\u044f\u0434\u0435\u043b. \u041f\u0440\u0435\u0434 \u043d\u0438\u043c \u0448\u0438\u0440\u043e\u043a\u043e\u0420\u0435\u043a\u0430 \u043d\u0435\u0441\u043b\u0430\u0441\u044f; \u0431\u0435\u0434\u043d\u044b\u0439 \u0447\u0451\u043b\u043d\u041f\u043e \u043d\u0435\u0439 \u0441\u0442\u0440\u0435\u043c\u0438\u043b\u0441\u044f \u043e\u0434\u0438\u043d\u043e\u043a\u043e.\u041f\u043e \u043c\u0448\u0438\u0441\u0442\u044b\u043c, \u0442\u043e\u043f\u043a\u0438\u043c \u0431\u0435\u0440\u0435\u0433\u0430\u043c\u0427\u0435\u0440\u043d\u0435\u043b\u0438 \u0438\u0437\u0431\u044b \u0437\u0434\u0435\u0441\u044c \u0438 \u0442\u0430\u043c,\u041f\u0440\u0438\u044e\u0442 \u0443\u0431\u043e\u0433\u043e\u0433\u043e \u0447\u0443\u0445\u043e\u043d\u0446\u0430;\u0418 \u043b\u0435\u0441, \u043d\u0435\u0432\u0435\u0434\u043e\u043c\u044b\u0439 \u043b\u0443\u0447\u0430\u043c\u0412 \u0442\u0443\u043c\u0430\u043d\u0435 \u0441\u043f\u0440\u044f\u0442\u0430\u043d\u043d\u043e\u0433\u043e \u0441\u043e\u043b\u043d\u0446\u0430,\u041a\u0440\u0443\u0433\u043e\u043c \u0448\u0443\u043c\u0435\u043b.Tamil\u0baf\u0bbe\u0bae\u0bb1\u0bbf\u0ba8\u0bcd\u0ba4 \u0bae\u0bca\u0bb4\u0bbf\u0b95\u0bb3\u0bbf\u0bb2\u0bc7 \u0ba4\u0bae\u0bbf\u0bb4\u0bcd\u0bae\u0bca\u0bb4\u0bbf \u0baa\u0bcb\u0bb2\u0bcd \u0b87\u0ba9\u0bbf\u0ba4\u0bbe\u0bb5\u0ba4\u0bc1 \u0b8e\u0b99\u0bcd\u0b95\u0bc1\u0bae\u0bcd \u0b95\u0bbe\u0ba3\u0bcb\u0bae\u0bcd,\u0baa\u0bbe\u0bae\u0bb0\u0bb0\u0bbe\u0baf\u0bcd \u0bb5\u0bbf\u0bb2\u0b99\u0bcd\u0b95\u0bc1\u0b95\u0bb3\u0bbe\u0baf\u0bcd, \u0b89\u0bb2\u0b95\u0ba9\u0bc8\u0ba4\u0bcd\u0ba4\u0bc1\u0bae\u0bcd \u0b87\u0b95\u0bb4\u0bcd\u0b9a\u0bcd\u0b9a\u0bbf\u0b9a\u0bca\u0bb2\u0baa\u0bcd \u0baa\u0bbe\u0ba9\u0bcd\u0bae\u0bc8 \u0b95\u0bc6\u0b9f\u0bcd\u0b9f\u0bc1,\u0ba8\u0bbe\u0bae\u0bae\u0ba4\u0bc1 \u0ba4\u0bae\u0bbf\u0bb4\u0bb0\u0bc6\u0ba9\u0b95\u0bcd \u0b95\u0bca\u0ba3\u0bcd\u0b9f\u0bc1 \u0b87\u0b99\u0bcd\u0b95\u0bc1 \u0bb5\u0bbe\u0bb4\u0bcd\u0ba8\u0bcd\u0ba4\u0bbf\u0b9f\u0bc1\u0ba4\u0bb2\u0bcd \u0ba8\u0ba9\u0bcd\u0bb1\u0bcb? \u0b9a\u0bca\u0bb2\u0bcd\u0bb2\u0bc0\u0bb0\u0bcd!\u0ba4\u0bc7\u0bae\u0ba4\u0bc1\u0bb0\u0ba4\u0bcd \u0ba4\u0bae\u0bbf\u0bb4\u0bcb\u0b9a\u0bc8 \u0b89\u0bb2\u0b95\u0bae\u0bc6\u0bb2\u0bbe\u0bae\u0bcd \u0baa\u0bb0\u0bb5\u0bc1\u0bae\u0bcd\u0bb5\u0b95\u0bc8 \u0b9a\u0bc6\u0baf\u0bcd\u0ba4\u0bb2\u0bcd \u0bb5\u0bc7\u0ba3\u0bcd\u0b9f\u0bc1\u0bae\u0bcd.Kanada:\u0cac\u0cbe \u0c87\u0cb2\u0ccd\u0cb2\u0cbf \u0cb8\u0c82\u0cad\u0cb5\u0cbf\u0cb8\u0cc1 \u0c87\u0c82\u0ca6\u0cc6\u0ca8\u0ccd\u0ca8 \u0cb9\u0cc3\u0ca6\u0caf\u0ca6\u0cb2\u0cbf \u0ca8\u0cbf\u0ca4\u0ccd\u0caf\u0cb5\u0cc2 \u0c85\u0cb5\u0ca4\u0cb0\u0cbf\u0caa \u0cb8\u0ca4\u0ccd\u0caf\u0cbe\u0cb5\u0ca4\u0cbe\u0cb0\u0cae\u0ca3\u0ccd\u0ca3\u0cbe\u0c97\u0cbf \u0cae\u0cb0\u0cb5\u0cbe\u0c97\u0cbf \u0cae\u0cbf\u0c97\u0cb5\u0cbe\u0c97\u0cbf \u0c95\u0c97\u0cb5\u0cbe\u0c97\u0cc0...\u0cae\u0ca3\u0ccd\u0ca3\u0cbe\u0c97\u0cbf \u0cae\u0cb0\u0cb5\u0cbe\u0c97\u0cbf \u0cae\u0cbf\u0c97\u0cb5\u0cbe\u0c97\u0cbf \u0c95\u0c97\u0cb5\u0cbe\u0c97\u0cbf\u0cad\u0cb5 \u0cad\u0cb5\u0ca6\u0cbf \u0cad\u0ca4\u0cbf\u0cb8\u0cbf\u0cb9\u0cc7 \u0cad\u0cb5\u0ca4\u0cbf \u0ca6\u0cc2\u0cb0\u0ca8\u0cbf\u0ca4\u0ccd\u0caf\u0cb5\u0cc2 \u0c85\u0cb5\u0ca4\u0cb0\u0cbf\u0caa \u0cb8\u0ca4\u0ccd\u0caf\u0cbe\u0cb5\u0ca4\u0cbe\u0cb0 || \u0cac\u0cbe \u0c87\u0cb2\u0ccd\u0cb2\u0cbf ||";
        byte[] utf_8_bytes = sample.getBytes("UTF-8");
        char[] chars = new char[utf_8_bytes.length];
        System.out.println("length=" + utf_8_bytes.length);
        OffHeapByteSource bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])utf_8_bytes, (boolean)true);
        int numCharRead = SQLChar.readIntoCharsForTesting((Object)bs, (int)0, (int)utf_8_bytes.length, (char[])chars);
        String controlOutput = new String(chars, 0, numCharRead);
        OffHeapByteCompareTest.assertEquals((String)sample, (String)controlOutput);
        OffHeapHelper.release((Object)bs);
    }

    public void testOffHeapByteSourceSerialization() throws Exception {
        OffHeapByteCompareTest.setupConnection();
        byte[] data = new byte[this.maxBatchSize * 2 + 53];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        OffHeapByteSource bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        ByteArrayOutputStream controlBaos = new ByteArrayOutputStream();
        DataOutputStream controlDao = new DataOutputStream(controlBaos);
        InternalDataSerializer.writeObject((Object)data, (DataOutput)controlDao);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dao = new DataOutputStream(baos);
        bs.sendTo((DataOutput)dao);
        baos.flush();
        byte[] outputBytes = baos.toByteArray();
        OffHeapByteCompareTest.assertTrue((boolean)Arrays.equals(controlBaos.toByteArray(), outputBytes));
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize * 2];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        controlBaos = new ByteArrayOutputStream();
        controlDao = new DataOutputStream(controlBaos);
        InternalDataSerializer.writeObject((Object)data, (DataOutput)controlDao);
        baos = new ByteArrayOutputStream();
        dao = new DataOutputStream(baos);
        bs.sendTo((DataOutput)dao);
        baos.flush();
        outputBytes = baos.toByteArray();
        OffHeapByteCompareTest.assertTrue((boolean)Arrays.equals(controlBaos.toByteArray(), outputBytes));
        OffHeapHelper.release((Object)bs);
        data = new byte[this.maxBatchSize - 50];
        OffHeapByteCompareTest.fillSingleByteUTF_8(data);
        bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        controlBaos = new ByteArrayOutputStream();
        controlDao = new DataOutputStream(controlBaos);
        InternalDataSerializer.writeObject((Object)data, (DataOutput)controlDao);
        baos = new ByteArrayOutputStream();
        dao = new DataOutputStream(baos);
        bs.sendTo((DataOutput)dao);
        baos.flush();
        outputBytes = baos.toByteArray();
        OffHeapByteCompareTest.assertTrue((boolean)Arrays.equals(controlBaos.toByteArray(), outputBytes));
        OffHeapHelper.release((Object)bs);
    }

    public void testOffHeapByteSourceReadLong() throws Exception {
        OffHeapByteCompareTest.setupConnection();
        ByteArrayOutputStream controlBaos = new ByteArrayOutputStream();
        DataOutputStream controlDao = new DataOutputStream(controlBaos);
        controlDao.writeLong(Long.MAX_VALUE);
        controlDao.writeLong(Long.MIN_VALUE);
        controlDao.writeLong(127L);
        controlDao.writeLong(-128L);
        controlDao.writeLong(32767L);
        controlDao.writeLong(-32768L);
        controlDao.writeLong(Integer.MAX_VALUE);
        controlDao.writeLong(Integer.MIN_VALUE);
        controlBaos.flush();
        byte[] data = controlBaos.toByteArray();
        OffHeapByteSource bs = (OffHeapByteSource)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])data, (boolean)true);
        DataInput result = bs.getDataInputStreamWrapper(0, bs.getLength());
        OffHeapByteCompareTest.assertEquals((long)Long.MAX_VALUE, (long)result.readLong());
        OffHeapByteCompareTest.assertEquals((long)Long.MIN_VALUE, (long)result.readLong());
        OffHeapByteCompareTest.assertEquals((long)127L, (long)result.readLong());
        OffHeapByteCompareTest.assertEquals((long)-128L, (long)result.readLong());
        OffHeapByteCompareTest.assertEquals((long)32767L, (long)result.readLong());
        OffHeapByteCompareTest.assertEquals((long)-32768L, (long)result.readLong());
        OffHeapByteCompareTest.assertEquals((long)Integer.MAX_VALUE, (long)result.readLong());
        OffHeapByteCompareTest.assertEquals((long)Integer.MIN_VALUE, (long)result.readLong());
        OffHeapHelper.release((Object)bs);
    }

    private static void fillSingleByteUTF_8(byte[] data) {
        byte startChar = 0;
        byte endChar = 127;
        byte charCount = startChar;
        for (int i = 0; i < data.length; ++i) {
            data[i] = charCount;
            charCount = charCount == endChar ? startChar : (byte)(charCount + 1);
        }
    }

    private static String getMultiByteUTF_8String(int numCodePoints) {
        StringBuilder sb = new StringBuilder();
        int startSingleByteChar = 0;
        int endSingleChar = 127;
        int singleCharCount = startSingleByteChar;
        int startDoubleByteChar = 128;
        int endDoubleByteChar = 2047;
        int doubleCharCount = startDoubleByteChar;
        int startTripleByteChar = 2048;
        int endTripleByteChar = 65535;
        int tripleCharCount = startTripleByteChar;
        for (int i = 0; i < numCodePoints; ++i) {
            sb.appendCodePoint(singleCharCount);
            singleCharCount = singleCharCount == endSingleChar ? startSingleByteChar : (int)((byte)(singleCharCount + 1));
            if (++i == numCodePoints) break;
            sb.appendCodePoint(doubleCharCount);
            doubleCharCount = doubleCharCount == endDoubleByteChar ? startDoubleByteChar : ++doubleCharCount;
            if (++i == numCodePoints) break;
            sb.appendCodePoint(tripleCharCount);
            if (tripleCharCount == endTripleByteChar) {
                tripleCharCount = startTripleByteChar;
                continue;
            }
            ++tripleCharCount;
        }
        return sb.toString();
    }

    @Override
    protected String getOffHeapSuffix() {
        return " offheap ";
    }
}

