/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.diag.MemoryAnalyticsVTI;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ProjectRestrictResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.VTIResultSet;
import com.pivotal.gemfirexd.internal.vti.IQualifyable;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class MemoryAnalyticsTest
extends JdbcTestBase {
    boolean generateComparisonValues = false;
    boolean testSimpleQueryCalledAgain = false;

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(MemoryAnalyticsTest.class));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = true;
        MemoryAnalyticsVTI.TEST_MODE = true;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.delete(new File("./myhdfs"));
        this.delete(new File("./gemfire"));
        DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = false;
        MemoryAnalyticsVTI.TEST_MODE = false;
    }

    public MemoryAnalyticsTest(String name) {
        super(name);
    }

    public void testSimpleQuerying() throws Exception {
        String tableName;
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        props.setProperty("table-default-partitioned", "false");
        props.setProperty("server-groups", "dbsync");
        props.setProperty("persist-dd", "true");
        Connection conn = MemoryAnalyticsTest.getConnection(props);
        String useCase3Script = TestUtil.getResourcesDir() + "/lib/useCase3Data/schema.sql";
        if (!this.testSimpleQueryCalledAgain) {
            GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase3Script}, (boolean)false, (Logger)MemoryAnalyticsTest.getLogger(), null, null, (boolean)false);
            String useCase3DataScript = TestUtil.getResourcesDir() + "/lib/useCase3Data/importAll.sql";
            GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase3DataScript}, (boolean)false, (Logger)MemoryAnalyticsTest.getLogger(), (String)"<path_prefix>", (String)TestUtil.getResourcesDir(), (boolean)false);
        }
        Statement stmt = conn.createStatement();
        java.sql.ResultSet rs = stmt.executeQuery("select * from sys.memoryanalytics ");
        String[] columnList = new String[]{"TABLE_NAME", "INDEX_NAME", "INDEX_TYPE", "CONSTANT_OVERHEAD", "ENTRY_SIZE", "KEY_SIZE", "VALUE_SIZE", "VALUE_SIZE_OFFHEAP", "NUM_ROWS", "NUM_KEYS_IN_MEMORY", "NUM_VALUES_IN_MEMORY", "NUM_VALUES_IN_OFFHEAP", "TOTAL_SIZE"};
        HashMap<String, float[]> indexColValues = new HashMap<String, float[]>();
        indexColValues.put("TF_GEMFIRE_PAA_ID", new float[]{0.152f, 0.072f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.224f});
        indexColValues.put("TF_GEMFIRE_PAA_NUI", new float[]{0.152f, 0.072f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.224f});
        indexColValues.put("TF_EQRMS_PAA_ID", new float[]{0.152f, 0.072f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.224f});
        indexColValues.put("TF_EQRMS_PAA_NUI", new float[]{0.152f, 0.072f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.224f});
        indexColValues.put("TF_EDEALER_PAA_ID", new float[]{0.152f, 0.072f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.224f});
        indexColValues.put("TF_EDEALER_PAA_NUI", new float[]{0.152f, 0.072f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.224f});
        indexColValues.put("IDX_FACT1_TM_ID", new float[]{0.152f, 0.368f, 0.0f, 0.9f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 1.42f});
        indexColValues.put("IDX_SOURCE_ID", new float[]{0.152f, 5.392f, 0.0f, 0.472f, 0.0f, 97.0f, 0.0f, 0.0f, 0.0f, 6.016f});
        indexColValues.put("IDX_FACT3_POSN_ID", new float[]{0.152f, 4.912f, 0.0f, 0.484f, 0.0f, 97.0f, 0.0f, 0.0f, 0.0f, 5.548f});
        indexColValues.put("IDX_FACT2_POSN_ID", new float[]{0.152f, 4.944f, 0.0f, 0.484f, 0.0f, 97.0f, 0.0f, 0.0f, 0.0f, 5.58f});
        indexColValues.put("IDX_ADJ_POSN_ID", new float[]{0.152f, 4.912f, 0.0f, 0.484f, 0.0f, 97.0f, 0.0f, 0.0f, 0.0f, 5.548f});
        indexColValues.put("IDX_TRADER_FIRM_ID", new float[]{0.152f, 5.288f, 0.0f, 0.4f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, 5.84f});
        indexColValues.put("IDX_EXT_ID", new float[]{0.152f, 4.992f, 0.0f, 0.428f, 0.0f, 99.0f, 0.0f, 0.0f, 0.0f, 5.572f});
        indexColValues.put("IDX_INSM_ID", new float[]{0.152f, 5.56f, 0.0f, 0.456f, 0.0f, 98.0f, 0.0f, 0.0f, 0.0f, 6.168f});
        String[] expectedOutputArr = new String[]{"APP.TL_CURRENCY null null 1.696 0.0 0.0 0.0 0.0 0 0 0 0 1.696 ", "APP.TD_PL_POSITION_INDICATIVE null null 1.696 0.0 0.0 0.0 0.0 0 0 0 0 1.696 ", "APP.TF_EDEALER_PAA null null 1.808 0.0 0.0 0.0 0.0 0 0 0 0 1.808 ", "APP.TF_GEMFIRE_PAA null null 1.808 0.0 0.0 0.0 0.0 0 0 0 0 1.808 ", "APP.TF_PL_POSITION_YTD null null 1.808 12.0 2.4 626.912 0.0 100 100 100 0 643.12 ", "APP.TD_POSN_EXTENDED_KEY null null 1.696 9.6 2.4 25.472 0.0 100 100 100 0 39.168 ", "APP.TX_PL_POSITION null null 1.808 0.0 0.0 0.0 0.0 0 0 0 0 1.808 ", "APP.TF_PL_POSITION_PTD null null 1.808 12.0 2.4 299.88 0.0 100 100 100 0 316.088 ", "APP.TD_TRADER_SCD null null 1.696 9.6 2.4 217.448 0.0 100 100 100 0 231.144 ", "APP.TF_PL_POSITION_FUNC null null 1.808 0.0 0.0 0.0 0.0 0 0 0 0 1.808 ", "APP.TF_PL_ADJ_REPORT null null 1.808 12.0 2.4 622.6 0.0 100 100 100 0 638.808 ", "APP.TF_PL_POSITION_DLY null null 1.808 0.0 0.0 0.0 0.0 0 0 0 0 1.808 ", "APP.TF_EQRMS_PAA null null 1.808 0.0 0.0 0.0 0.0 0 0 0 0 1.808 ", "APP.TX_PL_USER_POSN_MAP null null 1.808 12.0 2.4 109.456 0.0 100 100 100 0 125.664 ", "APP.TL_SOURCE_SYSTEM null null 1.696 9.6 2.4 21.088 0.0 100 100 100 0 34.784 ", "APP.TD_FIRM_ACCOUNT_SCD null null 1.696 0.0 0.0 0.0 0.0 0 0 0 0 1.696 ", "APP.TL_REGION null null 1.696 0.0 0.0 0.0 0.0 0 0 0 0 1.696 ", "APP.TD_INSTRUMENT_SCD null null 1.696 9.6 2.4 96.288 0.0 100 100 100 0 109.984 "};
        List<String> expectedOutput = Arrays.asList(expectedOutputArr);
        StringBuilder printOut = new StringBuilder("\n");
        StringBuilder printOut2 = new StringBuilder("\n");
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String indexType = rs.getString("INDEX_TYPE");
            float constantOverhead = rs.getFloat("CONSTANT_OVERHEAD");
            float entrySize = rs.getFloat("ENTRY_SIZE");
            float keySize = rs.getFloat("KEY_SIZE");
            float valSize = rs.getFloat("VALUE_SIZE");
            float valOffheapSize = rs.getFloat("VALUE_SIZE_OFFHEAP");
            float numRows = rs.getFloat("NUM_ROWS");
            float numKeysInMemory = rs.getFloat("NUM_KEYS_IN_MEMORY");
            float numValuesInMemory = rs.getFloat("NUM_VALUES_IN_MEMORY");
            float numValuesInOffheap = rs.getFloat("NUM_VALUES_IN_OFFHEAP");
            float totalSize = rs.getFloat("TOTAL_SIZE");
            if ("LOCAL".equals(indexType)) {
                if (this.generateComparisonValues) {
                    printOut.append("indexColValues.put(\"" + indexName + "\", new float[] {").append(constantOverhead).append("f, ").append(entrySize).append("f, ").append(keySize).append("f, ").append(valSize).append("f, ").append(valOffheapSize).append("f, ").append(numRows).append("f, ").append(numKeysInMemory).append("f, ").append(numValuesInMemory).append("f, ").append(numValuesInOffheap).append("f, ").append(totalSize).append("f});\n");
                    continue;
                }
                float[] expectedValues = (float[])indexColValues.get(indexName);
                float diff = Math.abs(expectedValues[0] - constantOverhead);
                MemoryAnalyticsTest.assertTrue((String)(indexName + " ConstantOverhead deviated by " + diff + "(" + constantOverhead + "," + expectedValues[0] + ")"), (diff < 1.0f ? 1 : 0) != 0);
                diff = Math.abs(expectedValues[1] - entrySize);
                MemoryAnalyticsTest.assertTrue((String)(indexName + " EntrySize deviated by " + diff + "(" + entrySize + "," + expectedValues[1] + ")"), (diff < 2.0f ? 1 : 0) != 0);
                diff = Math.abs(expectedValues[2] - keySize);
                MemoryAnalyticsTest.assertTrue((String)(indexName + " KeySize deviated by " + diff + "(" + keySize + "," + expectedValues[2] + ")"), (diff < 1.0f ? 1 : 0) != 0);
                diff = Math.abs(expectedValues[3] - valSize);
                MemoryAnalyticsTest.assertTrue((String)(indexName + " ValSize deviated by " + diff + "(" + valSize + "," + expectedValues[3] + ")"), (diff < 1.0f ? 1 : 0) != 0);
                diff = Math.abs(expectedValues[4] - valOffheapSize);
                MemoryAnalyticsTest.assertTrue((String)(indexName + " ValOffheapSize deviated by " + diff + "(" + valOffheapSize + "," + expectedValues[4] + ")"), (diff < 1.0f ? 1 : 0) != 0);
                MemoryAnalyticsTest.assertEquals((String)(indexName + " numRows=" + numRows + " expected=" + expectedValues[5]), (Object)Float.valueOf(expectedValues[5]), (Object)Float.valueOf(numRows));
                MemoryAnalyticsTest.assertEquals((String)(indexName + " numKeysInMemory=" + numKeysInMemory + " expected=" + expectedValues[6]), (Object)Float.valueOf(expectedValues[6]), (Object)Float.valueOf(numKeysInMemory));
                MemoryAnalyticsTest.assertEquals((String)(indexName + " numValuesInMemory=" + numValuesInMemory + " expected=" + expectedValues[7]), (Object)Float.valueOf(expectedValues[7]), (Object)Float.valueOf(numValuesInMemory));
                MemoryAnalyticsTest.assertEquals((String)(indexName + " numValuesInOffheap=" + numValuesInOffheap + " expected=" + expectedValues[8]), (Object)Float.valueOf(expectedValues[8]), (Object)Float.valueOf(numValuesInOffheap));
                diff = Math.abs(expectedValues[9] - totalSize);
                MemoryAnalyticsTest.assertTrue((String)(indexName + " TotalSize deviated by " + diff + "(" + totalSize + "," + expectedValues[9] + ")"), (diff < 2.0f ? 1 : 0) != 0);
                continue;
            }
            String output = this.checkOutput(rs, columnList, expectedOutput, this.generateComparisonValues ? printOut2 : null);
            if (output == null) continue;
            this.generateComparisonValues = true;
            this.testSimpleQueryCalledAgain = true;
            MemoryAnalyticsTest.getLogger().info((Object)"testSimpleQuerying being called again for just generating the expected values");
            this.testSimpleQuerying();
            MemoryAnalyticsTest.fail("not found in expected output: " + output);
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)printOut.toString());
            MemoryAnalyticsTest.getLogger().info((Object)printOut2.toString());
            printOut = new StringBuilder("\n");
            printOut2 = new StringBuilder("\n");
        }
        rs = stmt.executeQuery("select table_name, sum(constant_overhead) as csz, sum(entry_size) as esz, sum(key_size) as ksz, sum(value_size) as vsz, sum(value_size_offheap) as vohsz, sum(num_rows) as nr, sum(num_keys_in_memory) as nkim, sum(num_values_in_memory) as nvim, sum(num_values_in_offheap) as nvioh,  sum(total_size) as totsz from sys.memoryanalytics group by table_name");
        indexColValues = new HashMap();
        indexColValues.put("APP.TD_FIRM_ACCOUNT_SCD", new float[]{1.696f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.696f});
        indexColValues.put("APP.TD_INSTRUMENT_SCD", new float[]{1.8479999f, 15.16f, 2.4f, 96.744f, 0.0f, 198.0f, 100.0f, 100.0f, 0.0f, 116.152f});
        indexColValues.put("APP.TD_PL_POSITION_INDICATIVE", new float[]{1.696f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.696f});
        indexColValues.put("APP.TD_POSN_EXTENDED_KEY", new float[]{1.8479999f, 14.592001f, 2.4f, 25.9f, 0.0f, 199.0f, 100.0f, 100.0f, 0.0f, 44.739998f});
        indexColValues.put("APP.TD_TRADER_SCD", new float[]{1.8479999f, 14.8880005f, 2.4f, 217.84799f, 0.0f, 200.0f, 100.0f, 100.0f, 0.0f, 236.984f});
        indexColValues.put("APP.TF_EDEALER_PAA", new float[]{2.112f, 0.144f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.256f});
        indexColValues.put("APP.TF_EQRMS_PAA", new float[]{2.112f, 0.144f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.256f});
        indexColValues.put("APP.TF_GEMFIRE_PAA", new float[]{2.112f, 0.144f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.256f});
        indexColValues.put("APP.TF_PL_ADJ_REPORT", new float[]{1.9599999f, 16.912f, 2.4f, 623.084f, 0.0f, 197.0f, 100.0f, 100.0f, 0.0f, 644.35596f});
        indexColValues.put("APP.TF_PL_POSITION_DLY", new float[]{1.808f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.808f});
        indexColValues.put("APP.TF_PL_POSITION_FUNC", new float[]{1.808f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.808f});
        indexColValues.put("APP.TF_PL_POSITION_PTD", new float[]{1.9599999f, 16.944f, 2.4f, 300.364f, 0.0f, 197.0f, 100.0f, 100.0f, 0.0f, 321.668f});
        indexColValues.put("APP.TF_PL_POSITION_YTD", new float[]{1.9599999f, 16.912f, 2.4f, 627.396f, 0.0f, 197.0f, 100.0f, 100.0f, 0.0f, 648.66797f});
        indexColValues.put("APP.TL_CURRENCY", new float[]{1.696f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.696f});
        indexColValues.put("APP.TL_REGION", new float[]{1.696f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.696f});
        indexColValues.put("APP.TL_SOURCE_SYSTEM", new float[]{1.8479999f, 14.992001f, 2.4f, 21.56f, 0.0f, 197.0f, 100.0f, 100.0f, 0.0f, 40.8f});
        indexColValues.put("APP.TX_PL_POSITION", new float[]{1.808f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.808f});
        indexColValues.put("APP.TX_PL_USER_POSN_MAP", new float[]{1.9599999f, 12.368f, 2.4f, 110.356f, 0.0f, 105.0f, 100.0f, 100.0f, 0.0f, 127.084f});
        while (rs.next()) {
            tableName = rs.getString("TABLE_NAME");
            float constantOverhead = rs.getFloat("csz");
            float entrySize = rs.getFloat("esz");
            float keySize = rs.getFloat("ksz");
            float valSize = rs.getFloat("vsz");
            float valOffheapSize = rs.getFloat("vohsz");
            float numRows = rs.getFloat("nr");
            float numKeysInMemory = rs.getFloat("nkim");
            float numValuesInMemory = rs.getFloat("nvim");
            float numValuesInOffheap = rs.getFloat("nvioh");
            float totalSize = rs.getFloat("totsz");
            if (this.generateComparisonValues) {
                printOut.append("indexColValues.put(\"" + tableName + "\", new float[] {").append(constantOverhead).append("f, ").append(entrySize).append("f, ").append(keySize).append("f, ").append(valSize).append("f, ").append(valOffheapSize).append("f, ").append(numRows).append("f, ").append(numKeysInMemory).append("f, ").append(numValuesInMemory).append("f, ").append(numValuesInOffheap).append("f, ").append(totalSize).append("f});\n");
                continue;
            }
            float[] expectedValues = (float[])indexColValues.get(tableName);
            float diff = Math.abs(expectedValues[0] - constantOverhead);
            MemoryAnalyticsTest.assertTrue((String)(tableName + " ConstantOverhead deviated by " + diff + "(" + constantOverhead + "," + expectedValues[0] + ")"), (diff < 1.0f ? 1 : 0) != 0);
            diff = Math.abs(expectedValues[1] - entrySize);
            MemoryAnalyticsTest.assertTrue((String)(tableName + " EntrySize deviated by " + diff + "(" + entrySize + "," + expectedValues[1] + ")"), (diff < 2.0f ? 1 : 0) != 0);
            diff = Math.abs(expectedValues[2] - keySize);
            MemoryAnalyticsTest.assertTrue((String)(tableName + " KeySize deviated by " + diff + "(" + keySize + "," + expectedValues[2] + ")"), (diff < 1.0f ? 1 : 0) != 0);
            diff = Math.abs(expectedValues[3] - valSize);
            MemoryAnalyticsTest.assertTrue((String)(tableName + " ValSize deviated by " + diff + "(" + valSize + "," + expectedValues[3] + ")"), (diff < 1.0f ? 1 : 0) != 0);
            diff = Math.abs(expectedValues[4] - valOffheapSize);
            MemoryAnalyticsTest.assertTrue((String)(tableName + " ValOffheapSize deviated by " + diff + "(" + valOffheapSize + "," + expectedValues[4] + ")"), (diff < 1.0f ? 1 : 0) != 0);
            MemoryAnalyticsTest.assertEquals((String)("numRows=" + numRows + " expected=" + expectedValues[5]), (Object)Float.valueOf(expectedValues[5]), (Object)Float.valueOf(numRows));
            MemoryAnalyticsTest.assertEquals((String)("numKeysInMemory=" + numKeysInMemory + " expected=" + expectedValues[6]), (Object)Float.valueOf(expectedValues[6]), (Object)Float.valueOf(numKeysInMemory));
            MemoryAnalyticsTest.assertEquals((String)("numValuesInMemory=" + numValuesInMemory + " expected=" + expectedValues[7]), (Object)Float.valueOf(expectedValues[7]), (Object)Float.valueOf(numValuesInMemory));
            MemoryAnalyticsTest.assertEquals((String)("numValuesInOffheap=" + numValuesInOffheap + " expected=" + expectedValues[8]), (Object)Float.valueOf(expectedValues[8]), (Object)Float.valueOf(numValuesInOffheap));
            diff = Math.abs(expectedValues[9] - totalSize);
            MemoryAnalyticsTest.assertTrue((String)(tableName + " TotalSize deviated by " + diff + "(" + totalSize + "," + expectedValues[9] + ")"), (diff < 3.0f ? 1 : 0) != 0);
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)printOut.toString());
            printOut = new StringBuilder("\n");
        }
        rs = stmt.executeQuery("select table_name, sum(constant_overhead) + sum(entry_size) + sum(key_size) + sum(value_size) + sum(value_size_offheap) as totsz, sum(num_rows) as nr from (   select table_name, constant_overhead, entry_size, key_size, value_size, value_size_offheap, case when index_name is null then num_rows else 0 end as num_rows from sys.memoryanalytics) as memA group by table_name ");
        indexColValues = new HashMap();
        indexColValues.put("APP.TD_FIRM_ACCOUNT_SCD", new float[]{1.696f, 0.0f});
        indexColValues.put("APP.TD_INSTRUMENT_SCD", new float[]{116.152f, 100.0f});
        indexColValues.put("APP.TD_PL_POSITION_INDICATIVE", new float[]{1.696f, 0.0f});
        indexColValues.put("APP.TD_POSN_EXTENDED_KEY", new float[]{44.739998f, 100.0f});
        indexColValues.put("APP.TD_TRADER_SCD", new float[]{236.984f, 100.0f});
        indexColValues.put("APP.TF_EDEALER_PAA", new float[]{2.256f, 0.0f});
        indexColValues.put("APP.TF_EQRMS_PAA", new float[]{2.256f, 0.0f});
        indexColValues.put("APP.TF_GEMFIRE_PAA", new float[]{2.256f, 0.0f});
        indexColValues.put("APP.TF_PL_ADJ_REPORT", new float[]{644.35596f, 100.0f});
        indexColValues.put("APP.TF_PL_POSITION_DLY", new float[]{1.808f, 0.0f});
        indexColValues.put("APP.TF_PL_POSITION_FUNC", new float[]{1.808f, 0.0f});
        indexColValues.put("APP.TF_PL_POSITION_PTD", new float[]{321.668f, 100.0f});
        indexColValues.put("APP.TF_PL_POSITION_YTD", new float[]{648.66797f, 100.0f});
        indexColValues.put("APP.TL_CURRENCY", new float[]{1.696f, 0.0f});
        indexColValues.put("APP.TL_REGION", new float[]{1.696f, 0.0f});
        indexColValues.put("APP.TL_SOURCE_SYSTEM", new float[]{40.8f, 100.0f});
        indexColValues.put("APP.TX_PL_POSITION", new float[]{1.808f, 0.0f});
        indexColValues.put("APP.TX_PL_USER_POSN_MAP", new float[]{127.084f, 100.0f});
        while (rs.next()) {
            tableName = rs.getString("TABLE_NAME");
            float totalSize = rs.getFloat("totsz");
            float numRows = rs.getFloat("nr");
            if (this.generateComparisonValues) {
                printOut.append("indexColValues.put(\"" + tableName + "\", new float[] {").append(totalSize).append("f, ").append(numRows).append("f});\n");
                continue;
            }
            float[] expectedValues = (float[])indexColValues.get(tableName);
            float diff = Math.abs(expectedValues[0] - totalSize);
            MemoryAnalyticsTest.assertTrue((String)(tableName + " TotalSize deviated by " + diff + "(" + totalSize + "," + expectedValues[0] + ")"), (diff < 3.0f ? 1 : 0) != 0);
            MemoryAnalyticsTest.assertEquals((String)("numRows=" + numRows + " expected=" + expectedValues[1]), (Object)Float.valueOf(expectedValues[1]), (Object)Float.valueOf(numRows));
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)printOut.toString());
            printOut = new StringBuilder(10);
        }
        int rows = 0;
        rs = stmt.executeQuery("select table_name, sum(constant_overhead+entry_size) / case when sum(num_rows) > 0 then sum(num_rows) else 1 end from sys.memoryanalytics where index_name is null group by table_name");
        while (rs.next()) {
            ++rows;
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)("assertEquals(" + rows + ", rows);"));
        } else {
            MemoryAnalyticsTest.assertEquals((int)18, (int)rows);
        }
        rows = 0;
        rs = stmt.executeQuery("select table_name, sum(constant_overhead+entry_size) / case when sum(num_rows) > 0 then sum(num_rows) else 1 end from sys.memoryanalytics group by table_name");
        while (rs.next()) {
            ++rows;
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)("assertEquals(" + rows + ", rows);"));
        } else {
            MemoryAnalyticsTest.assertEquals((int)18, (int)rows);
        }
        rows = 0;
        rs = stmt.executeQuery("select index_name, sum(total_size) from sys.memoryanalytics where index_name like 'IDX%' group by index_name");
        while (rs.next()) {
            ++rows;
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)("assertEquals(" + rows + ", rows);"));
        } else {
            MemoryAnalyticsTest.assertEquals((int)8, (int)rows);
        }
        rows = 0;
        rs = stmt.executeQuery("select host, sum(total_size) from sys.memoryanalytics group by host");
        while (rs.next()) {
            ++rows;
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)("assertEquals(" + rows + ", rows);"));
        } else {
            MemoryAnalyticsTest.assertEquals((int)1, (int)rows);
        }
        rows = 0;
        rs = stmt.executeQuery("select table_name, index_name, key_size/ case when num_keys_in_memory > 0 then num_keys_in_memory else 1 end from sys.memoryanalytics");
        while (rs.next()) {
            ++rows;
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)("assertEquals(" + rows + ", rows);"));
        } else {
            MemoryAnalyticsTest.assertEquals((int)32, (int)rows);
        }
        rows = 0;
        rs = stmt.executeQuery("select table_name, sum(value_size)/case when                       sum(num_values_in_memory) > 0 then sum(num_values_in_memory) else 1 end, sum(value_size_offheap)/ case when                       sum(num_values_in_offheap) > 0 then sum(num_values_in_offheap) else 1 end from sys.memoryanalytics where index_name is null group by table_name");
        while (rs.next()) {
            ++rows;
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)("assertEquals(" + rows + ", rows);"));
        } else {
            MemoryAnalyticsTest.assertEquals((int)18, (int)rows);
        }
        rows = 0;
        rs = stmt.executeQuery("select table_name, index_name, max(total_size) as max_, min(total_size) as min_ from sys.memoryanalytics group by table_name, index_name");
        while (rs.next()) {
            ++rows;
        }
        if (this.generateComparisonValues) {
            MemoryAnalyticsTest.getLogger().info((Object)("assertEquals(" + rows + ", rows);"));
        } else {
            MemoryAnalyticsTest.assertEquals((int)32, (int)rows);
        }
        rows = 0;
    }

    public void testPushDownQualifiers() throws Exception {
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        props.setProperty("table-default-partitioned", "false");
        props.setProperty("server-groups", "dbsync");
        props.setProperty("persist-dd", "true");
        Connection conn = MemoryAnalyticsTest.getConnection(props);
        String useCase7Script = TestUtil.getResourcesDir() + "/lib/useCase7/schema.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase7Script}, (boolean)false, (Logger)MemoryAnalyticsTest.getLogger(), null, null, (boolean)false);
        String useCase7DataScript = TestUtil.getResourcesDir() + "/lib/useCase7/import.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase7DataScript}, (boolean)false, (Logger)MemoryAnalyticsTest.getLogger(), (String)"<path_prefix>", (String)TestUtil.getResourcesDir(), (boolean)false);
        String useCase3Script = TestUtil.getResourcesDir() + "/lib/useCase3Data/schema.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase3Script}, (boolean)false, (Logger)MemoryAnalyticsTest.getLogger(), null, null, (boolean)false);
        String useCase3DataScript = TestUtil.getResourcesDir() + "/lib/useCase3Data/importAll.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase3DataScript}, (boolean)false, (Logger)MemoryAnalyticsTest.getLogger(), (String)"<path_prefix>", (String)TestUtil.getResourcesDir(), (boolean)false);
        Statement stmt = conn.createStatement();
        int[] expectedPartialRows = new int[1];
        final MemoryAnalyticsVTI[] userRS = new MemoryAnalyticsVTI[1];
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public void afterResultSetOpen(GenericPreparedStatement stmt, LanguageConnectionContext lcc, ResultSet resultSet) {
                VTIResultSet rs;
                if (resultSet instanceof AbstractGemFireResultSet) {
                    return;
                }
                TestCase.assertTrue((String)resultSet.getClass().getName(), (resultSet instanceof VTIResultSet || resultSet instanceof ProjectRestrictResultSet ? 1 : 0) != 0);
                if (resultSet instanceof ProjectRestrictResultSet) {
                    NoPutResultSet r = ((ProjectRestrictResultSet)resultSet).getSource();
                    TestCase.assertTrue((String)r.getClass().getName(), (boolean)(r instanceof VTIResultSet));
                    rs = (VTIResultSet)r;
                } else {
                    rs = (VTIResultSet)resultSet;
                }
                TestCase.assertTrue((rs.getFastPath() != null ? 1 : 0) != 0);
                java.sql.ResultSet usrRS = rs.getUserVTI();
                TestCase.assertTrue((boolean)(usrRS instanceof IQualifyable));
                TestCase.assertTrue((boolean)(usrRS instanceof MemoryAnalyticsVTI));
                userRS[0] = (MemoryAnalyticsVTI)usrRS;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        expectedPartialRows[0] = 40;
        int rows = 0;
        java.sql.ResultSet rs = stmt.executeQuery("select * from sys.memoryanalytics where table_name like 'APP.C$_BO$_%' {escape '$'}");
        while (rs.next()) {
            String col;
            ++rows;
            MemoryAnalyticsTest.assertTrue((String)col, ((col = rs.getString(1)).startsWith("APP.C_BO_") || col.startsWith("APP.TF") ? 1 : 0) != 0);
            String report = rs.getString("MEMORY");
            this.assertMemReport(report);
        }
        ArrayList res = userRS[0].getPartialResult();
        int numTablesQualified = 0;
        for (DataValueDescriptor[] dvdA : res) {
            if (!dvdA[1].isNull() || !dvdA[2].isNull()) continue;
            ++numTablesQualified;
        }
        MemoryAnalyticsTest.assertTrue((res != null ? 1 : 0) != 0);
        MemoryAnalyticsTest.assertEquals((int)expectedPartialRows[0], (int)res.size());
        MemoryAnalyticsTest.assertNotSame((Object)userRS[0].getEstimatedRowCount(null), (Object)numTablesQualified);
        MemoryAnalyticsTest.assertEquals((int)expectedPartialRows[0], (int)rows);
        rs.close();
        rows = 0;
        rs = stmt.executeQuery("select * from sys.memoryanalytics where entry_size > 0.2");
        while (rs.next()) {
            ++rows;
            MemoryAnalyticsTest.assertTrue((rs.getFloat("ENTRY_SIZE") > 0.2f ? 1 : 0) != 0);
            String report = rs.getString("MEMORY");
            this.assertMemReport(report);
            MemoryAnalyticsTest.getLogger().info((Object)(rs.getString(1) + " " + rs.getFloat("ENTRY_SIZE") + " " + rs.getString("QUEUE_NAME") + " " + rs.getString("QUEUE_TYPE")));
        }
        res = userRS[0].getPartialResult();
        numTablesQualified = 0;
        for (DataValueDescriptor[] dvdA : res) {
            if (!dvdA[1].isNull() || !dvdA[2].isNull()) continue;
            ++numTablesQualified;
        }
        MemoryAnalyticsTest.assertTrue((res != null ? 1 : 0) != 0);
        MemoryAnalyticsTest.assertEquals((Object)userRS[0].getEstimatedRowCount(null), (Object)numTablesQualified);
        expectedPartialRows[0] = 151;
        MemoryAnalyticsTest.assertEquals((int)expectedPartialRows[0], (int)res.size());
        MemoryAnalyticsTest.assertEquals((int)23, (int)rows);
        rs.close();
    }

    public void testHDFSTables() throws Exception {
        String report;
        this.checkDirExistence("./myhdfs");
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        props.setProperty("table-default-partitioned", "false");
        Connection conn = MemoryAnalyticsTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' homedir './myhdfs'");
        st.execute("create table t1 (col1 int primary key, col2 int) partition by primary key hdfsstore (myhdfs)");
        Set senders = Misc.getGemFireCache().getAllGatewaySenders();
        for (GatewaySender g : senders) {
            g.pause();
        }
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 5000;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        java.sql.ResultSet rs = st.executeQuery("select * from sys.memoryanalytics ");
        while (rs.next()) {
            report = rs.getString("MEMORY");
            MemoryAnalyticsTest.getLogger().info((Object)(rs.getString(1) + " constant=" + rs.getFloat("CONSTANT_OVERHEAD") + " ez=" + rs.getFloat("ENTRY_SIZE") + " qname=" + rs.getString("QUEUE_NAME") + " type=" + rs.getString("QUEUE_TYPE") + "\nreport\n" + report + "\n"));
        }
        rs.close();
        for (GatewaySender g : senders) {
            g.resume();
            while (((AbstractGatewaySender)g).getQueue().size() > 0) {
                Thread.currentThread();
                Thread.sleep(1000L);
                rs = st.executeQuery("select * from sys.memoryanalytics where queue_type is not null");
                while (rs.next()) {
                    String report2 = rs.getString("MEMORY");
                    MemoryAnalyticsTest.getLogger().info((Object)(rs.getString(1) + " constant=" + rs.getFloat("CONSTANT_OVERHEAD") + " ez=" + rs.getFloat("ENTRY_SIZE") + " qname=" + rs.getString("QUEUE_NAME") + " type=" + rs.getString("QUEUE_TYPE") + "\nreport\n" + report2 + "\n"));
                }
                rs.close();
            }
        }
        rs = st.executeQuery("select * from sys.memoryanalytics where queue_type is not null");
        while (rs.next()) {
            report = rs.getString("MEMORY");
            MemoryAnalyticsTest.getLogger().info((Object)(rs.getString(1) + " constant=" + rs.getFloat("CONSTANT_OVERHEAD") + " ez=" + rs.getFloat("ENTRY_SIZE") + " qname=" + rs.getString("QUEUE_NAME") + " type=" + rs.getString("QUEUE_TYPE") + "\nreport\n" + report + "\n"));
        }
        rs.close();
    }

    private void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                File[] files;
                for (File f : files = file.listFiles()) {
                    this.delete(f);
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    private void checkDirExistence(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            this.delete(dir);
        }
    }

    private void assertMemReport(String report) {
        if (report.length() > 3) {
            StringTokenizer st = new StringTokenizer(report);
            int tokens = st.countTokens();
            MemoryAnalyticsTest.getLogger().info((Object)("asserting : " + report + " with numTokens=" + tokens));
            String ft = st.nextToken("\n");
            Pattern pt = Pattern.compile("Primary Bucket Distribution: [1-9]([0-9]{1,2})? buckets with min [1-9]([0-9]{1,2})? entries and max [1-9]([0-9]{1,2})? entries.");
            MemoryAnalyticsTest.assertTrue((String)ft, (boolean)pt.matcher(ft).find());
            MemoryAnalyticsTest.getLogger().info((Object)ft);
            ft = st.nextToken("\n{},");
            pt = Pattern.compile("B[0-9][0-9][0-9]=( )*([1-9])+");
            MemoryAnalyticsTest.assertTrue((String)ft, (boolean)pt.matcher(ft).find());
            MemoryAnalyticsTest.getLogger().info((Object)ft);
            int tgtLen = ft.length();
            boolean reachedHistogram = false;
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (!reachedHistogram && (reachedHistogram = t.contains("histogram:"))) {
                    t = st.nextToken("\n");
                    pt = Pattern.compile("[1-9][0-9]*-( )*[1-9][0-9]*( )+([0-9])+( )+([0-9])+(.([0-9])+)?%");
                }
                if (reachedHistogram) {
                    MemoryAnalyticsTest.getLogger().info((Object)t);
                    MemoryAnalyticsTest.assertTrue((String)t, (boolean)pt.matcher(t).find());
                } else {
                    MemoryAnalyticsTest.assertTrue((String)t, (boolean)pt.matcher(t).find());
                    MemoryAnalyticsTest.assertEquals((int)tgtLen, (int)t.length());
                    MemoryAnalyticsTest.getLogger().info((Object)t);
                }
                ++tokens;
            }
        }
    }

    private String checkOutput(java.sql.ResultSet rs, String[] columnList, List<String> expectedOutput, StringBuilder printOut2) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String s : columnList) {
            sb.append(rs.getString(s)).append(' ');
        }
        String output = sb.toString();
        if (printOut2 != null) {
            printOut2.append('\"').append(output).append("\",\n");
            return null;
        }
        if (!expectedOutput.contains(output)) {
            return output;
        }
        return null;
    }
}

