/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.ddl.IndexPersistenceDUnit;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheListener;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheWriter;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.GfxdJarResource;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.DUnitEnv;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DistributedSQLTestBase
extends DistributedTestBase {
    public static final float DB2_SMALLEST_REAL = -3.402E38f;
    public static final float DB2_LARGEST_REAL = 3.402E38f;
    public static final float DB2_SMALLEST_POSITIVE_REAL = 1.175E-37f;
    public static final float DB2_LARGEST_NEGATIVE_REAL = -1.175E-37f;
    public static final double DB2_SMALLEST_DOUBLE = -1.79769E308;
    public static final double DB2_LARGEST_DOUBLE = 1.79769E308;
    public static final double DB2_SMALLEST_POSITIVE_DOUBLE = 2.225E-307;
    public static final double DB2_LARGEST_NEGATIVE_DOUBLE = -2.225E-307;
    private static String currentTestName = null;
    private static String currentClassName = null;
    protected static final boolean isTransactional = false;
    protected static volatile int vmCount;
    protected static final ArrayList<String> expectedDerbyExceptions;
    protected final transient List<VM> clientVMs = new ArrayList<VM>();
    protected final transient List<VM> serverVMs = new ArrayList<VM>();
    protected transient Map<DistributedMember, VM> members = new HashMap<DistributedMember, VM>();
    private transient String locatorString = null;
    public static final char fileSeparator;
    protected static boolean beforeClassDone;
    protected static String lastTest;
    private static transient DistributedSQLTestBase testInstance;
    private volatile boolean configureDefaultOffHeap = false;
    private static final transient GetVM addNewClientVM;
    private static final transient GetVM addNewServerVM;
    private final transient GetVM restartServerVM = new GetVM(){

        @Override
        public VM get(int index, int numCurrentVMs, Host host) {
            return DistributedSQLTestBase.this.serverVMs.get(index);
        }

        @Override
        public boolean addVM() {
            return false;
        }

        @Override
        public String actionName() {
            return "Restarting";
        }
    };
    protected static final AtomicInteger numConnectionsOpened;
    protected static final AtomicInteger numConnectionsClosed;
    protected static final SerializableConnectionListener connListener;
    protected static volatile boolean isQueryExecutedOnNode;

    public DistributedSQLTestBase(String name) {
        super(name);
    }

    protected String reduceLogging() {
        return null;
    }

    public static void startCommonLocator(int locatorPort) {
        FabricLocator loc = FabricServiceManager.getFabricLocatorInstance();
        if (loc.status() != FabricService.State.RUNNING) {
            try {
                loc.start("localhost", locatorPort, null);
            }
            catch (SQLException e) {
                throw new TestException("Failed to start locator", (Throwable)e);
            }
        }
        assert (loc.status() == FabricService.State.RUNNING);
    }

    public void beforeClass() throws Exception {
        super.beforeClass();
        Host.getLocator().invoke(DistributedSQLTestBase.class, "startCommonLocator", (Object)DistributedSQLTestBase.getDUnitLocatorPort());
    }

    protected static String getDUnitLocatorString() {
        return "localhost[" + DistributedSQLTestBase.getDUnitLocatorPort() + ']';
    }

    protected void baseSetUp() throws Exception {
        super.setUp();
        GemFireXDUtils.IS_TEST_MODE = true;
        expectedDerbyExceptions.clear();
        currentTestName = this.getName();
        currentClassName = ((Object)((Object)this)).getClass().getName();
        testInstance = this;
        if (currentTestName != null) {
            DistributedSQLTestBase.invokeInEveryVM(DistributedSQLTestBase.class, (String)"setTestName", (Object[])new Object[]{currentTestName, currentClassName});
        }
        this.locatorString = DistributedSQLTestBase.getDUnitLocatorString();
        TestUtil.setRandomUserName();
        int numVMs = Host.getHost((int)0).getVMCount();
        DistributedSQLTestBase.setLogFile(((Object)((Object)this)).getClass().getName(), this.getName(), numVMs);
        DistributedSQLTestBase.invokeInEveryVM(((Object)((Object)this)).getClass(), (String)"setLogFile", (Object[])new Object[]{((Object)((Object)this)).getClass().getName(), this.getName(), numVMs});
        String logLevel = this.reduceLogging();
        if (logLevel != null) {
            this.reduceLogLevelForTest(logLevel);
        }
        IndexPersistenceDUnit.deleteAllOplogFiles();
    }

    public void setUp() throws Exception {
        this.baseSetUp();
    }

    protected void reduceLogLevelForTest(String logLevel) {
        SetLoggingLevel setLogLevel = new SetLoggingLevel(logLevel);
        DistributedSQLTestBase.invokeInEveryVM((SerializableRunnable)setLogLevel);
        setLogLevel.run();
    }

    public static void setLogFile(String className, String name, int numVMs) throws Exception {
        Class<?> c = Class.forName(className);
        DistributedSQLTestBase test = (DistributedSQLTestBase)((Object)c.getConstructor(String.class).newInstance(name));
        String logFilePrefix = test.getTestLogPrefix();
        TestUtil.setPropertyIfAbsent(null, GfxdConstants.GFXD_LOG_FILE, logFilePrefix + ".log");
        TestUtil.setPropertyIfAbsent(null, "gemfirexd.client.log-file", logFilePrefix + "-client.log");
        DistributedSQLTestBase.setPreallocateSysPropsToFalse();
        vmCount = numVMs;
    }

    public static void setPreallocateSysPropsToFalse() {
        System.setProperty("gemfire.preAllocateDisk", "false");
    }

    public static void setTestName(String name, String className) {
        try {
            currentTestName = name;
            currentClassName = className;
            Class<?> c = Class.forName(className);
            testInstance = (DistributedSQLTestBase)((Object)c.getConstructor(String.class).newInstance(name));
        }
        catch (Exception ex) {
            throw new TestException("unexpected exception", (Throwable)ex);
        }
    }

    public String getLocatorString() {
        return this.locatorString != null ? this.locatorString : (this.locatorString = DistributedSQLTestBase.getDUnitLocatorString());
    }

    public static String getClassName() {
        return currentClassName;
    }

    public static String getTestName() {
        return currentTestName;
    }

    public static String getCurrentDefaultSchemaName() {
        return TestUtil.getCurrentDefaultSchemaName();
    }

    public static void fail(String message, Throwable ex) {
        DistributedSQLTestBase.getGlobalLogger().error((Object)message, ex);
        DistributedTestBase.fail((String)message, (Throwable)ex);
    }

    protected void configureDefaultOffHeap(boolean on) {
        this.configureDefaultOffHeap = on;
        if (this.configureDefaultOffHeap) {
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
            System.setProperty("gemfire.off-heap-memory-size", "500m");
        }
    }

    protected static String getSysDirName() {
        return new File(".").getAbsolutePath();
    }

    protected void setGFXDProperty(Properties props, Object propName, Object propValue) {
        if (propName instanceof String && propValue instanceof String) {
            if (props.getProperty((String)propName) == null) {
                props.setProperty((String)propName, (String)propValue);
            }
        } else if (!props.containsKey(propName)) {
            props.put(propName, propValue);
        }
    }

    protected boolean containsGemFireProperty(Properties props, Object propName) {
        if (props != null) {
            String prop = propName.toString().startsWith("gemfire.") ? propName.toString().substring("gemfire.".length()) : "";
            return props.containsKey(propName) || prop.length() > 0 && props.containsKey(prop);
        }
        return System.getProperty(propName.toString()) != null;
    }

    protected void setCommonProperties(Properties props, int mcastPort, String serverGroups, Properties extraProps) {
        assert (props != null);
        String sysDirName = DistributedSQLTestBase.getSysDirName();
        String testLogPrefix = this.getTestLogPrefix();
        this.setGFXDProperty(props, "log-file", testLogPrefix + ".log");
        String dirPath = null;
        if (extraProps != null) {
            dirPath = extraProps.getProperty("sys-disk-dir");
        }
        if (dirPath != null && !dirPath.equals("")) {
            this.setGFXDProperty(props, "sys-disk-dir", dirPath);
        } else {
            this.setGFXDProperty(props, "sys-disk-dir", sysDirName);
        }
        if (extraProps != null) {
            if (this.configureDefaultOffHeap && !extraProps.containsKey("gemfire.off-heap-memory-size") && System.getProperty("gemfire.off-heap-memory-size") == null) {
                extraProps.setProperty("gemfire.off-heap-memory-size", "500m");
            }
            for (Map.Entry<Object, Object> entry : extraProps.entrySet()) {
                this.setGFXDProperty(props, entry.getKey(), entry.getValue());
            }
        } else if (this.configureDefaultOffHeap && System.getProperty("gemfire.off-heap-memory-size") == null) {
            this.setGFXDProperty(props, "gemfire.off-heap-memory-size", "500m");
        }
        this.setGFXDProperty(props, "statistic-archive-file", testLogPrefix + ".gfs");
        Properties dsProps = DUnitEnv.get().getDistributedSystemProperties();
        for (String prop : dsProps.stringPropertyNames()) {
            if (props.getProperty(prop) != null || System.getProperty("gemfire." + prop) != null) continue;
            props.setProperty(prop, dsProps.getProperty(prop));
        }
        if (vmCount >= 8) {
            System.setProperty("p2p.discoveryTimeout", "1000");
            System.setProperty("p2p.joinTimeout", "2000");
            this.setGFXDProperty(props, "member-timeout", "2000");
            System.setProperty("p2p.leaveTimeout", "1000");
            System.setProperty("p2p.socket_timeout", "4000");
            System.setProperty("p2p.disconnectDelay", "500");
            System.setProperty("p2p.handshakeTimeoutMs", "2000");
            System.setProperty("p2p.lingerTime", "500");
            System.setProperty("p2p.listenerCloseTimeout", "4000");
        }
        if (extraProps != null) {
            Enumeration<?> e = extraProps.propertyNames();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                if (k == null || !(k instanceof String) || !((String)k).contains("auth-ldap")) continue;
                String v = extraProps.getProperty((String)k);
                System.setProperty((String)k, v);
            }
        }
        this.setGFXDProperty(props, "conserve-sockets", "true");
        this.setGFXDProperty(props, "statistic-sampling-enabled", "true");
        System.setProperty("gemfirexd-impl.observer-volatile-read", "true");
        if (serverGroups != null) {
            props.setProperty("server-groups", serverGroups);
        }
        if (mcastPort > 0) {
            this.setGFXDProperty(props, "mcast-port", Integer.toString(mcastPort));
        } else if (!(this.containsGemFireProperty(props, "gemfire.locators") || props.containsKey("start-locator") || props.containsKey("locators") || props.containsKey("mcast-port"))) {
            this.setGFXDProperty(props, "mcast-port", "0");
            this.setGFXDProperty(props, "locators", this.getLocatorString());
        }
        this.setGFXDProperty(props, "table-default-partitioned", "true");
        this.setOtherCommonProperties(props, mcastPort, serverGroups);
    }

    protected Properties setMasterCommonProperties(Properties props) {
        if (TestUtil.currentUserName != null) {
            if (props == null) {
                props = new Properties();
            }
            if (!props.containsKey("UserName")) {
                TestUtil.setPropertyIfAbsent(props, "user", TestUtil.currentUserName);
            }
            TestUtil.setPropertyIfAbsent(props, "password", TestUtil.currentUserPassword);
        }
        return props;
    }

    protected void setOtherCommonProperties(Properties props, int mcastPort, String serverGroups) {
    }

    public static DistributedMember _startNewLocator(String className, String name, String locatorBindAdress, int locatorPort, String extraLocatorArgs, Properties extraProps) throws Exception {
        Class<?> c = Class.forName(className);
        DistributedSQLTestBase test = (DistributedSQLTestBase)((Object)c.getConstructor(String.class).newInstance(name));
        if (extraProps != null && !extraProps.containsKey("locators")) {
            if (locatorBindAdress == null) {
                locatorBindAdress = SocketCreator.getLocalHost().getHostName();
            }
            extraProps.setProperty("locators", locatorBindAdress + '[' + locatorPort + ']');
        }
        Properties props = test.getLocatorConfig(extraProps);
        TestUtil.loadDriver();
        return TestUtil.setupConnection(locatorBindAdress, locatorPort, extraLocatorArgs, props);
    }

    public void startLocatorVM(String locatorBindAdress, int locatorPort, String extraLocatorArgs, Properties extraProps) throws Exception {
        Host host = Host.getHost((int)0);
        Properties vmExtraProps = new Properties();
        if (extraProps != null) {
            vmExtraProps.putAll((Map<?, ?>)extraProps);
        }
        this.setMasterCommonProperties(vmExtraProps);
        this.joinVM(true, this.invokeStartLocatorVM(0, locatorBindAdress, locatorPort, extraLocatorArgs, host, vmExtraProps, addNewServerVM));
    }

    public void restartLocatorVM(int vmNum, String locatorBindAdress, int locatorPort, String extraLocatorArgs, Properties extraProps) throws Exception {
        Host host = Host.getHost((int)0);
        Properties vmExtraProps = new Properties();
        if (extraProps != null) {
            vmExtraProps.putAll((Map<?, ?>)extraProps);
        }
        this.setMasterCommonProperties(vmExtraProps);
        this.joinVM(false, this.invokeStartLocatorVM(vmNum - 1, locatorBindAdress, locatorPort, extraLocatorArgs, host, vmExtraProps, this.restartServerVM));
    }

    protected AsyncVM invokeStartLocatorVM(int index, String locatorBindAdress, int locatorPort, String extraLocatorArgs, Host host, Properties vmExtraProps, GetVM getVM) throws Exception {
        int currentServerVMs = this.serverVMs.size();
        if (getVM.addVM()) {
            int totalVMs = this.clientVMs.size() + currentServerVMs;
            int maxVMs = Host.getHost((int)0).getVMCount();
            DistributedSQLTestBase.assertTrue((String)("Total number of available VMs is " + maxVMs), (totalVMs <= maxVMs ? 1 : 0) != 0);
        }
        VM newVM = getVM.get(index, currentServerVMs, host);
        this.getLogWriter().info((Object)(getVM.actionName() + " VM with pid [" + newVM.getPid() + "] as locator."));
        return new AsyncVM(newVM.invokeAsync(((Object)((Object)this)).getClass(), "_startNewLocator", new Object[]{((Object)((Object)this)).getClass().getName(), this.getName(), locatorBindAdress, locatorPort, extraLocatorArgs, vmExtraProps}), newVM);
    }

    protected Properties getLocatorConfig(Properties extraProps) throws Exception {
        Properties props = new Properties();
        this.setCommonProperties(props, 0, null, extraProps);
        TestUtil.setPropertyIfAbsent(props, "host-data", "false");
        return props;
    }

    public static DistributedMember _startNewClient(String className, String name, int mcastPort, String serverGroups, Properties extraProps, boolean configureOffHeap) throws Exception {
        Class<?> c = Class.forName(className);
        DistributedSQLTestBase test = (DistributedSQLTestBase)((Object)c.getConstructor(String.class).newInstance(name));
        test.configureDefaultOffHeap = configureOffHeap;
        Properties props = test.getClientConfig(mcastPort, serverGroups, extraProps);
        TestUtil.loadDriver();
        return TestUtil.setupConnection(props);
    }

    public void startClientVMs(int numClients, int mcastPort, String serverGroups) throws Exception {
        this.startClientVMs(numClients, mcastPort, serverGroups, null, addNewClientVM);
    }

    public void startClientVMs(int numClients, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        this.startClientVMs(numClients, mcastPort, serverGroups, extraProps, addNewClientVM);
    }

    private void startClientVMs(int numClients, int mcastPort, String serverGroups, Properties extraProps, GetVM getVM) throws Exception {
        ArrayList<AsyncVM> startList = new ArrayList<AsyncVM>(5);
        this.invokeStartClientVMs(numClients, mcastPort, serverGroups, extraProps, getVM, startList);
        boolean addVM = getVM.addVM();
        for (AsyncVM async : startList) {
            this.joinVM(false, addVM, async);
        }
    }

    protected void invokeStartClientVMs(int numClients, int mcastPort, String serverGroups, Properties extraProps, GetVM getVM, List<AsyncVM> startList) throws Exception {
        String vmType;
        DistributedSQLTestBase.assertTrue((String)"At least one client should started", (numClients > 0 ? 1 : 0) != 0);
        int currentClientVms = this.clientVMs.size();
        boolean addVM = getVM.addVM();
        if (addVM) {
            int totalVMs = numClients + currentClientVms + this.serverVMs.size();
            int maxVMs = Host.getHost((int)0).getVMCount() + 1;
            DistributedSQLTestBase.assertTrue((String)("Total number of available VMs is " + maxVMs), (totalVMs <= maxVMs ? 1 : 0) != 0);
        }
        vmType = extraProps == null || (vmType = extraProps.getProperty("host-data")) == null || !Boolean.parseBoolean(vmType) ? "client." : "server.";
        Host host = Host.getHost((int)0);
        String action = getVM.actionName();
        Properties controllerProps = null;
        boolean hasController = false;
        if (currentClientVms == 0) {
            currentClientVms = 1;
            --numClients;
            hasController = true;
            if (extraProps != null && extraProps.size() > 0) {
                controllerProps = new Properties();
                controllerProps.putAll((Map<?, ?>)extraProps);
            }
        }
        if (numClients > 0) {
            Properties vmExtraProps = new Properties();
            if (extraProps != null && extraProps.size() > 0) {
                vmExtraProps.putAll((Map<?, ?>)extraProps);
            }
            this.setMasterCommonProperties(vmExtraProps);
            for (int index = 0; index < numClients; ++index) {
                VM newVM = getVM.get(index, currentClientVms, host);
                if (newVM != null) {
                    this.getLogWriter().info((Object)(action + " VM with pid [" + newVM.getPid() + "] as " + vmType));
                    if (numClients == 1 && !hasController) {
                        this.members.put((DistributedMember)newVM.invoke(((Object)((Object)this)).getClass(), "_startNewClient", new Object[]{((Object)((Object)this)).getClass().getName(), this.getName(), mcastPort, serverGroups, vmExtraProps, this.configureDefaultOffHeap}), newVM);
                        this.clientVMs.add(newVM);
                        continue;
                    }
                    startList.add(new AsyncVM(newVM.invokeAsync(((Object)((Object)this)).getClass(), "_startNewClient", new Object[]{((Object)((Object)this)).getClass().getName(), this.getName(), mcastPort, serverGroups, vmExtraProps, this.configureDefaultOffHeap}), newVM));
                    continue;
                }
                hasController = true;
                if (extraProps == null || extraProps.size() <= 0) continue;
                controllerProps = new Properties();
                controllerProps.putAll((Map<?, ?>)extraProps);
            }
        }
        if (hasController) {
            this.getLogWriter().info((Object)(action + " this controller VM as " + vmType));
            this.members.put(DistributedSQLTestBase._startNewClient(((Object)((Object)this)).getClass().getName(), this.getName(), mcastPort, serverGroups, controllerProps, this.configureDefaultOffHeap), null);
            if (addVM) {
                this.clientVMs.add(null);
            }
        }
    }

    public void restartClientVMNums(int[] vmNums, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        ArrayList<AsyncVM> restartList = new ArrayList<AsyncVM>(5);
        this.invokeRestartClientVMNums(vmNums, vmNums.length, mcastPort, serverGroups, extraProps, restartList);
        for (AsyncVM async : restartList) {
            this.joinVM(false, false, async);
        }
    }

    private void invokeRestartClientVMNums(final int[] vmNums, int numVMs, int mcastPort, String serverGroups, Properties extraProps, List<AsyncVM> restartList) throws Exception {
        this.invokeStartClientVMs(numVMs, mcastPort, serverGroups, extraProps, new GetVM(){

            @Override
            public VM get(int index, int numCurrentVMs, Host host) {
                return DistributedSQLTestBase.this.clientVMs.get(vmNums[index] - 1);
            }

            @Override
            public boolean addVM() {
                return false;
            }

            @Override
            public String actionName() {
                return "Restarting";
            }
        }, restartList);
    }

    protected Properties getClientConfig(int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        Properties props = new Properties();
        this.setCommonProperties(props, mcastPort, serverGroups, extraProps);
        TestUtil.setPropertyIfAbsent(props, "host-data", "false");
        return props;
    }

    public static DistributedMember _startNewServer(String className, String name, int mcastPort, String serverGroups, Properties extraProps, boolean configureOffHeap) throws Exception {
        Class<?> c = Class.forName(className);
        DistributedSQLTestBase test = (DistributedSQLTestBase)((Object)c.getConstructor(String.class).newInstance(name));
        test.configureDefaultOffHeap = configureOffHeap;
        Properties props = test.getServerConfig(mcastPort, serverGroups, extraProps);
        TestUtil.loadDriver();
        return TestUtil.setupConnection(props);
    }

    public void startServerVMs(int numServers, int mcastPort, String serverGroups) throws Exception {
        this.startServerVMs(numServers, mcastPort, serverGroups, null, addNewServerVM);
    }

    public void startServerVMs(int numServers, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        this.startServerVMs(numServers, mcastPort, serverGroups, extraProps, addNewServerVM);
    }

    private void startServerVMs(int numServers, int mcastPort, String serverGroups, Properties extraProps, GetVM getVM) throws Exception {
        ArrayList<AsyncVM> startList = new ArrayList<AsyncVM>(5);
        this.invokeStartServerVMs(numServers, mcastPort, serverGroups, extraProps, getVM, startList);
        boolean addVM = getVM.addVM();
        for (AsyncVM async : startList) {
            this.joinVM(true, addVM, async);
        }
    }

    private void invokeStartServerVMs(int numServers, int mcastPort, String serverGroups, Properties extraProps, GetVM getVM, List<AsyncVM> startList) throws Exception {
        DistributedSQLTestBase.assertTrue((String)"Negative number of servers!", (numServers >= 0 ? 1 : 0) != 0);
        int maxVms = Host.getHost((int)0).getVMCount();
        DistributedSQLTestBase.assertTrue((String)("Maximum number of servers is " + maxVms), (numServers <= maxVms ? 1 : 0) != 0);
        Host host = Host.getHost((int)0);
        Properties vmExtraProps = new Properties();
        if (extraProps != null) {
            vmExtraProps.putAll((Map<?, ?>)extraProps);
        }
        this.setMasterCommonProperties(vmExtraProps);
        for (int index = 0; index < numServers; ++index) {
            startList.add(this.invokeStartServerVM(index, mcastPort, serverGroups, host, vmExtraProps, getVM));
        }
    }

    public AsyncVM invokeStartServerVM(int vmNum, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        Host host = Host.getHost((int)0);
        Properties vmExtraProps = new Properties();
        if (extraProps != null) {
            vmExtraProps.putAll((Map<?, ?>)extraProps);
        }
        this.setMasterCommonProperties(vmExtraProps);
        return this.invokeStartServerVM(vmNum - 1, mcastPort, serverGroups, host, vmExtraProps, addNewServerVM);
    }

    private AsyncVM invokeStartServerVM(int index, int mcastPort, String serverGroups, Host host, Properties vmExtraProps, GetVM getVM) throws Exception {
        int currentServerVMs = this.serverVMs.size();
        if (getVM.addVM()) {
            int totalVMs = this.clientVMs.size() + currentServerVMs + 1;
            int maxVMs = Host.getHost((int)0).getVMCount() + 1;
            DistributedSQLTestBase.assertTrue((String)("Total number of available VMs is " + maxVMs), (totalVMs <= maxVMs ? 1 : 0) != 0);
        }
        VM newVM = getVM.get(index, currentServerVMs, host);
        this.getLogWriter().info((Object)(getVM.actionName() + " VM with pid [" + newVM.getPid() + "] as server."));
        return new AsyncVM(newVM.invokeAsync(((Object)((Object)this)).getClass(), "_startNewServer", new Object[]{((Object)((Object)this)).getClass().getName(), this.getName(), mcastPort, serverGroups, vmExtraProps, this.configureDefaultOffHeap}), newVM);
    }

    public void startVMs(int numClients, int numServers) throws Exception {
        this.startVMs(numClients, numServers, 0, null, null);
    }

    public void startVMs(int numClients, int numServers, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        ArrayList<AsyncVM> serverStartList = new ArrayList<AsyncVM>(9);
        ArrayList<AsyncVM> clientStartList = new ArrayList<AsyncVM>(9);
        if (numServers > 0) {
            this.invokeStartServerVMs(numServers, mcastPort, serverGroups, extraProps, addNewServerVM, serverStartList);
        }
        if (numClients > 0) {
            this.invokeStartClientVMs(numClients, mcastPort, serverGroups, extraProps, addNewClientVM, clientStartList);
        }
        for (AsyncVM async : serverStartList) {
            this.joinVM(true, true, async);
        }
        for (AsyncVM async : clientStartList) {
            this.joinVM(false, true, async);
        }
    }

    public void restartServerVMNums(int[] vmNums, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        ArrayList<AsyncVM> restartList = new ArrayList<AsyncVM>(5);
        this.invokeRestartServerVMNums(vmNums, vmNums.length, mcastPort, serverGroups, extraProps, restartList);
        for (AsyncVM async : restartList) {
            this.joinVM(true, false, async);
        }
    }

    private void invokeRestartServerVMNums(int[] vmNums, int numVMs, int mcastPort, String serverGroups, Properties extraProps, List<AsyncVM> restartList) throws Exception {
        DistributedSQLTestBase.assertTrue((String)"Negative number of servers!", (vmNums.length >= 0 ? 1 : 0) != 0);
        int maxVms = Host.getHost((int)0).getVMCount();
        DistributedSQLTestBase.assertTrue((String)("Maximum number of servers is " + maxVms), (vmNums.length <= maxVms ? 1 : 0) != 0);
        Host host = Host.getHost((int)0);
        Properties vmExtraProps = new Properties();
        if (extraProps != null) {
            vmExtraProps.putAll((Map<?, ?>)extraProps);
        }
        this.setMasterCommonProperties(vmExtraProps);
        for (int index = 0; index < numVMs; ++index) {
            restartList.add(this.invokeStartServerVM(vmNums[index] - 1, mcastPort, serverGroups, host, vmExtraProps, this.restartServerVM));
        }
    }

    public AsyncVM restartServerVMAsync(int vmNum, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        Host host = Host.getHost((int)0);
        Properties vmExtraProps = new Properties();
        if (extraProps != null) {
            vmExtraProps.putAll((Map<?, ?>)extraProps);
        }
        this.setMasterCommonProperties(vmExtraProps);
        return this.invokeStartServerVM(vmNum - 1, mcastPort, serverGroups, host, vmExtraProps, this.restartServerVM);
    }

    public void restartVMNums(int ... vmNums) throws Exception {
        this.restartVMNums(vmNums, 0, null, null);
    }

    public void restartVMNums(int[] vmNums, int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        ArrayList<AsyncVM> restartList = new ArrayList<AsyncVM>(5);
        int[] serverVMNums = new int[vmNums.length];
        int[] clientVMNums = new int[vmNums.length];
        int serverVMIndex = 0;
        int clientVMIndex = 0;
        for (int vmNum : vmNums) {
            if (vmNum < 0) {
                serverVMNums[serverVMIndex++] = -vmNum;
                continue;
            }
            clientVMNums[clientVMIndex++] = vmNum;
        }
        if (serverVMIndex > 0) {
            this.invokeRestartServerVMNums(serverVMNums, serverVMIndex, mcastPort, serverGroups, extraProps, restartList);
        }
        if (clientVMIndex > 0) {
            this.invokeRestartClientVMNums(clientVMNums, clientVMIndex, mcastPort, serverGroups, extraProps, restartList);
        }
        for (AsyncVM async : restartList) {
            this.joinVM(false, async);
        }
    }

    public void joinVM(boolean addVM, AsyncVM asyncVM) throws Exception {
        this.joinVM(true, addVM, asyncVM);
    }

    public void joinVMs(boolean addVM, AsyncVM ... vmEntries) throws Exception {
        for (int index = 0; index < vmEntries.length; ++index) {
            this.joinVM(true, addVM, vmEntries[index]);
        }
    }

    protected void joinVM(boolean isServer, boolean addVM, AsyncVM asyncVM) throws Exception {
        AsyncInvocation async = asyncVM.getInvocation();
        VM newVM = asyncVM.getVM();
        this.joinAsyncInvocation(async, newVM);
        Object result = async.getReturnValue();
        if (result != null && result instanceof DistributedMember) {
            if (addVM) {
                if (isServer) {
                    this.serverVMs.add(newVM);
                } else {
                    this.clientVMs.add(newVM);
                }
            }
            this.members.put((DistributedMember)result, newVM);
        }
    }

    protected Properties getServerConfig(int mcastPort, String serverGroups, Properties extraProps) throws Exception {
        Properties props = new Properties();
        this.setCommonProperties(props, mcastPort, serverGroups, extraProps);
        TestUtil.setPropertyIfAbsent(props, "host-data", "true");
        return props;
    }

    private void shutDownRestart(int serverNum, long sleepTimeMilliSec) throws Exception {
        this.stopVMNums(-serverNum);
        DistributedSQLTestBase.assertTrue((String)"sleep time before reconnect should be > 0", (sleepTimeMilliSec > 0L ? 1 : 0) != 0);
        try {
            Thread.sleep(sleepTimeMilliSec);
        }
        catch (InterruptedException e) {
            DistributedSQLTestBase.fail("exception while sleeping", e);
        }
        this.restartServerVMNums(new int[]{serverNum}, 0, null, null);
    }

    public void disconnectAndConnectAServerVM(final int serverNum, long sleepTimeMilliSec, boolean sync, List<AsyncInvocation> ainvoke) throws Exception {
        DistributedSQLTestBase.assertTrue((String)"Negative server number!", (serverNum >= 0 ? 1 : 0) != 0);
        int maxVms = Host.getHost((int)0).getVMCount();
        DistributedSQLTestBase.assertTrue((String)("Maximum number of servers is " + maxVms), (serverNum <= maxVms ? 1 : 0) != 0);
        if (sync) {
            this.restartServerVMNums(new int[]{serverNum}, 0, null, null);
        } else {
            final long sleepTime = sleepTimeMilliSec;
            final SerializableRunnable disconnConn = new SerializableRunnable("disconnConn"){

                public void run() throws CacheException {
                    try {
                        DistributedSQLTestBase.this.shutDownRestart(serverNum, sleepTime);
                    }
                    catch (Exception e) {
                        throw new CacheException("failed due to exception in restart", e){};
                    }
                }
            };
            AsyncInvocation ai = new AsyncInvocation((Object)disconnConn, "run", new Runnable(){

                @Override
                public void run() {
                    disconnConn.run();
                }
            });
            ai.start();
            ainvoke.add(ai);
        }
    }

    protected final AsyncVM stopVMNumAsync(int vmNum) {
        String vmType;
        DistributedSQLTestBase.assertTrue((String)"VM number should not be 0", (vmNum != 0 ? 1 : 0) != 0);
        VM vm = this.getVM(vmNum);
        String string = vmType = vmNum < 0 ? "server" : "client";
        if (vm != null) {
            this.getLogWriter().info((Object)("Stopping " + vmType + " VM with pid [" + vm.getPid() + "]."));
            return new AsyncVM(vm.invokeAsync(((Object)((Object)this)).getClass(), "_stopVM", new Object[]{TestUtil.deletePersistentFiles}), vm);
        }
        return null;
    }

    protected final void stopVM(VM vm, String vmType) throws SQLException {
        if (vm != null) {
            this.getLogWriter().info((Object)("Stopping " + vmType + " VM with pid [" + vm.getPid() + "]."));
            vm.invoke(((Object)((Object)this)).getClass(), "_stopVM", new Object[]{TestUtil.deletePersistentFiles});
        } else {
            this.getLogWriter().info((Object)"Stopping this controller VM as client.");
            DistributedSQLTestBase._stopVM(TestUtil.deletePersistentFiles);
        }
    }

    public final void stopVMNum(int vmNum) throws SQLException {
        DistributedSQLTestBase.assertTrue((String)"VM number should not be 0", (vmNum != 0 ? 1 : 0) != 0);
        if (vmNum < 0) {
            this.stopVM(this.getServerVM(-vmNum), "server");
        } else {
            this.stopVM(this.getClientVM(vmNum), "client");
        }
    }

    public static void _stopVM(Boolean deletePersistenceFile) throws SQLException {
        TestUtil.shutDown();
        if (deletePersistenceFile.booleanValue()) {
            DistributedSQLTestBase.deleteTestArtifacts();
        }
    }

    public void stopVMNums(int ... vmNums) throws SQLException {
        DistributedSQLTestBase.assertTrue((String)"At least one VM should be stopped", (vmNums != null && vmNums.length > 0 ? 1 : 0) != 0);
        for (int vmNum : vmNums) {
            this.stopVMNum(vmNum);
        }
    }

    public void stopAllVMs() throws SQLException {
        this.stopAllVMs(0);
    }

    public void stopAllVMs(int lastVMNum) throws SQLException {
        for (int serverNum = 1; serverNum <= this.serverVMs.size(); ++serverNum) {
            if (lastVMNum == -serverNum) continue;
            this.stopVMNum(-serverNum);
        }
        for (int clientNum = 1; clientNum <= this.clientVMs.size(); ++clientNum) {
            if (lastVMNum == clientNum) continue;
            this.stopVMNum(clientNum);
        }
        if (lastVMNum != 0) {
            this.stopVMNum(lastVMNum);
        } else {
            this.getLogWriter().info((Object)"Stopping this controller VM as client.");
            DistributedSQLTestBase._stopVM(TestUtil.deletePersistentFiles);
        }
    }

    public void stopAllVMsAsync(int lastVMNum) throws SQLException {
        ArrayList<AsyncVM> stopList = new ArrayList<AsyncVM>(5);
        boolean stopController = false;
        for (int serverNum = 1; serverNum <= this.serverVMs.size(); ++serverNum) {
            if (lastVMNum == -serverNum) continue;
            stopList.add(this.stopVMNumAsync(-serverNum));
        }
        for (int clientNum = 1; clientNum <= this.clientVMs.size(); ++clientNum) {
            if (lastVMNum == clientNum) continue;
            AsyncVM async = this.stopVMNumAsync(clientNum);
            if (async != null) {
                stopList.add(async);
                continue;
            }
            stopController = true;
        }
        if (stopController) {
            this.getLogWriter().info((Object)"Stopping this controller VM as client.");
            DistributedSQLTestBase._stopVM(TestUtil.deletePersistentFiles);
        }
        for (AsyncVM async : stopList) {
            try {
                this.joinAsyncInvocation(async.getInvocation(), async.getVM());
            }
            catch (InterruptedException ie) {
                throw new TestException("unexpected interrupted exception in stopping VM " + async.getVM(), (Throwable)ie);
            }
        }
        if (lastVMNum != 0) {
            this.stopVMNum(lastVMNum);
        }
    }

    public void clientSQLExecute(int clientNum, String jdbcSQL) throws Exception {
        this.clientSQLExecute(clientNum, jdbcSQL, true, false, false);
    }

    public void clientSQLExecute(int clientNum, String jdbcSQL, boolean usePrepStmt, boolean checkTypeInfo, boolean consumeResults) throws Exception {
        DistributedSQLTestBase.assertTrue((String)("Client number should be positive and not exceed total number of clients: " + this.clientVMs.size()), (clientNum > 0 && clientNum <= this.clientVMs.size() ? 1 : 0) != 0);
        this.execute(this.clientVMs.get(clientNum - 1), jdbcSQL, false, null, null, null, null, null, usePrepStmt, checkTypeInfo, consumeResults);
    }

    public final VM getServerVM(int serverNum) {
        DistributedSQLTestBase.assertTrue((String)("Server number should be positive and not exceed total number of servers: " + this.serverVMs.size()), (serverNum > 0 && serverNum <= this.serverVMs.size() ? 1 : 0) != 0);
        return this.serverVMs.get(serverNum - 1);
    }

    public final VM getClientVM(int vmNum) {
        DistributedSQLTestBase.assertTrue((String)("Client number " + vmNum + " should not exceed total " + "number of clients: " + this.clientVMs.size()), (vmNum <= this.clientVMs.size() ? 1 : 0) != 0);
        return this.clientVMs.get(vmNum - 1);
    }

    public void serverExecute(int serverNum, Runnable runnable) throws Exception {
        this.getServerVM(serverNum).invoke(runnable);
    }

    public void clientExecute(int clientNum, Runnable runnable) throws Exception {
        DistributedSQLTestBase.assertTrue((String)("Client number should be positive and not exceed total number of clients: " + this.clientVMs.size()), (clientNum > 0 && clientNum <= this.clientVMs.size() ? 1 : 0) != 0);
        VM vm = this.clientVMs.get(clientNum - 1);
        if (vm != null) {
            vm.invoke(runnable);
        } else {
            runnable.run();
        }
    }

    public Object serverExecute(int serverNum, Callable<?> callable) throws Exception {
        return this.getServerVM(serverNum).invoke(callable);
    }

    public Object clientExecute(int clientNum, Callable<?> callable) throws Exception {
        DistributedSQLTestBase.assertTrue((String)("Client number should be positive and not exceed total number of clients: " + this.clientVMs.size()), (clientNum > 0 && clientNum <= this.clientVMs.size() ? 1 : 0) != 0);
        VM vm = this.clientVMs.get(clientNum - 1);
        if (vm != null) {
            return vm.invoke(callable);
        }
        return callable.call();
    }

    public void serverSQLExecute(int serverNum, String jdbcSQL) throws Exception {
        this.serverSQLExecute(serverNum, jdbcSQL, true, false, false);
    }

    public void serverSQLExecute(int serverNum, String jdbcSQL, boolean usePrepStmt, boolean checkTypeInfo, boolean consumeResults) throws Exception {
        DistributedSQLTestBase.assertTrue((String)("Server number should be positive and not exceed total number of servers: " + this.serverVMs.size()), (serverNum > 0 && serverNum <= this.serverVMs.size() ? 1 : 0) != 0);
        this.execute(this.serverVMs.get(serverNum - 1), jdbcSQL, false, null, null, null, null, null, usePrepStmt, checkTypeInfo, consumeResults);
    }

    public void sqlExecuteVerify(int[] clientNums, int[] serverNums, String jdbcSQL, String goldenTextFile, String resultSetID) throws Exception {
        this.sqlExecuteVerify(clientNums, serverNums, jdbcSQL, goldenTextFile, resultSetID, true, false);
    }

    public void sqlExecuteVerify(int[] clientNums, int[] serverNums, String jdbcSQL, String goldenTextFile, String resultSetID, boolean usePrepStmt, boolean checkTypeInfo) throws Exception {
        this.execute(this.getVMs(clientNums, serverNums), jdbcSQL, true, goldenTextFile, resultSetID, null, null, null, usePrepStmt, checkTypeInfo);
    }

    public void clientVerifyRegionProperties(int clientNum, String schemaName, String tableName, RegionAttributes<?, ?> expectedAttrs) throws Exception {
        DistributedSQLTestBase.assertTrue((String)("Client number should be positive and not exceed total number of clients: " + this.clientVMs.size()), (clientNum > 0 && clientNum <= this.clientVMs.size() ? 1 : 0) != 0);
        this.execute(this.clientVMs.get(clientNum - 1), null, false, null, null, schemaName, tableName, expectedAttrs, false, false, false);
    }

    public void serverVerifyRegionProperties(int serverNum, String schemaName, String tableName, RegionAttributes<?, ?> expectedAttrs) throws Exception {
        DistributedSQLTestBase.assertTrue((String)("Server number should be positive and not exceed total number of servers: " + this.serverVMs.size()), (serverNum > 0 && serverNum <= this.serverVMs.size() ? 1 : 0) != 0);
        this.execute(this.serverVMs.get(serverNum - 1), null, false, null, null, schemaName, tableName, expectedAttrs, false, false, false);
    }

    public void addExpectedException(int[] clientNums, int[] serverNums, Object exceptionClass) {
        this.addExpectedException(clientNums, serverNums, new Object[]{exceptionClass});
    }

    public void addExpectedException(int[] clientNums, int[] serverNums, Object[] exceptionClasses) {
        for (VM vm : this.getVMs(clientNums, serverNums, true)) {
            this.addExpectedException(vm, exceptionClasses);
        }
    }

    public void addExpectedException(VM vm, Object[] exceptionClasses) {
        if (vm != null) {
            vm.invoke(TestUtil.class, "addExpectedExceptions", new Object[]{exceptionClasses});
        } else {
            TestUtil.addExpectedExceptions(exceptionClasses);
        }
    }

    public void removeExpectedException(int[] clientNums, int[] serverNums, Object exceptionClass) {
        this.removeExpectedException(clientNums, serverNums, new Object[]{exceptionClass});
    }

    public void removeExpectedException(int[] clientNums, int[] serverNums, Object[] exceptionClasses) {
        for (VM vm : this.getVMs(clientNums, serverNums, true)) {
            this.removeExpectedException(vm, exceptionClasses);
        }
    }

    public void removeExpectedException(VM vm, Object[] exceptionClasses) {
        if (vm != null) {
            vm.invoke(TestUtil.class, "removeExpectedExceptions", new Object[]{exceptionClasses});
        } else {
            TestUtil.removeExpectedExceptions(exceptionClasses);
        }
    }

    public ArrayList<AsyncInvocation> executeTaskAsync(int[] clientNums, int[] serverNums, Runnable r) {
        ArrayList<VM> vms = this.getVMs(clientNums, serverNums);
        ArrayList<AsyncInvocation> asyncList = new ArrayList<AsyncInvocation>(vms.size());
        for (VM vm : vms) {
            asyncList.add(vm.invokeAsync(r));
        }
        return asyncList;
    }

    public void joinAsyncInvocation(AsyncInvocation invocation, VM vm) throws InterruptedException {
        invocation.join();
        if (invocation.exceptionOccurred()) {
            Object o = invocation.getReceiver();
            throw new RMIException(vm, o instanceof Class ? ((Class)o).getName() : o.getClass().getName(), invocation.getMethodName(), invocation.getException());
        }
    }

    public void joinAsyncInvocation(Collection<AsyncInvocation> invocations) throws InterruptedException {
        for (AsyncInvocation invocation : invocations) {
            invocation.join();
            if (!invocation.exceptionOccurred()) continue;
            DistributedSQLTestBase.fail("Error in [" + invocation.getReceiver() + "]", invocation.getException());
        }
    }

    protected void addLogString(int[] clientNums, int[] serverNums, final String logStr) {
        for (VM vm : this.getVMs(clientNums, serverNums, true)) {
            if (vm != null) {
                vm.invoke((Runnable)new SerializableRunnable("add log string"){

                    public void run() {
                        TestUtil.addLogString(logStr);
                    }
                });
                continue;
            }
            TestUtil.addLogString(logStr);
        }
    }

    public static void _startNetworkServer(String className, String name, int mcastPort, int netPort, String serverGroups, Properties extraProps, Boolean configureDefautHeap) throws Exception {
        Class<?> c = Class.forName(className);
        if (TestUtil.getFabricService().status() != FabricService.State.RUNNING) {
            DistributedSQLTestBase._startNewServer(className, name, mcastPort, serverGroups, extraProps, configureDefautHeap);
        }
        DistributedSQLTestBase test = (DistributedSQLTestBase)((Object)c.getConstructor(String.class).newInstance(name));
        test.configureDefaultOffHeap = configureDefautHeap;
        Properties props = new Properties();
        test.setCommonProperties(props, mcastPort, serverGroups, extraProps);
        TestUtil.startNetServer(netPort, props);
    }

    public static void shutDownNetworkServer() {
        TestUtil.stopNetServer();
    }

    public int startNetworkServer(int vmNum, String serverGroups, Properties extraProps) throws Exception {
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        this.startNetworkServer(vmNum, serverGroups, extraProps, netPort);
        return netPort;
    }

    protected void startNetworkServer(int vmNum, String serverGroups, Properties extraProps, int netPort) throws Exception {
        DistributedSQLTestBase.assertTrue((String)"VM number should be >= 1", (vmNum >= 1 ? 1 : 0) != 0);
        int maxVMs = Host.getHost((int)0).getVMCount();
        DistributedSQLTestBase.assertTrue((String)("Maximum number of servers is " + maxVMs), (vmNum <= maxVMs ? 1 : 0) != 0);
        int totalVMs = this.clientVMs.size() + vmNum;
        DistributedSQLTestBase.assertTrue((String)("Total number of available VMs is " + maxVMs + 1), (totalVMs <= maxVMs + 1 ? 1 : 0) != 0);
        Host host = Host.getHost((int)0);
        extraProps = this.setMasterCommonProperties(extraProps);
        VM newVM = host.getVM(vmNum - 1);
        this.getLogWriter().info((Object)("Starting VM with pid [" + newVM.getPid() + "] as gemfirexd network server on port: " + netPort));
        newVM.invoke(DistributedSQLTestBase.class, "_startNetworkServer", new Object[]{((Object)((Object)this)).getClass().getName(), this.getName(), 0, netPort, serverGroups, extraProps, this.configureDefaultOffHeap});
        if (vmNum > this.serverVMs.size()) {
            this.serverVMs.add(newVM);
        }
    }

    public static final String getQualifiedInetAddress(InetAddress addr) {
        String hostName = addr.getCanonicalHostName();
        if (hostName != null) {
            return hostName + '/' + addr.getHostAddress();
        }
        return "/" + addr.getHostAddress();
    }

    protected final void attachConnectionListener(VM vm, SerializableConnectionListener listener) throws Exception {
        vm.invoke(((Object)((Object)this)).getClass(), "attachConnectionListener", new Object[]{listener});
    }

    protected final void attachConnectionListener(int serverNum, SerializableConnectionListener listener) throws Exception {
        this.attachConnectionListener(this.getServerVM(serverNum), listener);
    }

    public static final void attachConnectionListener(SerializableConnectionListener listener) throws Exception {
        numConnectionsOpened.set(0);
        numConnectionsClosed.set(0);
        TestUtil.netServer.setConnectionListener((NetworkInterface.ConnectionListener)listener);
    }

    public static int[] getNumConnections() {
        return new int[]{numConnectionsOpened.get(), numConnectionsClosed.get()};
    }

    protected void assertNumConnections(final int expectedConnectionsOpened, final int expectedConnectionsClosed, final VM ... vms) throws Exception {
        DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){
            private int openConns;
            private int closedConns;

            public boolean done() {
                boolean done;
                this.openConns = 0;
                this.closedConns = 0;
                for (VM vm : vms) {
                    int[] res = (int[])vm.invoke(DistributedSQLTestBase.class, "getNumConnections");
                    this.openConns += res[0];
                    this.closedConns += res[1];
                }
                if (expectedConnectionsOpened < 0) {
                    done = -expectedConnectionsOpened >= this.openConns;
                } else {
                    boolean bl = done = expectedConnectionsOpened == this.openConns;
                }
                done = expectedConnectionsClosed < 0 ? (done &= -expectedConnectionsClosed >= this.closedConns) : (done &= expectedConnectionsClosed == this.closedConns);
                return done;
            }

            public String description() {
                return "waiting for expectedConnectionsOpened=" + expectedConnectionsOpened + ", expectedConnectionsClosed=" + expectedConnectionsClosed + ", but got " + this.openConns + " and " + this.closedConns + " respectively";
            }
        };
        DistributedSQLTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)10000L, (long)500L, (boolean)true);
    }

    protected void assertNumConnections(int expectedConnectionsOpened, int expectedConnectionsClosed, int ... serverNums) throws Exception {
        VM[] serverVMs = new VM[serverNums.length];
        this.assertNumConnections(expectedConnectionsOpened, expectedConnectionsClosed, this.getVMs(null, serverNums).toArray(serverVMs));
    }

    public boolean stopNetworkServer(int vmNum) throws Exception {
        int currentServerVms = this.serverVMs.size();
        DistributedSQLTestBase.assertTrue((String)("Server number [" + vmNum + "] should be >= 1"), (vmNum >= 1 ? 1 : 0) != 0);
        DistributedSQLTestBase.assertTrue((String)("Total number of server VMs is " + currentServerVms), (vmNum <= currentServerVms ? 1 : 0) != 0);
        VM vm = this.serverVMs.get(vmNum - 1);
        this.getLogWriter().info((Object)("Stopping VM with pid [" + vm.getPid() + "] as gemfirexd network server."));
        return vm.invokeBoolean(TestUtil.class, "stopNetServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown2() throws Exception {
        GemFireXDUtils.IS_TEST_MODE = false;
        DoPreCleanup preCleanup = new DoPreCleanup();
        boolean[] requiresCleanup = (boolean[])preCleanup.call();
        Map requiresCleanupMap = DistributedSQLTestBase.invokeInEveryVM((SerializableCallable)preCleanup);
        DoCleanupOnAll1 doCleanup1 = new DoCleanupOnAll1();
        this.performCleanupOnAll(doCleanup1, requiresCleanup, requiresCleanupMap, 0);
        DoCleanup doCleanup = new DoCleanup();
        Boolean done = (Boolean)doCleanup.call();
        if (done != Boolean.TRUE) {
            for (int h = 0; h < Host.getHostCount(); ++h) {
                VM vm;
                Host host = Host.getHost((int)h);
                for (int v = 0; v < host.getVMCount() && (done = (Boolean)(vm = host.getVM(v)).invoke((Callable)((Object)doCleanup))) != Boolean.TRUE; ++v) {
                }
                if (done == Boolean.TRUE) break;
            }
        }
        DoCleanupOnAll2 doCleanup2 = new DoCleanupOnAll2();
        this.performCleanupOnAll(doCleanup2, requiresCleanup, requiresCleanupMap, 1);
        DoCleanupOnAll3 doCleanup3 = new DoCleanupOnAll3();
        this.performCleanupOnAll(doCleanup3, requiresCleanup, requiresCleanupMap, 2);
        if (this.reduceLogging() != null || System.getProperty("gemfire.log-level") != null) {
            this.reduceLogLevelForTest(null);
        }
        try {
            this.shutDownAll();
            super.tearDown2();
        }
        catch (Throwable throwable) {
            String[] dbs = new String[]{"newDB", "newDB2", "newDB3"};
            ModuleFactory mon = Monitor.getMonitor();
            HeaderPrintWriter pw = mon != null && mon.getSystemStreams() != null ? mon.getSystemStreams().stream() : null;
            if (pw != null) {
                pw.println("<ExpectedException action=add>SQLException</ExpectedException>");
            }
            for (String db : dbs) {
                if (pw != null) {
                    try {
                        DriverManager.getConnection("jdbc:derby:" + db + ";shutdown=true");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                try {
                    TestUtil.deleteDir(new File(db));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (pw != null) {
                pw.println("<ExpectedException action=remove>SQLException</ExpectedException>");
            }
            throw throwable;
        }
        String[] dbs = new String[]{"newDB", "newDB2", "newDB3"};
        ModuleFactory mon = Monitor.getMonitor();
        HeaderPrintWriter pw = mon != null && mon.getSystemStreams() != null ? mon.getSystemStreams().stream() : null;
        if (pw != null) {
            pw.println("<ExpectedException action=add>SQLException</ExpectedException>");
        }
        for (String db : dbs) {
            if (pw != null) {
                try {
                    DriverManager.getConnection("jdbc:derby:" + db + ";shutdown=true");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                TestUtil.deleteDir(new File(db));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pw != null) {
            pw.println("<ExpectedException action=remove>SQLException</ExpectedException>");
        }
        this.configureDefaultOffHeap(false);
    }

    private void performCleanupOnAll(SerializableRunnable doCleanup, boolean[] requiresCleanup, Map<?, ?> requiresCleanupMap, int requiresCleanIndex) {
        if (requiresCleanup[requiresCleanIndex]) {
            doCleanup.run();
        }
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost((int)h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                Object requiresCleanupObj = requiresCleanupMap.get(vm);
                if (requiresCleanupObj == null || !((boolean[])requiresCleanupObj)[requiresCleanIndex]) continue;
                vm.invoke((Runnable)doCleanup);
            }
        }
    }

    protected static final void executeCleanup(Statement stmt, String sql) {
        try {
            stmt.execute(sql);
        }
        catch (SQLException sqle) {
            DistributedSQLTestBase.getGlobalLogger().warn((Object)"unexpected exception", (Throwable)sqle);
        }
    }

    public static void vmShutDown(String className) throws Exception {
        Class<?> c = Class.forName(className);
        ((DistributedSQLTestBase)((Object)c.getConstructor(String.class).newInstance("tmp"))).vmTearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void vmTearDown() throws Exception {
        try {
            for (String exStr : expectedDerbyExceptions) {
                String expectedExRemoveStr = "<ExpectedException action=remove>" + exStr + "</ExpectedException>";
                System.out.println(expectedExRemoveStr);
                SanityManager.GET_DEBUG_STREAM().println(expectedExRemoveStr);
            }
            expectedDerbyExceptions.clear();
            numConnectionsOpened.set(0);
            numConnectionsClosed.set(0);
            DistributedSQLTestBase.deleteOrCreateDataDictionaryDir(true);
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
            System.setProperty("gemfire.off-heap-memory-size", "");
            Properties props = new Properties();
            this.setCommonProperties(props, 0, null, null);
            TestUtil.shutDown(props);
            DistributedSQLTestBase.deleteTestArtifacts();
            TestUtil.deletePersistentFiles = false;
        }
        finally {
            TestUtil.clearStatics();
        }
    }

    protected void baseShutDownAll() throws Exception {
        for (int hostNum = 0; hostNum < Host.getHostCount(); ++hostNum) {
            Host host = Host.getHost((int)hostNum);
            for (int vmNum = 0; vmNum < host.getVMCount(); ++vmNum) {
                VM vm = host.getVM(vmNum);
                try {
                    this.getLogWriter().info((Object)("Shutting down " + vm));
                    vm.invoke(DistributedSQLTestBase.class, "vmShutDown", new Object[]{((Object)((Object)this)).getClass().getName()});
                    continue;
                }
                catch (Exception ex) {
                    this.getLogWriter().error((Object)("Failed in shutdown for " + vm), (Throwable)ex);
                }
            }
        }
        try {
            DistributedSQLTestBase.vmShutDown(((Object)((Object)this)).getClass().getName());
        }
        catch (Exception ex) {
            this.getLogWriter().error((Object)"Failed in shutdown for controller VM", (Throwable)ex);
        }
        this.clientVMs.clear();
        this.serverVMs.clear();
        this.members.clear();
        this.locatorString = null;
        TestConfiguration.odbcIni.delete();
    }

    public void shutDownAll() throws Exception {
        this.baseShutDownAll();
    }

    public static void deleteStrayDataDictionaryDir() {
        DistributedSQLTestBase.deleteStrayDataDictionaryDir(true);
    }

    static void deleteStrayDataDictionaryDir(boolean force) {
        String parent = System.getProperty(GfxdConstants.GFXD_PREFIX + "sys-disk-dir");
        File dir = null;
        if (parent == null || parent.equals("")) {
            if (!force) {
                return;
            }
            dir = new File("datadictionary");
        } else {
            dir = new File(parent, "datadictionary");
        }
        boolean result = TestUtil.deleteDir(dir);
        TestUtil.getLogger().info((Object)("For Test: " + currentClassName + ":" + currentTestName + " found and deleted stray datadictionarydir at: " + dir.toString() + " : " + result));
    }

    public static void deleteDataDictionaryDir() {
        DistributedSQLTestBase.deleteOrCreateDataDictionaryDir(false);
    }

    public static void deleteGlobalIndexCachinDir() {
        File dir = new File(DistributedSQLTestBase.getSysDiskDir(), "globalIndex");
        boolean result = TestUtil.deleteDir(dir);
        DistributedSQLTestBase.getGlobalLogger().info((Object)("For Test: " + currentClassName + ":" + currentTestName + " found and deleted globalIndex cache at: " + dir.toString() + " : " + result));
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new DiskAccessException("Could not create directory for  global index caching: " + dir.getAbsolutePath(), (Region)null);
        }
    }

    protected static void deleteOrCreateDataDictionaryDir(boolean create) {
        File dir = new File(DistributedSQLTestBase.getSysDiskDir(), "datadictionary");
        if (!create) {
            boolean result = TestUtil.deleteDir(dir);
            DistributedSQLTestBase.getGlobalLogger().info((Object)("For Test: " + currentClassName + ":" + currentTestName + " found and deleted datadictionarydir at: " + dir.toString() + " : " + result));
            DistributedSQLTestBase.deleteStrayDataDictionaryDir(false);
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new DiskAccessException("Could not create directory for  datadictionary: " + dir.getAbsolutePath(), (Region)null);
        }
        DistributedSQLTestBase.getGlobalLogger().info((Object)("For Test: " + currentClassName + ":" + currentTestName + " created datadictionarydir at: " + dir.toString()));
    }

    protected final VM getVM(int vmNum) {
        if (vmNum < 0) {
            return this.getServerVM(-vmNum);
        }
        return this.getClientVM(vmNum);
    }

    public void waitForDDCreation(int vmNum) {
        VM vm = this.getVM(vmNum);
        if (vm != null) {
            vm.invoke(DistributedSQLTestBase.class, "_waitForDDCreation");
        } else {
            DistributedSQLTestBase._waitForDDCreation();
        }
    }

    public static void _waitForDDCreation() {
        DistributedSQLTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public String description() {
                return "waiting for DataDictionary region to initialize";
            }

            public boolean done() {
                LocalRegion region;
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                return cache != null && (region = (LocalRegion)cache.getRegion("_DDL_STMTS_META_REGION")) != null && region.isInitialized();
            }
        }, (long)120000L, (long)500L, (boolean)true);
    }

    public static void deleteTestArtifacts() {
        try {
            String[] testSpecificDirs;
            DistributedSQLTestBase.deleteDataDictionaryDir();
            DistributedSQLTestBase.deleteGlobalIndexCachinDir();
            DistributedSQLTestBase test = testInstance;
            if (test != null && (testSpecificDirs = test.testSpecificDirectoriesForDeletion()) != null) {
                for (String file : testSpecificDirs) {
                    File dir = new File(DistributedSQLTestBase.getSysDiskDir(), file);
                    boolean result = TestUtil.deleteDir(dir);
                    DistributedSQLTestBase.getGlobalLogger().info((Object)("For Test: " + currentClassName + ":" + currentTestName + " found and deleted test specific directory at: " + dir.toString() + " : " + result));
                }
            }
        }
        catch (Exception ex) {
            throw new TestException("unexpected exception", (Throwable)ex);
        }
    }

    public static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        DistributedSQLTestBase.delete(f);
                    }
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    protected void execute(VM executeVM, String jdbcSQL, boolean doVerify, String goldenTextFile, String nodeID, String schemaName, String tableName, RegionAttributes<?, ?> attrs, boolean usePrepStmt, boolean checkTypeInfo, boolean consumeResults) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException {
        if (jdbcSQL == null) {
            this.getLogWriter().info((Object)("Executing verifyRegionProperties for table [" + schemaName + "." + tableName + "] on VM: " + executeVM));
            if (executeVM != null) {
                executeVM.invoke(TestUtil.class, "verifyRegionProperties", new Object[]{schemaName, tableName, this.regionAttributesToXML(attrs, executeVM)});
            } else {
                TestUtil.verifyRegionProperties(schemaName, tableName, this.regionAttributesToXML(attrs, null));
            }
        } else if (doVerify) {
            this.getLogWriter().info((Object)("Executing sqlExecuteVerify [" + jdbcSQL + "] on VM: " + executeVM));
            if (goldenTextFile != null || nodeID != null) {
                if (executeVM != null) {
                    executeVM.invoke(TestUtil.class, "sqlExecuteVerifyText", new Object[]{jdbcSQL, goldenTextFile, nodeID, usePrepStmt, checkTypeInfo});
                } else {
                    TestUtil.sqlExecuteVerifyText(jdbcSQL, goldenTextFile, nodeID, usePrepStmt, checkTypeInfo);
                }
            } else if (executeVM != null) {
                executeVM.invoke(TestUtil.class, "sqlExecuteVerify", new Object[]{jdbcSQL, usePrepStmt});
            } else {
                TestUtil.sqlExecuteVerify(jdbcSQL, usePrepStmt);
            }
        } else {
            this.getLogWriter().info((Object)("Executing sqlExecute [" + jdbcSQL + "] on VM: " + executeVM));
            if (executeVM != null) {
                executeVM.invoke(TestUtil.class, "sqlExecute", new Object[]{jdbcSQL, usePrepStmt, consumeResults});
            } else {
                TestUtil.sqlExecute(jdbcSQL, usePrepStmt);
            }
        }
    }

    protected void execute(List<VM> executeVMs, String jdbcSQL, boolean doVerify, String goldenTextFile, String nodeID, String schemaName, String tableName, RegionAttributes<?, ?> attrs, boolean usePrepStmt, boolean checkTypeInfo) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException {
        for (VM vm : executeVMs) {
            this.execute(vm, jdbcSQL, doVerify, goldenTextFile, nodeID, schemaName, tableName, attrs, usePrepStmt, checkTypeInfo, false);
        }
    }

    protected static int executeUpdate(Statement stmt, String sql) throws SQLException {
        while (true) {
            try {
                if (sql != null) {
                    return stmt.executeUpdate(sql);
                }
                return ((PreparedStatement)stmt).executeUpdate();
            }
            catch (SQLException sqle) {
                String sqlState;
                Connection conn = stmt.getConnection();
                if (conn.getTransactionIsolation() != 0) continue;
                throw sqle;
                if ("40XD0".equals(sqlState = sqle.getSQLState()) || "40XD2".equals(sqlState)) continue;
                throw sqle;
            }
            break;
        }
    }

    public static String getRegionsStr(Cache gfCache) {
        StringBuilder sb = new StringBuilder();
        sb.append("Available regions: \n");
        for (Object regionObj : gfCache.rootRegions()) {
            Region region = (Region)regionObj;
            sb.append("\tRoot region: " + region.getFullPath() + "\n");
            for (Object subRegionObj : region.subregions(true)) {
                Region subRegion = (Region)subRegionObj;
                sb.append("\t\tSubregion: " + subRegion.getFullPath() + "\n");
            }
        }
        return sb.toString();
    }

    protected final ArrayList<VM> getVMs(int[] clientNums, int[] serverNums) {
        return this.getVMs(clientNums, serverNums, false);
    }

    protected final ArrayList<VM> getVMs(int[] clientNums, int[] serverNums, boolean skipNonExisting) {
        ArrayList<VM> vms = new ArrayList<VM>();
        if (clientNums != null) {
            int numClients = this.clientVMs.size();
            for (int clientNum : clientNums) {
                if (skipNonExisting && clientNum > numClients) continue;
                DistributedSQLTestBase.assertTrue((String)("Client number should be positive and not exceed total number of clients: " + this.clientVMs.size()), (clientNum > 0 && clientNum <= numClients ? 1 : 0) != 0);
                vms.add(this.clientVMs.get(clientNum - 1));
            }
        }
        if (serverNums != null) {
            int numServers = this.serverVMs.size();
            for (int serverNum : serverNums) {
                if (skipNonExisting && serverNum > numServers) continue;
                DistributedSQLTestBase.assertTrue((String)("Server number should be positive and not exceed total number of servers: " + this.serverVMs.size()), (serverNum > 0 && serverNum <= numServers ? 1 : 0) != 0);
                vms.add(this.serverVMs.get(serverNum - 1));
            }
        }
        return vms;
    }

    private String regionAttributesToXML(RegionAttributes<?, ?> attrs, VM vmForDiskDir) {
        return TestUtil.regionAttributesToXML(attrs);
    }

    public static String getSysDiskDir() {
        try {
            return DistributedSQLTestBase.getSysDirName();
        }
        catch (Exception ex) {
            throw new TestException("unexpected exception", (Throwable)ex);
        }
    }

    public String getTestLogPrefix() {
        String sysDirName = DistributedSQLTestBase.getSysDirName();
        String testName = this.getTestLogNamePrefix();
        return sysDirName + '/' + testName;
    }

    public String getTestLogNamePrefix() {
        return this.getTestClass().getName() + "-" + DistributedSQLTestBase.getTestName();
    }

    protected void checkFKViolation(int vmNum, String sql) throws Exception {
        this.checkKeyViolation(vmNum, sql, "23503", "foreign key violation");
    }

    protected void checkKeyViolation(int vmNum, String sql) throws Exception {
        this.checkKeyViolation(vmNum, sql, "23505", "primary or unique key violation");
    }

    protected void checkKeyViolation(int vmNum, String sql, String expectedState, String violationString) throws Exception {
        try {
            if (vmNum < 0) {
                this.serverSQLExecute(-vmNum, sql);
            } else {
                this.clientSQLExecute(vmNum, sql);
            }
            DistributedSQLTestBase.fail((String)("should have got a " + violationString + " exception for SQL: " + sql));
        }
        catch (SQLException ex) {
            if (!expectedState.equals(ex.getSQLState())) {
                throw ex;
            }
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                SQLException sqlEx = (SQLException)ex.getCause();
                if (!expectedState.equals(sqlEx.getSQLState())) {
                    throw ex;
                }
            }
            throw ex;
        }
    }

    public VM getHostVMForMember(DistributedMember member) {
        return this.members.get(member);
    }

    public DistributedMember getMemberForVM(VM vm) {
        for (Map.Entry<DistributedMember, VM> entry : this.members.entrySet()) {
            if (vm != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean getQueryStatus() {
        try {
            DistributedSQLTestBase.getGlobalLogger().info((Object)("Getting query status for this VM: " + isQueryExecutedOnNode));
            Boolean bl = isQueryExecutedOnNode;
            return bl;
        }
        finally {
            isQueryExecutedOnNode = false;
        }
    }

    protected void checkQueryExecution(boolean oneOf, VM ... vms) {
        SerializableRunnable checkNoQuery = new SerializableRunnable("check for no query execution"){

            public void run() throws CacheException {
                DistributedSQLTestBase.this.getLogWriter().info((Object)"Checking for no execution of query on this VM");
                TestCase.assertFalse((String)("expected query to not execute on this VM " + Misc.getGemFireCache().getMyId()), (boolean)isQueryExecutedOnNode);
            }
        };
        HashSet<VM> allServers = new HashSet<VM>(this.serverVMs);
        Boolean res = Boolean.FALSE;
        for (VM vm : vms) {
            Boolean tres = vm == null ? DistributedSQLTestBase.getQueryStatus() : (Boolean)vm.invoke(DistributedSQLTestBase.class, "getQueryStatus");
            if (oneOf) {
                if (res.booleanValue()) {
                    DistributedSQLTestBase.assertFalse((String)("did not expect query to execute on this VM: " + vm), (boolean)tres);
                } else {
                    res = tres;
                }
            } else {
                DistributedSQLTestBase.assertTrue((String)("expected query to execute on this VM: " + vm), (boolean)tres);
            }
            if (!tres.booleanValue()) continue;
            allServers.remove(vm);
        }
        if (oneOf) {
            DistributedSQLTestBase.assertTrue((String)"expected query to execute on exactly one VM", (boolean)res);
        }
        for (VM vm : allServers) {
            vm.invoke((Runnable)checkNoQuery);
        }
        checkNoQuery.run();
    }

    protected void setupObservers(VM[] dataStores, final SelectQueryInfo[] sqi) {
        isQueryExecutedOnNode = false;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qi, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                sqi[0] = (SelectQueryInfo)qi;
            }
        });
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver on DataStore Node"){

            public void run() throws CacheException {
                try {
                    isQueryExecutedOnNode = false;
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                            DistributedSQLTestBase.this.getLogWriter().info((Object)("Invoked DistributedSQLTestBase query observer for prepared statement query: " + query));
                            if (query == null && pstmt.getGPS() != null) {
                                query = pstmt.getGPS().getSource();
                            }
                            if (query == null || !query.contains("SYS.MEMORYANALYTICS") && !query.contains("SYS.MEMBERS")) {
                                isQueryExecutedOnNode = true;
                            }
                        }

                        public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                            DistributedSQLTestBase.this.getLogWriter().info((Object)("Invoked DistributedSQLTestBase query observer for statement query: " + query));
                            if (query == null || !query.contains("SYS.MEMORYANALYTICS") && !query.contains("SYS.MEMBERS")) {
                                isQueryExecutedOnNode = true;
                            }
                        }

                        public String toString() {
                            return "DistributedSQLTestBase query observer";
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        for (VM dataStore : dataStores) {
            if (dataStore == null) {
                setObserver.run();
                continue;
            }
            dataStore.invoke((Runnable)setObserver);
        }
    }

    protected void verifyQueryExecution(SelectQueryInfo sqi, Set<DistributedMember> prunedNodes, Set<DistributedMember> noQuerynodes, int noOfPrunedNodes, int noOfNoExecQueryNodes) {
        VM nodeVM;
        SerializableRunnable validateQueryExecution = new SerializableRunnable("validate node has executed the query"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertTrue((boolean)isQueryExecutedOnNode);
                    isQueryExecutedOnNode = false;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        SerializableRunnable validateNoQueryExecution = new SerializableRunnable("validate node has NOT executed the query"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertFalse((boolean)isQueryExecutedOnNode);
                    isQueryExecutedOnNode = false;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        this.getLogWriter().info((Object)(" Non Query nodes size= " + noQuerynodes.size()));
        Iterator<DistributedMember> itr2 = noQuerynodes.iterator();
        while (itr2.hasNext()) {
            this.getLogWriter().info((Object)(" Non Query member = " + itr2.next()));
        }
        this.getLogWriter().info((Object)("Number of members found after prunning =" + prunedNodes.size()));
        Iterator<DistributedMember> itr1 = prunedNodes.iterator();
        while (itr1.hasNext()) {
            this.getLogWriter().info((Object)("Prunned member=" + itr1.next()));
        }
        DistributedSQLTestBase.assertEquals((int)noOfPrunedNodes, (int)prunedNodes.size());
        DistributedSQLTestBase.assertEquals((int)noOfNoExecQueryNodes, (int)noQuerynodes.size());
        for (DistributedMember member : noQuerynodes) {
            nodeVM = this.getHostVMForMember(member);
            DistributedSQLTestBase.assertNotNull((Object)nodeVM);
            nodeVM.invoke((Runnable)validateNoQueryExecution);
        }
        for (DistributedMember member : prunedNodes) {
            nodeVM = this.getHostVMForMember(member);
            DistributedSQLTestBase.assertNotNull((Object)nodeVM);
            nodeVM.invoke((Runnable)validateQueryExecution);
        }
    }

    protected void derbyCleanup(Statement derbyStmt, Connection derbyConn, NetworkServerControl server) throws Exception {
        block11: {
            if (derbyConn == null) {
                return;
            }
            if (derbyStmt == null) {
                derbyStmt = derbyConn.createStatement();
            }
            derbyStmt.execute("drop procedure validateTestEnd ");
            derbyConn.commit();
            for (int tries = 1; tries <= 5; ++tries) {
                try {
                    derbyStmt.execute("drop trigger test_ok");
                    break;
                }
                catch (SQLException sqle) {
                    if (!sqle.getSQLState().startsWith("40XL")) {
                        throw sqle;
                    }
                    System.gc();
                    continue;
                }
            }
            derbyConn.commit();
            derbyConn.close();
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"TESTTABLE"}, derbyConn);
            this.addExpectedDerbyException(ShutdownException.class.getName());
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block11;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        if (server != null) {
            try {
                server.shutdown();
            }
            catch (Exception ex) {
                this.getLogWriter().error((Object)"unexpected exception", (Throwable)ex);
            }
        }
    }

    protected void cleanDerbyArtifacts(Statement derbyStmt, String[] derbyProcs, String[] derbyTriggers, String[] derbyTables, Connection conn) throws Exception {
        if (derbyStmt != null) {
            if (derbyProcs.length > 0) {
                this.addExpectedDerbyException("42Y55");
            }
            for (String derbyProc : derbyProcs) {
                try {
                    derbyStmt.execute("drop procedure " + derbyProc);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (derbyTriggers.length > 0) {
                this.addExpectedDerbyException("42X94");
            }
            for (String derbyTrigg : derbyTriggers) {
                try {
                    derbyStmt.execute("drop trigger " + derbyTrigg);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (String table : derbyTables) {
                try {
                    derbyStmt.execute("drop table " + table);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected final void addExpectedDerbyException(String exStr) {
        String expectedExStr = "<ExpectedException action=add>" + exStr + "</ExpectedException>";
        System.out.println(expectedExStr);
        SanityManager.GET_DEBUG_STREAM().println(expectedExStr);
        expectedDerbyExceptions.add(exStr);
    }

    protected final void validateResults(Statement derbyStmt, String validationQuery, int netPort, boolean ignoreTypeInfo) throws Exception {
        Statement stmt = TestUtil.getStatement();
        ResultSet derbyRS = derbyStmt.executeQuery(validationQuery);
        ResultSet gfxdRS = stmt.executeQuery(validationQuery);
        Element resultElement = Misc.resultSetToXMLElement((ResultSet)gfxdRS, (boolean)true, (boolean)ignoreTypeInfo);
        Element expectedElement = Misc.resultSetToXMLElement((ResultSet)derbyRS, (boolean)true, (boolean)ignoreTypeInfo);
        Map<String, Integer> resultMap = TestUtil.xmlElementToFrequencyMap(resultElement);
        Map<String, Integer> expectedResultMap = TestUtil.xmlElementToFrequencyMap(expectedElement);
        String resultStr = Misc.serializeXML((Element)resultElement);
        String expectedStr = Misc.serializeXML((Element)expectedElement);
        this.getLogWriter().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
        this.getLogWriter().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
        if (!TestUtil.compareFrequencyMaps(expectedResultMap, resultMap)) {
            this.getLogWriter().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
            this.getLogWriter().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
            DistributedSQLTestBase.fail((String)"Expected string in derby does not match the result from GemFireXD.");
        }
    }

    protected static SerializableRunnable getDiskStoreCreator(final String diskStore) {
        SerializableRunnable csr = new SerializableRunnable("diskstore creator"){

            public void run() throws CacheException {
                GemFireCacheImpl cache = Misc.getGemFireCache();
                if (cache.findDiskStore(diskStore) == null) {
                    String path = "." + fileSeparator + "test_dir";
                    File file = new File(path);
                    if (!file.mkdirs() && !file.isDirectory()) {
                        throw new DiskAccessException("Could not create directory for  default disk store : " + file.getAbsolutePath(), (Region)null);
                    }
                    try {
                        Connection conn = TestUtil.getConnection();
                        Statement stmt = conn.createStatement();
                        stmt.execute("Create DiskStore " + diskStore + " '" + path + "'");
                        conn.close();
                    }
                    catch (SQLException e) {
                        throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                    }
                }
            }
        };
        return csr;
    }

    public static void reset() {
        isQueryExecutedOnNode = false;
    }

    protected String[] testSpecificDirectoriesForDeletion() {
        return null;
    }

    protected boolean isDefaultOffHeapConfigured() {
        return this.configureDefaultOffHeap;
    }

    protected void verifyDeltaSizeFromStats(VM vm, final int expectedKeyNum, final int expectedTXIdNum, final int expectedDeltaGIINum, final String regionPath) {
        SerializableRunnable verify = new SerializableRunnable(){

            public void run() {
                LocalRegion lr = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)true, (boolean)false);
                LogWriter logger = lr.getLogWriterI18n().convertToLogWriter();
                CachePerfStats stats = lr.getRegionPerfStats();
                int size = stats.getGetInitialImageKeysReceived();
                logger.info("Delta contains: " + size + " keys");
                TestCase.assertEquals((int)expectedKeyNum, (int)size);
                size = stats.getGetInitialImageTransactionsReceived();
                logger.info("Delta contains: " + size + " TXIds");
                TestCase.assertEquals((int)expectedTXIdNum, (int)size);
                int num = stats.getDeltaGetInitialImagesCompleted();
                logger.info("Delta GII completed: " + num + " times");
                TestCase.assertEquals((int)expectedDeltaGIINum, (int)num);
            }
        };
        vm.invoke((Runnable)verify);
    }

    static {
        expectedDerbyExceptions = new ArrayList();
        fileSeparator = System.getProperty("file.separator").charAt(0);
        testInstance = null;
        addNewClientVM = new GetVM(){

            @Override
            public VM get(int index, int numCurrentVMs, Host host) {
                return host.getVM(Host.getHost((int)0).getVMCount() - index - numCurrentVMs);
            }

            @Override
            public boolean addVM() {
                return true;
            }

            @Override
            public String actionName() {
                return "Starting";
            }
        };
        addNewServerVM = new GetVM(){

            @Override
            public VM get(int index, int numCurrentVMs, Host host) {
                return host.getVM(index + numCurrentVMs);
            }

            @Override
            public boolean addVM() {
                return true;
            }

            @Override
            public String actionName() {
                return "Starting";
            }
        };
        numConnectionsOpened = new AtomicInteger(0);
        numConnectionsClosed = new AtomicInteger(0);
        connListener = new SerializableConnectionListener(){

            public void connectionOpened(Socket clientSocket, int connectionNumber) {
                numConnectionsOpened.incrementAndGet();
            }

            public void connectionClosed(Socket clientSocket, int connectionNumber) {
                numConnectionsClosed.incrementAndGet();
            }
        };
        isQueryExecutedOnNode = false;
    }

    static final class DoCleanupOnAll3
    extends SerializableRunnable {
        DoCleanupOnAll3() {
        }

        public void run() {
            try {
                GemFireCacheImpl cache;
                if (GemFireStore.getBootedInstance() != null && (cache = Misc.getGemFireCacheNoThrow()) != null && GemFireXDUtils.getMyVMKind().isAccessorOrStore()) {
                    Connection conn = TestUtil.getConnection();
                    Statement stmt = conn.createStatement();
                    for (GatewayReceiver receiver : cache.getGatewayReceivers()) {
                        DistributedSQLTestBase.executeCleanup(stmt, "drop gatewayreceiver \"" + receiver.getId() + '\"');
                    }
                    for (HDFSStoreImpl hdfsStore : cache.getAllHDFSStores()) {
                        DistributedSQLTestBase.executeCleanup(stmt, "drop hdfsstore \"" + hdfsStore.getName() + '\"');
                    }
                    for (DiskStoreImpl ds : cache.listDiskStores()) {
                        if ("GFXD-DEFAULT-DISKSTORE".equals(ds.getName()) || "GFXD-DD-DISKSTORE".equals(ds.getName())) continue;
                        DistributedSQLTestBase.executeCleanup(stmt, "drop diskstore \"" + ds.getName() + '\"');
                    }
                    if (GfxdSystemProcedures.GET_EVICTION_HEAP_PERCENTAGE() != 0.0f) {
                        DistributedSQLTestBase.executeCleanup(stmt, "call sys.set_eviction_heap_percentage_sg(0.0, NULL)");
                    }
                    if (GfxdSystemProcedures.GET_CRITICAL_HEAP_PERCENTAGE() != 0.0f) {
                        DistributedSQLTestBase.executeCleanup(stmt, "call sys.set_critical_heap_percentage_sg(0.0, NULL)");
                    }
                }
            }
            catch (Exception ex) {
                DistributedTestBase.getGlobalLogger().error((Object)"unexpected exception in cleanup", (Throwable)ex);
            }
        }
    }

    static final class DoCleanupOnAll2
    extends SerializableRunnable {
        DoCleanupOnAll2() {
        }

        public void run() {
            try {
                GemFireCacheImpl cache;
                if (GemFireStore.getBootedInstance() != null && (cache = Misc.getGemFireCacheNoThrow()) != null && GemFireXDUtils.getMyVMKind().isAccessorOrStore()) {
                    Connection conn = TestUtil.getConnection();
                    Statement stmt = conn.createStatement();
                    for (AsyncEventQueue queue : cache.getAsyncEventQueues()) {
                        DistributedSQLTestBase.executeCleanup(stmt, "drop asynceventlistener if exists \"" + queue.getId() + '\"');
                    }
                    for (GatewaySender sender : cache.getGatewaySenders()) {
                        DistributedSQLTestBase.executeCleanup(stmt, "drop gatewaysender if exists \"" + sender.getId() + '\"');
                    }
                }
            }
            catch (Exception ex) {
                DistributedTestBase.getGlobalLogger().error((Object)"unexpected exception in cleanup", (Throwable)ex);
            }
        }
    }

    static final class DoCleanupOnAll1
    extends SerializableRunnable {
        DoCleanupOnAll1() {
        }

        public void run() {
            try {
                GemFireStore store = GemFireStore.getBootedInstance();
                if (store != null && Misc.getGemFireCacheNoThrow() != null && GemFireXDUtils.getMyVMKind().isAccessorOrStore()) {
                    Connection conn = TestUtil.getConnection();
                    Statement stmt = conn.createStatement();
                    for (GemFireContainer c : store.getAllContainers()) {
                        LocalRegion r;
                        if (!c.isApplicationTable() || (r = c.getRegion()) == null) continue;
                        if (r.getCacheLoader() instanceof GfxdCacheLoader) {
                            DistributedSQLTestBase.executeCleanup(stmt, "call sys.remove_loader('" + c.getSchemaName() + "', '" + c.getTableName() + "')");
                        }
                        for (CacheListener l : r.getCacheListeners()) {
                            if (!(l instanceof GfxdCacheListener)) continue;
                            DistributedSQLTestBase.executeCleanup(stmt, "call sys.remove_listener('" + ((GfxdCacheListener)l).getName() + "', '" + c.getSchemaName() + "', '" + c.getTableName() + "')");
                        }
                        if (!(r.getCacheWriter() instanceof GfxdCacheWriter)) continue;
                        DistributedSQLTestBase.executeCleanup(stmt, "call sys.remove_writer('" + c.getSchemaName() + "', '" + c.getTableName() + "')");
                    }
                }
            }
            catch (Exception ex) {
                DistributedTestBase.getGlobalLogger().error((Object)"unexpected exception in cleanup", (Throwable)ex);
            }
        }
    }

    static final class DoPreCleanup
    extends SerializableCallable {
        DoPreCleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() {
            GemFireCacheImpl cache;
            ContextService cs;
            boolean[] requiresCleanup = new boolean[3];
            GemFireXDQueryObserverHolder.clearInstance();
            try {
                cs = ContextService.getFactory();
            }
            catch (Exception e) {
                cs = null;
            }
            if (cs != null) {
                ContextService e = cs;
                synchronized (e) {
                    ConcurrentHashSet contexts = cs.getAllContexts();
                    if (contexts != null) {
                        for (ContextManager cm : contexts) {
                            GemFireTransaction tran;
                            LanguageConnectionContext lcc;
                            try {
                                lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
                            }
                            catch (Exception e2) {
                                lcc = null;
                            }
                            if (lcc == null || (tran = (GemFireTransaction)lcc.getTransactionExecute()) == null) continue;
                            try {
                                tran.destroy();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            try {
                                tran.releaseAllLocks(true, true);
                            }
                            catch (Exception e2) {}
                        }
                    }
                }
            }
            TestUtil.addExpectedException(IllegalStateException.class.getName());
            GemFireStore store = GemFireStore.getBootedInstance();
            if (store != null && (cache = Misc.getGemFireCacheNoThrow()) != null && !cache.isClosed() && GemFireXDUtils.getMyVMKind().isAccessorOrStore()) {
                for (GemFireContainer c : store.getAllContainers()) {
                    LocalRegion r;
                    if (!c.isApplicationTable() || (r = c.getRegion()) == null) continue;
                    if (r.getCacheLoader() instanceof GfxdCacheLoader) {
                        requiresCleanup[0] = true;
                        break;
                    }
                    for (CacheListener l : r.getCacheListeners()) {
                        if (l instanceof GfxdCacheListener) {
                            requiresCleanup[0] = true;
                            break;
                        }
                        if (requiresCleanup[0]) break;
                    }
                    if (!(r.getCacheWriter() instanceof GfxdCacheWriter)) continue;
                    requiresCleanup[0] = true;
                    break;
                }
                boolean bl = requiresCleanup[1] = cache.getAllGatewaySenders().size() > 0;
                if (cache.getGatewayReceivers().size() > 0) {
                    requiresCleanup[2] = true;
                } else {
                    for (DiskStoreImpl ds : cache.listDiskStores()) {
                        if ("GFXD-DEFAULT-DISKSTORE".equals(ds.getName()) || "GFXD-DD-DISKSTORE".equals(ds.getName())) continue;
                        requiresCleanup[2] = true;
                        break;
                    }
                    if (!requiresCleanup[2]) {
                        if (GfxdSystemProcedures.GET_EVICTION_HEAP_PERCENTAGE() != 0.0f) {
                            requiresCleanup[2] = true;
                        }
                        if (GfxdSystemProcedures.GET_CRITICAL_HEAP_PERCENTAGE() != 0.0f) {
                            requiresCleanup[2] = true;
                        }
                    }
                }
            }
            return requiresCleanup;
        }
    }

    static final class DoCleanup
    extends SerializableCallable {
        DoCleanup() {
        }

        public Object call() {
            try {
                GemFireStore store = GemFireStore.getBootedInstance();
                if (store != null && Misc.getGemFireCacheNoThrow() != null && GemFireXDUtils.getMyVMKind().isAccessorOrStore()) {
                    Connection conn = TestUtil.getConnection();
                    Statement stmt = conn.createStatement();
                    GfxdJarResource fr = store.getJarFileHandler();
                    if (fr != null) {
                        for (String jarName : fr.getNameToIDMap().keySet()) {
                            DistributedSQLTestBase.executeCleanup(stmt, "call sqlj.remove_jar('" + jarName + "', 0)");
                        }
                    }
                    CleanDatabaseTestSetup.cleanDatabase(conn, false);
                    return Boolean.TRUE;
                }
            }
            catch (Exception ex) {
                DistributedTestBase.getGlobalLogger().error((Object)"unexpected exception in cleanup", (Throwable)ex);
            }
            return Boolean.FALSE;
        }
    }

    protected static abstract class SerializableConnectionListener
    implements NetworkInterface.ConnectionListener,
    Serializable {
        protected SerializableConnectionListener() {
        }

        public void close() {
        }
    }

    public static final class SetLoggingLevel
    extends SerializableRunnable {
        private final String level;

        public SetLoggingLevel(String level) {
            this.level = level;
        }

        public void run() {
            TestUtil.reduceLogLevel(this.level);
        }
    }

    protected static final class AsyncVM {
        private final AsyncInvocation async;
        private final VM vm;

        private AsyncVM(AsyncInvocation async, VM vm) {
            this.async = async;
            this.vm = vm;
        }

        public final AsyncInvocation getInvocation() {
            return this.async;
        }

        public final VM getVM() {
            return this.vm;
        }
    }

    private static interface GetVM {
        public VM get(int var1, int var2, Host var3);

        public boolean addVM();

        public String actionName();
    }
}

