/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.internal.engine.store.offheap.CollectionBasedOHAddressCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;

public abstract class CollectionBasedOHAddressCacheTestBase
extends TestCase {
    protected abstract CollectionBasedOHAddressCache createOHAddressCacheInstance();

    private GemFireCacheImpl createCache() {
        Properties props = new Properties();
        props.setProperty("locators", "");
        props.setProperty("mcast-port", "0");
        props.setProperty("off-heap-memory-size", "500m");
        GemFireCacheImpl result = (GemFireCacheImpl)new CacheFactory(props).create();
        return result;
    }

    private void closeCache(GemFireCacheImpl gfc) {
        gfc.close();
    }

    private SimpleMemoryAllocatorImpl getAllocator() {
        return SimpleMemoryAllocatorImpl.getAllocator();
    }

    private OffHeapMemoryStats getStats() {
        return this.getAllocator().getStats();
    }

    private long allocateSmallObject() {
        SimpleMemoryAllocatorImpl.Chunk mc = (SimpleMemoryAllocatorImpl.Chunk)this.getAllocator().allocate(8, null);
        return mc.getMemoryAddress();
    }

    public void testEmptyCache() {
        CollectionBasedOHAddressCache c = this.createOHAddressCacheInstance();
        try {
            c.releaseByteSource(0);
            CollectionBasedOHAddressCacheTestBase.fail((String)"expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        CollectionBasedOHAddressCacheTestBase.assertEquals((int)0, (int)c.testHook_getSize());
        CollectionBasedOHAddressCacheTestBase.assertEquals(Collections.emptyList(), (Object)c.testHook_copyToList());
        c.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleAddRelease() {
        GemFireCacheImpl gfc = this.createCache();
        try {
            int startOHObjects = this.getStats().getObjects();
            CollectionBasedOHAddressCache c = this.createOHAddressCacheInstance();
            try {
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
                long addr = this.allocateSmallObject();
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)(startOHObjects + 1), (int)this.getStats().getObjects());
                c.put(addr);
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)1, (int)c.testHook_getSize());
                ArrayList<Long> expected = new ArrayList<Long>(2);
                expected.add(0, addr);
                long addr2 = this.allocateSmallObject();
                c.put(addr2);
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)2, (int)c.testHook_getSize());
                expected.add(0, addr2);
                CollectionBasedOHAddressCacheTestBase.assertEquals(expected, (Object)c.testHook_copyToList());
            }
            finally {
                c.release();
            }
            CollectionBasedOHAddressCacheTestBase.assertEquals((int)0, (int)c.testHook_getSize());
            CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
        }
        finally {
            this.closeCache(gfc);
            SimpleMemoryAllocatorImpl.freeOffHeapMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkAddRelease() {
        GemFireCacheImpl gfc = this.createCache();
        int BULK_SIZE = 16384;
        try {
            int startOHObjects = this.getStats().getObjects();
            CollectionBasedOHAddressCache c = this.createOHAddressCacheInstance();
            try {
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
                for (int i = 0; i < 16384; ++i) {
                    c.put(this.allocateSmallObject());
                    CollectionBasedOHAddressCacheTestBase.assertEquals((int)(i + 1), (int)c.testHook_getSize());
                }
            }
            finally {
                c.release();
            }
            CollectionBasedOHAddressCacheTestBase.assertEquals((int)0, (int)c.testHook_getSize());
            CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
        }
        finally {
            this.closeCache(gfc);
            SimpleMemoryAllocatorImpl.freeOffHeapMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseIdx0() {
        GemFireCacheImpl gfc = this.createCache();
        int BULK_SIZE = 16384;
        try {
            int startOHObjects = this.getStats().getObjects();
            CollectionBasedOHAddressCache c = this.createOHAddressCacheInstance();
            try {
                int i;
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
                ArrayList<Long> expected = new ArrayList<Long>(16384);
                for (i = 0; i < 16384; ++i) {
                    long addr = this.allocateSmallObject();
                    c.put(addr);
                    expected.add(0, addr);
                    CollectionBasedOHAddressCacheTestBase.assertEquals((int)(i + 1), (int)c.testHook_getSize());
                    CollectionBasedOHAddressCacheTestBase.assertEquals(expected, (Object)c.testHook_copyToList());
                }
                for (i = 0; i < 16384; ++i) {
                    c.releaseByteSource(0);
                    expected.remove(0);
                    CollectionBasedOHAddressCacheTestBase.assertEquals((int)(16383 - i), (int)c.testHook_getSize());
                    CollectionBasedOHAddressCacheTestBase.assertEquals(expected, (Object)c.testHook_copyToList());
                }
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
            }
            finally {
                c.release();
            }
        }
        finally {
            this.closeCache(gfc);
            SimpleMemoryAllocatorImpl.freeOffHeapMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseIdxEnd() {
        GemFireCacheImpl gfc = this.createCache();
        int BULK_SIZE = 16384;
        try {
            int startOHObjects = this.getStats().getObjects();
            CollectionBasedOHAddressCache c = this.createOHAddressCacheInstance();
            try {
                int i;
                ArrayList<Long> expected = new ArrayList<Long>(16384);
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
                for (i = 0; i < 16384; ++i) {
                    long addr = this.allocateSmallObject();
                    c.put(addr);
                    expected.add(0, addr);
                    CollectionBasedOHAddressCacheTestBase.assertEquals((int)(i + 1), (int)c.testHook_getSize());
                }
                for (i = 16383; i >= 0; --i) {
                    c.releaseByteSource(i);
                    expected.remove(i);
                    CollectionBasedOHAddressCacheTestBase.assertEquals((int)i, (int)c.testHook_getSize());
                    CollectionBasedOHAddressCacheTestBase.assertEquals(expected, (Object)c.testHook_copyToList());
                }
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
            }
            finally {
                c.release();
            }
        }
        finally {
            this.closeCache(gfc);
            SimpleMemoryAllocatorImpl.freeOffHeapMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseIdxRandom() {
        GemFireCacheImpl gfc = this.createCache();
        int BULK_SIZE = 16384;
        try {
            int startOHObjects = this.getStats().getObjects();
            CollectionBasedOHAddressCache c = this.createOHAddressCacheInstance();
            try {
                ArrayList<Long> expected = new ArrayList<Long>(16384);
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
                for (int i = 0; i < 16384; ++i) {
                    long addr = this.allocateSmallObject();
                    c.put(addr);
                    expected.add(0, addr);
                    CollectionBasedOHAddressCacheTestBase.assertEquals((int)(i + 1), (int)c.testHook_getSize());
                }
                Random rand = new Random();
                for (int i = 16383; i >= 0; --i) {
                    int releaseIdx = rand.nextInt(i + 1);
                    c.releaseByteSource(releaseIdx);
                    expected.remove(releaseIdx);
                    CollectionBasedOHAddressCacheTestBase.assertEquals((int)i, (int)c.testHook_getSize());
                    CollectionBasedOHAddressCacheTestBase.assertEquals(expected, (Object)c.testHook_copyToList());
                }
                CollectionBasedOHAddressCacheTestBase.assertEquals((int)startOHObjects, (int)this.getStats().getObjects());
            }
            finally {
                c.release();
            }
        }
        finally {
            this.closeCache(gfc);
            SimpleMemoryAllocatorImpl.freeOffHeapMemory();
        }
    }
}

