/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.client.am.DisconnectException;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.io.File;
import java.io.FileOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.JDBC;

public class ClientServerDUnit
extends DistributedSQLTestBase {
    private static volatile HashMap<String, ArrayList<Integer>> batchExecutions = new HashMap();
    private static volatile boolean hasQueryObservers = false;
    private static volatile int preparedExec = 0;
    private static volatile int unpreparedExec = 0;

    public ClientServerDUnit(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        File dir = new File("datadictionary");
        boolean result = TestUtil.deleteDir(dir);
        TestUtil.getLogger().info((Object)("For Test: " + ClientServerDUnit.getClassName() + ":" + ClientServerDUnit.getTestName() + " found and deleted stray datadictionarydir at: " + dir.toString() + " : " + result));
    }

    private RegionAttributesCreation getServerTestTableProperties() {
        RegionAttributesCreation serverAttrs = new RegionAttributesCreation();
        serverAttrs.setDataPolicy(DataPolicy.PARTITION);
        serverAttrs.setConcurrencyChecksEnabled(false);
        PartitionAttributes pa = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
        serverAttrs.setPartitionAttributes(pa);
        serverAttrs.setInitialCapacity(10000);
        serverAttrs.setAllHasFields(true);
        serverAttrs.setHasScope(false);
        serverAttrs.setHasDiskDirs(false);
        serverAttrs.setHasDiskWriteAttributes(false);
        return serverAttrs;
    }

    private RegionAttributesCreation[] checkTestTableProperties(String schemaName) throws Exception {
        return this.checkTestTableProperties(schemaName, false);
    }

    private RegionAttributesCreation[] checkTestTableProperties(String schemaName, boolean isDataStore) throws Exception {
        RegionAttributesCreation serverAttrs = this.getServerTestTableProperties();
        if (schemaName == null) {
            schemaName = "APP";
        }
        this.serverVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)serverAttrs);
        this.serverVerifyRegionProperties(2, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)serverAttrs);
        RegionAttributesCreation clientAttrs = new RegionAttributesCreation((RegionAttributes)serverAttrs, false);
        PartitionAttributes pa = isDataStore ? new PartitionAttributesFactory(clientAttrs.getPartitionAttributes()).create() : new PartitionAttributesFactory(clientAttrs.getPartitionAttributes()).setLocalMaxMemory(0).create();
        clientAttrs.setPartitionAttributes(pa);
        TestUtil.verifyRegionProperties(schemaName, "TESTTABLE", TestUtil.regionAttributesToXML(clientAttrs));
        return new RegionAttributesCreation[]{serverAttrs, clientAttrs};
    }

    private void checkVMsDown(VM ... vms) {
        SerializableRunnable noGFE = new SerializableRunnable("GFE down"){

            public void run() throws CacheException {
                try {
                    CacheFactory.getAnyInstance();
                    TestCase.fail((String)"expected the cache to be closed");
                }
                catch (CacheClosedException cacheClosedException) {
                    // empty catch block
                }
                InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
                TestCase.assertNull((String)"expected the distributed system to be down", (Object)sys);
            }
        };
        for (VM vm : vms) {
            if (vm == null) {
                noGFE.run();
                continue;
            }
            vm.invoke((Runnable)noGFE);
        }
    }

    private void checkDBMetadata(Connection conn, String url) throws SQLException {
        this.checkDBMetadata(conn, url, null);
    }

    private void checkDBMetadata(Connection conn, String url, String url2) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        String actualUrl = dbmd.getURL();
        this.getLogWriter().info((Object)("Got DB " + dbmd.getDatabaseProductName() + ' ' + dbmd.getDatabaseProductVersion() + " using URL " + actualUrl));
        url = url.replaceFirst("/$", "");
        actualUrl = actualUrl.replaceFirst("/$", "");
        if (!(url.equals(actualUrl) || url2 != null && url2.replaceFirst("/$", "").equals(actualUrl))) {
            ClientServerDUnit.assertEquals((String)"Expected the provided URL to match", (String)url, (String)actualUrl);
        }
        ResultSet rs = dbmd.getCatalogs();
        while (rs.next()) {
            this.getLogWriter().info((Object)("Got DB catalog: " + rs.getString(1)));
        }
        rs.close();
        rs = dbmd.getSchemas();
        while (rs.next()) {
            this.getLogWriter().info((Object)("Got DB schema: " + rs.getString(1) + " in catalog=" + rs.getString(2)));
        }
        rs.close();
        rs = dbmd.getProcedures(null, null, null);
        while (rs.next()) {
            this.getLogWriter().info((Object)("Got Procedure " + rs.getString(3) + " in catalog=" + rs.getString(1) + ", schema=" + rs.getString(2)));
        }
        rs.close();
        ClientServerDUnit.assertTrue((boolean)dbmd.othersInsertsAreVisible(1003));
        ClientServerDUnit.assertTrue((boolean)dbmd.othersDeletesAreVisible(1003));
    }

    public void testDefaultClient() throws Exception {
        TestUtil.deletePersistentFiles = true;
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, null, null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, null, null);
        TestUtil.loadDriver();
        Properties props = new Properties();
        super.setCommonProperties(props, 0, null, null);
        Connection conn = null;
        props.setProperty("host-data", "false");
        conn = DriverManager.getConnection(TestUtil.getProtocol(), props);
        this.joinVMs(true, async1, async2);
        Statement stmt = conn.createStatement();
        this.checkDBMetadata(conn, TestUtil.getProtocol());
        stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        this.checkTestTableProperties(null);
        TestUtil.shutDown();
        TestUtil.loadDriver();
        props = new Properties();
        super.setCommonProperties(props, 0, null, null);
        props.setProperty("host-data", "false");
        conn = DriverManager.getConnection(TestUtil.getProtocol(), props);
        stmt = conn.createStatement();
        stmt.execute("drop table TESTTABLE");
        stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        this.checkTestTableProperties(null);
        TestUtil.shutDown();
        TestUtil.loadDriver();
        props = new Properties();
        super.setCommonProperties(props, 0, null, null);
        conn = DriverManager.getConnection(TestUtil.getProtocol(), props);
        stmt = conn.createStatement();
        stmt.execute("drop table TESTTABLE");
        stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        this.checkTestTableProperties(null, true);
    }

    public void testNondefaultClient() throws Exception {
        Properties props = new Properties();
        props.setProperty("host-data", "false");
        this.setCommonProperties(props, 0, null, null);
        TestUtil.loadDriver();
        TestUtil.setupConnection(props);
        this.startServerVMs(1, 0, null);
        TestUtil.sqlExecute("create schema EMP", Boolean.TRUE);
        RegionAttributesCreation expectedSchemaAttrs = new RegionAttributesCreation();
        expectedSchemaAttrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        expectedSchemaAttrs.setDataPolicy(DataPolicy.EMPTY);
        expectedSchemaAttrs.setConcurrencyChecksEnabled(false);
        expectedSchemaAttrs.setAllHasFields(true);
        expectedSchemaAttrs.setHasDiskDirs(false);
        expectedSchemaAttrs.setHasDiskWriteAttributes(false);
        TestUtil.verifyRegionProperties("EMP", null, TestUtil.regionAttributesToXML(expectedSchemaAttrs));
        this.serverVerifyRegionProperties(1, "EMP", null, (RegionAttributes<?, ?>)expectedSchemaAttrs);
        TestUtil.sqlExecute("create table EMP.TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null primary key)", Boolean.TRUE);
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        PartitionAttributes pa = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
        expectedAttrs.setPartitionAttributes(pa);
        expectedAttrs.setInitialCapacity(10000);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        this.serverVerifyRegionProperties(1, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        this.startServerVMs(1, 0, null);
        this.serverVerifyRegionProperties(2, "EMP", null, (RegionAttributes<?, ?>)expectedSchemaAttrs);
        this.serverVerifyRegionProperties(2, "EMP", "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs);
        pa = new PartitionAttributesFactory(expectedAttrs.getPartitionAttributes()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pa);
        TestUtil.verifyRegionProperties("EMP", "TESTTABLE", TestUtil.regionAttributesToXML(expectedAttrs));
        Connection conn = TestUtil.jdbcConn;
        PreparedStatement pstmt = conn.prepareStatement("insert into EMP.TESTTABLE values(?,?)");
        String s = "test\u0905";
        pstmt.setInt(1, 1);
        pstmt.setString(2, "test\u0905");
        pstmt.execute();
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        ResultSet rs = conn.createStatement().executeQuery("select * from EMP.TESTTABLE");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        String resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
    }

    public void testURLGemfireProperties() throws Exception {
        TestUtil.deletePersistentFiles = true;
        TestUtil.loadDriver();
        Connection conn = DriverManager.getConnection(TestUtil.getProtocol() + ";mcast-port=0;host-data=true;locators=" + this.getLocatorString());
        InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
        Properties sysProps = sys.getProperties();
        ClientServerDUnit.assertEquals((String)"Expected mcast-port to be 0", (String)"0", (String)sysProps.getProperty("mcast-port"));
        ClientServerDUnit.assertEquals((String)"Unexpected value for locators", (String)this.getLocatorString().replace('@', ':'), (String)sysProps.getProperty("locators"));
        ClientServerDUnit.assertTrue((String)"Expected host-data to be true", (boolean)ServerGroupUtils.isDataStore());
        Statement stmt = conn.createStatement();
        stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.REPLICATE);
        expectedAttrs.setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setInitialCapacity(10000);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        TestUtil.verifyRegionProperties("APP", "TESTTABLE", TestUtil.regionAttributesToXML(expectedAttrs));
        stmt.execute("drop table TESTTABLE");
    }

    public void testConnGemfireProperties() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", this.getLocatorString());
        TestUtil.deletePersistentFiles = true;
        TestUtil.loadDriver();
        Connection conn = DriverManager.getConnection(TestUtil.getProtocol(), props);
        InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
        Properties sysProps = sys.getProperties();
        ClientServerDUnit.assertEquals((String)"Expected mcast-port to be 0", (String)"0", (String)sysProps.getProperty("mcast-port"));
        ClientServerDUnit.assertEquals((String)"Unexpected value for locators", (String)this.getLocatorString().replace('@', ':'), (String)sysProps.getProperty("locators"));
        ClientServerDUnit.assertTrue((String)"Expected host-data to be true", (boolean)ServerGroupUtils.isDataStore());
        Statement stmt = conn.createStatement();
        stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.REPLICATE);
        expectedAttrs.setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setInitialCapacity(10000);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        TestUtil.verifyRegionProperties("APP", "TESTTABLE", TestUtil.regionAttributesToXML(expectedAttrs));
        stmt.execute("drop table TESTTABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNetworkClient() throws Exception {
        Statement stmt;
        Connection conn;
        VM serverVM;
        block62: {
            int id;
            CallableStatement cstmt;
            ResultSet rs;
            int[] results;
            block61: {
                GemFireXDQueryObserverAdapter queryExec;
                GemFireXDQueryObserverAdapter batchExec;
                Connection conn2;
                block60: {
                    PreparedStatement pstmt;
                    block58: {
                        GemFireXDQueryObserverAdapter errorGen;
                        block57: {
                            block56: {
                                int id2;
                                block55: {
                                    SerializableRunnable checkAttrs;
                                    String expectedUrl;
                                    String url;
                                    InetAddress localHost;
                                    Properties connProps;
                                    int netPort;
                                    block54: {
                                        int id3;
                                        int id4;
                                        block53: {
                                            block52: {
                                                this.startVMs(0, 2);
                                                netPort = this.startNetworkServer(1, null, null);
                                                int netPort2 = this.startNetworkServer(2, null, null);
                                                serverVM = (VM)this.serverVMs.get(0);
                                                TestUtil.loadNetDriver();
                                                TestUtil.deletePersistentFiles = true;
                                                connProps = new Properties();
                                                connProps.setProperty("load-balance", "false");
                                                localHost = SocketCreator.getLocalHost();
                                                url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
                                                conn = DriverManager.getConnection(url, connProps);
                                                conn2 = DriverManager.getConnection(TestUtil.getNetProtocol(localHost.getHostName(), netPort2), connProps);
                                                expectedUrl = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
                                                this.checkDBMetadata(conn, expectedUrl);
                                                stmt = conn.createStatement();
                                                stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
                                                int numOps = 20;
                                                String schemaName = "APP";
                                                batchExec = new GemFireXDQueryObserverAdapter(){

                                                    public void beforeBatchQueryExecution(EmbedStatement stmt, int batchSize) throws SQLException {
                                                        ArrayList<Integer> executions = (ArrayList<Integer>)batchExecutions.get(stmt.getSQLText());
                                                        if (executions == null) {
                                                            executions = new ArrayList<Integer>();
                                                            batchExecutions.put(stmt.getSQLText(), executions);
                                                        }
                                                        executions.add(batchSize);
                                                    }
                                                };
                                                queryExec = new GemFireXDQueryObserverAdapter(){

                                                    public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) {
                                                        if (stmt.isPrepared()) {
                                                            preparedExec++;
                                                        } else if (sqle == null) {
                                                            unpreparedExec++;
                                                        }
                                                        return false;
                                                    }
                                                };
                                                String indexName = "INDEX10_TEST";
                                                errorGen = new GemFireXDQueryObserverAdapter(){
                                                    private Integer batchElement;

                                                    public void beforeBatchQueryExecution(EmbedStatement stmt, int batchSize) throws SQLException {
                                                        this.batchElement = null;
                                                        if (!stmt.getSQLText().startsWith("call SYSIBM.SQLCAMESSAGE") && !stmt.getSQLText().startsWith("SET ")) {
                                                            if (PartitionedRegion.rand.nextBoolean()) {
                                                                throw PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"X0Z02", (Throwable)new Throwable("simulating a conflict exception")));
                                                            }
                                                            this.batchElement = PartitionedRegion.rand.nextInt(15) + 1;
                                                        }
                                                    }

                                                    /*
                                                     * Enabled force condition propagation
                                                     * Lifted jumps to return sites
                                                     */
                                                    public void beforeQueryExecution(EmbedStatement stmt, Activation activation) throws SQLException {
                                                        if (stmt.getSQLText().startsWith("call SYSIBM.SQLCAMESSAGE") || stmt.getSQLText().startsWith("SET ")) return;
                                                        if (this.batchElement == null) throw PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"42X65", (Object)"INDEX10_TEST"));
                                                        if (this.batchElement <= 0) throw PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"X0Z02", (Throwable)new Throwable("simulating a conflict exception")));
                                                        4 var3_3 = this;
                                                        Integer n = var3_3.batchElement;
                                                        Integer n2 = var3_3.batchElement = Integer.valueOf(var3_3.batchElement - 1);
                                                    }
                                                };
                                                checkAttrs = new SerializableRunnable("check region attributes", (GemFireXDQueryObserver)batchExec, (GemFireXDQueryObserver)queryExec){
                                                    final /* synthetic */ GemFireXDQueryObserver val$batchExec;
                                                    final /* synthetic */ GemFireXDQueryObserver val$queryExec;
                                                    {
                                                        this.val$batchExec = gemFireXDQueryObserver;
                                                        this.val$queryExec = gemFireXDQueryObserver2;
                                                        super(x0);
                                                    }

                                                    public void run() {
                                                        RegionAttributesCreation attrs = ClientServerDUnit.this.getServerTestTableProperties();
                                                        TestUtil.verifyRegionProperties("APP", "TESTTABLE", TestUtil.regionAttributesToXML(attrs));
                                                        if (hasQueryObservers) {
                                                            preparedExec = 0;
                                                            unpreparedExec = 0;
                                                        } else {
                                                            GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.val$batchExec);
                                                            GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.val$queryExec);
                                                            hasQueryObservers = true;
                                                        }
                                                    }
                                                };
                                                serverVM.invoke((Runnable)checkAttrs);
                                                pstmt = conn.prepareStatement("insert into testtable values(?, ?)");
                                                for (int id5 = 1; id5 <= 20; ++id5) {
                                                    pstmt.setInt(1, id5);
                                                    pstmt.setString(2, "test" + id5);
                                                    pstmt.addBatch();
                                                }
                                                results = pstmt.executeBatch();
                                                ClientServerDUnit.assertEquals((int)20, (int)results.length);
                                                for (int res : results) {
                                                    ClientServerDUnit.assertEquals((int)1, (int)res);
                                                }
                                                serverVM.invoke((Runnable)new SerializableRunnable(){

                                                    public void run() {
                                                        TestCase.assertEquals((int)1, (int)batchExecutions.size());
                                                        ArrayList batchExecs = (ArrayList)batchExecutions.get("insert into testtable values(?, ?)");
                                                        TestCase.assertNotNull((Object)batchExecs);
                                                        TestCase.assertEquals((int)1, (int)batchExecs.size());
                                                        TestCase.assertEquals((int)20, (int)((Integer)batchExecs.get(0)));
                                                        batchExecutions.clear();
                                                        TestCase.assertEquals((int)20, (int)preparedExec);
                                                        TestCase.assertEquals((int)0, (int)unpreparedExec);
                                                        preparedExec = 0;
                                                    }
                                                });
                                                try {
                                                    rs = stmt.executeQuery("select * from testtab order by id");
                                                    ClientServerDUnit.fail((String)"expected exception for non-existent table");
                                                }
                                                catch (SQLException sqle) {
                                                    if ("42X05".equals(sqle.getSQLState())) break block52;
                                                    throw sqle;
                                                }
                                            }
                                            try {
                                                rs = stmt.executeQuery("select * from testtable order by id2");
                                                ClientServerDUnit.fail((String)"expected exception for non-existent table");
                                            }
                                            catch (SQLException sqle) {
                                                if ("42X04".equals(sqle.getSQLState())) break block53;
                                                throw sqle;
                                            }
                                        }
                                        serverVM.invoke((Runnable)new SerializableRunnable(){

                                            public void run() {
                                                if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                                                    TestCase.assertEquals((int)0, (int)preparedExec);
                                                } else {
                                                    TestCase.assertEquals((int)2, (int)preparedExec);
                                                }
                                                TestCase.assertEquals((int)0, (int)unpreparedExec);
                                                preparedExec = 0;
                                            }
                                        });
                                        rs = stmt.executeQuery("select * from testtable order by id");
                                        for (id4 = 1; id4 <= 20; ++id4) {
                                            ClientServerDUnit.assertTrue((boolean)rs.next());
                                            ClientServerDUnit.assertEquals((int)id4, (int)rs.getInt(1));
                                            ClientServerDUnit.assertEquals((String)("test" + id4), (String)rs.getString(2));
                                        }
                                        ClientServerDUnit.assertFalse((boolean)rs.next());
                                        serverVM.invoke((Runnable)new SerializableRunnable(){

                                            public void run() {
                                                TestCase.assertEquals((int)0, (int)preparedExec);
                                                TestCase.assertEquals((int)2, (int)unpreparedExec);
                                                unpreparedExec = 0;
                                            }
                                        });
                                        for (id4 = 1; id4 <= 20; ++id4) {
                                            stmt.addBatch("update testtable set description='newtest" + id4 + "' where id=" + id4);
                                        }
                                        results = stmt.executeBatch();
                                        ClientServerDUnit.assertEquals((int)20, (int)results.length);
                                        for (int res : results) {
                                            ClientServerDUnit.assertEquals((int)1, (int)res);
                                        }
                                        serverVM.invoke((Runnable)new SerializableRunnable(){

                                            public void run() {
                                                if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                                                    TestCase.assertEquals((int)1, (int)batchExecutions.size());
                                                    ArrayList batchExecs = (ArrayList)batchExecutions.get(null);
                                                    TestCase.assertNotNull((Object)batchExecs);
                                                    TestCase.assertEquals((int)1, (int)batchExecs.size());
                                                    TestCase.assertEquals((int)20, (int)((Integer)batchExecs.get(0)));
                                                    batchExecutions.clear();
                                                } else {
                                                    TestCase.assertEquals((int)0, (int)batchExecutions.size());
                                                }
                                                TestCase.assertEquals((int)0, (int)preparedExec);
                                                TestCase.assertEquals((int)40, (int)unpreparedExec);
                                                unpreparedExec = 0;
                                            }
                                        });
                                        rs = stmt.executeQuery("select * from testtable order by id");
                                        for (id3 = 1; id3 <= 20; ++id3) {
                                            ClientServerDUnit.assertTrue((boolean)rs.next());
                                            ClientServerDUnit.assertEquals((int)id3, (int)rs.getInt(1));
                                            ClientServerDUnit.assertEquals((String)("newtest" + id3), (String)rs.getString(2));
                                        }
                                        ClientServerDUnit.assertFalse((boolean)rs.next());
                                        rs = stmt.executeQuery("select * from testtable where id > 10 order by id");
                                        for (id3 = 11; id3 <= 20; ++id3) {
                                            ClientServerDUnit.assertTrue((boolean)rs.next());
                                            ClientServerDUnit.assertEquals((int)id3, (int)rs.getInt(1));
                                            ClientServerDUnit.assertEquals((String)("newtest" + id3), (String)rs.getString(2));
                                        }
                                        ClientServerDUnit.assertFalse((boolean)rs.next());
                                        serverVM.invoke((Runnable)new SerializableRunnable(){

                                            public void run() {
                                                TestCase.assertEquals((int)0, (int)preparedExec);
                                                TestCase.assertEquals((int)4, (int)unpreparedExec);
                                                unpreparedExec = 0;
                                            }
                                        });
                                        stmt.execute("drop table TESTTABLE");
                                        stmt.close();
                                        conn.close();
                                        if (!TestUtil.USE_ODBC_BRIDGE) {
                                            url = TestUtil.getNetProtocol(localHost.getHostName(), netPort) + "test";
                                            try {
                                                conn = DriverManager.getConnection(url);
                                            }
                                            catch (SQLException ex) {
                                                if ("XJ028".equals(ex.getSQLState()) || "XJ212".equals(ex.getSQLState())) break block54;
                                                throw ex;
                                            }
                                        }
                                    }
                                    url = "jdbc:gemfirexd://" + localHost.getHostName() + ':' + netPort;
                                    conn = DriverManager.getConnection(url, connProps);
                                    expectedUrl = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
                                    this.checkDBMetadata(conn, expectedUrl);
                                    stmt = conn.createStatement();
                                    stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
                                    serverVM.invoke((Runnable)checkAttrs);
                                    pstmt = conn.prepareStatement("insert into TESTTABLE values(?,?)");
                                    String s = "test\u0905";
                                    pstmt.setInt(1, 1);
                                    pstmt.setString(2, "test\u0905");
                                    pstmt.execute();
                                    pstmt.setInt(1, 2);
                                    pstmt.setString(2, "test\u0905");
                                    pstmt.execute();
                                    rs = conn.createStatement().executeQuery("select * from TESTTABLE");
                                    ClientServerDUnit.assertTrue((boolean)rs.next());
                                    String resultStr = rs.getString(2);
                                    this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
                                    this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
                                    ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
                                    ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
                                    ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
                                    ClientServerDUnit.assertTrue((boolean)rs.next());
                                    resultStr = rs.getString(2);
                                    this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
                                    this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
                                    ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
                                    ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
                                    ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
                                    ClientServerDUnit.assertFalse((boolean)rs.next());
                                    serverVM.invoke((Runnable)new SerializableRunnable(){

                                        public void run() {
                                            TestCase.assertEquals((int)2, (int)preparedExec);
                                            TestCase.assertEquals((int)2, (int)unpreparedExec);
                                            preparedExec = 0;
                                            unpreparedExec = 0;
                                        }
                                    });
                                    stmt.execute("delete from testtable where 1=1");
                                    for (int id6 = 1; id6 <= 20; ++id6) {
                                        pstmt.setInt(1, id6);
                                        pstmt.setString(2, "test" + id6);
                                        pstmt.execute();
                                    }
                                    serverVM.invoke((Runnable)new SerializableRunnable(){

                                        public void run() {
                                            TestCase.assertEquals((int)20, (int)preparedExec);
                                            TestCase.assertEquals((int)2, (int)unpreparedExec);
                                            preparedExec = 0;
                                            unpreparedExec = 0;
                                        }
                                    });
                                    this.serverExecute(2, (Runnable)new SerializableRunnable("attach observer", (GemFireXDQueryObserver)errorGen){
                                        final /* synthetic */ GemFireXDQueryObserver val$errorGen;
                                        {
                                            this.val$errorGen = gemFireXDQueryObserver;
                                            super(x0);
                                        }

                                        public void run() throws CacheException {
                                            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$errorGen);
                                        }
                                    });
                                    String expectedMessage = PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"42X65", (Object)"INDEX10_TEST")).getLocalizedMessage();
                                    this.getLogWriter().info((Object)("Expected exception message: " + expectedMessage));
                                    this.addExpectedException((int[])null, new int[]{1, 2}, new Object[]{SQLException.class, "java.sql.SQLSyntaxErrorException", "42Y03", "42X65", "X0Z02"});
                                    try {
                                        stmt.execute("select * from TESTTABLE");
                                        ClientServerDUnit.fail((String)"expected an SQLException due to the observer");
                                    }
                                    catch (SQLException ex) {
                                        if (!"42X65".equals(ex.getSQLState())) {
                                            throw ex;
                                        }
                                        ClientServerDUnit.assertTrue((String)ex.getLocalizedMessage(), (boolean)ex.getLocalizedMessage().contains(expectedMessage));
                                    }
                                    try {
                                        stmt.execute("create index INDEX10_TEST on TESTTABLE (ID)");
                                        ClientServerDUnit.fail((String)"expected an SQLException due to the observer");
                                    }
                                    catch (SQLException ex) {
                                        if (!"42X65".equals(ex.getSQLState())) {
                                            throw ex;
                                        }
                                        ClientServerDUnit.assertTrue((String)ex.getLocalizedMessage(), (boolean)ex.getLocalizedMessage().contains(expectedMessage));
                                    }
                                    this.serverExecute(2, (Runnable)new SerializableRunnable("remove observer"){

                                        public void run() throws CacheException {
                                            GemFireXDQueryObserverHolder.clearInstance();
                                        }
                                    });
                                    stmt.execute("create procedure proc.test(DP1 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".procTest(java.lang.Integer)'");
                                    cstmt = conn.prepareCall("call proc.test(?)");
                                    cstmt.setInt(1, 1);
                                    cstmt.execute();
                                    stmt.execute("drop procedure proc.test");
                                    try {
                                        cstmt = conn.prepareCall("call proc.test(?)");
                                        cstmt.setInt(1, 10);
                                        cstmt.execute();
                                    }
                                    catch (SQLException ex) {
                                        if ("42Y03".equals(ex.getSQLState())) break block55;
                                        throw ex;
                                    }
                                }
                                stmt.execute("create procedure proc.test(DP1 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".procTest(java.lang.Integer)'");
                                pstmt = conn.prepareStatement("update testtable set description=? where id=?");
                                for (int id7 = 1; id7 <= 20; ++id7) {
                                    pstmt.setString(1, "newtest" + id7);
                                    pstmt.setInt(2, id7);
                                    pstmt.addBatch();
                                }
                                results = pstmt.executeBatch();
                                ClientServerDUnit.assertEquals((int)20, (int)results.length);
                                for (int res : results) {
                                    ClientServerDUnit.assertEquals((int)1, (int)res);
                                }
                                serverVM.invoke((Runnable)new SerializableRunnable(){

                                    public void run() {
                                        TestCase.assertEquals((int)1, (int)batchExecutions.size());
                                        ArrayList batchExecs = (ArrayList)batchExecutions.get("update testtable set description=? where id=?");
                                        TestCase.assertNotNull((Object)batchExecs);
                                        TestCase.assertEquals((int)1, (int)batchExecs.size());
                                        TestCase.assertEquals((int)20, (int)((Integer)batchExecs.get(0)));
                                        batchExecutions.clear();
                                    }
                                });
                                rs = stmt.executeQuery("select * from testtable order by id");
                                for (id2 = 1; id2 <= 20; ++id2) {
                                    ClientServerDUnit.assertTrue((boolean)rs.next());
                                    ClientServerDUnit.assertEquals((int)id2, (int)rs.getInt(1));
                                    ClientServerDUnit.assertEquals((String)("newtest" + id2), (String)rs.getString(2));
                                }
                                ClientServerDUnit.assertFalse((boolean)rs.next());
                                for (id2 = 1; id2 <= 20; ++id2) {
                                    stmt.addBatch("update testtable set description='new2test" + id2 + "' where id=" + id2);
                                }
                                results = stmt.executeBatch();
                                ClientServerDUnit.assertEquals((int)20, (int)results.length);
                                for (int res : results) {
                                    ClientServerDUnit.assertEquals((int)1, (int)res);
                                }
                                serverVM.invoke((Runnable)new SerializableRunnable(){

                                    public void run() {
                                        if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                                            TestCase.assertEquals((int)1, (int)batchExecutions.size());
                                            ArrayList batchExecs = (ArrayList)batchExecutions.get(null);
                                            TestCase.assertNotNull((Object)batchExecs);
                                            TestCase.assertEquals((int)1, (int)batchExecs.size());
                                            TestCase.assertEquals((int)20, (int)((Integer)batchExecs.get(0)));
                                            batchExecutions.clear();
                                        } else {
                                            TestCase.assertEquals((int)0, (int)batchExecutions.size());
                                        }
                                        preparedExec = 0;
                                        unpreparedExec = 0;
                                    }
                                });
                                try {
                                    rs = stmt.executeQuery("select * from testtab order by id");
                                    ClientServerDUnit.fail((String)"expected exception for non-existent table");
                                }
                                catch (SQLException sqle) {
                                    if ("42X05".equals(sqle.getSQLState())) break block56;
                                    throw sqle;
                                }
                            }
                            try {
                                rs = stmt.executeQuery("select * from testtable order by id2");
                                ClientServerDUnit.fail((String)"expected exception for non-existent table");
                            }
                            catch (SQLException sqle) {
                                if ("42X04".equals(sqle.getSQLState())) break block57;
                                throw sqle;
                            }
                        }
                        serverVM.invoke((Runnable)new SerializableRunnable(){

                            public void run() {
                                if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                                    TestCase.assertEquals((int)0, (int)preparedExec);
                                } else {
                                    TestCase.assertEquals((int)2, (int)preparedExec);
                                }
                                TestCase.assertEquals((int)0, (int)unpreparedExec);
                                preparedExec = 0;
                            }
                        });
                        this.serverExecute(1, (Runnable)new SerializableRunnable("attach error generator", (GemFireXDQueryObserver)errorGen){
                            final /* synthetic */ GemFireXDQueryObserver val$errorGen;
                            {
                                this.val$errorGen = gemFireXDQueryObserver;
                                super(x0);
                            }

                            public void run() throws CacheException {
                                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$errorGen);
                            }
                        });
                        try {
                            rs = stmt.executeQuery("select * from testtable order by id");
                            ClientServerDUnit.fail((String)"expected exception in query due to observer");
                        }
                        catch (SQLException sqle) {
                            if ("42X65".equals(sqle.getSQLState())) break block58;
                            throw sqle;
                        }
                    }
                    conn.setTransactionIsolation(2);
                    pstmt = conn.prepareStatement("update testtable set description=? where id=?");
                    for (int id8 = 1; id8 <= 20; ++id8) {
                        pstmt.setString(1, "new3test" + id8);
                        pstmt.setInt(2, id8);
                        pstmt.addBatch();
                    }
                    try {
                        pstmt.executeBatch();
                        ClientServerDUnit.fail((String)"expected exception in query due to observer");
                    }
                    catch (SQLException sqle) {
                        if (!"X0Z02".equals(sqle.getSQLState())) {
                            throw sqle;
                        }
                    }
                    finally {
                        pstmt.clearBatch();
                    }
                    try {
                        pstmt = conn.prepareStatement("update testtable set description2=? where id=?");
                        ClientServerDUnit.fail((String)"expected syntax error");
                    }
                    catch (SQLException sqle) {
                        if ("42X14".equals(sqle.getSQLState())) break block60;
                        throw sqle;
                    }
                }
                serverVM.invoke((Runnable)new SerializableRunnable((GemFireXDQueryObserver)batchExec, (GemFireXDQueryObserver)queryExec){
                    final /* synthetic */ GemFireXDQueryObserver val$batchExec;
                    final /* synthetic */ GemFireXDQueryObserver val$queryExec;
                    {
                        this.val$batchExec = gemFireXDQueryObserver;
                        this.val$queryExec = gemFireXDQueryObserver2;
                    }

                    public void run() {
                        TestCase.assertEquals((int)0, (int)preparedExec);
                        TestCase.assertEquals((int)0, (int)unpreparedExec);
                        GemFireXDQueryObserverHolder.clearInstance();
                        GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.val$batchExec);
                        GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.val$queryExec);
                        hasQueryObservers = true;
                    }
                });
                conn.commit();
                conn2.setTransactionIsolation(2);
                final Connection conn11 = conn;
                final Connection conn12 = conn2;
                final CyclicBarrier barrier = new CyclicBarrier(2);
                final Throwable[] failed = new Throwable[1];
                final AtomicInteger numConflicts = new AtomicInteger(0);
                Runnable conflictRun = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            int tnum = barrier.await();
                            PreparedStatement pstmt = tnum == 0 ? conn11.prepareStatement("update testtable set description=? where id=?") : conn12.prepareStatement("update testtable set description=? where id=?");
                            for (int id = 1; id <= 20; ++id) {
                                pstmt.setString(1, "new2test" + id);
                                pstmt.setInt(2, id);
                                pstmt.addBatch();
                            }
                            try {
                                pstmt.executeBatch();
                            }
                            catch (SQLException sqle) {
                                if (!"X0Z02".equals(sqle.getSQLState())) {
                                    throw sqle;
                                }
                                numConflicts.incrementAndGet();
                            }
                            finally {
                                try {
                                    pstmt.clearBatch();
                                }
                                catch (SQLException sqle) {
                                    ClientServerDUnit.this.getLogWriter().warn((Object)sqle);
                                }
                            }
                        }
                        catch (Throwable t) {
                            failed[0] = t;
                        }
                    }
                };
                Thread t12 = new Thread(conflictRun);
                Thread t22 = new Thread(conflictRun);
                t12.start();
                t22.start();
                t12.join();
                t22.join();
                if (failed[0] != null) {
                    ClientServerDUnit.fail("unexpected exception " + failed[0], failed[0]);
                }
                ClientServerDUnit.assertEquals((int)1, (int)numConflicts.get());
                conn.commit();
                conn2.commit();
                conn2.setTransactionIsolation(0);
                serverVM.invoke((Runnable)new SerializableRunnable(){

                    public void run() {
                        batchExecutions.clear();
                        preparedExec = 0;
                        unpreparedExec = 0;
                    }
                });
                stmt.clearBatch();
                stmt.addBatch("insert into testtable values (1000, 'desc1000')");
                stmt.addBatch("insert into testtab values (20, 'desc20')");
                stmt.addBatch("insert into testtable values (2000, 'desc2000')");
                try {
                    stmt.executeBatch();
                    ClientServerDUnit.fail((String)"expected syntax error");
                }
                catch (SQLException sqle) {
                    if ("42X05".equals(sqle.getSQLState())) break block61;
                    throw sqle;
                }
            }
            stmt.execute("delete from testtable where id > 20");
            serverVM.invoke((Runnable)new SerializableRunnable(){

                public void run() {
                    if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                        TestCase.assertEquals((int)0, (int)preparedExec);
                        TestCase.assertEquals((int)3, (int)unpreparedExec);
                        TestCase.assertEquals((int)1, (int)batchExecutions.size());
                    } else {
                        TestCase.assertEquals((int)1, (int)preparedExec);
                        TestCase.assertEquals((int)4, (int)unpreparedExec);
                    }
                    preparedExec = 0;
                    unpreparedExec = 0;
                    batchExecutions.clear();
                }
            });
            conn.commit();
            conn.setTransactionIsolation(0);
            this.removeExpectedException((int[])null, new int[]{1, 2}, new Object[]{SQLException.class, "java.sql.SQLSyntaxErrorException", "42Y03", "42X65", "X0Z02"});
            rs = stmt.executeQuery("select * from testtable order by id");
            for (id = 1; id <= 20; ++id) {
                ClientServerDUnit.assertTrue((boolean)rs.next());
                ClientServerDUnit.assertEquals((int)id, (int)rs.getInt(1));
                ClientServerDUnit.assertEquals((String)("new2test" + id), (String)rs.getString(2));
            }
            ClientServerDUnit.assertFalse((boolean)rs.next());
            serverVM.invoke((Runnable)new SerializableRunnable(){

                public void run() {
                    TestCase.assertEquals((int)0, (int)preparedExec);
                    if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                        TestCase.assertEquals((int)2, (int)unpreparedExec);
                    } else {
                        TestCase.assertEquals((int)3, (int)unpreparedExec);
                    }
                    unpreparedExec = 0;
                }
            });
            cstmt = conn.prepareCall("call proc.test(?)");
            for (id = 1; id <= 20; ++id) {
                cstmt.setInt(1, id);
                cstmt.addBatch();
            }
            results = cstmt.executeBatch();
            ClientServerDUnit.assertEquals((int)20, (int)results.length);
            for (int res : results) {
                if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                    ClientServerDUnit.assertEquals((int)0, (int)res);
                    continue;
                }
                ClientServerDUnit.assertEquals((int)-1, (int)res);
            }
            serverVM.invoke((Runnable)new SerializableRunnable(){

                public void run() {
                    TestCase.assertEquals((int)20, (int)preparedExec);
                    TestCase.assertEquals((int)0, (int)unpreparedExec);
                    preparedExec = 0;
                    if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                        TestCase.assertEquals((int)1, (int)batchExecutions.size());
                        ArrayList batchExecs = (ArrayList)batchExecutions.get("call proc.test(?)");
                        TestCase.assertNotNull((Object)batchExecs);
                        TestCase.assertEquals((int)1, (int)batchExecs.size());
                        TestCase.assertEquals((int)20, (int)((Integer)batchExecs.get(0)));
                        batchExecutions.clear();
                    } else {
                        TestCase.assertEquals((int)0, (int)batchExecutions.size());
                    }
                }
            });
            ClientServerDUnit.assertEquals((boolean)false, (boolean)stmt.execute("call proc.test(10)"));
            serverVM.invoke((Runnable)new SerializableRunnable(){

                public void run() {
                    TestCase.assertEquals((int)0, (int)batchExecutions.size());
                    if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                        TestCase.assertEquals((int)0, (int)preparedExec);
                        TestCase.assertEquals((int)1, (int)unpreparedExec);
                    } else {
                        TestCase.assertEquals((int)1, (int)preparedExec);
                        TestCase.assertEquals((int)0, (int)unpreparedExec);
                    }
                    unpreparedExec = 0;
                }
            });
            try {
                stmt.execute("call proc.test2(10)");
                ClientServerDUnit.fail((String)"expected procedure not found exception");
            }
            catch (SQLException ex) {
                if ("42Y03".equals(ex.getSQLState())) break block62;
                throw ex;
            }
        }
        serverVM.invoke((Runnable)new SerializableRunnable(){

            public void run() {
                if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                    TestCase.assertEquals((int)0, (int)preparedExec);
                } else {
                    TestCase.assertEquals((int)2, (int)preparedExec);
                }
                TestCase.assertEquals((int)0, (int)unpreparedExec);
                preparedExec = 0;
                unpreparedExec = 0;
            }
        });
        ClientServerDUnit.assertEquals((boolean)false, (boolean)stmt.execute("call proc.test(20)"));
        serverVM.invoke((Runnable)new SerializableRunnable(){

            public void run() {
                TestCase.assertEquals((int)0, (int)batchExecutions.size());
                if (ClientSharedUtils.USE_THRIFT_AS_DEFAULT) {
                    TestCase.assertEquals((int)0, (int)preparedExec);
                    TestCase.assertEquals((int)1, (int)unpreparedExec);
                } else {
                    TestCase.assertEquals((int)1, (int)preparedExec);
                    TestCase.assertEquals((int)0, (int)unpreparedExec);
                }
                unpreparedExec = 0;
            }
        });
        serverVM.invoke((Runnable)new SerializableRunnable("remove observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.clearInstance();
                batchExecutions.clear();
                hasQueryObservers = false;
                preparedExec = 0;
                unpreparedExec = 0;
            }
        });
        stmt.execute("drop table TESTTABLE");
        stmt.close();
        conn.close();
    }

    public void test44240() throws Exception {
        Properties props = new Properties();
        props.setProperty("log-level", "severe");
        props.setProperty("gemfirexd.debug.false", "TraceFunctionException");
        this.startVMs(0, 2, 0, null, props);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        TestUtil.deletePersistentFiles = true;
        Properties connProps = new Properties();
        connProps.setProperty("load-balance", "false");
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn = DriverManager.getConnection(url, connProps);
        Connection conn2 = DriverManager.getConnection(TestUtil.getNetProtocol(localHost.getHostName(), netPort2), TestUtil.getNetProperties(connProps));
        Statement stmt = conn.createStatement();
        stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        int numOps = 20;
        PreparedStatement pstmt = conn.prepareStatement("insert into testtable values(?, ?)");
        for (int id = 1; id <= 20; ++id) {
            pstmt.setInt(1, id);
            pstmt.setString(2, "test" + id);
            pstmt.addBatch();
        }
        int[] results = pstmt.executeBatch();
        ClientServerDUnit.assertEquals((int)20, (int)results.length);
        for (int res : results) {
            ClientServerDUnit.assertEquals((int)1, (int)res);
        }
        conn.commit();
        conn.setTransactionIsolation(2);
        conn2.setTransactionIsolation(2);
        this.addExpectedException(null, new int[]{1, 2}, "Conflict detected");
        final Connection conn11 = conn;
        final Connection conn12 = conn2;
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final Throwable[] failed = new Throwable[1];
        final AtomicInteger numConflicts = new AtomicInteger(0);
        int totalTries = 200;
        Runnable conflictRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int tnum = barrier.await();
                    PreparedStatement pstmt = tnum == 0 ? conn11.prepareStatement("update testtable set description=? where id=?") : conn12.prepareStatement("update testtable set description=? where id=?");
                    for (int tries = 1; tries <= 200; ++tries) {
                        ClientServerDUnit.this.getLogWriter().info((Object)("tries=" + tries));
                        barrier.await(30L, TimeUnit.SECONDS);
                        for (int id = 1; id <= 20; ++id) {
                            pstmt.setString(1, "new2test" + id);
                            pstmt.setInt(2, id);
                            pstmt.addBatch();
                        }
                        try {
                            pstmt.executeBatch();
                            continue;
                        }
                        catch (SQLException sqle) {
                            if (!"X0Z02".equals(sqle.getSQLState())) {
                                throw sqle;
                            }
                            numConflicts.incrementAndGet();
                            continue;
                        }
                        finally {
                            try {
                                pstmt.clearBatch();
                            }
                            catch (SQLException sqle) {
                                ClientServerDUnit.this.getLogWriter().error((Object)sqle);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    failed[0] = t;
                    ClientServerDUnit.this.getLogWriter().error((Object)t);
                }
            }
        };
        Thread t12 = new Thread(conflictRun);
        Thread t22 = new Thread(conflictRun);
        t12.start();
        t22.start();
        t12.join();
        t22.join();
        if (failed[0] != null) {
            ClientServerDUnit.fail("unexpected exception " + failed[0], failed[0]);
        }
        ClientServerDUnit.assertEquals((int)200, (int)numConflicts.get());
        this.removeExpectedException(null, new int[]{1, 2}, "Conflict detected");
        conn.commit();
        conn2.commit();
    }

    public void test44240_LOB() throws Exception {
        Properties props = new Properties();
        props.setProperty("log-level", "severe");
        props.setProperty("gemfirexd.debug.false", "TraceFunctionException");
        this.startVMs(0, 2, 0, null, props);
        int netPort = this.startNetworkServer(1, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        TestUtil.deletePersistentFiles = true;
        Properties connProps = new Properties();
        connProps.setProperty("load-balance", "false");
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn = DriverManager.getConnection(url, TestUtil.getNetProperties(connProps));
        Connection conn2 = DriverManager.getConnection(TestUtil.getNetProtocol(localHost.getHostName(), netPort2), connProps);
        Statement stmt = conn.createStatement();
        stmt.execute("create table TESTTABLE (ID int not null, DESCRIPTION clob not null)");
        int numOps = 20;
        PreparedStatement pstmt = conn.prepareStatement("insert into testtable values(?, ?)");
        for (int id = 1; id <= 20; ++id) {
            pstmt.setInt(1, id);
            pstmt.setString(2, "test" + id);
            pstmt.addBatch();
        }
        int[] results = pstmt.executeBatch();
        ClientServerDUnit.assertEquals((int)20, (int)results.length);
        for (int res : results) {
            ClientServerDUnit.assertEquals((int)1, (int)res);
        }
        conn.commit();
        conn.setTransactionIsolation(2);
        conn2.setTransactionIsolation(2);
        this.addExpectedException(null, new int[]{1, 2}, "Conflict detected");
        final Connection conn11 = conn;
        final Connection conn12 = conn2;
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final Throwable[] failed = new Throwable[1];
        final AtomicInteger numConflicts = new AtomicInteger(0);
        int totalTries = 200;
        Runnable conflictRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int tnum = barrier.await();
                    PreparedStatement pstmt = tnum == 0 ? conn11.prepareStatement("update testtable set description=? where id=?") : conn12.prepareStatement("update testtable set description=? where id=?");
                    for (int tries = 1; tries <= 200; ++tries) {
                        ClientServerDUnit.this.getLogWriter().info((Object)("tries=" + tries));
                        barrier.await(30L, TimeUnit.SECONDS);
                        for (int id = 1; id <= 20; ++id) {
                            pstmt.setString(1, "new2test" + id);
                            pstmt.setInt(2, id);
                            pstmt.addBatch();
                        }
                        try {
                            pstmt.executeBatch();
                            continue;
                        }
                        catch (SQLException sqle) {
                            if (!"X0Z02".equals(sqle.getSQLState())) {
                                throw sqle;
                            }
                            numConflicts.incrementAndGet();
                            continue;
                        }
                        finally {
                            try {
                                pstmt.clearBatch();
                            }
                            catch (SQLException sqle) {
                                ClientServerDUnit.this.getLogWriter().error((Object)sqle);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    failed[0] = t;
                    ClientServerDUnit.this.getLogWriter().error((Object)t);
                }
            }
        };
        Thread t12 = new Thread(conflictRun);
        Thread t22 = new Thread(conflictRun);
        t12.start();
        t22.start();
        t12.join();
        t22.join();
        if (failed[0] != null) {
            ClientServerDUnit.fail("unexpected exception " + failed[0], failed[0]);
        }
        ClientServerDUnit.assertEquals((int)200, (int)numConflicts.get());
        this.removeExpectedException(null, new int[]{1, 2}, "Conflict detected");
        conn.commit();
        conn2.commit();
    }

    public void testNetworkClientFailover() throws Exception {
        this.startVMs(0, 3);
        int netPort = this.startNetworkServer(1, null, null);
        this.attachConnectionListener(1, connListener);
        TestUtil.loadNetDriver();
        TestUtil.deletePersistentFiles = true;
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getCanonicalHostName(), netPort);
        Connection conn = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort, null, new Properties());
        this.assertNumConnections(-2, -1, 1);
        this.assertNumConnections(0, 0, 2);
        this.checkDBMetadata(conn, url);
        Statement stmt = conn.createStatement();
        stmt.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null) redundancy 1");
        PreparedStatement pstmt = conn.prepareStatement("insert into TESTTABLE values(?,?)");
        String s = "test\u0905";
        pstmt.setInt(1, 1);
        pstmt.setString(2, "test\u0905");
        pstmt.execute();
        ResultSet rs = conn.createStatement().executeQuery("select * from TESTTABLE");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        String resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
        this.assertNumConnections(-2, -1, 1);
        this.assertNumConnections(0, 0, 2);
        int netPort2 = this.startNetworkServer(2, null, null);
        String url2 = TestUtil.getNetProtocol(localHost.getCanonicalHostName(), netPort2);
        this.attachConnectionListener(2, connListener);
        Connection conn2 = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort, null, new Properties());
        this.assertNumConnections(-2, -1, 1);
        this.assertNumConnections(1, -1, 2);
        this.checkDBMetadata(conn2, url2);
        stmt = conn2.createStatement();
        rs = stmt.executeQuery("select * from TESTTABLE");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
        this.assertNumConnections(-2, -1, 1);
        this.assertNumConnections(1, -1, 2);
        Connection conn3 = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort, null, new Properties());
        this.checkDBMetadata(conn3, url, url2);
        this.assertNumConnections(-3, -1, 1);
        this.assertNumConnections(-2, -1, 2);
        conn.close();
        this.assertNumConnections(-3, -2, 1);
        this.assertNumConnections(-2, -1, 2);
        PreparedStatement pstmt3 = conn3.prepareStatement("select * from sys.members where kind <> ?");
        pstmt3.setString(1, "locator(normal)");
        rs = pstmt3.executeQuery();
        ClientServerDUnit.assertTrue((String)"expected three rows in meta-data query", (boolean)rs.next());
        ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(2));
        this.getLogWriter().info((Object)("Got sysProps=" + rs.getString(13)));
        this.getLogWriter().info((Object)("Got gfeProps=" + rs.getString(14)));
        this.getLogWriter().info((Object)("Got gfxdProps=" + rs.getString(15)));
        ClientServerDUnit.assertTrue((String)"expected three rows in meta-data query", (boolean)rs.next());
        ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(2));
        this.getLogWriter().info((Object)("Got sysProps=" + rs.getString(13)));
        this.getLogWriter().info((Object)("Got gfeProps=" + rs.getString(14)));
        this.getLogWriter().info((Object)("Got gfxdProps=" + rs.getString(15)));
        ClientServerDUnit.assertTrue((String)"expected three rows in meta-data query", (boolean)rs.next());
        ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(2));
        this.getLogWriter().info((Object)("Got sysProps=" + rs.getString(13)));
        this.getLogWriter().info((Object)("Got gfeProps=" + rs.getString(14)));
        this.getLogWriter().info((Object)("Got gfxdProps=" + rs.getString(15)));
        ClientServerDUnit.assertFalse((boolean)rs.next());
        PreparedStatement pstmt31 = conn3.prepareStatement("select * from sys.members where kind <> ?");
        pstmt31.setString(1, "locator(normal)");
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ConnectException.class, "com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolException"});
        this.addExpectedException(null, new Object[]{DisconnectException.class, SQLNonTransientConnectionException.class});
        this.stopVMNums(-1);
        pstmt = conn2.prepareStatement("insert into TESTTABLE values(?,?)");
        String s2 = "test\u0906";
        pstmt.setInt(1, 2);
        pstmt.setString(2, "test\u0906");
        pstmt.execute();
        this.assertNumConnections(-3, -2, 1);
        this.assertNumConnections(-2, -1, 2);
        this.checkDBMetadata(conn3, url, url2);
        stmt = conn3.createStatement();
        rs = stmt.executeQuery("select * from TESTTABLE where ID = 1");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
        rs = pstmt3.executeQuery();
        ClientServerDUnit.assertTrue((String)"expected two rows in meta-data query", (boolean)rs.next());
        ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(2));
        this.getLogWriter().info((Object)("Got sysProps=" + rs.getString(13)));
        this.getLogWriter().info((Object)("Got gfeProps=" + rs.getString(14)));
        this.getLogWriter().info((Object)("Got gfxdProps=" + rs.getString(15)));
        ClientServerDUnit.assertTrue((String)"expected two rows in meta-data query", (boolean)rs.next());
        ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(2));
        this.getLogWriter().info((Object)("Got sysProps=" + rs.getString(13)));
        this.getLogWriter().info((Object)("Got gfeProps=" + rs.getString(14)));
        this.getLogWriter().info((Object)("Got gfxdProps=" + rs.getString(15)));
        ClientServerDUnit.assertFalse((boolean)rs.next());
        rs = pstmt31.executeQuery();
        ClientServerDUnit.assertTrue((String)"expected two rows in meta-data query", (boolean)rs.next());
        ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(2));
        this.getLogWriter().info((Object)("Got sysProps=" + rs.getString(13)));
        this.getLogWriter().info((Object)("Got gfeProps=" + rs.getString(14)));
        this.getLogWriter().info((Object)("Got gfxdProps=" + rs.getString(15)));
        ClientServerDUnit.assertTrue((String)"expected two rows in meta-data query", (boolean)rs.next());
        ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(2));
        this.getLogWriter().info((Object)("Got sysProps=" + rs.getString(13)));
        this.getLogWriter().info((Object)("Got gfeProps=" + rs.getString(14)));
        this.getLogWriter().info((Object)("Got gfxdProps=" + rs.getString(15)));
        ClientServerDUnit.assertFalse((boolean)rs.next());
        this.assertNumConnections(-3, -2, 1);
        this.assertNumConnections(-3, -1, 2);
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ConnectException.class, "com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolException"});
        this.removeExpectedException(null, new Object[]{DisconnectException.class, SQLNonTransientConnectionException.class});
        conn = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort2, null, new Properties());
        rs = conn.createStatement().executeQuery("select * from TESTTABLE order by ID");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)2, (int)rs.getInt(1));
        resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0906".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0906".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0906".charAt("test\u0906".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0906", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
        this.assertNumConnections(-3, -2, 1);
        this.assertNumConnections(-4, -1, 2);
        stmt.execute("drop table TESTTABLE");
        stmt.close();
        conn2.close();
        this.assertNumConnections(-3, -2, 1);
        this.assertNumConnections(-4, -2, 2);
        conn.close();
        this.assertNumConnections(-3, -2, 1);
        this.assertNumConnections(-4, -3, 2);
        conn3.close();
        this.assertNumConnections(-3, -2, 1);
        this.assertNumConnections(-4, -4, 2);
    }

    public void testNetworkClientFailoverMultipleLocators() throws Throwable {
        AtomicInteger id;
        String secondaryLocators;
        int netPort1;
        String address;
        block2: {
            int locPort1 = AvailablePort.getRandomAvailablePort((int)0);
            int locPort2 = AvailablePort.getRandomAvailablePort((int)0);
            int locPort3 = AvailablePort.getRandomAvailablePort((int)0);
            address = SocketCreator.getLocalHost().getHostAddress();
            String locators = address + '[' + locPort1 + "]," + address + '[' + locPort2 + "]," + address + '[' + locPort3 + ']';
            Properties props = new Properties();
            props.setProperty("locators", locators);
            props.setProperty("mcast-port", "0");
            this.startLocatorVM(address, locPort1, null, props);
            this.startLocatorVM(address, locPort2, null, props);
            this.startLocatorVM(address, locPort3, null, props);
            this.startVMs(1, 1, 0, null, props);
            netPort1 = this.startNetworkServer(1, null, null);
            int netPort2 = this.startNetworkServer(2, null, null);
            int netPort3 = this.startNetworkServer(3, null, null);
            this.startNetworkServer(4, null, null);
            secondaryLocators = address + ':' + netPort2 + ',' + address + ':' + netPort3;
            final String secondaryLocators2 = address + '[' + netPort2 + "]," + address + '[' + netPort3 + ']';
            Connection netConn1 = TestUtil.getNetConnection(address, netPort1, ";secondary-locators=" + secondaryLocators, null);
            Statement stmt = netConn1.createStatement();
            stmt.execute("create table T.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null) redundancy 1");
            id = new AtomicInteger(1);
            SerializableCallable testConn = new SerializableCallable(){

                public Object call() {
                    try {
                        Connection netConn;
                        int currId = id.get();
                        switch (currId % 4) {
                            case 1: {
                                netConn = TestUtil.getNetConnection(address, netPort1, ";secondary-locators=" + secondaryLocators2, null);
                                break;
                            }
                            case 2: {
                                Properties props = new Properties();
                                props.setProperty("secondary-locators", secondaryLocators);
                                netConn = TestUtil.getNetConnection(address, netPort1, null, props);
                                break;
                            }
                            case 3: {
                                Properties props = new Properties();
                                props.setProperty("secondary-locators", secondaryLocators2);
                                netConn = TestUtil.getNetConnection(address, netPort1, null, props);
                                break;
                            }
                            default: {
                                netConn = TestUtil.getNetConnection(address, netPort1, ";secondary-locators=" + secondaryLocators, null);
                            }
                        }
                        Statement stmt = netConn.createStatement();
                        TestCase.assertEquals((int)1, (int)stmt.executeUpdate("insert into T.TESTTABLE values (" + currId + ",'DESC" + currId + "')"));
                        return id.incrementAndGet();
                    }
                    catch (Throwable t) {
                        return t;
                    }
                }
            };
            this.checkAndSetId(id, testConn.call());
            this.stopVMNum(-1);
            this.checkAndSetId(id, testConn.call());
            this.checkAndSetId(id, this.serverExecute(1, (Callable<?>)testConn));
            this.stopVMNum(-2);
            this.checkAndSetId(id, this.serverExecute(1, (Callable<?>)testConn));
            this.checkAndSetId(id, this.serverExecute(2, (Callable<?>)testConn));
            this.stopVMNum(-3);
            this.checkAndSetId(id, this.serverExecute(2, (Callable<?>)testConn));
            this.checkAndSetId(id, testConn.call());
            this.checkAndSetId(id, this.serverExecute(1, (Callable<?>)testConn));
            this.checkAndSetId(id, this.serverExecute(2, (Callable<?>)testConn));
            try {
                this.checkAndSetId(id, this.serverExecute(4, (Callable<?>)testConn));
                ClientServerDUnit.fail((String)"expected connection failure with no locator available");
            }
            catch (SQLException sqle) {
                if ("08006".equals(sqle.getSQLState()) || "X0Z01".equals(sqle.getSQLState())) break block2;
                ClientServerDUnit.fail("unexpected exception", sqle);
            }
        }
        SerializableCallable verify = new SerializableCallable(){

            public Object call() {
                try {
                    Connection netConn = TestUtil.getNetConnection(address, netPort1, ";secondary-locators=" + secondaryLocators, null);
                    Statement stmt = netConn.createStatement();
                    ResultSet rs = stmt.executeQuery("select * from T.TESTTABLE");
                    Object[][] expectedResults = new Object[][]{{1, "DESC1"}, {2, "DESC2"}, {3, "DESC3"}, {4, "DESC4"}, {5, "DESC5"}, {6, "DESC6"}, {7, "DESC7"}, {8, "DESC8"}, {9, "DESC9"}};
                    JDBC.assertUnorderedResultSet(rs, expectedResults, false);
                    return id.get();
                }
                catch (Throwable t) {
                    return t;
                }
            }
        };
        this.checkAndSetId(id, verify.call());
        this.checkAndSetId(id, this.serverExecute(1, (Callable<?>)verify));
        this.checkAndSetId(id, this.serverExecute(2, (Callable<?>)verify));
    }

    private void checkAndSetId(AtomicInteger id, Object result) throws Throwable {
        if (result instanceof Integer) {
            id.set((Integer)result);
        } else {
            if (result instanceof Throwable) {
                throw (Throwable)result;
            }
            ClientServerDUnit.fail((String)("unexpected result " + result));
        }
    }

    public void testNetworkClientLoadBalancing() throws Exception {
        VM locator = Host.getHost((int)0).getVM(3);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        InetAddress localHost = SocketCreator.getLocalHost();
        Properties props = new Properties();
        this.setCommonProperties(props, 0, null, null);
        props.remove("locators");
        int locatorPort = (Integer)locator.invoke(TestUtil.class, "startLocator", new Object[]{localHost.getHostAddress(), netPort, props});
        props = new Properties();
        props.setProperty("locators", localHost.getCanonicalHostName() + '[' + locatorPort + ']');
        this.startVMs(0, 2, 0, null, props);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        this.attachConnectionListener(1, connListener);
        this.attachConnectionListener(2, connListener);
        this.attachConnectionListener(locator, connListener);
        Connection conn = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort, null, new Properties());
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(1, -1, 1, 2);
        Statement stmt = conn.createStatement();
        stmt.execute("create table TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null) redundancy 1");
        PreparedStatement pstmt = conn.prepareStatement("insert into TESTTABLE values(?,?)");
        String s = "test\u0905";
        pstmt.setInt(1, 1);
        pstmt.setString(2, "test\u0905");
        pstmt.execute();
        ResultSet rs = conn.createStatement().executeQuery("select * from TESTTABLE");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        String resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(1, -1, 1, 2);
        Connection conn2 = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort1, null, new Properties());
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(1, -1, 1);
        this.assertNumConnections(1, -1, 2);
        stmt = conn2.createStatement();
        rs = stmt.executeQuery("select * from TESTTABLE");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(1, -1, 1);
        this.assertNumConnections(1, -1, 2);
        Connection conn3 = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort, null, new Properties());
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(3, -1, 1, 2);
        this.addExpectedException(null, new Object[]{ConnectException.class, DisconnectException.class, SQLNonTransientConnectionException.class});
        this.stopVMNums(-1);
        pstmt = conn2.prepareStatement("insert into TESTTABLE values(?,?)");
        String s2 = "test\u0906";
        pstmt.setInt(1, 2);
        pstmt.setString(2, "test\u0906");
        pstmt.execute();
        conn.createStatement().execute("select count(*) from TESTTABLE");
        conn3.createStatement().execute("select count(ID) from TESTTABLE");
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(3, -1, 2);
        this.removeExpectedException(null, new Object[]{ConnectException.class, DisconnectException.class, SQLNonTransientConnectionException.class});
        Connection conn4 = TestUtil.getNetConnection(localHost.getCanonicalHostName(), netPort, null, new Properties());
        rs = conn4.createStatement().executeQuery("select * from TESTTABLE order by ID");
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)1, (int)rs.getInt(1));
        resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0905".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0905".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0905".charAt("test\u0905".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0905", (String)resultStr);
        ClientServerDUnit.assertTrue((boolean)rs.next());
        ClientServerDUnit.assertEquals((int)2, (int)rs.getInt(1));
        resultStr = rs.getString(2);
        this.getLogWriter().info((Object)("sent chars: " + Arrays.toString("test\u0906".toCharArray())));
        this.getLogWriter().info((Object)("got chars: " + Arrays.toString(resultStr.toCharArray())));
        ClientServerDUnit.assertEquals((int)"test\u0906".length(), (int)resultStr.length());
        ClientServerDUnit.assertEquals((char)"test\u0906".charAt("test\u0906".length() - 1), (char)resultStr.charAt(resultStr.length() - 1));
        ClientServerDUnit.assertEquals((String)"test\u0906", (String)resultStr);
        ClientServerDUnit.assertFalse((boolean)rs.next());
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(4, -1, 2);
        stmt.execute("drop table TESTTABLE");
        stmt.close();
        conn.close();
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(4, -2, 2);
        conn2.close();
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(4, -3, 2);
        conn3.close();
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(4, -4, 2);
        conn4.close();
        this.assertNumConnections(1, 0, locator);
        this.assertNumConnections(4, -5, 2);
    }

    public void testPersistentDD() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, null, null);
        Properties props = new Properties();
        props.setProperty("sys-disk-dir", "SYS");
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, null, props);
        this.startClientVMs(1, 0, null);
        this.joinVMs(true, async1, async2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        String userName = "TesT1";
        if (userName.equalsIgnoreCase(TestUtil.currentUserName)) {
            userName = "TestT2";
        }
        String userSchemaName = StringUtil.SQLToUpperCase((String)userName);
        ClientServerDUnit.executeForUser(userName, "create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null)");
        String schemaName = ClientServerDUnit.getCurrentDefaultSchemaName();
        RegionAttributesCreation[] expectedAttrs = this.checkTestTableProperties(schemaName);
        RegionAttributesCreation[] userExpectedAttrs = this.checkTestTableProperties(userSchemaName);
        this.stopVMNums(-1, -2, 1);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        async1 = this.restartServerVMAsync(1, 0, null, null);
        async2 = this.restartServerVMAsync(2, 0, null, props);
        this.joinVMs(false, async1, async2);
        this.restartVMNums(1);
        this.serverVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(1, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)userExpectedAttrs[0]);
        this.serverVerifyRegionProperties(2, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(2, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)userExpectedAttrs[0]);
        this.clientVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[1]);
        this.clientVerifyRegionProperties(1, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)userExpectedAttrs[1]);
        this.stopVMNums(-1, 1);
        this.serverSQLExecute(2, "drop table TESTTABLE");
        this.executeOnServerForUser(2, userName, "drop table testtable");
        this.serverSQLExecute(2, "create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null) replicate");
        this.executeOnServerForUser(2, userName, "create table TESTTABLE (ID int not null, DESCRIPTION varchar(1024) not null) replicate");
        this.restartVMNums(1, -1);
        expectedAttrs[0] = new RegionAttributesCreation();
        expectedAttrs[0].setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs[0].setDataPolicy(DataPolicy.REPLICATE);
        expectedAttrs[0].setInitialCapacity(10000);
        expectedAttrs[0].setConcurrencyChecksEnabled(false);
        expectedAttrs[0].setAllHasFields(true);
        expectedAttrs[0].setHasDiskDirs(false);
        expectedAttrs[0].setHasDiskWriteAttributes(false);
        this.serverVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(1, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(2, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        expectedAttrs[1] = new RegionAttributesCreation((RegionAttributes)expectedAttrs[0], false);
        expectedAttrs[1].setDataPolicy(DataPolicy.EMPTY);
        expectedAttrs[1].setConcurrencyChecksEnabled(false);
        expectedAttrs[1].setHasDiskDirs(false);
        expectedAttrs[1].setHasDiskWriteAttributes(false);
        this.clientVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[1]);
        this.clientVerifyRegionProperties(1, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[1]);
        this.stopVMNums(-1, 1);
        this.stopVMNums(-2);
        this.joinVM(false, this.restartServerVMAsync(1, 0, null, props));
        props = new Properties();
        props.setProperty("persist-dd", "true");
        async2 = this.restartServerVMAsync(2, 0, null, props);
        this.joinVM(false, async2);
        this.restartVMNums(1);
        this.serverVerifyRegionProperties(2, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(2, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.serverVerifyRegionProperties(1, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[0]);
        this.clientVerifyRegionProperties(1, schemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[1]);
        this.clientVerifyRegionProperties(1, userSchemaName, "TESTTABLE", (RegionAttributes<?, ?>)expectedAttrs[1]);
        this.clientSQLExecute(1, "drop table TESTTABLE");
        ClientServerDUnit.executeForUser(userName, "drop table testTable");
    }

    public void testConfigScripts() throws Exception {
        SQLException sqlEx;
        String testsDir = TestUtil.getResourcesDir();
        TestUtil.deletePersistentFiles = true;
        Properties baseProps = new Properties();
        baseProps.setProperty("config-scripts", testsDir + "/lib/checkInitialScript.sql");
        this.startVMs(1, 2, 0, null, baseProps);
        String ckFile = testsDir + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, addr, tid from trade.customers", ckFile, "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, qty, tid from trade.portfolio", ckFile, "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tc.cid, tp.tid, cust_name, availQty from trade.portfolio tp, trade.customers tc where tp.cid=tc.cid", ckFile, "empty");
        this.clientSQLExecute(1, "drop table trade.portfolio");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.clientSQLExecute(1, "drop schema trade restrict");
        this.stopVMNums(1, -1, -2);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        this.restartVMNums(new int[]{1, -1}, 0, null, baseProps);
        Properties props = new Properties();
        props.setProperty("config-scripts", testsDir + "/lib/checkInitialScript.sql");
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript2.sql");
        this.restartVMNums(new int[]{-2}, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, addr, tid from trade.customers", ckFile, "dd_cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, qty, tid from trade.portfolio", ckFile, "is_port");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tc.cid, tp.tid, cust_name, availQty from trade.portfolio tp, trade.customers tc where tp.cid=tc.cid", ckFile, "is_cust_port");
        this.clientSQLExecute(1, "drop table trade.portfolio");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.clientSQLExecute(1, "drop schema trade restrict");
        this.stopVMNums(-1, -2, 1);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        this.restartVMNums(new int[]{-1, 1}, 0, null, baseProps);
        this.addExpectedException((int[])null, new int[]{2}, new Object[]{"XJ040", "java.sql.SQLSyntaxErrorException"});
        props.setProperty("config-scripts", testsDir + "/lib/checkInitialScript2.sql," + testsDir + "/lib/checkInitialScript.sql");
        try {
            this.joinVM(false, this.restartServerVMAsync(2, 0, null, props));
            ClientServerDUnit.fail((String)"Expected an SQLException while starting the VM.");
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                sqlEx = (SQLException)ex.getCause();
                if (!"XJ040".equals(sqlEx.getSQLState())) {
                    throw ex;
                }
                ((VM)this.serverVMs.get(1)).invoke(DistributedSQLTestBase.class, "deleteDataDictionaryDir");
            }
            throw ex;
        }
        this.removeExpectedException((int[])null, new int[]{2}, new Object[]{"XJ040", "java.sql.SQLSyntaxErrorException"});
        this.checkVMsDown((VM)this.serverVMs.get(1));
        this.stopVMNums(1, -1);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        this.restartVMNums(new int[]{1, -2}, 0, null, baseProps);
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{"XJ040", "java.sql.SQLSyntaxErrorException", SQLException.class});
        props.setProperty("config-scripts", testsDir + "/lib/checkInitialScript.sql," + testsDir + "/lib/checkInitialScript2.sql");
        try {
            this.joinVM(false, this.restartServerVMAsync(1, 0, null, props));
            ClientServerDUnit.fail((String)"Expected an SQLException while starting the VM.");
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                sqlEx = (SQLException)ex.getCause();
                if (!"XJ040".equals(sqlEx.getSQLState())) {
                    throw ex;
                }
                ((VM)this.serverVMs.get(0)).invoke(DistributedSQLTestBase.class, "deleteDataDictionaryDir");
            }
            throw ex;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{"XJ040", "java.sql.SQLSyntaxErrorException", SQLException.class});
        this.checkVMsDown((VM)this.serverVMs.get(0));
        this.clientSQLExecute(1, "drop table trade.portfolio");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.clientSQLExecute(1, "drop schema trade restrict");
        this.stopVMNums(1, -2);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        this.restartVMNums(new int[]{-2, 1}, 0, null, baseProps);
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{"XJ040", "java.sql.SQLSyntaxErrorException", SQLException.class});
        props.setProperty("config-scripts", testsDir + "/lib/checkInitialScript2.sql");
        try {
            this.joinVM(false, this.restartServerVMAsync(1, 0, null, props));
            ClientServerDUnit.fail((String)"Expected an SQLException while starting the VM.");
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                sqlEx = (SQLException)ex.getCause();
                if (!"XJ040".equals(sqlEx.getSQLState())) {
                    throw ex;
                }
                ((VM)this.serverVMs.get(0)).invoke(DistributedSQLTestBase.class, "deleteDataDictionaryDir");
            }
            throw ex;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{"XJ040", "java.sql.SQLSyntaxErrorException", SQLException.class});
        this.checkVMsDown((VM)this.serverVMs.get(0));
        props.setProperty("config-scripts", testsDir + "/lib/checkInitialScript.sql");
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript2.sql");
        this.restartServerVMNums(new int[]{1}, 0, null, props);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, addr, tid from trade.customers", ckFile, "dd_cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, qty, tid from trade.portfolio", ckFile, "is_port");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tc.cid, tp.tid, cust_name, availQty from trade.portfolio tp, trade.customers tc where tp.cid=tc.cid", ckFile, "is_cust_port");
    }

    public void testInitialScripts() throws Exception {
        SQLException sqlEx;
        String testsDir = TestUtil.getResourcesDir();
        TestUtil.deletePersistentFiles = true;
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, null, null);
        Properties props = new Properties();
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript.sql");
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, null, props);
        this.joinVMs(true, async1, async2);
        this.startVMs(1, 0);
        String ckFile = testsDir + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, addr, tid from trade.customers", ckFile, "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, qty, tid from trade.portfolio", ckFile, "empty");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tc.cid, tp.tid, cust_name, availQty from trade.portfolio tp, trade.customers tc where tp.cid=tc.cid", ckFile, "empty");
        this.clientSQLExecute(1, "drop table trade.portfolio");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.stopVMNums(1, -1, -2);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript.sql," + testsDir + "/lib/checkInitialScript2.sql");
        async2 = this.restartServerVMAsync(2, 0, null, props);
        async1 = this.restartServerVMAsync(1, 0, null, null);
        this.restartVMNums(1);
        this.joinVMs(false, async1, async2);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, addr, tid from trade.customers", ckFile, "dd_cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, qty, tid from trade.portfolio", ckFile, "is_port");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tc.cid, tp.tid, cust_name, availQty from trade.portfolio tp, trade.customers tc where tp.cid=tc.cid", ckFile, "is_cust_port");
        this.stopVMNums(-2);
        this.clientSQLExecute(1, "drop table trade.portfolio");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.stopVMNums(1, -1);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        this.restartVMNums(-1, 1);
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript2.sql," + testsDir + "/lib/checkInitialScript.sql");
        try {
            this.joinVM(false, this.restartServerVMAsync(2, 0, null, props));
            ClientServerDUnit.fail((String)"Expected an SQLException while starting the VM.");
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                sqlEx = (SQLException)ex.getCause();
                if (!"XJ040".equals(sqlEx.getSQLState())) {
                    throw ex;
                }
                ((VM)this.serverVMs.get(1)).invoke(DistributedSQLTestBase.class, "deleteDataDictionaryDir");
            }
            throw ex;
        }
        this.checkVMsDown((VM)this.serverVMs.get(1));
        this.stopVMNums(-1, 1);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript.sql");
        async2 = this.restartServerVMAsync(2, 0, null, props);
        this.restartVMNums(1);
        this.joinVM(false, async2);
        this.addExpectedException(new int[]{1}, new int[]{2}, SQLException.class);
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript.sql," + testsDir + "/lib/checkInitialScript2.sql");
        try {
            this.joinVM(false, this.restartServerVMAsync(1, 0, null, props));
            ClientServerDUnit.fail((String)"Expected an SQLException while starting the VM.");
        }
        catch (RMIException ex) {
            if (ex.getCause() instanceof SQLException) {
                sqlEx = (SQLException)ex.getCause();
                if (!"XJ040".equals(sqlEx.getSQLState())) {
                    throw ex;
                }
                ((VM)this.serverVMs.get(0)).invoke(DistributedSQLTestBase.class, "deleteDataDictionaryDir");
            }
            throw ex;
        }
        this.checkVMsDown((VM)this.serverVMs.get(0));
        this.removeExpectedException(new int[]{1}, new int[]{2}, SQLException.class);
        this.stopVMNums(1, -2);
        this.checkVMsDown((VM)this.clientVMs.get(0), (VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1));
        this.restartVMNums(1, -2);
        this.addExpectedException(new int[]{1}, new int[]{2}, SQLException.class);
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript2.sql");
        this.joinVM(false, this.restartServerVMAsync(1, 0, null, props));
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, addr, tid from trade.customers", ckFile, "dd_cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, qty, tid from trade.portfolio", ckFile, "is_port");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tc.cid, tp.tid, cust_name, availQty from trade.portfolio tp, trade.customers tc where tp.cid=tc.cid", ckFile, "is_cust_port");
        this.serverSQLExecute(2, "drop table trade.portfolio");
        this.serverSQLExecute(2, "drop table trade.customers");
        this.stopVMNums(-1);
        props.setProperty("init-scripts", testsDir + "/lib/checkInitialScript.sql," + testsDir + "/lib/checkInitialScript2.sql");
        this.joinVM(false, this.restartServerVMAsync(1, 0, null, props));
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, addr, tid from trade.customers", ckFile, "dd_cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select cid, qty, tid from trade.portfolio", ckFile, "is_port");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tc.cid, tp.tid, cust_name, availQty from trade.portfolio tp, trade.customers tc where tp.cid=tc.cid", ckFile, "is_cust_port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartUpWithLocaleSet() throws Exception {
        this.stopAllVMs();
        Properties props = new Properties();
        this.startVMs(0, 1);
        this.startVMs(0, 1);
        this.startVMs(0, 1);
        String locale1Str = new Locale("fr", "CA").toString();
        if (!Locale.getDefault().toString().equals(locale1Str)) {
            props.setProperty("territory", locale1Str);
        } else {
            props.setProperty("territory", new Locale("en", "GB").toString());
        }
        try {
            this.startVMs(0, 1, 0, null, props);
            ClientServerDUnit.fail((String)"This test should have failed with GemFireXDRuntimeException.Locale of all nodes in the cluser needs to be same");
        }
        catch (RMIException e) {
            if (!e.getCause().getCause().getMessage().startsWith("Locale should be same on all nodes in the cluster")) {
                ClientServerDUnit.fail("Test failed with unexpected exception :", e);
            }
        }
        finally {
            this.stopAllVMs();
        }
    }

    public void testServerGroupsRouting() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG1, SG3", null);
        this.startClientVMs(1, 0, "SG2, SG4", null);
        this.joinVMs(true, async1, async2, async3);
        SerializableRunnable registerFn = new SerializableRunnable("register function"){

            public void run() throws CacheException {
                FunctionService.registerFunction((Function)new TestFunction());
            }
        };
        this.serverExecute(1, (Runnable)registerFn);
        this.serverExecute(2, (Runnable)registerFn);
        this.serverExecute(3, (Runnable)registerFn);
        this.clientExecute(1, (Runnable)registerFn);
        DistributedMember server1 = this.getMemberForVM((VM)this.serverVMs.get(0));
        DistributedMember server2 = this.getMemberForVM((VM)this.serverVMs.get(1));
        DistributedMember server3 = this.getMemberForVM((VM)this.serverVMs.get(2));
        DistributedMember client1 = this.getMemberForVM((VM)this.clientVMs.get(0));
        List<?> resultMembers = this.executeOnServerGroups("SG3");
        this.checkMembersEqual(resultMembers, server3);
        resultMembers = this.executeOnServerGroups("SG2");
        this.checkMembersEqual(resultMembers, server2, client1);
        resultMembers = this.executeOnServerGroups("SG4");
        this.checkMembersEqual(resultMembers, client1);
        resultMembers = this.executeOnServerGroups("SG2,SG1");
        this.checkMembersEqual(resultMembers, server1, server2, server3, client1);
        resultMembers = this.executeOnServerGroups("SG3, SG2");
        this.checkMembersEqual(resultMembers, server2, server3, client1);
        resultMembers = this.executeOnServerGroups("SG3, SG4");
        this.checkMembersEqual(resultMembers, server3, client1);
        resultMembers = this.executeOnServerGroups("");
        this.checkMembersEqual(resultMembers, server1, server2, server3);
        resultMembers = this.executeOnServerGroups(null);
        this.checkMembersEqual(resultMembers, server1, server2, server3);
        resultMembers = this.executeOnServerGroups("  ");
        this.checkMembersEqual(resultMembers, server1, server2, server3);
        try {
            resultMembers = this.executeOnServerGroups("SG5");
            ClientServerDUnit.fail((String)"expected function exception");
        }
        catch (FunctionException functionException) {
            // empty catch block
        }
        GfxdListResultCollector gfxdRC = new GfxdListResultCollector();
        ResultCollector rc = ServerGroupUtils.onServerGroups((String)"SG1, SG2, SG3, SG4", (boolean)false).withCollector((ResultCollector)gfxdRC).execute("ClientServerDUnit.TestFunction");
        List result = (List)rc.getResult();
        ClientServerDUnit.assertEquals((String)"expected number of results: 4", (int)4, (int)result.size());
        for (Object res : result) {
            ClientServerDUnit.assertNull((String)"expected null result", res);
        }
    }

    public void testNodeAndServerGroupsExecution() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG1, SG3", null);
        this.startClientVMs(1, 0, "SG2, SG4", null);
        this.joinVMs(true, async1, async2, async3);
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (id int primary key, addr varchar(100))");
        PreparedStatement pstmt = TestUtil.jdbcConn.prepareStatement("insert into EMP.TESTTABLE values (?, ?)");
        for (int index = 1; index <= 100; ++index) {
            pstmt.setInt(1, index);
            pstmt.setString(2, "ADDR" + index);
            pstmt.execute();
        }
        int numResults = 0;
        Statement stmt = TestUtil.jdbcConn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from EMP.TESTTABLE where GROUPS() like 'SG1%'");
        while (rs.next()) {
            ++numResults;
        }
        rs = stmt.executeQuery("select * from EMP.TESTTABLE where GROUPS() = 'SG2'");
        while (rs.next()) {
            ++numResults;
        }
        ClientServerDUnit.assertEquals((int)100, (int)numResults);
        numResults = 0;
        rs = stmt.executeQuery("select * from EMP.TESTTABLE where GROUPS() like '%SG3' or 'SG2' = GROUPS() or GROUPS() = 'SG1'");
        while (rs.next()) {
            ++numResults;
        }
        ClientServerDUnit.assertEquals((int)100, (int)numResults);
        rs = stmt.executeQuery("select * from EMP.TESTTABLE where GROUPS() like '%SG4'");
        ClientServerDUnit.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from EMP.TESTTABLE where GROUPS() = 'SG3'");
        ClientServerDUnit.assertFalse((boolean)rs.next());
        DistributedMember server1 = this.getMemberForVM((VM)this.serverVMs.get(0));
        DistributedMember server2 = this.getMemberForVM((VM)this.serverVMs.get(1));
        DistributedMember server3 = this.getMemberForVM((VM)this.serverVMs.get(2));
        DistributedMember client1 = this.getMemberForVM((VM)this.clientVMs.get(0));
        numResults = 0;
        rs = stmt.executeQuery("select * from EMP.TESTTABLE where DSID() = '" + server1.toString() + "' or DSID() = '" + server2.toString() + "' or DSID() = '" + server3.toString() + "'");
        while (rs.next()) {
            ++numResults;
        }
        ClientServerDUnit.assertEquals((int)100, (int)numResults);
        rs = stmt.executeQuery("select * from EMP.TESTTABLE where DSID() = '" + client1.toString() + "'");
        ClientServerDUnit.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from EMP.TESTTABLE where DSID() = '1'");
        ClientServerDUnit.assertFalse((boolean)rs.next());
    }

    public void test41320_41723() throws Exception {
        this.startVMs(1, 0);
        this.run41320_41723("", 1, null);
        this.stopVMNum(-1);
        this.run41320_41723(" replicate", 1, null);
        this.run41320_41723(" server groups (sg1)", 2, "SG1");
        this.stopVMNum(-2);
        this.run41320_41723(" replicate server groups (sg2)", 2, "SG2");
    }

    private void run41320_41723(String createSuffix, int serverNum, String serverGroups) throws Exception {
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                try {
                                    this.clientSQLExecute(1, "create table EMP.TESTTABLE (id int primary key, addr varchar(100))" + createSuffix);
                                    ClientServerDUnit.fail((String)"expected exception when creating table with no datastore");
                                }
                                catch (SQLException ex) {
                                    if ("X0Z08".equals(ex.getSQLState())) break block15;
                                    throw ex;
                                }
                            }
                            if (this.serverVMs.size() < serverNum) {
                                this.startServerVMs(1, 0, serverGroups);
                            } else {
                                this.restartServerVMNums(new int[]{serverNum}, 0, serverGroups, null);
                            }
                            try {
                                this.clientSQLExecute(1, "create schema EMP");
                            }
                            catch (SQLException sqle) {
                                if ("X0Y68".equals(sqle.getSQLState())) break block16;
                                throw sqle;
                            }
                        }
                        this.clientSQLExecute(1, "create table EMP.TESTTABLE (id int primary key, addr varchar(100))" + createSuffix);
                        this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
                        try {
                            this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
                        }
                        catch (SQLException ex) {
                            if ("42Y55".equals(ex.getSQLState())) break block17;
                            throw ex;
                        }
                    }
                    this.clientSQLExecute(1, "create table EMP.TESTTABLE (id int primary key, addr varchar(100))" + createSuffix);
                    this.stopVMNum(-serverNum);
                    this.addExpectedException(new int[]{1}, (int[])null, new Object[]{PartitionedRegionStorageException.class, GemFireXDRuntimeException.class});
                    try {
                        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'ONE')");
                        ClientServerDUnit.fail((String)"expected exception when inserting with no datastore");
                    }
                    catch (SQLException ex) {
                        if ("X0Z08".equals(ex.getSQLState())) break block18;
                        throw ex;
                    }
                }
                this.removeExpectedException(new int[]{1}, (int[])null, new Object[]{PartitionedRegionStorageException.class, GemFireXDRuntimeException.class});
                try {
                    this.clientSQLExecute(1, "create index EMP.TESTIDX ON EMP.TESTTABLE(addr)");
                    ClientServerDUnit.fail((String)"expected exception when creating index with no datastore");
                }
                catch (SQLException ex) {
                    if ("X0Z08".equals(ex.getSQLState())) break block19;
                    throw ex;
                }
            }
            if (serverNum > 1) {
                try {
                    this.serverSQLExecute(1, "create index EMP.TESTIDX ON EMP.TESTTABLE(addr)");
                    ClientServerDUnit.fail((String)"expected exception when creating index with no datastore");
                }
                catch (RMIException rmiex) {
                    ClientServerDUnit.assertTrue((String)("expected SQLException: " + rmiex.getCause()), (boolean)(rmiex.getCause() instanceof SQLException));
                    SQLException sqle = (SQLException)rmiex.getCause();
                    if ("X0Z08".equals(sqle.getSQLState())) break block20;
                    throw sqle;
                }
            }
        }
        this.restartServerVMNums(new int[]{serverNum}, 0, serverGroups, null);
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (id int primary key, addr varchar(100))" + createSuffix);
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (id int primary key, addr varchar(100))" + createSuffix);
        this.clientSQLExecute(1, "create index EMP.TESTIDX ON EMP.TESTTABLE(addr)");
        this.serverSQLExecute(1, "create index EMP.TESTIDX2 ON EMP.TESTTABLE(id)");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'ONE')");
        this.serverSQLExecute(serverNum, "insert into EMP.TESTTABLE values (2, 'TWO')");
        this.serverSQLExecute(1, "drop index EMP.TESTIDX2");
        this.serverSQLExecute(serverNum, "drop index EMP.TESTIDX");
        this.clientSQLExecute(1, "drop table EMP.TESTTABLE");
    }

    public void testUseCase8Ticket5996_1() throws Exception {
        int netPort = this.startNetworkServer(1, null, null);
        this.startVMs(0, 1);
        TestUtil.deletePersistentFiles = true;
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE PROCEDURE TEST_5996(IN var Integer ) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.ClientServerDUnit.proc5996(java.lang.Integer)'");
        CallableStatement cs = conn.prepareCall("CALL TEST_5996(?)");
        try {
            cs.setInt(1, 1);
            cs.execute();
            ClientServerDUnit.fail((String)"Test should have failed");
        }
        catch (SQLException sqle) {
            if (sqle.getLocalizedMessage().indexOf("5996") == -1) {
                throw sqle;
            }
        }
        catch (Exception e) {
            ClientServerDUnit.fail("unexpected exception", e);
        }
        try {
            cs.setInt(1, 2);
            cs.execute();
            ClientServerDUnit.fail((String)"Test should have failed");
        }
        catch (SQLException sqle) {
            if (sqle.getLocalizedMessage().indexOf("5996") == -1) {
                throw sqle;
            }
        }
        catch (Exception e) {
            ClientServerDUnit.fail("unexpected exception", e);
        }
        try {
            cs.setInt(1, 3);
            cs.execute();
            ClientServerDUnit.fail((String)"Test should have failed");
        }
        catch (SQLException sqle) {
            if (sqle.getLocalizedMessage().indexOf("5996") == -1) {
                throw sqle;
            }
            if (!"38000".equals(sqle.getSQLState())) {
                throw sqle;
            }
        }
        catch (Exception e) {
            ClientServerDUnit.fail("unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseCase8Ticket5996_2() throws Exception {
        try {
            int netPort = AvailablePort.getRandomAvailablePort((int)0);
            ClientServerDUnit._startNetworkServer(((Object)((Object)this)).getClass().getName(), this.getName(), 0, netPort, null, null, false);
            TestUtil.deletePersistentFiles = true;
            this.startVMs(0, 2);
            Connection conn = TestUtil.getNetConnection(netPort, null, null);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE PROCEDURE TEST_5996(IN var Integer ) PARAMETER STYLE JAVA  LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.ClientServerDUnit.proc5996(java.lang.Integer)'");
            CallableStatement cs = conn.prepareCall("CALL TEST_5996(?)");
            try {
                cs.setInt(1, 1);
                cs.execute();
                ClientServerDUnit.fail((String)"Test should have failed");
            }
            catch (SQLException sqle) {
                if (sqle.getLocalizedMessage().indexOf("5996") == -1) {
                    throw sqle;
                }
            }
            catch (Exception e) {
                ClientServerDUnit.fail("unexpected exception", e);
            }
            try {
                cs.setInt(1, 2);
                cs.execute();
                ClientServerDUnit.fail((String)"Test should have failed");
            }
            catch (SQLException sqle) {
                if (sqle.getLocalizedMessage().indexOf("5996") == -1) {
                    throw sqle;
                }
            }
            catch (Exception e) {
                ClientServerDUnit.fail("unexpected exception", e);
            }
            try {
                cs.setInt(1, 3);
                cs.execute();
                ClientServerDUnit.fail((String)"Test should have failed");
            }
            catch (SQLException sqle) {
                if (sqle.getLocalizedMessage().indexOf("5996") == -1) {
                    throw sqle;
                }
                if (!"38000".equals(sqle.getSQLState())) {
                    throw sqle;
                }
            }
            catch (Exception e) {
                ClientServerDUnit.fail("unexpected exception", e);
            }
        }
        finally {
            ClientServerDUnit.shutDownNetworkServer();
        }
    }

    public void testVarbinaryFailure() throws Exception {
        int netPort = this.startNetworkServer(2, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("create table Varbinary_Tab (VARBINARY_VAL varchar(384) for bit data NULL)");
        PreparedStatement ps = conn.prepareStatement("insert into Varbinary_Tab values(?)");
        ps.setBytes(1, new byte[]{83});
        ps.execute();
        ps = conn.prepareStatement("update Varbinary_Tab set VARBINARY_VAL=?");
        ps.setBytes(1, new byte[]{125});
        ps.executeUpdate();
        stmt.execute("drop table Varbinary_Tab");
        stmt.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocatorStartupAPIWithBUILTINAuthentication() throws Exception {
        InetAddress localHost = SocketCreator.getLocalHost();
        Properties startProps = this.doSecuritySetup(new Properties(), true);
        Properties stopProps = this.doSecuritySetup(new Properties(), false);
        final Properties userProps = new Properties();
        userProps.setProperty(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", "sysUser1");
        userProps.setProperty("password", "pwd_sysUser1");
        FabricLocator fabapi = FabricServiceManager.getFabricLocatorInstance();
        Properties props = new Properties();
        this.setCommonProperties(props, 0, null, startProps);
        props.remove("locators");
        int port = TestUtil.startLocator(localHost.getHostAddress(), -1, props);
        Properties serverProps = this.doSecuritySetup(new Properties(), true);
        serverProps.setProperty("locators", localHost.getHostName() + '[' + port + ']');
        this.startServerVMs(1, 0, null, serverProps);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        NetworkInterface ni = fabapi.startNetworkServer(null, netPort, userProps);
        try {
            Statement stmt;
            block10: {
                this.serverExecute(1, (Runnable)new SerializableRunnable(){

                    public void run() {
                        try {
                            int netPort = AvailablePort.getRandomAvailablePort((int)0);
                            FabricServiceManager.getFabricServerInstance().startNetworkServer(null, netPort, null);
                            Connection conn = TestUtil.getConnection(userProps);
                            Statement stmt = conn.createStatement();
                            stmt.execute("call sys.create_user('gemfirexd.user.gem1', 'gem1')");
                            stmt.close();
                            conn.close();
                        }
                        catch (SQLException sqle) {
                            TestException te = new TestException("unexpected exception");
                            te.initCause((Throwable)sqle);
                            throw te;
                        }
                    }
                });
                userProps.setProperty("user", "gem1");
                userProps.setProperty("password", "gem1");
                Connection conn = TestUtil.getConnection(userProps);
                stmt = conn.createStatement();
                TestUtil.addExpectedException(GemFireXDRuntimeException.class);
                try {
                    stmt.execute("create table testapi(id int)");
                    ClientServerDUnit.fail((String)"expected DDL execution to fail");
                }
                catch (SQLException ex) {
                    if ("38000".equals(ex.getSQLState())) break block10;
                    throw ex;
                }
            }
            TestUtil.removeExpectedException(GemFireXDRuntimeException.class);
            ResultSet rs = stmt.executeQuery("select KIND, LOCATOR from SYS.MEMBERS order by KIND");
            ClientServerDUnit.assertTrue((String)"expected two rows in meta-data query", (boolean)rs.next());
            ClientServerDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(1));
            ClientServerDUnit.assertNull((Object)rs.getString(2));
            ClientServerDUnit.assertTrue((String)"expected two rows in meta-data query", (boolean)rs.next());
            ClientServerDUnit.assertEquals((String)"locator(normal)", (String)rs.getString(1));
            ClientServerDUnit.assertEquals((String)(localHost.getHostAddress() + '[' + port + ']'), (String)rs.getString(2));
            ClientServerDUnit.assertFalse((String)"expected no more than two rows from SYS.MEMBERS", (boolean)rs.next());
        }
        catch (Throwable throwable) {
            try {
                this.serverExecute(1, (Runnable)new SerializableRunnable(userProps, stopProps){
                    final /* synthetic */ Properties val$userProps;
                    final /* synthetic */ Properties val$stopProps;
                    {
                        this.val$userProps = properties;
                        this.val$stopProps = properties2;
                    }

                    public void run() {
                        TestException te = null;
                        try {
                            this.val$userProps.setProperty("user", "sysUser1");
                            this.val$userProps.setProperty("password", "pwd_sysUser1");
                            Connection conn = TestUtil.getConnection(this.val$userProps);
                            Statement stmt = conn.createStatement();
                            stmt.execute("call sys.drop_user('gem1')");
                            stmt.close();
                            conn.close();
                        }
                        catch (SQLException sqle) {
                            te = new TestException("unexpected exception");
                            te.initCause((Throwable)sqle);
                        }
                        try {
                            FabricServiceManager.getFabricServerInstance().stopAllNetworkServers();
                            TestUtil.shutDown(this.val$stopProps);
                        }
                        catch (SQLException sqle) {
                            te = new TestException("unexpected exception");
                            te.initCause((Throwable)sqle);
                        }
                        if (te != null) {
                            throw te;
                        }
                    }
                });
                ni.stop();
                fabapi.stop(stopProps);
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
            throw throwable;
        }
        try {
            this.serverExecute(1, (Runnable)new /* invalid duplicate definition of identical inner class */);
            ni.stop();
            fabapi.stop(stopProps);
        }
        finally {
            DistributedSQLTestBase.deleteStrayDataDictionaryDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testV3EncryptionScheme() throws Exception {
        Properties authProps = new Properties();
        authProps.setProperty("gemfirexd.user.admin", AuthenticationServiceBase.encryptUserPassword((String)"admin", (String)"admin", (boolean)true, (boolean)false, (boolean)true));
        authProps.setProperty("gemfirexd.user.root", AuthenticationServiceBase.encryptUserPassword((String)"root", (String)"root", (boolean)true, (boolean)true, (boolean)false));
        File authDir = new File("sec");
        authDir.mkdir();
        File authFile = new File(authDir, "gfxd-security.properties");
        FileOutputStream fos = new FileOutputStream(authFile);
        authProps.store(fos, null);
        Connection conn2 = null;
        Statement systemUser_stmt = null;
        try {
            Connection conn3;
            Connection conn1;
            block17: {
                Properties props2;
                block16: {
                    int locPort = AvailablePort.getRandomAvailablePort((int)0);
                    Properties props = new Properties();
                    props.setProperty("start-locator", "localhost[" + locPort + ']');
                    props.setProperty("auth-provider", "BUILTIN");
                    props.setProperty("gemfirexd.properties", authFile.getAbsolutePath());
                    props.setProperty("user", "admin");
                    props.setProperty("password", "admin");
                    this.startVMs(0, 1, 0, null, props);
                    props.remove("start-locator");
                    props.setProperty("locators", "localhost[" + locPort + ']');
                    props.setProperty("user", "root");
                    props.setProperty("password", "root");
                    this.startVMs(1, 2, 0, null, props);
                    props2 = new Properties();
                    props2.setProperty("user", "admin");
                    props2.setProperty("password", "admin");
                    conn1 = TestUtil.getConnection(props2);
                    props2.setProperty("user", "root");
                    props2.setProperty("password", "root");
                    conn2 = TestUtil.getConnection(props2);
                    systemUser_stmt = conn2.createStatement();
                    systemUser_stmt.execute("call sys.create_user('user1', 'a')");
                    props2.setProperty("user", "user1");
                    props2.setProperty("password", "a");
                    conn3 = TestUtil.getConnection(props2);
                    props2.setProperty("user", "root");
                    props2.setProperty("password", "admin");
                    try {
                        TestUtil.getConnection(props2);
                        ClientServerDUnit.fail((String)"expected exception in connection");
                    }
                    catch (SQLException sqle) {
                        if ("08004".equals(sqle.getSQLState())) break block16;
                        throw sqle;
                    }
                }
                props2.setProperty("user", "admin");
                props2.setProperty("password", "root");
                try {
                    TestUtil.getConnection(props2);
                    ClientServerDUnit.fail((String)"expected exception in connection");
                }
                catch (SQLException sqle) {
                    if ("08004".equals(sqle.getSQLState())) break block17;
                    throw sqle;
                }
            }
            conn1.close();
            conn3.close();
        }
        finally {
            try {
                if (conn2 != null) {
                    if (systemUser_stmt != null) {
                        systemUser_stmt.execute("call sys.drop_user('user1')");
                    }
                    conn2.close();
                }
            }
            finally {
                fos.close();
                if (!authFile.delete()) {
                    authFile.deleteOnExit();
                }
                if (!authDir.delete()) {
                    authDir.deleteOnExit();
                }
            }
        }
    }

    public static void proc5996(Integer throwSqlException) throws SQLException {
        if (throwSqlException == 1) {
            throw new SQLException("IGNORE_EXCEPTION_test test bug 5996");
        }
        if (throwSqlException == 2) {
            throw new GemFireXDRuntimeException("IGNORE_EXCEPTION_test test bug 5996");
        }
        if (throwSqlException == 3) {
            throw new SQLException("IGNORE_EXCEPTION_test test bug 5996", "38000");
        }
    }

    private void checkMembersEqual(List<?> resultMembers, DistributedMember ... expectedMembers) {
        ClientServerDUnit.assertEquals((String)("expected number of results: " + expectedMembers.length), (int)expectedMembers.length, (int)resultMembers.size());
        for (DistributedMember member : expectedMembers) {
            ClientServerDUnit.assertTrue((String)("expected to find VM in result: " + member), (boolean)resultMembers.contains(member));
        }
    }

    private List<?> executeOnServerGroups(String serverGroups) {
        GfxdListResultCollector gfxdRC = new GfxdListResultCollector();
        ResultCollector rc = ServerGroupUtils.onServerGroups((String)serverGroups, (boolean)false).withArgs((Object)Boolean.TRUE).withCollector((ResultCollector)gfxdRC).execute("ClientServerDUnit.TestFunction");
        List result = (List)rc.getResult();
        return result;
    }

    public static void executeForUser(String userName, String sql) throws SQLException {
        Properties userProps = new Properties();
        userProps.setProperty(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", userName);
        userProps.setProperty("password", userName);
        Connection userConn = TestUtil.getConnection(userProps);
        userConn.createStatement().execute(sql);
    }

    private void executeOnServerForUser(int serverNum, final String userName, final String sql) throws Exception {
        this.serverExecute(serverNum, (Runnable)new SerializableRunnable("executing " + sql + " with userName " + userName){

            public void run() throws CacheException {
                try {
                    ClientServerDUnit.executeForUser(userName, sql);
                }
                catch (SQLException ex) {
                    throw new CacheException(ex){};
                }
            }
        });
    }

    public static void procTest(Integer arg) {
        ClientServerDUnit.getGlobalLogger().info((Object)("Invoked procTest with arg: " + arg));
    }

    private Properties doSecuritySetup(Properties props, boolean defineSysUser) {
        if (defineSysUser) {
            props.setProperty("mcast-port", "0");
            props.setProperty("gemfire.security-log-level", "finest");
            props.setProperty("gemfirexd.debug.true", "TraceAuthentication,TraceSystemProcedures,TraceFabricServiceBoot");
            props.setProperty("gemfirexd.user.sysUser1", "pwd_sysUser1");
            props.setProperty("auth-provider", "BUILTIN");
        }
        props.setProperty(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", "sysUser1");
        props.setProperty("password", "pwd_sysUser1");
        return props;
    }

    @Override
    protected void setCommonProperties(Properties props, int mcastPort, String serverGroups, Properties extraProps) {
        super.setCommonProperties(props, mcastPort, serverGroups, extraProps);
        if (props != null) {
            props.setProperty("gemfirexd.test.skip-default-initial-capacity", "true");
        }
    }

    public static void waitForDerbyInitialization(NetworkServerControl server) throws InterruptedException {
        for (int tries = 1; tries <= 20; ++tries) {
            try {
                server.ping();
                break;
            }
            catch (Throwable t) {
                Thread.sleep(1000L);
                continue;
            }
        }
    }

    private static final class TestFunction
    implements Function {
        private static final String ID = "ClientServerDUnit.TestFunction";

        private TestFunction() {
        }

        public void execute(FunctionContext context) {
            Object args = context.getArguments();
            if (args instanceof Boolean && ((Boolean)args).booleanValue()) {
                InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
                context.getResultSender().lastResult((Object)myId);
            } else {
                context.getResultSender().lastResult(null);
            }
        }

        public String getId() {
            return ID;
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public boolean isHA() {
            return true;
        }
    }
}

