/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.query.SingleTablePredicatesCheckDUnit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ByteCompareTest
extends JdbcTestBase {
    private static final char[] alphabets = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+|".toCharArray();
    private static final char[] numerics = "0123456789".toCharArray();
    private static final char[] specials = " \t ".toCharArray();
    private static final char[] unicode1 = "\u0985\u0986\u0987\u0988\u0989\u098a\u098b\u098f\u0990\u0993\u0994\u0995\u0996\u0997\u0998\u0999\u099a\u099b\u099c\u099d\u099e\u099f\u09a0".toCharArray();
    private static final char[] unicode2 = "\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be".toCharArray();

    public ByteCompareTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ByteCompareTest.class));
    }

    public void testTableCharComparisons() throws Exception {
        ByteCompareTest.setupConnection();
        Statement stmt = jdbcConn.createStatement();
        stmt.execute("create table trade.customers (cust_id char(10), cid int, cust_name varchar(100) default 'unknown', since date, addr varchar(100), tid int, primary key (cid)) partition by range (cid) (VALUES BETWEEN 0 AND 999, VALUES BETWEEN 1000 AND 1102, VALUES BETWEEN 1103 AND 1250, VALUES BETWEEN 1251 AND 1677, VALUES BETWEEN 1678 AND 10000)" + this.getOffHeapSuffix());
        stmt.execute("insert into trade.customers values ('id1', 1, 'cust1', '2010-01-01', 'addr1', 1)");
        stmt.execute("insert into trade.customers values (NULL, 10, 'cust10', '2010-01-01', 'addr10', 10)");
        stmt.execute("insert into trade.customers values ('id100', 100, NULL, '2010-01-01', 'addr100', 100)");
        stmt.execute("insert into trade.customers values ('id1000', 1000, 'cust1000', '2010-01-01', NULL, 1000)");
        stmt.execute("insert into trade.customers values (NULL, 10000, 'cust10000', '2010-01-01', NULL, 10000)");
        stmt.execute("insert into trade.customers (cust_id, cid, since, addr, tid) values (NULL, 100000, '2010-01-01', NULL, 100000)");
        ResultSet rs = stmt.executeQuery("select * from trade.customers where cust_id='id100'");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100, (int)rs.getInt("CID"));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where cust_id is null order by cid");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10000, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100000, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where cust_id > 'id' order by cid");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1000, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        PreparedStatement ps = jdbcConn.prepareStatement("select * from trade.customers where cust_id > ? order by cid");
        ps.setString(1, "id100\n");
        rs = ps.executeQuery();
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1000, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where cust_name='cust1000'");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1000, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where cust_name is null order by cid");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100, (int)rs.getInt("CID"));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where cust_name > 'cust1' order by cid");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1000, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10000, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100000, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        ps = jdbcConn.prepareStatement("select * from trade.customers where cust_name > ? order by cid");
        ps.setString(1, "cust1\n");
        rs = ps.executeQuery();
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1000, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10000, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100000, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where addr='addr1'");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where addr is null order by cid");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1000, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10000, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100000, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers where addr > 'addr10' order by cid");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100, (int)rs.getInt(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        ps = jdbcConn.prepareStatement("select * from trade.customers where addr > ? order by cid");
        ps.setString(1, "addr10\n");
        rs = ps.executeQuery();
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10, (int)rs.getInt(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100, (int)rs.getInt("CID"));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from trade.customers  order by addr  NULLS FIRST, cid ");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1000, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10000, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100000, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)1, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)10, (int)rs.getInt("CID"));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((int)100, (int)rs.getInt("CID"));
        ByteCompareTest.assertFalse((boolean)rs.next());
        stmt.close();
    }

    public void testSingleTablePredicates() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement stmt = jdbcConn.createStatement();
        boolean isOffHeap = this.getOffHeapSuffix().toLowerCase().indexOf("offheap") != -1;
        Double dblPrice = PartitionedRegion.rand.nextDouble();
        SingleTablePredicatesCheckDUnit.prepareTable(dblPrice, false, false, conn, isOffHeap);
        ResultSet rs = stmt.executeQuery("select ID, DESCRIPTION from TESTTABLE where ID = 5 and DESCRIPTION like 'First%' Order By DESCRIPTION ASC NULLS FIRST");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First5", (String)rs.getString(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select ID, DESCRIPTION from TESTTABLE where ID  >= 5 And ID <= 7 Order By DESCRIPTION ASC NULLS FIRST");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertNull((Object)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First5", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First7", (String)rs.getString(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select ID, DESCRIPTION from TESTTABLE where ID  >= 5 And ID <= 7 Order By DESCRIPTION ASC NULLS LAST");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First5", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First7", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertNull((Object)rs.getString(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("Select count(src2), cast(sum(distinct src) as REAL)/count(src2) from testtable group by substr(description, 1, length(description)-1 )");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(rs.getFloat(2)));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(rs.getFloat(2)));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((Object)Float.valueOf(2.5f), (Object)Float.valueOf(rs.getFloat(2)));
        ByteCompareTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select distinct * from TESTTABLE where SRC > 1 order by address desc nulls first, id desc");
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertNull((Object)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertNull((Object)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertNull((Object)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First13", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First11", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First7", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertNull((Object)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertNull((Object)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First1", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First9", (String)rs.getString(2));
        ByteCompareTest.assertTrue((boolean)rs.next());
        ByteCompareTest.assertEquals((String)"First3", (String)rs.getString(2));
        ByteCompareTest.assertFalse((boolean)rs.next());
    }

    public void testCharComparisons() throws Exception {
        int i;
        String s1 = "test1";
        String s2 = "test10";
        int res = this.compareStringBytes(ByteCompareTest.getBytes(s1), ByteCompareTest.getBytes(s2), s1, s2);
        res = res > 0 ? 1 : (res < 0 ? -1 : 0);
        int chres = SQLChar.stringCompare((String)s1, (String)s2);
        System.out.println("Result " + res + (res != chres ? " != " : " == ") + chres);
        String[] rstrs = new String[10000];
        byte[][] rstrsbytes = new byte[rstrs.length][];
        int spaceRatio = rstrs.length / 10;
        for (i = 0; i < rstrs.length - spaceRatio; ++i) {
            rstrs[i] = ByteCompareTest.getRandomAlphaNumericString(i % 991 % 4);
            rstrsbytes[i] = ByteCompareTest.getBytes(rstrs[i]);
        }
        for (i = rstrs.length - spaceRatio; i < rstrs.length; ++i) {
            int randPick = PartitionedRegion.rand.nextInt(rstrs.length - spaceRatio);
            StringBuilder sb = new StringBuilder(rstrs[randPick]);
            for (int spaces = 0; spaces < randPick + 10; ++spaces) {
                sb.append(" ");
            }
            rstrs[i] = sb.toString();
            rstrsbytes[i] = ByteCompareTest.getBytes(rstrs[i]);
        }
        long totalbytetime = 0L;
        long totalstrtime = 0L;
        long currenttotalbytetime = 0L;
        long currenttotalstrtime = 0L;
        for (int runno = 0; runno < rstrs.length; ++runno) {
            int src;
            int[] bytecomp = new int[rstrs.length];
            int[] strcomp = new int[rstrs.length];
            long timeByteBegin = System.currentTimeMillis();
            for (int src2 = 0; src2 < rstrs.length; ++src2) {
                bytecomp[src2] = this.compareStringBytes(rstrsbytes[runno], rstrsbytes[src2], rstrs[runno], rstrs[src2]);
            }
            currenttotalbytetime += System.currentTimeMillis() - timeByteBegin;
            long timeStrBegin = System.currentTimeMillis();
            for (src = 0; src < rstrs.length; ++src) {
                strcomp[src] = SQLChar.stringCompare((String)rstrs[runno], (String)rstrs[src]);
            }
            currenttotalstrtime += System.currentTimeMillis() - timeStrBegin;
            for (src = 0; src < rstrs.length; ++src) {
                int n = bytecomp[src] > 0 ? 1 : (bytecomp[src] = bytecomp[src] < 0 ? -1 : 0);
                if (bytecomp[src] == strcomp[src]) continue;
                System.out.println(rstrs[src]);
                String msg = "Failed " + rstrs[runno] + " == " + rstrs[src] + "\t((" + bytecomp[src] + " != " + strcomp[src] + "))";
                msg.replaceAll("\n", "\r\n");
                System.out.println("Failed ");
                System.out.println("str1=" + rstrs[runno]);
                System.out.println("str2=" + rstrs[src]);
                SanityManager.THROWASSERT((String)msg);
            }
            if (runno % 1000 != 0) continue;
            String msg = rstrs.length * 100 + " byte comparisons took " + currenttotalbytetime + " ms and " + rstrs.length + " str comparisons took " + currenttotalstrtime + " ms ";
            System.out.println(msg);
            totalbytetime += currenttotalbytetime;
            totalstrtime += currenttotalstrtime;
            currenttotalbytetime = 0L;
            currenttotalstrtime = 0L;
            if (runno % 1000 != 0) continue;
            System.out.println(runno + " done");
        }
        System.out.println("Byte T " + totalbytetime);
        System.out.println("Str  T " + totalstrtime);
    }

    private static byte[] getBytes(String st) {
        char c;
        int i;
        int strlen = st.length();
        HeapDataOutputStream out = new HeapDataOutputStream(strlen + 32);
        boolean isLongUTF = false;
        int utflen = strlen;
        for (i = 0; i < strlen && utflen <= 65535; ++i) {
            c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        if (utflen > 65535) {
            isLongUTF = true;
            utflen = 0;
        }
        for (i = 0; i < strlen; ++i) {
            c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.writeByte((int)((byte)(c & 0xFF)));
                continue;
            }
            if (c > '\u07ff') {
                out.writeByte((int)((byte)(0xE0 | c >> 12 & 0xF)));
                out.writeByte((int)((byte)(0x80 | c >> 6 & 0x3F)));
                out.writeByte((int)((byte)(0x80 | c >> 0 & 0x3F)));
                continue;
            }
            out.writeByte((int)((byte)(0xC0 | c >> 6 & 0x1F)));
            out.writeByte((int)((byte)(0x80 | c >> 0 & 0x3F)));
        }
        if (isLongUTF) {
            out.writeByte(-32);
            out.writeByte(0);
            out.writeByte(0);
        }
        if (!isLongUTF && strlen == 0) {
            out.writeByte(-1);
        }
        return out.toByteArray();
    }

    public void __testIntComparisons() throws Exception {
    }

    public void __testDateComparisons() {
        int dt1 = 131531265;
        int dt2 = 131531266;
        byte[] dtb1 = new byte[4];
        byte[] dtb2 = new byte[4];
        RowFormatter.writeInt((byte[])dtb1, (int)dt1, (int)0);
        RowFormatter.writeInt((byte[])dtb2, (int)dt2, (int)0);
        int res = this.compareDateBytes(dtb1, dtb2);
        System.out.println("date comp res " + res + " expected " + (dt1 > dt2 ? 1 : (dt1 < dt2 ? -1 : 0)));
        int[] rdts = new int[10000];
        byte[][] rdtsbytes = new byte[rdts.length][4];
        for (int i = 0; i < rdts.length; ++i) {
            rdts[i] = PartitionedRegion.rand.nextInt(9999) << 16 | PartitionedRegion.rand.nextInt(12) << 8 | PartitionedRegion.rand.nextInt(31);
            RowFormatter.writeInt((byte[])rdtsbytes[i], (int)rdts[i], (int)0);
        }
        long totalbytetime = 0L;
        long totaldttime = 0L;
        long currenttotalbytetime = 0L;
        long currenttotaldttime = 0L;
        for (int runno = 0; runno < rdts.length; ++runno) {
            int src;
            int[] bytecomp = new int[rdts.length];
            int[] dbcomp = new int[rdts.length];
            long timeByteBegin = System.currentTimeMillis();
            for (int src2 = 0; src2 < rdts.length; ++src2) {
                bytecomp[src2] = this.compareDateBytes(rdtsbytes[runno], rdtsbytes[src2]);
            }
            currenttotalbytetime += System.currentTimeMillis() - timeByteBegin;
            long timeStrBegin = System.currentTimeMillis();
            for (src = 0; src < rdts.length; ++src) {
                dbcomp[src] = rdts[runno] > rdts[src] ? 1 : (rdts[runno] < rdts[src] ? -1 : 0);
            }
            currenttotaldttime += System.currentTimeMillis() - timeStrBegin;
            for (src = 0; src < rdts.length; ++src) {
                if (bytecomp[src] > 0 && dbcomp[src] > 0 || bytecomp[src] < 0 && dbcomp[src] < 0 || bytecomp[src] == 0 && dbcomp[src] == 0) continue;
                System.out.println(rdts[src]);
                String msg = "Failed " + rdts[runno] + " == " + rdts[src] + "\t((" + bytecomp[src] + " != " + dbcomp[src] + "))";
                msg.replaceAll("\n", "\r\n");
                System.err.println(msg);
                SanityManager.THROWASSERT((String)msg);
            }
            if (runno % 1000 != 0) continue;
            String msg = rdts.length * 100 + " byte comparisons took " + currenttotalbytetime + " ms and " + rdts.length + " dt comparisons took " + currenttotaldttime + " ms ";
            System.out.println(msg);
            totalbytetime += currenttotalbytetime;
            totaldttime += currenttotaldttime;
            currenttotalbytetime = 0L;
            currenttotaldttime = 0L;
            if (runno % 1000 != 0) continue;
            System.out.println(runno + " done");
        }
        System.out.println("Byte    T " + totalbytetime);
        System.out.println("Int Dt  T " + totaldttime);
    }

    public void __testDoubleComparisons() throws Exception {
        byte[] db1 = ByteCompareTest.getBytes(0.6322981066856577);
        byte[] db2 = ByteCompareTest.getBytes(0.39386921313482437);
        int r = this.compareDoubleBytes(db1, db2, 0.6322981066856577, 0.39386921313482437);
        if (this.compareDoubles(0.6322981066856577, 0.39386921313482437) != r) {
            throw new Exception("Not equal");
        }
        double[] rdbs = new double[10000];
        byte[][] rdbsbytes = new byte[rdbs.length][];
        for (int i = 0; i < rdbs.length; ++i) {
            rdbs[i] = PartitionedRegion.rand.nextDouble();
            rdbsbytes[i] = ByteCompareTest.getBytes(rdbs[i]);
        }
        long totalbytetime = 0L;
        long totaldbtime = 0L;
        long currenttotalbytetime = 0L;
        long currenttotalstrtime = 0L;
        for (int runno = 0; runno < rdbs.length; ++runno) {
            int src;
            int[] bytecomp = new int[rdbs.length];
            int[] dbcomp = new int[rdbs.length];
            long timeByteBegin = System.currentTimeMillis();
            for (int src2 = 0; src2 < rdbs.length; ++src2) {
                bytecomp[src2] = this.compareDoubleBytes(rdbsbytes[runno], rdbsbytes[src2], rdbs[runno], rdbs[src2]);
            }
            currenttotalbytetime += System.currentTimeMillis() - timeByteBegin;
            long timeStrBegin = System.currentTimeMillis();
            for (src = 0; src < rdbs.length; ++src) {
                dbcomp[src] = this.compareDoubles(rdbs[runno], rdbs[src]);
            }
            currenttotalstrtime += System.currentTimeMillis() - timeStrBegin;
            for (src = 0; src < rdbs.length; ++src) {
                if (bytecomp[src] > 0 && dbcomp[src] > 0 || bytecomp[src] < 0 && dbcomp[src] < 0 || bytecomp[src] == 0 && dbcomp[src] == 0) continue;
                System.out.println(rdbs[src]);
                String msg = "Failed " + rdbs[runno] + " == " + rdbs[src] + "\t((" + bytecomp[src] + " != " + dbcomp[src] + "))";
                msg.replaceAll("\n", "\r\n");
                System.err.println(msg);
                SanityManager.THROWASSERT((String)msg);
            }
            if (runno % 1000 != 0) continue;
            String msg = rdbs.length * 100 + " byte comparisons took " + currenttotalbytetime + " ms and " + rdbs.length + " double comparisons took " + currenttotalstrtime + " ms ";
            System.out.println(msg);
            totalbytetime += currenttotalbytetime;
            totaldbtime += currenttotalstrtime;
            currenttotalbytetime = 0L;
            currenttotalstrtime = 0L;
            if (runno % 1000 != 0) continue;
            System.out.println(runno + " done");
        }
        System.out.println("Byte    T " + totalbytetime);
        System.out.println("Double  T " + totaldbtime);
    }

    private static byte[] getBytes(double d) {
        long bits = Double.doubleToLongBits(d);
        byte[] lb = new byte[8];
        RowFormatter.writeLong((byte[])lb, (long)bits, (int)0);
        return lb;
    }

    public int compareDateBytes(byte[] dtb1, byte[] dtb2) {
        short yr1 = (short)(dtb1[3] << 8 | dtb1[2] & 0xFF);
        short yr2 = (short)(dtb2[3] << 8 | dtb2[2] & 0xFF);
        if (yr1 == yr2) {
            int res = dtb1[1] - dtb2[1];
            return res != 0 ? res : dtb1[0] - dtb2[0];
        }
        return yr1 - yr2;
    }

    public int compareDoubleBytes(byte[] db1, byte[] db2, double d1, double d2) throws Exception {
        long l2;
        long l1 = RowFormatter.readLong((byte[])db1, (int)0);
        if (l1 > (l2 = RowFormatter.readLong((byte[])db2, (int)0))) {
            return 1;
        }
        if (l1 < l2) {
            return -1;
        }
        return 0;
    }

    public int comparebyte(byte b1, byte b2) {
        return b1 == b2 ? 0 : (b1 > b2 ? 1 : -1);
    }

    public int compareDoubles(double d1, double d2) {
        if (d1 == d2) {
            return 0;
        }
        if (d1 > d2) {
            return 1;
        }
        return -1;
    }

    public int compareStringBytes(byte[] sb1, byte[] sb2, String s1, String s2) {
        int remainingLen;
        int posn;
        byte[] remainingString;
        int retvalIfLTSpace;
        int leftlen = sb1.length;
        int rightlen = sb2.length;
        if (sb1 == null || sb2 == null) {
            if (sb1 != null) {
                return -1;
            }
            if (sb2 != null) {
                return 1;
            }
            return 0;
        }
        int shorterLen = leftlen < rightlen ? leftlen : rightlen;
        int ltposn = 0;
        int rtposn = 0;
        while (ltposn < shorterLen && rtposn < shorterLen) {
            int res;
            byte lb = sb1[ltposn];
            byte rb = sb2[rtposn];
            if ((lb & 0x80) == 0) {
                if ((rb & 0x80) == 0) {
                    int res2 = sb1[ltposn] - sb2[rtposn];
                    if (res2 != 0) {
                        return res2;
                    }
                    ++ltposn;
                    ++rtposn;
                    continue;
                }
                return -1;
            }
            if ((lb & 0x60) == 64) {
                byte r2b;
                byte l2b;
                if ((rb & 0x80) == 0) {
                    return 1;
                }
                if ((rb & 0x70) == 96) {
                    return -1;
                }
                if ((res = (l2b = sb1[++ltposn]) - (r2b = sb2[++rtposn])) != 0) {
                    return res;
                }
                res = lb - rb;
                if (res != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((lb & 0x70) != 96) continue;
            if ((rb & 0x80) == 0) {
                return 1;
            }
            if ((rb & 0x60) == 64) {
                return 1;
            }
            byte l3b = sb1[ltposn += 2];
            byte r3b = sb2[rtposn += 2];
            res = l3b - r3b;
            if (res != 0) {
                return res;
            }
            byte l2b = sb1[ltposn - 1];
            byte r2b = sb2[rtposn - 1];
            res = l2b - r2b;
            if (res != 0) {
                return res;
            }
            if (lb != rb) {
                return lb - rb;
            }
            ++ltposn;
            ++rtposn;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (rtposn > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = sb1;
            posn = ltposn;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = sb2;
            posn = rtposn;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            byte remainingChar = remainingString[posn];
            if (remainingChar < 32) {
                return retvalIfLTSpace;
            }
            if (remainingChar > 32) {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    public static String getRandomAlphaNumericString(int pureAscii) {
        char[] userChars;
        block7: {
            int r;
            int pos;
            int strlen;
            Random rand;
            block9: {
                block8: {
                    block6: {
                        rand = PartitionedRegion.rand;
                        strlen = rand.nextInt(65) + 20;
                        int mixby = rand.nextInt(8) + 5;
                        userChars = new char[strlen];
                        int byteoffset = 0;
                        for (int mix = 1; mix < mixby; ++mix) {
                            int nextpart = rand.nextInt(strlen / mixby) + 3;
                            for (int index = byteoffset; index < byteoffset + nextpart && index < strlen; ++index) {
                                userChars[index] = mix % 2 != 0 ? alphabets[rand.nextInt(alphabets.length)] : numerics[rand.nextInt(numerics.length)];
                            }
                            byteoffset += nextpart;
                        }
                        if (pureAscii != 0) break block6;
                        userChars[(ch = strlen - 1 - rand.nextInt((int)(strlen / 2))) < 0 ? 0 : ch] = specials[rand.nextInt(specials.length)];
                        break block7;
                    }
                    if (pureAscii != 1) break block8;
                    r = rand.nextInt(pos + 4);
                    for (pos = rand.nextInt(strlen); pos < r && pos < strlen; ++pos) {
                        userChars[pos] = unicode1[rand.nextInt(unicode1.length)];
                    }
                    break block7;
                }
                if (pureAscii != 2) break block9;
                r = rand.nextInt(pos + 4);
                for (pos = rand.nextInt(strlen); pos < r && pos < strlen; ++pos) {
                    userChars[pos] = unicode2[rand.nextInt(unicode2.length)];
                }
                break block7;
            }
            if (pureAscii != 3) break block7;
            r = rand.nextInt(pos + 4);
            for (pos = rand.nextInt(strlen); pos < r && pos < strlen; ++pos) {
                userChars[pos] = unicode1[rand.nextInt(unicode1.length)];
            }
            r = rand.nextInt(pos + 4);
            for (pos = rand.nextInt(strlen); pos < r && pos < strlen; ++pos) {
                userChars[pos] = unicode2[rand.nextInt(unicode2.length)];
            }
        }
        return String.valueOf(userChars);
    }

    protected String getOffHeapSuffix() {
        return "  ";
    }
}

