/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.pivotal.gemfirexd.BackwardCompatabilityDUnit;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.tools.GfxdUtilLauncher;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.util.TestException;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public abstract class BackwardCompatabilityTestBase
extends DistributedSQLTestBase {
    protected String product;
    protected static final String PRODUCT_SQLFIRE = "SQLFIRE";
    protected static final String PRODUCT_GEMFIREXD = "GEMFIREXD";
    protected final String rollingUpgradeBaseVersion = "1.1.1";
    protected final String rollingUpgradeBaseVersionDir = "sqlfire/releases/SQLFire1.1.1-all";
    protected static final String[][] compatibleVersionLists = new String[][]{{"1.0.2", "1.0.3"}};
    protected static final String[][] compatibleVersionProductDirs = new String[][]{{"sqlfire/102/all", "sqlfire/103/all"}};
    protected static final String bug44988AffectedVersion = "1.0.2";
    protected static final String GCM_WHERE;
    protected static final Pattern ABSOLUTE_PATH_PAT;
    protected int currentListIdx = -1;
    protected int currentVersIdx = -1;
    protected String vm1WorkingDir;
    protected String vm2WorkingDir;
    protected String vm3WorkingDir;
    protected String vm4WorkingDir;
    SerializableCallable getVMWorkingDir = new SerializableCallable("get working directory of this JVM"){

        public Object call() {
            return DistributedSQLTestBase.getSysDirName();
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vm1WorkingDir = (String)Host.getHost((int)0).getVM(0).invoke((Callable)this.getVMWorkingDir);
        this.vm2WorkingDir = (String)Host.getHost((int)0).getVM(1).invoke((Callable)this.getVMWorkingDir);
        this.vm3WorkingDir = (String)Host.getHost((int)0).getVM(2).invoke((Callable)this.getVMWorkingDir);
        this.vm4WorkingDir = (String)Host.getHost((int)0).getVM(3).invoke((Callable)this.getVMWorkingDir);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        String workingDir = BackwardCompatabilityTestBase.getSysDirName();
        if (this.currentListIdx >= 0 && this.currentVersIdx >= 0) {
            try {
                this.stopVersionedServer(this.currentListIdx, this.currentVersIdx, workingDir);
            }
            catch (Exception e) {
                this.getLogWriter().info((Object)("Ignored exception during tearDown stop " + e));
            }
        }
        this.stopAllVMs();
        String[] customStoreDirs = new String[]{this.vm1WorkingDir + "/dir1", this.vm2WorkingDir + "/dir1", this.vm3WorkingDir + "/dir1", this.vm4WorkingDir + "/dir1"};
        this.cleanUpCustomStoreFiles(customStoreDirs);
    }

    public BackwardCompatabilityTestBase(String name) {
        super(name);
    }

    public void waitForProcesses(ProcessStart ... procStarts) throws InterruptedException {
        for (ProcessStart procStart : procStarts) {
            int exitValue = procStart.proc.waitFor();
            if (exitValue == 0) continue;
            String procType = procStart.isLocator ? "locator" : "server";
            procType = procStart.version != null ? procType + " version " + procStart.version : "current version " + procType;
            throw new TestException("Unexpected exit value " + exitValue + " while starting " + procType + ". See logs in " + procStart.logFile + " and start file output.");
        }
    }

    protected void sleepForAsyncLocatorStart(Process locProc, int locPort) throws InterruptedException {
        Thread.sleep(4000L);
        int maxTimes = 20;
        while (maxTimes-- > 0) {
            Thread.sleep(1000L);
            try {
                locProc.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (AvailablePort.isPortAvailable((int)locPort, (int)0)) continue;
            }
            break;
        }
    }

    protected void sleepForAsyncServerStart() throws InterruptedException {
        Thread.sleep(2000L);
    }

    public ProcessStart startCurrentVersionLocator(String directory) throws Exception {
        String utilLauncher = this.getCurrentUtilLauncher();
        int peerDiscoveryPort = AvailablePort.getRandomAvailablePort((int)0);
        this.getLogWriter().info((Object)("Starting current version GEMFIREXD locator from " + directory + " on port " + peerDiscoveryPort + " launcher=" + utilLauncher));
        String logFile = this.getTestLogNamePrefix() + "-locator" + "current" + ".log";
        String[] startOps = null;
        startOps = new String[]{utilLauncher, "locator", "start", "-dir=" + directory, "-run-netserver=false", "-log-file=" + logFile, "-peer-discovery-port=" + peerDiscoveryPort};
        Process serverProc = new ProcessBuilder(startOps).start();
        this.sleepForAsyncLocatorStart(serverProc, peerDiscoveryPort);
        return new ProcessStart(serverProc, peerDiscoveryPort, true, null, logFile);
    }

    public void stopCurrentVersionLocator(String directory) throws Exception {
        String utilLauncher = this.getCurrentUtilLauncher();
        this.getLogWriter().info((Object)("Stopping current version GEMFIREXD locator from " + directory + " launcher=" + utilLauncher));
        String[] startOps = new String[]{utilLauncher, "locator", "stop", "-dir=" + directory};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping current version locator. Trying again."));
            Thread.sleep(5L);
            serverProc = new ProcessBuilder(startOps).start();
            exitValue = serverProc.waitFor();
            if (exitValue != 0) {
                this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping current version locator in " + directory + ". Giving up."));
            }
        }
    }

    public ProcessStart startCurrentVersionServer(String directory, int locatorPort) throws Exception {
        String utilLauncher = this.getCurrentUtilLauncher();
        int clientPort = AvailablePort.getRandomAvailablePort((int)0);
        String logFile = this.getTestLogNamePrefix() + "-server" + "current" + ".log";
        String[] startOps = new String[]{utilLauncher, "server", "start", "-dir=" + directory, "-client-port=" + clientPort, "-log-file=" + logFile, "-locators=localhost[" + locatorPort + "]"};
        this.getLogWriter().info((Object)("Starting current version GEMFIREXD server from " + directory + " on port " + clientPort + " launcher=" + utilLauncher));
        Process serverProc = new ProcessBuilder(startOps).start();
        this.sleepForAsyncServerStart();
        return new ProcessStart(serverProc, clientPort, false, null, logFile);
    }

    public void stopCurrentVersionServer(String directory) throws Exception {
        String utilLauncher = this.getCurrentUtilLauncher();
        this.getLogWriter().info((Object)("Stopping current version GEMFIREXD server from " + directory + " launcher=" + utilLauncher));
        String[] startOps = new String[]{utilLauncher, "server", "stop", "-dir=" + directory};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping current version server. Trying again."));
            Thread.sleep(5L);
            serverProc = new ProcessBuilder(startOps).start();
            exitValue = serverProc.waitFor();
            if (exitValue != 0) {
                this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping current version server in " + directory + ". Giving up."));
            }
        }
    }

    private static String getGFXDVersionDir(String versionDir) {
        return ABSOLUTE_PATH_PAT.matcher(versionDir).find() ? versionDir : GCM_WHERE + '/' + versionDir;
    }

    public ProcessStart startVersionedServer(String version, String versionDir, String workingDir, int mcastPort, int locatorPort, boolean withAuth) throws Exception {
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        int clientPort = AvailablePort.getRandomAvailablePort((int)0);
        String logFile = this.getTestLogNamePrefix() + "-server" + version + ".log";
        String[] startOps = locatorPort > 0 ? (withAuth ? new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-locators=localhost[" + locatorPort + "]", "-auth-provider=BUILTIN", "-gemfirexd.sql-authorization=TRUE", "-gemfirexd.user.SYSADMIN=SA", "-user=SYSADMIN", "-password=SA"} : new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-locators=localhost[" + locatorPort + "]"}) : new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-mcast-port=" + mcastPort};
        this.getLogWriter().info((Object)("Starting " + this.product + " server version " + version + " from " + gfxdDir + " on port " + clientPort));
        Process serverProc = new ProcessBuilder(startOps).start();
        this.sleepForAsyncServerStart();
        return new ProcessStart(serverProc, clientPort, false, version, logFile);
    }

    public ProcessStart startVersionedServer(String version, String versionDir, String workingDir, int mcastPort, String locators, boolean withAuth, String persistDD) throws Exception {
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        int clientPort = AvailablePort.getRandomAvailablePort((int)0);
        String logFile = this.getTestLogNamePrefix() + "-server" + version + ".log";
        String[] startOps = locators != null ? (withAuth ? new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-locators=" + locators, "-auth-provider=BUILTIN", "-gemfirexd.sql-authorization=TRUE", "-gemfirexd.user.SYSADMIN=SA", "-user=SYSADMIN", "-password=SA", "-persist-dd=" + persistDD} : new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-locators=" + locators, "-persist-dd=" + persistDD}) : new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-mcast-port=" + mcastPort};
        this.getLogWriter().info((Object)("Starting " + this.product + "server version " + version + " from " + gfxdDir + " on port " + clientPort));
        Process serverProc = new ProcessBuilder(startOps).start();
        this.sleepForAsyncServerStart();
        return new ProcessStart(serverProc, clientPort, false, version, logFile);
    }

    public ProcessStart startVersionedLocator(int listIdx, int verIdx, int checkIdx, String workingDir, boolean withAuth) throws Exception {
        String version = compatibleVersionLists[listIdx][verIdx];
        String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
        String checkVersion = checkIdx >= 0 ? "_" + compatibleVersionLists[listIdx][checkIdx] : "";
        return this.startVersionedLocator(version, versionDir, workingDir, withAuth);
    }

    public ProcessStart startVersionedLocator(String version, String versionDir, String workingDir, boolean withAuth) throws Exception {
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        int peerDiscoveryPort = AvailablePort.getRandomAvailablePort((int)0);
        String logFile = this.getTestLogNamePrefix() + "-locator" + version + ".log";
        Object[] startOps = null;
        startOps = withAuth ? new String[]{utilLauncher, "locator", "start", "-dir=" + workingDir, "-log-file=" + logFile, "-peer-discovery-port=" + peerDiscoveryPort, "-run-netserver=false", "-auth-provider=BUILTIN", "-gemfirexd.sql-authorization=TRUE", "-gemfirexd.user.SYSADMIN=SA", "-user=SYSADMIN", "-password=SA"} : new String[]{utilLauncher, "locator", "start", "-dir=" + workingDir, "-run-netserver=false", "-log-file=" + logFile, "-peer-discovery-port=" + peerDiscoveryPort};
        this.getLogWriter().info((Object)("Starting " + this.product + " locator version " + version + " from " + gfxdDir + " on port " + peerDiscoveryPort + " command-line: " + Arrays.toString(startOps)));
        Process serverProc = new ProcessBuilder((String[])startOps).start();
        this.sleepForAsyncLocatorStart(serverProc, peerDiscoveryPort);
        return new ProcessStart(serverProc, peerDiscoveryPort, true, version, logFile);
    }

    public ProcessStart startVersionedLocator(String version, String versionDir, String workingDir, int peerDiscoveryPort, String locators, boolean withAuth, String persistDD) throws Exception {
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        this.getLogWriter().info((Object)("Starting locator version " + version + " from " + gfxdDir + " on port " + peerDiscoveryPort));
        String logFile = this.getTestLogNamePrefix() + "-locator" + version + ".log";
        String[] startOps = null;
        startOps = withAuth ? new String[]{utilLauncher, "locator", "start", "-dir=" + workingDir, "-log-file=" + logFile, "-peer-discovery-port=" + peerDiscoveryPort, "-run-netserver=false", "-auth-provider=BUILTIN", "-gemfirexd.sql-authorization=TRUE", "-gemfirexd.user.SYSADMIN=SA", "-locators=" + locators, "-user=SYSADMIN", "-password=SA", "-persist-dd=" + persistDD} : new String[]{utilLauncher, "locator", "start", "-dir=" + workingDir, "-run-netserver=false", "-locators=" + locators, "-log-file=" + logFile, "-peer-discovery-port=" + peerDiscoveryPort, "-persist-dd=" + persistDD};
        Process serverProc = new ProcessBuilder(startOps).start();
        this.sleepForAsyncLocatorStart(serverProc, peerDiscoveryPort);
        return new ProcessStart(serverProc, peerDiscoveryPort, true, version, logFile);
    }

    protected void shutdownAll(int listIdx, int verIdx, int locatorPort) throws Exception {
        String version = compatibleVersionLists[listIdx][verIdx];
        String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        String[] startOps = new String[]{utilLauncher, "shut-down-all", "-locators=localhost[" + locatorPort + "]"};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " during shut-down-all for version " + version + '.');
        }
    }

    public void stopVersionedLocator(int listIdx, int verIdx, String workingDir) throws Exception {
        String version = compatibleVersionLists[listIdx][verIdx];
        String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
        this.stopVersionedLocator(version, versionDir, workingDir);
    }

    public void stopVersionedLocator(String version, String versionDir, String workingDir) throws Exception {
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        this.getLogWriter().info((Object)("Stopping locator version " + version + " from " + gfxdDir));
        String[] startOps = new String[]{utilLauncher, "locator", "stop", "-dir=" + workingDir};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping locator version " + version + ". Trying again."));
            Thread.sleep(5L);
            serverProc = new ProcessBuilder(startOps).start();
            exitValue = serverProc.waitFor();
            if (exitValue != 0) {
                this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping locator version " + version + " in " + gfxdDir + ". Giving up."));
            }
        }
    }

    public void stopVersionedServer(int listIdx, int verIdx, String workingDir) throws Exception {
        String version = compatibleVersionLists[listIdx][verIdx];
        String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
        this.stopVersionedServer(version, versionDir, workingDir);
    }

    public void stopVersionedServer(String version, String versionDir, String workingDir) throws Exception {
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        this.getLogWriter().info((Object)("Stopping server version " + version + " from " + gfxdDir));
        String[] startOps = new String[]{utilLauncher, "server", "stop", "-dir=" + workingDir};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping server version " + version + ". Trying again."));
            Thread.sleep(5L);
            serverProc = new ProcessBuilder(startOps).start();
            exitValue = serverProc.waitFor();
            if (exitValue != 0) {
                this.getLogWriter().error((Object)("Unexpected exit value " + exitValue + " while stopping server version " + version + " in " + gfxdDir + ". Giving up."));
            }
        }
    }

    public ProcessStart startVersionedServerSG(String version, String versionDir, String workingDir, int mcastPort, int locatorPort, boolean withAuth, String serverGroups) throws Exception {
        String gfxdDir = BackwardCompatabilityTestBase.getGFXDVersionDir(versionDir);
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        int clientPort = AvailablePort.getRandomAvailablePort((int)0);
        String logFile = this.getTestLogNamePrefix() + "-server" + version + ".log";
        String[] startOps = locatorPort > 0 ? (withAuth ? new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-locators=localhost[" + locatorPort + "]", "-auth-provider=BUILTIN", "-gemfirexd.sql-authorization=TRUE", "-gemfirexd.user.SYSADMIN=SA", "-user=SYSADMIN", "-password=SA", "-server-groups=" + serverGroups, "-sync=false"} : new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-locators=localhost[" + locatorPort + "]", "-server-groups=" + serverGroups, "-sync=false"}) : new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-client-port=" + clientPort, "-log-file=" + logFile, "-mcast-port=" + mcastPort, "-server-groups=" + serverGroups, "-sync=false"};
        this.getLogWriter().info((Object)("Starting server version " + version + " from " + gfxdDir + " on port " + clientPort + " -server-groups=" + serverGroups));
        Process serverProc = new ProcessBuilder(startOps).start();
        this.sleepForAsyncServerStart();
        return new ProcessStart(serverProc, clientPort, false, version, logFile);
    }

    protected void doWithVersionedClient(String product, String version, String versionDir, int clientPort, String doWhat) throws Exception {
        this.doWithVersionedClient(product, version, versionDir, clientPort, doWhat, false);
    }

    protected void doWithVersionedClient(String product, String version, String versionDir, int clientPort, String doWhat, boolean useSQLFireUrl) throws Exception {
        String clientJar = this.getClientJarPath(product, versionDir);
        ArrayList<String> javaCommandLine = new ArrayList<String>();
        File javaBinDir = new File(System.getProperty("java.home"), "bin");
        File javaCommand = new File(javaBinDir, "java");
        javaCommandLine.add(javaCommand.getPath());
        javaCommandLine.add("-classpath");
        javaCommandLine.add(clientJar + File.pathSeparator + System.getenv("JUNIT_JAR") + File.pathSeparator + TestUtil.getResourcesDir());
        javaCommandLine.add(BackwardCompatabilityDUnit.ProductClient.class.getName());
        javaCommandLine.add(product);
        String host = "localhost";
        javaCommandLine.add(host);
        javaCommandLine.add(String.valueOf(clientPort));
        javaCommandLine.add(clientJar);
        javaCommandLine.add(Boolean.toString(useSQLFireUrl));
        javaCommandLine.add(doWhat);
        System.out.println("Starting: " + javaCommandLine);
        ProcessBuilder builder = new ProcessBuilder(javaCommandLine.toArray(new String[javaCommandLine.size()]));
        int[] exitValue = new int[]{-1};
        builder.redirectErrorStream(true);
        Process clientProc = builder.start();
        String clientOut = TestUtil.getProcessOutput(clientProc, 0, 90000, exitValue);
        System.out.println("Output from ProductClient using client " + clientJar + " : " + clientOut);
        if (exitValue[0] != 0) {
            throw new TestException("Unexpected exit value " + exitValue[0] + " while running client version " + version + ", OUTPUT=\n" + clientOut);
        }
    }

    protected void runVersionedClient(int listIdx, int verIdx, String host, int clientPort, int numOpsInBatch, int maxWaitMillis) throws Exception {
        String version = compatibleVersionLists[listIdx][verIdx];
        String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
        String gfxdclientJar = GCM_WHERE + '/' + versionDir + "/product-gfxd/lib/gemfirexd-client.jar";
        this.getLogWriter().info((Object)("Running client version " + version + " from " + gfxdclientJar));
        ArrayList<String> javaCommandLine = new ArrayList<String>();
        File javaBinDir = new File(System.getProperty("java.home"), "bin");
        File javaCommand = new File(javaBinDir, "java");
        javaCommandLine.add(javaCommand.getPath());
        javaCommandLine.add("-classpath");
        javaCommandLine.add(gfxdclientJar + File.pathSeparator + System.getProperty("java.class.path"));
        javaCommandLine.add(BackwardCompatabilityDUnit.ClientRun.class.getName());
        javaCommandLine.add(host);
        javaCommandLine.add(String.valueOf(clientPort));
        javaCommandLine.add(String.valueOf(numOpsInBatch));
        javaCommandLine.add(gfxdclientJar);
        this.getLogWriter().info((Object)("Starting: " + javaCommandLine));
        Process clientProc = new ProcessBuilder(javaCommandLine.toArray(new String[javaCommandLine.size()])).start();
        int[] exitValue = new int[]{-1};
        String clientOut = TestUtil.getProcessOutput(clientProc, 0, maxWaitMillis, exitValue);
        this.getLogWriter().info((Object)("Output from ClientRun using client " + gfxdclientJar + " : " + clientOut));
        if (exitValue[0] != 0) {
            throw new TestException("Unexpected exit value " + exitValue[0] + " while running client version " + version);
        }
    }

    protected void runUpgradeDiskStore(String storeName, String[] dirs) throws Exception {
        for (String dir : dirs) {
            this.getLogWriter().info((Object)("Upgrading diskstore " + storeName + " from " + dir));
            String[] utilLauncherArgs = new String[]{"upgrade-disk-store", storeName, dir};
            GfxdUtilLauncher.main((String[])utilLauncherArgs);
        }
    }

    protected String getClientJarPath(String product, String versionDir) throws Exception {
        String clientJar = null;
        if (product == null) {
            throw new Exception("Test error: PRODUCT must be set");
        }
        if (product.equals(PRODUCT_SQLFIRE)) {
            clientJar = GCM_WHERE + "/" + versionDir + "/product-sqlf/lib/sqlfireclient.jar";
        } else if (product.equals(PRODUCT_GEMFIREXD)) {
            clientJar = GCM_WHERE + "/" + versionDir + "/product-gfxd/lib/gemfirexd-client.jar";
        } else {
            throw new Exception("Unknown value for PRODUCT");
        }
        return clientJar;
    }

    protected String getCurrentUtilLauncher() {
        String productPath = System.getenv(PRODUCT_GEMFIREXD);
        NativeCalls nc = NativeCalls.getInstance();
        boolean isWindows = nc.getOSType().isWindows();
        if (productPath != null) {
            if (isWindows) {
                return productPath + "/bin/gfxd.bat";
            }
            return productPath + "/bin/gfxd";
        }
        String jtestsDir = System.getProperty("JTESTS");
        String basePath = jtestsDir.replace("tests/classes", "");
        return this.getUtilLauncher(basePath);
    }

    protected String getUtilLauncher(String gfxdDir) {
        NativeCalls nc = NativeCalls.getInstance();
        String prod = "gfxd";
        if (this.product != null && this.product.equals(PRODUCT_SQLFIRE)) {
            prod = "sqlf";
        }
        if (nc.getOSType().isWindows()) {
            BackwardCompatabilityTestBase.fail((String)"Windows is currently not supported. See bug #51624");
            return gfxdDir + "/product-" + prod + "/bin/" + prod + ".bat";
        }
        return gfxdDir + "/product-" + prod + "/bin/" + prod;
    }

    protected Connection getNetConnection(String host, int port, Properties props) throws Exception {
        TestUtil.loadNetDriver();
        Connection conn = null;
        if (props == null) {
            props = new Properties();
        }
        int attempts = 1;
        while (true) {
            try {
                this.getLogWriter().info((Object)("getNetConnection:attempt-" + attempts));
                String url = "jdbc:gemfirexd://";
                conn = DriverManager.getConnection(url + host + ":" + port, props);
                this.getLogWriter().info((Object)("getNetConnection::client connection created with isolation level=" + conn.getTransactionIsolation() + " and autocommit=" + conn.getAutoCommit()));
            }
            catch (SQLException e) {
                if (attempts++ < 10 && e.getSQLState().startsWith("08")) {
                    Thread.sleep(1000L);
                    continue;
                }
                throw e;
            }
            break;
        }
        return conn;
    }

    protected void cleanUpCustomStoreFiles(String[] dirs) {
        for (String dir : dirs) {
            File d = new File(dir);
            TestUtil.deleteDir(d);
        }
    }

    protected void deleteDefaultDiskStoreFiles(String workingDir) {
        File[] persistFiles = new File(workingDir).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("BACKUPGFXD-");
            }
        });
        if (persistFiles == null) {
            return;
        }
        for (File f : persistFiles) {
            f.delete();
        }
    }

    protected void cleanUp(String[] dirs) {
        BackwardCompatabilityTestBase.deleteDataDictionaryDir();
        this.deleteDefaultDiskStoreFiles(BackwardCompatabilityTestBase.getSysDirName());
        for (String dirName : dirs) {
            File dir = new File(dirName + "/datadictionary");
            TestUtil.deleteDir(dir);
            this.deleteDefaultDiskStoreFiles(dirName);
        }
    }

    static {
        ABSOLUTE_PATH_PAT = Pattern.compile("^/|([a-zA-Z]:)");
        String gcmdir = System.getenv("GCMDIR");
        if (gcmdir == null || gcmdir.length() == 0) {
            gcmdir = "/gcm";
        }
        GCM_WHERE = gcmdir + "/where";
    }

    public static final class ProcessStart {
        public final Process proc;
        public final int port;
        public final boolean isLocator;
        public final String version;
        public final String logFile;

        public ProcessStart(Process proc, int port, boolean isLocator, String version, String logFile) {
            this.proc = proc;
            this.logFile = logFile;
            this.isLocator = isLocator;
            this.port = port;
            this.version = version;
        }
    }
}

