/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.pivotal.gemfirexd.BackwardCompatabilityTestBase;
import com.pivotal.gemfirexd.TestUtil;
import io.snappydata.test.util.TestException;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import org.junit.Assert;

public class BackwardCompatabilityPart3DUnit
extends BackwardCompatabilityTestBase {
    public BackwardCompatabilityPart3DUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testDummy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Bug51465testBugs_50076_50136() throws Exception {
        String[] versions = new String[]{"1.1.1", "1.1.2"};
        String[] versionDirs = new String[]{"sqlfire/releases/SQLFire1.1.1-all", "sqlfire/releases/SQLFire1.1.2-all"};
        for (int i = 0; i < versions.length; ++i) {
            String version = versions[i];
            String versionDir = versionDirs[i];
            this.getLogWriter().info((Object)("Testing with SQLFire-" + version));
            String currentDir = BackwardCompatabilityPart3DUnit.getSysDirName();
            String locatorDir = currentDir + "/locatorDir";
            String serverOneDir = currentDir + "/serverOneDir";
            String serverTwoDir = currentDir + "/serverTwoDir";
            String serverThreeDir = currentDir + "/serverThreeDir";
            String serverFourDir = currentDir + "/serverFourDir";
            new File(locatorDir).mkdirs();
            new File(serverOneDir).mkdirs();
            new File(serverTwoDir).mkdirs();
            new File(serverThreeDir).mkdirs();
            new File(serverFourDir).mkdirs();
            try {
                this.product = "SQLFIRE";
                this.getLogWriter().info((Object)("Starting locator version: " + version + " with working dir: " + locatorDir));
                BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator(version, versionDir, locatorDir, false);
                int baseVersionLocatorPort = versionedLocator.port;
                this.getLogWriter().info((Object)"Starting earlier version servers");
                BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(version, versionDir, serverOneDir, -1, baseVersionLocatorPort, false);
                int clientPort1 = versionedServer1.port;
                BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(version, versionDir, serverTwoDir, -1, baseVersionLocatorPort, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer3 = this.startVersionedServer(version, versionDir, serverThreeDir, -1, baseVersionLocatorPort, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer4 = this.startVersionedServer(version, versionDir, serverFourDir, -1, baseVersionLocatorPort, false);
                this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2, versionedServer3, versionedServer4);
                this.doWithVersionedClient("SQLFIRE", version, versionDir, clientPort1, "createDataForClient");
            }
            finally {
                this.getLogWriter().info((Object)"Stopping earlier version servers");
                this.stopVersionedServer(version, versionDir, serverOneDir);
                this.stopVersionedServer(version, versionDir, serverTwoDir);
                this.stopVersionedServer(version, versionDir, serverThreeDir);
                this.stopVersionedServer(version, versionDir, serverFourDir);
                this.getLogWriter().info((Object)"Stopping earlier version locator");
                this.stopVersionedLocator(version, versionDir, locatorDir);
            }
            this.getLogWriter().info((Object)("VM WORKING DIRS:" + serverOneDir + "," + serverTwoDir + "," + serverThreeDir + "," + serverFourDir + "," + locatorDir));
            String[] storeDirs = new String[]{locatorDir, serverOneDir, serverTwoDir, serverThreeDir, serverFourDir};
            String[] customDSDirs = new String[]{serverOneDir, serverTwoDir, serverThreeDir, serverFourDir};
            String[] ddDirs = new String[]{locatorDir + "/datadictionary", serverOneDir + "/datadictionary", serverTwoDir + "/datadictionary", serverThreeDir + "/datadictionary", serverFourDir + "/datadictionary"};
            this.getLogWriter().info((Object)"Upgrading disk stores");
            this.runUpgradeDiskStore("SQLF-DEFAULT-DISKSTORE", storeDirs);
            this.runUpgradeDiskStore("CUSTOMDS", customDSDirs);
            this.runUpgradeDiskStore("SQLF-DD-DISKSTORE", ddDirs);
            try {
                this.getLogWriter().info((Object)"Starting current version locator");
                this.product = "GEMFIREXD";
                BackwardCompatabilityTestBase.ProcessStart currentLocator = this.startCurrentVersionLocator(locatorDir);
                int currentVersionLocatorPort = currentLocator.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer1 = this.startCurrentVersionServer(serverOneDir, currentVersionLocatorPort);
                BackwardCompatabilityTestBase.ProcessStart currentServer2 = this.startCurrentVersionServer(serverTwoDir, currentVersionLocatorPort);
                int clientPort = currentServer2.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer3 = this.startCurrentVersionServer(serverThreeDir, currentVersionLocatorPort);
                int anotherClientPort = currentServer3.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer4 = this.startCurrentVersionServer(serverFourDir, currentVersionLocatorPort);
                this.waitForProcesses(currentLocator, currentServer1, currentServer2, currentServer3, currentServer4);
                Properties props = new Properties();
                props.put("load-balance", "false");
                Connection connection = this.getNetConnection("localhost", clientPort, props);
                Connection anotherConnection = this.getNetConnection("localhost", anotherClientPort, props);
                Statement gfxdSt = connection.createStatement();
                Statement anotherGfxdSt = anotherConnection.createStatement();
                this.getLogWriter().info((Object)"Creating tables");
                gfxdSt.execute("create table t1_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t2_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) colocate with (t1_temp) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t3_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                anotherGfxdSt.execute("create table t4_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                anotherGfxdSt.execute("create table t5_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                try {
                    this.getLogWriter().info((Object)"Verifying bug #50136");
                    gfxdSt.execute("create index idx1_t1_temp on t1_temp(id2, id1)");
                    gfxdSt.execute("create index idx2_t1_temp on t1_temp(id1, ts)");
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)("EXCEPTION=" + e));
                    Assert.fail((String)("Exception while creating index:" + e));
                }
                this.getLogWriter().info((Object)"Inserting data");
                PreparedStatement gfxdPs = connection.prepareStatement("insert into t1_temp values(?,?,?,?)");
                for (int j = 0; j < 5; ++j) {
                    int id = j * 100;
                    gfxdPs.setString(1, String.valueOf(id));
                    gfxdPs.setInt(2, id);
                    gfxdPs.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    gfxdPs.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                    gfxdPs.execute();
                }
                gfxdPs.close();
                PreparedStatement gfxdPs2 = connection.prepareStatement("insert into t2_temp values(?,?,?,?)");
                for (int k = 0; k < 5; ++k) {
                    int id = k * 100;
                    gfxdPs2.setString(1, String.valueOf(id));
                    gfxdPs2.setInt(2, id);
                    gfxdPs2.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    gfxdPs2.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                    gfxdPs2.execute();
                }
                gfxdPs2.close();
                try {
                    this.getLogWriter().info((Object)"Verifying bug #50076 - table qualified");
                    gfxdSt.execute("select count(*) from app.t1 outertable where outertable.id1 in (select id1 from t1_temp)");
                    ResultSet rs = gfxdSt.getResultSet();
                    rs.next();
                    int count = rs.getInt(1);
                    this.getLogWriter().info((Object)("COUNT=" + count));
                    BackwardCompatabilityPart3DUnit.assertEquals((int)5, (int)count);
                    this.getLogWriter().info((Object)"Firing the query with IN clause");
                    gfxdSt.execute("select count(*) from t1 outertable where outertable.id1 in (select id1 from t1_temp)");
                    rs = gfxdSt.getResultSet();
                    rs.next();
                    count = rs.getInt(1);
                    this.getLogWriter().info((Object)("COUNT=" + count));
                    BackwardCompatabilityPart3DUnit.assertEquals((int)5, (int)count);
                    gfxdSt.execute("select count(*) from t1 outertable where outertable.id1 NOT in (select id1 from t1_temp)");
                    rs = gfxdSt.getResultSet();
                    rs.next();
                    count = rs.getInt(1);
                    this.getLogWriter().info((Object)("COUNT=" + count));
                    BackwardCompatabilityPart3DUnit.assertEquals((int)0, (int)count);
                }
                catch (SQLException e) {
                    this.getLogWriter().info((Object)("EXCEPTION=" + e));
                    Assert.fail((String)("Exception during query:" + e));
                }
                gfxdSt.close();
                anotherGfxdSt.close();
                connection.close();
                anotherConnection.close();
                this.getLogWriter().info((Object)"Restarting current version servers and locator");
                this.stopCurrentVersionServer(serverOneDir);
                this.stopCurrentVersionServer(serverTwoDir);
                this.stopCurrentVersionServer(serverThreeDir);
                this.stopCurrentVersionServer(serverFourDir);
                this.stopCurrentVersionLocator(locatorDir);
                BackwardCompatabilityTestBase.ProcessStart currentLocator_1 = this.startCurrentVersionLocator(locatorDir);
                int newLocatorPort = currentLocator_1.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer1_1 = this.startCurrentVersionServer(serverOneDir, newLocatorPort);
                int newPort = currentServer1_1.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer2_1 = this.startCurrentVersionServer(serverTwoDir, newLocatorPort);
                int anotherNewPort = currentServer2_1.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer3_1 = this.startCurrentVersionServer(serverThreeDir, newLocatorPort);
                BackwardCompatabilityTestBase.ProcessStart currentServer4_1 = this.startCurrentVersionServer(serverFourDir, newLocatorPort);
                this.waitForProcesses(currentLocator_1, currentServer1_1, currentServer2_1, currentServer3_1, currentServer4_1);
                Connection newConn = this.getNetConnection("localhost", newPort, props);
                Connection anotherNewConn = this.getNetConnection("localhost", anotherNewPort, props);
                Statement newSt = newConn.createStatement();
                Statement anotherNewSt = anotherNewConn.createStatement();
                this.getLogWriter().info((Object)"Creating some more tables");
                newSt.execute("create table t6_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                newSt.execute("create table t7_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                anotherNewSt.execute("create table t8_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                anotherNewSt.execute("create table t9_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                try {
                    this.getLogWriter().info((Object)"Verifying bug #50136 again");
                    newSt.execute("create index idx1_t6_temp on t6_temp(id2, id1)");
                    newSt.execute("create index idx2_t6_temp on t6_temp(id1, ts)");
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)("EXCEPTION=" + e));
                    Assert.fail((String)("Exception while creating index:" + e));
                }
                try {
                    this.getLogWriter().info((Object)"Verifying bug #50076 again");
                    newSt.execute("select count(*) from t1 outertable where outertable.id1 in (select id1 from t7_temp)");
                    ResultSet rs = newSt.getResultSet();
                    rs.next();
                    int count = rs.getInt(1);
                    this.getLogWriter().info((Object)("COUNT=" + count));
                    BackwardCompatabilityPart3DUnit.assertEquals((int)0, (int)count);
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)("EXCEPTION:" + e));
                    Assert.fail();
                }
                this.getLogWriter().info((Object)"Adding more data");
                PreparedStatement newPs = newConn.prepareStatement("insert into t7_temp values(?,?,?,?)");
                for (int k = 0; k < 5; ++k) {
                    int id = k * 100;
                    newPs.setString(1, String.valueOf(id));
                    newPs.setInt(2, id);
                    newPs.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    newPs.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                    newPs.execute();
                }
                newPs.close();
                this.getLogWriter().info((Object)"Verifying bug #50016 yet again");
                try {
                    newSt.execute("select count(*) from t1 outertable where outertable.id1 in (select id1 from t7_temp)");
                    ResultSet rs = newSt.getResultSet();
                    rs.next();
                    int count = rs.getInt(1);
                    this.getLogWriter().info((Object)("COUNT=" + count));
                    BackwardCompatabilityPart3DUnit.assertEquals((int)5, (int)count);
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)("EXCEPTION:" + e));
                    Assert.fail();
                }
                newSt.close();
                newConn.close();
            }
            catch (Exception e) {
                this.getLogWriter().info((Object)("EXCEPTION:" + e));
            }
            finally {
                this.getLogWriter().info((Object)"Stopping current version servers and locator");
                this.stopCurrentVersionServer(serverOneDir);
                this.stopCurrentVersionServer(serverTwoDir);
                this.stopCurrentVersionServer(serverThreeDir);
                this.stopCurrentVersionServer(serverFourDir);
                this.stopCurrentVersionLocator(locatorDir);
                this.product = null;
            }
            this.cleanUpCustomStoreFiles(storeDirs);
        }
    }

    public void DISABLED_testBug48761() throws Exception {
        String locatorPath = BackwardCompatabilityPart3DUnit.getSysDirName() + "/locator48761";
        this.getLogWriter().info((Object)("Creating locator dir for base version: " + locatorPath));
        File rollingVersionLocatorDir = new File(locatorPath);
        BackwardCompatabilityPart3DUnit.assertTrue((boolean)rollingVersionLocatorDir.mkdir());
        String currentBuildDir = System.getProperty("JTESTS") + "/../..";
        this.getLogWriter().info((Object)("currentBuildDir=" + currentBuildDir));
        BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator("", currentBuildDir, locatorPath, false);
        int locatorPort = versionedLocator.port;
        BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServerSG("", currentBuildDir, this.vm1WorkingDir, 0, locatorPort, false, "MYGROUP");
        int clientPort1 = versionedServer1.port;
        BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServerSG("", currentBuildDir, this.vm2WorkingDir, 0, locatorPort, false, "MYGROUP");
        this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2);
        Properties props1 = new Properties();
        props1.setProperty("disable-cancel", "true");
        Connection conn = TestUtil.getNetConnection("localhost", clientPort1, null, props1);
        Statement st = conn.createStatement();
        st.execute("create schema apples");
        st.execute("set schema apples");
        String jarFile = TestUtil.getResourcesDir() + "/lib/callback.jar";
        st.execute("call sqlj.install_jar('" + jarFile + "', 'apples.callbackjar', 0)");
        jarFile = TestUtil.getResourcesDir() + "/lib/myAsyncJar.jar";
        st.execute("call sqlj.install_jar('" + jarFile + "', 'apples.myasyncjar', 0)");
        st.execute("CREATE TABLE command_table (ID INT generated always as identity NOT NULL,  EXECUTE_ON_GEMFIREXD VARCHAR(1) default 'N',  EXECUTE_ON_GREENPLUM VARCHAR(1) default 'Y', command_type varchar(10),  COMMAND VARCHAR(800) not null ) SERVER GROUPS (MYGROUP) partition by (id) redundancy 1");
        st.execute("call sys.ADD_LISTENER ('CommandTableEventCallBackListenerImpl', 'apples', 'command_table', 'gemfirexd.callbacktests.GfxdTestListener', '', 'MYGROUP')");
        st.execute("create table pipe_lookup (table_name varchar(30) primary key, pipe_name varchar(30), external_table varchar(30) ) SERVER GROUPS (MYGROUP)");
        st.execute("CREATE ASYNCEVENTLISTENER GENERICASYNCEVENTLISTENER (LISTENERCLASS 'jarSource.AsyncListener' INITPARAMS '' BATCHSIZE 1000 BATCHTIMEINTERVAL 2000 ENABLEPERSISTENCE false MAXQUEUEMEMORY 100 ) SERVER GROUPS (MYGROUP)");
        st.execute("call SYS.START_ASYNC_EVENT_LISTENER ('GENERICASYNCEVENTLISTENER')");
        String utilLauncher = this.getUtilLauncher(currentBuildDir);
        String[] startOps = new String[]{utilLauncher, "shut-down-all", "-locators=localhost[" + locatorPort + "]"};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " during shut-down-all.");
        }
        Thread.sleep(5000L);
        this.getLogWriter().info((Object)("Stopping locator from " + currentBuildDir));
        startOps = new String[]{utilLauncher, "locator", "stop", "-dir=" + locatorPath};
        serverProc = new ProcessBuilder(startOps).start();
        exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " while stopping locator.");
        }
        versionedLocator = this.startVersionedLocator("", currentBuildDir, locatorPath, false);
        locatorPort = versionedLocator.port;
        versionedServer1 = this.startVersionedServerSG("", currentBuildDir, this.vm1WorkingDir, 0, locatorPort, false, "MYGROUP");
        clientPort1 = versionedServer1.port;
        versionedServer2 = this.startVersionedServerSG("", currentBuildDir, this.vm2WorkingDir, 0, locatorPort, false, "MYGROUP");
        this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2);
        startOps = new String[]{utilLauncher, "shut-down-all", "-locators=localhost[" + locatorPort + "]"};
        serverProc = new ProcessBuilder(startOps).start();
        exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " during shut-down-all.");
        }
        Thread.sleep(5000L);
        this.getLogWriter().info((Object)("Stopping locator from " + currentBuildDir));
        startOps = new String[]{utilLauncher, "locator", "stop", "-dir=" + locatorPath};
        serverProc = new ProcessBuilder(startOps).start();
        exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " while stopping locator.");
        }
    }
}

