/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.pivotal.gemfirexd.BackwardCompatabilityTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.junit.Assert;

public class BackwardCompatabilityPart2DUnit
extends BackwardCompatabilityTestBase {
    private final String myjar = TestUtil.getResourcesDir() + "/lib/myjar.jar";

    public BackwardCompatabilityPart2DUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testDummy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testBug50141() throws Exception {
        String[] versions = new String[]{"1.1.1", "1.1.2"};
        String[] versionDirs = new String[]{"sqlfire/releases/SQLFire1.1.1-all", "sqlfire/releases/SQLFire1.1.2-all"};
        for (int i = 0; i < versions.length; ++i) {
            String version = versions[i];
            String versionDir = versionDirs[i];
            this.getLogWriter().info((Object)("Testing with SQLFire-" + version));
            String currentDir = BackwardCompatabilityPart2DUnit.getSysDirName();
            String locatorDir = currentDir + "/locatorDir";
            String serverOneDir = currentDir + "/serverOneDir";
            String serverTwoDir = currentDir + "/serverTwoDir";
            String serverThreeDir = currentDir + "/serverThreeDir";
            String serverFourDir = currentDir + "/serverFourDir";
            new File(locatorDir).mkdirs();
            new File(serverOneDir).mkdirs();
            new File(serverTwoDir).mkdirs();
            new File(serverThreeDir).mkdirs();
            new File(serverFourDir).mkdirs();
            try {
                this.product = "SQLFIRE";
                this.getLogWriter().info((Object)("Starting locator version: " + version + " with working dir: " + locatorDir));
                BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator(version, versionDir, locatorDir, false);
                int baseVersionLocatorPort = versionedLocator.port;
                this.getLogWriter().info((Object)"Starting earlier version servers");
                BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(version, versionDir, serverOneDir, -1, baseVersionLocatorPort, false);
                int clientPort1 = versionedServer1.port;
                BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(version, versionDir, serverTwoDir, -1, baseVersionLocatorPort, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer3 = this.startVersionedServer(version, versionDir, serverThreeDir, -1, baseVersionLocatorPort, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer4 = this.startVersionedServer(version, versionDir, serverFourDir, -1, baseVersionLocatorPort, false);
                this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2, versionedServer3, versionedServer4);
                this.doWithVersionedClient("SQLFIRE", version, versionDir, clientPort1, "createDataForClient");
            }
            catch (Exception e) {
                this.getLogWriter().info((Object)e);
                Assert.fail((String)("Exception:" + e));
            }
            finally {
                this.getLogWriter().info((Object)"Stopping earlier version servers");
                this.stopVersionedServer(version, versionDir, serverOneDir);
                this.stopVersionedServer(version, versionDir, serverTwoDir);
                this.stopVersionedServer(version, versionDir, serverThreeDir);
                this.stopVersionedServer(version, versionDir, serverFourDir);
                this.getLogWriter().info((Object)"Stopping earlier version locator");
                this.stopVersionedLocator(version, versionDir, locatorDir);
            }
            this.getLogWriter().info((Object)("VM WORKING DIRS:" + serverOneDir + "," + serverTwoDir + "," + serverThreeDir + "," + serverFourDir + "," + locatorDir));
            String[] storeDirs = new String[]{locatorDir, serverOneDir, serverTwoDir, serverThreeDir, serverFourDir};
            String[] customDSDirs = new String[]{serverOneDir, serverTwoDir, serverThreeDir, serverFourDir};
            String[] ddDirs = new String[]{locatorDir + "/datadictionary", serverOneDir + "/datadictionary", serverTwoDir + "/datadictionary", serverThreeDir + "/datadictionary", serverFourDir + "/datadictionary"};
            this.getLogWriter().info((Object)"Upgrading disk stores");
            this.runUpgradeDiskStore("SQLF-DEFAULT-DISKSTORE", storeDirs);
            this.runUpgradeDiskStore("CUSTOMDS", customDSDirs);
            this.runUpgradeDiskStore("SQLF-DD-DISKSTORE", ddDirs);
            try {
                this.getLogWriter().info((Object)"Starting current version locator");
                this.product = "GEMFIREXD";
                BackwardCompatabilityTestBase.ProcessStart currentLocator = this.startCurrentVersionLocator(locatorDir);
                int currentVersionLocatorPort = currentLocator.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer1 = this.startCurrentVersionServer(serverOneDir, currentVersionLocatorPort);
                int clientPort = currentServer1.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer2 = this.startCurrentVersionServer(serverTwoDir, currentVersionLocatorPort);
                BackwardCompatabilityTestBase.ProcessStart currentServer3 = this.startCurrentVersionServer(serverThreeDir, currentVersionLocatorPort);
                BackwardCompatabilityTestBase.ProcessStart currentServer4 = this.startCurrentVersionServer(serverFourDir, currentVersionLocatorPort);
                this.waitForProcesses(currentLocator, currentServer1, currentServer2, currentServer3, currentServer4);
                Properties props = new Properties();
                props.put("load-balance", "false");
                Connection connection = this.getNetConnection("localhost", clientPort, new Properties());
                Statement gfxdSt = connection.createStatement();
                this.getLogWriter().info((Object)"Creating tables");
                gfxdSt.execute("create table t1_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t2_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) colocate with (t1_temp) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t3_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                ResultSet metadataRs = connection.getMetaData().getTables(null, "APP", "T1_TEMP", null);
                boolean foundTable = false;
                while (metadataRs.next()) {
                    foundTable = metadataRs.getString(3).equalsIgnoreCase("T1_TEMP") && metadataRs.getString(2).equalsIgnoreCase("APP");
                    BackwardCompatabilityPart2DUnit.assertTrue((boolean)foundTable);
                }
                metadataRs.close();
                try {
                    this.getLogWriter().info((Object)"Testing for Bug #50141");
                    this.getLogWriter().info((Object)"Attempting to drop table t2_temp");
                    gfxdSt.execute("drop table t2_temp");
                    this.getLogWriter().info((Object)"Attempting to drop table t1_temp");
                    gfxdSt.execute("drop table t1_temp");
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)e);
                    throw e;
                }
                this.getLogWriter().info((Object)"Verifying that the tables are deleted");
                metadataRs = connection.getMetaData().getTables(null, "APP", "T1_TEMP", null);
                foundTable = false;
                while (metadataRs.next()) {
                    foundTable = metadataRs.getString(3).equalsIgnoreCase("T1_TEMP") && metadataRs.getString(2).equalsIgnoreCase("APP");
                    BackwardCompatabilityPart2DUnit.assertFalse((boolean)foundTable);
                }
                metadataRs = connection.getMetaData().getTables(null, "APP", "T2_TEMP", null);
                foundTable = false;
                while (metadataRs.next()) {
                    foundTable = metadataRs.getString(3).equalsIgnoreCase("T2_TEMP") && metadataRs.getString(2).equalsIgnoreCase("APP");
                    BackwardCompatabilityPart2DUnit.assertFalse((boolean)foundTable);
                }
                gfxdSt.close();
            }
            catch (Exception e) {
                this.getLogWriter().info((Object)("EXCEPTION:" + e));
            }
            finally {
                this.getLogWriter().info((Object)"Stopping current version servers and locator");
                this.stopCurrentVersionServer(serverOneDir);
                this.stopCurrentVersionServer(serverTwoDir);
                this.stopCurrentVersionServer(serverThreeDir);
                this.stopCurrentVersionServer(serverFourDir);
                this.stopCurrentVersionLocator(locatorDir);
                this.product = null;
            }
            this.cleanUpCustomStoreFiles(storeDirs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testBug50233() throws Exception {
        boolean isWindows = NativeCalls.getInstance().getOSType().isWindows();
        String[] prevVersions = new String[]{"1.0", "1.3.1"};
        String[] prevVersionDirs = new String[]{isWindows ? null : "gemfireXD/releases/GemFireXD1.0.0-all", isWindows ? "gemfireXD/releases/GemFireXD1.3.1-all/Windows_NT" : "gemfireXD/releases/GemFireXD1.3.1-all/Linux"};
        String[] products = new String[]{"GEMFIREXD", "GEMFIREXD"};
        String currentDir = BackwardCompatabilityPart2DUnit.getSysDirName();
        String locatorDir = currentDir + "/locatorDir";
        String serverOneDir = currentDir + "/serverOneDir";
        String serverTwoDir = currentDir + "/serverTwoDir";
        String serverThreeDir = currentDir + "/serverThreeDir";
        String serverFourDir = currentDir + "/serverFourDir";
        for (int v = 0; v < prevVersions.length; ++v) {
            String prevVersion = prevVersions[v];
            String prevVersionDir = prevVersionDirs[v];
            this.product = products[v];
            if (prevVersionDir == null) continue;
            new File(locatorDir).mkdirs();
            new File(serverOneDir).mkdirs();
            new File(serverTwoDir).mkdirs();
            new File(serverThreeDir).mkdirs();
            new File(serverFourDir).mkdirs();
            String[] dirs = new String[]{locatorDir, serverOneDir, serverTwoDir, serverThreeDir, serverFourDir};
            try {
                BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator(prevVersion, prevVersionDir, locatorDir, false);
                int baseVersionLocatorPort = versionedLocator.port;
                BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(prevVersion, prevVersionDir, serverOneDir, -1, baseVersionLocatorPort, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(prevVersion, prevVersionDir, serverTwoDir, -1, baseVersionLocatorPort, false);
                this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2);
                BackwardCompatabilityTestBase.ProcessStart currentServer1 = this.startCurrentVersionServer(serverThreeDir, baseVersionLocatorPort);
                int clientPort1 = currentServer1.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer2 = this.startCurrentVersionServer(serverFourDir, baseVersionLocatorPort);
                this.waitForProcesses(currentServer1, currentServer2);
                Properties props = new Properties();
                props.setProperty("disable-cancel", "true");
                props.put("load-balance", "false");
                Connection conn = TestUtil.getNetConnection("localhost", clientPort1, null, props);
                Statement stmt = conn.createStatement();
                stmt.execute("call sqlj.install_jar('" + this.myjar + "', 'app.sample2', 0)");
                String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
                stmt.execute(ddl);
                PreparedStatement ps = conn.prepareStatement("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (?, ?, ?)");
                for (int i = 1; i < 100; ++i) {
                    ps.setInt(1, i);
                    ps.setInt(2, i);
                    ps.setString(3, "" + i);
                    ps.execute();
                }
                stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
                stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
                String sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE";
                CallableStatement cs = conn.prepareCall(sql);
                cs.execute();
                cs.getResultSet();
                cs.close();
                continue;
            }
            catch (Exception e) {
                this.getLogWriter().info((Object)e);
                Assert.fail((String)("EXCEPTION=" + e));
                continue;
            }
            finally {
                this.stopVersionedServer(prevVersion, prevVersionDir, serverOneDir);
                this.stopVersionedServer(prevVersion, prevVersionDir, serverTwoDir);
                this.stopCurrentVersionServer(serverThreeDir);
                this.stopCurrentVersionServer(serverFourDir);
                this.stopVersionedLocator(prevVersion, prevVersionDir, locatorDir);
                this.cleanUp(dirs);
                this.product = null;
            }
        }
    }
}

