/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.pivotal.gemfirexd.BackwardCompatabilityTestBase;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.junit.Assert;

public class BackwardCompatabilityDUnit
extends BackwardCompatabilityTestBase {
    private static final String[] DDLS = new String[]{"create table t.t1 (id int, addr varchar(100)) persistent", "create index t.idx1 on t.t1 (id)", "create table t.t2 (id int primary key, addr varchar(100))", "create table t.t3 (id int primary key, addr varchar(100)) persistent partition by primary key", "create table t.t4 (id int, addr varchar(100)) replicate", "drop table t.t4", "create table t.t4 (id int primary key generated always as identity, addr varchar(100)) persistent", "create index t.idx on t.t1 (addr)", "drop index t.idx", "create index t.idx on t.t2 (addr)", "drop index t.idx", "create index t.idx on t.t3 (addr)", "drop index t.idx", "create index t.idx on t.t4 (addr)"};
    private static final String[] DMLS = new String[]{"insert into t.t1 values (?, ?)", "insert into t.t2 values (?, ?)", "insert into t.t3 values (?, ?)", "insert into t.t4 (addr) values (?)"};
    private static final Object[][] TABLES = new Object[][]{{"t.t1", true, 0}, {"t.t2", false, 0}, {"t.t3", true, 0}, {"t.t4", true, 10}};
    private static final String[] INDEXES = new String[]{"t.idx", "t.idx1"};
    private static final String[] DDL_STMTS = ProductClient.access$000();
    private static final String[] DDL_STMTS2 = new String[]{"create schema upgradetest", "create table upgradetest.t1(id int, addr varchar(100))", "drop table upgradetest.t1", "create table upgradetest.t1(id int, addr varchar(100)) persistent", "create index upgradetest.idx_id on upgradetest.t1(id)", "create table upgradetest.t2(id int primary key, addr varchar(100))", "create table upgradetest.t3(id int primary key, addr varchar(100)) persistent", "create index idx_t3_id on upgradetest.t3(id)", "create table upgradetest.t4(id1 int, id2 int, addr varchar(100), constraint t4_pk primary key(id1, id2)) persistent", "create index idx_t4_id1 on upgradetest.t4(id1)", "create index idx_t4_id2 on upgradetest.t4(id2)", "create table upgradetest.t5(id int primary key, addr varchar(100)) persistent", "create table upgradetest.t6(id int primary key, addr varchar(100)) persistent partition by primary key", "create table upgradetest.t7(id1 int primary key, id2 int, addr varchar(100)) persistent partition by column(id2)", "create table upgradetest.t9(id int, clobcol clob(300K), blobcol blob(3K)) persistent", "create table upgradetest.t10(id int primary key, id2 int not null unique, addr varchar(100)) persistent partition by column(addr)", "create table upgradetest.t11(id int, id2 int, addr varchar(100) not null unique) persistent partition by column(id2)", "create table upgradetest.t12(id int primary key generated by default as identity, clobcol clob(300K) not null, blobcol blob(3K)) persistent partition by column(clobcol)"};
    private static final String[] DDL_STMTS_CUSTOM_DISKSTORE = ProductClient.access$100();
    private static final String[] DML_STMTS = ProductClient.access$200();
    private static final String[] DML_STMTS_CUSTOM_DISKSTORE = ProductClient.access$100();
    private static final String[] TABLE_NAMES = ProductClient.access$300();
    private static final String[] TABLE_NAMES_CUSTOM_DISKSTORE = ProductClient.access$400();
    private static final String[] TABLE_NAMES_BUG50794 = ProductClient.access$500();
    private static final String[] ALTER_STMTS = new String[]{"alter table upgradetest.t1 add column newcol varchar(100)", "alter table upgradetest.t1 drop column newcol", "alter table upgradetest.t3 add constraint addr_uk unique(addr)", "alter table upgradetest.t3 drop constraint addr_uk", "alter table upgradetest.t9 add column newcol1 clob(300K)", "alter table upgradetest.t9 add column newcol2 blob(3K)", "alter table upgradetest.t9 drop column newcol1", "alter table upgradetest.t9 drop column newcol2    "};
    static boolean[] remoteCallbackInvoked = new boolean[]{false, false, false, false, false};

    public BackwardCompatabilityDUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    private boolean alterTableWithDataSupported(String version) {
        int firstOrdinal = new Integer(version.substring(0, version.indexOf(".")));
        int lastOrdinal = new Integer(version.substring(version.lastIndexOf(".") + 1));
        if (version.indexOf(".") == version.lastIndexOf(".")) {
            return firstOrdinal >= 1 && lastOrdinal >= 1;
        }
        return firstOrdinal >= 1 && lastOrdinal >= 99;
    }

    public static void runAddData(String[] ddls, String[] dmls) throws SQLException {
        BackwardCompatabilityDUnit.addData(TestUtil.getConnection(), ddls, dmls);
    }

    public static void addData(Connection conn, String[] DDLs, String[] DMLs) throws SQLException {
        ProductClient.addData(conn, DDLs, DMLs);
    }

    public static void runDDLs(Connection conn, String[] DDLs) throws SQLException {
        ProductClient.runDDLs(conn, DDLs);
    }

    public static void runDMLs(Connection conn, String[] DMLs) throws SQLException {
        BackwardCompatabilityDUnit.runDMLs(conn, DMLs, 1);
    }

    public static void runDMLs(Connection conn, String[] DMLs, int startId) throws SQLException {
        ProductClient.runDMLs(conn, DMLs, startId);
    }

    private void setAuthProps(Properties props) {
        props.put("gemfirexd.auth-provider", "BUILTIN");
        props.put("gemfirexd.sql-authorization", "TRUE");
        props.put("gemfirexd.user.SYSADMIN", "SA");
        props.put("user", "SYSADMIN");
        props.put("password", "SA");
    }

    public void DISABLED_testIncrementalProductVersionUpgrade() throws Exception {
        String rollingVersionLocatorPath = BackwardCompatabilityDUnit.getSysDirName() + "/rollingVersionLocatorPath";
        this.getLogWriter().info((Object)("Creating locator dir for base version: " + rollingVersionLocatorPath));
        File rollingVersionLocatorDir = new File(rollingVersionLocatorPath);
        BackwardCompatabilityDUnit.assertTrue((boolean)rollingVersionLocatorDir.mkdir());
        BackwardCompatabilityTestBase.ProcessStart rollingVersionLocator = this.startVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", rollingVersionLocatorPath, false);
        int rollingVersionLocatorPort = rollingVersionLocator.port;
        BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm1WorkingDir, 0, rollingVersionLocatorPort, false);
        int clientPort1 = versionedServer1.port;
        BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm2WorkingDir, 0, rollingVersionLocatorPort, false);
        BackwardCompatabilityTestBase.ProcessStart versionedServer3 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir, 0, rollingVersionLocatorPort, false);
        BackwardCompatabilityTestBase.ProcessStart versionedServer4 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir, 0, rollingVersionLocatorPort, false);
        this.waitForProcesses(rollingVersionLocator, versionedServer1, versionedServer2, versionedServer3, versionedServer4);
        this.getLogWriter().info((Object)"Adding data");
        Properties props1 = new Properties();
        props1.setProperty("disable-cancel", "true");
        Connection conn = TestUtil.getNetConnection("localhost", clientPort1, null, props1);
        BackwardCompatabilityDUnit.addData(conn, DDL_STMTS2, DML_STMTS);
        BackwardCompatabilityDUnit.addData(conn, DDL_STMTS_CUSTOM_DISKSTORE, DML_STMTS_CUSTOM_DISKSTORE);
        if (this.alterTableWithDataSupported("1.1.1")) {
            this.getLogWriter().info((Object)"Running alter statements on server version 1.1.1");
            BackwardCompatabilityDUnit.runDDLs(conn, ALTER_STMTS);
        }
        conn.close();
        this.getLogWriter().info((Object)"Stopping first 1.1.1server");
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm1WorkingDir);
        Properties props = new Properties();
        props.setProperty("table-default-partitioned", "false");
        props.setProperty("locators", SocketCreator.getLocalHost().getHostAddress() + '[' + rollingVersionLocatorPort + ']');
        this.getLogWriter().info((Object)"Starting current version server");
        this.startServerVMs(1, 0, null, props);
        this.getLogWriter().info((Object)"Stopping second 1.1.1 server");
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm2WorkingDir);
        this.getLogWriter().info((Object)"Starting current version server");
        this.startServerVMs(1, 0, null, props);
        this.getLogWriter().info((Object)"Stopping third 1.1.1 server");
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir);
        this.getLogWriter().info((Object)"Starting current version server");
        this.startServerVMs(1, 0, null, props);
        this.getLogWriter().info((Object)"Stopping fourth 1.1.1server");
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir);
        this.getLogWriter().info((Object)"Starting current version server");
        this.startServerVMs(1, 0, null, props);
        this.getLogWriter().info((Object)"Verifying data");
        VM vm1 = Host.getHost((int)0).getVM(0);
        vm1.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES});
        vm1.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES_CUSTOM_DISKSTORE});
        this.stopAllVMs();
        this.restartVMNums(new int[]{-1, -2, -3, -4}, 0, null, props);
        this.getLogWriter().info((Object)"Verifying data");
        vm1.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES});
        vm1.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES_CUSTOM_DISKSTORE});
        this.stopVMNums(-1, -2, -3, -4);
        this.stopVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", rollingVersionLocatorPath);
        String[] customStoreDirs = new String[]{this.vm1WorkingDir + "/dir1", this.vm2WorkingDir + "/dir1", this.vm3WorkingDir + "/dir1", this.vm4WorkingDir + "/dir1"};
        this.cleanUpCustomStoreFiles(customStoreDirs);
        String[] defaultStoreDirs = new String[]{this.vm1WorkingDir, this.vm2WorkingDir, this.vm3WorkingDir, this.vm4WorkingDir};
        this.cleanUp(defaultStoreDirs);
    }

    public void DISABLED_MERGE_testUpgradeDiskStoreWithMultipleServers() throws Exception {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        boolean restartVMs = false;
        for (int listIdx = 0; listIdx < compatibleVersionLists.length; ++listIdx) {
            String[] compatibleVersions = compatibleVersionLists[listIdx];
            for (int verIdx = 0; verIdx < compatibleVersions.length; ++verIdx) {
                String version = compatibleVersionLists[listIdx][verIdx];
                String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
                this.getLogWriter().info((Object)"Starting earlier version servers");
                BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(version, versionDir, this.vm1WorkingDir, mcastPort, 0, false);
                int clientPort1 = versionedServer1.port;
                BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(version, versionDir, this.vm2WorkingDir, mcastPort, 0, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer3 = this.startVersionedServer(version, versionDir, this.vm3WorkingDir, mcastPort, 0, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer4 = this.startVersionedServer(version, versionDir, this.vm4WorkingDir, mcastPort, 0, false);
                this.waitForProcesses(versionedServer1, versionedServer2, versionedServer3, versionedServer4);
                this.getLogWriter().info((Object)"Executing DDLs");
                Properties props1 = new Properties();
                props1.setProperty("disable-cancel", "true");
                Connection conn = TestUtil.getNetConnection("localhost", clientPort1, null, props1);
                BackwardCompatabilityDUnit.addData(conn, DDL_STMTS, DML_STMTS);
                BackwardCompatabilityDUnit.addData(conn, DDL_STMTS_CUSTOM_DISKSTORE, DML_STMTS_CUSTOM_DISKSTORE);
                if (this.alterTableWithDataSupported(version)) {
                    this.getLogWriter().info((Object)("Running alter statements on server version " + version));
                    BackwardCompatabilityDUnit.runDDLs(conn, ALTER_STMTS);
                }
                conn.close();
                this.getLogWriter().info((Object)"Stopping earlier version servers");
                this.stopVersionedServer(listIdx, verIdx, this.vm1WorkingDir);
                this.stopVersionedServer(listIdx, verIdx, this.vm2WorkingDir);
                this.stopVersionedServer(listIdx, verIdx, this.vm3WorkingDir);
                this.stopVersionedServer(listIdx, verIdx, this.vm4WorkingDir);
                this.getLogWriter().info((Object)("VM WORKING DIRS:" + this.vm1WorkingDir + "," + this.vm2WorkingDir + "," + this.vm3WorkingDir + "," + this.vm4WorkingDir));
                String[] defaultStoreDirs = new String[]{this.vm1WorkingDir, this.vm2WorkingDir, this.vm3WorkingDir, this.vm4WorkingDir};
                String[] ddDirs = new String[]{this.vm1WorkingDir + "/datadictionary", this.vm2WorkingDir + "/datadictionary", this.vm3WorkingDir + "/datadictionary", this.vm4WorkingDir + "/datadictionary"};
                String[] customStoreDirs = new String[]{this.vm1WorkingDir + "/dir1", this.vm2WorkingDir + "/dir1", this.vm3WorkingDir + "/dir1", this.vm4WorkingDir + "/dir1"};
                this.getLogWriter().info((Object)"Upgrading disk stores");
                this.runUpgradeDiskStore("GFXD-DEFAULT-DISKSTORE", defaultStoreDirs);
                this.runUpgradeDiskStore("GFXD-DD-DISKSTORE", ddDirs);
                this.runUpgradeDiskStore("TESTSTORE", customStoreDirs);
                this.getLogWriter().info((Object)"Starting current version servers");
                if (restartVMs) {
                    this.restartVMNums(new int[]{-1, -2, -3, -4}, mcastPort, null, null);
                } else {
                    this.startServerVMs(4, mcastPort, null);
                    restartVMs = true;
                }
                this.getLogWriter().info((Object)"Verifying data");
                VM vm1 = Host.getHost((int)0).getVM(0);
                for (String sql : ALTER_STMTS) {
                    this.serverSQLExecute(1, sql);
                }
                vm1.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES});
                vm1.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES_CUSTOM_DISKSTORE});
                this.stopVMNums(-1, -2, -3, -4);
                this.cleanUpCustomStoreFiles(customStoreDirs);
                this.cleanUp(defaultStoreDirs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiskStoreUpgradeAndClientCompatibility_SQLF_or_GFXD_Versions_To_CurrentGemFireXD() throws Exception {
        String[] products = new String[]{"GEMFIREXD"};
        String[] versions = new String[]{"1.3.1"};
        boolean isWindows = NativeCalls.getInstance().getOSType().isWindows();
        String[] versionDirs = new String[]{isWindows ? "gemfireXD/releases/GemFireXD1.3.1-all/Windows_NT" : "gemfireXD/releases/GemFireXD1.3.1-all/Linux"};
        for (int i = 0; i < versions.length; ++i) {
            String version = versions[i];
            String versionDir = versionDirs[i];
            if (versionDir == null) continue;
            String prevProduct = products[i];
            this.getLogWriter().info((Object)("Testing disk store upgrade from " + prevProduct + "-" + version + " to current GemFireXD build version"));
            String currentDir = BackwardCompatabilityDUnit.getSysDirName();
            String locatorDir = currentDir + "/locatorDir";
            String serverOneDir = currentDir + "/serverOneDir";
            String serverTwoDir = currentDir + "/serverTwoDir";
            new File(locatorDir).mkdirs();
            new File(serverOneDir).mkdirs();
            new File(serverTwoDir).mkdirs();
            String[] defaultStoreDirs = new String[]{locatorDir, serverOneDir, serverTwoDir};
            String[] ddDirs = new String[]{serverOneDir + "/datadictionary", serverTwoDir + "/datadictionary", locatorDir + "/datadictionary"};
            String[] customStoreDirs = new String[]{serverOneDir + "/dir1", serverTwoDir + "/dir1"};
            try {
                try {
                    this.product = prevProduct;
                    this.getLogWriter().info((Object)("Starting locator version: " + version + " with working dir: " + locatorDir));
                    BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator(version, versionDir, locatorDir, false);
                    int baseVersionLocatorPort = versionedLocator.port;
                    this.getLogWriter().info((Object)"Starting earlier version servers");
                    BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(version, versionDir, serverOneDir, -1, baseVersionLocatorPort, false);
                    int clientPort1 = versionedServer1.port;
                    BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(version, versionDir, serverTwoDir, -1, baseVersionLocatorPort, false);
                    this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2);
                    this.doWithVersionedClient(prevProduct, version, versionDir, clientPort1, "addDataForClient");
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)("EXCEPTION:" + e));
                    Assert.fail((String)("EXCEPTION:" + e));
                }
                finally {
                    this.getLogWriter().info((Object)"Stopping earlier version servers");
                    this.stopVersionedServer(version, versionDir, serverOneDir);
                    this.stopVersionedServer(version, versionDir, serverTwoDir);
                    this.getLogWriter().info((Object)"Stopping earlier version locator");
                    try {
                        this.stopVersionedLocator(version, versionDir, locatorDir);
                    }
                    catch (Exception e) {
                        this.getLogWriter().info((Object)("EXCEPTION stopping locator:" + e.getMessage()));
                    }
                }
                this.getLogWriter().info((Object)("VM WORKING DIRS:" + serverOneDir + "," + serverTwoDir + "," + locatorDir));
                try {
                    this.getLogWriter().info((Object)"Starting current version locator");
                    this.product = "GEMFIREXD";
                    BackwardCompatabilityTestBase.ProcessStart currentLocator = this.startCurrentVersionLocator(locatorDir);
                    int currentVersionLocatorPort = currentLocator.port;
                    BackwardCompatabilityTestBase.ProcessStart currentServer1 = this.startCurrentVersionServer(serverOneDir, currentVersionLocatorPort);
                    int clientPort = currentServer1.port;
                    BackwardCompatabilityTestBase.ProcessStart currentServer2 = this.startCurrentVersionServer(serverTwoDir, currentVersionLocatorPort);
                    this.waitForProcesses(currentLocator, currentServer1, currentServer2);
                    this.getLogWriter().info((Object)"Verifying data using current GEMFIREXD DRIVER and JDBC URL jdbc:gemfirexd://");
                    Connection connection = this.getNetConnection("localhost", clientPort, new Properties());
                    BackwardCompatabilityDUnit.verifyData(connection, TABLE_NAMES);
                    BackwardCompatabilityDUnit.verifyData(connection, TABLE_NAMES_CUSTOM_DISKSTORE);
                    if (prevProduct.equals("SQLFIRE")) {
                        this.getLogWriter().info((Object)("Verifying client connectivity using " + prevProduct + "-" + version + " DRIVER and older JDBC URL jdbc:sqlfire://"));
                        this.doWithVersionedClient(prevProduct, version, versionDir, clientPort, "verifyDataForClient");
                        continue;
                    }
                    if (!version.equals("1.0")) {
                        this.getLogWriter().info((Object)("Verifying client connectivity using " + prevProduct + "-" + version + " DRIVER and older JDBC URL jdbc:sqlfire://"));
                        this.doWithVersionedClient(prevProduct, version, versionDir, clientPort, "verifyDataForClient", true);
                    }
                    this.getLogWriter().info((Object)("Verifying client connectivity using " + prevProduct + "-" + version + " DRIVER and newer JDBC URL jdbc:gemfirexd://"));
                    this.doWithVersionedClient(prevProduct, version, versionDir, clientPort, "verifyDataForClient");
                    continue;
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)e);
                    Assert.fail((String)("EXCEPTION:" + e));
                    continue;
                }
                finally {
                    this.stopCurrentVersionServer(serverOneDir);
                    this.stopCurrentVersionServer(serverTwoDir);
                    this.stopCurrentVersionLocator(locatorDir);
                }
            }
            finally {
                this.getLogWriter().info((Object)"Cleaning up");
                this.cleanUpCustomStoreFiles(customStoreDirs);
                this.cleanUp(defaultStoreDirs);
                this.product = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testBug50794() throws Exception {
        String[] versions = new String[]{"1.1.2"};
        String[] versionDirs = new String[]{"sqlfire/releases/SQLFire1.1.2-all"};
        for (int i = 0; i < versions.length; ++i) {
            String version = versions[i];
            String versionDir = versionDirs[i];
            this.getLogWriter().info((Object)("Testing disk store upgrade from SQLFire-" + version + " to current GemFireXD build version"));
            String currentDir = BackwardCompatabilityDUnit.getSysDirName();
            String locatorDir = currentDir + "/locatorDir";
            String serverOneDir = currentDir + "/serverOneDir";
            String serverTwoDir = currentDir + "/serverTwoDir";
            new File(locatorDir).mkdirs();
            new File(serverOneDir).mkdirs();
            new File(serverTwoDir).mkdirs();
            String[] defaultStoreDirs = new String[]{locatorDir, serverOneDir, serverTwoDir};
            String[] ddDirs = new String[]{serverOneDir + "/datadictionary", serverTwoDir + "/datadictionary", locatorDir + "/datadictionary"};
            String[] customStoreDirs = new String[]{serverOneDir + "/dir1", serverTwoDir + "/dir1"};
            try {
                try {
                    this.product = "SQLFIRE";
                    this.getLogWriter().info((Object)("Starting locator version: " + version + " with working dir: " + locatorDir));
                    BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator(version, versionDir, locatorDir, false);
                    int baseVersionLocatorPort = versionedLocator.port;
                    this.getLogWriter().info((Object)"Starting earlier version servers");
                    BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(version, versionDir, serverOneDir, -1, baseVersionLocatorPort, false);
                    int clientPort1 = versionedServer1.port;
                    BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(version, versionDir, serverTwoDir, -1, baseVersionLocatorPort, false);
                    this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2);
                    this.doWithVersionedClient("SQLFIRE", version, versionDir, clientPort1, "addDataForBug50794");
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)e);
                    Assert.fail((String)("EXCEPTION:" + e));
                }
                finally {
                    this.getLogWriter().info((Object)"Stopping earlier version servers");
                    this.stopVersionedServer(version, versionDir, serverOneDir);
                    this.stopVersionedServer(version, versionDir, serverTwoDir);
                    this.getLogWriter().info((Object)"Stopping earlier version locator");
                    this.stopVersionedLocator(version, versionDir, locatorDir);
                }
                this.getLogWriter().info((Object)("VM WORKING DIRS:" + serverOneDir + "," + serverTwoDir + "," + locatorDir));
                this.getLogWriter().info((Object)"Upgrading disk stores");
                try {
                    this.runUpgradeDiskStore("SQLF-DEFAULT-DISKSTORE", defaultStoreDirs);
                    this.runUpgradeDiskStore("SQLF-DD-DISKSTORE", ddDirs);
                }
                catch (Throwable e) {
                    this.getLogWriter().info((Object)e);
                    Assert.fail((String)("Exception during upgrade:" + e));
                }
                try {
                    this.getLogWriter().info((Object)"Starting current version locator");
                    this.product = "GEMFIREXD";
                    BackwardCompatabilityTestBase.ProcessStart currentLocator = this.startCurrentVersionLocator(locatorDir);
                    int currentVersionLocatorPort = currentLocator.port;
                    BackwardCompatabilityTestBase.ProcessStart currentServer1 = this.startCurrentVersionServer(serverOneDir, currentVersionLocatorPort);
                    int clientPort = currentServer1.port;
                    BackwardCompatabilityTestBase.ProcessStart currentServer2 = this.startCurrentVersionServer(serverTwoDir, currentVersionLocatorPort);
                    this.waitForProcesses(currentLocator, currentServer1, currentServer2);
                    Connection connection = this.getNetConnection("localhost", clientPort, new Properties());
                    connection.createStatement().execute("insert into upgradetest.pencil_default values(100, 'abc', 'def')");
                    connection.createStatement().execute("insert into upgradetest.pencil_default values(200, 'ghi', 'jkl')");
                    BackwardCompatabilityDUnit.verifyData(connection, TABLE_NAMES_BUG50794);
                    this.getLogWriter().info((Object)("Verifying client connectivity using SQLFIRE-" + version + " DRIVER and older JDBC URL jdbc:sqlfire://"));
                    this.doWithVersionedClient("SQLFIRE", version, versionDir, clientPort, "verifyDataForClientBug50794");
                    this.getLogWriter().info((Object)"Verifying client connectivity using GEMFIREXD DRIVER and older JDBC URL jdbc:sqlfire://");
                    Connection oldUrlConn = this.getNetConnection("localhost", clientPort, new Properties());
                    BackwardCompatabilityDUnit.verifyData(oldUrlConn, TABLE_NAMES_BUG50794);
                    continue;
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)e);
                    Assert.fail((String)("EXCEPTION:" + e));
                    continue;
                }
                finally {
                    this.stopCurrentVersionServer(serverOneDir);
                    this.stopCurrentVersionServer(serverTwoDir);
                    this.stopCurrentVersionLocator(locatorDir);
                }
            }
            finally {
                this.getLogWriter().info((Object)"Cleaning up");
                this.cleanUpCustomStoreFiles(customStoreDirs);
                this.cleanUp(defaultStoreDirs);
                this.product = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testBug_50165() throws Exception {
        String[] versions = new String[]{"1.1.2"};
        String[] versionDirs = new String[]{"sqlfire/releases/SQLFire1.1.2-all"};
        for (int i = 0; i < versions.length; ++i) {
            String version = versions[i];
            String versionDir = versionDirs[i];
            this.getLogWriter().info((Object)("Testing with SQLFire-" + version));
            String currentDir = BackwardCompatabilityDUnit.getSysDirName();
            String locatorDir = currentDir + "/locatorDir";
            String serverOneDir = currentDir + "/serverOneDir";
            String serverTwoDir = currentDir + "/serverTwoDir";
            String serverThreeDir = currentDir + "/serverThreeDir";
            String serverFourDir = currentDir + "/serverFourDir";
            new File(locatorDir).mkdirs();
            new File(serverOneDir).mkdirs();
            new File(serverTwoDir).mkdirs();
            new File(serverThreeDir).mkdirs();
            new File(serverFourDir).mkdirs();
            try {
                this.product = "SQLFIRE";
                this.getLogWriter().info((Object)("Starting locator version: " + version + " with working dir: " + locatorDir));
                BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator(version, versionDir, locatorDir, false);
                int baseVersionLocatorPort = versionedLocator.port;
                this.getLogWriter().info((Object)"Starting earlier version servers");
                BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(version, versionDir, serverOneDir, -1, baseVersionLocatorPort, false);
                int clientPort1 = versionedServer1.port;
                BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(version, versionDir, serverTwoDir, -1, baseVersionLocatorPort, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer3 = this.startVersionedServer(version, versionDir, serverThreeDir, -1, baseVersionLocatorPort, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer4 = this.startVersionedServer(version, versionDir, serverFourDir, -1, baseVersionLocatorPort, false);
                this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2, versionedServer3, versionedServer4);
                this.doWithVersionedClient("SQLFIRE", version, versionDir, clientPort1, "createDataForClient");
            }
            finally {
                this.getLogWriter().info((Object)"Stopping earlier version servers");
                this.stopVersionedServer(version, versionDir, serverOneDir);
                this.stopVersionedServer(version, versionDir, serverTwoDir);
                this.stopVersionedServer(version, versionDir, serverThreeDir);
                this.stopVersionedServer(version, versionDir, serverFourDir);
                this.getLogWriter().info((Object)"Stopping earlier version locator");
                this.stopVersionedLocator(version, versionDir, locatorDir);
            }
            this.getLogWriter().info((Object)("VM WORKING DIRS:" + serverOneDir + "," + serverTwoDir + "," + serverThreeDir + "," + serverFourDir + "," + locatorDir));
            String[] storeDirs = new String[]{locatorDir, serverOneDir, serverTwoDir, serverThreeDir, serverFourDir};
            String[] customDSDirs = new String[]{serverOneDir, serverTwoDir, serverThreeDir, serverFourDir};
            String[] ddDirs = new String[]{locatorDir + "/datadictionary", serverOneDir + "/datadictionary", serverTwoDir + "/datadictionary", serverThreeDir + "/datadictionary", serverFourDir + "/datadictionary"};
            int currentVersionLocatorPort = -1;
            try {
                this.getLogWriter().info((Object)"Starting current version locator");
                this.product = "GEMFIREXD";
                BackwardCompatabilityTestBase.ProcessStart currentLocator = this.startCurrentVersionLocator(locatorDir);
                currentVersionLocatorPort = currentLocator.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer1 = this.startCurrentVersionServer(serverOneDir, currentVersionLocatorPort);
                int clientPort = currentServer1.port;
                BackwardCompatabilityTestBase.ProcessStart currentServer2 = this.startCurrentVersionServer(serverTwoDir, currentVersionLocatorPort);
                BackwardCompatabilityTestBase.ProcessStart currentServer3 = this.startCurrentVersionServer(serverThreeDir, currentVersionLocatorPort);
                BackwardCompatabilityTestBase.ProcessStart currentServer4 = this.startCurrentVersionServer(serverFourDir, currentVersionLocatorPort);
                this.waitForProcesses(currentLocator, currentServer1, currentServer2, currentServer3, currentServer4);
                Connection connection = this.getNetConnection("localhost", clientPort, new Properties());
                Statement gfxdSt = connection.createStatement();
                this.getLogWriter().info((Object)"Creating tables");
                gfxdSt.execute("create table t1_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t2_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) colocate with (t1_temp) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t3_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t4_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                gfxdSt.execute("create table t5_temp(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
                try {
                    gfxdSt.execute("create index idx1_t1_temp on t1_temp(id2, id1)");
                    gfxdSt.execute("create index idx2_t1_temp on t1_temp(id1, ts)");
                }
                catch (Exception e) {
                    this.getLogWriter().info((Object)("EXCEPTION=" + e));
                    Assert.fail((String)("Exception while creating index:" + e));
                }
                this.getLogWriter().info((Object)"Inserting data");
                PreparedStatement gfxdPs = connection.prepareStatement("insert into t1_temp values(?,?,?,?)");
                for (int j = 0; j < 5; ++j) {
                    int id = j * 100;
                    gfxdPs.setString(1, String.valueOf(id));
                    gfxdPs.setInt(2, id);
                    gfxdPs.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    gfxdPs.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                    gfxdPs.execute();
                }
                gfxdPs.close();
                PreparedStatement gfxdPs2 = connection.prepareStatement("insert into t2_temp values(?,?,?,?)");
                for (int k = 0; k < 5; ++k) {
                    int id = k * 100;
                    gfxdPs2.setString(1, String.valueOf(id));
                    gfxdPs2.setInt(2, id);
                    gfxdPs2.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    gfxdPs2.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                    gfxdPs2.execute();
                }
                gfxdPs2.close();
                gfxdSt.close();
                connection.close();
            }
            catch (Exception e) {
                this.getLogWriter().info((Object)("EXCEPTION:" + e));
            }
            finally {
                this.getLogWriter().info((Object)"Shutdown current version cluster");
                if (currentVersionLocatorPort != -1) {
                    this.shutdownAllCurrent(currentVersionLocatorPort);
                }
                this.product = null;
            }
            this.cleanUpCustomStoreFiles(storeDirs);
        }
    }

    public void DISABLED_testMixedVersionsWithAuthentication() throws Exception {
        String baseLocatorPath = BackwardCompatabilityDUnit.getSysDirName() + "/baseVersionLocator";
        this.getLogWriter().info((Object)("Creating locator dir for base version: " + baseLocatorPath));
        File baseVersionLocatorDir = new File(baseLocatorPath);
        BackwardCompatabilityDUnit.assertTrue((boolean)baseVersionLocatorDir.mkdir());
        this.getLogWriter().info((Object)("Starting locator version: 1.1.1 with working dir: " + baseLocatorPath));
        BackwardCompatabilityTestBase.ProcessStart versionedLocator = this.startVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", baseLocatorPath, true);
        int baseVersionLocatorPort = versionedLocator.port;
        this.getLogWriter().info((Object)("Starting server version: 1.1.1 with working dir: " + this.vm3WorkingDir));
        BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir, 0, baseVersionLocatorPort, true);
        int clientPort1 = versionedServer1.port;
        this.getLogWriter().info((Object)("Starting server version: 1.1.1 with working dir: " + this.vm4WorkingDir));
        BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir, 0, baseVersionLocatorPort, true);
        this.waitForProcesses(versionedLocator, versionedServer1, versionedServer2);
        this.getLogWriter().info((Object)("Adding data, connecting to server at working dir " + this.vm3WorkingDir));
        Properties p = new Properties();
        p.put("user", "SYSADMIN");
        p.put("password", "SA");
        p.put("disable-cancel", "true");
        Connection conn = TestUtil.getNetConnection("localhost", clientPort1, null, p);
        BackwardCompatabilityDUnit.addData(conn, DDL_STMTS2, DML_STMTS);
        Properties props = new Properties();
        this.setAuthProps(props);
        props.put("locators", "localhost:" + baseVersionLocatorPort);
        props.setProperty("table-default-partitioned", "false");
        this.getLogWriter().info((Object)"Starting locator with current version in the second VM of this dunit test");
        int currentVersionLocatorPort = this.startLocator(Host.getHost((int)0).getVM(1), props);
        props.remove("locators");
        props.put("locators", "localhost:" + currentVersionLocatorPort);
        this.getLogWriter().info((Object)"Starting server with current version in the first VM");
        this.startServerVMs(1, 0, null, props);
        VM newVM = this.getServerVM(1);
        newVM.invoke(((Object)((Object)this)).getClass(), "runAddData", new Object[]{null, DML_STMTS});
        this.getLogWriter().info((Object)"Verifying data by connecting to this last server");
        newVM.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES, p});
        this.getLogWriter().info((Object)"Stopping the server and the locator running in test VMs");
        this.stopAllVMs();
        props.remove("locators");
        this.stopLocator(Host.getHost((int)0).getVM(1), props);
        this.getLogWriter().info((Object)"Stopping versioned servers");
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir);
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir);
        this.getLogWriter().info((Object)"Stopping versioned locator");
        this.stopVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", baseLocatorPath);
        this.getLogWriter().info((Object)"Cleaning up");
        TestUtil.deleteDir(new File(baseLocatorPath));
    }

    public void DISABLED_MERGE_testUpgradeDiskStoreAddNewServerWithNoData() throws Exception {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        boolean restartVMs = false;
        boolean restartFourthVM = false;
        for (int listIdx = 0; listIdx < compatibleVersionLists.length; ++listIdx) {
            String[] compatibleVersions = compatibleVersionLists[listIdx];
            for (int verIdx = 0; verIdx < compatibleVersions.length; ++verIdx) {
                String version = compatibleVersionLists[listIdx][verIdx];
                String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
                this.getLogWriter().info((Object)"Starting earlier version servers");
                BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer(version, versionDir, this.vm1WorkingDir, mcastPort, 0, false);
                int clientPort1 = versionedServer1.port;
                BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer(version, versionDir, this.vm2WorkingDir, mcastPort, 0, false);
                BackwardCompatabilityTestBase.ProcessStart versionedServer3 = this.startVersionedServer(version, versionDir, this.vm3WorkingDir, mcastPort, 0, false);
                this.waitForProcesses(versionedServer1, versionedServer2, versionedServer3);
                this.getLogWriter().info((Object)"Executing DDLs");
                Properties props1 = new Properties();
                props1.setProperty("disable-cancel", "true");
                Connection conn = TestUtil.getNetConnection("localhost", clientPort1, null, props1);
                BackwardCompatabilityDUnit.addData(conn, DDL_STMTS, DML_STMTS);
                conn.close();
                this.getLogWriter().info((Object)"Stopping earlier version servers");
                this.stopVersionedServer(listIdx, verIdx, this.vm1WorkingDir);
                this.stopVersionedServer(listIdx, verIdx, this.vm2WorkingDir);
                this.stopVersionedServer(listIdx, verIdx, this.vm3WorkingDir);
                this.getLogWriter().info((Object)("VM WORKING DIRS:" + this.vm1WorkingDir + "," + this.vm2WorkingDir + "," + this.vm3WorkingDir));
                String[] defaultStoreDirs = new String[]{this.vm1WorkingDir, this.vm2WorkingDir, this.vm3WorkingDir};
                String[] ddDirs = new String[]{this.vm1WorkingDir + "/datadictionary", this.vm2WorkingDir + "/datadictionary", this.vm3WorkingDir + "/datadictionary"};
                this.getLogWriter().info((Object)"Upgrading disk stores");
                this.runUpgradeDiskStore("GFXD-DEFAULT-DISKSTORE", defaultStoreDirs);
                this.runUpgradeDiskStore("GFXD-DD-DISKSTORE", ddDirs);
                this.getLogWriter().info((Object)"Starting current version servers");
                if (restartVMs) {
                    this.restartVMNums(new int[]{-1, -2, -3}, mcastPort, null, null);
                } else {
                    this.startServerVMs(3, mcastPort, null);
                    restartVMs = true;
                }
                this.getLogWriter().info((Object)"Verifying data");
                VM vm1 = Host.getHost((int)0).getVM(0);
                vm1.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES});
                if (restartFourthVM) {
                    this.restartVMNums(new int[]{-4}, mcastPort, null, null);
                } else {
                    this.startServerVMs(1, mcastPort, null);
                    restartFourthVM = true;
                }
                VM vm4 = Host.getHost((int)0).getVM(3);
                vm4.invoke(((Object)((Object)this)).getClass(), "verifyData", new Object[]{TABLE_NAMES});
                this.stopVMNums(-1, -2, -3, -4);
                this.cleanUp(new String[]{this.vm1WorkingDir, this.vm2WorkingDir, this.vm3WorkingDir, this.vm4WorkingDir});
            }
        }
    }

    private int startLocator(VM locatorVM, Properties props) throws IOException {
        final int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        final Properties pr = props;
        File locatorLogFile = new File("locator-" + locatorPort + ".log");
        locatorVM.invoke((Callable)new SerializableCallable(){

            public Object call() throws IOException {
                try {
                    Properties p = new Properties();
                    p.setProperty("jmx-manager", "false");
                    p.putAll((Map<?, ?>)pr);
                    p = DistributedTestBase.getAllDistributedSystemProperties((Properties)p);
                    FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
                    locator.start("localhost", locatorPort, p);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        return locatorPort;
    }

    private void stopLocator(VM locatorVM, Properties props) throws Exception {
        final Properties p = props;
        locatorVM.invoke((Callable)new SerializableCallable(){

            public Object call() throws IOException {
                try {
                    FabricService locator = FabricServiceManager.currentFabricServiceInstance();
                    locator.stop(p);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void DISABLED_MERGE_testUpgradeDiskStoreSingleServer() throws Exception {
        String workingDir = BackwardCompatabilityDUnit.getSysDirName();
        boolean thisVMStarted = false;
        for (int listIdx = 0; listIdx < compatibleVersionLists.length; ++listIdx) {
            String[] compatibleVersions = compatibleVersionLists[listIdx];
            for (int verIdx = 0; verIdx < compatibleVersions.length; ++verIdx) {
                this.getLogWriter().info((Object)("WORKING DIR=" + workingDir));
                int clientPort = this.startLonerVersionedServer(listIdx, verIdx, -1, workingDir);
                this.currentListIdx = listIdx;
                this.currentVersIdx = verIdx;
                Properties props1 = new Properties();
                props1.setProperty("disable-cancel", "true");
                Connection conn = TestUtil.getNetConnection("localhost", clientPort, null, props1);
                Statement stmt = conn.createStatement();
                int id = 1;
                int numInserts = 10;
                for (String ddl : DDLS) {
                    if (ddl.startsWith("drop")) {
                        BackwardCompatabilityDUnit.runDMLs(id, numInserts, conn);
                        id += numInserts;
                    }
                    stmt.execute(ddl);
                }
                BackwardCompatabilityDUnit.runDMLsAsBatch(id, numInserts, conn);
                id += numInserts;
                conn.close();
                this.stopVersionedServer(listIdx, verIdx, workingDir);
                this.currentListIdx = -1;
                this.currentVersIdx = -1;
                String[] dirs = new String[]{workingDir};
                String[] ddDirs = new String[]{workingDir + "/datadictionary"};
                this.runUpgradeDiskStore("GFXD-DEFAULT-DISKSTORE", dirs);
                this.runUpgradeDiskStore("GFXD-DD-DISKSTORE", ddDirs);
                this.getLogWriter().info((Object)("testing server version " + compatibleVersions[verIdx] + " against current build"));
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("host-data", "true");
                props.setProperty("table-default-partitioned", "false");
                if (thisVMStarted) {
                    this.restartClientVMNums(new int[]{1}, 1, null, props);
                } else {
                    this.startClientVMs(1, 1, null, props);
                    thisVMStarted = true;
                }
                clientPort = TestUtil.startNetserverAndReturnPort();
                conn = TestUtil.getNetConnection(clientPort, null, null);
                BackwardCompatabilityDUnit.verifyData(conn, id, true);
                this.dropDatabaseObjects(null, clientPort);
                conn.close();
                this.stopVMNum(1);
                BackwardCompatabilityDUnit.deleteDataDictionaryDir();
                this.deleteDefaultDiskStoreFiles(workingDir);
            }
        }
    }

    public void _old_testDataDictionaryAndDataRecovery() throws Exception {
        String workingDir = BackwardCompatabilityDUnit.getSysDirName();
        boolean thisVMStarted = false;
        for (int listIdx = 0; listIdx < compatibleVersionLists.length; ++listIdx) {
            String[] compatibleVersions = compatibleVersionLists[listIdx];
            for (int verIdx = 0; verIdx < compatibleVersions.length; ++verIdx) {
                int clientPort = this.startLonerVersionedServer(listIdx, verIdx, -1, workingDir);
                this.currentListIdx = listIdx;
                this.currentVersIdx = verIdx;
                Connection conn = TestUtil.getNetConnection("localhost", clientPort, null, null);
                Statement stmt = conn.createStatement();
                int id = 1;
                int numInserts = 10;
                for (String ddl : DDLS) {
                    if (ddl.startsWith("drop")) {
                        BackwardCompatabilityDUnit.runDMLs(id, numInserts, conn);
                        id += numInserts;
                    }
                    stmt.execute(ddl);
                }
                BackwardCompatabilityDUnit.runDMLsAsBatch(id, numInserts, conn);
                id += numInserts;
                conn.close();
                this.stopVersionedServer(listIdx, verIdx, workingDir);
                this.currentListIdx = -1;
                this.currentVersIdx = -1;
                int higherIdx = compatibleVersions.length - 1;
                String testVersion = compatibleVersions[higherIdx];
                if (higherIdx != verIdx && testVersion.equals("1.0.2")) {
                    this.getLogWriter().info((Object)("skipping test of server version " + compatibleVersions[verIdx] + " against " + testVersion + " due to bug 44988"));
                    continue;
                }
                this.getLogWriter().info((Object)("testing server version " + compatibleVersions[verIdx] + " against " + testVersion));
                clientPort = this.startLonerVersionedServer(listIdx, higherIdx, verIdx, workingDir);
                this.currentListIdx = listIdx;
                this.currentVersIdx = higherIdx;
                conn = TestUtil.getNetConnection("localhost", clientPort, null, null);
                BackwardCompatabilityDUnit.verifyData(conn, id, true);
                conn.close();
                this.stopVersionedServer(listIdx, verIdx, workingDir);
                this.currentListIdx = -1;
                this.currentVersIdx = -1;
                this.getLogWriter().info((Object)("testing server version " + compatibleVersions[verIdx] + " against current build"));
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("host-data", "true");
                props.setProperty("table-default-partitioned", "false");
                if (thisVMStarted) {
                    this.restartClientVMNums(new int[]{1}, 1, null, props);
                } else {
                    this.startClientVMs(1, 1, null, props);
                    thisVMStarted = true;
                }
                clientPort = TestUtil.startNetserverAndReturnPort();
                conn = TestUtil.getNetConnection(clientPort, null, null);
                BackwardCompatabilityDUnit.verifyData(conn, id, true);
                this.dropDatabaseObjects(null, clientPort);
                conn.close();
                this.stopVMNum(1);
            }
            BackwardCompatabilityDUnit.deleteDataDictionaryDir();
            this.deleteDefaultDiskStoreFiles(workingDir);
        }
    }

    public void DISABLED_MERGE_testClientCompatibility() throws Exception {
        String workingDir = BackwardCompatabilityDUnit.getSysDirName();
        boolean thisVMStarted = false;
        for (int listIdx = 0; listIdx < compatibleVersionLists.length; ++listIdx) {
            String[] compatibleVersions = compatibleVersionLists[listIdx];
            for (int verIdx = 0; verIdx < compatibleVersions.length; ++verIdx) {
                int higherIdx = compatibleVersions.length - 1;
                String testVersion = compatibleVersions[higherIdx];
                this.getLogWriter().info((Object)("testing client version " + compatibleVersions[verIdx] + " against " + testVersion));
                int clientPort = this.startLonerVersionedServer(listIdx, higherIdx, verIdx, workingDir);
                this.currentListIdx = listIdx;
                this.currentVersIdx = higherIdx;
                this.runVersionedClient(listIdx, verIdx, "localhost", clientPort, 10, 10000);
                this.stopVersionedServer(listIdx, verIdx, workingDir);
                this.currentListIdx = -1;
                this.currentVersIdx = -1;
                this.getLogWriter().info((Object)"Upgrading disk stores");
                this.runUpgradeDiskStore("GFXD-DEFAULT-DISKSTORE", new String[]{workingDir});
                this.runUpgradeDiskStore("GFXD-DD-DISKSTORE", new String[]{workingDir + "/datadictionary"});
                this.getLogWriter().info((Object)("testing client version " + compatibleVersions[verIdx] + " against current build"));
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("host-data", "true");
                props.setProperty("table-default-partitioned", "false");
                if (thisVMStarted) {
                    this.restartClientVMNums(new int[]{1}, 1, null, props);
                } else {
                    this.startClientVMs(1, 1, null, props);
                    thisVMStarted = true;
                }
                clientPort = TestUtil.startNetserverAndReturnPort();
                Connection conn = TestUtil.getNetConnection(clientPort, null, null);
                this.dropDatabaseObjects(null, clientPort);
                String localHostName = SocketCreator.getLocalHost().getHostName();
                this.runVersionedClient(listIdx, verIdx, localHostName, clientPort, 10, 10000);
                this.dropDatabaseObjects(null, clientPort);
                this.stopVMNum(1);
                BackwardCompatabilityDUnit.deleteDataDictionaryDir();
                this.deleteDefaultDiskStoreFiles(workingDir);
            }
        }
    }

    private int startLonerVersionedServer(int listIdx, int verIdx, int checkIdx, String workingDir) throws Exception {
        String version = compatibleVersionLists[listIdx][verIdx];
        String versionDir = compatibleVersionProductDirs[listIdx][verIdx];
        BackwardCompatabilityTestBase.ProcessStart versionedServer = this.startVersionedServer(version, versionDir, workingDir, 0, 0, false);
        this.waitForProcesses(versionedServer);
        return versionedServer.port;
    }

    private static void runDMLs(int start, int numInserts, Connection conn) throws SQLException {
        int last = start + numInserts;
        for (String dml : DMLS) {
            PreparedStatement pstmt = conn.prepareStatement(dml);
            int numParams = pstmt.getParameterMetaData().getParameterCount();
            for (int id = start; id < last; ++id) {
                if (numParams == 1) {
                    pstmt.setString(1, "addr" + id);
                } else {
                    pstmt.setInt(1, id);
                    pstmt.setString(2, "addr" + id);
                }
                pstmt.executeUpdate();
            }
        }
    }

    private static void runDMLsAsBatch(int start, int numInserts, Connection conn) throws SQLException {
        int last = start + numInserts;
        for (String dml : DMLS) {
            PreparedStatement pstmt = conn.prepareStatement(dml);
            int numParams = pstmt.getParameterMetaData().getParameterCount();
            for (int id = start; id < last; ++id) {
                if (numParams == 1) {
                    pstmt.setString(1, "addr" + id);
                } else {
                    pstmt.setInt(1, id);
                    pstmt.setString(2, "addr" + id);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
    }

    public static void verifyData(String[] tables2, Properties props) throws SQLException {
        Connection conn = TestUtil.getConnection(props);
        BackwardCompatabilityDUnit.verifyData(conn, tables2);
    }

    public static void verifyData(Connection conn, String[] tables2) throws SQLException {
        ProductClient.verifyData(conn, tables2);
    }

    public static void verifyData(String[] tables2) throws SQLException {
        BackwardCompatabilityDUnit.verifyData(tables2, null);
    }

    private static void verifyData(Connection conn, int limit, boolean checkRecovery) throws SQLException {
        for (Object[] tableObj : TABLES) {
            HashSet<Integer> resultIds = new HashSet<Integer>();
            String table = (String)tableObj[0];
            int offset = (Integer)tableObj[2];
            BackwardCompatabilityDUnit.getGlobalLogger().info((Object)("checking data for table " + table));
            java.sql.ResultSet rs = conn.createStatement().executeQuery("select * from " + table);
            while (rs.next()) {
                int resId = rs.getInt(1);
                if (resultIds.contains(resId)) {
                    BackwardCompatabilityDUnit.fail((String)("double result for " + resId));
                }
                BackwardCompatabilityDUnit.assertTrue((String)("unexpected ID " + resId), (resId > 0 ? 1 : 0) != 0);
                BackwardCompatabilityDUnit.assertTrue((String)("unexpected ID " + resId + " offset " + offset + " with limit " + limit), (resId + offset < limit ? 1 : 0) != 0);
                BackwardCompatabilityDUnit.assertEquals((String)("addr" + (resId + offset)), (String)rs.getString(2));
                resultIds.add(resId);
            }
            rs.close();
            if (!checkRecovery || ((Boolean)tableObj[1]).booleanValue()) {
                BackwardCompatabilityDUnit.assertEquals((int)(limit - 1 - offset), (int)resultIds.size());
                continue;
            }
            BackwardCompatabilityDUnit.assertEquals((int)0, (int)resultIds.size());
        }
    }

    private void dropDatabaseObjects(String host, int clientPort) throws SQLException {
        Connection conn = TestUtil.getNetConnection(host, clientPort, null, null);
        Statement stmt = conn.createStatement();
        for (String string : INDEXES) {
            this.getLogWriter().info((Object)("dropping index " + string));
            stmt.execute("drop index " + string);
        }
        for (String string : TABLES) {
            this.getLogWriter().info((Object)("dropping table " + string[0]));
            stmt.execute("drop table " + string[0]);
        }
        conn.close();
    }

    private BackwardCompatabilityTestBase.ProcessStart startVersionedLocator(String version, String versionDir, String workingDir, boolean withAuth, int locatorPort1, int locatorPort2) throws Exception {
        String gfxdDir = GCM_WHERE + '/' + versionDir;
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        int clientPort = AvailablePort.getRandomAvailablePort((int)0);
        this.getLogWriter().info((Object)("Starting " + this.product + " locator version " + version + " from " + gfxdDir + " on port " + locatorPort1));
        String logFile = this.getTestLogNamePrefix() + "-locator" + version + ".log";
        String[] startOps = null;
        startOps = withAuth ? new String[]{utilLauncher, "locator", "start", "-dir=" + workingDir, "-log-file=" + logFile, "-peer-discovery-port=" + locatorPort1, "-auth-provider=BUILTIN", "-gemfirexd.sql-authorization=TRUE", "-gemfirexd.user.SYSADMIN=SA", "-user=SYSADMIN", "-password=SA", "-locators=localhost:" + locatorPort2, "-client-port=" + clientPort} : new String[]{utilLauncher, "locator", "start", "-dir=" + workingDir, "-log-file=" + logFile, "-peer-discovery-port=" + locatorPort1, "-locators=localhost:" + locatorPort2, "-client-port=" + clientPort};
        Process serverProc = new ProcessBuilder(startOps).start();
        this.sleepForAsyncLocatorStart(serverProc, locatorPort1);
        return new BackwardCompatabilityTestBase.ProcessStart(serverProc, clientPort, true, version, logFile);
    }

    private void shutdownAllCurrent(int locatorPort) throws Exception {
        String utilLauncher = this.getCurrentUtilLauncher();
        String logFile = this.getTestLogNamePrefix() + "-shutdownall-current.log";
        String[] startOps = new String[]{utilLauncher, "shut-down-all", "-locators=localhost[" + locatorPort + "]", "-log-file=" + logFile, "-log-level=fine"};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " during shut-down-all for current version ");
        }
    }

    private void shutdownAll(String version, String versionDir, int locatorPort) throws Exception {
        String gfxdDir = GCM_WHERE + '/' + versionDir;
        String utilLauncher = this.getUtilLauncher(gfxdDir);
        String[] startOps = new String[]{utilLauncher, "shut-down-all", "-locators=localhost[" + locatorPort + "]"};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " during shut-down-all for version " + version + '.');
        }
    }

    public void DISABLED_testBug47476() throws Exception {
        int locatorPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int locatorPort2 = AvailablePort.getRandomAvailablePort((int)0);
        this.getLogWriter().info((Object)("Starting locator1 version: 1.1.1 with working dir: " + this.vm1WorkingDir));
        BackwardCompatabilityTestBase.ProcessStart versionedLocator1 = this.startVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm1WorkingDir, false, locatorPort1, locatorPort2);
        this.getLogWriter().info((Object)("Starting locator2 version: 1.1.1 with working dir: " + this.vm2WorkingDir));
        BackwardCompatabilityTestBase.ProcessStart versionedLocator2 = this.startVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm2WorkingDir, false, locatorPort2, locatorPort1);
        this.getLogWriter().info((Object)("Starting server1 version: 1.1.1 with working dir: " + this.vm3WorkingDir));
        BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir, 0, locatorPort1, false);
        int clientPort1 = versionedServer1.port;
        this.getLogWriter().info((Object)("Starting server2 version: 1.1.1 with working dir: " + this.vm4WorkingDir));
        BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir, 0, locatorPort1, false);
        this.waitForProcesses(versionedLocator1, versionedLocator2, versionedServer1, versionedServer2);
        String newVersion = "1.1.0";
        String newVersionDir = "gemfirexd/releases/GemFireXD1.1.0-all";
        this.stopVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm1WorkingDir);
        this.waitForProcesses(this.startVersionedLocator(newVersion, newVersionDir, this.vm1WorkingDir, false, locatorPort1, locatorPort2));
        this.stopVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm2WorkingDir);
        this.waitForProcesses(this.startVersionedLocator(newVersion, newVersionDir, this.vm2WorkingDir, false, locatorPort2, locatorPort1));
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir);
        this.waitForProcesses(this.startVersionedServer(newVersion, newVersionDir, this.vm3WorkingDir, 0, locatorPort1, false));
        this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir);
        this.waitForProcesses(this.startVersionedServer(newVersion, newVersionDir, this.vm4WorkingDir, 0, locatorPort1, false));
        this.shutdownAll(newVersion, newVersionDir, locatorPort1);
        this.stopVersionedLocator(newVersion, newVersionDir, this.vm1WorkingDir);
        this.stopVersionedLocator(newVersion, newVersionDir, this.vm2WorkingDir);
        this.stopAllVMs();
        String[] defaultStoreDirs = new String[]{this.vm1WorkingDir, this.vm2WorkingDir, this.vm3WorkingDir, this.vm4WorkingDir};
        this.cleanUp(defaultStoreDirs);
    }

    void createTable_TestBug47753(Connection conn, String tag) throws Exception {
        Statement s = conn.createStatement();
        s.execute("create schema trade" + tag);
        s.execute("create table trade" + tag + ".t1 ( id int, name varchar(10), type int primary key) " + "partition by primary key");
        s.execute("create INDEX trade" + tag + ".t1index on t1(id)");
    }

    void insertData_TestBug47753(Connection conn, String tag) throws Exception {
        Statement s = conn.createStatement();
        s.execute("Insert into  trade" + tag + ".t1 values(1,'vivek',1)");
        s.execute("Insert into  trade" + tag + ".t1 values(2,'vivek',2)");
        s.execute("Insert into  trade" + tag + ".t1 values(3,'vivek',3)");
        s.execute("Insert into  trade" + tag + ".t1 values(4,'vivek',4)");
        s.execute("Insert into  trade" + tag + ".t1 values(5,'vivek',5)");
    }

    void dropTable_TestBug47753(Connection conn, String tag) throws Exception {
        Statement s = conn.createStatement();
        s.execute("drop index if exists trade" + tag + ".t1index ");
        s.execute("drop table if exists trade" + tag + ".t1 ");
        s.execute("drop schema if exists trade" + tag + " restrict");
    }

    String getQuery_TestBug47753(String tag) {
        return "select type, id, name from trade" + tag + ".t1 where id IN (?,?,?)";
    }

    void verifyData_TestBug47753(Connection conn, String query) throws Exception {
        PreparedStatement ps1 = conn.prepareStatement(query);
        ps1.setInt(1, 1);
        ps1.setInt(2, 2);
        ps1.setInt(3, 3);
        java.sql.ResultSet rs = ps1.executeQuery();
        HashSet<Integer> hashi = new HashSet<Integer>();
        hashi.add(1);
        hashi.add(2);
        hashi.add(3);
        while (rs.next()) {
            BackwardCompatabilityDUnit.assertTrue((boolean)hashi.remove(rs.getInt(1)));
        }
        BackwardCompatabilityDUnit.assertTrue((boolean)hashi.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testBug47753() throws Exception {
        int netPort;
        int rollingVersionLocatorPort2;
        GemFireXDQueryObserverAdapter oldGetAllObserver = new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                if (qInfo instanceof SelectQueryInfo) {
                    BackwardCompatabilityDUnit.remoteCallbackInvoked[0] = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                    TestCase.assertFalse((boolean)sqi.isGetAllOnLocalIndex());
                    TestCase.assertTrue((boolean)sqi.isDynamic());
                    TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                    Object[] pks = (Object[])sqi.getPrimaryKey();
                    TestCase.assertNull((Object)pks);
                    try {
                        TestCase.assertTrue((boolean)sqi.createGFEActivation());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestCase.fail((String)e.toString());
                    }
                }
            }

            public void createdGemFireXDResultSet(ResultSet rs) {
                if (rs instanceof GemFireDistributedResultSet) {
                    BackwardCompatabilityDUnit.remoteCallbackInvoked[1] = true;
                }
            }

            public void getAllInvoked(int numElements) {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[3] = true;
            }

            public void getAllLocalIndexExecuted() {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[4] = true;
            }

            public void getAllLocalIndexInvoked(int numElements) {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[2] = true;
                TestCase.assertEquals((int)0, (int)numElements);
            }
        };
        GemFireXDQueryObserverAdapter newGetAllObserver = new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                if (qInfo instanceof SelectQueryInfo) {
                    BackwardCompatabilityDUnit.remoteCallbackInvoked[0] = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                    TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                    TestCase.assertTrue((boolean)sqi.isDynamic());
                    TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                    Object[] pks = (Object[])sqi.getPrimaryKey();
                    TestCase.assertNull((Object)pks);
                    try {
                        TestCase.assertTrue((boolean)sqi.createGFEActivation());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestCase.fail((String)e.toString());
                    }
                }
            }

            public void createdGemFireXDResultSet(ResultSet rs) {
                if (rs instanceof GemFireResultSet) {
                    BackwardCompatabilityDUnit.remoteCallbackInvoked[1] = true;
                }
            }

            public void getAllInvoked(int numElements) {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[3] = true;
            }

            public void getAllLocalIndexExecuted() {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[4] = true;
            }

            public void getAllLocalIndexInvoked(int numElements) {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[2] = true;
                TestCase.assertEquals((int)3, (int)numElements);
            }
        };
        SerializableRunnable getAllSetOld = new SerializableRunnable("Set GetAll Observer for Old", (GemFireXDQueryObserver)oldGetAllObserver){
            final /* synthetic */ GemFireXDQueryObserver val$oldGetAllObserver;
            {
                this.val$oldGetAllObserver = gemFireXDQueryObserver;
                super(x0);
            }

            public void run() throws CacheException {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[0] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[1] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[2] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[3] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[4] = false;
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$oldGetAllObserver);
            }
        };
        SerializableRunnable getAllSetNew = new SerializableRunnable("Set GetAll Observer for New", (GemFireXDQueryObserver)newGetAllObserver){
            final /* synthetic */ GemFireXDQueryObserver val$newGetAllObserver;
            {
                this.val$newGetAllObserver = gemFireXDQueryObserver;
                super(x0);
            }

            public void run() throws CacheException {
                BackwardCompatabilityDUnit.remoteCallbackInvoked[0] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[1] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[2] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[3] = false;
                BackwardCompatabilityDUnit.remoteCallbackInvoked[4] = false;
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$newGetAllObserver);
            }
        };
        SerializableRunnable getAllObsReset = new SerializableRunnable("Reset GetAll Observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
            }
        };
        SerializableRunnable getAllObsVerify_oldVersion = new SerializableRunnable("Verify GetAll Observer For older Version"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[2]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[3]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[4]);
            }
        };
        SerializableRunnable getAllObsVerify_newVersion = new SerializableRunnable("Verify GetAll Observer For new Version"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[2]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[3]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[4]);
            }
        };
        SerializableRunnable clearStmtCache = new SerializableRunnable("Clear Stmt Cache"){

            public void run() throws CacheException {
                try {
                    TestUtil.clearStatementCache();
                    BackwardCompatabilityDUnit.remoteCallbackInvoked[3] = true;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        SerializableRunnable verifyStmtCache = new SerializableRunnable("Verify Stmt Cache"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[3]);
            }
        };
        String persistDD = "false";
        int rollingVersionLocatorPort1 = AvailablePort.getRandomAvailablePort((int)0);
        SanityManager.ASSERT((rollingVersionLocatorPort1 != (rollingVersionLocatorPort2 = AvailablePort.getRandomAvailablePort((int)0)) ? 1 : 0) != 0);
        String locators = "localhost[" + rollingVersionLocatorPort1 + "]" + "," + "localhost[" + rollingVersionLocatorPort2 + "]";
        Properties props = new Properties();
        props.setProperty("locators", locators);
        props.setProperty("persist-dd", persistDD);
        props.setProperty("log-level", this.getLogLevel());
        BackwardCompatabilityTestBase.ProcessStart versionedLocator1 = this.startVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm1WorkingDir, rollingVersionLocatorPort1, locators, false, persistDD);
        BackwardCompatabilityTestBase.ProcessStart versionedLocator2 = this.startVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm2WorkingDir, rollingVersionLocatorPort2, locators, false, persistDD);
        Properties connClientProps = new Properties();
        connClientProps.setProperty("single-hop-enabled", "false");
        connClientProps.setProperty("single-hop-max-connections", "5");
        if (this.getLogLevel().startsWith("fine")) {
            connClientProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        }
        int oldVersionClientPort = 0;
        BackwardCompatabilityTestBase.ProcessStart versionedServer1 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir, 0, locators, false, persistDD);
        int clientPort = versionedServer1.port;
        BackwardCompatabilityTestBase.ProcessStart versionedServer2 = this.startVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir, 0, locators, false, persistDD);
        oldVersionClientPort = versionedServer2.port;
        this.waitForProcesses(versionedLocator1, versionedLocator2, versionedServer1, versionedServer2);
        Connection conn = TestUtil.getNetConnection("localhost", clientPort, null, connClientProps);
        this.createTable_TestBug47753(conn, "1");
        this.insertData_TestBug47753(conn, "1");
        this.verifyData_TestBug47753(conn, this.getQuery_TestBug47753("1"));
        this.dropTable_TestBug47753(conn, "1");
        props.setProperty("mcast-port", "0");
        props.put("max-wait-time-reconnect", "15000");
        this.getLogWriter().info((Object)"Stopping first 1.1.1locator");
        this.stopVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm1WorkingDir);
        this.getLogWriter().info((Object)"Starting first locator");
        this.startLocatorVM("localhost", rollingVersionLocatorPort1, null, props);
        this.getLogWriter().info((Object)"Stopping Second 1.1.1locator");
        this.stopVersionedLocator("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm2WorkingDir);
        this.getLogWriter().info((Object)"Starting second locator");
        this.startLocatorVM("localhost", rollingVersionLocatorPort2, null, props);
        try {
            this.getLogWriter().info((Object)"Stopping first 1.1.1server");
            this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm3WorkingDir);
            this.getLogWriter().info((Object)"Starting current version server");
            this.startServerVMs(1, 0, null, props);
            netPort = this.startNetworkServer(3, null, null);
            TestUtil.loadNetDriver();
            Connection oldConn = TestUtil.getNetConnection("localhost", oldVersionClientPort, null, connClientProps);
            this.createTable_TestBug47753(oldConn, "2");
            this.insertData_TestBug47753(oldConn, "2");
            this.verifyData_TestBug47753(oldConn, this.getQuery_TestBug47753("2"));
            InetAddress localHost = SocketCreator.getLocalHost();
            String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
            Connection newConn = DriverManager.getConnection(url, TestUtil.getNetProperties(connClientProps));
            this.serverExecute(3, (Runnable)clearStmtCache);
            this.serverExecute(3, (Runnable)verifyStmtCache);
            this.serverExecute(3, (Runnable)getAllSetOld);
            try {
                this.verifyData_TestBug47753(newConn, this.getQuery_TestBug47753("2"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.dropTable_TestBug47753(oldConn, "2");
            try {
                this.serverExecute(3, (Runnable)getAllObsVerify_oldVersion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.serverExecute(3, (Runnable)getAllObsReset);
            this.serverExecute(3, (Runnable)getAllSetNew);
            this.createTable_TestBug47753(newConn, "4");
            this.insertData_TestBug47753(newConn, "4");
            this.verifyData_TestBug47753(newConn, this.getQuery_TestBug47753("4"));
            this.dropTable_TestBug47753(newConn, "4");
            this.serverExecute(3, (Runnable)getAllObsVerify_newVersion);
        }
        finally {
            this.serverExecute(3, (Runnable)getAllObsReset);
        }
        try {
            this.getLogWriter().info((Object)"Stopping second 1.1.1 server");
            this.stopVersionedServer("1.1.1", "sqlfire/releases/SQLFire1.1.1-all", this.vm4WorkingDir);
            this.getLogWriter().info((Object)"Starting current version server");
            this.startServerVMs(1, 0, null, props);
            netPort = this.startNetworkServer(4, null, null);
            TestUtil.loadNetDriver();
            InetAddress localHost = SocketCreator.getLocalHost();
            String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
            conn = DriverManager.getConnection(url, TestUtil.getNetProperties(connClientProps));
            this.serverExecute(4, (Runnable)clearStmtCache);
            this.serverExecute(4, (Runnable)verifyStmtCache);
            this.serverExecute(4, (Runnable)getAllSetNew);
            this.createTable_TestBug47753(conn, "3");
            this.insertData_TestBug47753(conn, "3");
            this.verifyData_TestBug47753(conn, this.getQuery_TestBug47753("3"));
            this.dropTable_TestBug47753(conn, "3");
            this.serverExecute(4, (Runnable)getAllObsVerify_newVersion);
        }
        finally {
            this.serverExecute(4, (Runnable)getAllObsReset);
        }
        this.stopVMNums(-1, -2, -3, -4);
        String[] customStoreDirs = new String[]{this.vm1WorkingDir + "/dir1", this.vm2WorkingDir + "/dir1", this.vm3WorkingDir + "/dir1", this.vm4WorkingDir + "/dir1"};
        this.cleanUpCustomStoreFiles(customStoreDirs);
        this.cleanUp(new String[]{this.vm1WorkingDir, this.vm2WorkingDir, this.vm3WorkingDir, this.vm4WorkingDir});
    }

    public static class ClientRun {
        public static void main(String[] args) {
            try {
                String host = args[0];
                int clientPort = Integer.parseInt(args[1]);
                int numInserts = Integer.parseInt(args[2]);
                File gemfirexdclientJar = new File(args[3]).getCanonicalFile();
                Class<?> clazz = Class.forName("com.pivotal.gemfirexd.jdbc.ClientDriver");
                TestCase.assertEquals((Object)gemfirexdclientJar.toURI(), (Object)clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
                Connection conn = DriverManager.getConnection("jdbc:gemfirexd://" + host + ':' + clientPort);
                Statement stmt = conn.createStatement();
                int id = 1;
                for (String ddl : DDLS) {
                    if (ddl.startsWith("drop")) {
                        BackwardCompatabilityDUnit.runDMLs(id, numInserts, conn);
                        id += numInserts;
                    }
                    stmt.execute(ddl);
                }
                BackwardCompatabilityDUnit.runDMLsAsBatch(id, numInserts, conn);
                conn.close();
                conn = DriverManager.getConnection("jdbc:gemfirexd://" + host + ':' + clientPort);
                stmt = conn.createStatement();
                BackwardCompatabilityDUnit.verifyData(conn, id += numInserts, false);
                conn.close();
            }
            catch (Throwable t) {
                System.out.println("ERROR: unexpected exception: " + t);
                t.printStackTrace(System.out);
                System.exit(1);
            }
        }
    }

    public static class ProductClient {
        private static final String[] DDL_STMTS = new String[]{"create schema upgradetest", "create table upgradetest.t1(id int, addr varchar(100))", "drop table upgradetest.t1", "create table upgradetest.t1(id int, addr varchar(100)) persistent", "create index upgradetest.idx_id on upgradetest.t1(id)", "create table upgradetest.t2(id int primary key, addr varchar(100))", "create table upgradetest.t3(id int primary key, addr varchar(100)) persistent", "create index idx_t3_id on upgradetest.t3(id)", "create table upgradetest.t4(id1 int, id2 int, addr varchar(100), constraint t4_pk primary key(id1, id2)) persistent", "create index idx_t4_id1 on upgradetest.t4(id1)", "create index idx_t4_id2 on upgradetest.t4(id2)", "create table upgradetest.t5(id int primary key, addr varchar(100)) persistent", "create table upgradetest.t6(id int primary key, addr varchar(100)) persistent partition by primary key", "create table upgradetest.t7(id1 int primary key, id2 int, addr varchar(100)) persistent partition by column(id2)", "create table upgradetest.t9(id int, clobcol clob(300K), blobcol blob(3K)) persistent", "create table upgradetest.t10(id int primary key, id2 int not null unique, addr varchar(100)) persistent partition by column(addr)", "create table upgradetest.t11(id int, id2 int, addr varchar(100) not null unique) persistent partition by column(id2)", "create table upgradetest.t12(id int primary key generated always as identity, clobcol clob(300K) not null, blobcol blob(3K)) persistent partition by column(clobcol)"};
        private static final String[] DML_STMTS = new String[]{"insert into upgradetest.t1 values(?,?)", "insert into upgradetest.t2 values(?,?)", "insert into upgradetest.t3 values(?,?)", "insert into upgradetest.t4 values(?,?,?)", "insert into upgradetest.t5 values(?,?)", "insert into upgradetest.t6 values(?,?)", "insert into upgradetest.t7 values(?,?,?)", "insert into upgradetest.t9 values(?,?,?)", "insert into upgradetest.t10 values(?,?,?)", "insert into upgradetest.t11 values(?,?,?)", "insert into upgradetest.t12(clobcol,blobcol) values(?,?)"};
        private static final String[] DDL_STMTS_CUSTOM_DISKSTORE = new String[]{"create DiskStore TESTSTORE maxlogsize 1024 autocompact true allowforcecompaction false compactionthreshold 80 TimeInterval 223344 writebuffersize 19292393 queuesize 17374  ('dir1')", "create table upgradetest.t8(id1 int primary key, id2 int, addr varchar(100)) partition by column(id2) persistent 'TESTSTORE'"};
        private static final String[] DML_STMTS_CUSTOM_DISKSTORE = new String[]{"insert into upgradetest.t8 values(?,?,?)"};
        private static final String[] DDL_STMTS_BUG50794 = new String[]{"CREATE TABLE upgradetest.PENCIL_DEFAULT (ID INTEGER ,HEADER_TEXT VARCHAR(255),STORE_ID VARCHAR(15) NOT NULL,CONSTRAINT PENCIL_DEFAULT_PK PRIMARY KEY(ID))PERSISTENT ASYNCHRONOUS EVICTION BY LRUCOUNT 2 EVICTACTION OVERFLOW REDUNDANCY 1 RECOVERYDELAY 5000 PARTITION BY COLUMN (STORE_ID) "};
        private static final String[] DML_STMTS_BUG50794 = new String[]{"insert into upgradetest.pencil_default values(?,?,?)"};
        private static final String[] TABLE_NAMES = new String[]{"t1", "t2", "t3", "t4", "t5", "t6", "t7", "t9", "t10", "t11", "t12"};
        private static final String[] TABLE_NAMES_CUSTOM_DISKSTORE = new String[]{"t8"};
        private static final String[] TABLE_NAMES_BUG50794 = new String[]{"PENCIL_DEFAULT"};

        public static void main(String[] args) {
            try {
                Connection conn;
                String urlPrefix;
                String product = args[0];
                String host = args[1];
                int clientPort = Integer.parseInt(args[2]);
                File clientJar = new File(args[3]).getCanonicalFile();
                boolean useSQLFireURL = Boolean.parseBoolean(args[4]);
                switch (product) {
                    case "SQLFIRE": {
                        Class<?> clazz = Class.forName("com.vmware.sqlfire.jdbc.ClientDriver");
                        URI classJarURI = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
                        if (!clientJar.toURI().equals(classJarURI)) {
                            throw new AssertionError((Object)("Expected URI=" + clientJar.toURI() + " classURI=" + classJarURI));
                        }
                        urlPrefix = "jdbc:sqlfire://";
                        break;
                    }
                    case "GEMFIREXD": {
                        Class<?> clazz = Class.forName("com.pivotal.gemfirexd.jdbc.ClientDriver");
                        URI classJarURI = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
                        if (!clientJar.toURI().equals(classJarURI)) {
                            throw new AssertionError((Object)("Expected URI=" + clientJar.toURI() + " classURI=" + classJarURI));
                        }
                        if (useSQLFireURL) {
                            urlPrefix = "jdbc:sqlfire://";
                            break;
                        }
                        urlPrefix = "jdbc:gemfirexd://";
                        break;
                    }
                    default: {
                        throw new Exception("No PRODUCT set");
                    }
                }
                String connectString = urlPrefix + host + ':' + clientPort;
                System.out.println("Creating a client connection with connect string:" + connectString);
                int attempts = 1;
                while (true) {
                    try {
                        System.out.println("getConnection:attempt-" + attempts);
                        Properties props = new Properties();
                        props.put("load-balance", "false");
                        conn = DriverManager.getConnection(connectString, props);
                        if (product.equals("SQLFIRE") || conn.getTransactionIsolation() != 0) {
                            conn.setAutoCommit(true);
                        }
                        System.out.println("Client connection created with isolation level=" + conn.getTransactionIsolation() + " and autocommit=" + conn.getAutoCommit());
                    }
                    catch (SQLException e) {
                        if (attempts++ < 10 && e.getSQLState().startsWith("08")) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
                String doMethod = args[5];
                Method method = ProductClient.class.getMethod(doMethod, Connection.class);
                method.invoke(null, conn);
                conn.close();
            }
            catch (Throwable t) {
                System.out.println("ERROR: unexpected exception: " + t);
                t.printStackTrace(System.out);
                System.exit(1);
            }
        }

        public static void createDataForClient(Connection conn) throws Exception {
            System.out.println("Creating tables");
            Statement st = conn.createStatement();
            st.execute("create diskstore customds");
            st.execute("create table t1(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
            st.execute("create table t2(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) colocate with (t1) redundancy 1 persistent 'customds'");
            st.execute("create table t3(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
            st.execute("create table t4(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
            st.execute("create table t5(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
            st.execute("create table t6(id1 varchar(40) not null, id2 integer not null, ts timestamp not null, other_ts timestamp, primary key(id1, id2, ts)) partition by column(id1, id2, ts) redundancy 1 persistent 'customds'");
            System.out.println("Creating indices");
            st.execute("create index idx1_t1 on t1(id2, id1)");
            st.execute("create index idx2_t1 on t2(id1, ts)");
            st.close();
            System.out.println("Inserting data");
            PreparedStatement ps = conn.prepareStatement("insert into t1 values(?,?,?,?)");
            for (int j = 0; j < 5; ++j) {
                int id = j * 100;
                ps.setString(1, String.valueOf(id));
                ps.setInt(2, id);
                ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                ps.execute();
            }
            ps.close();
            PreparedStatement ps2 = conn.prepareStatement("insert into t2 values(?,?,?,?)");
            for (int k = 0; k < 5; ++k) {
                int id = k * 100;
                ps2.setString(1, String.valueOf(id));
                ps2.setInt(2, id);
                ps2.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                ps2.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                ps2.execute();
            }
            ps2.close();
        }

        public static void addDataForClient(Connection conn) throws SQLException {
            ProductClient.addData(conn, DDL_STMTS, DML_STMTS);
            ProductClient.addData(conn, DDL_STMTS_CUSTOM_DISKSTORE, DML_STMTS_CUSTOM_DISKSTORE);
        }

        public static void addDataForBug50794(Connection conn) throws SQLException {
            ProductClient.addData(conn, DDL_STMTS_BUG50794, DML_STMTS_BUG50794);
        }

        public static void addData(Connection conn, String[] DDLs, String[] DMLs) throws SQLException {
            boolean hasDDLs;
            boolean bl = hasDDLs = DDLs != null;
            if (hasDDLs) {
                ProductClient.runDDLs(conn, DDLs);
            }
            if (DMLs != null) {
                ProductClient.runDMLs(conn, DMLs, hasDDLs ? 1 : 11);
            }
        }

        public static void runDDLs(Connection conn, String[] DDLs) throws SQLException {
            for (String stmt : DDLs) {
                System.out.println("DDL:" + stmt);
                conn.createStatement().execute(stmt);
            }
            System.out.println("Done executing DDLs");
        }

        public static void runDMLs(Connection conn, String[] DMLs, int startId) throws SQLException {
            for (String st : DMLs) {
                System.out.println("DML:" + st);
                PreparedStatement s = conn.prepareStatement(st);
                ParameterMetaData metaData = s.getParameterMetaData();
                int paramCount = metaData.getParameterCount();
                for (int id = startId; id <= 9 + startId; ++id) {
                    for (int i = 1; i <= paramCount; ++i) {
                        int type = metaData.getParameterType(i);
                        if (type == 4) {
                            s.setInt(i, id);
                            continue;
                        }
                        if (2005 == type) {
                            s.setString(i, "clob" + id);
                            continue;
                        }
                        if (12 == type) {
                            s.setString(i, "addr" + id);
                            continue;
                        }
                        if (2004 != type) continue;
                        s.setBytes(i, ("blob" + id).getBytes());
                    }
                    s.execute();
                }
                s.close();
            }
            System.out.println("Done executing DMLs");
        }

        public static void verifyDataForClient(Connection conn) throws SQLException {
            ProductClient.verifyData(conn, TABLE_NAMES);
            ProductClient.verifyData(conn, TABLE_NAMES_CUSTOM_DISKSTORE);
        }

        public static void verifyDataForClientBug50794(Connection conn) throws SQLException {
            ProductClient.verifyData(conn, TABLE_NAMES_BUG50794);
        }

        public static void verifyData(Connection conn, String[] tables2) throws SQLException {
            SQLException exception = null;
            for (String table : tables2) {
                try {
                    HashSet<Integer> resultIds = new HashSet<Integer>();
                    System.out.println("Verifying table " + table);
                    java.sql.ResultSet rs = conn.createStatement().executeQuery("select * from upgradetest." + table);
                    ResultSetMetaData rsm = rs.getMetaData();
                    int colCount = rsm.getColumnCount();
                    while (rs.next()) {
                        int resId = rs.getInt(1);
                        if (resultIds.contains(resId)) {
                            throw new AssertionError((Object)("double result for " + resId));
                        }
                        if (resId <= 0) {
                            throw new AssertionError((Object)("unexpected ID " + resId));
                        }
                        resultIds.add(resId);
                        for (int i = 2; i <= colCount; ++i) {
                            int value;
                            int colType = rsm.getColumnType(i);
                            if (colType == 12 || colType == 1 || colType == 2005) {
                                String value2 = rs.getString(i);
                                if (value2 == null) {
                                    throw new AssertionError((Object)"unexpected null value");
                                }
                                continue;
                            }
                            if (colType == 2004) {
                                byte[] value3 = rs.getBytes(i);
                                if (value3 == null) {
                                    throw new AssertionError((Object)"unexpected null value");
                                }
                                continue;
                            }
                            if (colType == 4 && (value = rs.getInt(i)) <= 0) {
                                throw new AssertionError((Object)("unexpected value=" + value));
                            }
                        }
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        static /* synthetic */ String[] access$000() {
            return DDL_STMTS;
        }

        static /* synthetic */ String[] access$100() {
            return DDL_STMTS_CUSTOM_DISKSTORE;
        }

        static /* synthetic */ String[] access$200() {
            return DML_STMTS;
        }

        static /* synthetic */ String[] access$300() {
            return TABLE_NAMES;
        }

        static /* synthetic */ String[] access$400() {
            return TABLE_NAMES_CUSTOM_DISKSTORE;
        }

        static /* synthetic */ String[] access$500() {
            return TABLE_NAMES_BUG50794;
        }
    }
}

