/*
 * Decompiled with CFR 0.152.
 */
package com.jpmorgan.tss.securitas.strategic.logsynctable.db.gemfirexd.callbacks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.ManagerLogWriter;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.callbacks.DBSynchronizer;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.execute.QueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.BatchUpdateException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectDBSynchronizer
extends DBSynchronizer {
    private static final Pattern deleteQueryPattern = Pattern.compile("^\\s*DELETE\\s+FROM\\s+.*$", 42);
    protected String errorFile;
    protected OutputStream errorStream;
    protected XMLStreamWriter errorWriter;
    protected HashMap<String, HashSet<String>> parentTables;
    protected static final String ERROR_ENTRIES_SUFFIX = "_entries";
    protected static final int DEFAULT_ERROR_TRIES = 3;
    protected int numErrorTries = 0;
    protected final ConcurrentHashMap<Event, Object[]> errorTriesMap = new ConcurrentHashMap(16, 0.75f, 2);
    protected static final String ERR_XML_ROOT = "failures";
    protected static final String ERR_XML_ENTRIES_ENTITY = "errorEntries";
    protected static final String ERR_XML_FAILURE = "failure";
    protected static final String ERR_XML_SQL = "sql";
    protected static final String ERR_XML_PARAMS = "parameters";
    protected static final String ERR_XML_PARAM = "param";
    protected static final String ERR_XML_ATTR_TYPE = "jtype";
    protected static final String ERR_XML_ATTR_NULL = "isnull";
    protected static final String ERR_XML_EXCEPTION = "exception";
    protected static final String ERR_XML_SQLSTATE = "sqlstate";
    protected static final String ERR_XML_ERRCODE = "errorcode";
    protected static final String ERR_XML_EX_MESSAGE = "message";
    protected static final String ERR_XML_EX_CLASS = "class";
    protected static final String ERR_XML_EX_STACK = "stack";
    protected static final String ERRORFILE = "errorfile";
    protected static final String ERRORTRIES = "errortries";
    protected static final String Gfxd_DB_SYNCHRONIZER__14 = "SectDBSynchronizer::close: Error in closing XML stream writer for '%s'";
    protected static final String Gfxd_DB_SYNCHRONIZER__15 = "SectDBSynchronizer::close: Error in closing XML stream for '%s'";
    protected static final String Gfxd_DB_SYNCHRONIZER_16 = "SectDBSynchronizer::init: could not rename '%s' to '%s'.";
    protected final Logger logger2 = LoggerFactory.getLogger((String)"com.pivotal.gemfirexd");
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void init(String initParamStr) {
        this.driver = null;
        this.driverClass = null;
        this.dbUrl = null;
        this.userName = null;
        this.passwd = null;
        this.errorFile = null;
        this.errorStream = null;
        this.errorWriter = null;
        this.numErrorTries = 0;
        String propsFile = this.startsWithIgnoreCase(initParamStr, "file=");
        if (propsFile != null) {
            FileInputStream fis = null;
            Properties props = new Properties();
            try {
                fis = new FileInputStream(propsFile);
                props.load(fis);
            }
            catch (Exception e) {
                throw this.helper.newRuntimeException(String.format("DBSynchronizer::init: Exception in loading properties file '%s' for initialization", propsFile), (Throwable)e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {}
            }
            try {
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = ((String)entry.getKey()).trim();
                    String value = ((String)entry.getValue()).trim();
                    if ("driver".equalsIgnoreCase(key)) {
                        this.driverClass = value;
                    } else if ("url".equalsIgnoreCase(key)) {
                        this.dbUrl = value;
                    } else if ("user".equalsIgnoreCase(key)) {
                        this.userName = value;
                    } else if (ERRORFILE.equalsIgnoreCase(key)) {
                        this.errorFile = value;
                    } else if (ERRORTRIES.equalsIgnoreCase(key)) {
                        this.numErrorTries = Integer.parseInt(value);
                    } else if ("password".equalsIgnoreCase(key)) {
                        this.passwd = value;
                    } else if ("transformation".equalsIgnoreCase(key)) {
                        this.transformation = value;
                    } else if ("keysize".equalsIgnoreCase(key)) {
                        this.keySize = Integer.parseInt(value);
                    } else {
                        throw new IllegalArgumentException(String.format("DBSynchronizer::init: unknown property '%s' in file '%s'", key, propsFile));
                    }
                    if (this.passwd == null) continue;
                    AsyncEventHelper.decryptPassword((String)this.userName, (String)this.passwd, (String)this.transformation, (int)this.keySize);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.helper.newRuntimeException(String.format("DBSynchronizer::init: Exception in loading properties file '%s' for initialization", propsFile), (Throwable)e);
            }
            if (this.driverClass == null || this.driverClass.length() == 0 || this.dbUrl == null || this.dbUrl.length() == 0) {
                throw new IllegalArgumentException(String.format("DBSynchronizer::init: missing Driver or URL properties in file '%s'", propsFile));
            }
        } else {
            this.inlineInit(initParamStr);
        }
        if (this.errorFile != null && this.numErrorTries == 0) {
            this.numErrorTries = 3;
        }
        this.initConnection();
        this.parentTables = new HashMap();
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            GemFireStore store = Misc.getMemStoreBooting();
            for (GemFireContainer container : store.getAllContainers()) {
                if (!container.isApplicationTable() || container.getRegion().getAsyncEventQueueIds().isEmpty()) continue;
                String schema = container.getSchemaName();
                String tableName = container.getTableName();
                this.addParentTables(metaData, schema, tableName, container.getQualifiedTableName());
            }
            HashSet<String> merged = new HashSet<String>();
            for (Map.Entry<String, HashSet<String>> entry : this.parentTables.entrySet()) {
                this.mergeParentTables(entry.getKey(), entry.getValue(), merged);
            }
        }
        catch (Exception e) {
            String maskedPasswordDbUrl = null;
            if (this.dbUrl != null) {
                maskedPasswordDbUrl = SectDBSynchronizer.maskPassword((String)this.dbUrl);
            }
            throw this.helper.newRuntimeException(String.format("DBSynchronizer::init: Exception while initializing connection for driver class '%s' and db url = %s", this.driverClass, maskedPasswordDbUrl), (Throwable)e);
        }
    }

    protected void addParentTables(DatabaseMetaData metaData, String schema, String tableName, String fullTableName) throws SQLException {
        HashSet<String> parents = this.parentTables.get(fullTableName);
        if (parents == null) {
            parents = new HashSet(5);
            this.parentTables.put(fullTableName, parents);
        }
        ResultSet parentRS = metaData.getImportedKeys(null, schema, tableName);
        while (parentRS.next()) {
            String parentSchema = parentRS.getString("PKTABLE_SCHEM");
            String parentTableName = parentRS.getString("PKTABLE_NAME");
            parents = this.parentTables.get(fullTableName);
            if (parentSchema == null) {
                parentSchema = schema;
            }
            parents.add(parentSchema != null ? parentSchema + '.' + parentTableName : parentTableName);
        }
        parentRS.close();
    }

    protected final void mergeParentTables(String fullTableName, HashSet<String> parents, HashSet<String> merged) {
        if (parents != null) {
            String[] parentsArray;
            merged.add(fullTableName);
            for (String parent : parentsArray = parents.toArray(new String[parents.size()])) {
                HashSet<String> pparents = this.parentTables.get(parent);
                if (pparents == null) continue;
                if (!merged.contains(parent)) {
                    this.mergeParentTables(parent, pparents, merged);
                }
                parents.addAll(pparents);
            }
        }
    }

    protected void inlineInit(String initParamStr) {
        String[] params = initParamStr.split(",");
        if (params.length < 2) {
            throw new IllegalArgumentException(String.format("DBSynchronizer::init: Illegal format of init string '%s', expected <driver>,<URL>,...", initParamStr));
        }
        this.driverClass = params[0].trim();
        this.dbUrl = params[1].trim();
        if (params.length > 2) {
            try {
                for (int index = 2; index < params.length; ++index) {
                    String param = params[index];
                    String paramValue = this.startsWithIgnoreCase(param, "errorfile=");
                    if (paramValue != null) {
                        this.errorFile = paramValue.trim();
                        continue;
                    }
                    paramValue = this.startsWithIgnoreCase(param, "errortries=");
                    if (paramValue != null) {
                        this.numErrorTries = Integer.parseInt(paramValue.trim());
                        continue;
                    }
                    this.userName = param.trim();
                    if (params.length > index + 1) {
                        if (params.length > index + 2) {
                            int len = 0;
                            for (int i = 0; i <= index; ++i) {
                                len += params[i].length() + 1;
                            }
                            this.passwd = initParamStr.substring(len);
                        } else {
                            this.passwd = params[index + 1];
                        }
                        AsyncEventHelper.decryptPassword((String)this.userName, (String)this.passwd, (String)this.transformation, (int)this.keySize);
                    }
                    break;
                }
            }
            catch (Exception e) {
                String maskedPasswdDbUrl = null;
                if (this.dbUrl != null) {
                    maskedPasswdDbUrl = SectDBSynchronizer.maskPassword((String)this.dbUrl);
                }
                throw this.helper.newRuntimeException(String.format("DBSynchronizer::init: Exception while initializing connection for driver class '%s' and db url = %s", this.driverClass, maskedPasswdDbUrl), (Throwable)e);
            }
        }
    }

    protected String startsWithIgnoreCase(String s, String prefix) {
        if (s.length() > prefix.length() && (s.startsWith(prefix) || prefix.equalsIgnoreCase(s.substring(0, prefix.length())))) {
            return s.substring(prefix.length());
        }
        return null;
    }

    protected synchronized void initErrorFile() throws Exception {
        if (this.errorFile != null && this.errorWriter == null) {
            int dotIndex = this.errorFile.lastIndexOf(46);
            if (dotIndex <= 0 || !"xml".equalsIgnoreCase(this.errorFile.substring(dotIndex + 1))) {
                this.errorFile = this.errorFile.concat(".xml");
            }
            String errorFileName = this.errorFile.substring(0, this.errorFile.length() - 4);
            String errorEntriesFile = errorFileName + ERROR_ENTRIES_SUFFIX + ".xml";
            String errorRootFile = this.errorFile;
            this.errorFile = errorEntriesFile;
            errorEntriesFile = this.rollFileIfRequired(errorEntriesFile, this.logger2);
            FileOutputStream xmlStream = new FileOutputStream(errorRootFile);
            String encoding = "UTF-8";
            XMLOutputFactory xmlFactory = XMLOutputFactory.newFactory();
            XMLStreamWriter xmlWriter = xmlFactory.createXMLStreamWriter(xmlStream, "UTF-8");
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeDTD("<!DOCTYPE staticinc [ <!ENTITY errorEntries SYSTEM \"" + new File(errorEntriesFile).getName() + "\"> ]>");
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement(ERR_XML_ROOT);
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEntityRef(ERR_XML_ENTRIES_ENTITY);
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
            xmlStream.flush();
            xmlStream.close();
            this.errorStream = new BufferedOutputStream(new FileOutputStream(this.errorFile));
            if (xmlFactory.isPropertySupported("com.ctc.wstx.outputValidateStructure")) {
                xmlFactory.setProperty("com.ctc.wstx.outputValidateStructure", Boolean.FALSE);
            }
            this.errorWriter = xmlFactory.createXMLStreamWriter(this.errorStream, "UTF-8");
        }
    }

    public String rollFileIfRequired(String logfile, Logger logger) {
        File logFile = new File(logfile);
        if (logFile.exists()) {
            File oldMain = ManagerLogWriter.getLogNameForOldMainLog((File)logFile, (boolean)false);
            if (!logFile.renameTo(oldMain)) {
                logfile = oldMain.getPath();
                if (logger.isWarnEnabled()) {
                    logger.info(Gfxd_DB_SYNCHRONIZER_16, (Object)logFile, (Object)oldMain);
                }
            } else {
                logfile = logFile.getPath();
            }
        }
        return logfile;
    }

    public synchronized void close() {
        super.close();
        if (this.errorWriter != null) {
            try {
                this.errorWriter.flush();
                this.errorWriter.close();
            }
            catch (Exception e) {
                this.helper.logFormat(this.logger, Level.WARNING, (Throwable)e, Gfxd_DB_SYNCHRONIZER__14, new Object[]{this.errorFile});
            }
            this.errorWriter = null;
        }
        if (this.errorStream != null) {
            try {
                this.errorStream.flush();
                this.errorStream.close();
            }
            catch (Exception e) {
                this.helper.logFormat(this.logger, Level.WARNING, (Throwable)e, Gfxd_DB_SYNCHRONIZER__15, new Object[]{this.errorFile});
            }
            this.errorStream = null;
        }
        this.errorFile = null;
    }

    private boolean compareColumns(ResultSetMetaData meta1, ResultSetMetaData meta2) throws SQLException {
        int numColumns = meta1.getColumnCount();
        if (meta2.getColumnCount() != numColumns) {
            return false;
        }
        for (int i = 1; i <= numColumns; ++i) {
            if (meta1.getColumnType(i) == meta2.getColumnType(i) && meta1.getColumnName(i).equals(meta2.getColumnName(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processEvents(List<Event> events) {
        boolean completedSucessfully;
        block98: {
            Iterator<Event> i$;
            block103: {
                block102: {
                    block96: {
                        if (this.shutDown) {
                            return false;
                        }
                        QueryObserver observer = QueryObserverHolder.getInstance();
                        this.traceDBSynchronizer = this.helper.traceDBSynchronizer() && this.logger.isLoggable(Level.INFO);
                        boolean traceDBSynchronizer = this.traceDBSynchronizer;
                        completedSucessfully = false;
                        String listOfEventsString = null;
                        Statement stmt = null;
                        Statement ps = null;
                        Event event = null;
                        Event.Type evType = null;
                        Iterator<Event> eventItr = events.iterator();
                        ArrayList<List<Object>> batchEvents = new ArrayList<List<Object>>();
                        TObjectIntHashMap tablesSeen = new TObjectIntHashMap();
                        while (true) {
                            boolean foundExisting;
                            String tableName;
                            block100: {
                                block92: {
                                    List prevEvents;
                                    Event prevEv;
                                    String eventDML;
                                    int batchIndex;
                                    block99: {
                                        if (!eventItr.hasNext()) break;
                                        event = eventItr.next();
                                        evType = event.getType();
                                        tableName = event.getTableName();
                                        batchIndex = tablesSeen.get((Object)tableName);
                                        foundExisting = false;
                                        if (evType.isBulkOperation()) break block99;
                                        if (traceDBSynchronizer) {
                                            this.logger.info("SectDBSynchronizer::processEvents :processing PK based event=" + event + ", type=" + evType);
                                        }
                                        switch (evType) {
                                            case AFTER_INSERT: {
                                                List prevEvents2;
                                                if (batchIndex > 0 && ((Event)(prevEvents2 = (List)batchEvents.get(batchIndex - 1)).get(0)).getType() == Event.Type.AFTER_INSERT) {
                                                    prevEvents2.add(event);
                                                    foundExisting = true;
                                                }
                                                break block92;
                                            }
                                            case AFTER_UPDATE: {
                                                List prevEvents2;
                                                if (batchIndex > 0) {
                                                    prevEvents2 = (List)batchEvents.get(batchIndex - 1);
                                                    Event prevEvent = (Event)prevEvents2.get(0);
                                                    try {
                                                        if (prevEvent.getType() == Event.Type.AFTER_UPDATE && this.compareColumns(event.getNewRowsAsResultSet().getMetaData(), prevEvent.getNewRowsAsResultSet().getMetaData())) {
                                                            prevEvents2.add(event);
                                                            foundExisting = true;
                                                        }
                                                        break block92;
                                                    }
                                                    catch (SQLException sQLException) {}
                                                }
                                                break block92;
                                            }
                                            case AFTER_DELETE: {
                                                this.logger.info("SectDBSynchronizer::processEvents: skipping the delete operation for event=" + event.toString());
                                                break;
                                            }
                                            default: {
                                                this.logger.severe("SectDBSynchronizer::processEvents: unexpected eventType " + evType + " for " + event.toString());
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    if (traceDBSynchronizer) {
                                        this.logger.info("SectDBSynchronizer::processEvents: processing Bulk DML Event=" + event);
                                    }
                                    if ((eventDML = event.getDMLString()) != null && deleteQueryPattern.matcher(eventDML).find()) {
                                        this.logger.info("SectDBSynchronizer::processEvents: skipping the delete operation for event=" + event.toString());
                                        continue;
                                    }
                                    if (evType == Event.Type.BULK_DML && batchIndex > 0 && (prevEv = (Event)(prevEvents = (List)batchEvents.get(batchIndex - 1)).get(0)).getType() == Event.Type.BULK_DML && eventDML.equals(prevEv.getDMLString())) {
                                        prevEvents.add(event);
                                        foundExisting = true;
                                    }
                                }
                                if (tablesSeen.size() <= 0) break block100;
                                Object[] tables2 = tablesSeen.keys();
                                DatabaseMetaData metaData = null;
                                Object[] arr$ = tables2;
                                int len$ = arr$.length;
                                for (int i$2 = 0; i$2 < len$; ++i$2) {
                                    Object childTable = arr$[i$2];
                                    HashSet<String> parents = this.parentTables.get(childTable);
                                    if (parents == null) {
                                        String childTableName = (String)childTable;
                                        String childSchema = null;
                                        int dotIndex = childTableName.indexOf(46);
                                        if (dotIndex > 0) {
                                            childSchema = childTableName.substring(0, dotIndex);
                                            childTableName = childTableName.substring(dotIndex + 1);
                                        }
                                        try {
                                            if (metaData == null) {
                                                metaData = this.conn.getMetaData();
                                            }
                                            this.addParentTables(metaData, childSchema, childTableName, (String)childTable);
                                            parents = this.parentTables.get(childTable);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (parents == null || !parents.contains(tableName)) continue;
                                    tablesSeen.remove(childTable);
                                }
                            }
                            if (foundExisting) continue;
                            if (evType.isBulkInsert()) {
                                batchEvents.add(Collections.singletonList(event));
                                tablesSeen.remove((Object)tableName);
                                continue;
                            }
                            ArrayList<Event> eventList = new ArrayList<Event>(4);
                            eventList.add(event);
                            batchEvents.add(eventList);
                            tablesSeen.put((Object)tableName, batchEvents.size());
                        }
                        Iterator batchItr = batchEvents.iterator();
                        List batch = null;
                        boolean hasBatch = false;
                        String eventString = null;
                        event = null;
                        evType = null;
                        try {
                            while (!(completedSucessfully = !batchItr.hasNext())) {
                                Statement prevPS = null;
                                batch = (List)batchItr.next();
                                int batchSize = batch.size();
                                boolean isPKBased = false;
                                eventString = null;
                                hasBatch = batchSize > 1;
                                for (int batchIndex = 0; batchIndex < batchSize; ++batchIndex) {
                                    block93: {
                                        DBSynchronizer.SqlExceptionHandler handler;
                                        event = (Event)batch.get(batchIndex);
                                        evType = event.getType();
                                        eventString = traceDBSynchronizer ? event.toString() : null;
                                        if (!evType.isBulkOperation()) {
                                            isPKBased = true;
                                            try {
                                                switch (evType) {
                                                    case AFTER_INSERT: {
                                                        ps = this.getExecutableInsertPrepStmntPKBased(event, (PreparedStatement)prevPS);
                                                        break block93;
                                                    }
                                                    case AFTER_UPDATE: {
                                                        ps = this.getExecutableUpdatePrepStmntPKBased(event, (PreparedStatement)prevPS);
                                                        break block93;
                                                    }
                                                    default: {
                                                        this.logger.severe("SectDBSynchronizer::processEvents: unexpected eventType " + evType + " for " + event);
                                                        break;
                                                    }
                                                }
                                                continue;
                                            }
                                            catch (SQLException sqle) {
                                                handler = this.handleSQLException(sqle, "DBSynchronizer::processEvents: Exception while fetching prepared statement for event '%s': %s", null, event, eventString, this.logger, true);
                                                if (handler.breakTheLoop()) {
                                                    break;
                                                }
                                                break block93;
                                            }
                                            catch (RegionDestroyedException rde) {
                                                if (!this.logger.isLoggable(Level.INFO)) continue;
                                                this.logger.info("SectDBSynchronizer::processEvents: WBCLEvent " + event + " will  be discarded as the underlying region " + "for the table has been destroyed");
                                                continue;
                                            }
                                        }
                                        isPKBased = false;
                                        try {
                                            ps = this.getExecutablePrepStmntBulkOp(event, (PreparedStatement)prevPS);
                                            if (ps != null) break block93;
                                            if (stmt == null) {
                                                stmt = this.conn.createStatement();
                                            }
                                            if (hasBatch) {
                                                stmt.addBatch(event.getDMLString());
                                            }
                                        }
                                        catch (SQLException sqle) {
                                            handler = this.handleSQLException(sqle, "DBSynchronizer::processEvents: Exception while fetching prepared statement for event '%s': %s", null, event, eventString, this.logger, true);
                                            if (handler.breakTheLoop()) break;
                                        }
                                    }
                                    prevPS = ps;
                                }
                                try {
                                    int num;
                                    int[] res;
                                    if (evType.isBulkInsert()) {
                                        hasBatch = true;
                                        if (traceDBSynchronizer) {
                                            this.logger.info("SectDBSynchronizer::processEvents executing batch insert for bulk statement=" + ps + " for event=" + eventString);
                                        }
                                        res = ps.executeBatch();
                                        num = res.length;
                                        this.helper.removeEventFromFailureMap(event);
                                        if (traceDBSynchronizer) {
                                            this.logger.info("SectDBSynchronizer::processEvents total num rows modified=" + num + " for statement=" + ps + " for event=" + eventString);
                                        }
                                        if (observer == null) continue;
                                        observer.afterBulkOpDBSynchExecution(evType, num, ps, event.getDMLString());
                                        continue;
                                    }
                                    if (ps != null) {
                                        if (hasBatch) {
                                            if (traceDBSynchronizer) {
                                                this.logger.info("SectDBSynchronizer::processEvents executing batch statement for prepared statement=" + ps + " for batchSize=" + batchSize + ": " + batch);
                                            }
                                            ps.addBatch();
                                            res = ps.executeBatch();
                                            num = res.length;
                                            for (Event ev : batch) {
                                                this.helper.removeEventFromFailureMap(ev);
                                            }
                                        } else {
                                            if (traceDBSynchronizer) {
                                                this.logger.info("SectDBSynchronizer::processEvents executing update statement for prepared statement=" + ps + " for event=" + eventString);
                                            }
                                            num = ps.executeUpdate();
                                            this.helper.removeEventFromFailureMap(event);
                                        }
                                        if (observer != null) {
                                            if (isPKBased) {
                                                observer.afterPKBasedDBSynchExecution(evType, num, ps);
                                            } else {
                                                observer.afterBulkOpDBSynchExecution(evType, num, ps, event.getDMLString());
                                            }
                                        }
                                    } else if (hasBatch) {
                                        if (traceDBSynchronizer) {
                                            this.logger.info("SectDBSynchronizer::processEvents executing batch unprepared statement=" + stmt + " for batchSize=" + batchSize + ": " + batch);
                                        }
                                        res = stmt.executeBatch();
                                        num = res.length;
                                        for (Event ev : batch) {
                                            this.helper.removeEventFromFailureMap(ev);
                                            if (observer == null) continue;
                                            observer.afterBulkOpDBSynchExecution(evType, num, stmt, ev.getDMLString());
                                        }
                                    } else {
                                        if (traceDBSynchronizer) {
                                            this.logger.info("SectDBSynchronizer::processEvents executing unprepared statement for event=" + eventString);
                                        }
                                        num = stmt.executeUpdate(event.getDMLString());
                                        this.helper.removeEventFromFailureMap(event);
                                        if (observer != null) {
                                            observer.afterBulkOpDBSynchExecution(evType, num, stmt, event.getDMLString());
                                        }
                                    }
                                    if (!traceDBSynchronizer) continue;
                                    this.logger.info("SectDBSynchronizer::processEvents num rows modified=" + num + " for statement=" + (ps != null ? ps : stmt));
                                }
                                catch (SQLException sqle) {
                                    DBSynchronizer.SqlExceptionHandler handler;
                                    block95: {
                                        try {
                                            if (ps != null) {
                                                if (hasBatch) {
                                                    ps.clearBatch();
                                                    break block95;
                                                } else {
                                                    ps.clearParameters();
                                                }
                                                break block95;
                                            }
                                            if (stmt != null && hasBatch) {
                                                stmt.clearBatch();
                                            }
                                        }
                                        catch (SQLException res) {
                                            // empty catch block
                                        }
                                    }
                                    if (!(handler = this.handleSQLException(sqle, "DBSynchronizer::processEvents: Operation failed for event '%s' due to exception: %s", ps != null ? ps : stmt, event, eventString, this.logger, false)).breakTheLoop()) continue;
                                }
                            }
                            if (!completedSucessfully) break block96;
                            try {
                                if (this.helper.logFineEnabled()) {
                                    if (listOfEventsString == null) {
                                        listOfEventsString = events.toString();
                                    }
                                    this.logger.fine("SectDBSynchronizer::processEvents: before commit of events=" + listOfEventsString);
                                }
                                this.conn.commit();
                                if (observer != null) {
                                    observer.afterCommitDBSynchExecution(events);
                                }
                                if (this.helper.logFineEnabled()) {
                                    if (listOfEventsString == null) {
                                        listOfEventsString = events.toString();
                                    }
                                    this.logger.fine("SectDBSynchronizer::processEvents: committed successfully for events=" + listOfEventsString);
                                }
                            }
                            catch (SQLException sqle) {
                                block97: {
                                    try {
                                        if (ps != null) {
                                            if (hasBatch) {
                                                ps.clearBatch();
                                                break block97;
                                            } else {
                                                ps.clearParameters();
                                            }
                                            break block97;
                                        }
                                        if (stmt != null && hasBatch) {
                                            stmt.clearBatch();
                                        }
                                    }
                                    catch (SQLException batchSize) {
                                        // empty catch block
                                    }
                                }
                                DBSynchronizer.SqlExceptionHandler handler = this.handleSQLException(sqle, "DBSynchronizer::processEvents: Exception occured while committing '%s' to external DB: %s", ps != null ? ps : stmt, event, eventString, this.logger, true);
                                if (handler != DBSynchronizer.SqlExceptionHandler.IGNORE) {
                                    completedSucessfully = false;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (this.logger != null && this.logger.isLoggable(Level.SEVERE) && (event == null || !this.helper.skipFailureLogging(event))) {
                                StringBuilder sb = new StringBuilder();
                                if (event != null) {
                                    if (eventString == null) {
                                        eventString = event.toString();
                                    }
                                    sb.append("[FAILED: ").append(eventString).append(" ]");
                                }
                                while (batchItr.hasNext()) {
                                    sb.append("[ ").append(((List)batchItr.next()).toString()).append(" ]");
                                }
                                this.helper.logFormat(this.logger, Level.SEVERE, (Throwable)e, "DBSynchronizer::processEvents: Unexpected Exception occured while processing Events. The list of unprocessed events is: %s. Attempt will be made to rollback the changes.", new Object[]{sb.toString()});
                            }
                            DBSynchronizer.SqlExceptionHandler.CLEANUP.execute((DBSynchronizer)this);
                            completedSucessfully = false;
                        }
                    }
                    if (!completedSucessfully) break block102;
                    if (this.numErrorTries <= 0 || this.errorTriesMap.size() <= 0) break block98;
                    i$ = events.iterator();
                    break block103;
                }
                try {
                    if (this.conn != null && !this.conn.isClosed()) {
                        this.conn.rollback();
                    }
                    break block98;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                break block98;
            }
            while (i$.hasNext()) {
                Event ev = i$.next();
                Object[] tries = this.errorTriesMap.remove(ev);
                if (tries == null || tries[1] == null || this.errorFile == null) continue;
                try {
                    this.logError(ev, (SQLException)tries[1]);
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.WARNING)) continue;
                    this.helper.log(this.logger, Level.WARNING, (Throwable)e, e.getMessage());
                }
            }
        }
        if (this.helper.traceExecute()) {
            this.logger.info("SectDBSynchronizer::processEvents: processed " + events.size() + " events, success=" + completedSucessfully);
        }
        return completedSucessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DBSynchronizer.SqlExceptionHandler handleSQLException(SQLException sqle) {
        DBSynchronizer.SqlExceptionHandler handler;
        String sqlState = sqle.getSQLState();
        if (sqlState == null) {
            if (sqle instanceof BatchUpdateException && sqle.getNextException() != null) {
                sqlState = "42Y96";
            } else {
                try {
                    SectDBSynchronizer sectDBSynchronizer = this;
                    synchronized (sectDBSynchronizer) {
                        if (this.conn == null || this.conn.isClosed()) {
                            return DBSynchronizer.SqlExceptionHandler.REFRESH;
                        }
                    }
                }
                catch (Exception e) {
                    return DBSynchronizer.SqlExceptionHandler.REFRESH;
                }
                return this.checkExceptionString(sqle.toString().toLowerCase(), DBSynchronizer.SqlExceptionHandler.REFRESH);
            }
        }
        if ((handler = this.checkExceptionType(sqle)) != null) {
            return handler;
        }
        if (sqlState.startsWith("23") || sqlState.startsWith("25")) {
            return DBSynchronizer.SqlExceptionHandler.IGNORE;
        }
        if (sqlState.startsWith("42") || sqlState.startsWith("22")) {
            return this.numErrorTries > 0 ? DBSynchronizer.SqlExceptionHandler.IGNORE_BREAK_LOOP : DBSynchronizer.SqlExceptionHandler.IGNORE;
        }
        if (sqlState.startsWith("08")) {
            return DBSynchronizer.SqlExceptionHandler.REFRESH;
        }
        if (sqlState.startsWith("40")) {
            return DBSynchronizer.SqlExceptionHandler.IGNORE_BREAK_LOOP;
        }
        if (sqle instanceof BatchUpdateException && sqle.getNextException() != null) {
            return this.handleSQLException(sqle.getNextException());
        }
        try {
            SectDBSynchronizer sectDBSynchronizer = this;
            synchronized (sectDBSynchronizer) {
                if (this.conn == null || this.conn.isClosed()) {
                    return DBSynchronizer.SqlExceptionHandler.REFRESH;
                }
            }
        }
        catch (Exception e) {
            return DBSynchronizer.SqlExceptionHandler.REFRESH;
        }
        return this.checkExceptionString(sqle.toString().toLowerCase(), DBSynchronizer.SqlExceptionHandler.REFRESH);
    }

    protected DBSynchronizer.SqlExceptionHandler checkExceptionType(SQLException sqle) {
        if (sqle != null) {
            if (sqle instanceof SQLNonTransientConnectionException) {
                return DBSynchronizer.SqlExceptionHandler.REFRESH;
            }
            if (sqle instanceof SQLIntegrityConstraintViolationException) {
                return DBSynchronizer.SqlExceptionHandler.IGNORE;
            }
            if (sqle instanceof SQLNonTransientException) {
                return this.numErrorTries > 0 ? DBSynchronizer.SqlExceptionHandler.IGNORE_BREAK_LOOP : DBSynchronizer.SqlExceptionHandler.IGNORE;
            }
            if (sqle instanceof SQLTransientException) {
                return DBSynchronizer.SqlExceptionHandler.IGNORE_BREAK_LOOP;
            }
            if (sqle instanceof BatchUpdateException) {
                return this.checkExceptionType(sqle.getNextException());
            }
        }
        return null;
    }

    protected DBSynchronizer.SqlExceptionHandler checkExceptionString(String message, DBSynchronizer.SqlExceptionHandler defaultHandler) {
        if (message.contains("constraint")) {
            return DBSynchronizer.SqlExceptionHandler.IGNORE;
        }
        if (message.contains("syntax")) {
            return this.numErrorTries > 0 ? DBSynchronizer.SqlExceptionHandler.IGNORE_BREAK_LOOP : DBSynchronizer.SqlExceptionHandler.IGNORE;
        }
        if (message.contains("connect")) {
            return DBSynchronizer.SqlExceptionHandler.REFRESH;
        }
        return defaultHandler;
    }

    protected DBSynchronizer.SqlExceptionHandler handleSQLException(SQLException sqle, String format, Statement stmt, Event event, String eventString, java.util.logging.Logger logger, boolean logWarning) throws SQLException {
        boolean skipLogging = false;
        DBSynchronizer.SqlExceptionHandler handler = this.handleSQLException(sqle);
        if (event != null && this.numErrorTries > 0) {
            Object[] tries = this.errorTriesMap.get(event);
            if (tries != null) {
                Integer numTries = (Integer)tries[0];
                if (numTries >= this.numErrorTries) {
                    handler = DBSynchronizer.SqlExceptionHandler.IGNORE;
                    logWarning = false;
                }
                tries[0] = numTries + 1;
                tries[1] = sqle;
            } else {
                this.errorTriesMap.put(event, new Object[]{1, sqle});
            }
        }
        if (event != null && (logWarning || this.traceDBSynchronizer)) {
            skipLogging = this.helper.skipFailureLogging(event);
            if (eventString == null) {
                eventString = event.toString();
            }
        }
        if (!skipLogging) {
            if (logWarning && logger.isLoggable(Level.WARNING)) {
                StringBuilder sqleStr = new StringBuilder();
                sqleStr.append(sqle);
                SQLException next = sqle;
                while ((next = next.getNextException()) != null) {
                    sqleStr.append("; ").append(next);
                }
                this.helper.logFormat(logger, Level.WARNING, null, format, new Object[]{eventString, sqleStr.toString()});
            }
            if (this.traceDBSynchronizer && logger.isLoggable(Level.WARNING)) {
                String stmtStr = stmt != null ? "executing statement=" + stmt : "preparing statement";
                this.helper.log(logger, Level.WARNING, (Throwable)sqle, "SectDBSynchronizer::processEvents: Exception while " + stmtStr + " for event=" + eventString);
                if (sqle.getNextException() != null) {
                    this.helper.log(logger, Level.WARNING, (Throwable)sqle.getNextException(), "SectDBSynchronizer::processEvents: next exception");
                }
            }
        }
        handler.execute((DBSynchronizer)this);
        return handler;
    }

    protected void logError(Event event, SQLException sqle) throws Exception {
        int[] paramTypes;
        List<Object> paramsBatch;
        String dmlString;
        this.initErrorFile();
        int indentStep = 2;
        int indent = 2;
        this.errorWriter.writeStartElement(ERR_XML_FAILURE);
        String tableName = event.getTableName();
        switch (event.getType()) {
            case AFTER_INSERT: {
                int jdbcType;
                Object metadata = event.getResultSetMetaData();
                int numColumns = metadata.getColumnCount();
                dmlString = AsyncEventHelper.getInsertString((String)tableName, (TableMetaData)((TableMetaData)metadata), (boolean)false);
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                ResultSet rows = event.getNewRowsAsResultSet();
                for (int colIdx = 1; colIdx <= numColumns; ++colIdx) {
                    jdbcType = metadata.getColumnType(colIdx);
                    params[colIdx - 1] = SectDBSynchronizer.getColumnAsString(rows, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                break;
            }
            case AFTER_UPDATE: {
                int colIdx;
                int jdbcType;
                ResultSet rows = event.getNewRowsAsResultSet();
                Object metadata = rows.getMetaData();
                int numUpdatedCols = metadata.getColumnCount();
                ResultSet pkResultSet = event.getPrimaryKeysAsResultSet();
                ResultSetMetaData pkMetaData = pkResultSet.getMetaData();
                int n = pkMetaData.getColumnCount();
                int numColumns = numUpdatedCols + n;
                dmlString = AsyncEventHelper.getUpdateString((String)tableName, (ResultSetMetaData)pkMetaData, (ResultSetMetaData)metadata);
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                for (colIdx = 1; colIdx <= numUpdatedCols; ++colIdx) {
                    jdbcType = metadata.getColumnType(colIdx);
                    params[colIdx - 1] = SectDBSynchronizer.getColumnAsString(rows, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                for (colIdx = 1; colIdx <= n; ++colIdx) {
                    jdbcType = pkMetaData.getColumnType(colIdx);
                    params[colIdx + numUpdatedCols - 1] = SectDBSynchronizer.getColumnAsString(pkResultSet, colIdx, jdbcType);
                    paramTypes[colIdx + numUpdatedCols - 1] = jdbcType;
                }
                break;
            }
            case AFTER_DELETE: {
                int colIdx;
                int jdbcType;
                ResultSet pkResultSet = event.getPrimaryKeysAsResultSet();
                ResultSetMetaData pkMetaData = pkResultSet.getMetaData();
                dmlString = AsyncEventHelper.getDeleteString((String)tableName, (ResultSetMetaData)pkMetaData);
                int numColumns = pkMetaData.getColumnCount();
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                for (colIdx = 1; colIdx <= numColumns; ++colIdx) {
                    jdbcType = pkMetaData.getColumnType(colIdx);
                    params[colIdx - 1] = SectDBSynchronizer.getColumnAsString(pkResultSet, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                break;
            }
            case BULK_DML: {
                int colIdx;
                int jdbcType;
                ResultSet rows;
                int numColumns;
                Object metadata;
                dmlString = event.getDMLString();
                paramsBatch = null;
                paramTypes = null;
                if (!event.hasParameters() || (rows = event.getNewRowsAsResultSet()) == null || (numColumns = (metadata = rows.getMetaData()).getColumnCount()) <= 0) break;
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                for (colIdx = 1; colIdx <= numColumns; ++colIdx) {
                    jdbcType = metadata.getColumnType(colIdx);
                    params[colIdx - 1] = SectDBSynchronizer.getColumnAsString(rows, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                break;
            }
            case BULK_INSERT: {
                int jdbcType;
                String[] params;
                dmlString = event.getDMLString();
                ResultSet rows = event.getNewRowsAsResultSet();
                Object metadata = rows.getMetaData();
                int numColumns = metadata.getColumnCount();
                paramsBatch = new ArrayList();
                paramTypes = new int[numColumns];
                boolean firstIter = true;
                while (rows.next()) {
                    params = new String[numColumns];
                    paramsBatch.add(params);
                    for (int colIdx = 1; colIdx <= numColumns; ++colIdx) {
                        if (firstIter) {
                            paramTypes[colIdx - 1] = jdbcType = metadata.getColumnType(colIdx);
                        } else {
                            jdbcType = paramTypes[colIdx - 1];
                        }
                        params[colIdx - 1] = SectDBSynchronizer.getColumnAsString(rows, colIdx, jdbcType);
                    }
                    firstIter = false;
                }
                break;
            }
            default: {
                dmlString = event.toString();
                paramsBatch = null;
                paramTypes = null;
            }
        }
        this.indentInErrorXML(indent);
        this.errorWriter.writeStartElement(ERR_XML_SQL);
        this.errorWriter.writeCharacters(dmlString);
        this.errorWriter.writeEndElement();
        if (paramsBatch != null) {
            for (String[] stringArray : paramsBatch) {
                this.indentInErrorXML(indent);
                this.errorWriter.writeStartElement(ERR_XML_PARAMS);
                indent += 2;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.indentInErrorXML(indent);
                    this.errorWriter.writeStartElement(ERR_XML_PARAM);
                    this.errorWriter.writeAttribute(ERR_XML_ATTR_TYPE, Integer.toString(paramTypes[i]));
                    if (stringArray[i] != null) {
                        this.errorWriter.writeCharacters(stringArray[i]);
                    } else {
                        this.errorWriter.writeAttribute(ERR_XML_ATTR_NULL, "true");
                    }
                    this.errorWriter.writeEndElement();
                }
                this.indentInErrorXML(indent -= 2);
                this.errorWriter.writeEndElement();
            }
        }
        this.writeExceptionInErrorXML(sqle, indent, 2, true);
        this.errorWriter.writeCharacters("\n");
        this.errorWriter.writeEndElement();
        this.errorWriter.writeCharacters("\n");
        this.errorWriter.flush();
        this.errorStream.flush();
    }

    public static final String getColumnAsString(ResultSet rs, int columnIndex, int jdbcType) throws SQLException {
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                byte[] bytes = rs.getBytes(columnIndex);
                if (bytes != null) {
                    return SectDBSynchronizer.toHexString(bytes, 0, bytes.length);
                }
                return null;
            }
            case 2000: {
                Object v = rs.getObject(columnIndex);
                if (v != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    try {
                        DataSerializer.writeObject((Object)v, (DataOutput)dos);
                        dos.flush();
                    }
                    catch (IOException ioe) {
                        throw new SQLException(ioe.getMessage(), "XJ001", 0, ioe);
                    }
                    byte[] bytes = bos.toByteArray();
                    return SectDBSynchronizer.toHexString(bytes, 0, bytes.length);
                }
                return null;
            }
        }
        return rs.getString(columnIndex);
    }

    public static String toHexString(byte[] data, int offset, int length) {
        char[] chars = new char[length << 1];
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            int high_nibble = (data[i] & 0xF0) >>> 4;
            int low_nibble = data[i] & 0xF;
            int j = i - offset << 1;
            chars[j] = hex_table[high_nibble];
            chars[j + 1] = hex_table[low_nibble];
        }
        return new String(chars);
    }

    protected void indentInErrorXML(int level) throws XMLStreamException {
        this.errorWriter.writeCharacters("\n");
        char[] indent = new char[level];
        for (int idx = 0; idx < level; ++idx) {
            indent[idx] = 32;
        }
        this.errorWriter.writeCharacters(indent, 0, indent.length);
    }

    protected void writeExceptionInErrorXML(SQLException sqle, int indent, int indentStep, boolean printStack) throws XMLStreamException {
        this.indentInErrorXML(indent);
        this.errorWriter.writeStartElement(ERR_XML_EXCEPTION);
        this.writeObjectInErrorXML(ERR_XML_SQLSTATE, sqle.getSQLState(), indent += indentStep);
        this.writeObjectInErrorXML(ERR_XML_ERRCODE, sqle.getErrorCode(), indent);
        this.writeObjectInErrorXML(ERR_XML_EX_MESSAGE, sqle.getMessage(), indent);
        if (printStack) {
            StringBuilder sb = new StringBuilder();
            this.helper.getStackTrace((Throwable)sqle, sb);
            this.writeObjectInErrorXML(ERR_XML_EX_STACK, sb.toString(), indent);
        } else {
            this.writeObjectInErrorXML(ERR_XML_EX_STACK, sqle.toString(), indent);
        }
        sqle = sqle.getNextException();
        if (sqle != null) {
            this.writeExceptionInErrorXML(sqle, indent, indentStep, false);
        }
        this.indentInErrorXML(indent -= indentStep);
        this.errorWriter.writeEndElement();
    }

    protected void writeObjectInErrorXML(String tag, Object o, int indent) throws XMLStreamException {
        this.indentInErrorXML(indent);
        if (o != null) {
            this.errorWriter.writeStartElement(tag);
            this.errorWriter.writeCharacters(o.toString());
            this.errorWriter.writeEndElement();
        } else {
            this.errorWriter.writeEmptyElement(tag);
        }
    }
}

