/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis.decode.cp;

import codeAnalysis.decode.cp.Cp;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class CpUtf8
extends Cp {
    private StringBuffer value;
    private String stringValue;
    private Vector classes;

    CpUtf8(DataInputStream source) throws IOException {
        int len = source.readUnsignedShort();
        this.value = new StringBuffer();
        for (int idx = 0; idx < len; ++idx) {
            this.value.append((char)source.readByte());
        }
    }

    public String stringValue() {
        if (this.stringValue == null) {
            this.stringValue = this.value.toString();
        }
        return this.stringValue;
    }

    public int argCount() {
        if (this.classes == null) {
            this.decodeClassName(0);
        }
        return this.classes.size() - 1;
    }

    public String decodeClassName(int argNo) {
        if (this.classes == null) {
            this.classes = new Vector();
            int idx = 0;
            while (idx >= 0) {
                idx = this.decodeNextClassName(idx);
            }
        }
        if (argNo == 0) {
            return (String)this.classes.elementAt(this.classes.size() - 1);
        }
        return (String)this.classes.elementAt(argNo - 1);
    }

    private int decodeNextClassName(int startIdx) {
        StringBuffer str;
        StringBuffer arraySpec = new StringBuffer();
        int idx = startIdx;
        int len = this.value.length();
        if (idx >= len) {
            return -1;
        }
        while (this.value.charAt(idx) == ')' || this.value.charAt(idx) == '(') {
            ++idx;
        }
        arraySpec = new StringBuffer();
        while (this.value.charAt(idx) == '[') {
            ++idx;
            arraySpec.append("[]");
        }
        switch (this.value.charAt(idx)) {
            case 'B': {
                str = new StringBuffer("byte");
                break;
            }
            case 'C': {
                str = new StringBuffer("char");
                break;
            }
            case 'D': {
                str = new StringBuffer("double");
                break;
            }
            case 'F': {
                str = new StringBuffer("float");
                break;
            }
            case 'I': {
                str = new StringBuffer("int");
                break;
            }
            case 'J': {
                str = new StringBuffer("long");
                break;
            }
            case 'L': {
                ++idx;
                str = new StringBuffer();
                while (this.value.charAt(idx) != ';') {
                    str.append(this.value.charAt(idx));
                    ++idx;
                }
                break;
            }
            case 'S': {
                str = new StringBuffer("short");
                break;
            }
            case 'Z': {
                str = new StringBuffer("boolean");
                break;
            }
            case 'V': {
                str = new StringBuffer("void");
                break;
            }
            default: {
                throw new Error("Unknown type specifier in descriptor: " + this.value.charAt(idx));
            }
        }
        str.append(arraySpec);
        this.classes.addElement(str.toString());
        return idx + 1;
    }
}

