/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis.decode.cp;

import codeAnalysis.decode.cp.CpClass;
import codeAnalysis.decode.cp.CpDouble;
import codeAnalysis.decode.cp.CpFieldref;
import codeAnalysis.decode.cp.CpFloat;
import codeAnalysis.decode.cp.CpInteger;
import codeAnalysis.decode.cp.CpInterfaceMethodref;
import codeAnalysis.decode.cp.CpLong;
import codeAnalysis.decode.cp.CpMethodref;
import codeAnalysis.decode.cp.CpNameAndType;
import codeAnalysis.decode.cp.CpString;
import codeAnalysis.decode.cp.CpUtf8;
import java.io.DataInputStream;
import java.io.IOException;

public class Cp {
    protected static final int TAG_Class = 7;
    protected static final int TAG_Fieldref = 9;
    protected static final int TAG_Methodref = 10;
    protected static final int TAG_InterfaceMethodref = 11;
    protected static final int TAG_String = 8;
    protected static final int TAG_Integer = 3;
    protected static final int TAG_Float = 4;
    protected static final int TAG_Long = 5;
    protected static final int TAG_Double = 6;
    protected static final int TAG_NameAndType = 12;
    protected static final int TAG_Utf8 = 1;

    public static Cp readCp(DataInputStream source) throws IOException {
        byte tag = (byte)source.readUnsignedByte();
        switch (tag) {
            case 7: {
                return new CpClass(source);
            }
            case 9: {
                return new CpFieldref(source);
            }
            case 10: {
                return new CpMethodref(source);
            }
            case 11: {
                return new CpInterfaceMethodref(source);
            }
            case 8: {
                return new CpString(source);
            }
            case 3: {
                return new CpInteger(source);
            }
            case 4: {
                return new CpFloat(source);
            }
            case 5: {
                return new CpLong(source);
            }
            case 6: {
                return new CpDouble(source);
            }
            case 12: {
                return new CpNameAndType(source);
            }
            case 1: {
                return new CpUtf8(source);
            }
        }
        throw new Error("Unknown tag type in constant pool: " + tag);
    }
}

