/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis.decode;

import codeAnalysis.decode.CompiledAttribute;
import codeAnalysis.decode.CompiledClass;
import codeAnalysis.decode.CompiledCode;
import codeAnalysis.decode.cp.CpUtf8;
import java.io.DataInputStream;
import java.io.IOException;

public class CompiledMethod
implements Comparable {
    int access_flags;
    int name_index;
    int descriptor_index;
    int attributes_count;
    CompiledAttribute[] attributes;
    String name;
    String descriptor;
    String accessString;
    String signature;
    String args;
    CompiledClass myclass;

    CompiledMethod(DataInputStream source, CompiledClass clazz) throws IOException {
        this.myclass = clazz;
        this.access_flags = source.readUnsignedShort();
        this.name_index = source.readUnsignedShort();
        this.descriptor_index = source.readUnsignedShort();
        this.attributes_count = source.readUnsignedShort();
        this.attributes = new CompiledAttribute[this.attributes_count];
        for (int idx = 0; idx < this.attributes_count; ++idx) {
            this.attributes[idx] = new CompiledAttribute(source);
        }
    }

    public String accessString() {
        if (this.accessString != null) {
            return this.accessString;
        }
        StringBuffer result = new StringBuffer();
        if ((this.access_flags & 1) != 0) {
            result.append("public ");
        }
        if ((this.access_flags & 2) != 0) {
            result.append("private ");
        }
        if ((this.access_flags & 4) != 0) {
            result.append("protected ");
        }
        if ((this.access_flags & 8) != 0) {
            result.append("static ");
        }
        if ((this.access_flags & 0x10) != 0) {
            result.append("final ");
        }
        if ((this.access_flags & 0x20) != 0) {
            result.append("synchronized ");
        }
        if ((this.access_flags & 0x100) != 0) {
            result.append("native ");
        }
        if ((this.access_flags & 0x400) != 0) {
            result.append("abstract ");
        }
        this.accessString = result.toString();
        return this.accessString;
    }

    public boolean isAbstract() {
        return (this.access_flags & 0x400) != 0;
    }

    public String descriptor() {
        if (this.descriptor == null) {
            this.descriptor = ((CpUtf8)this.myclass.constant_pool[this.descriptor_index]).decodeClassName(0);
        }
        return this.descriptor;
    }

    public String name() {
        if (this.name == null) {
            this.name = ((CpUtf8)this.myclass.constant_pool[this.name_index]).stringValue();
        }
        return this.name;
    }

    public String args() {
        if (this.args == null) {
            int argCount = ((CpUtf8)this.myclass.constant_pool[this.descriptor_index]).argCount();
            for (int idx = 1; idx <= argCount; ++idx) {
                String str = ((CpUtf8)this.myclass.constant_pool[this.descriptor_index]).decodeClassName(idx);
                this.args = this.args == null ? str : this.args + ", " + str;
            }
        }
        if (this.args == null) {
            this.args = "";
        }
        return this.args;
    }

    public String signature() {
        if (this.signature == null) {
            this.signature = this.accessString() + this.descriptor() + " " + this.name() + "( " + this.args() + " );";
        }
        return this.signature;
    }

    public CompiledCode getCode() {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].name(this.myclass).equals("Code")) continue;
            try {
                return new CompiledCode(this.attributes[i].info);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        CompiledMethod otherMethod = (CompiledMethod)other;
        return this.signature().compareTo(otherMethod.signature());
    }
}

