/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis.decode;

import codeAnalysis.decode.CompiledAttribute;
import codeAnalysis.decode.CompiledClass;
import codeAnalysis.decode.cp.CpUtf8;
import java.io.DataInputStream;
import java.io.IOException;

public class CompiledField
implements Comparable {
    int access_flags;
    int name_index;
    int descriptor_index;
    int attributes_count;
    CompiledAttribute[] attributes;
    String name;
    String descriptor;
    String accessString;
    String signature;
    CompiledClass myclass;

    CompiledField(DataInputStream source, CompiledClass myclass) throws IOException {
        this.myclass = myclass;
        this.access_flags = source.readUnsignedShort();
        this.name_index = source.readUnsignedShort();
        this.descriptor_index = source.readUnsignedShort();
        this.attributes_count = source.readUnsignedShort();
        this.attributes = new CompiledAttribute[this.attributes_count];
        for (int idx = 0; idx < this.attributes_count; ++idx) {
            this.attributes[idx] = new CompiledAttribute(source);
        }
    }

    public String accessString() {
        if (this.accessString != null) {
            return this.accessString;
        }
        StringBuffer result = new StringBuffer();
        if ((this.access_flags & 1) != 0) {
            result.append("public ");
        }
        if ((this.access_flags & 2) != 0) {
            result.append("private ");
        }
        if ((this.access_flags & 4) != 0) {
            result.append("protected ");
        }
        if ((this.access_flags & 8) != 0) {
            result.append("static ");
        }
        if ((this.access_flags & 0x10) != 0) {
            result.append("final ");
        }
        if ((this.access_flags & 0x40) != 0) {
            result.append("volatile ");
        }
        if ((this.access_flags & 0x80) != 0) {
            result.append("transient ");
        }
        this.accessString = result.toString();
        return this.accessString;
    }

    public boolean isStatic() {
        return (this.access_flags & 8) != 0;
    }

    public boolean isTransient() {
        return (this.access_flags & 0x80) != 0;
    }

    public String descriptor() {
        if (this.descriptor == null) {
            this.descriptor = ((CpUtf8)this.myclass.constant_pool[this.descriptor_index]).decodeClassName(0);
        }
        return this.descriptor;
    }

    public String name() {
        if (this.name == null) {
            this.name = ((CpUtf8)this.myclass.constant_pool[this.name_index]).stringValue();
        }
        return this.name;
    }

    public String signature() {
        if (this.signature == null) {
            this.signature = this.accessString() + this.descriptor() + " " + this.name() + ";";
        }
        return this.signature;
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        CompiledField otherField = (CompiledField)other;
        return this.name().compareTo(otherField.name);
    }
}

