/*
 * Decompiled with CFR 0.152.
 */
package codeAnalysis.decode;

import codeAnalysis.decode.CompiledAttribute;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CompiledCode {
    public int max_stack;
    public int max_locals;
    public int code_length;
    public byte[] code;
    public int exception_table_length;
    ExceptionTableEntry[] exceptionTable;
    public int attributes_count;
    public CompiledAttribute[] attributes_info;

    CompiledCode(byte[] code_block) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(code_block);
        DataInputStream source = new DataInputStream(bis);
        this.max_stack = source.readUnsignedShort();
        this.max_locals = source.readUnsignedShort();
        this.code_length = source.readInt();
        this.code = new byte[this.code_length];
        source.read(this.code);
        this.exception_table_length = source.readUnsignedShort();
        this.exceptionTable = new ExceptionTableEntry[this.exception_table_length];
        for (int i = 0; i < this.exception_table_length; ++i) {
            this.exceptionTable[i] = new ExceptionTableEntry(source);
        }
        this.attributes_count = source.readUnsignedShort();
        this.attributes_info = new CompiledAttribute[this.attributes_count];
        for (int idx = 0; idx < this.attributes_count; ++idx) {
            this.attributes_info[idx] = new CompiledAttribute(source);
        }
    }

    public static class ExceptionTableEntry {
        public int start_pc;
        public int end_pc;
        public int handler_pc;
        public int catch_type;

        ExceptionTableEntry(DataInputStream source) throws IOException {
            this.start_pc = source.readUnsignedShort();
            this.end_pc = source.readUnsignedShort();
            this.handler_pc = source.readUnsignedShort();
            this.catch_type = source.readUnsignedShort();
        }
    }
}

